/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.io.formats.mango;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.ViewerController;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewersurface.SurfaceManager;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.operations.io.ShapeData;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceData;
import edu.uthscsa.ric.mango.viewersurface.screen.SurfaceOverlay;
import edu.uthscsa.ric.mango.viewersurface.utilities.SurfaceUtils;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.visualization.surface.SurfaceController;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.visualization.surface.primitives.Overlay;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.vecmath.Point3d;

public class MangoFormat
implements SurfaceFormat,
Cloneable,
ActionListener {
    public static final String TEXT_FORMAT_NOT_RECOGNIZED = "Format not recognized.";
    public static final String ERROR_MESSAGE_IMPORT = "Error importing file!  See console for more details.";
    public static final String ERROR_MESSAGE_FORMAT_NOT_RECOGNIZED = "This format is not recognized!";
    public static final String ERROR_MESSAGE_EXPORT = "Error exporting file!  See console for more details.";
    public static final String ERROR_TITLE_FILE = "File Error";
    private JCheckBox allLinesAndPointsBox;
    private JCheckBox allVolsBox;
    private JComboBox<Surface> volBox;
    private JLabel volBoxLabel;
    private JTextField nameText;
    private static boolean littleEndian = ByteOrder.nativeOrder().toString().equals(ByteOrder.LITTLE_ENDIAN.toString());
    private static final byte[] MAGIC_NUMBER_BIG = new byte[]{109, 97, 110, 103, 111, 98, 49, 48};
    private static final byte[] MAGIC_NUMBER_BIG_1_1 = new byte[]{109, 97, 110, 103, 111, 98, 49, 49};
    private static final byte[] MAGIC_NUMBER_BIG_1_2 = new byte[]{109, 97, 110, 103, 111, 98, 49, 50};
    private static final byte[] MAGIC_NUMBER_BIG_1_3 = new byte[]{109, 97, 110, 103, 111, 98, 49, 51};
    private static final byte[] MAGIC_NUMBER_BIG_1_4 = new byte[]{109, 97, 110, 103, 111, 98, 49, 52};
    private static final byte[] MAGIC_NUMBER_BIG_1_5 = new byte[]{109, 97, 110, 103, 111, 98, 49, 53};
    private static final byte[] MAGIC_NUMBER_LITTLE = new byte[]{109, 97, 110, 103, 111, 108, 49, 48};
    private static final byte[] MAGIC_NUMBER_LITTLE_1_1 = new byte[]{109, 97, 110, 103, 111, 108, 49, 49};
    private static final byte[] MAGIC_NUMBER_LITTLE_1_2 = new byte[]{109, 97, 110, 103, 111, 108, 49, 50};
    private static final byte[] MAGIC_NUMBER_LITTLE_1_3 = new byte[]{109, 97, 110, 103, 111, 108, 49, 51};
    private static final byte[] MAGIC_NUMBER_LITTLE_1_4 = new byte[]{109, 97, 110, 103, 111, 108, 49, 52};
    private static final byte[] MAGIC_NUMBER_LITTLE_1_5 = new byte[]{109, 97, 110, 103, 111, 108, 49, 53};
    private static final byte[] SHAPE_MAGIC_NUMBER = new byte[]{-1, 0, 0, 0, 115, 104, 97, 112};
    private static final byte[] SHAPE_MAGIC_NUMBER_WITH_SURFACE_FLAG = new byte[]{-2, 0, 0, 0, 115, 104, 97, 112};
    private static final byte[] SURFACE_OVERLAY_MAGIC_NUMBER = new byte[]{0, 0, 0, 0, 115, 99, 97, 108};
    public static final String BASE_SURFACE_NAME = "BASESURFACE";
    public static final String EXTENSION = ".surf";
    public static final String FORMAT_NAME = "Mango Surface";
    public static final int MANGO_FORMAT_HEADER_SIZE = 76;
    public static final int MANGO_FORMAT_HEADER_SIZE_1_1 = 268;
    public static final int MANGO_FORMAT_HEADER_SIZE_1_2 = 304;
    public static final int MANGO_FORMAT_HEADER_SIZE_1_3 = 180;
    public static final int MANGO_FORMAT_HEADER_SIZE_1_4 = 184;
    public static final int MANGO_FORMAT_HEADER_SIZE_1_5 = 184;
    public static final int NAME_BUFFER_SIZE = 64;

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.volBox.setEnabled(!this.allVolsBox.isSelected());
        this.volBoxLabel.setEnabled(!this.allVolsBox.isSelected());
        this.allLinesAndPointsBox.setEnabled(!this.allVolsBox.isSelected());
    }

    public Object clone() {
        Object ob = null;
        try {
            ob = super.clone();
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return ob;
    }

    public String getMinimumVersionSupported() {
        return null;
    }

    public boolean isIncludeLinesAndPoints() {
        return this.allLinesAndPointsBox != null ? this.allLinesAndPointsBox.isSelected() : true;
    }

    @Deprecated
    public JPanel getOptionsPanel(Surface[] data, Shape[] shapes, SurfaceController controller) {
        return this.getOptionsPanel(data, shapes, (VolumeManager)controller.getViewerController());
    }

    public JPanel getOptionsPanel(Surface[] data, Shape[] shapes, VolumeManager controller) {
        JLabel nameLabel = new JLabel("Name:");
        this.nameText = new JTextField(data[0].getName());
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        namePanel.add(Box.createHorizontalStrut(4));
        namePanel.add(nameLabel);
        namePanel.add(this.nameText);
        namePanel.add(Box.createHorizontalStrut(4));
        this.allVolsBox = new JCheckBox("Include surface and all shapes");
        this.allVolsBox.setSelected(true);
        this.allVolsBox.addActionListener(this);
        JPanel allVolsPanel = new JPanel();
        allVolsPanel.setLayout(new BoxLayout(allVolsPanel, 0));
        allVolsPanel.add(Box.createHorizontalStrut(4));
        allVolsPanel.add(this.allVolsBox);
        allVolsPanel.add(Box.createHorizontalStrut(4));
        this.allLinesAndPointsBox = new JCheckBox("Include lines and points");
        this.allLinesAndPointsBox.setSelected(true);
        this.allLinesAndPointsBox.setEnabled(false);
        this.allLinesAndPointsBox.addActionListener(this);
        JPanel allLinesAndPointsPanel = new JPanel();
        allLinesAndPointsPanel.setLayout(new BoxLayout(allLinesAndPointsPanel, 0));
        allLinesAndPointsPanel.add(Box.createHorizontalStrut(4));
        allLinesAndPointsPanel.add(this.allLinesAndPointsBox);
        allLinesAndPointsPanel.add(Box.createHorizontalStrut(4));
        this.volBox = new JComboBox<Surface>(data);
        this.volBox.setEnabled(false);
        this.volBoxLabel = new JLabel("Select:");
        this.volBoxLabel.setEnabled(false);
        JPanel volPanel = new JPanel();
        volPanel.setLayout(new BoxLayout(volPanel, 0));
        volPanel.add(Box.createHorizontalStrut(4));
        volPanel.add(this.volBoxLabel);
        volPanel.add(this.volBox);
        volPanel.add(Box.createHorizontalStrut(4));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(namePanel);
        mainPanel.add(allVolsPanel);
        mainPanel.add(allLinesAndPointsPanel);
        mainPanel.add(volPanel);
        return mainPanel;
    }

    public String getPluginName() {
        return FORMAT_NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return EXTENSION;
    }

    public String getSelectedName() {
        return this.nameText.getText();
    }

    public String getVersion() {
        return null;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    public boolean isSelectedImage() {
        return !this.allVolsBox.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            byte[] magicNum = new byte[MAGIC_NUMBER_BIG.length];
            int bytesRead = input.read(magicNum);
            if (bytesRead > 0) {
                String magicNumStr = new String(magicNum, 0, MAGIC_NUMBER_BIG.length);
                boolean is10 = magicNumStr.equals(new String(MAGIC_NUMBER_LITTLE)) || magicNumStr.equals(new String(MAGIC_NUMBER_BIG));
                boolean is11 = magicNumStr.equals(new String(MAGIC_NUMBER_LITTLE_1_1)) || magicNumStr.equals(new String(MAGIC_NUMBER_BIG_1_1));
                boolean is12 = magicNumStr.equals(new String(MAGIC_NUMBER_LITTLE_1_2)) || magicNumStr.equals(new String(MAGIC_NUMBER_BIG_1_2));
                boolean is13 = magicNumStr.equals(new String(MAGIC_NUMBER_LITTLE_1_3)) || magicNumStr.equals(new String(MAGIC_NUMBER_BIG_1_3));
                boolean is14 = magicNumStr.equals(new String(MAGIC_NUMBER_LITTLE_1_4)) || magicNumStr.equals(new String(MAGIC_NUMBER_BIG_1_4));
                boolean is15 = magicNumStr.equals(new String(MAGIC_NUMBER_LITTLE_1_5)) || magicNumStr.equals(new String(MAGIC_NUMBER_BIG_1_5));
                boolean bl = is10 || is11 || is12 || is13 || is14 || is15;
                return bl;
            }
        }
        catch (FileNotFoundException ex) {
            if (AppLogger.isDebugEnabled()) {
                AppLogger.debug((String)ex.getMessage());
            }
        }
        catch (IOException ex) {
            if (AppLogger.isDebugEnabled()) {
                AppLogger.debug((String)ex.getMessage());
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return false;
    }

    @Deprecated
    public Surface[] readSurfaceFile(File file, ViewerController controller, Vector<Shape> shapes, boolean baseSurface) {
        return this.readSurfaceFile(file, (VolumeManager)controller, shapes, baseSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface[] readSurfaceFile(File file, VolumeManager controller, Vector<Shape> shapes, boolean baseSurface) {
        FileInputStream input = null;
        Surface[] data = null;
        try {
            boolean is11;
            input = new FileInputStream(file);
            byte[] buffer = new byte[MAGIC_NUMBER_LITTLE.length];
            FileUtilities.readFully((InputStream)input, (byte[])buffer);
            String readString = new String(buffer);
            String little11 = new String(MAGIC_NUMBER_LITTLE_1_1);
            String big11 = new String(MAGIC_NUMBER_BIG_1_1);
            String little12 = new String(MAGIC_NUMBER_LITTLE_1_2);
            String big12 = new String(MAGIC_NUMBER_BIG_1_2);
            String little13 = new String(MAGIC_NUMBER_LITTLE_1_3);
            String big13 = new String(MAGIC_NUMBER_BIG_1_3);
            String little14 = new String(MAGIC_NUMBER_LITTLE_1_4);
            String big14 = new String(MAGIC_NUMBER_BIG_1_4);
            String little15 = new String(MAGIC_NUMBER_LITTLE_1_5);
            String big15 = new String(MAGIC_NUMBER_BIG_1_5);
            input.close();
            boolean is15 = readString.equals(little15) || readString.equals(big15);
            boolean is14 = readString.equals(little14) || readString.equals(big14);
            boolean is13 = readString.equals(little13) || readString.equals(big13);
            boolean is12 = readString.equals(little12) || readString.equals(big12);
            boolean bl = is11 = readString.equals(little11) || readString.equals(big11);
            if (is15) {
                data = this.readMangoFormat14And15(file, shapes, controller, baseSurface, false, 1.0f, true);
                data[0].setDescription("Mango surface file format v1.5");
            } else if (is14) {
                data = this.readMangoFormat14And15(file, shapes, controller, baseSurface, false, -1.0f, false);
                data[0].setDescription("Mango surface file format v1.4");
            } else if (is13) {
                data = this.readMangoFormat13(file, shapes, controller, baseSurface, false);
                data[0].setDescription("Mango surface file format v1.3");
            } else if (is11 || is12) {
                data = this.readMangoFormat1plus(file, is12, shapes, controller, baseSurface, false);
                if (is12) {
                    data[0].setDescription("Mango surface file format v1.2");
                } else {
                    data[0].setDescription("Mango surface file format v1.1");
                }
            } else {
                data = this.readMangoFormat10(file, false);
                data[0].setDescription("Mango surface file format v1.0");
            }
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface[] readSurfaceHeader(File file, Vector<Shape> shapes) throws SurfaceFormatException {
        FileInputStream input = null;
        Surface[] data = null;
        try {
            boolean is11;
            input = new FileInputStream(file);
            byte[] buffer = new byte[MAGIC_NUMBER_LITTLE.length];
            FileUtilities.readFully((InputStream)input, (byte[])buffer);
            String readString = new String(buffer);
            String little11 = new String(MAGIC_NUMBER_LITTLE_1_1);
            String big11 = new String(MAGIC_NUMBER_BIG_1_1);
            String little12 = new String(MAGIC_NUMBER_LITTLE_1_2);
            String big12 = new String(MAGIC_NUMBER_BIG_1_2);
            String little13 = new String(MAGIC_NUMBER_LITTLE_1_3);
            String big13 = new String(MAGIC_NUMBER_BIG_1_3);
            String little14 = new String(MAGIC_NUMBER_LITTLE_1_4);
            String big14 = new String(MAGIC_NUMBER_BIG_1_4);
            String little15 = new String(MAGIC_NUMBER_LITTLE_1_5);
            String big15 = new String(MAGIC_NUMBER_BIG_1_5);
            input.close();
            boolean is15 = readString.equals(little15) || readString.equals(big15);
            boolean is14 = readString.equals(little14) || readString.equals(big14);
            boolean is13 = readString.equals(little13) || readString.equals(big13);
            boolean is12 = readString.equals(little12) || readString.equals(big12);
            boolean bl = is11 = readString.equals(little11) || readString.equals(big11);
            if (is15) {
                data = this.readMangoFormat14And15(file, shapes, null, true, true, 1.0f, true);
                data[0].setDescription("Mango surface file format v1.5");
            } else if (is14) {
                data = this.readMangoFormat14And15(file, shapes, null, true, true, -1.0f, false);
                data[0].setDescription("Mango surface file format v1.4");
            } else if (is13) {
                data = this.readMangoFormat13(file, shapes, null, true, true);
                data[0].setDescription("Mango surface file format v1.3");
            } else if (is11 || is12) {
                data = this.readMangoFormat1plus(file, is12, shapes, null, true, true);
                if (is12) {
                    data[0].setDescription("Mango surface file format v1.2");
                } else {
                    data[0].setDescription("Mango surface file format v1.1");
                }
            } else {
                data = this.readMangoFormat10(file, true);
                data[0].setDescription("Mango surface file format v1.0");
            }
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return data;
    }

    @Deprecated
    public void writeSurfaceFile(File file, Surface[] surfacesVal, Shape[] shapesVal, SurfaceController controller) {
        this.writeSurfaceFile(file, surfacesVal, shapesVal, (VolumeManager)controller.getViewerController());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSurfaceFile(File file, Surface[] surfacesVal, Shape[] shapesVal, VolumeManager controller) {
        Surface[] surfaces = surfacesVal;
        Shape[] shapes = shapesVal;
        ImageDimensions id = controller.getBaseVolume().getImageDimensions();
        VoxelDimensions vd = controller.getBaseVolume().getVoxelDimensions();
        Coordinate origin = controller.getBaseVolume().getOrigin();
        double[] xform = controller.getSurfaceManager().getViewTransform();
        if (this.allVolsBox != null && !this.allVolsBox.isSelected()) {
            surfaces = new Surface[]{(Surface)this.volBox.getSelectedItem()};
            if (!this.allLinesAndPointsBox.isSelected()) {
                shapes = null;
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            SurfaceManager surfaceManager = controller.getSurfaceManager();
            if (surfaceManager instanceof SurfaceViewer) {
                ImageIO.write((RenderedImage)((SurfaceViewer)surfaceManager).captureImage(surfaces.length > 1 ? null : surfaces[0], shapes != null), "jpg", outputStream);
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        byte[] imageBytes = outputStream.toByteArray();
        byte[] header = new byte[184];
        ByteBuffer byteBuffer = ByteBuffer.wrap(header);
        if (littleEndian) {
            byteBuffer.put(MAGIC_NUMBER_LITTLE_1_5);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.put(MAGIC_NUMBER_BIG_1_5);
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        byteBuffer.putInt(imageBytes.length);
        byteBuffer.putInt(surfaces.length);
        for (int ctr = 0; ctr < 16; ++ctr) {
            byteBuffer.putDouble(xform[ctr]);
        }
        byteBuffer.putInt(id.getX());
        byteBuffer.putInt(id.getY());
        byteBuffer.putInt(id.getZ());
        byteBuffer.putFloat((float)vd.getXSize());
        byteBuffer.putFloat((float)vd.getYSize());
        byteBuffer.putFloat((float)vd.getZSize());
        byteBuffer.putFloat((float)origin.xDbl);
        byteBuffer.putFloat((float)origin.yDbl);
        byteBuffer.putFloat((float)origin.zDbl);
        byteBuffer.putFloat(controller.getSurfaceManager().getThreshold());
        int numPointsAll = 0;
        for (Surface surface : surfaces) {
            CompositeSurface cs = (CompositeSurface)surface;
            int numParts = cs.getNumParts();
            numPointsAll += surface.getNumPoints() * 3;
            numPointsAll += numParts * 4;
        }
        int pointsSizeTotal = numPointsAll * 4 + surfaces.length * 4;
        int numNormalsAll = 0;
        for (Surface surface : surfaces) {
            CompositeSurface cs = (CompositeSurface)surface;
            int numParts = cs.getNumParts();
            numNormalsAll += surface.getNumPoints() * 3;
            numNormalsAll += numParts * 4;
        }
        int normalsSizeTotal = numNormalsAll * 4 + surfaces.length * 4;
        int numTriangles = 0;
        for (Surface surface : surfaces) {
            CompositeSurface cs = (CompositeSurface)surface;
            int numParts = cs.getNumParts();
            numTriangles += surface.getNumTriangles() * 3;
            numTriangles += numParts * 4;
        }
        int indicesSizeTotal = numTriangles * 4 + surfaces.length * 4;
        int numOverlaysTotal = 0;
        int overlayDataSize = 0;
        for (Surface surface : surfaces) {
            Overlay[] overlays = surface.getOverlays();
            CompositeSurface cs = (CompositeSurface)surface;
            int numParts = cs.getNumParts();
            if (overlays != null) {
                for (Overlay overlay : overlays) {
                    overlayDataSize += overlay.getScalarsSize();
                    ++numOverlaysTotal;
                }
            }
            overlayDataSize += numParts * 4;
        }
        int scalarsSizeTotal = overlayDataSize * 4 + numOverlaysTotal * 2 * 64 + numOverlaysTotal * 5 * 4 + numOverlaysTotal * 8;
        int nameSize = surfaces.length * 64;
        int colorSize = surfaces.length * 12;
        int shapesSize = 0;
        if (shapes != null) {
            for (Overlay overlay : shapes) {
                shapesSize += this.getNumBytes(overlay.getPoints(), overlay.getColor());
            }
        }
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            output = new RandomAccessFile(file, "rw");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer outputBuffer = outputChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 184 + pointsSizeTotal + normalsSizeTotal + indicesSizeTotal + nameSize + colorSize + scalarsSizeTotal + shapesSize + imageBytes.length);
            if (littleEndian) {
                outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                outputBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            outputBuffer.put(header);
            outputBuffer.put(imageBytes);
            for (Surface surface : surfaces) {
                int ctrPoint;
                int ctrPart;
                CompositeSurface cs = (CompositeSurface)surface;
                byte[] nameBuffer = new byte[64];
                String name = surface.getName();
                if (name != null) {
                    byte[] nameBytes = name.getBytes();
                    for (int ctrB = 0; ctrB < nameBytes.length; ++ctrB) {
                        nameBuffer[ctrB] = nameBytes[ctrB];
                    }
                }
                outputBuffer.put(nameBuffer);
                float[] color = surface.getColor();
                if (color != null) {
                    outputBuffer.putFloat(color[0]);
                    outputBuffer.putFloat(color[1]);
                    outputBuffer.putFloat(color[2]);
                } else {
                    outputBuffer.putFloat(1.0f);
                    outputBuffer.putFloat(1.0f);
                    outputBuffer.putFloat(1.0f);
                }
                int numParts = cs.getNumParts();
                outputBuffer.putInt(numParts);
                for (ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                    FloatBuffer points = cs.getPointsBuffer(ctrPart);
                    int numPoints = points.capacity();
                    outputBuffer.putInt(numPoints);
                    for (ctrPoint = 0; ctrPoint < numPoints; ++ctrPoint) {
                        outputBuffer.putFloat(points.get(ctrPoint));
                    }
                }
                outputBuffer.putInt(numParts);
                for (ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                    FloatBuffer normals = cs.getNormalsBuffer(ctrPart);
                    int numNormals = normals.capacity();
                    outputBuffer.putInt(numNormals);
                    for (ctrPoint = 0; ctrPoint < numNormals; ++ctrPoint) {
                        outputBuffer.putFloat(normals.get(ctrPoint));
                    }
                }
                outputBuffer.putInt(numParts);
                for (ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                    IntBuffer indices = cs.getIndicesBuffer(ctrPart);
                    int numIndices = indices.capacity();
                    outputBuffer.putInt(numIndices);
                    for (ctrPoint = 0; ctrPoint < numIndices; ++ctrPoint) {
                        outputBuffer.putInt(indices.get(ctrPoint));
                    }
                }
                Overlay[] overlays = surface.getOverlays();
                if (overlays == null) continue;
                for (Overlay o : overlays) {
                    SurfaceOverlay so = (SurfaceOverlay)o;
                    outputBuffer.put(SURFACE_OVERLAY_MAGIC_NUMBER);
                    outputBuffer.put(StringUtilities.convertToBytes((String)"Overlay", (byte[])new byte[64]));
                    outputBuffer.put(StringUtilities.convertToBytes((String)so.getColorTableName(), (byte[])new byte[64]));
                    outputBuffer.putInt(so.getAlpha());
                    outputBuffer.putFloat(so.getMin());
                    outputBuffer.putFloat(so.getMax());
                    outputBuffer.putFloat(1.0f);
                    numParts = cs.getNumParts();
                    outputBuffer.putInt(numParts);
                    for (int ctrPart2 = 0; ctrPart2 < numParts; ++ctrPart2) {
                        FloatBuffer scalars = so.getScalars(ctrPart2);
                        int numScalars = scalars.capacity();
                        outputBuffer.putInt(numScalars);
                        for (int ctrPoint2 = 0; ctrPoint2 < numScalars; ++ctrPoint2) {
                            outputBuffer.putFloat(scalars.get(ctrPoint2));
                        }
                    }
                }
            }
            if (shapes != null) {
                for (Shape shape : shapes) {
                    Point3d[] points;
                    ShapeData shapeData = (ShapeData)shape;
                    if (shapeData.isOnSurface()) {
                        outputBuffer.put(SHAPE_MAGIC_NUMBER_WITH_SURFACE_FLAG);
                    } else {
                        outputBuffer.put(SHAPE_MAGIC_NUMBER);
                    }
                    outputBuffer.put(StringUtilities.convertToBytes((String)shapeData.getSurfaceName(), (byte[])new byte[64]));
                    outputBuffer.putFloat(shapeData.getColor()[0]);
                    outputBuffer.putFloat(shapeData.getColor()[1]);
                    outputBuffer.putFloat(shapeData.getColor()[2]);
                    outputBuffer.putInt(shapeData.getPoints().length);
                    for (Point3d point : points = shapeData.getPoints()) {
                        outputBuffer.putFloat((float)point.x);
                        outputBuffer.putFloat((float)point.y);
                        outputBuffer.putFloat((float)point.z);
                    }
                }
            }
            outputBuffer.force();
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
            Mango.showErrorDialogStatic(ERROR_MESSAGE_EXPORT, ERROR_TITLE_FILE);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            Mango.showErrorDialogStatic(ERROR_MESSAGE_EXPORT, ERROR_TITLE_FILE);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
            try {
                outputChannel.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    private int getNumBytes(Point3d[] points, float[] colorArray) {
        int totalBytes = 0;
        if (points != null) {
            totalBytes += points.length * 3 * 4;
        }
        if (colorArray != null) {
            totalBytes += 12;
        }
        totalBytes += 8;
        totalBytes += 4;
        return totalBytes += 64;
    }

    private double[] makeWorldTransform(VolumeManager controller, int xDim, int yDim, int zDim, double xSize, double ySize, double zSize, double xOrigin, double yOrigin, double zOrigin) {
        if (controller == null) {
            return null;
        }
        double centerX = (double)xDim * xSize / 2.0;
        double centerY = (double)yDim * ySize / 2.0;
        double centerZ = (double)zDim * zSize / 2.0;
        double originX = xOrigin * xSize;
        double originY = yOrigin * ySize;
        double originZ = zOrigin * zSize;
        double diffX = originX - centerX;
        double diffY = originY - centerY;
        double diffZ = originZ - centerZ;
        ImageDimensions id = controller.getBaseVolume().getImageDimensions();
        VoxelDimensions vd = controller.getBaseVolume().getVoxelDimensions();
        Coordinate baseOrigin = ((Volume)controller.getBaseVolume()).getOriginOriginal();
        double centerBaseX = (double)id.getX() * vd.getXSize() / 2.0;
        double centerBaseY = (double)id.getY() * vd.getYSize() / 2.0;
        double centerBaseZ = (double)id.getZ() * vd.getZSize() / 2.0;
        double originBaseX = baseOrigin.xDbl * vd.getXSize();
        double originBaseY = baseOrigin.yDbl * vd.getYSize();
        double originBaseZ = baseOrigin.zDbl * vd.getZSize();
        double baseDiffX = originBaseX - centerBaseX;
        double baseDiffY = originBaseY - centerBaseY;
        double baseDiffZ = originBaseZ - centerBaseZ;
        double[] worldXform = new double[16];
        worldXform[0] = 1.0;
        worldXform[5] = 1.0;
        worldXform[10] = 1.0;
        worldXform[15] = 1.0;
        worldXform[3] = baseDiffX - diffX;
        worldXform[7] = baseDiffY - diffY;
        worldXform[11] = baseDiffZ - diffZ;
        return worldXform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface[] readMangoFormat10(File file, boolean headerOnly) {
        Surface[] data = null;
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            int ctr;
            output = new RandomAccessFile(file, "r");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer inputBuffer = outputChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            byte[] magicNum = new byte[8];
            inputBuffer.get(magicNum);
            if (new String(magicNum).equals(new String(MAGIC_NUMBER_LITTLE))) {
                littleEndian = true;
            } else if (new String(magicNum).equals(new String(MAGIC_NUMBER_BIG))) {
                littleEndian = false;
            } else {
                Mango.showErrorDialogStatic(ERROR_MESSAGE_FORMAT_NOT_RECOGNIZED, ERROR_TITLE_FILE);
                throw new Exception(TEXT_FORMAT_NOT_RECOGNIZED);
            }
            if (littleEndian) {
                inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                inputBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            int numSurfaces = inputBuffer.getInt();
            data = new Surface[numSurfaces];
            float[] values = new float[16];
            for (ctr = 0; ctr < values.length; ++ctr) {
                values[ctr] = inputBuffer.getFloat();
            }
            for (ctr = 0; ctr < numSurfaces; ++ctr) {
                byte[] nameBytes = new byte[64];
                inputBuffer.get(nameBytes);
                String name = new String(nameBytes);
                name = name.trim();
                float[] color = new float[]{inputBuffer.getFloat(), inputBuffer.getFloat(), inputBuffer.getFloat()};
                if (color[0] == 0.0f && color[0] == color[1] && color[1] == color[2]) {
                    color[2] = 1.0f;
                    color[1] = 1.0f;
                    color[0] = 1.0f;
                }
                int numPoints = inputBuffer.getInt();
                int numPointValues = numPoints * 3;
                ByteBuffer pointsBufferByte = null;
                FloatBuffer pointsBuffer = null;
                if (headerOnly) {
                    inputBuffer.position(inputBuffer.position() + numPointValues * 4);
                } else {
                    pointsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
                    pointsBufferByte.order(ByteOrder.nativeOrder());
                    pointsBuffer = pointsBufferByte.asFloatBuffer();
                    int num = numPointValues / 3;
                    for (int ctrP = 0; ctrP < num; ++ctrP) {
                        pointsBuffer.put(inputBuffer.getFloat() * -1.0f);
                        pointsBuffer.put(inputBuffer.getFloat());
                        pointsBuffer.put(inputBuffer.getFloat() * -1.0f);
                    }
                }
                int numNormals = inputBuffer.getInt();
                int numNormalValues = numNormals * 3;
                ByteBuffer normalsBufferByte = null;
                FloatBuffer normalsBuffer = null;
                if (headerOnly) {
                    inputBuffer.position(inputBuffer.position() + numNormalValues * 4);
                } else {
                    normalsBufferByte = ByteBuffer.allocateDirect(numNormalValues * 4);
                    normalsBufferByte.order(ByteOrder.nativeOrder());
                    normalsBuffer = normalsBufferByte.asFloatBuffer();
                    int num = numNormalValues / 3;
                    for (int ctrN = 0; ctrN < num; ++ctrN) {
                        normalsBuffer.put(inputBuffer.getFloat() * -1.0f);
                        normalsBuffer.put(inputBuffer.getFloat());
                        normalsBuffer.put(inputBuffer.getFloat() * -1.0f);
                    }
                }
                int stripCountNum = inputBuffer.getInt();
                IntBuffer indicesBuffer = null;
                if (headerOnly) {
                    inputBuffer.position(inputBuffer.position() + stripCountNum * 4);
                } else if (stripCountNum > 0) {
                    int[] strips = new int[stripCountNum];
                    for (int ctrI = 0; ctrI < strips.length; ++ctrI) {
                        strips[ctrI] = inputBuffer.getInt();
                    }
                    indicesBuffer = SurfaceUtils.convertStripCountsToIndices(strips);
                }
                if (headerOnly) {
                    data[ctr] = new SurfaceData(name, "", null);
                    ((SurfaceData)data[ctr]).setNumPoints(numPoints);
                } else {
                    data[ctr] = new CompositeSurface(pointsBuffer, normalsBuffer, indicesBuffer, name, color);
                }
                boolean hasOverlays = true;
                while (!headerOnly && hasOverlays) {
                    if (inputBuffer.position() < inputBuffer.capacity()) {
                        byte[] overlayMagicNumber = new byte[SURFACE_OVERLAY_MAGIC_NUMBER.length];
                        inputBuffer.get(overlayMagicNumber);
                        for (int ctrM = 0; ctrM < SURFACE_OVERLAY_MAGIC_NUMBER.length; ++ctrM) {
                            if (overlayMagicNumber[ctrM] == SURFACE_OVERLAY_MAGIC_NUMBER[ctrM]) continue;
                            inputBuffer.position(inputBuffer.position() - SURFACE_OVERLAY_MAGIC_NUMBER.length);
                            hasOverlays = false;
                            break;
                        }
                        if (!hasOverlays) continue;
                        byte[] overlayNameBytes = new byte[64];
                        inputBuffer.get(overlayNameBytes);
                        nameBytes = new byte[64];
                        inputBuffer.get(nameBytes);
                        String overlayColorTableName = StringUtilities.convertToString((byte[])nameBytes);
                        int alpha = inputBuffer.getInt();
                        float min = inputBuffer.getFloat();
                        float max = inputBuffer.getFloat();
                        inputBuffer.getFloat();
                        int numScalars = inputBuffer.getInt();
                        ByteBuffer scalarsBufferByte = ByteBuffer.allocateDirect(numScalars * 4);
                        scalarsBufferByte.order(ByteOrder.nativeOrder());
                        FloatBuffer scalarsBuffer = scalarsBufferByte.asFloatBuffer();
                        for (int ctrN = 0; ctrN < numScalars; ++ctrN) {
                            scalarsBuffer.put(inputBuffer.getFloat());
                        }
                        SurfaceOverlay so = new SurfaceOverlay(scalarsBuffer, min, max, overlayColorTableName);
                        so.setAlpha(alpha);
                        Vector<SurfaceOverlay> overlays = ((CompositeSurface)data[ctr]).getSurfaceOverlays();
                        overlays.add(so);
                        continue;
                    }
                    hasOverlays = false;
                }
                if (!headerOnly) continue;
                break;
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            Mango.showErrorDialogStatic(ERROR_MESSAGE_IMPORT, ERROR_TITLE_FILE);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
            try {
                outputChannel.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface[] readMangoFormat13(File file, Vector<Shape> shapes, VolumeManager controller, boolean baseSurface, boolean headerOnly) {
        Surface[] data = null;
        double[] xform = null;
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            output = new RandomAccessFile(file, "r");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer inputBuffer = outputChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            byte[] magicNum = new byte[MAGIC_NUMBER_LITTLE.length];
            inputBuffer.get(magicNum);
            String magicString = new String(magicNum);
            if (magicString.equals(new String(MAGIC_NUMBER_LITTLE_1_1)) || magicString.equals(new String(MAGIC_NUMBER_LITTLE_1_2)) || magicString.equals(new String(MAGIC_NUMBER_LITTLE_1_3))) {
                littleEndian = true;
            } else if (magicString.equals(new String(MAGIC_NUMBER_BIG_1_1)) || magicString.equals(new String(MAGIC_NUMBER_BIG_1_2)) || magicString.equals(new String(MAGIC_NUMBER_BIG_1_3))) {
                littleEndian = false;
            } else {
                Mango.showErrorDialogStatic(ERROR_MESSAGE_FORMAT_NOT_RECOGNIZED, ERROR_TITLE_FILE);
                throw new Exception(TEXT_FORMAT_NOT_RECOGNIZED);
            }
            if (littleEndian) {
                inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                inputBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            inputBuffer.position(MAGIC_NUMBER_LITTLE.length);
            int numSurfaces = inputBuffer.getInt();
            data = new Surface[numSurfaces];
            xform = new double[16];
            for (int ctr = 0; ctr < xform.length; ++ctr) {
                xform[ctr] = inputBuffer.getDouble();
            }
            int xDim = inputBuffer.getInt();
            int yDim = inputBuffer.getInt();
            int zDim = inputBuffer.getInt();
            double xSize = inputBuffer.getFloat();
            double ySize = inputBuffer.getFloat();
            double zSize = inputBuffer.getFloat();
            double originX = inputBuffer.getFloat();
            double originY = inputBuffer.getFloat();
            double originZ = inputBuffer.getFloat();
            double[] worldTransform = this.makeWorldTransform(controller, xDim, yDim, zDim, xSize, ySize, zSize, originX, originY, originZ);
            float threshold = inputBuffer.getFloat();
            for (int ctr = 0; ctr < numSurfaces; ++ctr) {
                byte[] nameBytes = new byte[64];
                inputBuffer.get(nameBytes);
                String name = new String(nameBytes);
                name = name.trim();
                float[] color = new float[]{inputBuffer.getFloat(), inputBuffer.getFloat(), inputBuffer.getFloat()};
                int numPointsTotal = 0;
                int numParts = inputBuffer.getInt();
                FloatBuffer[] pointBuffers = new FloatBuffer[numParts];
                for (int ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                    int numPointValues = inputBuffer.getInt();
                    numPointsTotal += numPointValues / 3;
                    ByteBuffer pointsBufferByte = null;
                    FloatBuffer pointsBuffer = null;
                    if (headerOnly) {
                        inputBuffer.position(inputBuffer.position() + numPointValues * 4);
                    } else {
                        pointsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
                        pointsBufferByte.order(ByteOrder.nativeOrder());
                        pointsBuffer = pointsBufferByte.asFloatBuffer();
                        int num = numPointValues / 3;
                        for (int ctrP = 0; ctrP < num; ++ctrP) {
                            pointsBuffer.put(inputBuffer.getFloat() * -1.0f);
                            pointsBuffer.put(inputBuffer.getFloat());
                            pointsBuffer.put(inputBuffer.getFloat() * -1.0f);
                        }
                    }
                    pointBuffers[ctrPart] = pointsBuffer;
                }
                numParts = inputBuffer.getInt();
                FloatBuffer[] normalBuffers = new FloatBuffer[numParts];
                for (int ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                    int numNormalValues = inputBuffer.getInt();
                    ByteBuffer normalsBufferByte = null;
                    FloatBuffer normalsBuffer = null;
                    if (headerOnly) {
                        inputBuffer.position(inputBuffer.position() + numNormalValues * 4);
                    } else {
                        normalsBufferByte = ByteBuffer.allocateDirect(numNormalValues * 4);
                        normalsBufferByte.order(ByteOrder.nativeOrder());
                        normalsBuffer = normalsBufferByte.asFloatBuffer();
                        int num = numNormalValues / 3;
                        for (int ctrN = 0; ctrN < num; ++ctrN) {
                            normalsBuffer.put(inputBuffer.getFloat() * -1.0f);
                            normalsBuffer.put(inputBuffer.getFloat());
                            normalsBuffer.put(inputBuffer.getFloat() * -1.0f);
                        }
                    }
                    normalBuffers[ctrPart] = normalsBuffer;
                }
                int numTriangles = 0;
                numParts = inputBuffer.getInt();
                IntBuffer[] indexBuffers = new IntBuffer[numParts];
                for (int ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                    int numIndexValues = inputBuffer.getInt();
                    numTriangles += numIndexValues * 3;
                    ByteBuffer normalsBufferByte = null;
                    IntBuffer indicesBuffer = null;
                    if (headerOnly) {
                        inputBuffer.position(inputBuffer.position() + numIndexValues * 4);
                    } else {
                        normalsBufferByte = ByteBuffer.allocateDirect(numIndexValues * 4);
                        normalsBufferByte.order(ByteOrder.nativeOrder());
                        indicesBuffer = normalsBufferByte.asIntBuffer();
                        for (int ctrN = 0; ctrN < numIndexValues; ++ctrN) {
                            indicesBuffer.put(inputBuffer.getInt());
                        }
                    }
                    indexBuffers[ctrPart] = indicesBuffer;
                }
                if (headerOnly) {
                    data[ctr] = new SurfaceData(name, "", null);
                    ((SurfaceData)data[ctr]).setNumPoints(numPointsTotal);
                    ((SurfaceData)data[ctr]).setNumTriangles(numTriangles);
                } else {
                    data[ctr] = new CompositeSurface(pointBuffers, normalBuffers, indexBuffers, name, color);
                    if (!baseSurface || ctr != 0) {
                        ((CompositeSurface)data[ctr]).setWorldTransform(worldTransform);
                    }
                }
                boolean hasOverlays = true;
                while (!headerOnly && hasOverlays) {
                    if (inputBuffer.position() < inputBuffer.capacity()) {
                        byte[] overlayMagicNumber = new byte[SURFACE_OVERLAY_MAGIC_NUMBER.length];
                        inputBuffer.get(overlayMagicNumber);
                        for (int ctrM = 0; ctrM < SURFACE_OVERLAY_MAGIC_NUMBER.length; ++ctrM) {
                            if (overlayMagicNumber[ctrM] == SURFACE_OVERLAY_MAGIC_NUMBER[ctrM]) continue;
                            inputBuffer.position(inputBuffer.position() - SURFACE_OVERLAY_MAGIC_NUMBER.length);
                            hasOverlays = false;
                            break;
                        }
                        if (!hasOverlays) continue;
                        byte[] overlayNameBytes = new byte[64];
                        inputBuffer.get(overlayNameBytes);
                        nameBytes = new byte[64];
                        inputBuffer.get(nameBytes);
                        String overlayColorTableName = StringUtilities.convertToString((byte[])nameBytes);
                        int alpha = inputBuffer.getInt();
                        float min = inputBuffer.getFloat();
                        float max = inputBuffer.getFloat();
                        inputBuffer.getFloat();
                        numParts = inputBuffer.getInt();
                        FloatBuffer[] scalarsBuffer = new FloatBuffer[numParts];
                        for (int ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                            int numScalars = inputBuffer.getInt();
                            ByteBuffer scalarsBufferByte = ByteBuffer.allocateDirect(numScalars * 4);
                            scalarsBufferByte.order(ByteOrder.nativeOrder());
                            FloatBuffer scalarBuffer = scalarsBufferByte.asFloatBuffer();
                            for (int ctrN = 0; ctrN < numScalars; ++ctrN) {
                                scalarBuffer.put(inputBuffer.getFloat());
                            }
                            scalarsBuffer[ctrPart] = scalarBuffer;
                        }
                        SurfaceOverlay so = new SurfaceOverlay(scalarsBuffer, min, max, overlayColorTableName);
                        so.setAlpha(alpha);
                        Vector<SurfaceOverlay> overlays = ((CompositeSurface)data[ctr]).getSurfaceOverlays();
                        overlays.add(so);
                        continue;
                    }
                    hasOverlays = false;
                }
                if (headerOnly) break;
            }
            boolean hasShapes = true;
            boolean isOnSurface = false;
            while (!headerOnly && hasShapes) {
                if (inputBuffer.position() < inputBuffer.capacity()) {
                    byte[] shapeMagicNumber = new byte[SHAPE_MAGIC_NUMBER.length];
                    inputBuffer.get(shapeMagicNumber);
                    for (int ctrM = 1; ctrM < SHAPE_MAGIC_NUMBER.length; ++ctrM) {
                        if (shapeMagicNumber[ctrM] == SHAPE_MAGIC_NUMBER[ctrM]) continue;
                        hasShapes = false;
                        break;
                    }
                    boolean bl = isOnSurface = shapeMagicNumber[0] == SHAPE_MAGIC_NUMBER_WITH_SURFACE_FLAG[0];
                    if (!hasShapes) continue;
                    byte[] shapeNameBytes = new byte[64];
                    inputBuffer.get(shapeNameBytes);
                    String shapeName = StringUtilities.convertToString((byte[])shapeNameBytes);
                    float[] colorS = new float[]{inputBuffer.getFloat(), inputBuffer.getFloat(), inputBuffer.getFloat()};
                    int numShapePoints = inputBuffer.getInt();
                    Point3d[] shapePoints = new Point3d[numShapePoints];
                    for (int ctrS = 0; ctrS < numShapePoints; ++ctrS) {
                        float xLoc = inputBuffer.getFloat() * -1.0f;
                        float yLoc = inputBuffer.getFloat();
                        float zLoc = inputBuffer.getFloat() * -1.0f;
                        shapePoints[ctrS] = new Point3d((double)xLoc, (double)yLoc, (double)zLoc);
                    }
                    ShapeData sd = new ShapeData(shapePoints, colorS);
                    sd.setOnSurface(isOnSurface);
                    sd.setSurfaceName(shapeName);
                    shapes.add(sd);
                    continue;
                }
                hasShapes = false;
            }
            data[0].setThreshold(threshold);
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            Mango.showErrorDialogStatic(ERROR_MESSAGE_IMPORT, ERROR_TITLE_FILE);
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
            try {
                outputChannel.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface[] readMangoFormat14And15(File file, Vector<Shape> shapes, VolumeManager controller, boolean baseSurface, boolean headerOnly, float coefficient, boolean is15) {
        Surface[] data = null;
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            output = new RandomAccessFile(file, "r");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer inputBuffer = outputChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            byte[] magicNum = new byte[MAGIC_NUMBER_LITTLE.length];
            inputBuffer.get(magicNum);
            String magicString = new String(magicNum);
            if (magicString.equals(new String(MAGIC_NUMBER_LITTLE_1_4))) {
                littleEndian = true;
            } else if (magicString.equals(new String(MAGIC_NUMBER_BIG_1_4))) {
                littleEndian = false;
            } else if (magicString.equals(new String(MAGIC_NUMBER_LITTLE_1_5))) {
                littleEndian = true;
            } else if (magicString.equals(new String(MAGIC_NUMBER_BIG_1_5))) {
                littleEndian = false;
            } else {
                Mango.showErrorDialogStatic(ERROR_MESSAGE_FORMAT_NOT_RECOGNIZED, ERROR_TITLE_FILE);
                throw new Exception(TEXT_FORMAT_NOT_RECOGNIZED);
            }
            if (littleEndian) {
                inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                inputBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            inputBuffer.position(MAGIC_NUMBER_LITTLE.length);
            int previewSize = inputBuffer.getInt();
            int numSurfaces = inputBuffer.getInt();
            data = new Surface[numSurfaces];
            double[] xform = new double[16];
            for (int ctr = 0; ctr < xform.length; ++ctr) {
                xform[ctr] = inputBuffer.getDouble();
            }
            int xDim = inputBuffer.getInt();
            int yDim = inputBuffer.getInt();
            int zDim = inputBuffer.getInt();
            double xSize = inputBuffer.getFloat();
            double ySize = inputBuffer.getFloat();
            double zSize = inputBuffer.getFloat();
            double originX = inputBuffer.getFloat();
            double originY = inputBuffer.getFloat();
            double originZ = inputBuffer.getFloat();
            double[] worldTransform = this.makeWorldTransform(controller, xDim, yDim, zDim, xSize, ySize, zSize, originX, originY, originZ);
            float threshold = inputBuffer.getFloat();
            byte[] previewBytes = new byte[previewSize];
            inputBuffer.get(previewBytes);
            BufferedImage previewImage = ImageIO.read(new ByteArrayInputStream(previewBytes));
            for (int ctr = 0; ctr < numSurfaces; ++ctr) {
                byte[] nameBytes = new byte[64];
                inputBuffer.get(nameBytes);
                String name = new String(nameBytes);
                name = name.trim();
                float[] color = new float[]{inputBuffer.getFloat(), inputBuffer.getFloat(), inputBuffer.getFloat()};
                int numPointsTotal = 0;
                int numParts = inputBuffer.getInt();
                FloatBuffer[] pointBuffers = new FloatBuffer[numParts];
                for (int ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                    int numPointValues = inputBuffer.getInt();
                    numPointsTotal += numPointValues / 3;
                    ByteBuffer pointsBufferByte = null;
                    FloatBuffer pointsBuffer = null;
                    if (headerOnly) {
                        inputBuffer.position(inputBuffer.position() + numPointValues * 4);
                    } else {
                        pointsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
                        pointsBufferByte.order(ByteOrder.nativeOrder());
                        pointsBuffer = pointsBufferByte.asFloatBuffer();
                        int num = numPointValues / 3;
                        for (int ctrP = 0; ctrP < num; ++ctrP) {
                            pointsBuffer.put(inputBuffer.getFloat() * coefficient);
                            pointsBuffer.put(inputBuffer.getFloat());
                            pointsBuffer.put(inputBuffer.getFloat() * coefficient);
                        }
                    }
                    pointBuffers[ctrPart] = pointsBuffer;
                }
                numParts = inputBuffer.getInt();
                FloatBuffer[] normalBuffers = new FloatBuffer[numParts];
                for (int ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                    int numNormalValues = inputBuffer.getInt();
                    ByteBuffer normalsBufferByte = null;
                    FloatBuffer normalsBuffer = null;
                    if (headerOnly) {
                        inputBuffer.position(inputBuffer.position() + numNormalValues * 4);
                    } else {
                        normalsBufferByte = ByteBuffer.allocateDirect(numNormalValues * 4);
                        normalsBufferByte.order(ByteOrder.nativeOrder());
                        normalsBuffer = normalsBufferByte.asFloatBuffer();
                        int num = numNormalValues / 3;
                        for (int ctrN = 0; ctrN < num; ++ctrN) {
                            normalsBuffer.put(inputBuffer.getFloat() * coefficient);
                            normalsBuffer.put(inputBuffer.getFloat());
                            normalsBuffer.put(inputBuffer.getFloat() * coefficient);
                        }
                    }
                    normalBuffers[ctrPart] = normalsBuffer;
                }
                int numTriangles = 0;
                numParts = inputBuffer.getInt();
                IntBuffer[] indexBuffers = new IntBuffer[numParts];
                for (int ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                    int numIndexValues = inputBuffer.getInt();
                    numTriangles += numIndexValues * 3;
                    ByteBuffer normalsBufferByte = null;
                    IntBuffer indicesBuffer = null;
                    if (headerOnly) {
                        inputBuffer.position(inputBuffer.position() + numIndexValues * 4);
                    } else {
                        normalsBufferByte = ByteBuffer.allocateDirect(numIndexValues * 4);
                        normalsBufferByte.order(ByteOrder.nativeOrder());
                        indicesBuffer = normalsBufferByte.asIntBuffer();
                        for (int ctrN = 0; ctrN < numIndexValues; ++ctrN) {
                            indicesBuffer.put(inputBuffer.getInt());
                        }
                    }
                    indexBuffers[ctrPart] = indicesBuffer;
                }
                if (headerOnly) {
                    data[ctr] = new SurfaceData(name, "", null);
                    ((SurfaceData)data[ctr]).setNumPoints(numPointsTotal);
                    ((SurfaceData)data[ctr]).setNumTriangles(numTriangles);
                    ((SurfaceData)data[ctr]).setPreviewImage(previewImage);
                } else {
                    data[ctr] = new CompositeSurface(pointBuffers, normalBuffers, indexBuffers, name, color);
                    if (baseSurface && ctr == 0) {
                        if (is15) {
                            ((CompositeSurface)data[0]).setInitialViewTransform(xform);
                        }
                    } else {
                        ((CompositeSurface)data[ctr]).setWorldTransform(worldTransform);
                    }
                }
                boolean hasOverlays = true;
                while (!headerOnly && hasOverlays) {
                    if (inputBuffer.position() < inputBuffer.capacity()) {
                        byte[] overlayMagicNumber = new byte[SURFACE_OVERLAY_MAGIC_NUMBER.length];
                        inputBuffer.get(overlayMagicNumber);
                        for (int ctrM = 0; ctrM < SURFACE_OVERLAY_MAGIC_NUMBER.length; ++ctrM) {
                            if (overlayMagicNumber[ctrM] == SURFACE_OVERLAY_MAGIC_NUMBER[ctrM]) continue;
                            inputBuffer.position(inputBuffer.position() - SURFACE_OVERLAY_MAGIC_NUMBER.length);
                            hasOverlays = false;
                            break;
                        }
                        if (!hasOverlays) continue;
                        byte[] overlayNameBytes = new byte[64];
                        inputBuffer.get(overlayNameBytes);
                        nameBytes = new byte[64];
                        inputBuffer.get(nameBytes);
                        String overlayColorTableName = StringUtilities.convertToString((byte[])nameBytes);
                        int alpha = inputBuffer.getInt();
                        float min = inputBuffer.getFloat();
                        float max = inputBuffer.getFloat();
                        inputBuffer.getFloat();
                        numParts = inputBuffer.getInt();
                        FloatBuffer[] scalarsBuffer = new FloatBuffer[numParts];
                        for (int ctrPart = 0; ctrPart < numParts; ++ctrPart) {
                            int numScalars = inputBuffer.getInt();
                            ByteBuffer scalarsBufferByte = ByteBuffer.allocateDirect(numScalars * 4);
                            scalarsBufferByte.order(ByteOrder.nativeOrder());
                            FloatBuffer scalarBuffer = scalarsBufferByte.asFloatBuffer();
                            for (int ctrN = 0; ctrN < numScalars; ++ctrN) {
                                scalarBuffer.put(inputBuffer.getFloat());
                            }
                            scalarsBuffer[ctrPart] = scalarBuffer;
                        }
                        SurfaceOverlay so = new SurfaceOverlay(scalarsBuffer, min, max, overlayColorTableName);
                        so.setAlpha(alpha);
                        Vector<SurfaceOverlay> overlays = ((CompositeSurface)data[ctr]).getSurfaceOverlays();
                        overlays.add(so);
                        continue;
                    }
                    hasOverlays = false;
                }
                if (headerOnly) break;
            }
            boolean hasShapes = true;
            boolean isOnSurface = false;
            while (!headerOnly && hasShapes) {
                if (inputBuffer.position() < inputBuffer.capacity()) {
                    byte[] shapeMagicNumber = new byte[SHAPE_MAGIC_NUMBER.length];
                    inputBuffer.get(shapeMagicNumber);
                    for (int ctrM = 1; ctrM < SHAPE_MAGIC_NUMBER.length; ++ctrM) {
                        if (shapeMagicNumber[ctrM] == SHAPE_MAGIC_NUMBER[ctrM]) continue;
                        hasShapes = false;
                        break;
                    }
                    boolean bl = isOnSurface = shapeMagicNumber[0] == SHAPE_MAGIC_NUMBER_WITH_SURFACE_FLAG[0];
                    if (!hasShapes) continue;
                    byte[] shapeNameBytes = new byte[64];
                    inputBuffer.get(shapeNameBytes);
                    String shapeName = StringUtilities.convertToString((byte[])shapeNameBytes);
                    float[] colorS = new float[]{inputBuffer.getFloat(), inputBuffer.getFloat(), inputBuffer.getFloat()};
                    int numShapePoints = inputBuffer.getInt();
                    Point3d[] shapePoints = new Point3d[numShapePoints];
                    for (int ctrS = 0; ctrS < numShapePoints; ++ctrS) {
                        float xLoc = inputBuffer.getFloat() * coefficient;
                        float yLoc = inputBuffer.getFloat();
                        float zLoc = inputBuffer.getFloat() * coefficient;
                        shapePoints[ctrS] = new Point3d((double)xLoc, (double)yLoc, (double)zLoc);
                    }
                    ShapeData sd = new ShapeData(shapePoints, colorS);
                    sd.setOnSurface(isOnSurface);
                    sd.setSurfaceName(shapeName);
                    shapes.add(sd);
                    continue;
                }
                hasShapes = false;
            }
            data[0].setThreshold(threshold);
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            Mango.showErrorDialogStatic(ERROR_MESSAGE_IMPORT, ERROR_TITLE_FILE);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
            try {
                outputChannel.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface[] readMangoFormat1plus(File file, boolean is12, Vector<Shape> shapes, VolumeManager controller, boolean baseSurface, boolean headerOnly) {
        Surface[] data = null;
        double[] rotation = null;
        double[] zoom = null;
        double[] zoomScroll = null;
        double[] translation = null;
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            int ctr;
            output = new RandomAccessFile(file, "r");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer inputBuffer = outputChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            byte[] magicNum = new byte[MAGIC_NUMBER_LITTLE.length];
            inputBuffer.get(magicNum);
            String magicString = new String(magicNum);
            if (magicString.equals(new String(MAGIC_NUMBER_LITTLE_1_1)) || magicString.equals(new String(MAGIC_NUMBER_LITTLE_1_2)) || magicString.equals(new String(MAGIC_NUMBER_LITTLE_1_3))) {
                littleEndian = true;
            } else if (magicString.equals(new String(MAGIC_NUMBER_BIG_1_1)) || magicString.equals(new String(MAGIC_NUMBER_BIG_1_2)) || magicString.equals(new String(MAGIC_NUMBER_BIG_1_3))) {
                littleEndian = false;
            } else {
                Mango.showErrorDialogStatic(ERROR_MESSAGE_FORMAT_NOT_RECOGNIZED, ERROR_TITLE_FILE);
                throw new Exception(TEXT_FORMAT_NOT_RECOGNIZED);
            }
            if (littleEndian) {
                inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                inputBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            inputBuffer.position(MAGIC_NUMBER_LITTLE.length);
            int numSurfaces = inputBuffer.getInt();
            data = new Surface[numSurfaces];
            rotation = new double[16];
            zoom = new double[16];
            zoomScroll = new double[16];
            translation = new double[16];
            for (ctr = 0; ctr < rotation.length; ++ctr) {
                rotation[ctr] = inputBuffer.getFloat();
            }
            for (ctr = 0; ctr < zoom.length; ++ctr) {
                zoom[ctr] = inputBuffer.getFloat();
            }
            for (ctr = 0; ctr < zoomScroll.length; ++ctr) {
                zoomScroll[ctr] = inputBuffer.getFloat();
            }
            for (ctr = 0; ctr < translation.length; ++ctr) {
                translation[ctr] = inputBuffer.getFloat();
            }
            double[] worldTransform = null;
            if (is12) {
                int xDim = inputBuffer.getInt();
                int yDim = inputBuffer.getInt();
                int zDim = inputBuffer.getInt();
                double xSize = inputBuffer.getFloat();
                double ySize = inputBuffer.getFloat();
                double zSize = inputBuffer.getFloat();
                double originX = inputBuffer.getFloat();
                double originY = inputBuffer.getFloat();
                double originZ = inputBuffer.getFloat();
                this.makeWorldTransform(controller, xDim, yDim, zDim, xSize, ySize, zSize, originX, originY, originZ);
            }
            for (int ctr2 = 0; ctr2 < numSurfaces; ++ctr2) {
                byte[] nameBytes = new byte[64];
                inputBuffer.get(nameBytes);
                String name = new String(nameBytes);
                name = name.trim();
                float[] color = new float[]{inputBuffer.getFloat(), inputBuffer.getFloat(), inputBuffer.getFloat()};
                int numPoints = inputBuffer.getInt();
                int numPointValues = numPoints * 3;
                ByteBuffer pointsBufferByte = null;
                FloatBuffer pointsBuffer = null;
                if (headerOnly) {
                    inputBuffer.position(inputBuffer.position() + numPointValues * 4);
                } else {
                    pointsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
                    pointsBufferByte.order(ByteOrder.nativeOrder());
                    pointsBuffer = pointsBufferByte.asFloatBuffer();
                    int num = numPointValues / 3;
                    for (int ctrP = 0; ctrP < num; ++ctrP) {
                        pointsBuffer.put(inputBuffer.getFloat() * -1.0f);
                        pointsBuffer.put(inputBuffer.getFloat());
                        pointsBuffer.put(inputBuffer.getFloat() * -1.0f);
                    }
                }
                int numNormals = inputBuffer.getInt();
                int numNormalValues = numNormals * 3;
                ByteBuffer normalsBufferByte = null;
                FloatBuffer normalsBuffer = null;
                if (headerOnly) {
                    inputBuffer.position(inputBuffer.position() + numNormalValues * 4);
                } else {
                    normalsBufferByte = ByteBuffer.allocateDirect(numNormalValues * 4);
                    normalsBufferByte.order(ByteOrder.nativeOrder());
                    normalsBuffer = normalsBufferByte.asFloatBuffer();
                    int num = numNormalValues / 3;
                    for (int ctrN = 0; ctrN < num; ++ctrN) {
                        normalsBuffer.put(inputBuffer.getFloat() * -1.0f);
                        normalsBuffer.put(inputBuffer.getFloat());
                        normalsBuffer.put(inputBuffer.getFloat() * -1.0f);
                    }
                }
                int stripCountNum = inputBuffer.getInt();
                IntBuffer indicesBuffer = null;
                if (headerOnly) {
                    inputBuffer.position(inputBuffer.position() + stripCountNum * 4);
                } else if (stripCountNum > 0) {
                    int[] strips = new int[stripCountNum];
                    for (int ctrI = 0; ctrI < strips.length; ++ctrI) {
                        strips[ctrI] = inputBuffer.getInt();
                    }
                    indicesBuffer = SurfaceUtils.convertStripCountsToIndices(strips);
                }
                if (headerOnly) {
                    data[ctr2] = new SurfaceData(name, "", null);
                    ((SurfaceData)data[ctr2]).setNumPoints(numPoints);
                } else {
                    data[ctr2] = new CompositeSurface(pointsBuffer, normalsBuffer, indicesBuffer, name, color);
                    if (!baseSurface || ctr2 != 0) {
                        ((CompositeSurface)data[ctr2]).setWorldTransform(worldTransform);
                    }
                }
                boolean hasOverlays = true;
                while (!headerOnly && hasOverlays) {
                    if (inputBuffer.position() < inputBuffer.capacity()) {
                        byte[] overlayMagicNumber = new byte[SURFACE_OVERLAY_MAGIC_NUMBER.length];
                        inputBuffer.get(overlayMagicNumber);
                        for (int ctrM = 0; ctrM < SURFACE_OVERLAY_MAGIC_NUMBER.length; ++ctrM) {
                            if (overlayMagicNumber[ctrM] == SURFACE_OVERLAY_MAGIC_NUMBER[ctrM]) continue;
                            inputBuffer.position(inputBuffer.position() - SURFACE_OVERLAY_MAGIC_NUMBER.length);
                            hasOverlays = false;
                            break;
                        }
                        if (!hasOverlays) continue;
                        byte[] overlayNameBytes = new byte[64];
                        inputBuffer.get(overlayNameBytes);
                        nameBytes = new byte[64];
                        inputBuffer.get(nameBytes);
                        String overlayColorTableName = StringUtilities.convertToString((byte[])nameBytes);
                        int alpha = inputBuffer.getInt();
                        float min = inputBuffer.getFloat();
                        float max = inputBuffer.getFloat();
                        inputBuffer.getFloat();
                        int numScalars = inputBuffer.getInt();
                        ByteBuffer scalarsBufferByte = ByteBuffer.allocateDirect(numScalars * 4);
                        scalarsBufferByte.order(ByteOrder.nativeOrder());
                        FloatBuffer scalarsBuffer = scalarsBufferByte.asFloatBuffer();
                        for (int ctrN = 0; ctrN < numScalars; ++ctrN) {
                            scalarsBuffer.put(inputBuffer.getFloat());
                        }
                        SurfaceOverlay so = new SurfaceOverlay(scalarsBuffer, min, max, overlayColorTableName);
                        so.setAlpha(alpha);
                        Vector<SurfaceOverlay> overlays = ((CompositeSurface)data[ctr2]).getSurfaceOverlays();
                        overlays.add(so);
                        continue;
                    }
                    hasOverlays = false;
                }
                if (headerOnly) break;
            }
            boolean hasShapes = true;
            boolean isOnSurface = false;
            while (!headerOnly && hasShapes) {
                if (inputBuffer.position() < inputBuffer.capacity()) {
                    byte[] shapeMagicNumber = new byte[SHAPE_MAGIC_NUMBER.length];
                    inputBuffer.get(shapeMagicNumber);
                    for (int ctrM = 1; ctrM < SHAPE_MAGIC_NUMBER.length; ++ctrM) {
                        if (shapeMagicNumber[ctrM] == SHAPE_MAGIC_NUMBER[ctrM]) continue;
                        hasShapes = false;
                        break;
                    }
                    boolean bl = isOnSurface = shapeMagicNumber[0] == SHAPE_MAGIC_NUMBER_WITH_SURFACE_FLAG[0];
                    if (!hasShapes) continue;
                    byte[] shapeNameBytes = new byte[64];
                    inputBuffer.get(shapeNameBytes);
                    float[] colorS = new float[]{inputBuffer.getFloat(), inputBuffer.getFloat(), inputBuffer.getFloat()};
                    int numShapePoints = inputBuffer.getInt();
                    Point3d[] shapePoints = new Point3d[numShapePoints];
                    for (int ctrS = 0; ctrS < numShapePoints; ++ctrS) {
                        float xLoc = inputBuffer.getFloat() * -1.0f;
                        float yLoc = inputBuffer.getFloat();
                        float zLoc = inputBuffer.getFloat() * -1.0f;
                        shapePoints[ctrS] = new Point3d((double)xLoc, (double)yLoc, (double)zLoc);
                    }
                    ShapeData sd = new ShapeData(shapePoints, colorS);
                    sd.setOnSurface(isOnSurface);
                    sd.setSurfaceName(StringUtilities.convertToString((byte[])shapeNameBytes));
                    shapes.add(sd);
                    continue;
                }
                hasShapes = false;
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            Mango.showErrorDialogStatic(ERROR_MESSAGE_IMPORT, ERROR_TITLE_FILE);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
            }
            try {
                outputChannel.close();
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        return data;
    }

    public String getOptions() {
        return null;
    }

    public void setOptions(String options) {
    }
}

