/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.io.formats.gifti;

import com.jogamp.common.nio.Buffers;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalAnalysisTool;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.screen.LogicalOverlay;
import edu.uthscsa.ric.mango.viewersurface.screen.SurfaceOverlay;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.Label;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class GIFTIColorMapper {
    private Vector<LogicalOverlay> logicalOverlays;
    private final CompositeSurface surface;
    private final SliceViewer viewer;
    private final Vector<SurfaceOverlay> surfaceOverlays;
    public static final double EPSILON = 1.0E-9;
    public static final float MULTIPLIER = 1.0f;

    public GIFTIColorMapper(SliceViewer viewer, Vector<SurfaceOverlay> surfaceOverlays, CompositeSurface surface) {
        this.viewer = viewer;
        this.surfaceOverlays = surfaceOverlays;
        this.surface = surface;
    }

    public IntBuffer mapColors(Map<Integer, Label> map) {
        this.logicalOverlays = this.findLogicals();
        int keyIndex = 0;
        TreeMap<Integer, Integer> keyMap = new TreeMap<Integer, Integer>();
        Iterator<SurfaceOverlay> it = this.surfaceOverlays.iterator();
        int index = 0;
        boolean logicalsFinished = false;
        IntBuffer buf = Buffers.newDirectIntBuffer((int)this.surface.getNumPoints(0));
        while (it.hasNext()) {
            SurfaceOverlay so = it.next();
            ScreenVolume screenVol = so.getOverlay();
            if (!this.surface.getMaterial().isShowOnlyThisOverlayColors() || screenVol == null || this.surface.getAssociatedOvelray() == screenVol.getVolume()) {
                boolean isLogical;
                boolean hiding;
                float max;
                float min;
                if (screenVol != null) {
                    min = this.viewer.getMango().getToolBox().getScreenMinOf(screenVol);
                    max = this.viewer.getMango().getToolBox().getScreenMaxOf(screenVol);
                } else {
                    min = so.getMin();
                    max = so.getMax();
                }
                float alpha = screenVol != null ? (float)((double)screenVol.getAlphaInteger() / 255.0) : (float)((double)so.getAlpha() / 255.0);
                boolean isNegative = min > max;
                LookupTableManager lut = null;
                if (screenVol != null) {
                    lut = screenVol.getLookupTableManager();
                } else {
                    lut = LookupTableManager.createLookupTableManager(LookupTableManager.findIndex(so.getColorTableName()), true);
                    if (lut == null) {
                        lut = LookupTableManager.createLookupTableManager(3, true);
                    }
                    lut.initLUT();
                }
                float materialAlpha = 1.0f - this.surface.getMaterial().getTransparency();
                float minDynamic = min;
                float maxDynamic = max;
                double screenRatio = 255.0 / (double)(max - min);
                float oneMinusAlpha = 1.0f - alpha;
                boolean bl = hiding = screenVol != null ? screenVol.isHidden() : false;
                if (screenVol != null) {
                    minDynamic = this.viewer.getMango().getToolBox().getDynamicScreenMinOf(screenVol);
                    maxDynamic = this.viewer.getMango().getToolBox().getDynamicScreenMaxOf(screenVol);
                    so.setMin(minDynamic);
                    so.setMax(maxDynamic);
                }
                float[] baseColor = this.surface.getMaterial().getColor().getColorComponents(null);
                if (so.isBuilding() || hiding && index != 0) continue;
                LogicalAnalysisTool logicalManager = this.viewer.getLogicalManager();
                boolean allLogicalsHidden = logicalManager != null && logicalManager.allLogicalHidden();
                boolean bl2 = isLogical = screenVol != null && screenVol.isLogical();
                if (isLogical && !hiding && !allLogicalsHidden) {
                    if (logicalsFinished) continue;
                    this.doLogicals(index, so);
                    index += this.logicalOverlays.size();
                    logicalsFinished = true;
                    continue;
                }
                FloatBuffer scalars = so.getScalars(0);
                int num = scalars.capacity();
                for (int ctr = 0; ctr < num; ++ctr) {
                    int key;
                    int hashKey;
                    float value = scalars.get(ctr);
                    int position = ctr;
                    double red = 0.0;
                    double green = 0.0;
                    double blue = 0.0;
                    if (hiding || MathUtilities.essentiallyEqual((float)value, (float)Float.MIN_VALUE) || !isNegative && value <= minDynamic || isNegative && value >= minDynamic || (double)Math.abs(value - minDynamic) < 1.0E-9) {
                        if (index == 0) {
                            red = baseColor[0];
                            green = baseColor[1];
                            blue = baseColor[2];
                        }
                    } else if (!isNegative && value >= maxDynamic || isNegative && value <= maxDynamic || (double)Math.abs(value - maxDynamic) < 1.0E-9) {
                        if (index == 0) {
                            red = alpha * ((float)lut.lookupRed(255) / 255.0f * 1.0f) + oneMinusAlpha * baseColor[0];
                            green = alpha * ((float)lut.lookupGreen(255) / 255.0f * 1.0f) + oneMinusAlpha * baseColor[1];
                            blue = alpha * ((float)lut.lookupBlue(255) / 255.0f * 1.0f) + oneMinusAlpha * baseColor[2];
                        } else {
                            Label label = map.get(buf.get(position));
                            red = (double)(alpha * ((float)lut.lookupRed(255) / 255.0f * 1.0f)) + (double)oneMinusAlpha * label.getRed();
                            green = (double)(alpha * ((float)lut.lookupGreen(255) / 255.0f * 1.0f)) + (double)oneMinusAlpha * label.getGreen();
                            blue = (double)(alpha * ((float)lut.lookupBlue(255) / 255.0f * 1.0f)) + (double)oneMinusAlpha * label.getBlue();
                        }
                    } else {
                        int valueInt = (int)((double)(value - min) * screenRatio + 0.5);
                        Label label = map.get(buf.get(position));
                        if (index == 0) {
                            red = alpha * ((float)lut.lookupRed(valueInt) / 255.0f * 1.0f) + oneMinusAlpha * baseColor[0];
                            green = alpha * ((float)lut.lookupGreen(valueInt) / 255.0f * 1.0f) + oneMinusAlpha * baseColor[1];
                            blue = alpha * ((float)lut.lookupBlue(valueInt) / 255.0f * 1.0f) + oneMinusAlpha * baseColor[2];
                        } else {
                            red = (double)(alpha * ((float)lut.lookupRed(valueInt) / 255.0f * 1.0f)) + (double)oneMinusAlpha * label.getRed();
                            green = (double)(alpha * ((float)lut.lookupGreen(valueInt) / 255.0f * 1.0f)) + (double)oneMinusAlpha * label.getGreen();
                            blue = (double)(alpha * ((float)lut.lookupBlue(valueInt) / 255.0f * 1.0f)) + (double)oneMinusAlpha * label.getBlue();
                        }
                    }
                    if (keyMap.containsKey(hashKey = Label.computeHash((double)red, (double)green, (double)blue, (double)materialAlpha))) {
                        key = (Integer)keyMap.get(hashKey);
                    } else {
                        keyMap.put(hashKey, keyIndex);
                        key = keyIndex++;
                    }
                    if (!map.containsKey(key)) {
                        map.put(key, new Label(red, green, blue, (double)materialAlpha, "?"));
                    }
                    buf.put(position, key);
                }
            }
            ++index;
        }
        return (IntBuffer)buf.rewind();
    }

    private void doLogicals(int startIndex, SurfaceOverlay so) {
        LogicalAnalysisTool logicalManager = this.viewer.getLogicalManager();
        Enumeration<LogicalOverlay> en = this.logicalOverlays.elements();
        int numLogicals = this.logicalOverlays.size();
        LogicalOverlay[] logicals = new LogicalOverlay[numLogicals];
        float materialAlpha = 1.0f - this.surface.getMaterial().getTransparency();
        float[] baseColor = this.surface.getMaterial().getColor().getColorComponents(null);
        int index = 0;
        while (en.hasMoreElements()) {
            logicals[index++] = en.nextElement();
        }
        for (int ctrPart = 0; ctrPart < this.surface.getNumParts(); ++ctrPart) {
            FloatBuffer colors = this.surface.getColorsBuffer(ctrPart);
            if (colors == null) {
                colors = Buffers.newDirectFloatBuffer((int)(this.surface.getNumPoints(ctrPart) * 4));
                this.surface.addColorsData(colors, ctrPart);
            }
            int num = so.getScalars(ctrPart).capacity();
            for (int ctr = 0; ctr < num; ++ctr) {
                int position = ctr * 4;
                boolean doLogical = false;
                int overlayHash = 0;
                LogicalOverlay[] logicalOverlayArray = logicals;
                int n = logicalOverlayArray.length;
                for (int i = 0; i < n; ++i) {
                    LogicalOverlay logical;
                    LogicalOverlay lo = logical = logicalOverlayArray[i];
                    ScreenVolume screenVolume = (ScreenVolume)lo.getOverlay();
                    FloatBuffer scalars = lo.getSurfaceOverlay().getScalars(ctrPart);
                    float value = scalars.get(ctr);
                    if (!lo.isNegative() && value <= lo.getMinDynamic() || lo.isNegative() && value >= lo.getMinDynamic() || (double)Math.abs(value - lo.getMinDynamic()) < 1.0E-9) continue;
                    doLogical = true;
                    overlayHash += screenVolume.getVolume().hashCode();
                }
                if (doLogical) {
                    int color = 0;
                    if (logicalManager != null) {
                        color = logicalManager.getColorOfVoxel(overlayHash);
                    }
                    if (color != 0) {
                        colors.put(position, (float)((double)(color >> 16 & 0xFF) / 255.0));
                        colors.put(position + 1, (float)((double)(color >> 8 & 0xFF) / 255.0));
                        colors.put(position + 2, (float)((double)(color >> 0 & 0xFF) / 255.0));
                    } else if (startIndex == 0) {
                        colors.put(position, baseColor[0]);
                        colors.put(position + 1, baseColor[1]);
                        colors.put(position + 2, baseColor[2]);
                    }
                } else if (startIndex == 0) {
                    colors.put(position, baseColor[0]);
                    colors.put(position + 1, baseColor[1]);
                    colors.put(position + 2, baseColor[2]);
                }
                colors.put(position + 3, materialAlpha);
            }
        }
    }

    private Vector<LogicalOverlay> findLogicals() {
        LogicalAnalysisTool logicalManager = this.viewer.getLogicalManager();
        boolean allLogicalsHidden = logicalManager != null && logicalManager.allLogicalHidden();
        Vector<LogicalOverlay> logicalOverlays = new Vector<LogicalOverlay>();
        Enumeration<SurfaceOverlay> en = this.surfaceOverlays.elements();
        if (!allLogicalsHidden) {
            while (en.hasMoreElements()) {
                float max;
                float min;
                SurfaceOverlay so = en.nextElement();
                ScreenVolume screenVol = so.getOverlay();
                if (screenVol != null) {
                    min = this.viewer.getMango().getToolBox().getScreenMinOf(screenVol);
                    max = this.viewer.getMango().getToolBox().getScreenMaxOf(screenVol);
                } else {
                    min = so.getMin();
                    max = so.getMax();
                }
                boolean isNegative = min > max;
                LookupTableManager lut = null;
                if (screenVol != null) {
                    lut = screenVol.getLookupTableManager();
                } else {
                    lut = LookupTableManager.createLookupTableManager(LookupTableManager.findIndex(so.getColorTableName()), true);
                    if (lut == null) {
                        lut = LookupTableManager.createLookupTableManager(3, true);
                    }
                    lut.initLUT();
                }
                float minDynamic = min;
                float maxDynamic = max;
                if (screenVol != null) {
                    minDynamic = (float)screenVol.getDynamicScreenMin();
                    maxDynamic = (float)screenVol.getDynamicScreenMax();
                    so.setMin(minDynamic);
                    so.setMax(maxDynamic);
                }
                boolean hiding = screenVol != null ? screenVol.isHidden() : false;
                boolean isLogical = screenVol != null && screenVol.isLogical();
                if (!isLogical || hiding) continue;
                LogicalOverlay lo = new LogicalOverlay();
                lo.setOverlay(screenVol);
                lo.setSurfaceOverlay(so);
                lo.setNegative(isNegative);
                logicalOverlays.add(lo);
            }
        }
        return logicalOverlays;
    }
}

