/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.io.formats.bv;

import edu.uthscsa.ric.mango.ViewerController;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceData;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.visualization.surface.SurfaceController;
import edu.uthscsa.ric.visualization.surface.io.FloatIterator;
import edu.uthscsa.ric.visualization.surface.io.IndexIterator;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.visualization.surface.primitives.Shape;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BrainVisaMeshFormat
implements SurfaceFormat,
Cloneable {
    public static final String ERROR_MESSAGE_IMPORT = "Error importing file!  See console for more details.";
    public static final String ERROR_TITLE_FILE = "File Error";
    private JComboBox<Surface> volBox;
    private JRadioButton binButton;
    private JRadioButton textButton;
    private static final byte[] MAGIC_NUMBER_ASCII = new byte[]{97, 115, 99, 105, 105};
    private static final byte[] MAGIC_NUMBER_BIG = new byte[]{98, 105, 110, 97, 114, 65, 66, 67, 68};
    private static final byte[] MAGIC_NUMBER_LITTLE = new byte[]{98, 105, 110, 97, 114, 68, 67, 66, 65};
    private static final byte[] VOID = new byte[]{86, 79, 73, 68};
    public static final String EXTENSION = "mesh";
    public static final String MIN_MANGO_SUPPORTED = "3";
    public static final String NAME = "BrainVisa Mesh";
    public static final String VERSION = "1.1";
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder().toString().equals(ByteOrder.LITTLE_ENDIAN.toString());
    public static final int CURRENT_TIMEPOINT = 0;
    public static final int NUM_POLYGON_DIMS = 3;
    public static final int NUM_TIMEPOINTS = 1;

    private static void showErrorDialog(String message, String title) {
        JOptionPane.showMessageDialog(null, message + "  ", title, 2);
    }

    public Object clone() {
        Object ob = null;
        try {
            ob = super.clone();
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return ob;
    }

    public String getMinimumVersionSupported() {
        return MIN_MANGO_SUPPORTED;
    }

    public String getOptions() {
        StringBuffer sb = new StringBuffer();
        sb.append("Text=").append(this.textButton.isSelected());
        return sb.toString();
    }

    public void setOptions(String options) {
        boolean value = Boolean.parseBoolean(options.substring(options.indexOf(61) + 1));
        this.textButton.setSelected(value);
        this.binButton.setSelected(!value);
    }

    @Deprecated
    public JPanel getOptionsPanel(Surface[] data, Shape[] shapes, SurfaceController controller) {
        return this.getOptionsPanel(data, shapes, (VolumeManager)controller.getViewerController());
    }

    public JPanel getOptionsPanel(Surface[] data, Shape[] shapes, VolumeManager controller) {
        this.volBox = new JComboBox<Surface>(data);
        JPanel volPanel = new JPanel();
        volPanel.setLayout(new BoxLayout(volPanel, 0));
        volPanel.add(Box.createHorizontalStrut(4));
        volPanel.add(new JLabel("Select Volume:"));
        volPanel.add(this.volBox);
        volPanel.add(Box.createHorizontalStrut(4));
        JPanel optionsPanel = new JPanel();
        this.textButton = new JRadioButton("Text");
        this.binButton = new JRadioButton("Binary");
        JLabel formatLabel = new JLabel("Select Format:");
        ButtonGroup group = new ButtonGroup();
        group.add(this.textButton);
        group.add(this.binButton);
        this.textButton.setSelected(true);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        optionsPanel.add(Box.createHorizontalStrut(4));
        optionsPanel.add(formatLabel);
        optionsPanel.add(this.textButton);
        optionsPanel.add(this.binButton);
        optionsPanel.add(Box.createHorizontalStrut(4));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(volPanel);
        mainPanel.add(optionsPanel);
        return mainPanel;
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return EXTENSION;
    }

    public String getVersion() {
        return VERSION;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        boolean isThisFormat = false;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            byte[] magicNum = new byte[9];
            int bytesRead = input.read(magicNum);
            if (bytesRead > 0) {
                if (new String(magicNum, 0, bytesRead).equals(new String(MAGIC_NUMBER_BIG))) {
                    isThisFormat = true;
                } else if (new String(magicNum, 0, bytesRead).equals(new String(MAGIC_NUMBER_LITTLE))) {
                    isThisFormat = true;
                } else if (new String(magicNum, 0, Math.min(5, bytesRead)).equals(new String(MAGIC_NUMBER_ASCII))) {
                    isThisFormat = true;
                }
            }
        }
        catch (Exception ex) {
            AppLogger.warn((Throwable)ex);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return isThisFormat;
    }

    @Deprecated
    public Surface[] readSurfaceFile(File file, ViewerController controller, Vector<Shape> shapes, boolean baseSurface) {
        return this.readSurface(file, (VolumeManager)controller, false);
    }

    public Surface[] readSurfaceFile(File file, VolumeManager controller, Vector<Shape> shapes, boolean baseSurface) {
        return this.readSurface(file, controller, false);
    }

    public Surface[] readSurfaceHeader(File file, Vector<Shape> shapes) throws SurfaceFormatException {
        return this.readSurface(file, null, true);
    }

    @Deprecated
    public void writeSurfaceFile(File file, Surface[] data, Shape[] shapes, SurfaceController controller) throws SurfaceFormatException {
        if (this.textButton.isSelected()) {
            this.writeAsciiFile(file, (VolumeManager)controller.getViewerController());
        } else {
            this.writeBinaryFile(file, (VolumeManager)controller.getViewerController());
        }
    }

    public void writeSurfaceFile(File file, Surface[] data, Shape[] shapes, VolumeManager controller) throws SurfaceFormatException {
        if (this.textButton.isSelected()) {
            this.writeAsciiFile(file, controller);
        } else {
            this.writeBinaryFile(file, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface[] readAsciiFormat(File file, VolumeManager controller, boolean headerOnly) {
        Surface[] sd = null;
        BufferedInputStream reader = null;
        try {
            ImageDimensions id = null;
            VoxelDimensions vd = null;
            int xDim = 0;
            int yDim = 0;
            int zDim = 0;
            float xSize = 0.0f;
            float ySize = 0.0f;
            float zSize = 0.0f;
            float xHalf = 0.0f;
            float yHalf = 0.0f;
            float zHalf = 0.0f;
            if (controller != null) {
                id = controller.getBaseVolume().getImageDimensions();
                vd = controller.getBaseVolume().getVoxelDimensions();
                xDim = id.getX();
                yDim = id.getY();
                zDim = id.getZ();
                xSize = (float)vd.getXSize();
                ySize = (float)vd.getYSize();
                zSize = (float)vd.getZSize();
                xHalf = (float)xDim * xSize / 2.0f;
                yHalf = (float)yDim * ySize / 2.0f;
                zHalf = (float)zDim * zSize / 2.0f;
            }
            reader = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[256];
            String magicNumberAscii = new String(MAGIC_NUMBER_ASCII);
            String voidString = new String(VOID);
            boolean foundIndicesNum = false;
            boolean currentTimepointNotFound = false;
            boolean numTimepointsNotFound = false;
            boolean numParamtersNotFound = false;
            boolean voidNotFound = false;
            boolean asciiNotFound = false;
            boolean finishedIndices = false;
            boolean finishedTexture = false;
            boolean foundNormalNum = false;
            boolean finishedNormals = false;
            boolean foundPointNum = false;
            boolean finishedPoints = false;
            int compIndex = 0;
            int numNormalValues = 0;
            int numPointValues = 0;
            int numIndexValues = 0;
            int numIndices = 0;
            int indicesIndex = 0;
            int pointsIndex = 0;
            int normalsIndex = 0;
            int numNormals = 0;
            int numPoints = 0;
            FloatBuffer pointsBuffer = null;
            FloatBuffer normalsBuffer = null;
            IntBuffer indicesBuffer = null;
            String currentToken = "";
            int bytesRead = reader.read(buffer);
            block17: while (bytesRead != -1) {
                StringTokenizer tokenizer = new StringTokenizer(currentToken + new String(buffer, 0, bytesRead), ",() \t\n\r\f", true);
                if (tokenizer.hasMoreTokens()) {
                    currentToken = tokenizer.nextToken();
                    while (tokenizer.hasMoreTokens()) {
                        try {
                            if (currentToken.equals(",") || currentToken.equals("(") || currentToken.equals(")") || currentToken.equals("\t") || currentToken.equals("\n") || currentToken.equals("\r") || currentToken.equals("\f") || currentToken.equals(" ")) {
                                currentToken = tokenizer.nextToken();
                                continue;
                            }
                            if (!asciiNotFound) {
                                asciiNotFound = currentToken.equals(magicNumberAscii);
                                currentToken = tokenizer.nextToken();
                                continue;
                            }
                            if (!voidNotFound) {
                                voidNotFound = currentToken.equals(voidString);
                                currentToken = tokenizer.nextToken();
                                continue;
                            }
                            float value = Float.parseFloat(currentToken);
                            if (!numParamtersNotFound) {
                                numParamtersNotFound = true;
                                currentToken = tokenizer.nextToken();
                                continue;
                            }
                            if (!numTimepointsNotFound) {
                                numTimepointsNotFound = true;
                                currentToken = tokenizer.nextToken();
                                continue;
                            }
                            if (!currentTimepointNotFound) {
                                currentTimepointNotFound = true;
                                currentToken = tokenizer.nextToken();
                                continue;
                            }
                            if (!finishedPoints) {
                                if (!foundPointNum) {
                                    numPoints = (int)value;
                                    if (headerOnly) break block17;
                                    numPointValues = numPoints * 3;
                                    ByteBuffer pointsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
                                    pointsBufferByte.order(ByteOrder.nativeOrder());
                                    pointsBuffer = pointsBufferByte.asFloatBuffer();
                                    foundPointNum = true;
                                    currentToken = tokenizer.nextToken();
                                    continue;
                                }
                                if (pointsIndex < numPointValues) {
                                    if (compIndex == 0) {
                                        value = -1.0f * value + xHalf;
                                    } else if (compIndex == 1) {
                                        value -= yHalf;
                                    } else if (compIndex == 2) {
                                        value -= zHalf;
                                    }
                                    pointsBuffer.put(value);
                                    ++pointsIndex;
                                    ++compIndex;
                                    compIndex %= 3;
                                    currentToken = tokenizer.nextToken();
                                    continue;
                                }
                                finishedPoints = true;
                            }
                            if (!finishedNormals) {
                                if (!foundNormalNum) {
                                    numNormals = (int)value;
                                    numNormalValues = numNormals * 3;
                                    ByteBuffer normalsBufferByte = ByteBuffer.allocateDirect(numNormalValues * 4);
                                    normalsBufferByte.order(ByteOrder.nativeOrder());
                                    normalsBuffer = normalsBufferByte.asFloatBuffer();
                                    compIndex = 0;
                                    foundNormalNum = true;
                                    currentToken = tokenizer.nextToken();
                                    continue;
                                }
                                if (normalsIndex < numNormalValues) {
                                    if (compIndex == 0) {
                                        value *= -1.0f;
                                    }
                                    normalsBuffer.put(value);
                                    ++normalsIndex;
                                    ++compIndex;
                                    compIndex %= 3;
                                    currentToken = tokenizer.nextToken();
                                    continue;
                                }
                                finishedNormals = true;
                            }
                            if (!finishedTexture) {
                                finishedTexture = true;
                                currentToken = tokenizer.nextToken();
                                continue;
                            }
                            if (!finishedIndices) {
                                if (!foundIndicesNum) {
                                    numIndices = (int)value;
                                    numIndexValues = numIndices * 3;
                                    ByteBuffer indicesByteBuffer = ByteBuffer.allocateDirect(numIndexValues * 4);
                                    indicesByteBuffer.order(ByteOrder.nativeOrder());
                                    indicesBuffer = indicesByteBuffer.asIntBuffer();
                                    foundIndicesNum = true;
                                    compIndex = 0;
                                    currentToken = tokenizer.nextToken();
                                    continue;
                                }
                                if (indicesIndex < numIndexValues) {
                                    int indicesIndexTrue = indicesIndex;
                                    if (compIndex == 0) {
                                        indicesIndexTrue += 2;
                                    } else if (compIndex == 2) {
                                        indicesIndexTrue -= 2;
                                    }
                                    indicesBuffer.put(indicesIndexTrue, (int)value);
                                    ++indicesIndex;
                                    ++compIndex;
                                    compIndex %= 3;
                                    currentToken = tokenizer.nextToken();
                                    continue;
                                }
                                finishedIndices = true;
                            }
                        }
                        catch (Exception ex) {
                            AppLogger.error((Throwable)ex);
                        }
                        currentToken = tokenizer.nextToken();
                    }
                }
                bytesRead = reader.read(buffer);
            }
            sd = new Surface[]{new SurfaceData("Surface", "", pointsBuffer, normalsBuffer, indicesBuffer)};
            ((SurfaceData)sd[0]).setNumPoints(numPoints);
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
            BrainVisaMeshFormat.showErrorDialog(ERROR_MESSAGE_IMPORT, ERROR_TITLE_FILE);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            BrainVisaMeshFormat.showErrorDialog(ERROR_MESSAGE_IMPORT, ERROR_TITLE_FILE);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return sd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface[] readFormat(File file, boolean isLittle, VolumeManager controller, boolean headerOnly) {
        Surface[] sd = null;
        RandomAccessFile output = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            ImageDimensions id = null;
            VoxelDimensions vd = null;
            int xDim = 0;
            int yDim = 0;
            int zDim = 0;
            float xSize = 0.0f;
            float ySize = 0.0f;
            float zSize = 0.0f;
            float xHalf = 0.0f;
            float yHalf = 0.0f;
            float zHalf = 0.0f;
            if (controller != null) {
                id = controller.getBaseVolume().getImageDimensions();
                vd = controller.getBaseVolume().getVoxelDimensions();
                xDim = id.getX();
                yDim = id.getY();
                zDim = id.getZ();
                xSize = (float)vd.getXSize();
                ySize = (float)vd.getYSize();
                zSize = (float)vd.getZSize();
                xHalf = (float)xDim * xSize / 2.0f;
                yHalf = (float)yDim * ySize / 2.0f;
                zHalf = (float)zDim * zSize / 2.0f;
            }
            output = new RandomAccessFile(file, "r");
            outputChannel = output.getChannel();
            ((FileChannel)outputChannel).position(((FileChannel)outputChannel).size());
            MappedByteBuffer inputBuffer = ((FileChannel)outputChannel).map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            if (isLittle) {
                inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                inputBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            inputBuffer.position(29);
            FloatBuffer pointsBuffer = null;
            FloatBuffer normalsBuffer = null;
            IntBuffer indicesBuffer = null;
            int numPoints = inputBuffer.getInt();
            if (!headerOnly) {
                int numPointValues = numPoints * 3;
                ByteBuffer pointsBufferByte = ByteBuffer.allocateDirect(numPointValues * 4);
                pointsBufferByte.order(ByteOrder.nativeOrder());
                pointsBuffer = pointsBufferByte.asFloatBuffer();
                for (int ctrP = 0; ctrP < numPointValues; ctrP += 3) {
                    float valX = inputBuffer.getFloat();
                    float valY = inputBuffer.getFloat();
                    float valZ = inputBuffer.getFloat();
                    pointsBuffer.put(-1.0f * valX + xHalf);
                    pointsBuffer.put(valY - yHalf);
                    pointsBuffer.put(valZ - zHalf);
                }
                int numNormals = inputBuffer.getInt();
                int numNormalValues = numNormals * 3;
                ByteBuffer normalsBufferByte = ByteBuffer.allocateDirect(numNormalValues * 4);
                normalsBufferByte.order(ByteOrder.nativeOrder());
                normalsBuffer = normalsBufferByte.asFloatBuffer();
                for (int ctrN = 0; ctrN < numNormalValues; ctrN += 3) {
                    float valX = inputBuffer.getFloat();
                    float valY = inputBuffer.getFloat();
                    float valZ = inputBuffer.getFloat();
                    normalsBuffer.put(-1.0f * valX);
                    normalsBuffer.put(valY);
                    normalsBuffer.put(valZ);
                }
                inputBuffer.getInt();
                int numIndices = inputBuffer.getInt();
                ByteBuffer indicesBufferByte = ByteBuffer.allocateDirect(numIndices * 3 * 4);
                indicesBufferByte.order(ByteOrder.nativeOrder());
                indicesBuffer = indicesBufferByte.asIntBuffer();
                for (int ctr = 0; ctr < numIndices; ++ctr) {
                    int p1 = inputBuffer.getInt();
                    int p2 = inputBuffer.getInt();
                    int p3 = inputBuffer.getInt();
                    indicesBuffer.put(p3);
                    indicesBuffer.put(p2);
                    indicesBuffer.put(p1);
                }
            }
            sd = new Surface[]{new SurfaceData("Surface", "", pointsBuffer, normalsBuffer, indicesBuffer)};
            ((SurfaceData)sd[0]).setNumPoints(numPoints);
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
            BrainVisaMeshFormat.showErrorDialog(ERROR_MESSAGE_IMPORT, ERROR_TITLE_FILE);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            BrainVisaMeshFormat.showErrorDialog(ERROR_MESSAGE_IMPORT, ERROR_TITLE_FILE);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
            try {
                outputChannel.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return sd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Surface[] readSurface(File file, VolumeManager controller, boolean headerOnly) {
        boolean isLittle = false;
        boolean isAscii = false;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            byte[] magicNum = new byte[9];
            FileUtilities.readFully((InputStream)input, (byte[])magicNum);
            if (new String(magicNum, 0, 5).equals(new String(MAGIC_NUMBER_ASCII))) {
                isAscii = true;
            } else if (new String(magicNum).equals(new String(MAGIC_NUMBER_BIG))) {
                isLittle = false;
            } else if (new String(magicNum).equals(new String(MAGIC_NUMBER_LITTLE))) {
                isLittle = true;
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        if (isAscii) {
            return this.readAsciiFormat(file, controller, headerOnly);
        }
        return this.readFormat(file, isLittle, controller, headerOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAsciiFile(File file, VolumeManager controller) throws SurfaceFormatException {
        Surface surface = (Surface)this.volBox.getSelectedItem();
        ImageDimensions id = controller.getBaseVolume().getImageDimensions();
        VoxelDimensions vd = controller.getBaseVolume().getVoxelDimensions();
        int xDim = id.getX();
        int yDim = id.getY();
        int zDim = id.getZ();
        float xSize = (float)vd.getXSize();
        float ySize = (float)vd.getYSize();
        float zSize = (float)vd.getZSize();
        float xHalf = (float)xDim * xSize / 2.0f;
        float yHalf = (float)yDim * ySize / 2.0f;
        float zHalf = (float)zDim * zSize / 2.0f;
        int numPoints = surface.getNumPoints();
        int numTriangles = surface.getNumTriangles();
        FloatIterator pointsIterator = surface.getPointsIterator();
        FloatIterator normalsIterator = surface.getNormalsIterator();
        PrintWriter writer = null;
        try {
            float value;
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            writer.println(new String(MAGIC_NUMBER_ASCII));
            writer.println(new String(VOID));
            writer.println(String.valueOf(3));
            writer.println(String.valueOf(1));
            writer.println(String.valueOf(0));
            writer.print(numPoints + " ");
            int compIndex = 0;
            while (pointsIterator.hasNext()) {
                value = pointsIterator.next();
                if (compIndex == 0) {
                    writer.print("(" + -1.0f * (value - xHalf) + ",");
                } else if (compIndex == 1) {
                    writer.print(value + yHalf + ",");
                } else if (compIndex == 2) {
                    writer.print(value + zHalf + ") ");
                }
                ++compIndex;
                compIndex %= 3;
            }
            writer.println("\n");
            writer.print(numPoints + " ");
            compIndex = 0;
            while (normalsIterator.hasNext()) {
                value = normalsIterator.next();
                if (compIndex == 0) {
                    writer.print("(" + -1.0f * value + ",");
                } else if (compIndex == 1) {
                    writer.print(value + ",");
                } else if (compIndex == 2) {
                    writer.print(value + ") ");
                }
                ++compIndex;
                compIndex %= 3;
            }
            writer.println("\n");
            writer.print("0");
            writer.println("\n");
            writer.print(numTriangles + " ");
            IndexIterator indicesIterator = surface.getIndiciesIterator();
            while (indicesIterator.hasNext()) {
                int p1 = indicesIterator.next();
                int p2 = indicesIterator.next();
                int p3 = indicesIterator.next();
                writer.print("(" + p3 + "," + p2 + "," + p1 + ") ");
            }
            writer.println("\n");
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
            BrainVisaMeshFormat.showErrorDialog("Error exporting file!  See console for more details.", ERROR_TITLE_FILE);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }

    private void writeBinaryFile(File file, VolumeManager controller) throws SurfaceFormatException {
        int pointsSize;
        Surface surface = (Surface)this.volBox.getSelectedItem();
        ImageDimensions id = controller.getBaseVolume().getImageDimensions();
        VoxelDimensions vd = controller.getBaseVolume().getVoxelDimensions();
        int xDim = id.getX();
        int yDim = id.getY();
        int zDim = id.getZ();
        float xSize = (float)vd.getXSize();
        float ySize = (float)vd.getYSize();
        float zSize = (float)vd.getZSize();
        float xHalf = (float)xDim * xSize / 2.0f;
        float yHalf = (float)yDim * ySize / 2.0f;
        float zHalf = (float)zDim * zSize / 2.0f;
        int numPoints = surface.getNumPoints();
        int numTriangles = surface.getNumTriangles();
        FloatIterator pointsIterator = surface.getPointsIterator();
        FloatIterator normalsIterator = surface.getNormalsIterator();
        int normalsSize = pointsSize = numPoints * 3 * 4 + 4;
        int textureSize = 4;
        boolean numTextures = false;
        int indicesSize = numTriangles * 3 * 4 + 4;
        int headerSize = 9;
        headerSize += 8;
        headerSize += 4;
        headerSize += 4;
        headerSize += 4;
        RandomAccessFile output = null;
        FileChannel outputChannel = null;
        try {
            float value;
            output = new RandomAccessFile(file, "rw");
            outputChannel = output.getChannel();
            outputChannel.position(outputChannel.size());
            MappedByteBuffer outputBuffer = outputChannel.map(FileChannel.MapMode.READ_WRITE, 0L, headerSize + pointsSize + normalsSize + 4 + indicesSize);
            if (LITTLE_ENDIAN) {
                outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                outputBuffer.order(ByteOrder.BIG_ENDIAN);
            }
            if (LITTLE_ENDIAN) {
                outputBuffer.put(MAGIC_NUMBER_LITTLE);
            } else {
                outputBuffer.put(MAGIC_NUMBER_BIG);
            }
            outputBuffer.putInt(4);
            outputBuffer.put(VOID);
            outputBuffer.putInt(3);
            outputBuffer.putInt(1);
            outputBuffer.putInt(0);
            outputBuffer.putInt(numPoints);
            int compIndex = 0;
            while (pointsIterator.hasNext()) {
                value = pointsIterator.next();
                if (compIndex == 0) {
                    value = -1.0f * (value - xHalf);
                } else if (compIndex == 1) {
                    value += yHalf;
                } else if (compIndex == 2) {
                    value += zHalf;
                }
                outputBuffer.putFloat(value);
                ++compIndex;
                compIndex %= 3;
            }
            outputBuffer.putInt(numPoints);
            compIndex = 0;
            while (normalsIterator.hasNext()) {
                value = normalsIterator.next();
                if (compIndex == 0) {
                    value = -1.0f * value;
                }
                outputBuffer.putFloat(value);
                ++compIndex;
                compIndex %= 3;
            }
            outputBuffer.putInt(0);
            outputBuffer.putInt(numTriangles);
            IndexIterator indicesIterator = surface.getIndiciesIterator();
            while (indicesIterator.hasNext()) {
                int p1 = indicesIterator.next();
                int p2 = indicesIterator.next();
                int p3 = indicesIterator.next();
                outputBuffer.putInt(p3);
                outputBuffer.putInt(p2);
                outputBuffer.putInt(p1);
            }
            outputBuffer.force();
        }
        catch (FileNotFoundException ex) {
            AppLogger.error((Throwable)ex);
            throw new SurfaceFormatException((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            throw new SurfaceFormatException((Throwable)ex);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
            try {
                outputChannel.close();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
    }
}

