/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.io.formats;

import com.jogamp.common.nio.Buffers;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class NormalsGenerator {
    private final IntBuffer indices;
    private final FloatBuffer normals;
    private final FloatBuffer points;

    public NormalsGenerator(FloatBuffer points, IntBuffer indices) {
        this.points = points;
        this.indices = indices;
        this.normals = Buffers.newDirectFloatBuffer((int)points.capacity());
    }

    public FloatBuffer generateNormals() {
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        Point3f p3 = new Point3f();
        float[] normalsArray = new float[this.points.capacity()];
        int numIndices = this.indices.capacity();
        for (int ctr = 0; ctr < numIndices; ctr += 3) {
            int index1 = this.indices.get(ctr) * 3;
            int index2 = this.indices.get(ctr + 1) * 3;
            int index3 = this.indices.get(ctr + 2) * 3;
            p1.x = this.points.get(index1);
            p1.y = this.points.get(index1 + 1);
            p1.z = this.points.get(index1 + 2);
            p2.x = this.points.get(index2);
            p2.y = this.points.get(index2 + 1);
            p2.z = this.points.get(index2 + 2);
            p3.x = this.points.get(index3);
            p3.y = this.points.get(index3 + 1);
            p3.z = this.points.get(index3 + 2);
            float qx = p2.x - p1.x;
            float qy = p2.y - p1.y;
            float qz = p2.z - p1.z;
            float px = p3.x - p1.x;
            float py = p3.y - p1.y;
            float pz = p3.z - p1.z;
            float normalX = py * qz - pz * qy;
            float normalY = pz * qx - px * qz;
            float normalZ = px * qy - py * qx;
            int n = index1;
            normalsArray[n] = normalsArray[n] + normalX;
            int n2 = index1 + 1;
            normalsArray[n2] = normalsArray[n2] + normalY;
            int n3 = index1 + 2;
            normalsArray[n3] = normalsArray[n3] + normalZ;
            int n4 = index2;
            normalsArray[n4] = normalsArray[n4] + normalX;
            int n5 = index2 + 1;
            normalsArray[n5] = normalsArray[n5] + normalY;
            int n6 = index2 + 2;
            normalsArray[n6] = normalsArray[n6] + normalZ;
            int n7 = index3;
            normalsArray[n7] = normalsArray[n7] + normalX;
            int n8 = index3 + 1;
            normalsArray[n8] = normalsArray[n8] + normalY;
            int n9 = index3 + 2;
            normalsArray[n9] = normalsArray[n9] + normalZ;
        }
        Vector3f normal = new Vector3f();
        int numNormalValues = this.normals.capacity();
        for (int ctr = 0; ctr < numNormalValues; ctr += 3) {
            normal.x = normalsArray[ctr];
            normal.y = normalsArray[ctr + 1];
            normal.z = normalsArray[ctr + 2];
            normal.negate();
            normal.normalize();
            normalsArray[ctr] = normal.x;
            normalsArray[ctr + 1] = normal.y;
            normalsArray[ctr + 2] = normal.z;
        }
        this.normals.put(normalsArray);
        return this.normals;
    }
}

