/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.building;

import com.jogamp.common.nio.Buffers;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewersurface.SurfacePosition;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantBuilder;
import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantRunner;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceScalarsBuilderListener;
import edu.uthscsa.ric.mango.viewersurface.screen.SurfaceOverlay;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.nio.FloatBuffer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class SurfaceScalarsBuilder
implements OctantRunner {
    private SurfaceScalarsBuilderListener listener;
    private double distance;
    private double stepSize;
    private final CompositeSurface data;
    private final SliceViewer viewer;
    private final SurfaceOverlay surfaceOverlay;
    private final SurfacePosition position;
    private final Volume baseVolume;
    private final boolean hasImageTransform;
    private final boolean hasWorldTransform;
    public static final int DISTANCE_MULTIPLIER = 3;

    public static double getDistanceDefault(SurfaceViewer render) {
        VoxelDimensions vd = render.getViewer().getVoxelDimensions();
        double xSize = vd.getXSize();
        double ySize = vd.getYSize();
        double zSize = vd.getZSize();
        double averageSize = (xSize + ySize + zSize) / 3.0;
        return averageSize * 3.0;
    }

    public static double getStepSizeDefault(SurfaceViewer render) {
        VoxelDimensions vd = render.getViewer().getVoxelDimensions();
        double xSize = vd.getXSize();
        double ySize = vd.getYSize();
        double zSize = vd.getZSize();
        double averageSize = (xSize + ySize + zSize) / 3.0;
        return averageSize / 2.0;
    }

    public SurfaceScalarsBuilder(SliceViewer viewer, SurfacePosition position, CompositeSurface data, Volume baseVolume, SurfaceOverlay surfaceOverlay) {
        this.viewer = viewer;
        this.position = position;
        this.data = data;
        this.baseVolume = baseVolume;
        this.surfaceOverlay = surfaceOverlay;
        this.hasImageTransform = !position.isImageTransformIdentity() && (data.isBaseSurface() || data.isUseTransform());
        this.hasWorldTransform = !data.isBaseSurface() && data.getWorldTransform() != null;
    }

    public void buildScalars(SurfaceScalarsBuilderListener listener, double distance, double stepSize) {
        this.distance = distance;
        this.stepSize = stepSize;
        this.listener = listener;
        if (this.data.getNumParts() == 1) {
            this.doSingleProcess();
        } else {
            OctantBuilder builder = new OctantBuilder(this, true);
            builder.start();
        }
    }

    @Override
    public void finishProcess(boolean sync) {
        this.doProcess(this.data.getNumParts() - 1);
        this.finishUp();
    }

    @Override
    public void process(int numProcesses, int threadIndex, int ctr, int ctrPart) {
        this.doProcess(ctrPart);
    }

    @Override
    public boolean testProcess() {
        if (this.surfaceOverlay.isBuilding()) {
            return false;
        }
        this.surfaceOverlay.setBuilding(true);
        return true;
    }

    private void doProcess(int ctrPart) {
        Volume volume = this.surfaceOverlay.getOverlay().getVolume();
        boolean isWorldMode = this.viewer.getMango().getToolBox().isWorldMode();
        boolean useTransform = true;
        Vector3d tempNormal = new Vector3d();
        Point3d tempVertex = new Point3d();
        Coordinate tempCoordinate = new Coordinate();
        double[] transformedCoords = new double[3];
        FloatBuffer points = this.data.getPointsBuffer(ctrPart);
        FloatBuffer normals = this.data.getNormalsBuffer(ctrPart);
        int numPointValues = points.capacity();
        int numPoints = numPointValues / 3;
        double[][] worldTransform = null;
        if (this.hasWorldTransform) {
            double[] matArraySingle = this.data.getWorldTransform();
            worldTransform = new double[4][4];
            for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    worldTransform[ctrOut][ctrIn] = matArraySingle[ctrOut * 4 + ctrIn];
                }
            }
        }
        FloatBuffer scalars = Buffers.newDirectFloatBuffer((int)numPoints);
        this.surfaceOverlay.setScalars(scalars, ctrPart);
        int xDim = this.baseVolume.getXDim();
        int yDim = this.baseVolume.getYDim();
        int zDim = this.baseVolume.getZDim();
        float xSize = (float)this.baseVolume.getXSize();
        float ySize = (float)this.baseVolume.getYSize();
        float zSize = (float)this.baseVolume.getZSize();
        float xHalf = (float)xDim * xSize / 2.0f;
        float yHalf = (float)yDim * ySize / 2.0f;
        float zHalf = (float)zDim * zSize / 2.0f;
        this.surfaceOverlay.setAlpha(this.surfaceOverlay.getOverlay().getLookupTableManager().getAlpha());
        VolumeData volData = new VolumeData(this.viewer);
        for (int ctr = 0; ctr < numPointValues; ctr += 3) {
            double xLoc = points.get(ctr);
            double yLoc = points.get(ctr + 1);
            double zLoc = points.get(ctr + 2);
            if (this.hasWorldTransform) {
                SurfacePosition.applyTransform(worldTransform, xLoc, yLoc, zLoc, transformedCoords);
                xLoc = transformedCoords[0];
                yLoc = transformedCoords[1];
                zLoc = transformedCoords[2];
            }
            if (this.hasImageTransform) {
                this.position.applyImageTransform(xLoc, yLoc, zLoc, transformedCoords);
                xLoc = transformedCoords[0];
                yLoc = transformedCoords[1];
                zLoc = transformedCoords[2];
            }
            double xImage = xLoc + (double)xHalf;
            double yImage = yLoc + (double)yHalf;
            double zImage = zLoc + (double)zHalf;
            if (isWorldMode) {
                tempCoordinate.setValues(xImage /= (double)xSize, yImage /= (double)ySize, zImage /= (double)zSize);
                volData.convertIndexToWorldCoordinate(tempCoordinate);
            } else {
                tempCoordinate.setValues(xImage, yImage, zImage);
            }
            double xNorm = normals.get(ctr) * -1.0f;
            double yNorm = normals.get(ctr + 1);
            double zNorm = normals.get(ctr + 2) * -1.0f;
            tempVertex.set(tempCoordinate.xDbl, tempCoordinate.yDbl, tempCoordinate.zDbl);
            tempNormal.set(xNorm, yNorm, zNorm);
            float value = this.getScalar(volume, tempVertex, tempNormal, this.distance, this.stepSize, volume.getCurrentTimepoint(), isWorldMode, true);
            scalars.put(value);
        }
    }

    private void doSingleProcess() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (SurfaceScalarsBuilder.this.testProcess()) {
                    SurfaceScalarsBuilder.this.viewer.startIndeterminateProgressBar();
                    SurfaceScalarsBuilder.this.doProcess(0);
                    SurfaceScalarsBuilder.this.finishUp();
                    SurfaceScalarsBuilder.this.viewer.endIndeterminateProgressBar();
                }
            }
        }, "SurfaceScalarsBuilder.doSingleProcess() Thread");
        workThread.start();
    }

    private void finishUp() {
        this.surfaceOverlay.setBuilding(false);
        this.listener.scalarBuildFinished(this.data);
    }

    private float getScalar(Volume volume, Point3d vertex, Vector3d normal, double distance, double step, int timepoint, boolean isWorldMode, boolean useTransform) {
        double current;
        double currentDistance;
        int ctr;
        double max = 1.4E-45f;
        int totalSteps = Math.max(1, (int)(distance / step));
        for (ctr = 0; ctr < totalSteps; ++ctr) {
            currentDistance = step * (double)ctr;
            current = 0.0;
            current = isWorldMode ? volume.getVoxelValueAtCoordinate(vertex.x + normal.x * currentDistance, vertex.y + normal.y * currentDistance, vertex.z + normal.z * currentDistance, timepoint, useTransform, true) : volume.getVoxelValueAtMM(vertex.x + normal.x * currentDistance, vertex.y + normal.y * currentDistance, vertex.z + normal.z * currentDistance, timepoint, useTransform, true);
            if (Double.isNaN(current)) {
                current = 1.4E-45f;
            }
            if (!(Math.abs(current) > Math.abs(max))) continue;
            max = current;
        }
        for (ctr = 1; ctr < totalSteps; ++ctr) {
            currentDistance = step * (double)ctr * -1.0;
            current = 0.0;
            current = isWorldMode ? volume.getVoxelValueAtCoordinate(vertex.x + normal.x * currentDistance, vertex.y + normal.y * currentDistance, vertex.z + normal.z * currentDistance, timepoint, useTransform, true) : volume.getVoxelValueAtMM(vertex.x + normal.x * currentDistance, vertex.y + normal.y * currentDistance, vertex.z + normal.z * currentDistance, timepoint, useTransform, true);
            if (Double.isNaN(current)) {
                current = 1.4E-45f;
            }
            if (!(Math.abs(current) > Math.abs(max))) continue;
            max = current;
        }
        return (float)max;
    }
}

