/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.building;

import com.jogamp.common.nio.Buffers;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.Logical;
import edu.uthscsa.ric.mango.viewerslice.operations.ShrinkWrapOperations;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.core.Cube;
import edu.uthscsa.ric.mango.viewersurface.core.Triangle;
import edu.uthscsa.ric.mango.viewersurface.core.TriangleData;
import edu.uthscsa.ric.mango.viewersurface.core.TriangleVertex;
import edu.uthscsa.ric.mango.viewersurface.operations.building.MarchingCubesRenderer;
import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantBuilder;
import edu.uthscsa.ric.mango.viewersurface.operations.building.OctantRunner;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceBuildParameters;
import edu.uthscsa.ric.roi.mask.buffers.AbstractROIBuffer;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Image;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VolumeListener;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;
import edu.uthscsa.ric.volume.operations.filter.FilterOp;
import edu.uthscsa.ric.volume.operations.filter.FilterVolume;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class SurfaceFactory
implements OctantRunner {
    private ByteBuffer mask;
    private Color color;
    private CompositeSurface composite;
    private Coordinate tempCoor;
    private VolumeManager viewer;
    private ProgressMeter progressBar;
    private ImageVolume overlay;
    private String name;
    private SurfaceBuildParameters params;
    private SurfaceViewer renderer;
    private TriangleData[] allTriData;
    private Volume baseVolume;
    private Volume overlayVolume;
    private Volume renderVolume;
    private VolumeData volData;
    private boolean building;
    private boolean indexMode;
    private boolean isLogical;
    private boolean isOverlay;
    private boolean isROI;
    private boolean isWorldMode;
    private boolean sameDimensions;
    private boolean stepFilter;
    private boolean stepMarchingCubes;
    private boolean stepShrinkWrap;
    private float xRes;
    private float yRes;
    private float zRes;
    private long roiMask;
    private long startTime;
    private boolean sameThread;
    private final Coordinate origin;
    private final float averageVoxelSize;
    private final float threshold;
    private final float xSize;
    private final float ySize;
    private final float zSize;
    private final int xDim;
    private final int xSteps;
    private final int yDim;
    private final int ySteps;
    private final int zDim;
    private final int zSteps;
    public static final int OVERLAP = 1;

    public SurfaceFactory(SurfaceBuildParameters params, Volume baseVolume) {
        this.baseVolume = this.renderVolume = baseVolume;
        this.params = params;
        this.origin = baseVolume.getOrigin();
        this.threshold = params.getThreshold();
        this.xDim = baseVolume.getXDim();
        this.yDim = baseVolume.getYDim();
        this.zDim = baseVolume.getZDim();
        this.xRes = params.getResX();
        this.yRes = params.getResY();
        this.zRes = params.getResZ();
        this.xSize = (float)baseVolume.getXSize();
        this.ySize = (float)baseVolume.getYSize();
        this.zSize = (float)baseVolume.getZSize();
        this.xSteps = Math.round((float)this.xDim * this.xSize / this.xRes);
        this.ySteps = Math.round((float)this.yDim * this.ySize / this.yRes);
        this.zSteps = Math.round((float)this.zDim * this.zSize / this.zRes);
        this.averageVoxelSize = (this.xSize + this.ySize + this.zSize) / 3.0f;
        if (this.xSteps == this.xDim && this.ySteps == this.yDim && this.zSteps == this.zDim) {
            this.indexMode = true;
            this.xRes = this.xSize;
            this.yRes = this.ySize;
            this.zRes = this.zSize;
        }
        this.name = "Surface";
    }

    public void clear() {
        this.baseVolume = null;
        this.renderVolume = null;
        this.overlayVolume = null;
        this.params = null;
        this.viewer = null;
        if (this.allTriData != null) {
            for (int ctr = 0; ctr < this.allTriData.length; ++ctr) {
                if (this.allTriData[ctr] == null) continue;
                this.allTriData[ctr].clear();
                this.allTriData[ctr] = null;
            }
        }
        this.allTriData = null;
        this.renderer = null;
        this.composite = null;
        this.tempCoor = null;
        this.overlay = null;
        this.mask = null;
    }

    public void setViewer(VolumeManager viewer) {
        this.viewer = viewer;
        this.volData = new VolumeData(viewer);
    }

    public Surface createLogicalSurface(SurfaceViewer renderer, Logical logical, String name, Color color) {
        if (renderer != null) {
            this.renderer = renderer;
            this.setViewer(renderer.getViewer());
        }
        return this.doCreateLogicalSurface(logical, name, color);
    }

    private Surface doCreateLogicalSurface(final Logical logical, String name, Color color) {
        this.isLogical = true;
        this.name = name;
        this.color = color;
        this.isWorldMode = this.viewer.isWorldMode();
        this.startTime = System.currentTimeMillis();
        if (this.sameThread) {
            return this.copyLogicalDataToTempBuffer(logical);
        }
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SurfaceFactory.this.copyLogicalDataToTempBuffer(logical);
            }
        }, "SurfaceFactory.createLogicalSurface() Thread");
        workThread.start();
        return null;
    }

    public Surface createOverlaySurface(SurfaceViewer renderer, Volume aOverlay, String aName, Color aColor) {
        if (renderer != null) {
            this.renderer = renderer;
            this.setViewer(renderer.getViewer());
            this.overlay = aOverlay;
        }
        this.isOverlay = true;
        this.name = aName;
        this.color = aColor;
        this.renderVolume = this.overlayVolume = aOverlay;
        this.tempCoor = new Coordinate();
        this.isWorldMode = Mango.getInstance().getToolBox().isWorldMode();
        this.sameDimensions = this.baseVolume.getImageDimensions().equals((Object)this.overlayVolume.getImageDimensions()) && this.baseVolume.getVoxelDimensions().equals((Object)this.overlayVolume.getVoxelDimensions());
        this.startTime = System.currentTimeMillis();
        return this.doNext();
    }

    public Surface createROISurface(SurfaceViewer renderer, ROIManager roiManager, int roiNum, String name, Color color) {
        if (renderer != null) {
            this.renderer = renderer;
            this.setViewer(renderer.getViewer());
        }
        this.isROI = true;
        int xDimROI = this.xDim + 1;
        int yDimROI = this.yDim + 1;
        this.roiMask = 1L << roiNum;
        this.name = name;
        this.color = color;
        this.startTime = System.currentTimeMillis();
        this.copyROIDataToTempBuffer(roiManager.getBuffer(), xDimROI, yDimROI);
        return this.doNext();
    }

    public Surface createSurface(SurfaceViewer renderer) {
        this.renderer = renderer;
        if (renderer != null) {
            this.setViewer(renderer.getViewer());
            this.name = renderer.getViewer().getImageTitle();
        }
        this.startTime = System.currentTimeMillis();
        return this.doNext();
    }

    @Override
    public void finishProcess(boolean sync) {
        if (this.building) {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SurfaceFactory.this.progressBar != null) {
                        SurfaceFactory.this.progressBar.setValue(SurfaceFactory.this.progressBar.getMax());
                        SurfaceFactory.this.progressBar = SurfaceFactory.this.viewer.makeProgressMeter();
                        SurfaceFactory.this.progressBar.setDescription("Finishing Up");
                        SurfaceFactory.this.progressBar.start(0, 0, 8, true);
                    }
                }
            });
            for (int ctr = 1; ctr < 8; ++ctr) {
                this.allTriData[0].merge(this.allTriData[ctr]);
                this.allTriData[ctr].clear();
                this.allTriData[ctr] = null;
                if (this.progressBar == null) continue;
                this.progressBar.setValue(ctr);
            }
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SurfaceFactory.this.progressBar != null) {
                        SurfaceFactory.this.progressBar.setIndeterminateMode(true);
                    }
                }
            });
            this.createData(this.allTriData[0], 0);
            SwingWidgetUtilities.invokeAndWaitSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    SurfaceFactory.this.params.setBuildTime(System.currentTimeMillis() - SurfaceFactory.this.startTime);
                    SurfaceFactory.this.composite.setParams(SurfaceFactory.this.params);
                    if (SurfaceFactory.this.isOverlay || SurfaceFactory.this.isROI || SurfaceFactory.this.isLogical) {
                        SurfaceFactory.this.composite.getMaterial().setColor(SurfaceFactory.this.color);
                        SurfaceFactory.this.composite.setName(SurfaceFactory.this.name);
                        if (SurfaceFactory.this.isOverlay) {
                            SurfaceFactory.this.composite.setBuildFromOverlay(SurfaceFactory.this.isOverlay);
                            SurfaceFactory.this.composite.setAssociatedOverlay(SurfaceFactory.this.overlay);
                            SurfaceFactory.this.composite.getMaterial().setShowOverlayColors(true);
                            SurfaceFactory.this.composite.getMaterial().setShowOnlyThisOverlayColors(true);
                        }
                        if (SurfaceFactory.this.renderer != null) {
                            SurfaceFactory.this.renderer.addShape(SurfaceFactory.this.composite);
                        }
                    } else {
                        SurfaceFactory.this.composite.setBaseSurface(true);
                        SurfaceFactory.this.composite.getMaterial().setShowOverlayColors(true);
                        if (SurfaceFactory.this.renderer != null) {
                            SurfaceFactory.this.renderer.finishedBuild(SurfaceFactory.this.composite);
                        }
                    }
                }
            });
        }
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SurfaceFactory.this.progressBar != null) {
                    SurfaceFactory.this.progressBar.setValue(SurfaceFactory.this.progressBar.getMax());
                }
            }
        });
        this.building = false;
    }

    public boolean isBuilding() {
        return this.building;
    }

    @Override
    public void process(int numProcesses, int threadIndex, int ctr, int processIndex) {
        try {
            if (this.building) {
                this.processOctant(this.renderOctant(processIndex, threadIndex, ctr, numProcesses));
            } else {
                this.finishProcess(false);
            }
        }
        catch (Error err) {
            AppLogger.error((Throwable)err);
            this.viewer.showErrorMessage("There was a problem building the surface.", "Surface Error");
            this.building = false;
        }
    }

    @Override
    public boolean testProcess() {
        return true;
    }

    private Surface copyLogicalDataToTempBuffer(Logical logical) {
        this.renderVolume.makeTempBuffer();
        this.progressBar = this.viewer.makeProgressMeter();
        this.progressBar.setDescription("Analyzing Logical");
        this.progressBar.start(0, 0, this.zDim);
        List allOverlays = this.viewer.getOverlays();
        int logicalHash = logical.hashCode();
        VolumeData[] volsData = new VolumeData[allOverlays.size()];
        for (int ctr = 0; ctr < allOverlays.size(); ++ctr) {
            volsData[ctr] = new VolumeData(this.viewer, (Volume)allOverlays.get(ctr));
        }
        for (int ctrZ = 0; ctrZ < this.zDim; ++ctrZ) {
            this.progressBar.setValue(ctrZ);
            for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
                for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                    int overlaysHash = 0;
                    for (int ctr = 0; ctr < allOverlays.size(); ++ctr) {
                        boolean logicalContains;
                        Volume volume = (Volume)allOverlays.get(ctr);
                        double value = volsData[ctr].getValue(ctrX, ctrY, ctrZ);
                        double overlayScreenMin = this.viewer.getVolumeDisplayRangeMin((ImageVolume)volume);
                        boolean isNegative = this.viewer.isVolumeDisplayNegative((ImageVolume)volume);
                        boolean aboveThreshold = !isNegative && value > overlayScreenMin || isNegative && value < overlayScreenMin;
                        if (aboveThreshold ^ (logicalContains = logical.contains(volume))) {
                            overlaysHash = 0;
                            break;
                        }
                        if (!aboveThreshold || !logicalContains) continue;
                        overlaysHash += volume.hashCode();
                    }
                    if (logicalHash == overlaysHash) {
                        this.baseVolume.putRawVoxelValueAtIndexTemp(ctrX, ctrY, ctrZ, 1.0);
                        continue;
                    }
                    this.baseVolume.putRawVoxelValueAtIndexTemp(ctrX, ctrY, ctrZ, 0.0);
                }
            }
        }
        this.progressBar.setValue(this.progressBar.getMax());
        return this.doNext();
    }

    private void copyROIDataToTempBuffer(AbstractROIBuffer roiBuffer, int xDimROI, int yDimROI) {
        this.renderVolume.makeTempBuffer();
        roiBuffer.rewind();
        int offsetROI = 0;
        int offsetYROI = 0;
        int offsetZROI = 0;
        for (int ctrZ = 0; ctrZ < this.zDim; ++ctrZ) {
            offsetZROI = ctrZ * xDimROI * yDimROI;
            for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
                offsetYROI = ctrY * xDimROI;
                for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                    boolean maskOn;
                    offsetROI = offsetZROI + offsetYROI + ctrX;
                    boolean bl = maskOn = (roiBuffer.getCurrent(offsetROI) & this.roiMask) != 0L;
                    if (maskOn) {
                        this.renderVolume.putRawVoxelValueAtIndexTemp(ctrX, ctrY, ctrZ, 1.0);
                        continue;
                    }
                    this.renderVolume.putRawVoxelValueAtIndexTemp(ctrX, ctrY, ctrZ, 0.0);
                }
            }
        }
    }

    private void createData(TriangleData triData, int index) {
        Collection<TriangleVertex> vertices = triData.getVertices().values();
        FloatBuffer pointsBuffer = Buffers.newDirectFloatBuffer((int)(vertices.size() * 3));
        FloatBuffer normalsBuffer = Buffers.newDirectFloatBuffer((int)(vertices.size() * 3));
        Iterator<TriangleVertex> it = vertices.iterator();
        int pointsCtr = 0;
        while (it.hasNext()) {
            TriangleVertex pt = it.next();
            Point3f avgPlane = pt.getAveragePlaneCenter(false);
            pointsBuffer.put(avgPlane.x);
            pointsBuffer.put(avgPlane.y);
            pointsBuffer.put(avgPlane.z);
            pt.index = pointsCtr++;
            Vector3f normal = pt.getAveragePlaneNormal();
            normal.normalize();
            normal.negate();
            normalsBuffer.put(normal.x);
            normalsBuffer.put(normal.y);
            normalsBuffer.put(normal.z);
        }
        Set<Triangle> triangles = triData.getTriangles();
        int numTriangles = triangles.size();
        IntBuffer indexBuffer = Buffers.newDirectIntBuffer((int)(numTriangles * 3));
        for (Triangle tri : triangles) {
            indexBuffer.put(tri.vert1.index);
            indexBuffer.put(tri.vert2.index);
            indexBuffer.put(tri.vert3.index);
        }
        this.composite.addData(pointsBuffer, normalsBuffer, indexBuffer, index);
        triData.clear();
        this.allTriData[index] = null;
    }

    private void doFilter() {
        ByteBuffer tempBuffer = this.renderVolume.makeTempBuffer();
        if (!this.isROI && !this.isLogical) {
            if (this.viewer != null) {
                this.progressBar = this.viewer.makeProgressMeter();
                this.progressBar.start(0, 0, 100);
                this.progressBar.setIndeterminateMode(true);
                this.progressBar.setValue(100);
            }
            this.renderVolume.copyDataToTempBuffer();
        }
        boolean success = true;
        if (this.params.useFilter()) {
            ImageDimensions id = this.renderVolume.getImageDimensions();
            int sliceSize = id.getNumVoxelsSlice();
            FilterBuffer filterBuffer = new FilterBuffer(sliceSize, (ByteBuffer)tempBuffer.rewind(), this.isROI || this.isLogical ? 0.0 : this.renderVolume.getVolumeIntercept());
            filterBuffer.initialize();
            double SD = (double)this.params.getFilterFWHM() / 2.3548;
            FilterVolume filter = new FilterVolume("Gaussian Filter", "((1/(sqrt(2*pi)*" + SD + ")) * exp(-.5*pow((col/" + SD + "),2)))", "((1/(sqrt(2*pi)*" + SD + ")) * exp(-.5*pow((row/" + SD + "),2)))", "((1/(sqrt(2*pi)*" + SD + ")) * exp(-.5*pow((slice/" + SD + "),2)))", this.params.getFilterSize(), true);
            FilterOp filterOp = new FilterOp(this.viewer, (VolumeListener)this.viewer);
            success = filterOp.runFilter(filter, this.renderVolume, filterBuffer, false, true);
        }
        if (success) {
            this.stepFilter = true;
            this.doNext();
        }
    }

    private void filter() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SurfaceFactory.this.doFilter();
                }
                catch (OutOfMemoryError err) {
                    AppLogger.error((Throwable)err);
                }
            }
        }, "SurfaceFactory.doFilter() Thread");
        workThread.start();
    }

    private Surface doNext() {
        if (!this.stepFilter) {
            if (this.sameThread) {
                this.doFilter();
            } else {
                this.filter();
            }
        } else if (!this.stepShrinkWrap) {
            this.doShrinkWrap();
        } else if (!this.stepMarchingCubes) {
            this.startRender();
        }
        return this.composite;
    }

    private void doShrinkWrap() {
        try {
            if (this.params.isUseShrinkWrap()) {
                if (this.params.isUseNegative()) {
                    ByteBuffer labelBuffer = Image.makeBuffer(this.xSteps * this.ySteps * this.zSteps * 4);
                    this.mask = ShrinkWrapOperations.shrinkWrap3D(this.xSteps, this.ySteps, this.zSteps, this.xRes, this.yRes, this.zRes, this.renderVolume, labelBuffer, this.viewer, -3.4028234663852886E38, this.threshold, this.isWorldMode, this.isOverlay, 0, this.isROI || this.isLogical, !this.isOverlay && this.indexMode);
                } else {
                    ByteBuffer labelBuffer = Image.makeBuffer(this.xSteps * this.ySteps * this.zSteps * 4);
                    this.mask = ShrinkWrapOperations.shrinkWrap3D(this.xSteps, this.ySteps, this.zSteps, this.xRes, this.yRes, this.zRes, this.renderVolume, labelBuffer, this.viewer, this.threshold, 3.4028234663852886E38, this.isWorldMode, this.isOverlay, 0, this.isROI || this.isLogical, !this.isOverlay && this.indexMode);
                }
            }
            this.stepShrinkWrap = true;
            this.doNext();
        }
        catch (OutOfMemoryError err) {
            AppLogger.error((Throwable)err);
        }
    }

    private int getMaskValue(int locX, int locY, int locZ) {
        if (locX < 0 || locX >= this.xSteps || locY < 0 || locY >= this.ySteps || locZ < 0 || locZ >= this.zSteps) {
            return 0;
        }
        return this.mask.get(locZ * this.xSteps * this.ySteps + locY * this.xSteps + locX);
    }

    private ImageBounds getSectionBounds(int index) {
        if (index == 7) {
            return new ImageBounds(-1, this.xSteps - 1, -1, this.ySteps - 1, -1, this.zSteps / 8 + 1);
        }
        if (index == 6) {
            return new ImageBounds(-1, this.xSteps - 1, -1, this.ySteps - 1, this.zSteps / 8 - 1, this.zSteps / 8 * 2 + 1);
        }
        if (index == 5) {
            return new ImageBounds(-1, this.xSteps - 1, -1, this.ySteps - 1, this.zSteps / 8 * 2 - 1, this.zSteps / 8 * 3 + 1);
        }
        if (index == 4) {
            return new ImageBounds(-1, this.xSteps - 1, -1, this.ySteps - 1, this.zSteps / 8 * 3 - 1, this.zSteps / 8 * 4 + 1);
        }
        if (index == 3) {
            return new ImageBounds(-1, this.xSteps - 1, -1, this.ySteps - 1, this.zSteps / 8 * 4 - 1, this.zSteps / 8 * 5 + 1);
        }
        if (index == 2) {
            return new ImageBounds(-1, this.xSteps - 1, -1, this.ySteps - 1, this.zSteps / 8 * 5 - 1, this.zSteps / 8 * 6 + 1);
        }
        if (index == 1) {
            return new ImageBounds(-1, this.xSteps - 1, -1, this.ySteps - 1, this.zSteps / 8 * 6 - 1, this.zSteps / 8 * 7 + 1);
        }
        if (index == 0) {
            return new ImageBounds(-1, this.xSteps - 1, -1, this.ySteps - 1, this.zSteps / 8 * 7 - 1, this.zSteps - 1);
        }
        return new ImageBounds(-1, this.xSteps - 1, -1, this.ySteps - 1, -1, this.zSteps - 1);
    }

    private float getValue(int locX, int locY, int locZ, boolean isUseNegative) {
        if (locX < 0 || locX >= this.xSteps || locY < 0 || locY >= this.ySteps || locZ < 0 || locZ >= this.zSteps) {
            if (this.isROI || this.isLogical) {
                return 0.0f;
            }
            if (isUseNegative) {
                return 0.0f;
            }
            return (float)this.renderVolume.getImageMin();
        }
        if (this.indexMode && !this.isOverlay) {
            if (this.isROI || this.isLogical) {
                return (float)this.renderVolume.getVoxelValueAtIndexTemp(locX, locY, locZ, false);
            }
            if (this.sameDimensions) {
                return (float)this.renderVolume.getVoxelValueAtIndexTemp(locX, locY, locZ, true);
            }
            if (this.isWorldMode) {
                this.tempCoor.setValues((double)locX, (double)locY, (double)locZ);
                this.volData.convertIndexToWorldCoordinate(this.tempCoor);
                return (float)this.renderVolume.getVoxelValueAtCoordinateTemp(this.tempCoor.xDbl, this.tempCoor.yDbl, this.tempCoor.zDbl, this.isOverlay, true);
            }
            return (float)this.renderVolume.getVoxelValueAtMMTemp((float)locX * this.xRes, (float)locY * this.yRes, (float)locZ * this.zRes, true, this.isOverlay);
        }
        if (this.isROI || this.isLogical) {
            return (float)this.renderVolume.getVoxelValueAtMMTemp((float)locX * this.xRes, (float)locY * this.yRes, (float)locZ * this.zRes, false);
        }
        if (!this.isOverlay) {
            return (float)this.renderVolume.getVoxelValueAtMMTemp((float)locX * this.xRes, (float)locY * this.yRes, (float)locZ * this.zRes, true);
        }
        if (this.isWorldMode) {
            return (float)this.renderVolume.getVoxelValueAtCoordinateTemp((float)locX * this.xRes - (float)this.origin.xInt * this.xSize, (float)this.origin.yInt * this.ySize - (float)locY * this.yRes, (float)this.origin.zInt * this.zSize - (float)locZ * this.zRes, this.isOverlay, true);
        }
        return (float)this.renderVolume.getVoxelValueAtMMTemp((float)locX * this.xRes, (float)locY * this.yRes, (float)locZ * this.zRes, true, this.isOverlay);
    }

    private void processOctant(TriangleData triData) {
        if (triData != null) {
            this.runDecimation(triData);
        }
    }

    private TriangleData renderOctant(int index, int threadIndex, int processId, int numProcesses) {
        TriangleData triData;
        this.allTriData[index] = triData = new TriangleData(index);
        MarchingCubesRenderer mcr = new MarchingCubesRenderer();
        ImageBounds octantBounds = this.getSectionBounds(index);
        int xMin = octantBounds.getMinX();
        int xMax = octantBounds.getMaxX();
        int yMin = octantBounds.getMinY();
        int yMax = octantBounds.getMaxY();
        int zMin = octantBounds.getMinZ();
        int zMax = octantBounds.getMaxZ();
        float xHalf = (float)this.xSteps * this.xRes / 2.0f;
        float yHalf = (float)this.ySteps * this.yRes / 2.0f;
        float zHalf = (float)this.zSteps * this.zRes / 2.0f;
        boolean useShrinkWrap = this.params.isUseShrinkWrap();
        boolean useNegative = this.params.isUseNegative();
        int nearEdge = 4;
        Cube cube = new Cube();
        Point3f[] triangleGeom = null;
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            float zLoc = (float)ctrZ * this.zRes - zHalf;
            float zLocPlus = (float)(ctrZ + 1) * this.zRes - zHalf;
            if (threadIndex == 0) {
                float processRatio = 1.0f / (float)numProcesses;
                float progress = (float)(ctrZ - zMin) / (float)(zMax - zMin) * processRatio + (float)processId * processRatio;
                this.setRenderProgress(Math.round(progress * 100.0f));
            }
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                float yLoc = (float)ctrY * this.yRes - yHalf;
                float yLocPlus = (float)(ctrY + 1) * this.yRes - yHalf;
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    boolean isNearEdge;
                    float xLoc = (float)ctrX * this.xRes - xHalf;
                    float xLocPlus = (float)(ctrX + 1) * this.xRes - xHalf;
                    boolean isOctantBoundary = ctrZ == zMin || ctrZ == zMax;
                    boolean bl = isNearEdge = Math.abs(ctrZ - zMin) < 4 || Math.abs(ctrZ - zMax) < 4;
                    if (ctrX == xMin) {
                        cube.values[0] = this.getValue(ctrX, ctrY, ctrZ + 1, useNegative);
                        cube.values[3] = this.getValue(ctrX, ctrY, ctrZ, useNegative);
                        cube.values[4] = this.getValue(ctrX, ctrY + 1, ctrZ + 1, useNegative);
                        cube.values[7] = this.getValue(ctrX, ctrY + 1, ctrZ, useNegative);
                        if (useShrinkWrap) {
                            cube.maskValues[0] = this.getMaskValue(ctrX, ctrY, ctrZ + 1);
                            cube.maskValues[3] = this.getMaskValue(ctrX, ctrY, ctrZ);
                            cube.maskValues[4] = this.getMaskValue(ctrX, ctrY + 1, ctrZ + 1);
                            cube.maskValues[7] = this.getMaskValue(ctrX, ctrY + 1, ctrZ);
                        }
                    } else {
                        cube.values[0] = cube.values[1];
                        cube.values[3] = cube.values[2];
                        cube.values[4] = cube.values[5];
                        cube.values[7] = cube.values[6];
                        if (useShrinkWrap) {
                            cube.maskValues[0] = cube.maskValues[1];
                            cube.maskValues[3] = cube.maskValues[2];
                            cube.maskValues[4] = cube.maskValues[5];
                            cube.maskValues[7] = cube.maskValues[6];
                        }
                    }
                    cube.values[1] = this.getValue(ctrX + 1, ctrY, ctrZ + 1, useNegative);
                    cube.values[2] = this.getValue(ctrX + 1, ctrY, ctrZ, useNegative);
                    cube.values[5] = this.getValue(ctrX + 1, ctrY + 1, ctrZ + 1, useNegative);
                    cube.values[6] = this.getValue(ctrX + 1, ctrY + 1, ctrZ, useNegative);
                    if (useShrinkWrap) {
                        cube.maskValues[1] = this.getMaskValue(ctrX + 1, ctrY, ctrZ + 1);
                        cube.maskValues[2] = this.getMaskValue(ctrX + 1, ctrY, ctrZ);
                        cube.maskValues[5] = this.getMaskValue(ctrX + 1, ctrY + 1, ctrZ + 1);
                        cube.maskValues[6] = this.getMaskValue(ctrX + 1, ctrY + 1, ctrZ);
                    }
                    cube.points[0].x = xLoc;
                    cube.points[0].y = yLoc;
                    cube.points[0].z = zLocPlus;
                    cube.points[1].x = xLocPlus;
                    cube.points[1].y = yLoc;
                    cube.points[1].z = zLocPlus;
                    cube.points[3].x = xLoc;
                    cube.points[3].y = yLoc;
                    cube.points[3].z = zLoc;
                    cube.points[2].x = xLocPlus;
                    cube.points[2].y = yLoc;
                    cube.points[2].z = zLoc;
                    cube.points[4].x = xLoc;
                    cube.points[4].y = yLocPlus;
                    cube.points[4].z = zLocPlus;
                    cube.points[5].x = xLocPlus;
                    cube.points[5].y = yLocPlus;
                    cube.points[5].z = zLocPlus;
                    cube.points[7].x = xLoc;
                    cube.points[7].y = yLocPlus;
                    cube.points[7].z = zLoc;
                    cube.points[6].x = xLocPlus;
                    cube.points[6].y = yLocPlus;
                    cube.points[6].z = zLoc;
                    triangleGeom = useNegative ? mcr.polygonize(cube, -3.4028235E38f, this.threshold, useShrinkWrap) : mcr.polygonize(cube, this.threshold, useShrinkWrap);
                    if (triangleGeom == null) continue;
                    for (int ctr = 0; ctr < triangleGeom.length; ctr += 3) {
                        if (triangleGeom[ctr] == null) continue;
                        TriangleVertex vert1 = null;
                        if (triData.containsVertex(triangleGeom[ctr])) {
                            vert1 = triData.getVertex(triangleGeom[ctr]);
                        } else {
                            vert1 = new TriangleVertex(new Point3f(triangleGeom[ctr]));
                            triData.addVertex(vert1.point, vert1);
                        }
                        TriangleVertex vert2 = null;
                        if (triData.containsVertex(triangleGeom[ctr + 1])) {
                            vert2 = triData.getVertex(triangleGeom[ctr + 1]);
                        } else {
                            vert2 = new TriangleVertex(new Point3f(triangleGeom[ctr + 1]));
                            triData.addVertex(vert2.point, vert2);
                        }
                        TriangleVertex vert3 = null;
                        if (triData.containsVertex(triangleGeom[ctr + 2])) {
                            vert3 = triData.getVertex(triangleGeom[ctr + 2]);
                        } else {
                            vert3 = new TriangleVertex(new Point3f(triangleGeom[ctr + 2]));
                            triData.addVertex(vert3.point, vert3);
                        }
                        Triangle triangle = new Triangle(vert1, vert2, vert3);
                        vert1.setOctantBoundary(isOctantBoundary);
                        vert2.setOctantBoundary(isOctantBoundary);
                        vert3.setOctantBoundary(isOctantBoundary);
                        vert1.setNearOctantEdge(isNearEdge);
                        vert2.setNearOctantEdge(isNearEdge);
                        vert3.setNearOctantEdge(isNearEdge);
                        triData.addTriangle(triangle);
                        vert1.addTriangle(triangle);
                        vert2.addTriangle(triangle);
                        vert3.addTriangle(triangle);
                    }
                }
            }
        }
        return triData;
    }

    private void runDecimation(TriangleData data) {
        for (int ctr = 0; ctr < this.params.getNumSmoothingIterations(); ++ctr) {
            data.decimate(this.params.getFeatureError(), this.params.convertFeatureAngle(), this.averageVoxelSize, ctr);
        }
    }

    private synchronized void setRenderProgress(final int val) {
        if (this.progressBar != null) {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (val >= 95) {
                        SurfaceFactory.this.progressBar.setIndeterminateMode(true);
                    } else {
                        SurfaceFactory.this.progressBar.setValue(val);
                    }
                }
            });
        }
    }

    private void startRender() {
        this.building = true;
        this.allTriData = new TriangleData[8];
        this.composite = new CompositeSurface(1, this.name);
        if (this.progressBar != null) {
            this.progressBar = this.viewer.makeProgressMeter();
            this.progressBar.setDescription("Building Surface");
            this.progressBar.start(0, 0, 101, true);
        }
        OctantBuilder builder = new OctantBuilder(this, false);
        builder.setSync(this.sameThread);
        builder.start();
    }

    public boolean isSameThread() {
        return this.sameThread;
    }

    public void setSameThread(boolean sameThread) {
        this.sameThread = sameThread;
    }
}

