/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.operations.building;

import edu.uthscsa.ric.volume.ImageVolume;
import java.io.Serializable;

public class SurfaceBuildParameters
implements Serializable {
    private boolean useImageSmoothing = true;
    private boolean useNegative;
    private boolean usePercentMax;
    private boolean useShrinkWrap;
    private boolean useSurfaceSmoothing = true;
    private float featureAngle;
    private float featureError;
    private float resX;
    private float resY;
    private float resZ;
    private float smoothingWidth;
    private float threshold;
    private int smoothingKernel;
    private int surfaceSmoothingIterations;
    private long buildTime;
    private static final long serialVersionUID = 1L;
    public static final float FEATURE_ANGLE_DEFAULT_STANDARD = 44.0f;
    public static final float FILTER_FWHM_DEFAULT_STANDARD = 2.0f;
    public static final int FILTER_SIZE_DEFAULT_STANDARD = 3;
    public static final int SMOOTH_ITERATIONS_DEFAULT = 1;

    public SurfaceBuildParameters(ImageVolume volume) {
        this.resX = (float)volume.getXSize();
        this.resY = (float)volume.getYSize();
        this.resZ = (float)volume.getZSize();
        this.smoothingWidth = 2.0f;
        this.smoothingKernel = 3;
        this.featureAngle = 44.0f;
        this.surfaceSmoothingIterations = 1;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public float getFeatureAngle() {
        return this.featureAngle;
    }

    public float getFeatureError() {
        return this.featureError;
    }

    public float getFilterFWHM() {
        return this.smoothingWidth;
    }

    public int getFilterSize() {
        return this.smoothingKernel / 2 * 2 + 1;
    }

    public int getNumSmoothingIterations() {
        return this.useSurfaceSmoothing ? this.surfaceSmoothingIterations : 0;
    }

    public float getResX() {
        return this.resX;
    }

    public float getResY() {
        return this.resY;
    }

    public float getResZ() {
        return this.resZ;
    }

    public int getSmoothingKernel() {
        return this.smoothingKernel;
    }

    public float getSmoothingWidth() {
        return this.smoothingWidth;
    }

    public int getSurfaceSmoothingIterations() {
        return this.surfaceSmoothingIterations;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public boolean isUseImageSmoothing() {
        return this.useImageSmoothing;
    }

    public boolean isUseNegative() {
        return this.useNegative;
    }

    public boolean isUseShrinkWrap() {
        return this.useShrinkWrap;
    }

    public boolean isUseSurfaceSmoothing() {
        return this.useSurfaceSmoothing;
    }

    public void setBuildTime(long buildTime) {
        this.buildTime = buildTime;
    }

    public void setFeatureAngle(float featureAngle) {
        this.featureAngle = featureAngle;
    }

    public void setFeatureError(float featureError) {
        this.featureError = featureError;
    }

    public void setResX(float resX) {
        this.resX = resX;
    }

    public void setResY(float resY) {
        this.resY = resY;
    }

    public void setResZ(float resZ) {
        this.resZ = resZ;
    }

    public void setSmoothingKernel(int smoothingKernel) {
        this.smoothingKernel = smoothingKernel;
    }

    public void setSmoothingWidth(float smoothingWidth) {
        this.smoothingWidth = smoothingWidth;
    }

    public void setSurfaceSmoothingIterations(int surfaceSmoothingIterations) {
        this.surfaceSmoothingIterations = surfaceSmoothingIterations;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public void setUseImageSmoothing(boolean useImageSmoothing) {
        this.useImageSmoothing = useImageSmoothing;
    }

    public void setUseNegative(boolean useNegative) {
        this.useNegative = useNegative;
    }

    public void setUseShrinkWrap(boolean useShrinkWrap) {
        this.useShrinkWrap = useShrinkWrap;
    }

    public void setUseSurfaceSmoothing(boolean useSurfaceSmoothing) {
        this.useSurfaceSmoothing = useSurfaceSmoothing;
    }

    protected float convertFeatureAngle() {
        return (float)((double)Math.max(0.0f, Math.min(this.featureAngle, 180.0f)) * (Math.PI / 180));
    }

    protected boolean useFilter() {
        return this.useImageSmoothing && this.getFilterFWHM() > 0.0f && this.getFilterSize() >= 3;
    }

    public boolean isUsePercentMax() {
        return this.usePercentMax;
    }

    public void setUsePercentMax(boolean usePercentMax) {
        this.usePercentMax = usePercentMax;
    }
}

