/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.menus.context;

import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.menus.context.SurfaceContextMenuActions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public final class SurfaceContextMenu
extends JPopupMenu {
    private final SurfaceViewer renderer;
    private final CompositeSurface surface;
    private static SurfaceContextMenu menu;
    private static final long serialVersionUID = 1L;
    public static final Font FONT;

    public static void doPop(SurfaceViewer renderer, CompositeSurface surface, Component comp, Point loc) {
        menu = new SurfaceContextMenu(renderer, surface);
        menu.show(comp, loc.x, loc.y);
    }

    private SurfaceContextMenu(SurfaceViewer renderer, CompositeSurface surface) {
        this.renderer = renderer;
        this.surface = surface;
        this.add(this.makeMenuItem("Measure"));
        if (!surface.isBaseSurface()) {
            this.add(new JToolBar.Separator(new Dimension(0, 6)));
            this.add(this.makeMenuItem("Hide"));
            this.add(this.makeMenuItem("Remove"));
        }
    }

    private JMenuItem makeMenuItem(String actionName) {
        JMenuItem menuItem = new JMenuItem(new SurfaceContextMenuActions(this.renderer, this.surface, actionName));
        menuItem.setFont(FONT);
        return menuItem;
    }

    static {
        FONT = new Font("SansSerif", 0, 11);
    }
}

