/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.menus;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.dialogs.snapshot.Snapshot;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalPanel;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewersurface.SurfacePosition;
import edu.uthscsa.ric.mango.viewersurface.SurfacePreferences;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.core.Marker;
import edu.uthscsa.ric.mango.viewersurface.core.MarkerLine;
import edu.uthscsa.ric.mango.viewersurface.dialogs.cine.CineSurface;
import edu.uthscsa.ric.mango.viewersurface.dialogs.modal.BackgroundDialog;
import edu.uthscsa.ric.mango.viewersurface.dialogs.modal.BuildSurfaceDialog;
import edu.uthscsa.ric.mango.viewersurface.dialogs.modal.LightingDialog;
import edu.uthscsa.ric.mango.viewersurface.dialogs.modal.MaterialDialog;
import edu.uthscsa.ric.mango.viewersurface.dialogs.modal.TransformDialog;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceBuildParameters;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceFactory;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceReader;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.gifti.GiftiFormat;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.mango.MangoFormat;
import edu.uthscsa.ric.mango.viewersurface.screen.Lighting;
import edu.uthscsa.ric.mango.viewersurface.screen.Material;
import edu.uthscsa.ric.mango.viewersurface.window.SurfaceFrame;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.visualization.surface.SurfaceController;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.volume.Volume;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SurfaceViewerMenuAction
extends AbstractAction {
    private final SurfaceViewer renderer;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_CANCEL = "Cancel";
    public static final String ACTION_DEFAULT = "Default";
    public static final String ACTION_LINE = "Line";
    public static final String FILE_EXPORT_AS = "Export As";
    public static final String FILE_IMPORT_AS = "Import As";
    public static final String FILE_INFO = "Surface Info";
    public static final String FILE_SAVE_AS = "Save As...";
    public static final String PLUGINS_DO = "Plugin|";
    public static final String PLUGINS_GET_MORE = "Get More Plugins...";
    public static final String SHAPES_HIDE = "Hide Shape";
    public static final String SHAPES_HIDE_ALL = "Hide All";
    public static final String SHAPES_LOAD = "Load from File...";
    public static final String SHAPES_LOGICAL = "Add Logical...";
    public static final String SHAPES_MARKERLINE_GOTO_NEXT = "MarkerLine Goto Next";
    public static final String SHAPES_MARKERLINE_HIDE = "MarkerLine Hide";
    public static final String SHAPES_MARKERLINE_LINE_TO = "MarkerLine Line To";
    public static final String SHAPES_MARKERLINE_LINE_TO_CURRENT = "MarkerLine Line To Current";
    public static final String SHAPES_MARKERLINE_MEASURE = "MarkerLine Measure";
    public static final String SHAPES_MARKERLINE_REMOVE = "MarkerLine Remove";
    public static final String SHAPES_MARKER_GOTO = "Marker Goto";
    public static final String SHAPES_MARKER_HIDE = "Marker Hide";
    public static final String SHAPES_MARKER_LINE_TO = "Marker Line To";
    public static final String SHAPES_MARKER_LINE_TO_CURRENT = "Marker Line To Current";
    public static final String SHAPES_MARKER_REMOVE = "Marker Remove";
    public static final String SHAPES_MARKER_SURFACE_TO = "Marker Surface To";
    public static final String SHAPES_MATERIAL = "Material Shape";
    public static final String SHAPES_MEASURE_ALL = "Measure All";
    public static final String SHAPES_MEASURE = "Measure";
    public static final String SHAPES_OVERLAY = "Add Overlay...";
    public static final String SHAPES_REMOVE = "Remove Shape";
    public static final String SHAPES_REMOVE_ALL = "Remove All";
    public static final String SHAPES_ROI = "Add ROI...";
    public static final String SHAPES_TRANSFORM = "Transform";
    public static final String SURFACE_ALL_CUT_PLANES = "All Cut Planes";
    public static final String SURFACE_ANIMATE = "Animate";
    public static final String SURFACE_APPEARANCE_BACKGROUND = "Background...";
    public static final String SURFACE_APPEARANCE_LIGHTING = "Lighting...";
    public static final String SURFACE_APPEARANCE_MATERIAL = "Material...";
    public static final String SURFACE_APPEARANCE_TRANSFORM = "Transform...";
    public static final String SURFACE_AXIAL_CUT_PLANE_INF = "Inferior";
    public static final String SURFACE_AXIAL_CUT_PLANE_SUP = "Superior";
    public static final String SURFACE_CINE = "Create Video...";
    public static final String SURFACE_CORONAL_CUT_PLANE_ANT = "Anterior";
    public static final String SURFACE_CORONAL_CUT_PLANE_POS = "Posterior";
    public static final String SURFACE_MEASURE = "Surface Measure";
    public static final String SURFACE_OBLIQUE_CUT_PLANE = "Oblique Cut Plane";
    public static final String SURFACE_POSITION_ANTERIOR = "View Anterior";
    public static final String SURFACE_POSITION_DEFAULT = "Default";
    public static final String SURFACE_POSITION_GOTO = "Go To Saved";
    public static final String SURFACE_POSITION_INFERIOR = "View Inferior";
    public static final String SURFACE_POSITION_LEFT = "View Left";
    public static final String SURFACE_POSITION_POSTERIOR = "View Posterior";
    public static final String SURFACE_POSITION_RIGHT = "View Right";
    public static final String SURFACE_POSITION_SAVE = "Save";
    public static final String SURFACE_POSITION_SUPERIOR = "View Superior";
    public static final String SURFACE_SAGITTAL_CUT_PLANE_LEFT = "Left";
    public static final String SURFACE_SAGITTAL_CUT_PLANE_RIGHT = "Right";
    public static final String SURFACE_SNAPSHOT = "Create Snapshot...";
    public static final String VIEW_ALL_SLICE_PLANES = "All Slice Planes";
    public static final String VIEW_CROSSHAIRS = "Crosshairs";
    public static final String VIEW_MAIN_SLICE_PLANE = "Main Slice Plane";
    public static final String VIEW_ORIENTATION = "Orientation";
    public static final String VIEW_RULER = "Ruler";
    public static final String VIEW_ANGLE = "Angle";
    public static final String VIEW_POSITION = "Position";
    public static final String VIEW_SHAPES = "Shapes";
    public static final String VIEW_SLICES = "Slices";
    public static final String VIEW_ROIS = "ROIs";
    public static final String VIEW_SURFACE = "Surface";
    public static final String WINDOW_MAXIMIZE = "Maximize";
    public static final String WINDOW_MINIMIZE = "Dock";
    public static final String WINDOW_STICKY = "Stick to Slice Viewer";
    public static final String WINDOW_ZOOM_IN = "Zoom In";
    public static final String WINDOW_ZOOM_OUT = "Zoom Out";

    private static File makeOpenFileChooser(String[] extensions, String dir, String description, Frame frame) {
        return OpenFileDialog.showOpenFileChooser(frame, dir, extensions, description);
    }

    private static File makeSaveFileChooser(String dir, String filename, Frame frame) {
        return SaveFileDialog.showSaveFileChooser(frame, dir, filename);
    }

    public SurfaceViewerMenuAction(String actionCommand, SurfaceViewer renderer) {
        super(actionCommand);
        this.renderer = renderer;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        this.actionPerformed(actionCommand);
    }

    public void actionPerformed(String actionCommand) {
        if (actionCommand.equals("Default")) {
            this.renderer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Default")});
            this.renderer.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.DEFAULT_ROTATION));
        } else if (actionCommand.equals(SURFACE_POSITION_SUPERIOR)) {
            this.renderer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString(SURFACE_POSITION_SUPERIOR)});
            this.renderer.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.SUPERIOR_ROTATION));
        } else if (actionCommand.equals(SURFACE_POSITION_INFERIOR)) {
            this.renderer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString(SURFACE_POSITION_INFERIOR)});
            this.renderer.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.INFERIOR_ROTATION));
        } else if (actionCommand.equals(SURFACE_POSITION_ANTERIOR)) {
            this.renderer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString(SURFACE_POSITION_ANTERIOR)});
            this.renderer.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.ANTERIOR_ROTATION));
        } else if (actionCommand.equals(SURFACE_POSITION_POSTERIOR)) {
            this.renderer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString(SURFACE_POSITION_POSTERIOR)});
            this.renderer.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.POSTERIOR_ROTATION));
        } else if (actionCommand.equals(SURFACE_POSITION_LEFT)) {
            this.renderer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString(SURFACE_POSITION_LEFT)});
            this.renderer.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.LEFT_ROTATION));
        } else if (actionCommand.equals(SURFACE_POSITION_RIGHT)) {
            this.renderer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString(SURFACE_POSITION_RIGHT)});
            this.renderer.goToPosition(CollectionUtilities.arrayDoubles(SurfacePosition.RIGHT_ROTATION));
        } else if (actionCommand.equals(SURFACE_POSITION_SAVE)) {
            this.renderer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString(SURFACE_POSITION_SAVE)});
            this.renderer.savePosition();
        } else if (actionCommand.equals(SURFACE_POSITION_GOTO)) {
            this.renderer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString(SURFACE_POSITION_GOTO)});
            this.renderer.goToSavedPosition();
        } else if (actionCommand.equals(VIEW_CROSSHAIRS)) {
            this.renderer.setViewOptionCrosshairs(!this.renderer.getPreferences().isShowCrosshairs());
        } else if (actionCommand.equals(VIEW_ALL_SLICE_PLANES)) {
            this.renderer.setViewOptionShowAllSlicePlanes(this.renderer.getPreferences().getShowActivePlanes() != 2);
        } else if (actionCommand.equals(VIEW_MAIN_SLICE_PLANE)) {
            this.renderer.setViewOptionShowMainSlicePlanes(this.renderer.getPreferences().getShowActivePlanes() != 1);
        } else if (actionCommand.equals(SURFACE_AXIAL_CUT_PLANE_SUP)) {
            this.renderer.setSurfaceOptionAxialSuperiorCutPlane(this.renderer.getPreferences().getAxialCutPlane() != -1);
        } else if (actionCommand.equals(SURFACE_AXIAL_CUT_PLANE_INF)) {
            this.renderer.setSurfaceOptionAxialInferiorCutPlane(this.renderer.getPreferences().getAxialCutPlane() != 1);
        } else if (actionCommand.equals(SURFACE_CORONAL_CUT_PLANE_ANT)) {
            this.renderer.setSurfaceOptionCoronalAnteriorCutPlane(this.renderer.getPreferences().getCoronalCutPlane() != 1);
        } else if (actionCommand.equals(SURFACE_CORONAL_CUT_PLANE_POS)) {
            this.renderer.setSurfaceOptionCoronalPosteriorCutPlane(this.renderer.getPreferences().getCoronalCutPlane() != -1);
        } else if (actionCommand.equals(SURFACE_SAGITTAL_CUT_PLANE_LEFT)) {
            this.renderer.setSurfaceOptionSagittalLeftCutPlane(this.renderer.getPreferences().getSagittalCutPlane() != -1);
        } else if (actionCommand.equals(SURFACE_SAGITTAL_CUT_PLANE_RIGHT)) {
            this.renderer.setSurfaceOptionSagittalRightCutPlane(this.renderer.getPreferences().getSagittalCutPlane() != 1);
        } else if (actionCommand.equals(SURFACE_OBLIQUE_CUT_PLANE)) {
            this.renderer.showObliquePlaneDialog(!this.renderer.getPreferences().isUsingObliqueCutPlane());
        } else if (actionCommand.equals(SURFACE_ALL_CUT_PLANES)) {
            SurfacePreferences viewPrefs = this.renderer.getPreferences();
            this.renderer.setSurfaceOptionAllCutPlanes(!viewPrefs.isUsingAxialCutPlane() || !viewPrefs.isUsingCoronalCutPlane() || !viewPrefs.isUsingSagittalCutPlane());
        } else if (actionCommand.equals(SURFACE_APPEARANCE_BACKGROUND)) {
            this.showBackgroundDialog();
        } else if (actionCommand.equals(SURFACE_APPEARANCE_LIGHTING)) {
            this.showLightingDialog();
        } else if (actionCommand.equals(SURFACE_APPEARANCE_MATERIAL)) {
            this.showMaterialDialog(this.renderer.getBaseSurface());
        } else if (actionCommand.equals(SURFACE_APPEARANCE_TRANSFORM)) {
            this.showTransformDialog();
        } else if (actionCommand.equals(WINDOW_MAXIMIZE)) {
            this.renderer.selectWindowMenuOptionMaximize();
        } else if (actionCommand.equals(WINDOW_MINIMIZE)) {
            this.renderer.selectWindowMenuOptionMinimize();
        } else if (actionCommand.equals(WINDOW_ZOOM_IN)) {
            this.renderer.selectWindowMenuOptionZoomIn();
        } else if (actionCommand.equals(WINDOW_ZOOM_OUT)) {
            this.renderer.selectWindowMenuOptionZoomOut();
        } else if (actionCommand.equals(WINDOW_STICKY)) {
            this.renderer.getViewer().getViewerFrame().addStickyWindow(this.renderer);
            SurfaceFrame frame = this.renderer.getFrame();
            this.renderer.setWindowMenuOptionStick(!frame.isSticky());
        } else if (actionCommand.equals(VIEW_ORIENTATION)) {
            this.renderer.setViewOptionOrientation(!this.renderer.getPreferences().isShowOrientation());
        } else if (actionCommand.equals(VIEW_RULER)) {
            this.renderer.setViewOptionRuler(!this.renderer.getPreferences().isShowRuler());
        } else if (actionCommand.equals(VIEW_ANGLE)) {
            this.renderer.setViewOptionAngle(!this.renderer.getPreferences().isShowAngle());
        } else if (actionCommand.equals(VIEW_POSITION)) {
            this.renderer.setViewOptionPosition(!this.renderer.getPreferences().isShowPosition());
        } else if (actionCommand.equals(VIEW_SURFACE)) {
            this.renderer.setViewOptionSurface(!this.renderer.getBaseSurface().isHidden());
        } else if (actionCommand.equals(VIEW_SLICES)) {
            this.renderer.setViewOptionSlices(!this.renderer.getPreferences().isShowSlices());
        } else if (actionCommand.equals(VIEW_ROIS)) {
            this.renderer.setViewOptionROIs(!this.renderer.getPreferences().isShowDynamicROI());
        } else if (actionCommand.equals(SHAPES_LOAD)) {
            this.loadShapeFromFile();
        } else if (actionCommand.equals("Import AsGIFTI Labels")) {
            this.loadColorsFromGIFTILabelFile();
        } else if (actionCommand.equals("Import AsGIFTI RGBA")) {
            this.loadColorsFromGIFTIRGBAFile();
        } else if (actionCommand.equals(SHAPES_OVERLAY)) {
            final BuildSurfaceDialog dialog = new BuildSurfaceDialog(this.renderer.getViewer());
            dialog.createOverlayPanel();
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.renderer.getFrame(), (Object)dialog, "Add Overlay", -1);
            dialog.setDialog(jopf);
            final JOptionPane jop = jopf.getJOptionPane();
            JButton buttonAdd = new JButton("Add");
            buttonAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (dialog.passZeroThresholdCheck()) {
                        jop.setValue(0);
                        jop.setVisible(false);
                    }
                }
            });
            JButton buttonAddAll = new JButton("Add All");
            buttonAddAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (dialog.passZeroThresholdCheck()) {
                        jop.setValue(2);
                        jop.setVisible(false);
                        SurfaceViewerMenuAction.this.addAllOverlays(dialog.getBuildParameters());
                    }
                }
            });
            Object[] options = new Object[]{buttonAdd, buttonAddAll};
            jopf.setOptions(options);
            jopf.setInitialValue(buttonAdd);
            int selection = jopf.show();
            if (selection == 0) {
                SurfaceBuildParameters params = dialog.getBuildParameters();
                this.renderer.recordAction("addShapeFromOverlay", new String[]{null, ScriptUtils.convertString("Overlay"), String.valueOf(dialog.getSolidColor().getRGB()), String.valueOf(params.getThreshold()), ScriptUtils.convertBoolean(params.isUseShrinkWrap()), ScriptUtils.convertBoolean(params.isUseNegative()), ScriptUtils.convertBoolean(params.isUseImageSmoothing()), String.valueOf(params.getFilterFWHM()), String.valueOf(params.getFilterSize()), String.valueOf(params.getResX()), String.valueOf(params.getResY()), String.valueOf(params.getResZ()), ScriptUtils.convertBoolean(params.isUseSurfaceSmoothing()), String.valueOf(params.getFeatureError()), String.valueOf(params.getFeatureAngle()), String.valueOf(params.getNumSmoothingIterations())}, true);
                Volume overlay = this.renderer.getViewer().getOverlayManager().getOverlay(dialog.getOverlayIndex()).getVolume();
                SurfaceFactory factory = new SurfaceFactory(params, this.renderer.getViewer().getVolume());
                factory.createOverlaySurface(this.renderer, overlay, dialog.getShapeName(), dialog.getSolidColor());
            }
        } else if (actionCommand.equals(SHAPES_LOGICAL)) {
            final BuildSurfaceDialog dialog = new BuildSurfaceDialog(this.renderer.getViewer());
            dialog.createLogicalPanel();
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.renderer.getFrame(), (Object)dialog, "Add Logical", -1);
            dialog.setDialog(jopf);
            final JOptionPane jop = jopf.getJOptionPane();
            JButton buttonAdd = new JButton("Add");
            buttonAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (dialog.passZeroThresholdCheck()) {
                        jop.setValue(0);
                        jop.setVisible(false);
                    }
                }
            });
            JButton buttonAddAll = new JButton("Add All");
            buttonAddAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (dialog.passZeroThresholdCheck()) {
                        jop.setValue(2);
                        jop.setVisible(false);
                        SurfaceViewerMenuAction.this.addAllLogicals(dialog.getBuildParameters());
                    }
                }
            });
            Object[] options = new Object[]{buttonAdd, buttonAddAll};
            jopf.setOptions(options);
            jopf.setInitialValue(buttonAdd);
            int selection = jopf.show();
            if (selection == 0) {
                SurfaceBuildParameters params = dialog.getBuildParameters();
                this.renderer.recordAction("addShapeFromLogical", new String[]{null, ScriptUtils.convertString("Logical"), String.valueOf(dialog.getSolidColor().getRGB()), String.valueOf(params.getThreshold()), ScriptUtils.convertBoolean(params.isUseShrinkWrap()), ScriptUtils.convertBoolean(params.isUseNegative()), ScriptUtils.convertBoolean(params.isUseImageSmoothing()), String.valueOf(params.getFilterFWHM()), String.valueOf(params.getFilterSize()), String.valueOf(params.getResX()), String.valueOf(params.getResY()), String.valueOf(params.getResZ()), ScriptUtils.convertBoolean(params.isUseSurfaceSmoothing()), String.valueOf(params.getFeatureError()), String.valueOf(params.getFeatureAngle()), String.valueOf(params.getNumSmoothingIterations())}, true);
                SurfaceFactory factory = new SurfaceFactory(params, this.renderer.getViewer().getVolume());
                factory.createLogicalSurface(this.renderer, this.renderer.getViewer().getLogicalManager().getLogicalPanels().get(dialog.getOverlayIndex()).getLogical(), dialog.getShapeName(), dialog.getSolidColor());
            }
        } else if (actionCommand.equals(SHAPES_ROI)) {
            final BuildSurfaceDialog dialog = new BuildSurfaceDialog(this.renderer.getViewer());
            dialog.createROIPanel();
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.renderer.getFrame(), (Object)dialog, "Add ROI", -1);
            dialog.setDialog(jopf);
            final JOptionPane jop = jopf.getJOptionPane();
            JButton buttonAdd = new JButton("Add");
            buttonAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (dialog.passZeroThresholdCheck()) {
                        jop.setValue(0);
                        jop.setVisible(false);
                    }
                }
            });
            JButton buttonAddAll = new JButton("Add All");
            buttonAddAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (dialog.passZeroThresholdCheck()) {
                        jop.setValue(2);
                        jop.setVisible(false);
                        SurfaceViewerMenuAction.this.addAllROIs(dialog.getBuildParameters());
                    }
                }
            });
            Object[] options = new Object[]{buttonAdd, buttonAddAll};
            jopf.setOptions(options);
            jopf.setInitialValue(buttonAdd);
            int selection = jopf.show();
            if (selection == 0) {
                SurfaceBuildParameters params = dialog.getBuildParameters();
                this.renderer.recordAction("addShapeFromROI", new String[]{null, ScriptUtils.convertString("ROI"), String.valueOf(dialog.getSolidColor().getRGB()), String.valueOf(params.getThreshold()), ScriptUtils.convertBoolean(params.isUseShrinkWrap()), ScriptUtils.convertBoolean(params.isUseNegative()), ScriptUtils.convertBoolean(params.isUseImageSmoothing()), String.valueOf(params.getFilterFWHM()), String.valueOf(params.getFilterSize()), String.valueOf(params.getResX()), String.valueOf(params.getResY()), String.valueOf(params.getResZ()), ScriptUtils.convertBoolean(params.isUseSurfaceSmoothing()), String.valueOf(params.getFeatureError()), String.valueOf(params.getFeatureAngle()), String.valueOf(params.getNumSmoothingIterations())}, true);
                SurfaceFactory factory = new SurfaceFactory(params, this.renderer.getViewer().getVolume());
                factory.createROISurface(this.renderer, this.renderer.getViewer().getROIManager(), dialog.getROINum(), dialog.getShapeName(), dialog.getSolidColor());
            }
        } else if (actionCommand.startsWith(SHAPES_HIDE)) {
            String hash = actionCommand.substring(SHAPES_HIDE.length());
            CompositeSurface shape = this.renderer.getShape(hash);
            if (shape != null) {
                shape.setHidden(!shape.isHidden());
                this.renderer.updateSurface();
            }
        } else if (actionCommand.startsWith(SHAPES_REMOVE)) {
            String hash = actionCommand.substring(SHAPES_REMOVE.length());
            CompositeSurface shape = this.renderer.getShape(hash);
            if (shape != null) {
                this.renderer.recordAction("removeSurface", new String[]{null}, true);
                this.renderer.removeShape(hash);
            }
        } else if (actionCommand.startsWith(SHAPES_MATERIAL)) {
            String hash = actionCommand.substring(SHAPES_MATERIAL.length());
            CompositeSurface shape = this.renderer.getShape(hash);
            if (shape != null) {
                this.showMaterialDialog(shape);
            }
        } else if (actionCommand.equals(SHAPES_MEASURE_ALL)) {
            this.renderer.recordAction("measureAll");
            Vector<CompositeSurface> shapes = this.renderer.getShapes();
            Collection<MarkerLine> markerLines = this.renderer.getMarkerLines();
            for (CompositeSurface addedShape : shapes) {
                if (addedShape.isBaseSurface()) continue;
                this.renderer.measureSurfaceArea(addedShape);
                this.renderer.measureSurfaceVolume(addedShape);
            }
            for (MarkerLine ml : markerLines) {
                this.renderer.measureLine(ml);
            }
        } else if (actionCommand.startsWith(SHAPES_MEASURE)) {
            String hash = actionCommand.substring(SHAPES_MEASURE.length());
            CompositeSurface shape = this.renderer.getShape(hash);
            if (shape != null) {
                this.renderer.recordAction("runSurfaceAreaStats", new String[]{null}, true);
                this.renderer.recordAction("runSurfaceVolumeStats", new String[]{null}, true);
                this.renderer.measureSurfaceArea(shape);
                this.renderer.measureSurfaceVolume(shape);
            }
        } else if (actionCommand.startsWith(SHAPES_TRANSFORM)) {
            String hash = actionCommand.substring(SHAPES_TRANSFORM.length());
            CompositeSurface shape = this.renderer.getShape(hash);
            if (shape != null) {
                shape.setUseTransform(!shape.isUseTransform());
            }
            this.renderer.updateSurface();
        } else if (actionCommand.startsWith(SHAPES_HIDE_ALL)) {
            this.renderer.hideAll(this.renderer.hasVisibleShapes());
        } else if (actionCommand.startsWith(SHAPES_REMOVE_ALL)) {
            int value = JOptionPane.showConfirmDialog(this.renderer.getFrame(), "Remove all shapes?", "", 0);
            if (value == 0) {
                this.renderer.removeAll();
            }
        } else if (actionCommand.startsWith(SURFACE_MEASURE)) {
            this.renderer.recordAction("runSurfaceAreaStats", new String[]{this.renderer.getViewer().getScriptObjectName() + ".surfaceManager" + ".baseSurface"});
            this.renderer.recordAction("runSurfaceVolumeStats", new String[]{this.renderer.getViewer().getScriptObjectName() + ".surfaceManager" + ".baseSurface"});
            this.renderer.measureSurfaceArea(this.renderer.getBaseSurface());
            this.renderer.measureSurfaceVolume(this.renderer.getBaseSurface());
        } else if (actionCommand.startsWith(SURFACE_CINE)) {
            new CineSurface(this.renderer.getViewer(), this.renderer);
        } else if (actionCommand.startsWith(SURFACE_SNAPSHOT)) {
            new Snapshot(this.renderer.getViewer(), this.renderer);
        } else if (actionCommand.startsWith(VIEW_SHAPES)) {
            this.renderer.setViewOptionShapes(!this.renderer.getPreferences().isShowShapes());
        } else if (actionCommand.startsWith(SHAPES_MARKER_GOTO)) {
            this.renderer.recordAction("goToShape", new String[]{null}, true);
            String markerStr = actionCommand.substring(SHAPES_MARKER_GOTO.length());
            markerStr = markerStr.substring(markerStr.indexOf(32) + 1);
            markerStr = markerStr.substring(0, markerStr.indexOf(32));
            int number = Integer.parseInt(markerStr);
            Marker marker = this.renderer.getMarker(number);
            this.renderer.goToShape(marker);
        } else if (actionCommand.startsWith(SHAPES_MARKER_HIDE)) {
            Marker marker;
            String name = actionCommand.substring(SHAPES_MARKER_HIDE.length());
            name = name.substring(name.indexOf(32) + 1);
            int number = Integer.parseInt(name = name.substring(0, name.indexOf(32)));
            marker.setVisible(!(marker = this.renderer.getMarker(number)).isVisible());
            this.renderer.updateSurface();
        } else if (actionCommand.startsWith(SHAPES_MARKER_REMOVE)) {
            String name = actionCommand.substring(SHAPES_MARKER_REMOVE.length());
            name = name.substring(name.indexOf(32) + 1);
            name = name.substring(0, name.indexOf(32));
            int number = Integer.parseInt(name);
            this.renderer.removeShape(this.renderer.getMarker(number));
        } else if (actionCommand.startsWith(SHAPES_MARKER_LINE_TO_CURRENT)) {
            String markerStr = actionCommand.substring(26);
            markerStr = markerStr.substring(markerStr.indexOf(32) + 1);
            markerStr = markerStr.substring(0, markerStr.indexOf(32));
            int number = Integer.parseInt(markerStr);
            Marker marker = this.renderer.getMarker(number);
            this.renderer.lineToShape(marker, null);
        } else if (actionCommand.startsWith(SHAPES_MARKER_LINE_TO)) {
            String startStr = actionCommand.substring(SHAPES_MARKER_LINE_TO.length(), actionCommand.indexOf(124));
            startStr = startStr.substring(startStr.indexOf(32) + 1);
            startStr = startStr.substring(0, startStr.indexOf(32));
            int startNum = Integer.parseInt(startStr);
            String endStr = actionCommand.substring(actionCommand.indexOf(124) + 1);
            endStr = endStr.substring(endStr.indexOf(32) + 1);
            endStr = endStr.substring(0, endStr.indexOf(32));
            int endNum = Integer.parseInt(endStr);
            Marker start = this.renderer.getMarker(startNum);
            Marker end = this.renderer.getMarker(endNum);
            this.renderer.lineToShape(start, end);
        } else if (actionCommand.startsWith(SHAPES_MARKER_SURFACE_TO)) {
            String startStr = actionCommand.substring(SHAPES_MARKER_SURFACE_TO.length(), actionCommand.indexOf(124));
            startStr = startStr.substring(startStr.indexOf(32) + 1);
            startStr = startStr.substring(0, startStr.indexOf(32));
            int startNum = Integer.parseInt(startStr);
            String endStr = actionCommand.substring(actionCommand.indexOf(124) + 1);
            endStr = endStr.substring(endStr.indexOf(32) + 1);
            endStr = endStr.substring(0, endStr.indexOf(32));
            int endNum = Integer.parseInt(endStr);
            Marker start = this.renderer.getMarker(startNum);
            Marker end = this.renderer.getMarker(endNum);
            this.renderer.surfaceToShape(start, end);
        } else if (actionCommand.startsWith(SHAPES_MARKERLINE_GOTO_NEXT)) {
            this.renderer.recordAction("goToShape", new String[]{null}, true);
            String markerStr = actionCommand.substring(actionCommand.lastIndexOf(ACTION_LINE) + 4);
            markerStr = markerStr.substring(markerStr.indexOf(32) + 1);
            markerStr = markerStr.substring(0, markerStr.indexOf(32));
            int num = Integer.parseInt(markerStr);
            MarkerLine ml = this.renderer.getMarkerLine(num);
            this.renderer.goToShape(ml);
        } else if (actionCommand.startsWith(SHAPES_MARKERLINE_HIDE)) {
            MarkerLine marker;
            String name = actionCommand.substring(actionCommand.lastIndexOf(ACTION_LINE) + 4);
            name = name.substring(name.indexOf(32) + 1);
            int number = Integer.parseInt(name = name.substring(0, name.indexOf(32)));
            marker.setVisible(!(marker = this.renderer.getMarkerLine(number)).isVisible());
            this.renderer.updateSurface();
        } else if (actionCommand.startsWith(SHAPES_MARKERLINE_REMOVE)) {
            String name = actionCommand.substring(actionCommand.lastIndexOf(ACTION_LINE) + 4);
            name = name.substring(name.indexOf(32) + 1);
            name = name.substring(0, name.indexOf(32));
            int number = Integer.parseInt(name);
            this.renderer.removeShape(this.renderer.getMarkerLine(number));
        } else if (actionCommand.startsWith(SHAPES_MARKERLINE_LINE_TO_CURRENT)) {
            String markerStr = actionCommand.substring(actionCommand.lastIndexOf(ACTION_LINE) + 4);
            markerStr = markerStr.substring(markerStr.indexOf(32) + 1);
            markerStr = markerStr.substring(0, markerStr.indexOf(32));
            int num = Integer.parseInt(markerStr);
            MarkerLine line = this.renderer.getMarkerLine(num);
            this.renderer.lineToShape(line, null);
        } else if (actionCommand.startsWith(SHAPES_MARKERLINE_LINE_TO)) {
            String startStr = actionCommand.substring(SHAPES_MARKERLINE_LINE_TO.length(), actionCommand.indexOf(124));
            startStr = startStr.substring(startStr.indexOf(32) + 1);
            startStr = startStr.substring(0, startStr.indexOf(32));
            int startNum = Integer.parseInt(startStr);
            String endStr = actionCommand.substring(actionCommand.indexOf(124) + 1);
            endStr = endStr.substring(endStr.indexOf(32) + 1);
            endStr = endStr.substring(0, endStr.indexOf(32));
            int endNum = Integer.parseInt(endStr);
            MarkerLine line = this.renderer.getMarkerLine(startNum);
            Marker point = this.renderer.getMarker(endNum);
            this.renderer.lineToShape(line, point);
        } else if (actionCommand.startsWith(SHAPES_MARKERLINE_MEASURE)) {
            String name = actionCommand.substring(actionCommand.lastIndexOf(ACTION_LINE) + 4);
            name = name.substring(name.indexOf(32) + 1);
            name = name.substring(0, name.indexOf(32));
            int number = Integer.parseInt(name);
            MarkerLine ml = this.renderer.getMarkerLine(number);
            this.renderer.measureLine(ml);
        } else if (actionCommand.equals(FILE_INFO)) {
            this.renderer.selectFileMenuSurfaceInfo();
        } else if (actionCommand.equals(FILE_SAVE_AS)) {
            File loadedFile = this.renderer.getViewer().getLoadedFile();
            File outputFile = null;
            String filename = loadedFile.getName();
            MangoFormat mangoFormat = new MangoFormat();
            int selection = 0;
            JPanel optionsPanel = null;
            try {
                optionsPanel = mangoFormat.getOptionsPanel(this.renderer.getSurfaces(), this.renderer.getShapeData(), this.renderer.getViewer());
            }
            catch (AbstractMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                optionsPanel = mangoFormat.getOptionsPanel(this.renderer.getSurfaces(), this.renderer.getShapeData(), this.renderer);
            }
            catch (NoSuchMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                optionsPanel = mangoFormat.getOptionsPanel(this.renderer.getSurfaces(), this.renderer.getShapeData(), this.renderer);
            }
            if (optionsPanel != null) {
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.renderer.getFrame(), optionsPanel, "Export Options", -1, null);
                selection = jopf.show();
            }
            if (selection == 0) {
                filename = mangoFormat.getSelectedName();
                outputFile = filename.indexOf(46) != -1 ? new File(loadedFile.getParent(), filename.substring(0, filename.indexOf(46)) + ".surf") : new File(loadedFile.getParent(), filename + ".surf");
                if ((outputFile = SurfaceViewerMenuAction.makeSaveFileChooser(outputFile.getParent(), outputFile.getName(), this.renderer.getFrame())) != null) {
                    this.renderer.recordAction("saveAs", new String[]{this.renderer.getViewer().getScriptObjectName() + ".makeFilename(\"" + ".surf" + "\")", null, ScriptUtils.convertBoolean(mangoFormat.isIncludeLinesAndPoints())});
                    mangoFormat.writeSurfaceFile(outputFile, this.renderer.getSurfaces(), this.renderer.getShapeData(), this.renderer.getViewer());
                    Mango.getInstance().updateImageBrowser(outputFile);
                }
            }
        } else if (actionCommand.indexOf(PLUGINS_GET_MORE) != -1) {
            DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//mango.html#pluginslist");
        } else if (actionCommand.startsWith(PLUGINS_DO)) {
            String name = actionCommand.substring(actionCommand.indexOf(124) + 2);
            Mango.usePlugin(this.renderer.getViewer(), name);
        } else if (actionCommand.startsWith(FILE_EXPORT_AS)) {
            String commandName = actionCommand.substring(FILE_EXPORT_AS.length());
            this.exportFile(commandName);
        } else if (actionCommand.startsWith(SURFACE_ANIMATE)) {
            if (this.renderer.isAnimating()) {
                this.renderer.stopAnimation();
            } else {
                this.renderer.startAnimation();
            }
        }
    }

    private void exportFile(final String commandName) {
        Thread workThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Collection<SurfaceFormat> values = SurfaceReader.getLoadedFormats().values();
                Iterator<SurfaceFormat> it = values.iterator();
                boolean success = false;
                String message = null;
                File outputFile = null;
                while (it.hasNext()) {
                    SurfaceFormat aFormat = it.next();
                    String formatName = PluginManagerDialog.getPluginName(aFormat);
                    if (!commandName.equals(formatName)) continue;
                    ProgressMeter meter = SurfaceViewerMenuAction.this.renderer.getViewerController().makeProgressMeter();
                    meter.start(0, 0, 100);
                    meter.setIndeterminateMode(true);
                    try {
                        Class<?> aClass = Class.forName(aFormat.getClass().getName());
                        SurfaceFormat surfaceWriter = (SurfaceFormat)aClass.newInstance();
                        int selection = 0;
                        JPanel optionsPanel = surfaceWriter.getOptionsPanel(SurfaceViewerMenuAction.this.renderer.getSurfaces(), SurfaceViewerMenuAction.this.renderer.getShapeData(), (SurfaceController)SurfaceViewerMenuAction.this.renderer);
                        if (optionsPanel != null) {
                            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(SurfaceViewerMenuAction.this.renderer.getFrame(), optionsPanel, "Export Options", -1, null);
                            selection = jopf.show();
                        }
                        if (selection != 0) break;
                        File loadedFile = SurfaceViewerMenuAction.this.renderer.getViewer().getLoadedFile();
                        String filename = loadedFile.getName();
                        outputFile = filename.indexOf(46) != -1 ? new File(loadedFile.getParent(), filename.substring(0, filename.indexOf(46)) + "." + aFormat.getPreferredFileExtension()) : new File(loadedFile.getParent(), filename + "." + aFormat.getPreferredFileExtension());
                        if ((outputFile = SurfaceViewerMenuAction.this.makeSaveFileChooser(outputFile.getParent(), outputFile.getName())) == null || surfaceWriter == null) break;
                        SurfaceViewerMenuAction.this.renderer.recordAction("exportTo", new String[]{SurfaceViewerMenuAction.this.renderer.getViewer().getScriptObjectName() + ".makeFilename(\"." + surfaceWriter.getPreferredFileExtension() + "\")", ScriptUtils.convertString(formatName), null, ScriptUtils.convertString(surfaceWriter.getOptions())}, true);
                        try {
                            surfaceWriter.writeSurfaceFile(outputFile, SurfaceViewerMenuAction.this.renderer.getSurfaces(), SurfaceViewerMenuAction.this.renderer.getShapeData(), (VolumeManager)SurfaceViewerMenuAction.this.renderer.getViewer());
                        }
                        catch (AbstractMethodError err) {
                            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                            surfaceWriter.writeSurfaceFile(outputFile, SurfaceViewerMenuAction.this.renderer.getSurfaces(), SurfaceViewerMenuAction.this.renderer.getShapeData(), (SurfaceController)SurfaceViewerMenuAction.this.renderer);
                        }
                        catch (NoSuchMethodError err) {
                            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                            surfaceWriter.writeSurfaceFile(outputFile, SurfaceViewerMenuAction.this.renderer.getSurfaces(), SurfaceViewerMenuAction.this.renderer.getShapeData(), (SurfaceController)SurfaceViewerMenuAction.this.renderer);
                        }
                        success = true;
                        break;
                    }
                    catch (SurfaceFormatException sfx) {
                        AppLogger.error((Throwable)sfx);
                        message = sfx.getMessage();
                        break;
                    }
                    catch (Error err) {
                        AppLogger.error((Throwable)err);
                        message = err.getMessage();
                        break;
                    }
                    catch (ClassNotFoundException ex) {
                        AppLogger.error((Throwable)ex);
                        message = ex.getMessage();
                        break;
                    }
                    catch (InstantiationException ex) {
                        AppLogger.error((Throwable)ex);
                        message = ex.getMessage();
                        break;
                    }
                    catch (IllegalAccessException ex) {
                        AppLogger.error((Throwable)ex);
                        message = ex.getMessage();
                        break;
                    }
                    finally {
                        meter.setValue(100);
                        meter.setIndeterminateMode(false);
                    }
                }
                if (outputFile != null) {
                    SurfaceViewerMenuAction.this.renderer.surfaceFileWritten(success, outputFile, message);
                }
            }
        }, "SurfaceAction.exportFile() Thread");
        workThread.start();
    }

    private void loadShapeFromFile() {
        File selectedFile = SurfaceViewerMenuAction.makeOpenFileChooser(SurfaceReader.getFormatExtensions(), this.renderer.getViewer().getSaveDirectory(), "All Surface Files", this.renderer.getFrame());
        if (selectedFile != null) {
            this.renderer.recordAction("addShapesFromFile", new String[]{ScriptUtils.convertString(selectedFile.toString())}, true);
            SurfaceReader sr = new SurfaceReader();
            sr.readFile(selectedFile, this.renderer.getViewer(), this.renderer, false);
        }
    }

    private void loadColorsFromGIFTILabelFile() {
        File selectedFile = SurfaceViewerMenuAction.makeOpenFileChooser(new String[]{".label.gii"}, this.renderer.getViewer().getSaveDirectory(), "All Surface Files", this.renderer.getFrame());
        if (selectedFile != null) {
            GiftiFormat gf = new GiftiFormat();
            try {
                gf.readLabelFile(selectedFile, this.renderer, this.renderer.getViewer());
            }
            catch (SurfaceFormatException sfe) {
                this.renderer.showErrorDialog(sfe.getMessage(), "Surface Error");
            }
        }
    }

    private void loadColorsFromGIFTIRGBAFile() {
        File selectedFile = SurfaceViewerMenuAction.makeOpenFileChooser(new String[]{".rgba.gii"}, this.renderer.getViewer().getSaveDirectory(), "All Surface Files", this.renderer.getFrame());
        if (selectedFile != null) {
            GiftiFormat gf = new GiftiFormat();
            try {
                gf.readRGBAFile(selectedFile, this.renderer, this.renderer.getViewer());
            }
            catch (SurfaceFormatException sfe) {
                this.renderer.showErrorDialog(sfe.getMessage(), "Surface Error");
            }
        }
    }

    private File makeSaveFileChooser(String dir, String filename) {
        return SaveFileDialog.showSaveFileChooser(this.renderer.getFrame(), dir, filename);
    }

    private void showBackgroundDialog() {
        final BackgroundDialog dialog = new BackgroundDialog(this.renderer.getBackgroundColor(), this.renderer.getDefaultBackgroundColor());
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.renderer.getFrame(), (Object)dialog, "Backgound Options", -1);
        final JOptionPane jop = jopf.getJOptionPane();
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
            }
        });
        JButton buttonCancel = new JButton(ACTION_CANCEL);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(2);
                jop.setVisible(false);
            }
        });
        JButton buttonDefault = new JButton("Default");
        buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.setToDefault();
            }
        });
        Object[] options = new Object[]{buttonOk, buttonCancel, buttonDefault};
        jopf.setOptions(options);
        jopf.setInitialValue(buttonOk);
        int selection = jopf.show();
        if (selection == 0) {
            this.renderer.setBackgroundColor(dialog.getColor());
            this.renderer.updateSurface();
            this.renderer.getFrame().updateInfoPanelColors();
        }
    }

    private void showLightingDialog() {
        final LightingDialog dialog = new LightingDialog(this.renderer.getBaseSurface().getLighting(), this.renderer);
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.renderer.getFrame(), (Object)dialog, "Lighting", -1);
        final JOptionPane jop = jopf.getJOptionPane();
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
            }
        });
        JButton buttonCancel = new JButton(ACTION_CANCEL);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(2);
                jop.setVisible(false);
            }
        });
        JButton buttonDefault = new JButton("Default");
        buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.setToDefault();
            }
        });
        Object[] options = new Object[]{buttonOk, buttonCancel, buttonDefault};
        jopf.setOptions(options);
        jopf.setInitialValue(buttonOk);
        int selection = jopf.show(false, true);
        Lighting lighting = this.renderer.getBaseSurface().getLighting();
        if (selection == 0) {
            Lighting dialogLighting = dialog.getLighting();
            this.renderer.recordAction("setLighting", new String[]{String.valueOf(dialogLighting.getAmbient()), String.valueOf(dialogLighting.getDiffuse()), String.valueOf(dialogLighting.getSpecular()), String.valueOf(dialogLighting.getDirection()[0]), String.valueOf(dialogLighting.getDirection()[1])});
            lighting.setValues(dialog.getLighting());
        } else {
            lighting.setTempLighting(null);
        }
        this.renderer.updateSurface();
    }

    private void showMaterialDialog(CompositeSurface data) {
        float threshold = data.isBaseSurface() ? this.renderer.getThreshold() : Float.MIN_VALUE;
        final MaterialDialog dialog = new MaterialDialog(data.getMaterial(), data.getLighting(), this.renderer, data.hasColors(), this.renderer.canUseShaders(), threshold, data.isBuildFromOverlay());
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.renderer.getFrame(), (Object)dialog, "Material", -1);
        final JOptionPane jop = jopf.getJOptionPane();
        dialog.setOptionPane(jopf);
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
            }
        });
        JButton buttonCancel = new JButton(ACTION_CANCEL);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(2);
                jop.setVisible(false);
            }
        });
        JButton buttonDefault = new JButton("Default");
        buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.setToDefault();
            }
        });
        Object[] options = new Object[]{buttonOk, buttonCancel, buttonDefault};
        jopf.setOptions(options);
        jopf.setInitialValue(buttonOk);
        int selection = jopf.show(false, true);
        Material material = data.getMaterial();
        if (selection == 0) {
            boolean oldShowOverlayColors = material.isShowOverlayColors();
            boolean newShowOverlayColors = dialog.isShowOverlayColors();
            boolean oldShowThisOverlayColors = material.isShowOnlyThisOverlayColors();
            boolean newShowThisOverlayColors = dialog.isShowThisOverlayColors();
            float oldTransparency = material.getTransparency();
            float newTransparency = dialog.getTransparency();
            double oldDistance = material.getDistance();
            double newDistance = dialog.getDistance();
            Material dialogMaterial = dialog.getMaterial();
            String surfaceArg = null;
            if (data == this.renderer.getBaseSurface()) {
                surfaceArg = this.renderer.getViewer().getScriptObjectName() + ".surfaceManager" + ".baseSurface";
            }
            material.setValues(dialogMaterial);
            this.renderer.recordAction("setMaterial", new String[]{surfaceArg, String.valueOf(material.getColor().getRGB()), ScriptUtils.convertBoolean(material.isShowOverlayColors()), ScriptUtils.convertBoolean(material.isShowOnlyThisOverlayColors()), ScriptUtils.convertBoolean(!material.isSmoothShading()), String.valueOf(material.getPolygonStyle()), String.valueOf(material.getTransparency()), String.valueOf(material.getEmissivity()), String.valueOf(material.getShininess()), String.valueOf(material.getDistance())});
            if (newShowOverlayColors != oldShowOverlayColors || oldShowThisOverlayColors != newShowThisOverlayColors || oldTransparency != newTransparency || oldDistance != newDistance) {
                this.renderer.syncOverlays(data);
            } else {
                data.updateColors(this.renderer.getViewer());
            }
            if (data.isBaseSurface()) {
                float val = dialog.getThreshold();
                if (!MathUtilities.essentiallyEqual((float)val, (float)Float.MIN_VALUE)) {
                    this.renderer.setThreshold(val);
                }
                this.renderer.getViewer().updateSurfaceTextures(true);
            }
        } else {
            material.setTempMaterial(null);
        }
        this.renderer.updateSurface();
    }

    private void showTransformDialog() {
        final TransformDialog dialog = new TransformDialog();
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.renderer.getFrame(), (Object)dialog, "Transform Options", -1);
        final JOptionPane jop = jopf.getJOptionPane();
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
            }
        });
        JButton buttonCancel = new JButton(ACTION_CANCEL);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(2);
                jop.setVisible(false);
            }
        });
        JButton buttonDefault = new JButton("Default");
        buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.setToDefault();
            }
        });
        Object[] options = new Object[]{buttonOk, buttonCancel, buttonDefault};
        jopf.setOptions(options);
        jopf.setInitialValue(buttonOk);
        int selection = jopf.show();
        if (selection == 0) {
            float[][] xform = dialog.getXform();
            this.renderer.transformPoints(xform);
        }
    }

    private void addAllOverlays(final SurfaceBuildParameters params) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SurfaceViewerMenuAction.this.doAddAllOverlays(params);
            }
        });
        workThread.start();
    }

    private void doAddAllOverlays(SurfaceBuildParameters params) {
        this.renderer.getViewer().startIndeterminateProgressBar();
        ScreenVolume[] screenVols = this.renderer.getViewer().getOverlayManager().getAllOverlays();
        for (int ctr = 0; ctr < screenVols.length; ++ctr) {
            if (screenVols[ctr] == null) continue;
            ImageIcon[] icons = this.renderer.getViewer().getToolBox().getOverlayImageIcons();
            Color color = new Color(((BufferedImage)icons[ctr].getImage()).getRGB(0, 0));
            String name = this.renderer.getViewer().getOverlayManager().getOverlay(ctr).getName();
            this.renderer.recordAction("addShapeFromOverlay", new String[]{null, ScriptUtils.convertString("Overlay"), String.valueOf(color.getRGB()), String.valueOf(params.getThreshold()), ScriptUtils.convertBoolean(params.isUseShrinkWrap()), ScriptUtils.convertBoolean(params.isUseNegative()), ScriptUtils.convertBoolean(params.isUseImageSmoothing()), String.valueOf(params.getFilterFWHM()), String.valueOf(params.getFilterSize()), String.valueOf(params.getResX()), String.valueOf(params.getResY()), String.valueOf(params.getResZ()), ScriptUtils.convertBoolean(params.isUseSurfaceSmoothing()), String.valueOf(params.getFeatureError()), String.valueOf(params.getFeatureAngle()), String.valueOf(params.getNumSmoothingIterations())}, true);
            Volume overlay = screenVols[ctr].getVolume();
            SurfaceFactory factory = new SurfaceFactory(params, this.renderer.getViewer().getVolume());
            factory.setSameThread(true);
            factory.createOverlaySurface(this.renderer, overlay, name, color);
        }
        this.renderer.getViewer().endIndeterminateProgressBar();
    }

    private void addAllROIs(final SurfaceBuildParameters params) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SurfaceViewerMenuAction.this.doAddAllROIs(params);
            }
        });
        workThread.start();
    }

    private void doAddAllROIs(SurfaceBuildParameters params) {
        this.renderer.getViewer().startIndeterminateProgressBar();
        Vector<Integer> used = this.renderer.getViewer().getROIManager().getUsedIndices();
        for (Integer item : used) {
            Color color = ROIColor.getColor(item);
            String name = this.renderer.getViewer().getROIManager().getLabel(item, "ROI (" + ROIDefaultLabels.getDefaultLabelBitPlaneOrder(item, this.renderer.getViewer().getROIManager().getBuffer().getMaximumColors()) + ")");
            this.renderer.recordAction("addShapeFromROI", new String[]{null, ScriptUtils.convertString("ROI"), String.valueOf(color.getRGB()), String.valueOf(params.getThreshold()), ScriptUtils.convertBoolean(params.isUseShrinkWrap()), ScriptUtils.convertBoolean(params.isUseNegative()), ScriptUtils.convertBoolean(params.isUseImageSmoothing()), String.valueOf(params.getFilterFWHM()), String.valueOf(params.getFilterSize()), String.valueOf(params.getResX()), String.valueOf(params.getResY()), String.valueOf(params.getResZ()), ScriptUtils.convertBoolean(params.isUseSurfaceSmoothing()), String.valueOf(params.getFeatureError()), String.valueOf(params.getFeatureAngle()), String.valueOf(params.getNumSmoothingIterations())}, true);
            SurfaceFactory factory = new SurfaceFactory(params, this.renderer.getViewer().getVolume());
            factory.setSameThread(true);
            factory.createROISurface(this.renderer, this.renderer.getViewer().getROIManager(), item, name, color);
        }
        this.renderer.getViewer().endIndeterminateProgressBar();
    }

    private void addAllLogicals(final SurfaceBuildParameters params) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SurfaceViewerMenuAction.this.doAddAllLogicals(params);
            }
        });
        workThread.start();
    }

    private void doAddAllLogicals(SurfaceBuildParameters params) {
        this.renderer.getViewer().startIndeterminateProgressBar();
        Vector<LogicalPanel> logicals = this.renderer.getViewer().getLogicalManager().getLogicalPanels();
        if (logicals != null) {
            for (int ctr = 0; ctr < logicals.size(); ++ctr) {
                LogicalPanel lp = logicals.get(ctr);
                if (lp.isEmptyLogical()) continue;
                Color color = lp.getLogical().getColor();
                this.renderer.recordAction("addShapeFromLogical", new String[]{null, ScriptUtils.convertString("Logical"), String.valueOf(color.getRGB()), String.valueOf(params.getThreshold()), ScriptUtils.convertBoolean(params.isUseShrinkWrap()), ScriptUtils.convertBoolean(params.isUseNegative()), ScriptUtils.convertBoolean(params.isUseImageSmoothing()), String.valueOf(params.getFilterFWHM()), String.valueOf(params.getFilterSize()), String.valueOf(params.getResX()), String.valueOf(params.getResY()), String.valueOf(params.getResZ()), ScriptUtils.convertBoolean(params.isUseSurfaceSmoothing()), String.valueOf(params.getFeatureError()), String.valueOf(params.getFeatureAngle()), String.valueOf(params.getNumSmoothingIterations())}, true);
                SurfaceFactory factory = new SurfaceFactory(params, this.renderer.getViewer().getVolume());
                factory.createLogicalSurface(this.renderer, this.renderer.getViewer().getLogicalManager().getLogicalPanels().get(ctr).getLogical(), "Logical " + (ctr + 1), color);
            }
        }
        this.renderer.getViewer().endIndeterminateProgressBar();
    }
}

