/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.viewersurface.screen.Lighting;
import edu.uthscsa.ric.mango.viewersurface.screen.Material;
import edu.uthscsa.ric.mango.viewersurface.screen.SurfaceUpdater;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MaterialDialog
extends JPanel
implements ActionListener,
ChangeListener {
    private Color currentColor;
    private JColorChooser colorChooser;
    private MangoFocusableOptionPane jopf;
    private boolean alreadyUpdatedSurfaceTextures;
    private final JCheckBox useOverlayColors;
    private final JCheckBox useThisOverlayColors;
    private final JLabel distanceWarning;
    private final JLabel shininessWarning;
    private final JLabel transparencyWarning;
    private final JPanel colorSwatchPanel;
    private final JRadioButton fillOption;
    private final JRadioButton lineOption;
    private final JRadioButton niceShadeButton;
    private final JSlider distanceSlider;
    private final JSlider emissivitySlider;
    private final JSlider shininessSlider;
    private final JSlider transparencySlider;
    private final JTextField distanceText;
    private final JTextField emissivityText;
    private final JTextField shininessText;
    private final JTextField thresholdText;
    private final JTextField transparencyText;
    private final Lighting lighting;
    private final Material tempMaterial;
    private final SurfaceUpdater updater;
    private final boolean inited;
    private final boolean showingOverlays;
    private static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    private static final long serialVersionUID = 1L;
    public static final int SWATCH_SIZE = 25;

    public MaterialDialog(final Material material, Lighting lighting, SurfaceUpdater updater, boolean showingOverlays, boolean isUsingShader, float threshold, boolean buildFromOverlay) {
        this.updater = updater;
        this.lighting = lighting;
        this.showingOverlays = showingOverlays && material.isShowOverlayColors();
        this.tempMaterial = new Material(material);
        material.setTempMaterial(this.tempMaterial);
        this.currentColor = material.getColor();
        JButton colorButton = new JButton("Select Color...");
        colorButton.setFocusable(false);
        colorButton.addActionListener(this);
        this.colorSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(MaterialDialog.this.currentColor.getRed(), MaterialDialog.this.currentColor.getGreen(), MaterialDialog.this.currentColor.getBlue(), (int)((1.0 - (double)material.getTransparency() / 100.0) * 255.0)));
                g.fillRect(0, 0, 25, 25);
            }
        };
        this.colorSwatchPanel.setPreferredSize(new Dimension(25, 25));
        this.colorSwatchPanel.setMaximumSize(this.colorSwatchPanel.getPreferredSize());
        this.colorSwatchPanel.setMinimumSize(this.colorSwatchPanel.getPreferredSize());
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        colorPanel.add(Box.createHorizontalStrut(8));
        colorPanel.add(colorButton);
        colorPanel.add(Box.createHorizontalStrut(8));
        colorPanel.add(this.colorSwatchPanel);
        colorPanel.add(Box.createHorizontalStrut(8));
        JPanel colorPanel2 = new JPanel();
        colorPanel2.setLayout(new BoxLayout(colorPanel2, 1));
        colorPanel2.add(colorPanel);
        colorPanel2.add(Box.createVerticalStrut(4));
        this.useOverlayColors = new JCheckBox("Show Overlay Colors");
        this.useOverlayColors.setSelected(material.isShowOverlayColors());
        this.useOverlayColors.addActionListener(this);
        JPanel overlayColorPanel = new JPanel();
        overlayColorPanel.setLayout(new BoxLayout(overlayColorPanel, 0));
        overlayColorPanel.add(this.useOverlayColors);
        this.useThisOverlayColors = new JCheckBox("Show Only This Overlay");
        this.useThisOverlayColors.setSelected(material.isShowOnlyThisOverlayColors());
        this.useThisOverlayColors.addActionListener(this);
        this.useThisOverlayColors.setEnabled(this.useOverlayColors.isSelected());
        JPanel overlayThisColorPanel = new JPanel();
        overlayThisColorPanel.setLayout(new BoxLayout(overlayThisColorPanel, 0));
        overlayThisColorPanel.add(this.useThisOverlayColors);
        this.niceShadeButton = new JRadioButton("Smooth Shading");
        JRadioButton flatShadeButton = new JRadioButton("Flat Shading");
        flatShadeButton.addActionListener(this);
        this.niceShadeButton.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.niceShadeButton);
        group.add(flatShadeButton);
        if (material.isSmoothShading()) {
            this.niceShadeButton.setSelected(true);
        } else {
            flatShadeButton.setSelected(true);
        }
        JPanel shadePanel = new JPanel();
        shadePanel.setLayout(new BoxLayout(shadePanel, 0));
        shadePanel.add(Box.createHorizontalGlue());
        shadePanel.add(this.niceShadeButton);
        shadePanel.add(Box.createHorizontalStrut(8));
        shadePanel.add(flatShadeButton);
        shadePanel.add(Box.createHorizontalGlue());
        shadePanel.setVisible(!isUsingShader);
        JLabel transparencySliderLabel = new JLabel("Transparency");
        this.transparencySlider = new JSlider(0, 100, Math.round(this.tempMaterial.getTransparency() * 100.0f));
        this.transparencySlider.addChangeListener(this);
        this.transparencySlider.setMaximumSize(this.transparencySlider.getPreferredSize());
        this.transparencySlider.setMinimumSize(this.transparencySlider.getPreferredSize());
        this.transparencyText = new MangoTextField(FORMATTER.format(this.tempMaterial.getTransparency()), 4);
        this.transparencyText.setMaximumSize(this.transparencyText.getPreferredSize());
        this.transparencyText.setMinimumSize(this.transparencyText.getPreferredSize());
        this.transparencyText.addActionListener(this);
        JPanel transparencySliderPanel = new JPanel();
        transparencySliderPanel.setLayout(new BoxLayout(transparencySliderPanel, 0));
        transparencySliderPanel.add(Box.createHorizontalStrut(8));
        transparencySliderPanel.add(transparencySliderLabel);
        transparencySliderPanel.add(Box.createHorizontalGlue());
        transparencySliderPanel.add(this.transparencySlider);
        transparencySliderPanel.add(Box.createHorizontalStrut(4));
        transparencySliderPanel.add(this.transparencyText);
        transparencySliderPanel.add(Box.createHorizontalStrut(8));
        JPanel transparencyWarningPanel = new JPanel();
        transparencyWarningPanel.setLayout(new BoxLayout(transparencyWarningPanel, 0));
        this.transparencyWarning = new JLabel("Transparency will update when dialog is closed.");
        this.transparencyWarning.setFont(this.transparencyWarning.getFont().deriveFont((float)this.transparencyWarning.getFont().getSize() - 2.0f));
        this.transparencyWarning.setForeground(Color.RED);
        transparencyWarningPanel.add(Box.createHorizontalGlue());
        transparencyWarningPanel.add(this.transparencyWarning);
        transparencyWarningPanel.add(Box.createHorizontalGlue());
        this.transparencyWarning.setVisible(false);
        JLabel shininessSliderLabel = new JLabel("Shininess");
        this.shininessSlider = new JSlider(0, Math.round(128.0f), Math.round(this.tempMaterial.getShininess()));
        this.shininessSlider.addChangeListener(this);
        this.shininessSlider.setMaximumSize(this.shininessSlider.getPreferredSize());
        this.shininessSlider.setMinimumSize(this.shininessSlider.getPreferredSize());
        this.shininessText = new MangoTextField(FORMATTER.format(this.tempMaterial.getShininess() / 128.0f), 4);
        this.shininessText.setMaximumSize(this.shininessText.getPreferredSize());
        this.shininessText.setMinimumSize(this.shininessText.getPreferredSize());
        this.shininessText.addActionListener(this);
        JPanel shininessSliderPanel = new JPanel();
        shininessSliderPanel.setLayout(new BoxLayout(shininessSliderPanel, 0));
        shininessSliderPanel.add(Box.createHorizontalStrut(8));
        shininessSliderPanel.add(shininessSliderLabel);
        shininessSliderPanel.add(Box.createHorizontalGlue());
        shininessSliderPanel.add(this.shininessSlider);
        shininessSliderPanel.add(Box.createHorizontalStrut(4));
        shininessSliderPanel.add(this.shininessText);
        shininessSliderPanel.add(Box.createHorizontalStrut(8));
        JPanel shininessWarningPanel = new JPanel();
        shininessWarningPanel.setLayout(new BoxLayout(shininessWarningPanel, 0));
        this.shininessWarning = new JLabel("Shininess requires specular lighting to be at least 30%.");
        this.shininessWarning.setFont(this.shininessWarning.getFont().deriveFont((float)this.shininessWarning.getFont().getSize() - 2.0f));
        this.shininessWarning.setForeground(Color.RED);
        shininessWarningPanel.add(Box.createHorizontalGlue());
        shininessWarningPanel.add(this.shininessWarning);
        shininessWarningPanel.add(Box.createHorizontalGlue());
        this.shininessWarning.setVisible(false);
        JLabel emissiveLabel = new JLabel("Emissivity");
        this.emissivitySlider = new JSlider(0, 100, Math.round(this.tempMaterial.getEmissivity() * 100.0f));
        this.emissivitySlider.addChangeListener(this);
        this.emissivitySlider.setMaximumSize(this.emissivitySlider.getPreferredSize());
        this.emissivitySlider.setMinimumSize(this.emissivitySlider.getPreferredSize());
        this.emissivityText = new MangoTextField(FORMATTER.format(this.tempMaterial.getEmissivity()), 4);
        this.emissivityText.setMaximumSize(this.emissivityText.getPreferredSize());
        this.emissivityText.setMinimumSize(this.emissivityText.getPreferredSize());
        this.emissivityText.addActionListener(this);
        JPanel emissivePanel = new JPanel();
        emissivePanel.setLayout(new BoxLayout(emissivePanel, 0));
        emissivePanel.add(Box.createHorizontalStrut(8));
        emissivePanel.add(emissiveLabel);
        emissivePanel.add(Box.createHorizontalGlue());
        emissivePanel.add(this.emissivitySlider);
        emissivePanel.add(Box.createHorizontalStrut(4));
        emissivePanel.add(this.emissivityText);
        emissivePanel.add(Box.createHorizontalStrut(8));
        JLabel distanceLabel = new JLabel("Overlay Search Distance");
        JPanel distanceLabelPanel = new JPanel();
        distanceLabelPanel.setLayout(new BoxLayout(distanceLabelPanel, 0));
        distanceLabelPanel.add(Box.createHorizontalGlue());
        distanceLabelPanel.add(distanceLabel);
        distanceLabelPanel.add(Box.createHorizontalGlue());
        this.distanceSlider = new JSlider(0, (int)Math.round(this.tempMaterial.getDistanceMax()), (int)Math.round(this.tempMaterial.getDistance()));
        this.distanceSlider.addChangeListener(this);
        this.distanceText = new MangoTextField(FORMATTER.format(this.tempMaterial.getDistance()), 4);
        this.distanceText.setMaximumSize(this.distanceText.getPreferredSize());
        this.distanceText.setMinimumSize(this.distanceText.getPreferredSize());
        this.distanceText.addActionListener(this);
        JPanel distanceSliderPanel = new JPanel();
        distanceSliderPanel.setLayout(new BoxLayout(distanceSliderPanel, 0));
        distanceSliderPanel.add(Box.createHorizontalStrut(8));
        distanceSliderPanel.add(this.distanceSlider);
        distanceSliderPanel.add(Box.createHorizontalStrut(4));
        distanceSliderPanel.add(this.distanceText);
        distanceSliderPanel.add(Box.createHorizontalStrut(8));
        JPanel distancePanel = new JPanel();
        distancePanel.setLayout(new BoxLayout(distancePanel, 1));
        distancePanel.add(distanceLabelPanel);
        distancePanel.add(distanceSliderPanel);
        JPanel distanceWarningPanel = new JPanel();
        distanceWarningPanel.setLayout(new BoxLayout(distanceWarningPanel, 0));
        this.distanceWarning = new JLabel("Overlay will update when dialog is closed.");
        this.distanceWarning.setFont(this.distanceWarning.getFont().deriveFont((float)this.distanceWarning.getFont().getSize() - 2.0f));
        this.distanceWarning.setForeground(Color.RED);
        distanceWarningPanel.add(Box.createHorizontalGlue());
        distanceWarningPanel.add(this.distanceWarning);
        distanceWarningPanel.add(Box.createHorizontalGlue());
        this.distanceWarning.setVisible(false);
        this.fillOption = new JRadioButton("Surface");
        this.fillOption.addActionListener(this);
        this.lineOption = new JRadioButton("Wireframe");
        this.lineOption.addActionListener(this);
        JRadioButton pointOption = new JRadioButton("Points");
        pointOption.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.fillOption);
        bg.add(this.lineOption);
        bg.add(pointOption);
        if (material.getPolygonStyle() == 0) {
            this.fillOption.setSelected(true);
        } else if (material.getPolygonStyle() == 1) {
            this.lineOption.setSelected(true);
        } else {
            pointOption.setSelected(true);
        }
        JPanel polygonTypePanel = new JPanel();
        polygonTypePanel.setLayout(new BoxLayout(polygonTypePanel, 0));
        polygonTypePanel.add(this.fillOption);
        polygonTypePanel.add(Box.createHorizontalStrut(2));
        polygonTypePanel.add(this.lineOption);
        polygonTypePanel.add(Box.createHorizontalStrut(2));
        polygonTypePanel.add(pointOption);
        this.thresholdText = new MangoTextField(FORMATTER.format(threshold), 4);
        this.thresholdText.setMaximumSize(this.thresholdText.getPreferredSize());
        this.thresholdText.setMinimumSize(this.thresholdText.getPreferredSize());
        JPanel thresholdPanel = new JPanel();
        thresholdPanel.setLayout(new BoxLayout(thresholdPanel, 0));
        thresholdPanel.add(Box.createHorizontalGlue());
        thresholdPanel.add(new JLabel("Cut Plane Threshold "));
        thresholdPanel.add(this.thresholdText);
        thresholdPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 1));
        this.add(colorPanel2);
        this.add(Box.createVerticalStrut(12));
        this.add(overlayColorPanel);
        if (buildFromOverlay) {
            this.add(overlayThisColorPanel);
        }
        this.add(Box.createVerticalStrut(6));
        this.add(shadePanel);
        this.add(Box.createVerticalStrut(6));
        this.add(polygonTypePanel);
        this.add(Box.createVerticalStrut(12));
        this.add(transparencySliderPanel);
        this.add(transparencyWarningPanel);
        this.add(emissivePanel);
        this.add(shininessSliderPanel);
        this.add(shininessWarningPanel);
        this.add(Box.createVerticalStrut(12));
        this.add(distancePanel);
        this.add(distanceWarningPanel);
        this.add(Box.createVerticalStrut(6));
        if (!isUsingShader && threshold > -1.4E-45f) {
            this.add(thresholdPanel);
        }
        this.inited = true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("Select Color...")) {
            this.colorChooser = new JColorChooser(this.currentColor);
            JDialog dialog = JColorChooser.createDialog(this, "Colors", true, this.colorChooser, this, this);
            dialog.setVisible(true);
        } else if (actionCommand.equals("OK")) {
            this.currentColor = this.colorChooser.getColor();
            this.colorSwatchPanel.repaint();
        } else if (actionCommand.equals("Update")) {
            this.colorSwatchPanel.repaint();
        }
        this.tempMaterial.setColor(this.getColor());
        this.tempMaterial.setTransparency(this.getTransparency());
        this.tempMaterial.setPolygonStyle(this.getPolygonStyle());
        this.tempMaterial.setShadeModel(this.getShadeModel());
        this.useThisOverlayColors.setEnabled(this.isShowOverlayColors());
        if (!this.isShowOverlayColors()) {
            this.useThisOverlayColors.setSelected(false);
        }
        this.tempMaterial.setShowOverlayColors(this.isShowOverlayColors());
        this.tempMaterial.setShowOnlyThisOverlayColors(this.isShowThisOverlayColors());
        float value = 0.0f;
        try {
            value = Float.parseFloat(this.transparencyText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.transparencyText.setText(FORMATTER.format(0.0));
        }
        this.transparencySlider.setValue(Math.round(value * 100.0f));
        value = 0.0f;
        try {
            value = Float.parseFloat(this.emissivityText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.emissivityText.setText(FORMATTER.format(0.0));
        }
        this.emissivitySlider.setValue(Math.round(value * 100.0f));
        value = 0.5f;
        try {
            value = Float.parseFloat(this.shininessText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.shininessText.setText(FORMATTER.format(0.5));
        }
        this.shininessSlider.setValue(Math.round(value * 128.0f));
        double distanceVal = this.tempMaterial.getDistanceDefault();
        try {
            distanceVal = Float.parseFloat(this.distanceText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            this.distanceText.setText(FORMATTER.format(this.tempMaterial.getDistanceDefault()));
        }
        this.distanceSlider.setValue((int)Math.round(distanceVal));
        this.updater.updateSurface();
    }

    public Color getColor() {
        return this.currentColor;
    }

    public double getDistance() {
        return this.distanceSlider.getValue();
    }

    public float getEmissivity() {
        return (float)this.emissivitySlider.getValue() / 100.0f;
    }

    public Material getMaterial() {
        return this.tempMaterial;
    }

    public int getPolygonStyle() {
        if (this.fillOption.isSelected()) {
            return 0;
        }
        if (this.lineOption.isSelected()) {
            return 1;
        }
        return 2;
    }

    public int getShadeModel() {
        if (this.isNiceShade()) {
            return 7425;
        }
        return 7424;
    }

    public float getShininess() {
        return this.shininessSlider.getValue();
    }

    public float getThreshold() {
        float val = Float.MIN_VALUE;
        try {
            val = Float.parseFloat(this.thresholdText.getText());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    public float getTransparency() {
        return (float)this.transparencySlider.getValue() / 100.0f;
    }

    public boolean isNiceShade() {
        return this.niceShadeButton.isSelected();
    }

    public boolean isShowOverlayColors() {
        return this.useOverlayColors.isSelected();
    }

    public boolean isShowThisOverlayColors() {
        return this.useThisOverlayColors.isSelected();
    }

    public void setOptionPane(MangoFocusableOptionPane jopf) {
        this.jopf = jopf;
    }

    public void setToDefault() {
        this.shininessSlider.setValue(Math.round(64.0f));
        this.emissivitySlider.setValue(Math.round(0.0f));
        this.transparencySlider.setValue(Math.round(0.0f));
        this.distanceSlider.setValue((int)Math.round(this.tempMaterial.getDistanceDefault()));
        this.niceShadeButton.setSelected(true);
        this.fillOption.setSelected(true);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        boolean updatedTransparency = false;
        if (this.inited) {
            this.tempMaterial.setEmissivity(this.getEmissivity());
            this.tempMaterial.setShininess(this.getShininess());
            this.tempMaterial.setTransparency(this.getTransparency());
            this.tempMaterial.setDistance(this.getDistance());
            this.transparencyText.setText(FORMATTER.format((float)this.transparencySlider.getValue() / 100.0f));
            this.emissivityText.setText(FORMATTER.format((float)this.emissivitySlider.getValue() / 100.0f));
            this.shininessText.setText(FORMATTER.format((float)this.shininessSlider.getValue() / 128.0f));
            this.distanceText.setText(FORMATTER.format(this.distanceSlider.getValue()));
            if (ce.getSource() == this.transparencySlider) {
                if (this.tempMaterial.getTransparency() > 0.0f) {
                    updatedTransparency = true;
                }
                if (this.showingOverlays) {
                    this.transparencyWarning.setVisible(true);
                    this.jopf.repack();
                }
            }
            if (ce.getSource() == this.shininessSlider && this.lighting.getSpecular() < 0.3f) {
                this.shininessWarning.setVisible(true);
                this.jopf.repack();
            }
            if (ce.getSource() == this.distanceSlider && this.showingOverlays) {
                this.distanceWarning.setVisible(true);
                this.jopf.repack();
            }
        }
        if (updatedTransparency && !this.alreadyUpdatedSurfaceTextures) {
            this.alreadyUpdatedSurfaceTextures = true;
            this.updater.updateSurfaceTextures();
        }
        this.updater.updateSurface();
    }
}

