/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.dialogs.modal;

import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoSquareButton;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPicker;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPickerPopupManager;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.components.menus.MangoSquareMenuItem;
import edu.uthscsa.ric.mango.components.titledcheckboxborder.MangoTitledCheckboxBorder;
import edu.uthscsa.ric.mango.components.titledcheckboxborder.MangoTitledCheckboxBorderListener;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalPanel;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceBuildParameters;
import edu.uthscsa.ric.mango.window.Toolbox;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class BuildSurfaceDialog
extends JPanel
implements ActionListener,
PopupMenuListener,
MangoTitledCheckboxBorderListener,
MangoColorSelectedListener,
MangoColorPickerPopupManager {
    private Color currentColor;
    private ImageIcon[] icons;
    private JButton optionsButton;
    private JCheckBox minPercent;
    private JCheckBox negativeBox;
    private JCheckBox shrinkWrap;
    private JColorChooser colorChooser;
    private JLabel featureAngleLabel;
    private JLabel filterFWHMLabel;
    private JLabel filterSizeLabel;
    private JLabel presetLabel;
    private JLabel smoothErrorLabel;
    private JLabel smoothIterationsLabel;
    private JLabel thresholdLabel;
    private JPanel nameColorPanel;
    private JPanel optionsPanel;
    private JPanel presetsPanel;
    private JPanel resPanelOuter;
    private JPanel smoothImagePanel;
    private JPanel smoothPanelOuter;
    private JPanel solidSwatchPanel;
    private JPanel thresholdPanel;
    private JPanel typePanel;
    private JPopupMenu popupMenu;
    private JRadioButton betterGraphics;
    private JTextField featureAngle;
    private JTextField filterFWHM;
    private JTextField filterSize;
    private JTextField name;
    private JTextField resX;
    private JTextField resY;
    private JTextField resZ;
    private JTextField smoothError;
    private JTextField smoothIterations;
    private JTextField thresholdText;
    private MangoFocusableOptionPane dialog;
    private MangoSquareButton popupButton;
    private MangoTitledCheckboxBorder imageFilterCheckboxBorder;
    private MangoTitledCheckboxBorder surfaceFilterCheckboxBorder;
    private Popup popupROI;
    private boolean isLogical;
    private boolean isOverlay;
    private boolean isROI;
    private int currentIndex;
    private int currentROI;
    private int presetMode;
    private long popupTimeCanceled;
    private final SliceViewer viewer;
    private static SurfaceBuildParameters customPreset;
    private static final long serialVersionUID = 1L;
    public static final MangoNumberFormatter FORMATTER;
    public static final MangoNumberFormatter FORMATTER2;
    public static final String OPTIONS_LABEL1 = "Show Options";
    public static final String PRESET_STORE_NAME = "CustomSurfaceBuild";
    public static final String ROI_DEFAULT_THRESHOLD = ".5";
    public static final int LARGE_VOLUME_THRESHOLD = 0x1000000;
    public static final int PRESET_CUSTOM = 2;
    public static final int PRESET_STANDARD = 0;
    public static final int SMALL_VOLUME_THRESHOLD = 262144;

    public BuildSurfaceDialog(SliceViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        block31: {
            String command = ae.getActionCommand();
            if (command.equals("Range")) {
                this.shrinkWrap.setSelected(false);
            } else if (command.equals("min percent max")) {
                double imageMax = this.negativeBox.isSelected() ? this.viewer.getVolume().getImageMin() : this.viewer.getVolume().getImageMax();
                try {
                    if (this.minPercent.isSelected()) {
                        double minNum = Double.parseDouble(this.thresholdText.getText());
                        this.thresholdText.setText(FORMATTER.format(minNum / imageMax * 100.0));
                        break block31;
                    }
                    double minNum = Double.parseDouble(this.thresholdText.getText());
                    this.thresholdText.setText(FORMATTER.format(minNum / 100.0 * imageMax));
                }
                catch (NumberFormatException ex) {
                    AppLogger.info((Throwable)ex);
                }
            } else if (command.equals("overlayButtonToggle")) {
                long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
                if (timeSinceCancel > 250L) {
                    this.popupMenu.show(this.popupButton, 2, 35);
                }
            } else if (command.startsWith("overlay")) {
                this.currentIndex = Integer.parseInt(command.substring(7));
                this.popupButton.setIcon(this.icons[this.currentIndex]);
                this.name.setText(this.viewer.getOverlayManager().getOverlay(this.currentIndex).getName());
                this.currentColor = new Color(((BufferedImage)this.icons[this.currentIndex].getImage()).getRGB(0, 0));
                this.negativeBox.setSelected(this.isOverlay && this.viewer.getOverlayManager().getOverlay(this.currentIndex).isNegative());
                this.negativeChanged();
                this.solidSwatchPanel.repaint();
            } else if (command.startsWith("logical")) {
                this.currentIndex = Integer.parseInt(command.substring(7));
                this.popupButton.setIcon(this.viewer.getLogicalManager().getLogicalPanels().get(this.currentIndex).getLogical().getColor());
                this.name.setText("Logical " + (this.currentIndex > 0 ? String.valueOf(this.currentIndex + 1) : ""));
                this.currentColor = this.viewer.getLogicalManager().getLogicalPanels().get(this.currentIndex).getLogical().getColor();
                this.solidSwatchPanel.repaint();
            } else if (command.equals("roiButtonToggle")) {
                if (this.popupROI != null) {
                    this.popupROI.hide();
                    this.popupROI = null;
                } else {
                    this.showROIColorPicker();
                }
            } else if (command.equals("Select Color...")) {
                this.colorChooser = new JColorChooser(this.currentColor);
                JDialog dialog = JColorChooser.createDialog(this, "Colors", true, this.colorChooser, this, this);
                dialog.setVisible(true);
            } else if (command.equals("OK")) {
                this.currentColor = this.colorChooser.getColor();
                this.solidSwatchPanel.repaint();
            } else if (command.equals("Options")) {
                this.showOptions();
            } else if (command.equals("Default")) {
                this.updateToStandardPreset();
            } else if (command.equals("Custom")) {
                this.updateToCustomPreset();
            } else if (command.equals("Negative")) {
                this.negativeChanged();
            } else if (command.equals("Better Graphics") || command.equals("Default Graphics")) {
                this.updateToStandardPreset();
            }
        }
    }

    @Override
    public void checkboxBorderDeselected(String title) {
        if (title.equals("Image Smoothing")) {
            this.updateImageSmoothingPanel();
        } else if (title.equals("Surface Filtering")) {
            this.updateSurfaceSmoothingPanel();
        }
    }

    @Override
    public void checkboxBorderSelected(String title) {
        if (title.equals("Image Smoothing")) {
            this.updateImageSmoothingPanel();
        } else if (title.equals("Surface Filtering")) {
            this.updateSurfaceSmoothingPanel();
        }
    }

    @Override
    public void closeColorPickerPopup() {
        this.closePopups();
    }

    public void colorSelected(int colorNum) {
        this.closePopups();
        this.currentROI = colorNum;
        if (this.popupButton instanceof MangoColorButton) {
            MangoColorButton roiButton = (MangoColorButton)this.popupButton;
            roiButton.setColor(this.currentROI);
        }
        this.name.setText(this.viewer.getROIManager().getLabel(this.currentROI, "ROI (" + ROIDefaultLabels.getDefaultLabelBitPlaneOrder(this.currentROI, this.viewer.getROIManager().getBuffer().getMaximumColors()) + ")"));
        this.currentColor = ROIColor.getColor(this.currentROI);
        this.solidSwatchPanel.repaint();
    }

    public void createLogicalPanel() {
        this.isLogical = true;
        this.makeNameAndColorPanel();
        this.createMe();
    }

    public void createOverlayPanel() {
        this.isOverlay = true;
        this.makeNameAndColorPanel();
        this.createMe();
    }

    public void createROIPanel() {
        this.isROI = true;
        this.makeNameAndColorPanel();
        this.createMe();
    }

    public void createSurfacePanel() {
        this.createMe();
    }

    public SurfaceBuildParameters getBuildParameters() {
        Volume volume = this.viewer.getVolume();
        if (this.isOverlay) {
            volume = this.viewer.getOverlayManager().getOverlay(this.currentIndex).getVolume();
        }
        SurfaceBuildParameters params = new SurfaceBuildParameters(volume);
        params.setUseImageSmoothing(this.imageFilterCheckboxBorder.isSelected());
        params.setUseSurfaceSmoothing(this.surfaceFilterCheckboxBorder.isSelected());
        params.setSmoothingKernel(this.getFilterSize());
        params.setSurfaceSmoothingIterations(this.getSmoothingIterations());
        params.setThreshold(this.getThreshold());
        params.setUseNegative(this.negativeBox.isSelected());
        params.setSmoothingWidth(this.getFilterWidth());
        params.setResX(this.getResX());
        params.setResY(this.getResY());
        params.setResZ(this.getResZ());
        params.setFeatureError(this.getFeatureError());
        params.setFeatureAngle(this.getFeatureAngle());
        params.setUseShrinkWrap(this.shrinkWrap.isSelected());
        params.setUsePercentMax(this.minPercent.isSelected());
        if (this.presetMode == 2) {
            this.viewer.getMango().storeSetting(PRESET_STORE_NAME, params);
        }
        if (this.viewer.getMango().isApplet() && this.betterGraphics.isSelected()) {
            SurfaceViewer.setUseShaders(true);
        }
        return params;
    }

    public float getFeatureAngle() {
        String text = this.featureAngle.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    public float getFeatureError() {
        String text = this.smoothError.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    public float getFilterWidth() {
        String text = this.filterFWHM.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    public int getOverlayIndex() {
        return this.currentIndex;
    }

    public float getResX() {
        String text = this.resX.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    public float getResY() {
        String text = this.resY.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    public float getResZ() {
        String text = this.resZ.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    public int getROINum() {
        return this.currentROI;
    }

    public String getShapeName() {
        return this.name.getText();
    }

    public int getSmoothingIterations() {
        String text = this.smoothIterations.getText();
        double val = 0.0;
        try {
            val = Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return (int)Math.round(val);
    }

    public Color getSolidColor() {
        return this.currentColor;
    }

    public float getThreshold() {
        String text = this.thresholdText.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        if (this.minPercent.isSelected()) {
            val = (float)(this.viewer.getVolume().getImageMax() * ((double)val / 100.0));
        }
        return val;
    }

    public boolean passZeroThresholdCheck() {
        if (this.getThreshold() == 0.0f) {
            int result = JOptionPane.showConfirmDialog(this, "Threshold is 0.  Continue? ", "Threshold Warning", 2);
            return result == 0;
        }
        return true;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popupMenu) {
            this.popupTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    public void setDialog(MangoFocusableOptionPane dialog) {
        this.dialog = dialog;
    }

    private double calculateDefaultFeatureError() {
        double errorVal = 0.0;
        if (this.presetMode == 0) {
            Volume volume = this.viewer.getVolume();
            errorVal = (volume.getXSize() + volume.getYSize() + volume.getZSize()) / 3.0 * 0.2;
        } else {
            errorVal = customPreset.getFeatureError();
            if (errorVal == 0.0) {
                Volume volume = this.viewer.getVolume();
                errorVal = (volume.getXSize() + volume.getYSize() + volume.getZSize()) / 3.0 * 0.2;
            }
        }
        return errorVal;
    }

    private void closePopups() {
        if (this.popupROI != null) {
            this.popupROI.hide();
            this.popupROI = null;
        }
    }

    private void createMe() {
        VoxelDimensions vdOvly;
        JRadioButton standardBox = new JRadioButton("Default");
        standardBox.addActionListener(this);
        JRadioButton customBox = new JRadioButton("Custom");
        customBox.addActionListener(this);
        ButtonGroup presetsGroup = new ButtonGroup();
        presetsGroup.add(standardBox);
        presetsGroup.add(customBox);
        standardBox.setSelected(this.presetMode == 0);
        customBox.setSelected(this.presetMode == 2);
        JRadioButton defaultGraphics = new JRadioButton("Default");
        defaultGraphics.setActionCommand("Default Graphics");
        defaultGraphics.addActionListener(this);
        this.betterGraphics = new JRadioButton("Better");
        this.betterGraphics.setActionCommand("Better Graphics");
        this.betterGraphics.addActionListener(this);
        ButtonGroup graphicsModeGroup = new ButtonGroup();
        graphicsModeGroup.add(defaultGraphics);
        graphicsModeGroup.add(this.betterGraphics);
        defaultGraphics.setSelected(true);
        this.shrinkWrap = new JCheckBox("Shrink Wrap");
        this.shrinkWrap.setActionCommand("Shrink Wrap");
        this.shrinkWrap.addActionListener(this);
        this.shrinkWrap.setFocusable(false);
        this.negativeBox = new JCheckBox("Maximum");
        this.negativeBox.setActionCommand("Negative");
        this.negativeBox.addActionListener(this);
        this.negativeBox.setFocusable(false);
        this.negativeBox.setSelected(this.isOverlay && this.viewer.getOverlayManager().getOverlay(this.currentIndex).isNegative());
        this.optionsButton = new JButton(OPTIONS_LABEL1);
        this.optionsButton.setActionCommand("Options");
        this.optionsButton.addActionListener(this);
        this.optionsPanel = new JPanel();
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 0));
        this.presetsPanel = new JPanel();
        this.presetsPanel.setLayout(new BoxLayout(this.presetsPanel, 0));
        this.presetsPanel.add(Box.createHorizontalGlue());
        if (this.viewer.getMango().isApplet()) {
            this.presetLabel = new JLabel("Graphics Mode:");
            this.presetsPanel.add(defaultGraphics);
            this.presetsPanel.add(Box.createHorizontalGlue());
            this.presetsPanel.add(this.betterGraphics);
        } else {
            this.presetLabel = new JLabel("Saved Settings:");
            this.presetsPanel.add(standardBox);
            this.presetsPanel.add(Box.createHorizontalGlue());
            this.presetsPanel.add(customBox);
        }
        this.presetsPanel.add(Box.createHorizontalGlue());
        if (this.isROI || this.isLogical) {
            this.presetsPanel.add(this.optionsButton);
            this.presetsPanel.add(Box.createHorizontalGlue());
        } else {
            this.presetsPanel.add(this.shrinkWrap);
            this.presetsPanel.add(Box.createHorizontalGlue());
            this.optionsPanel.add(Box.createHorizontalGlue());
            this.optionsPanel.add(this.optionsButton);
            this.optionsPanel.add(Box.createHorizontalGlue());
        }
        this.thresholdText = new MangoTextField("", 6);
        this.thresholdText.setMaximumSize(this.thresholdText.getPreferredSize());
        this.thresholdText.setMinimumSize(this.thresholdText.getPreferredSize());
        this.updateThreshold();
        this.thresholdLabel = new JLabel("Threshold");
        this.thresholdLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        this.typePanel = new JPanel();
        this.typePanel.setLayout(new BoxLayout(this.typePanel, 0));
        this.typePanel.add(Box.createHorizontalGlue());
        this.typePanel.add(Box.createHorizontalGlue());
        this.minPercent = new JCheckBox("% Max");
        this.minPercent.setFocusable(false);
        this.minPercent.setActionCommand("min percent max");
        this.minPercent.addActionListener(this);
        this.minPercent.setVisible(false);
        JPanel minPanel = new JPanel();
        minPanel.setLayout(new BoxLayout(minPanel, 0));
        minPanel.add(Box.createHorizontalGlue());
        minPanel.add(this.thresholdLabel);
        minPanel.add(this.thresholdText);
        minPanel.add(this.optionsPanel);
        minPanel.add(this.minPercent);
        if (this.isROI || this.isLogical) {
            minPanel.add(this.shrinkWrap);
        }
        minPanel.add(Box.createHorizontalGlue());
        this.thresholdPanel = new JPanel();
        this.thresholdPanel.setLayout(new BoxLayout(this.thresholdPanel, 1));
        this.thresholdPanel.add(Box.createVerticalGlue());
        this.thresholdPanel.add(this.typePanel);
        this.thresholdPanel.add(minPanel);
        this.thresholdPanel.add(Box.createVerticalGlue());
        this.typePanel.setVisible(false);
        VoxelDimensions vd = this.viewer.getVolume().getVoxelDimensions();
        if (this.isOverlay && (vdOvly = this.viewer.getOverlayManager().getOverlay(this.currentIndex).getVolume().getVoxelDimensions()).getVolume() > vd.getVolume()) {
            vd = vdOvly;
        }
        this.resX = new MangoTextField(FORMATTER2.format(vd.getXSize()), 4);
        this.resX.setMinimumSize(this.resX.getPreferredSize());
        this.resX.setMaximumSize(this.resX.getPreferredSize());
        JLabel xResLabel = new JLabel("X");
        this.resY = new MangoTextField(FORMATTER2.format(vd.getYSize()), 4);
        this.resY.setMinimumSize(this.resY.getPreferredSize());
        this.resY.setMaximumSize(this.resY.getPreferredSize());
        JLabel yResLabel = new JLabel("Y");
        this.resZ = new MangoTextField(FORMATTER2.format(vd.getZSize()), 4);
        this.resZ.setMinimumSize(this.resZ.getPreferredSize());
        this.resZ.setMaximumSize(this.resZ.getPreferredSize());
        JLabel zResLabel = new JLabel("Z");
        JPanel resPanel = new JPanel();
        resPanel.setLayout(new BoxLayout(resPanel, 0));
        resPanel.add(Box.createHorizontalGlue());
        resPanel.add(xResLabel);
        resPanel.add(Box.createHorizontalStrut(2));
        resPanel.add(this.resX);
        resPanel.add(Box.createHorizontalStrut(8));
        resPanel.add(yResLabel);
        resPanel.add(Box.createHorizontalStrut(2));
        resPanel.add(this.resY);
        resPanel.add(Box.createHorizontalStrut(8));
        resPanel.add(zResLabel);
        resPanel.add(Box.createHorizontalStrut(2));
        resPanel.add(this.resZ);
        resPanel.add(Box.createHorizontalGlue());
        resPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Resolution"));
        this.resPanelOuter = new JPanel();
        this.resPanelOuter.setLayout(new BoxLayout(this.resPanelOuter, 1));
        this.resPanelOuter.add(Box.createVerticalStrut(4));
        this.resPanelOuter.add(resPanel);
        this.resPanelOuter.setVisible(false);
        this.smoothIterations = new MangoTextField("", 4);
        this.smoothIterations.setMinimumSize(this.smoothIterations.getPreferredSize());
        this.smoothIterations.setMaximumSize(this.smoothIterations.getPreferredSize());
        this.smoothIterationsLabel = new JLabel("Number of Iterations");
        this.smoothIterationsLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        JPanel smoothIterationsPanel = new JPanel();
        smoothIterationsPanel.setLayout(new BoxLayout(smoothIterationsPanel, 0));
        smoothIterationsPanel.add(Box.createHorizontalGlue());
        smoothIterationsPanel.add(this.smoothIterationsLabel);
        smoothIterationsPanel.add(this.smoothIterations);
        this.smoothError = new MangoTextField("", 4);
        this.smoothError.setMinimumSize(this.smoothError.getPreferredSize());
        this.smoothError.setMaximumSize(this.smoothError.getPreferredSize());
        this.smoothErrorLabel = new JLabel("Point Error Threshold (mm)");
        this.smoothErrorLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        JPanel smoothErrorPanel = new JPanel();
        smoothErrorPanel.setLayout(new BoxLayout(smoothErrorPanel, 0));
        smoothErrorPanel.add(Box.createHorizontalGlue());
        smoothErrorPanel.add(this.smoothErrorLabel);
        smoothErrorPanel.add(this.smoothError);
        this.featureAngle = new MangoTextField("", 4);
        this.featureAngle.setMinimumSize(this.featureAngle.getPreferredSize());
        this.featureAngle.setMaximumSize(this.featureAngle.getPreferredSize());
        this.featureAngleLabel = new JLabel("Feature Angle Threshold (deg)");
        this.featureAngleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        JPanel featureAnglePanel = new JPanel();
        featureAnglePanel.setLayout(new BoxLayout(featureAnglePanel, 0));
        featureAnglePanel.add(Box.createHorizontalGlue());
        featureAnglePanel.add(this.featureAngleLabel);
        featureAnglePanel.add(this.featureAngle);
        JPanel smoothPanel = new JPanel();
        smoothPanel.setLayout(new BoxLayout(smoothPanel, 1));
        smoothPanel.add(Box.createVerticalStrut(4));
        smoothPanel.add(smoothErrorPanel);
        smoothPanel.add(Box.createVerticalStrut(2));
        smoothPanel.add(featureAnglePanel);
        smoothPanel.add(Box.createVerticalStrut(2));
        smoothPanel.add(smoothIterationsPanel);
        this.smoothPanelOuter = new JPanel();
        this.smoothPanelOuter.setLayout(new BoxLayout(this.smoothPanelOuter, 0));
        this.smoothPanelOuter.add(Box.createHorizontalGlue());
        this.smoothPanelOuter.add(smoothPanel);
        this.smoothPanelOuter.add(Box.createHorizontalGlue());
        this.smoothPanelOuter.setVisible(false);
        this.surfaceFilterCheckboxBorder = new MangoTitledCheckboxBorder(this.smoothPanelOuter, this, "Surface Filtering");
        this.smoothPanelOuter.setBorder(this.surfaceFilterCheckboxBorder);
        this.filterSize = new MangoTextField("", 4);
        this.filterSize.setMinimumSize(this.filterSize.getPreferredSize());
        this.filterSize.setMaximumSize(this.filterSize.getPreferredSize());
        this.filterSizeLabel = new JLabel("Kernel");
        this.filterFWHM = new MangoTextField("", 4);
        this.filterFWHM.setMinimumSize(this.filterFWHM.getPreferredSize());
        this.filterFWHM.setMaximumSize(this.filterFWHM.getPreferredSize());
        this.filterFWHMLabel = new JLabel("Width");
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BoxLayout(filterPanel, 0));
        filterPanel.add(Box.createHorizontalGlue());
        filterPanel.add(this.filterFWHMLabel);
        filterPanel.add(Box.createHorizontalStrut(2));
        filterPanel.add(this.filterFWHM);
        filterPanel.add(Box.createHorizontalStrut(4));
        filterPanel.add(this.filterSizeLabel);
        filterPanel.add(Box.createHorizontalStrut(2));
        filterPanel.add(this.filterSize);
        filterPanel.add(Box.createHorizontalGlue());
        this.smoothImagePanel = new JPanel();
        this.smoothImagePanel.setLayout(new BoxLayout(this.smoothImagePanel, 1));
        this.smoothImagePanel.add(Box.createVerticalStrut(4));
        this.smoothImagePanel.add(filterPanel);
        this.imageFilterCheckboxBorder = new MangoTitledCheckboxBorder(this.smoothImagePanel, this, "Image Smoothing");
        this.smoothImagePanel.setBorder(this.imageFilterCheckboxBorder);
        this.smoothImagePanel.setVisible(false);
        if (this.isROI || this.isLogical) {
            this.thresholdText.setVisible(false);
            this.thresholdLabel.setVisible(false);
            this.shrinkWrap.setVisible(false);
        }
        this.setLayout(new BoxLayout(this, 1));
        if (this.isROI || this.isOverlay || this.isLogical) {
            this.add(this.nameColorPanel);
        }
        this.add(this.thresholdPanel);
        this.add(this.smoothImagePanel);
        this.add(this.resPanelOuter);
        this.add(this.smoothPanelOuter);
        this.add(Box.createVerticalStrut(4));
        this.add(this.presetsPanel);
        Object obj = this.viewer.getMango().readSetting(PRESET_STORE_NAME);
        customPreset = obj != null && obj instanceof SurfaceBuildParameters ? (SurfaceBuildParameters)obj : this.makeCustomPreset();
        if (this.presetMode == 0) {
            this.updateToStandardPreset();
        } else if (this.presetMode == 2) {
            this.updateToCustomPreset();
        }
    }

    private int getFilterSize() {
        String text = this.filterSize.getText();
        double val = 0.0;
        try {
            val = Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return (int)Math.round(val);
    }

    private boolean isUsingBetterGraphics() {
        return this.betterGraphics.isSelected() || SurfaceViewer.isUseShaders();
    }

    private SurfaceBuildParameters makeCustomPreset() {
        Volume volume = this.viewer.getVolume();
        if (this.isOverlay) {
            volume = this.viewer.getOverlayManager().getOverlay(this.currentIndex).getVolume();
        }
        return new SurfaceBuildParameters(volume);
    }

    private void makeLogicalPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.addPopupMenuListener(this);
        Vector<LogicalPanel> logicals = this.viewer.getLogicalManager().getLogicalPanels();
        if (logicals != null) {
            for (int ctr = 0; ctr < logicals.size(); ++ctr) {
                LogicalPanel lp = logicals.get(ctr);
                if (lp.isEmptyLogical()) continue;
                if (ctr == 0) {
                    this.currentColor = lp.getLogical().getColor();
                }
                MangoSquareMenuItem mp = new MangoSquareMenuItem(lp.getLogical().getColor());
                mp.setPreferredSize(new Dimension(30, 30));
                mp.setBackground(this.viewer.getToolBox().getPopupMenuItemColor());
                mp.setContentAreaFilled(true);
                mp.setActionCommand("logical" + ctr);
                mp.addActionListener(this);
                this.popupMenu.add(mp);
            }
        }
    }

    private void makeNameAndColorPanel() {
        String nameStr = "";
        if (this.isOverlay) {
            this.currentIndex = Math.max(this.viewer.getCurrentOverlayIndex(), 0);
            ScreenVolume overlay = this.viewer.getOverlayManager().getOverlay(this.currentIndex);
            nameStr = overlay.getName();
            int dotIndex = nameStr.indexOf(46);
            if (dotIndex != -1) {
                nameStr = nameStr.substring(0, dotIndex);
            }
            if (overlay.getVolume().getNumTimepoints() > 1) {
                nameStr = nameStr + " (" + (overlay.getVolume().getCurrentTimepoint() + 1) + " of " + overlay.getVolume().getNumTimepoints() + ")";
            }
        } else if (this.isROI) {
            this.currentROI = this.viewer.getRoiColor();
            nameStr = this.viewer.getROIManager().getLabel(this.currentROI, "ROI (" + ROIDefaultLabels.getDefaultLabelBitPlaneOrder(this.currentROI, this.viewer.getROIManager().getBuffer().getMaximumColors()) + ")");
        } else if (this.isLogical) {
            nameStr = "Logical";
        }
        this.name = new MangoTextField(nameStr, 15);
        this.name.setMaximumSize(this.name.getPreferredSize());
        this.name.setMinimumSize(this.name.getPreferredSize());
        this.makePopupMenu();
        this.popupButton.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.popupButton.setFocusable(false);
        this.popupButton.addActionListener(this);
        this.popupButton.setEnabled(true);
        this.popupButton.setPreferredSize(Toolbox.BUTTON_SIZE);
        this.popupButton.setMaximumSize(Toolbox.BUTTON_SIZE);
        this.popupButton.setMinimumSize(Toolbox.BUTTON_SIZE);
        JPanel selectPanel = new JPanel(new BorderLayout());
        selectPanel.setBackground(Color.WHITE);
        selectPanel.add((Component)this.popupButton, "Center");
        selectPanel.setPreferredSize(this.popupButton.getPreferredSize());
        selectPanel.setMaximumSize(selectPanel.getPreferredSize());
        selectPanel.setMinimumSize(selectPanel.getPreferredSize());
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        namePanel.add(Box.createHorizontalGlue());
        namePanel.add(this.name);
        namePanel.add(Box.createHorizontalStrut(8));
        namePanel.add(selectPanel);
        namePanel.add(Box.createHorizontalGlue());
        JButton colorButton = new JButton("Select Color...");
        colorButton.setFocusable(false);
        colorButton.addActionListener(this);
        this.solidSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(BuildSurfaceDialog.this.currentColor.getRed(), BuildSurfaceDialog.this.currentColor.getGreen(), BuildSurfaceDialog.this.currentColor.getBlue()));
                g.fillRect(0, 0, 21, 21);
                g.setColor(Color.DARK_GRAY);
                g.drawRect(0, 0, 21, 21);
            }
        };
        this.solidSwatchPanel.setPreferredSize(new Dimension(22, 22));
        this.solidSwatchPanel.setMaximumSize(this.solidSwatchPanel.getPreferredSize());
        this.solidSwatchPanel.setMinimumSize(this.solidSwatchPanel.getPreferredSize());
        JPanel solidPanel = new JPanel();
        solidPanel.setLayout(new BoxLayout(solidPanel, 0));
        solidPanel.add(Box.createHorizontalGlue());
        solidPanel.add(colorButton);
        solidPanel.add(Box.createHorizontalStrut(4));
        solidPanel.add(this.solidSwatchPanel);
        solidPanel.add(Box.createHorizontalGlue());
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        colorPanel.add(Box.createHorizontalGlue());
        colorPanel.add(solidPanel);
        colorPanel.add(Box.createHorizontalGlue());
        this.nameColorPanel = new JPanel();
        this.nameColorPanel.setLayout(new BoxLayout(this.nameColorPanel, 1));
        this.nameColorPanel.add(namePanel);
        this.nameColorPanel.add(colorPanel);
        this.nameColorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Name & Color"));
        if (this.isROI) {
            this.colorSelected(this.currentROI);
        }
    }

    private void makeOverlayPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.addPopupMenuListener(this);
        int numOverlays = this.viewer.getOverlayManager().getNumInStack();
        this.icons = this.viewer.getToolBox().getOverlayImageIcons();
        for (int ctr = 0; ctr < numOverlays; ++ctr) {
            MangoSquareMenuItem mp = new MangoSquareMenuItem(this.icons[ctr]);
            mp.setPreferredSize(new Dimension(30, 30));
            mp.setBackground(this.viewer.getToolBox().getPopupMenuItemColor());
            mp.setContentAreaFilled(true);
            mp.setActionCommand("overlay" + ctr);
            mp.addActionListener(this);
            this.popupMenu.add(mp);
        }
        this.currentColor = new Color(((BufferedImage)this.icons[this.currentIndex].getImage()).getRGB(0, 0));
    }

    private void makePopupMenu() {
        if (this.isOverlay) {
            this.makeOverlayPopupMenu();
            this.popupButton = new MangoSquareButton(this.icons[this.currentIndex], false, this.viewer.getMango());
            this.popupButton.setActionCommand("overlayButtonToggle");
        } else if (this.isROI) {
            this.popupButton = new MangoColorButton(this.currentROI, (ColorManager)this.viewer.getROIManager(), this.viewer);
            this.popupButton.setActionCommand("roiButtonToggle");
        } else if (this.isLogical) {
            this.makeLogicalPopupMenu();
            this.popupButton = new MangoSquareButton(this.viewer.getLogicalManager().getLogicalPanels().get(this.currentIndex).getLogical().getColor(), false, this.viewer.getMango());
            this.popupButton.setActionCommand("overlayButtonToggle");
        }
    }

    private void negativeChanged() {
        if (this.negativeBox.isSelected()) {
            this.thresholdLabel.setText("Maximum");
        } else {
            this.thresholdLabel.setText("Minimum");
        }
        this.updateThreshold();
    }

    private void showOptions() {
        this.thresholdPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Surface Threshold"));
        this.typePanel.removeAll();
        this.typePanel.add(Box.createHorizontalGlue());
        if (!this.isROI && !this.isLogical) {
            this.typePanel.add(this.shrinkWrap);
            this.typePanel.add(this.negativeBox);
        }
        this.typePanel.add(Box.createHorizontalGlue());
        this.typePanel.revalidate();
        this.presetsPanel.add(Box.createHorizontalGlue(), 1);
        this.presetsPanel.add((Component)this.presetLabel, 1);
        this.thresholdLabel.setText("Minimum");
        this.thresholdText.setVisible(true);
        if (this.isROI || this.isLogical) {
            this.thresholdLabel.setVisible(false);
        }
        if (this.isROI || this.isOverlay || this.isLogical) {
            this.nameColorPanel.setVisible(true);
        }
        this.optionsButton.setVisible(false);
        this.optionsPanel.setVisible(false);
        this.minPercent.setVisible(true);
        this.typePanel.setVisible(!this.isROI && !this.isLogical);
        this.smoothImagePanel.setVisible(true);
        this.resPanelOuter.setVisible(true);
        this.smoothPanelOuter.setVisible(true);
        this.shrinkWrap.setVisible(true);
        if (this.dialog != null) {
            this.dialog.showAndCenter();
        }
    }

    private void showROIColorPicker() {
        this.popupROI = PopupFactory.getSharedInstance().getPopup(this.popupButton, new MangoColorPicker((ColorManager)this.viewer.getROIManager(), this, this.viewer.getROIManager(), this.viewer.getROIManager().getBuffer().getMaximumColors(), false), this.popupButton.getLocationOnScreen().x, this.popupButton.getLocationOnScreen().y + 35);
        this.popupROI.show();
    }

    private void updateImageSmoothingPanel() {
        boolean useImageFiltering = this.imageFilterCheckboxBorder.isSelected();
        this.filterSize.setEnabled(useImageFiltering);
        this.filterSizeLabel.setEnabled(useImageFiltering);
        this.filterFWHM.setEnabled(useImageFiltering);
        this.filterFWHMLabel.setEnabled(useImageFiltering);
    }

    private void updateSurfaceSmoothingPanel() {
        boolean useSurfaceSmoothing = this.surfaceFilterCheckboxBorder.isSelected();
        this.smoothIterationsLabel.setEnabled(useSurfaceSmoothing);
        this.smoothErrorLabel.setEnabled(useSurfaceSmoothing);
        this.featureAngleLabel.setEnabled(useSurfaceSmoothing);
        this.smoothIterations.setEnabled(useSurfaceSmoothing);
        this.smoothError.setEnabled(useSurfaceSmoothing);
        this.featureAngle.setEnabled(useSurfaceSmoothing);
    }

    private void updateThreshold() {
        if (this.isOverlay) {
            this.thresholdText.setText(FORMATTER.format(this.viewer.getOverlayManager().getOverlay(this.currentIndex).getScreenMin()));
        } else if (this.isROI || this.isLogical) {
            this.thresholdText.setText(ROI_DEFAULT_THRESHOLD);
        } else {
            double diff = this.viewer.getScreenVolume().getDynamicScreenMax() - this.viewer.getScreenVolume().getDynamicScreenMin();
            double threshold = this.negativeBox.isSelected() ? this.viewer.getScreenVolume().getDynamicScreenMax() - diff / 3.0 : this.viewer.getScreenVolume().getDynamicScreenMin() + diff / 3.0;
            if (Math.abs(threshold) > 10.0) {
                threshold = Math.round(threshold);
            }
            this.thresholdText.setText(FORMATTER.format(threshold));
        }
    }

    private void updateToCustomPreset() {
        this.presetMode = 2;
        this.shrinkWrap.setSelected(customPreset.isUseShrinkWrap());
        this.imageFilterCheckboxBorder.setSelected(customPreset.isUseImageSmoothing());
        this.filterSize.setText(String.valueOf(customPreset.getSmoothingKernel()));
        this.filterFWHM.setText(String.valueOf(customPreset.getSmoothingWidth()));
        this.updateImageSmoothingPanel();
        this.surfaceFilterCheckboxBorder.setSelected(customPreset.isUseSurfaceSmoothing());
        this.smoothError.setText(FORMATTER2.format(this.calculateDefaultFeatureError()));
        this.featureAngle.setText(String.valueOf(customPreset.getFeatureAngle()));
        this.smoothIterations.setText(String.valueOf(customPreset.getSurfaceSmoothingIterations()));
        this.updateSurfaceSmoothingPanel();
    }

    private void updateToStandardPreset() {
        this.presetMode = 0;
        this.shrinkWrap.setSelected(true);
        boolean smallImage = this.isOverlay || this.isLogical ? this.viewer.getOverlayManager().getOverlay(this.currentIndex).getVolume().getNumVoxelsInVolume() < 262144 : this.viewer.getVolume().getNumVoxelsInVolume() < 262144;
        this.imageFilterCheckboxBorder.setSelected(!smallImage);
        this.filterSize.setText(String.valueOf(3));
        this.filterFWHM.setText(String.valueOf(2.0f));
        this.updateImageSmoothingPanel();
        boolean largeImage = this.viewer.getVolume().getNumVoxelsInVolume() > 0x1000000;
        this.surfaceFilterCheckboxBorder.setSelected(largeImage || !this.isUsingBetterGraphics());
        this.smoothError.setText(FORMATTER2.format(this.calculateDefaultFeatureError()));
        this.featureAngle.setText(String.valueOf(44.0f));
        this.smoothIterations.setText(String.valueOf(1));
        this.updateSurfaceSmoothingPanel();
    }

    static {
        FORMATTER = new MangoNumberFormatter(1, false);
        FORMATTER2 = new MangoNumberFormatter(0, false);
    }
}

