/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.dialogs;

import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceBuildParameters;
import edu.uthscsa.ric.mango.viewersurface.window.SurfaceFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SurfaceInfoDialog
extends JFrame
implements ViewerAssociated {
    private final SurfaceViewer renderer;
    private JTextArea contents;
    public static final String DESCRIPTION = "Surface Info";
    public static final Dimension START_SIZE = new Dimension(450, 400);
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    private static final long serialVersionUID = 1L;

    public SurfaceInfoDialog(SurfaceViewer renderer) {
        this.renderer = renderer;
        this.createAndShow();
    }

    private final void createAndShow() {
        this.contents = new JTextArea();
        this.contents.setEditable(false);
        this.contents.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JScrollPane scrollPane = new JScrollPane(this.contents);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanel.add((Component)scrollPane, "Center");
        this.getContentPane().setPreferredSize(START_SIZE);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setTitle("Surface Info: " + this.getViewer().getImageTitle());
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.setDefaultCloseOperation(1);
        this.updateInfo();
        this.setVisible(true);
        this.setResizable(true);
        this.getViewer().associateWindow(this);
    }

    public final void updateInfo() {
        this.contents.setText("");
        Vector<CompositeSurface> surfaces = this.renderer.getShapes();
        for (CompositeSurface surface : surfaces) {
            if (surface.isBaseSurface()) {
                this.contents.append("Surface \n");
            } else {
                this.contents.append("Shape: " + surface.getName() + "\n");
            }
            if (surface.getParams() != null) {
                this.contents.append(this.makeBuildString(surface.getParams()) + "\n");
            } else if (surface.isBaseSurface()) {
                this.contents.append(surface.getDescription() + "\n");
            }
            this.contents.append("  Points=" + surface.getNumPoints() + "\n");
            this.contents.append("  Triangles=" + surface.getNumTriangles() + "\n\n");
        }
        this.pack();
        SurfaceFrame frame = this.renderer.getFrame();
        if (frame != null) {
            this.setLocation(DisplayUtils.getCenterDialogLocationRelative(frame, this.getSize()));
        }
        this.contents.setCaretPosition(0);
    }

    private String makeBuildString(SurfaceBuildParameters params) {
        String str = "  " + (params.isUseNegative() ? "Maximum" : "Minimum") + " Threshold: " + params.getThreshold() + " ";
        str = str + "\n  Shrink Wrap: " + (params.isUseShrinkWrap() ? "Yes" : "No");
        str = params.isUseImageSmoothing() ? str + "\n  Image Smoothing: Width=" + params.getFilterFWHM() + " Kernel=" + params.getFilterSize() : str + "\n  Image Smoothing: (none)";
        str = str + "\n  Resolution: X=" + params.getResX() + " Y=" + params.getResY() + " Z=" + params.getResZ();
        str = params.isUseSurfaceSmoothing() ? str + "\n  Surface Smoothing: Error=" + params.getFeatureError() + " Angle=" + params.getFeatureAngle() + "\u00b0 Iterations=" + params.getSurfaceSmoothingIterations() : str + "\n  Surface Smoothing: (none)";
        str = str + "\n  Build Time: " + FORMATTER.format((double)params.getBuildTime() / 1000.0) + "s";
        return str;
    }

    @Override
    public SliceViewer getViewer() {
        return this.renderer.getViewer();
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }
}

