/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.core.TriangleVertex;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class TriangleVertexLoop {
    protected Point3f averageCenter;
    protected Vector3f averageNormal;
    protected TriangleVertex[] verts;

    protected TriangleVertexLoop(TriangleVertex[] verts, Vector3f norm, Point3f center) {
        this.verts = verts;
        this.averageNormal = norm;
        this.averageCenter = center;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Loop [ ");
        for (TriangleVertex vert : this.verts) {
            sb.append(vert.toString());
            sb.append(' ');
        }
        sb.append(" ] " + this.averageNormal + " " + this.averageCenter);
        return sb.toString();
    }

    protected TriangleVertexLoop[] split() {
        int countOriginal = this.verts.length;
        if (countOriginal <= 3) {
            return null;
        }
        Point3f p1 = null;
        Point3f p2 = null;
        Point3f p3 = new Point3f();
        Vector3f p3p1 = new Vector3f();
        Vector3f p3p2 = new Vector3f();
        Vector3f cross = new Vector3f();
        int startMax = this.verts.length / 2;
        int endMax = this.verts.length - 4;
        int startBest = 0;
        int endBest = 0;
        double aspectRatio = 0.0;
        boolean valid = true;
        for (int ctrStart = 0; ctrStart <= startMax; ++ctrStart) {
            int start = 0;
            int end = 0;
            for (int ctrEnd = 0; ctrEnd <= endMax; ++ctrEnd) {
                double ratio;
                double distanceABS;
                double distance;
                start = ctrStart;
                end = (ctrStart + 2 + ctrEnd) % this.verts.length;
                p1 = this.verts[start].point;
                p2 = this.verts[end].point;
                p3.set(p1.x + this.averageNormal.x, p1.y + this.averageNormal.y, p1.z + this.averageNormal.z);
                p3p1.set(p3.x - p1.x, p3.y - p1.y, p3.z - p1.z);
                p3p2.set(p3.x - p2.x, p3.y - p2.y, p3.z - p2.z);
                cross.cross(p3p1, p3p2);
                cross.normalize();
                Vector3f pointToPlane = p3p1;
                valid = true;
                double splitLineDistance = p1.distance(p2);
                double minDistance = -1.0;
                double previousDistance = 0.0;
                int ctr = (start + 1) % this.verts.length;
                while (ctr != end && valid) {
                    pointToPlane.set(this.verts[ctr].point.x - p1.x, this.verts[ctr].point.y - p1.y, this.verts[ctr].point.z - p1.z);
                    distance = pointToPlane.dot(cross);
                    distanceABS = Math.abs(distance);
                    if (previousDistance != 0.0 && (distance > 0.0 && previousDistance < 0.0 || distance < 0.0 && previousDistance > 0.0)) {
                        valid = false;
                    }
                    previousDistance = distance;
                    if (minDistance == -1.0 || minDistance > distanceABS) {
                        minDistance = distanceABS;
                    }
                    ctr = (ctr + 1) % this.verts.length;
                }
                if (valid) {
                    previousDistance *= -1.0;
                    ctr = (end + 1) % this.verts.length;
                    while (ctr != start && valid) {
                        pointToPlane.set(this.verts[ctr].point.x - p1.x, this.verts[ctr].point.y - p1.y, this.verts[ctr].point.z - p1.z);
                        distance = pointToPlane.dot(cross);
                        distanceABS = Math.abs(distance);
                        if (distance > 0.0 && previousDistance < 0.0 || distance < 0.0 && previousDistance > 0.0) {
                            valid = false;
                        }
                        previousDistance = distance;
                        if (minDistance > distanceABS) {
                            minDistance = distanceABS;
                        }
                        ctr = (ctr + 1) % this.verts.length;
                    }
                }
                if (!(aspectRatio < (ratio = minDistance / splitLineDistance))) continue;
                aspectRatio = ratio;
                startBest = start;
                endBest = end;
            }
        }
        if (!valid) {
            return null;
        }
        if (aspectRatio < 0.01) {
            return null;
        }
        return this.split(startBest, endBest);
    }

    protected TriangleVertexLoop[] split(int startBest, int endBest) {
        int ctr;
        int countOriginal = this.verts.length;
        int countNew1 = 1;
        int ctr2 = startBest;
        while (ctr2 != endBest) {
            ctr2 = (ctr2 + 1) % this.verts.length;
            ++countNew1;
        }
        int countNew2 = countOriginal - countNew1 + 2;
        TriangleVertex[] vertsOriginal = this.verts;
        TriangleVertex[] vertsNew1 = new TriangleVertex[countNew1];
        TriangleVertex[] vertsNew2 = new TriangleVertex[countNew2];
        int startIndex1 = startBest;
        int startIndex2 = endBest;
        for (ctr = 0; ctr < vertsNew1.length; ++ctr) {
            vertsNew1[ctr] = vertsOriginal[(startIndex1 + ctr) % vertsOriginal.length];
        }
        for (ctr = 0; ctr < vertsNew2.length; ++ctr) {
            vertsNew2[ctr] = vertsOriginal[(startIndex2 + ctr) % vertsOriginal.length];
        }
        return new TriangleVertexLoop[]{new TriangleVertexLoop(vertsNew1, this.averageNormal, this.averageCenter), new TriangleVertexLoop(vertsNew2, this.averageNormal, this.averageCenter)};
    }
}

