/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import com.jogamp.common.nio.Buffers;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.Quad;
import edu.uthscsa.ric.mango.viewersurface.core.ROISlice;
import edu.uthscsa.ric.roi.mask.display.ROIShape;
import java.nio.FloatBuffer;

public class ROI {
    private FloatBuffer quadBuffer;
    private FloatBuffer workingBuffer;
    private ROISlice[] slices;
    private boolean needsBufferSwitch;
    private int direction;
    private int quadCount;
    private int workingQuadCount;
    private final int xDim;
    private final int yDim;
    private final int zDim;
    public static final double BUFFER_RATIO = 1.1;

    public ROI(int xDim, int yDim, int zDim, int direction) {
        this.xDim = xDim;
        this.yDim = yDim;
        this.zDim = zDim;
        this.reset(direction);
    }

    public synchronized void createQuadBuffer() {
        this.workingQuadCount = this.countQuads();
        FloatBuffer buffer = this.makeBuffer();
        buffer.rewind();
        for (ROISlice slice : this.slices) {
            for (Quad quad : slice.getQuads()) {
                this.putQuad(buffer, quad);
            }
        }
        this.needsBufferSwitch = true;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getNumQuads() {
        return this.quadCount * 4;
    }

    public FloatBuffer getQuads() {
        return this.quadBuffer;
    }

    public void makeQuads(ROIShape roi, SurfaceViewer renderer, int slice) {
        this.slices[slice].makeQuads(roi, renderer);
    }

    public boolean needsBufferSwitch() {
        return this.needsBufferSwitch;
    }

    public void replaceQuads(byte[] aboveData, ROIShape roi, SurfaceViewer renderer, int slice) {
        if (this.slices[slice].isTop()) {
            this.slices[slice].copyMaskData(roi.getMaskData());
            this.slices[slice].makeQuads(roi, renderer);
        } else {
            this.slices[slice].copyMaskData(aboveData);
            this.slices[slice].makeQuads(roi, renderer);
        }
    }

    public final void reset(int direction) {
        this.direction = direction;
        if (direction == 0) {
            ROISlice previous = null;
            this.slices = new ROISlice[this.zDim];
            for (int ctr = 0; ctr < this.slices.length; ++ctr) {
                this.slices[ctr] = new ROISlice(this.xDim, this.yDim, ctr, direction);
                if (previous != null) {
                    previous.setNext(this.slices[ctr]);
                }
                previous = this.slices[ctr];
            }
            this.slices[0].setTop(true);
            this.slices[this.slices.length - 1].setBottom(true);
        } else if (direction == 1) {
            ROISlice previous = null;
            this.slices = new ROISlice[this.yDim];
            for (int ctr = 0; ctr < this.slices.length; ++ctr) {
                this.slices[ctr] = new ROISlice(this.xDim, this.zDim, ctr, direction);
                if (previous != null) {
                    previous.setNext(this.slices[ctr]);
                }
                previous = this.slices[ctr];
            }
            this.slices[0].setTop(true);
            this.slices[this.slices.length - 1].setBottom(true);
        } else if (direction == 2) {
            ROISlice previous = null;
            this.slices = new ROISlice[this.xDim];
            for (int ctr = 0; ctr < this.slices.length; ++ctr) {
                this.slices[ctr] = new ROISlice(this.yDim, this.zDim, ctr, direction);
                if (previous != null) {
                    previous.setNext(this.slices[ctr]);
                }
                previous = this.slices[ctr];
            }
            this.slices[0].setTop(true);
            this.slices[this.slices.length - 1].setBottom(true);
        }
    }

    public synchronized void switchBuffered() {
        FloatBuffer tempBuffer = this.quadBuffer;
        this.quadBuffer = this.workingBuffer;
        this.quadCount = this.workingQuadCount;
        this.workingBuffer = tempBuffer;
        this.needsBufferSwitch = false;
    }

    private int countQuads() {
        int count = 0;
        for (ROISlice slice : this.slices) {
            count += slice.getQuadCount();
        }
        return count;
    }

    private synchronized FloatBuffer makeBuffer() {
        if (this.workingBuffer == null || this.workingBuffer.capacity() / 12 < this.workingQuadCount) {
            this.workingBuffer = Buffers.newDirectFloatBuffer((int)((int)((double)this.workingQuadCount * 1.1) * 4 * 3));
        }
        return this.workingBuffer;
    }

    private void putQuad(FloatBuffer buffer, Quad quad) {
        buffer.put(quad.p1.x);
        buffer.put(quad.p1.y);
        buffer.put(quad.p1.z);
        buffer.put(quad.p2.x);
        buffer.put(quad.p2.y);
        buffer.put(quad.p2.z);
        buffer.put(quad.p3.x);
        buffer.put(quad.p3.y);
        buffer.put(quad.p3.z);
        buffer.put(quad.p4.x);
        buffer.put(quad.p4.y);
        buffer.put(quad.p4.z);
    }
}

