/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import edu.uthscsa.ric.mango.viewersurface.core.LineSegment;
import java.util.Vector;

public class Polygon {
    private final Vector<LineSegment> segments = new Vector();

    public Polygon(LineSegment segment) {
        this.segments.add(segment);
    }

    public boolean connect(LineSegment segment) {
        if (this.segments.firstElement().connects(segment)) {
            this.segments.insertElementAt(segment, 0);
            return true;
        }
        if (this.segments.lastElement().connects(segment)) {
            this.segments.add(segment);
            return true;
        }
        return false;
    }

    public boolean connect(Polygon polygon) {
        int numConnectingSegs = polygon.segments.size();
        if (this.segments.firstElement().equals(polygon.segments.firstElement())) {
            for (int ctr = 1; ctr < numConnectingSegs; ++ctr) {
                this.segments.insertElementAt(polygon.segments.get(ctr), 0);
            }
            return true;
        }
        if (this.segments.firstElement().equals(polygon.segments.lastElement())) {
            for (int ctr = numConnectingSegs - 2; ctr >= 0; --ctr) {
                this.segments.insertElementAt(polygon.segments.get(ctr), 0);
            }
            return true;
        }
        if (this.segments.lastElement().equals(polygon.segments.firstElement())) {
            for (int ctr = 1; ctr < numConnectingSegs; ++ctr) {
                this.segments.add(polygon.segments.get(ctr));
            }
            return true;
        }
        if (this.segments.lastElement().equals(polygon.segments.lastElement())) {
            for (int ctr = numConnectingSegs - 2; ctr >= 0; --ctr) {
                this.segments.add(polygon.segments.get(ctr));
            }
            return true;
        }
        return false;
    }

    public Vector<LineSegment> getSegments() {
        return this.segments;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Polygon [");
        for (LineSegment segment : this.segments) {
            sb.append(segment);
            sb.append(" ,");
        }
        sb.append(']');
        return sb.toString();
    }
}

