/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface.core;

import com.jogamp.opengl.GL2;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayListener;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.viewersurface.core.PickableSurface;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceBuildParameters;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceColorUpdater;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceData;
import edu.uthscsa.ric.mango.viewersurface.screen.Lighting;
import edu.uthscsa.ric.mango.viewersurface.screen.Material;
import edu.uthscsa.ric.mango.viewersurface.screen.SurfaceOverlay;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.visualization.surface.io.FloatIterator;
import edu.uthscsa.ric.visualization.surface.io.IndexIterator;
import edu.uthscsa.ric.visualization.surface.primitives.Overlay;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageVolume;
import java.lang.ref.WeakReference;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Vector;
import javax.vecmath.Point3d;

public final class CompositeSurface
implements Surface,
PickableSurface {
    private Coordinate pickedImageCoordinate;
    private FloatBuffer[] colorsBuffer;
    private FloatBuffer[] normalsBuffer;
    private FloatBuffer[] pointsBuffer;
    private IntBuffer[] indicesBuffer;
    private Material material;
    private Point3d pickedSurfaceCoordinate;
    private String description;
    private String name;
    private SurfaceBuildParameters params;
    private SurfaceColorUpdater colorUpdater;
    private Vector<SurfaceOverlay> overlays;
    private WeakReference<ImageVolume> associatedOverlay;
    private boolean baseSurface;
    private boolean buildFromOverlay;
    private boolean colorsAreDirty;
    private boolean colorsBound;
    private boolean hidden;
    private boolean useTransform;
    private double pickDistance;
    private double[] initialViewTransform;
    private double[] worldTransform;
    private float threshold = Float.MIN_VALUE;
    private int numParts;
    private boolean hasImportedColors;
    private static Lighting lighting = new Lighting();
    private static final int NUM_VBO_ELEMENTS = 3;
    private static final int NUM_VBO_ELEMENTS_WITH_INDICES = 4;
    public int[] vbo;
    public static final int NUM_PARTS = 8;
    public static final int VBO_COLORS = 2;
    public static final int VBO_INDICES = 3;
    public static final int VBO_NORMALS = 1;
    public static final int VBO_VERTICES = 0;

    public CompositeSurface(FloatBuffer pointsBuffer, FloatBuffer normalsBuffer, IntBuffer indicesBuffer, String name, float[] color) {
        this(name);
        this.numParts = 1;
        this.pointsBuffer = new FloatBuffer[]{pointsBuffer};
        this.normalsBuffer = new FloatBuffer[]{normalsBuffer};
        if (indicesBuffer != null) {
            this.indicesBuffer = new IntBuffer[]{indicesBuffer};
        }
        this.colorsBuffer = new FloatBuffer[this.numParts];
        this.material.setColorComponents(color);
    }

    public CompositeSurface(FloatBuffer[] pointsBuffer, FloatBuffer[] normalsBuffer, IntBuffer[] indexBuffers, String name, float[] color) {
        this(name);
        this.numParts = pointsBuffer.length;
        this.pointsBuffer = pointsBuffer;
        this.normalsBuffer = normalsBuffer;
        if (indexBuffers != null) {
            this.indicesBuffer = indexBuffers;
        }
        this.colorsBuffer = new FloatBuffer[this.numParts];
        this.material.setColorComponents(color);
    }

    public CompositeSurface(int numParts, String name) {
        this(name);
        this.numParts = numParts;
        this.pointsBuffer = new FloatBuffer[numParts];
        this.normalsBuffer = new FloatBuffer[numParts];
        this.colorsBuffer = new FloatBuffer[numParts];
    }

    public CompositeSurface(SurfaceData surface) {
        this(surface.getPointsBuffer(), surface.getNormalsBuffer(), surface.getIndicesBuffer(), surface.getName(), surface.getColor());
        this.setDescription(surface.getDescription());
        this.setBaseSurface(surface.isBaseSurface());
        this.setThreshold(surface.getThreshold());
        Overlay[] overlays = surface.getOverlays();
        if (CollectionUtilities.isNotEmpty((Object)overlays)) {
            for (Overlay overlay : overlays) {
                SurfaceOverlay so = new SurfaceOverlay(overlay.getScalars(), overlay.getMin(), overlay.getMax(), LookupTableManager.NAMES.get(3));
                this.overlays.add(so);
            }
        } else if (surface.getColorsBuffer() != null) {
            this.setColorsData(surface.getColorsBuffer());
        }
    }

    private CompositeSurface(String name) {
        this.material = new Material();
        this.material.setColorComponents(DEFAULT_COLOR);
        this.overlays = new Vector();
        this.name = name;
        this.pickedSurfaceCoordinate = new Point3d();
        this.pickedImageCoordinate = new Coordinate();
    }

    public void addColorsData(FloatBuffer colors, int index) {
        this.colorsBuffer[index] = colors;
        this.colorsAreDirty = true;
    }

    public void setColorsData(FloatBuffer colors) {
        this.colorsBuffer[0] = colors;
        this.colorsAreDirty = true;
        this.hasImportedColors = true;
    }

    public synchronized void addData(FloatBuffer points, FloatBuffer normals, IntBuffer indices, int index) {
        this.createIndicesBuffers();
        this.addData(points, normals, index);
        if (index == -1) {
            this.indicesBuffer[this.numParts - 1] = indices;
        } else {
            this.indicesBuffer[index] = indices;
        }
    }

    public SurfaceOverlay addOverlay(ScreenVolume overlay) {
        SurfaceOverlay so = new SurfaceOverlay(overlay, this.numParts);
        this.overlays.add(so);
        return so;
    }

    public void bindColorData(GL2 gl, boolean canUseVBO) {
        if (canUseVBO) {
            for (int ctr = 0; ctr < this.numParts; ++ctr) {
                gl.glBindBuffer(34962, this.vbo[ctr * this.getNumVboElements() + 2]);
                gl.glBufferData(34962, (long)(this.getNumPoints(ctr) * 4 * 4), this.colorsBuffer[ctr].rewind(), 35044);
            }
        }
        this.colorsBound = true;
        this.colorsAreDirty = false;
    }

    public boolean bindData(GL2 gl, boolean canUseVBO) {
        if (!this.isComplete()) {
            return false;
        }
        this.vbo = new int[this.numParts * this.getNumVboElements()];
        if (canUseVBO) {
            gl.glGenBuffers(this.numParts * this.getNumVboElements(), this.vbo, 0);
            for (int ctr = 0; ctr < this.numParts; ++ctr) {
                gl.glBindBuffer(34962, this.vbo[ctr * this.getNumVboElements() + 0]);
                gl.glBufferData(34962, (long)(this.getNumPoints(ctr) * 3 * 4), this.pointsBuffer[ctr].rewind(), 35044);
                gl.glBindBuffer(34962, this.vbo[ctr * this.getNumVboElements() + 1]);
                gl.glBufferData(34962, (long)(this.getNumPoints(ctr) * 3 * 4), this.normalsBuffer[ctr].rewind(), 35044);
                if (!this.isUsingIndices()) continue;
                gl.glBindBuffer(34962, this.vbo[ctr * this.getNumVboElements() + 3]);
                gl.glBufferData(34962, (long)(this.getNumTriangles(ctr) * 3 * 4), this.indicesBuffer[ctr].rewind(), 35044);
            }
        }
        return true;
    }

    public void clear(GL2 gl, OverlayListener ol, boolean canUseVBO) {
        if (canUseVBO) {
            if (this.vbo != null && gl != null) {
                gl.glDeleteBuffers(this.getNumVboElements(), this.vbo, 0);
            }
            this.vbo = null;
        }
        this.pointsBuffer = null;
        this.normalsBuffer = null;
        this.colorsBuffer = null;
        this.indicesBuffer = null;
        this.material = null;
        this.params = null;
        this.colorUpdater = null;
        if (this.overlays != null) {
            for (SurfaceOverlay so : this.overlays) {
                ScreenVolume sv = so.getOverlay();
                if (sv != null) {
                    sv.removeOverlayListener(ol);
                }
                so.clear();
            }
            this.overlays.clear();
            this.overlays = null;
        }
    }

    public boolean colorsAreDirty() {
        return this.colorsAreDirty;
    }

    public boolean colorsBound() {
        return this.colorsBound;
    }

    public ImageVolume getAssociatedOvelray() {
        if (this.associatedOverlay != null) {
            return (ImageVolume)this.associatedOverlay.get();
        }
        return null;
    }

    public float[] getColor() {
        return this.getMaterial().getColorComponents();
    }

    public FloatBuffer getColorsBuffer(int index) {
        return this.colorsBuffer[index];
    }

    public FloatIterator getColorsIterator() {
        return new FloatIterator(this.colorsBuffer);
    }

    public String getDescription() {
        return this.description;
    }

    public IntBuffer getIndicesBuffer(int index) {
        return this.indicesBuffer[index];
    }

    public IndexIterator getIndiciesIterator() {
        return new IndexIterator(this.indicesBuffer, this.getPointCounts());
    }

    public double[] getInitialViewTransform() {
        return this.initialViewTransform;
    }

    public Lighting getLighting() {
        return lighting;
    }

    public Material getMaterial() {
        return this.material;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public FloatBuffer getNormalsBuffer(int index) {
        return this.normalsBuffer[index];
    }

    public FloatIterator getNormalsIterator() {
        return new FloatIterator(this.normalsBuffer);
    }

    public int getNumParts() {
        return this.numParts;
    }

    public int getNumPoints() {
        int count = 0;
        for (FloatBuffer element : this.pointsBuffer) {
            count += element.capacity();
        }
        return count / 3;
    }

    public int getNumPoints(int index) {
        return this.pointsBuffer[index].capacity() / 3;
    }

    public int getNumTriangles() {
        if (this.isUsingIndices()) {
            int count = 0;
            for (IntBuffer element : this.indicesBuffer) {
                count += element.capacity();
            }
            return count / 3;
        }
        int count = 0;
        for (FloatBuffer element : this.pointsBuffer) {
            count += element.capacity();
        }
        return count / 9;
    }

    public int getNumTriangles(int index) {
        if (this.isUsingIndices()) {
            return this.indicesBuffer[index].capacity() / 3;
        }
        return this.pointsBuffer[index].capacity() / 9;
    }

    public int getNumVboElements() {
        if (this.isUsingIndices()) {
            return 4;
        }
        return 3;
    }

    public SurfaceOverlay getOverlay(ScreenVolume overlay) {
        for (SurfaceOverlay surfaceOverlay : this.overlays) {
            if (surfaceOverlay.getOverlay() != overlay) continue;
            return surfaceOverlay;
        }
        return null;
    }

    public Overlay[] getOverlays() {
        return this.overlays.toArray(new Overlay[this.overlays.size()]);
    }

    public SurfaceBuildParameters getParams() {
        return this.params;
    }

    @Override
    public double getPickDistance() {
        return this.pickDistance;
    }

    @Override
    public Coordinate getPickedImageCoordinate() {
        return this.pickedImageCoordinate;
    }

    @Override
    public Point3d getPickedSurfaceCoordinate() {
        return this.pickedSurfaceCoordinate;
    }

    public FloatBuffer getPointsBuffer(int index) {
        return this.pointsBuffer[index];
    }

    public FloatIterator getPointsIterator() {
        return new FloatIterator(this.pointsBuffer);
    }

    public Vector<SurfaceOverlay> getSurfaceOverlays() {
        return this.overlays;
    }

    public float getThreshold() {
        if (!MathUtilities.essentiallyEqual((float)this.threshold, (float)Float.MIN_VALUE)) {
            return this.threshold;
        }
        if (this.params != null) {
            return this.params.getThreshold();
        }
        return 0.0f;
    }

    public double[] getWorldTransform() {
        return this.worldTransform;
    }

    public boolean hasColors() {
        return this.overlays.size() > 0 || this.hasImportedColors;
    }

    @Override
    public boolean isBaseSurface() {
        return this.baseSurface;
    }

    public boolean isBuildFromOverlay() {
        return this.buildFromOverlay;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isUseTransform() {
        return this.useTransform;
    }

    public boolean isUsingIndices() {
        return this.indicesBuffer != null;
    }

    public boolean isVisible() {
        return !this.hidden;
    }

    public void rebindPoints(GL2 gl) {
        for (int ctr = 0; ctr < this.numParts; ++ctr) {
            gl.glBindBuffer(34962, this.vbo[ctr * this.getNumVboElements() + 0]);
            gl.glBufferData(34962, (long)(this.getNumPoints(ctr) * 3 * 4), this.pointsBuffer[ctr].rewind(), 35044);
        }
    }

    public void removeOverlay(ScreenVolume overlay) {
        SurfaceOverlay overlayToRemove = null;
        if (this.overlays != null) {
            for (SurfaceOverlay surfaceOverlay : this.overlays) {
                if (surfaceOverlay.getOverlay() != overlay) continue;
                overlayToRemove = surfaceOverlay;
                break;
            }
            this.overlays.remove(overlayToRemove);
        }
    }

    public void setAssociatedOverlay(ImageVolume overlay) {
        this.associatedOverlay = new WeakReference<ImageVolume>(overlay);
    }

    public void setBaseSurface(boolean baseSurface) {
        this.baseSurface = baseSurface;
    }

    public void setBuildFromOverlay(boolean buildFromOverlay) {
        this.buildFromOverlay = buildFromOverlay;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setInitialViewTransform(double[] initialViewTransform) {
        this.initialViewTransform = initialViewTransform;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParams(SurfaceBuildParameters params) {
        this.params = params;
    }

    @Override
    public void setPickDistance(double val) {
        this.pickDistance = val;
    }

    @Override
    public void setPickedImageCoordinate(Coordinate pickedImageCoordinate) {
        this.pickedImageCoordinate = pickedImageCoordinate;
    }

    @Override
    public void setPickedSurfaceCoordinate(Point3d pickedSurfaceCoordinate) {
        this.pickedSurfaceCoordinate = pickedSurfaceCoordinate;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public void setUseTransform(boolean useTransform) {
        this.useTransform = useTransform;
    }

    public void setWorldTransform(double[] worldTransform) {
        this.worldTransform = worldTransform;
    }

    public String toString() {
        return this.getName();
    }

    public void updateColors(SliceViewer viewer) {
        if (this.colorUpdater == null) {
            this.colorUpdater = new SurfaceColorUpdater(viewer, this.overlays, this);
        }
        if (this.overlays.size() > 0) {
            this.hasImportedColors = false;
            this.colorsAreDirty = this.colorUpdater.updateColors();
        }
    }

    private synchronized void addData(FloatBuffer points, FloatBuffer normals, int index) {
        if (index == -1) {
            this.pointsBuffer[this.numParts - 1] = points;
            this.normalsBuffer[this.numParts - 1] = normals;
        } else {
            this.pointsBuffer[index] = points;
            this.normalsBuffer[index] = normals;
        }
    }

    private void createIndicesBuffers() {
        if (this.indicesBuffer == null) {
            this.indicesBuffer = new IntBuffer[this.numParts];
        }
    }

    private int[] getPointCounts() {
        int[] counts = new int[this.numParts];
        for (int ctr = 0; ctr < this.numParts; ++ctr) {
            counts[ctr] = this.getNumPoints(ctr);
        }
        return counts;
    }

    private boolean isComplete() {
        for (int ctr = 0; ctr < this.numParts; ++ctr) {
            if (this.pointsBuffer[ctr] == null) {
                return false;
            }
            if (this.normalsBuffer[ctr] == null) {
                return false;
            }
            if (this.indicesBuffer == null || this.indicesBuffer[ctr] != null) continue;
            return false;
        }
        return true;
    }
}

