/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface;

import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import java.util.ArrayList;
import java.util.List;

public class SurfaceViewerSyncer {
    private final List<SurfaceViewer> viewers = new ArrayList<SurfaceViewer>();
    private boolean synced;

    public void addViewer(SurfaceViewer viewer) {
        this.viewers.add(viewer);
    }

    public void removeViewer(SurfaceViewer viewer) {
        if (viewer != null) {
            this.viewers.remove(viewer);
        }
    }

    public void syncDynamic(SurfaceViewer viewer) {
        double[] rotX = viewer.getPosition().getMouseRotateX();
        double[] rotY = viewer.getPosition().getMouseRotateY();
        double[] trans = viewer.getPosition().getMouseTranslate();
        double[] mat = viewer.getPosition().getViewTransform();
        int mode = viewer.getPosition().getDymamicMode();
        for (SurfaceViewer current : this.viewers) {
            if (current == viewer) continue;
            current.getPosition().copyTransform(rotX, rotY, trans, mode);
            current.getPosition().copyViewTransform(mat);
            current.updateSurface();
        }
    }

    public void sync(SurfaceViewer viewer) {
        double[] mat = viewer.getPosition().getViewTransform();
        for (SurfaceViewer current : this.viewers) {
            if (current == viewer) continue;
            current.getPosition().apply(null, mat);
            current.updateSurface();
        }
    }

    public void syncThis(SurfaceViewer viewer) {
        for (SurfaceViewer current : this.viewers) {
            if (current == viewer) continue;
            double[] mat = current.getPosition().getViewTransform();
            viewer.getPosition().apply(null, mat);
            viewer.updateSurface();
            break;
        }
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }
}

