/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewersurface;

import Jama.Matrix;
import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewersurface.core.AngleTool;
import edu.uthscsa.ric.mango.viewersurface.core.Marker;
import edu.uthscsa.ric.mango.viewersurface.core.PickableSurface;
import edu.uthscsa.ric.mango.viewersurface.core.RulerTool;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import java.awt.Point;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point3d;
import org.apache.commons.lang3.ArrayUtils;

public class SurfacePosition {
    private PickableSurface pickedSurface;
    private boolean pickDirty;
    private boolean resetZoom;
    private double[] mouseRotLast;
    private double[][] imageTransformMat;
    private double[][] imageTransformMatInverse;
    private double[][] postTrans;
    private double[][] preTrans;
    private double[][] sizeInverseTrans;
    private double[][] sizeTrans;
    private double[][] tempTrans1;
    private double[][] tempTrans2;
    private int dynamicMode;
    private int obliqueDirection;
    private int pickedOctant;
    private int zoom;
    private int zoomDefault;
    private int zoomDynamic;
    private int zoomSaved;
    private final FloatBuffer winZ;
    private final GLU glu;
    private final Point lastPoint = new Point();
    private final Point3d currentSurfaceCoord;
    private final double xHalf;
    private final double xSize;
    private final double yHalf;
    private final double ySize;
    private final double zHalf;
    private final double zSize;
    private final double[] coordTemp;
    private final double[] decomp;
    private final double[] imageTransform;
    private final double[] modelview;
    private final double[] mouseRotDrag;
    private final double[] mouseRotDragX;
    private final double[] mouseRotDragY;
    private final double[] mouseTemp;
    private final double[] mouseTranslate;
    private final double[] pickedSurfaceCoord;
    private final double[] pickedSurfaceCoordTemp;
    private final double[] projection;
    private final double[] saved;
    private final float[] theZ;
    private final int xDim;
    private final int yDim;
    private final int zDim;
    private final int[] viewport;
    private static final double[][] IDENTITY = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    public static final List<Double> ANTERIOR_ROTATION = CollectionUtilities.immutable((Double[])new Double[]{-1.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    public static final List<Double> DEFAULT_ROTATION = CollectionUtilities.immutable((Double[])new Double[]{-0.6540161112031582, 0.7404771237240793, -0.15477905390611574, 0.0, 0.45373659842363206, 0.2202656463411315, -0.8634848836505182, 0.0, -0.6052982946760322, -0.6349619471143849, -0.48003885278074304, 0.0, 0.0, 0.0, 0.0, 1.0});
    public static final List<Double> INFERIOR_ROTATION = CollectionUtilities.immutable((Double[])new Double[]{-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    public static final List<Double> LEFT_ROTATION = CollectionUtilities.immutable((Double[])new Double[]{0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    public static final List<Double> POSTERIOR_ROTATION = CollectionUtilities.immutable((Double[])new Double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    public static final List<Double> RIGHT_ROTATION = CollectionUtilities.immutable((Double[])new Double[]{0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    public static final List<Double> SUPERIOR_ROTATION = CollectionUtilities.immutable((Double[])new Double[]{1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    public static final double DEFAULT_MOUSE_SENSITIVITY = 0.3;
    public static final double DEFAULT_ZOOM_FACTOR = 1.5;
    public static final float DEFAULT_Z_FAR = 100000.0f;
    public static final float DEFAULT_Z_NEAR = 10.0f;
    public static final int ANIMATE_STEPS = 360;
    public static final int DEFAULT_ZOOM_SENSITIVITY = 3;
    public static final int MODE_ROTATE = 0;
    public static final int MODE_TRANSLATE = 1;
    public static final int MODE_ZOOM = 2;
    public static final int OCTANT_ANTERIOR = 2;
    public static final int OCTANT_LEFT = 1;
    public static final int OCTANT_SUPERIOR = 4;

    public static double[] applyTransform(double[][] xform, double xLoc, double yLoc, double zLoc, double[] coords) {
        double xTrans = xLoc * xform[0][0] + yLoc * xform[0][1] + zLoc * xform[0][2] + xform[0][3];
        double yTrans = xLoc * xform[1][0] + yLoc * xform[1][1] + zLoc * xform[1][2] + xform[1][3];
        double zTrans = xLoc * xform[2][0] + yLoc * xform[2][1] + zLoc * xform[2][2] + xform[2][3];
        coords[0] = xTrans;
        coords[1] = yTrans;
        coords[2] = zTrans;
        return coords;
    }

    private static void clearTransform(double[] xform) {
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                xform[ctrOut * 4 + ctrIn] = ctrOut == ctrIn ? 1.0 : 0.0;
            }
        }
    }

    private static boolean isIdentity(double[] xform) {
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                if (ctrOut == ctrIn && Math.abs(xform[ctrOut * 4 + ctrIn]) != 1.0) {
                    return false;
                }
                if (ctrOut == ctrIn || xform[ctrOut * 4 + ctrIn] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    private static double validateNum(double num) {
        if (Double.isInfinite(num)) {
            return 0.0;
        }
        if (Double.isNaN(num)) {
            return 0.0;
        }
        if (num == 0.0) {
            return 0.0;
        }
        return num;
    }

    protected SurfacePosition(SliceViewer viewer, GLU glu) {
        this.glu = glu;
        this.xDim = viewer.getXDim();
        this.yDim = viewer.getYDim();
        this.zDim = viewer.getZDim();
        this.xSize = viewer.getXSize();
        this.ySize = viewer.getYSize();
        this.zSize = viewer.getZSize();
        this.xHalf = (double)this.xDim * this.xSize / 2.0;
        this.yHalf = (double)this.yDim * this.ySize / 2.0;
        this.zHalf = (double)this.zDim * this.zSize / 2.0;
        this.viewport = new int[4];
        this.modelview = new double[16];
        this.projection = new double[16];
        this.coordTemp = new double[3];
        this.mouseRotDrag = new double[16];
        this.mouseRotDragX = new double[16];
        this.mouseRotDragY = new double[16];
        this.mouseRotLast = new double[16];
        this.mouseTemp = new double[16];
        this.mouseTranslate = new double[16];
        this.saved = new double[16];
        this.imageTransform = new double[16];
        this.winZ = Buffers.newDirectFloatBuffer((int)4);
        this.theZ = new float[4];
        this.decomp = new double[6];
        this.obliqueDirection = -1;
        this.currentSurfaceCoord = new Point3d();
        this.pickedSurfaceCoordTemp = new double[4];
        this.pickedSurfaceCoord = new double[4];
        this.makeImageTransforms();
        SurfacePosition.clearTransform(this.mouseRotDrag);
        SurfacePosition.clearTransform(this.mouseRotDragX);
        SurfacePosition.clearTransform(this.mouseRotDragY);
        SurfacePosition.clearTransform(this.mouseRotLast);
        SurfacePosition.clearTransform(this.mouseTemp);
        SurfacePosition.clearTransform(this.mouseTranslate);
        SurfacePosition.clearTransform(this.saved);
        SurfacePosition.clearTransform(this.imageTransform);
        System.arraycopy(CollectionUtilities.arrayDoubles(DEFAULT_ROTATION), 0, this.mouseRotLast, 0, DEFAULT_ROTATION.size());
        System.arraycopy(CollectionUtilities.arrayDoubles(DEFAULT_ROTATION), 0, this.saved, 0, DEFAULT_ROTATION.size());
        this.updateImageTransform(null);
    }

    public double[] applyImageTransform(double xLoc, double yLoc, double zLoc, double[] coordsVal) {
        double[] coords = coordsVal;
        double xTrans = xLoc * this.imageTransformMat[0][0] + yLoc * this.imageTransformMat[0][1] + zLoc * this.imageTransformMat[0][2] + this.imageTransformMat[0][3];
        double yTrans = xLoc * this.imageTransformMat[1][0] + yLoc * this.imageTransformMat[1][1] + zLoc * this.imageTransformMat[1][2] + this.imageTransformMat[1][3];
        double zTrans = xLoc * this.imageTransformMat[2][0] + yLoc * this.imageTransformMat[2][1] + zLoc * this.imageTransformMat[2][2] + this.imageTransformMat[2][3];
        if (coords == null) {
            coords = this.coordTemp;
        }
        coords[0] = xTrans;
        coords[1] = yTrans;
        coords[2] = zTrans;
        return coords;
    }

    public void applyImageTransform(Point3d point, Point3d pointTrans) {
        double xTrans = point.x * this.imageTransformMat[0][0] + point.y * this.imageTransformMat[0][1] + point.z * this.imageTransformMat[0][2] + this.imageTransformMat[0][3];
        double yTrans = point.x * this.imageTransformMat[1][0] + point.y * this.imageTransformMat[1][1] + point.z * this.imageTransformMat[1][2] + this.imageTransformMat[1][3];
        double zTrans = point.x * this.imageTransformMat[2][0] + point.y * this.imageTransformMat[2][1] + point.z * this.imageTransformMat[2][2] + this.imageTransformMat[2][3];
        if (pointTrans != null) {
            pointTrans.x = xTrans;
            pointTrans.y = yTrans;
            pointTrans.z = zTrans;
        } else {
            point.x = xTrans;
            point.y = yTrans;
            point.z = zTrans;
        }
    }

    public float convertX(double xLoc) {
        return (float)(xLoc * this.xSize - this.xHalf);
    }

    public float convertY(double yLoc) {
        return (float)(yLoc * this.ySize - this.yHalf);
    }

    public float convertZ(double zLoc) {
        return (float)(zLoc * this.zSize - this.zHalf);
    }

    public Point3d convertCoordinateToPoint(Coordinate coor) {
        return new Point3d(coor.xDbl * this.xSize - this.xHalf, coor.yDbl * this.ySize - this.yHalf, coor.zDbl * this.zSize - this.zHalf);
    }

    public Coordinate convertPointToCoordinate(Point3d point) {
        return this.convertPointToCoordinate(point, false);
    }

    public double[][] convertTransformOrientation(double[][] array) {
        int ctrIn;
        int ctrOut;
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.tempTrans1[ctrOut][ctrIn] = this.preTrans[ctrOut][0] * array[0][ctrIn] + this.preTrans[ctrOut][1] * array[1][ctrIn] + this.preTrans[ctrOut][2] * array[2][ctrIn] + this.preTrans[ctrOut][3] * array[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.tempTrans2[ctrOut][ctrIn] = this.tempTrans1[ctrOut][0] * this.postTrans[0][ctrIn] + this.tempTrans1[ctrOut][1] * this.postTrans[1][ctrIn] + this.tempTrans1[ctrOut][2] * this.postTrans[2][ctrIn] + this.tempTrans1[ctrOut][3] * this.postTrans[3][ctrIn];
            }
        }
        return this.tempTrans2;
    }

    public Point3d getCurrentCoordinate() {
        return this.currentSurfaceCoord;
    }

    public double getHalfX() {
        return this.xHalf;
    }

    public double getHalfY() {
        return this.yHalf;
    }

    public double getHalfZ() {
        return this.zHalf;
    }

    public double[][] getImageTransform() {
        return this.imageTransformMat;
    }

    public double[][] getImageTransformInverse() {
        return this.imageTransformMatInverse;
    }

    public int getLastPickedOctant() {
        return this.pickedOctant;
    }

    public int getObliqueDirection() {
        return this.obliqueDirection;
    }

    public PickableSurface getPickedSurface() {
        return this.pickedSurface;
    }

    public double[] getSaved() {
        return this.saved;
    }

    public double getSizeX() {
        return this.xSize;
    }

    public double getSizeY() {
        return this.ySize;
    }

    public double getSizeZ() {
        return this.zSize;
    }

    public int[] getViewport() {
        return this.viewport;
    }

    public double[] getViewTransform() {
        return this.mouseRotLast;
    }

    public double[] getViewerTransformCopy() {
        return Arrays.copyOf(this.mouseRotLast, this.mouseRotLast.length);
    }

    public int getZoom() {
        return this.zoom + this.zoomDynamic;
    }

    public boolean isImageTransformIdentity() {
        return SurfacePosition.isIdentity(this.imageTransform);
    }

    public boolean isPickDirty() {
        return this.pickDirty;
    }

    public void setObliqueDirection(int obliqueDirection) {
        this.obliqueDirection = obliqueDirection;
    }

    public void setPickDirty(boolean pickDirty) {
        this.pickDirty = pickDirty;
    }

    public void setPickedOctant(int val) {
        this.pickedOctant = val;
    }

    public void setViewTransform(double[] xform) {
        this.mouseRotLast = xform;
    }

    public void copyViewTransform(double[] xform) {
        System.arraycopy(xform, 0, this.mouseRotLast, 0, xform.length);
    }

    protected void apply(GL2 gl, double scaleFactor) {
        gl.glLoadIdentity();
        if (this.dynamicMode == 0) {
            gl.glMultTransposeMatrixd(this.mouseRotDragY, 0);
            gl.glMultTransposeMatrixd(this.mouseRotDragX, 0);
        } else if (this.dynamicMode == 1) {
            gl.glMultTransposeMatrixd(this.mouseTranslate, 0);
        } else if (this.dynamicMode == 2) {
            this.updateCamera(gl, scaleFactor);
        }
        if (this.resetZoom) {
            this.updateCamera(gl, scaleFactor);
            this.resetZoom = false;
        }
        gl.glMultTransposeMatrixd(this.mouseRotLast, 0);
        gl.glGetDoublev(2982, this.modelview, 0);
        gl.glGetDoublev(2983, this.projection, 0);
        gl.glGetIntegerv(2978, this.viewport, 0);
    }

    protected double[] getModelViewTransform() {
        return this.modelview;
    }

    protected void apply(GL2 gl, double[] mat) {
        SurfacePosition.clearTransform(this.mouseRotDragX);
        SurfacePosition.clearTransform(this.mouseRotDragY);
        SurfacePosition.clearTransform(this.mouseTranslate);
        System.arraycopy(mat, 0, this.mouseRotLast, 0, DEFAULT_ROTATION.size());
        if (ArrayUtils.isEquals((Object)mat, (Object)CollectionUtilities.arrayDoubles(DEFAULT_ROTATION))) {
            this.zoom = this.zoomDefault;
            this.resetZoom = true;
        }
    }

    protected double[] applyModelTransform(double xLoc, double yLoc, double zLoc) {
        double xTrans = xLoc * this.modelview[0] + yLoc * this.modelview[4] + zLoc * this.modelview[8] + this.modelview[12];
        double yTrans = xLoc * this.modelview[1] + yLoc * this.modelview[5] + zLoc * this.modelview[9] + this.modelview[13];
        double zTrans = xLoc * this.modelview[2] + yLoc * this.modelview[6] + zLoc * this.modelview[10] + this.modelview[14];
        this.coordTemp[0] = xTrans;
        this.coordTemp[1] = yTrans;
        this.coordTemp[2] = zTrans;
        return this.coordTemp;
    }

    protected void applyUserTransform(GL2 gl) {
        gl.glMultTransposeMatrixd(this.imageTransform, 0);
    }

    protected Coordinate convertPointToCoordinate(Point3d point, boolean round) {
        if (round) {
            return new Coordinate((double)Math.round((point.x + this.xHalf) / this.xSize), (double)Math.round((point.y + this.yHalf) / this.ySize), (double)Math.round((point.z + this.zHalf) / this.zSize));
        }
        return new Coordinate((point.x + this.xHalf) / this.xSize, (point.y + this.yHalf) / this.ySize, (point.z + this.zHalf) / this.zSize);
    }

    protected double[] decomposeModelTransform() {
        this.decomp[0] = SurfacePosition.validateNum(this.modelview[12]);
        this.decomp[1] = SurfacePosition.validateNum(this.modelview[13]);
        this.decomp[2] = SurfacePosition.validateNum(-1 * (this.zoom + this.zoomDynamic - this.zoomDefault));
        double xRot = SurfacePosition.validateNum(Math.atan(this.modelview[6] / this.modelview[10]));
        double yRot = 0.0;
        double zRot = 0.0;
        yRot = xRot == 0.0 ? SurfacePosition.validateNum(Math.atan(-1.0 * Math.cos(xRot) * (this.modelview[2] / this.modelview[10]))) : SurfacePosition.validateNum(Math.atan(-1.0 * Math.sin(xRot) * (this.modelview[2] / this.modelview[6])));
        double temp = (this.modelview[5] / this.modelview[1] - Math.sin(xRot) * Math.tan(yRot)) * (Math.cos(yRot) / Math.cos(xRot));
        zRot = SurfacePosition.validateNum(Math.atan(1.0 / temp));
        this.decomp[3] = SurfacePosition.validateNum(xRot * 57.29577951308232);
        this.decomp[4] = SurfacePosition.validateNum(yRot * 57.29577951308232);
        this.decomp[5] = SurfacePosition.validateNum(zRot * 57.29577951308232);
        return this.decomp;
    }

    protected boolean foundPickedSurface() {
        return this.pickedSurface != null;
    }

    protected void goToSaved() {
        System.arraycopy(this.saved, 0, this.mouseRotLast, 0, DEFAULT_ROTATION.size());
        this.zoom = this.zoomSaved;
        this.resetZoom = true;
    }

    protected boolean findRulerStartLocation(GL2 gl, RulerTool ruler) {
        float val;
        int ctrX;
        int ctrY;
        int xScreenDim = this.viewport[2];
        int yScreenDim = this.viewport[3];
        FloatBuffer sliceBuf = Buffers.newDirectFloatBuffer((int)(4 * xScreenDim * yScreenDim));
        gl.glReadPixels(0, 0, this.viewport[2], this.viewport[3], 6402, 5126, (Buffer)sliceBuf);
        ArrayList<Float> depths = new ArrayList<Float>();
        float max = 0.0f;
        float min = 1.0f;
        int maxX = 0;
        int maxY = 0;
        int minX = 0;
        int minY = 0;
        for (ctrY = 0; ctrY < yScreenDim; ++ctrY) {
            for (ctrX = 0; ctrX < xScreenDim; ++ctrX) {
                val = sliceBuf.get(ctrY * xScreenDim + ctrX);
                if (!(val < 1.0f) || !(val > 0.0f)) continue;
                depths.add(Float.valueOf(val));
            }
        }
        if (depths.size() > 0) {
            Collections.sort(depths);
            min = ((Float)depths.get((int)((double)depths.size() * 0.1))).floatValue();
            max = ((Float)depths.get((int)((double)depths.size() * 0.3))).floatValue();
            for (ctrY = 0; ctrY < yScreenDim; ++ctrY) {
                for (ctrX = 0; ctrX < xScreenDim; ++ctrX) {
                    val = sliceBuf.get(ctrY * xScreenDim + ctrX);
                    if (val == max) {
                        maxX = ctrX;
                        maxY = ctrY;
                    }
                    if (val != min) continue;
                    minX = ctrX;
                    minY = ctrY;
                }
            }
            double[] coord = new double[4];
            this.glu.gluUnProject((double)minX, (double)minY, (double)min, this.modelview, 0, this.projection, 0, this.viewport, 0, coord, 0);
            ruler.getFirst().setPoint(new Point3d(coord[0], coord[1], coord[2]));
            this.glu.gluUnProject((double)maxX, (double)maxY, (double)max, this.modelview, 0, this.projection, 0, this.viewport, 0, coord, 0);
            ruler.getSecond().setPoint(new Point3d(coord[0], coord[1], coord[2]));
            ruler.getLine().editLine(new Point3d[]{ruler.getFirst().getPoint(), ruler.getSecond().getPoint()});
            return true;
        }
        return false;
    }

    protected boolean findAngleStartLocation(GL2 gl, AngleTool angle) {
        float val;
        int ctrX;
        int ctrY;
        int xScreenDim = this.viewport[2];
        int yScreenDim = this.viewport[3];
        FloatBuffer sliceBuf = Buffers.newDirectFloatBuffer((int)(4 * xScreenDim * yScreenDim));
        gl.glReadPixels(0, 0, this.viewport[2], this.viewport[3], 6402, 5126, (Buffer)sliceBuf);
        ArrayList<Float> depths = new ArrayList<Float>();
        float max = 0.0f;
        float min = 1.0f;
        float third = 0.0f;
        int maxX = 0;
        int maxY = 0;
        int minX = 0;
        int minY = 0;
        int thirdX = 0;
        int thirdY = 0;
        for (ctrY = 0; ctrY < yScreenDim; ++ctrY) {
            for (ctrX = 0; ctrX < xScreenDim; ++ctrX) {
                val = sliceBuf.get(ctrY * xScreenDim + ctrX);
                if (!(val < 1.0f) || !(val > 0.0f)) continue;
                depths.add(Float.valueOf(val));
            }
        }
        if (depths.size() > 0) {
            Collections.sort(depths);
            min = ((Float)depths.get((int)((double)depths.size() * 0.1))).floatValue();
            third = ((Float)depths.get((int)((double)depths.size() * 0.3))).floatValue();
            max = ((Float)depths.get((int)((double)depths.size() * 0.5))).floatValue();
            for (ctrY = 0; ctrY < yScreenDim; ++ctrY) {
                for (ctrX = 0; ctrX < xScreenDim; ++ctrX) {
                    val = sliceBuf.get(ctrY * xScreenDim + ctrX);
                    if (val == max) {
                        maxX = ctrX;
                        maxY = ctrY;
                    }
                    if (val == min) {
                        minX = ctrX;
                        minY = ctrY;
                    }
                    if (val != third) continue;
                    thirdX = ctrX;
                    thirdY = ctrY;
                }
            }
            double[] coord = new double[4];
            this.glu.gluUnProject((double)minX, (double)minY, (double)min, this.modelview, 0, this.projection, 0, this.viewport, 0, coord, 0);
            angle.getFirst().setPoint(new Point3d(coord[0], coord[1], coord[2]));
            this.glu.gluUnProject((double)maxX, (double)maxY, (double)max, this.modelview, 0, this.projection, 0, this.viewport, 0, coord, 0);
            angle.getSecond().setPoint(new Point3d(coord[0], coord[1], coord[2]));
            this.glu.gluUnProject((double)thirdX, (double)thirdY, (double)third, this.modelview, 0, this.projection, 0, this.viewport, 0, coord, 0);
            angle.getThird().setPoint(new Point3d(coord[0], coord[1], coord[2]));
            angle.getFirstLine().editLine(new Point3d[]{angle.getFirst().getPoint(), angle.getThird().getPoint()});
            angle.getSecondLine().editLine(new Point3d[]{angle.getSecond().getPoint(), angle.getThird().getPoint()});
            return true;
        }
        return false;
    }

    protected void pickPoint(GL2 gl, Point mouse, PickableSurface surface, boolean measureMode) {
        double winX = mouse.getX();
        double winY = this.viewport[3] - (int)mouse.getY() - 1;
        this.winZ.rewind();
        gl.glReadPixels((int)winX, (int)winY, 1, 1, 6402, 5126, (Buffer)this.winZ);
        this.winZ.get(this.theZ);
        this.glu.gluUnProject(winX, winY, (double)this.theZ[0], this.modelview, 0, this.projection, 0, this.viewport, 0, this.pickedSurfaceCoordTemp, 0);
        int xSlice = this.xDim - (int)Math.round((this.pickedSurfaceCoordTemp[0] - this.xHalf) / -this.xSize);
        int ySlice = this.yDim - (int)Math.round((this.pickedSurfaceCoordTemp[1] - this.yHalf) / -this.ySize);
        int zSlice = this.zDim - (int)Math.round((this.pickedSurfaceCoordTemp[2] - this.zHalf) / -this.zSize);
        if (this.inRange(xSlice, ySlice, zSlice)) {
            Marker marker = null;
            if (surface.getClass().equals(Marker.class)) {
                marker = (Marker)surface;
                this.pickedSurfaceCoordTemp[0] = marker.getPoint().x;
                this.pickedSurfaceCoordTemp[1] = marker.getPoint().y;
                this.pickedSurfaceCoordTemp[2] = marker.getPoint().z;
                xSlice = this.xDim - (int)Math.round((marker.getPoint().x - this.xHalf) / -this.xSize);
                ySlice = this.yDim - (int)Math.round((marker.getPoint().y - this.yHalf) / -this.ySize);
                zSlice = this.zDim - (int)Math.round((marker.getPoint().z - this.zHalf) / -this.zSize);
            } else if (surface.isBaseSurface()) {
                this.pickedSurfaceCoord[0] = this.pickedSurfaceCoordTemp[0];
                this.pickedSurfaceCoord[1] = this.pickedSurfaceCoordTemp[1];
                this.pickedSurfaceCoord[2] = this.pickedSurfaceCoordTemp[2];
                this.pickedSurfaceCoord[3] = this.pickedSurfaceCoordTemp[3];
            }
            surface.setPickDistance(this.theZ[0]);
            Point3d surfaceCoord = surface.getPickedSurfaceCoordinate();
            surfaceCoord.x = this.pickedSurfaceCoordTemp[0];
            surfaceCoord.y = this.pickedSurfaceCoordTemp[1];
            surfaceCoord.z = this.pickedSurfaceCoordTemp[2];
            Coordinate imageCoord = surface.getPickedImageCoordinate();
            imageCoord.setValues((double)xSlice, (double)ySlice, (double)zSlice);
            if (this.pickedSurface != null) {
                if (this.pickedSurface.getPickDistance() > surface.getPickDistance()) {
                    this.pickedSurface = surface;
                }
            } else {
                this.pickedSurface = surface;
            }
        } else {
            Coordinate imageCoord = surface.getPickedImageCoordinate();
            imageCoord.setValues(Double.NaN, Double.NaN, Double.NaN);
        }
        this.setPickDirty(true);
    }

    protected void resetPick() {
        this.pickedSurface = null;
    }

    public double[] getMouseRotateX() {
        return this.mouseRotDragX;
    }

    public double[] getMouseRotateY() {
        return this.mouseRotDragY;
    }

    public double[] getMouseTranslate() {
        return this.mouseTranslate;
    }

    public int getDymamicMode() {
        return this.dynamicMode;
    }

    public void copyTransform(double[] rotX, double[] rotY, double[] trans, int mode) {
        this.dynamicMode = mode;
        System.arraycopy(rotX, 0, this.mouseRotDragX, 0, rotX.length);
        System.arraycopy(rotY, 0, this.mouseRotDragY, 0, rotY.length);
        System.arraycopy(trans, 0, this.mouseTranslate, 0, trans.length);
    }

    public void rotateX() {
        double theta = Math.PI / 180;
        double cosTheta = Math.cos(Math.PI / 180);
        double sinTheta = Math.sin(Math.PI / 180);
        SurfacePosition.clearTransform(this.mouseRotDragX);
        this.mouseRotDragX[0] = cosTheta;
        this.mouseRotDragX[2] = sinTheta;
        this.mouseRotDragX[8] = -1.0 * sinTheta;
        this.mouseRotDragX[10] = cosTheta;
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.mouseTemp[ctrOut * 4 + ctrIn] = this.mouseRotDragX[ctrOut * 4 + 0] * this.mouseRotLast[0 + ctrIn] + this.mouseRotDragX[ctrOut * 4 + 1] * this.mouseRotLast[4 + ctrIn] + this.mouseRotDragX[ctrOut * 4 + 2] * this.mouseRotLast[8 + ctrIn] + this.mouseRotDragX[ctrOut * 4 + 3] * this.mouseRotLast[12 + ctrIn];
            }
        }
        System.arraycopy(this.mouseTemp, 0, this.mouseRotLast, 0, this.mouseRotLast.length);
        SurfacePosition.clearTransform(this.mouseRotDragX);
        SurfacePosition.clearTransform(this.mouseTemp);
    }

    protected void save() {
        this.zoomSaved = this.zoom;
        System.arraycopy(this.mouseRotLast, 0, this.saved, 0, this.saved.length);
    }

    protected void setCurrentCoordinate(double xLoc, double yLoc, double zLoc) {
        this.currentSurfaceCoord.set(xLoc, yLoc, zLoc);
    }

    protected void setDefaultZoom(GL2 gl, int val, double scaleFactor) {
        this.zoomSaved = this.zoom = val;
        this.zoomDefault = this.zoom;
        this.zoomDynamic = 0;
        this.updateCamera(gl, scaleFactor);
    }

    protected void setDynamicStart(Point point, int mode) {
        this.dynamicMode = mode;
        this.lastPoint.setLocation(point);
    }

    protected void updateCurrent() {
        if (this.dynamicMode == 0) {
            int ctrIn;
            int ctrOut;
            SurfacePosition.clearTransform(this.mouseTemp);
            SurfacePosition.clearTransform(this.mouseRotDrag);
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.mouseRotDrag[ctrOut * 4 + ctrIn] = this.mouseRotDragY[ctrOut * 4 + 0] * this.mouseRotDragX[0 + ctrIn] + this.mouseRotDragY[ctrOut * 4 + 1] * this.mouseRotDragX[4 + ctrIn] + this.mouseRotDragY[ctrOut * 4 + 2] * this.mouseRotDragX[8 + ctrIn] + this.mouseRotDragY[ctrOut * 4 + 3] * this.mouseRotDragX[12 + ctrIn];
                }
            }
            for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.mouseTemp[ctrOut * 4 + ctrIn] = this.mouseRotDrag[ctrOut * 4 + 0] * this.mouseRotLast[0 + ctrIn] + this.mouseRotDrag[ctrOut * 4 + 1] * this.mouseRotLast[4 + ctrIn] + this.mouseRotDrag[ctrOut * 4 + 2] * this.mouseRotLast[8 + ctrIn] + this.mouseRotDrag[ctrOut * 4 + 3] * this.mouseRotLast[12 + ctrIn];
                }
            }
            System.arraycopy(this.mouseTemp, 0, this.mouseRotLast, 0, this.mouseTemp.length);
            SurfacePosition.clearTransform(this.mouseRotDragX);
            SurfacePosition.clearTransform(this.mouseRotDragY);
        } else if (this.dynamicMode == 1) {
            for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.mouseTemp[ctrOut * 4 + ctrIn] = this.mouseTranslate[ctrOut * 4 + 0] * this.mouseRotLast[0 + ctrIn] + this.mouseTranslate[ctrOut * 4 + 1] * this.mouseRotLast[4 + ctrIn] + this.mouseTranslate[ctrOut * 4 + 2] * this.mouseRotLast[8 + ctrIn] + this.mouseTranslate[ctrOut * 4 + 3] * this.mouseRotLast[12 + ctrIn];
                }
            }
            System.arraycopy(this.mouseTemp, 0, this.mouseRotLast, 0, this.mouseTemp.length);
            SurfacePosition.clearTransform(this.mouseTranslate);
        } else if (this.dynamicMode == 2) {
            this.zoom += this.zoomDynamic;
            this.zoomDynamic = 0;
        }
        this.dynamicMode = 0;
    }

    protected void updateDynamic(Point point, double scaleFactor) {
        if (this.dynamicMode == 0) {
            double rotX = (double)(point.y - this.lastPoint.y) * 0.3;
            double rotY = (double)(point.x - this.lastPoint.x) * 0.3;
            double theta = rotY * Math.PI / 180.0;
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            SurfacePosition.clearTransform(this.mouseRotDragX);
            this.mouseRotDragX[0] = cosTheta;
            this.mouseRotDragX[2] = sinTheta;
            this.mouseRotDragX[8] = -1.0 * sinTheta;
            this.mouseRotDragX[10] = cosTheta;
            theta = rotX * Math.PI / 180.0;
            cosTheta = Math.cos(theta);
            sinTheta = Math.sin(theta);
            SurfacePosition.clearTransform(this.mouseRotDragY);
            this.mouseRotDragY[5] = cosTheta;
            this.mouseRotDragY[6] = -1.0 * sinTheta;
            this.mouseRotDragY[9] = sinTheta;
            this.mouseRotDragY[10] = cosTheta;
        } else if (this.dynamicMode == 1) {
            double transX = (double)(point.x - this.lastPoint.x) * 0.3;
            double transY = (double)(point.y - this.lastPoint.y) * 0.3;
            SurfacePosition.clearTransform(this.mouseTranslate);
            this.mouseTranslate[3] = transX * scaleFactor;
            this.mouseTranslate[7] = -transY * scaleFactor;
        } else if (this.dynamicMode == 2) {
            this.zoomDynamic = (int)Math.round((double)(-1 * (point.y - this.lastPoint.y) * 3) * scaleFactor);
            if (this.zoom + this.zoomDynamic < 0) {
                this.zoomDynamic = -this.zoom;
            }
        }
    }

    protected boolean updateImageTransform(double[][] xformVal) {
        int ctrIn;
        int ctrOut;
        boolean changed = false;
        double[][] xform = xformVal;
        if (xform == null) {
            xform = IDENTITY;
        }
        double[][] centerTrans = new double[][]{{1.0, 0.0, 0.0, -this.xHalf}, {0.0, 1.0, 0.0, -this.yHalf}, {0.0, 0.0, 1.0, -this.zHalf}, {0.0, 0.0, 0.0, 1.0}};
        double[][] centerInverseTrans = new double[][]{{1.0, 0.0, 0.0, this.xHalf}, {0.0, 1.0, 0.0, this.yHalf}, {0.0, 0.0, 1.0, this.zHalf}, {0.0, 0.0, 0.0, 1.0}};
        double[][] flipPreTrans = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double[][] flipPostTrans = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.preTrans[ctrOut][ctrIn] = flipPreTrans[ctrOut][0] * centerTrans[0][ctrIn] + flipPreTrans[ctrOut][1] * centerTrans[1][ctrIn] + flipPreTrans[ctrOut][2] * centerTrans[2][ctrIn] + flipPreTrans[ctrOut][3] * centerTrans[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.postTrans[ctrOut][ctrIn] = centerInverseTrans[ctrOut][0] * flipPostTrans[0][ctrIn] + centerInverseTrans[ctrOut][1] * flipPostTrans[1][ctrIn] + centerInverseTrans[ctrOut][2] * flipPostTrans[2][ctrIn] + centerInverseTrans[ctrOut][3] * flipPostTrans[3][ctrIn];
            }
        }
        xform = this.convertTransform(xform);
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                if (this.imageTransform[ctrOut * 4 + ctrIn] != xform[ctrOut][ctrIn]) {
                    changed = true;
                }
                this.imageTransform[ctrOut * 4 + ctrIn] = xform[ctrOut][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.imageTransformMat[ctrOut][ctrIn] = xform[ctrOut][ctrIn];
            }
        }
        this.imageTransformMatInverse = new Matrix(this.imageTransformMat).inverse().getArrayCopy();
        return changed;
    }

    protected void updateScroll(int val, int mode, double scaleFactor) {
        this.dynamicMode = mode;
        if (this.dynamicMode == 2) {
            this.zoomDynamic = (int)Math.round((double)(-1 * val * 3) * scaleFactor);
            if (this.zoom + this.zoomDynamic < 0) {
                this.zoomDynamic = -this.zoom;
            }
        }
    }

    private double[][] convertTransform(double[][] array) {
        int ctrIn;
        int ctrOut;
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                this.tempTrans1[ctrOut][ctrIn] = this.sizeTrans[ctrOut][0] * array[0][ctrIn] + this.sizeTrans[ctrOut][1] * array[1][ctrIn] + this.sizeTrans[ctrOut][2] * array[2][ctrIn] + this.sizeTrans[ctrOut][3] * array[3][ctrIn];
            }
        }
        for (ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (ctrIn = 0; ctrIn < 4; ++ctrIn) {
                array[ctrOut][ctrIn] = this.tempTrans1[ctrOut][0] * this.sizeInverseTrans[0][ctrIn] + this.tempTrans1[ctrOut][1] * this.sizeInverseTrans[1][ctrIn] + this.tempTrans1[ctrOut][2] * this.sizeInverseTrans[2][ctrIn] + this.tempTrans1[ctrOut][3] * this.sizeInverseTrans[3][ctrIn];
            }
        }
        return this.convertTransformOrientation(array);
    }

    private boolean inRange(int xSlice, int ySlice, int zSlice) {
        return xSlice >= 0 && ySlice >= 0 && zSlice >= 0 && xSlice < this.xDim && ySlice < this.yDim && zSlice < this.zDim;
    }

    private void makeImageTransforms() {
        this.sizeTrans = new double[][]{{this.xSize, 0.0, 0.0, 0.0}, {0.0, this.ySize, 0.0, 0.0}, {0.0, 0.0, this.zSize, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.sizeInverseTrans = new double[][]{{1.0 / this.xSize, 0.0, 0.0, 0.0}, {0.0, 1.0 / this.ySize, 0.0, 0.0}, {0.0, 0.0, 1.0 / this.zSize, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.preTrans = new double[][]{{1.0, 0.0, 0.0, -this.xHalf}, {0.0, 1.0, 0.0, -this.yHalf}, {0.0, 0.0, 1.0, -this.zHalf}, {0.0, 0.0, 0.0, 1.0}};
        this.postTrans = new double[][]{{1.0, 0.0, 0.0, this.xHalf}, {0.0, 1.0, 0.0, this.yHalf}, {0.0, 0.0, 1.0, this.zHalf}, {0.0, 0.0, 0.0, 1.0}};
        this.tempTrans1 = new double[4][4];
        this.tempTrans2 = new double[4][4];
        this.imageTransformMat = new double[4][4];
        this.imageTransformMatInverse = new double[4][4];
    }

    private void updateCamera(GL2 gl, double scaleFactor) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(45.0, 1.0, 10.0 * scaleFactor, 100000.0);
        this.glu.gluLookAt(0.0f, 0.0f, (float)(this.zoom + this.zoomDynamic), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }
}

