/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.window;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

public class ViewerWindowManager
implements WindowListener {
    private SliceViewer viewer;
    private Vector<ViewerAssociated> windows = new Vector();

    public ViewerWindowManager(SliceViewer viewer) {
        this.viewer = viewer;
    }

    public ViewerAssociated[] getAllViewerAssociatedWindows() {
        int count = 0;
        int ctr = 0;
        ViewerAssociated[] vaws = null;
        try {
            ViewerAssociated vaw;
            Enumeration<ViewerAssociated> en = this.windows.elements();
            while (en.hasMoreElements()) {
                vaw = en.nextElement();
                if (!vaw.getWindow().isVisible()) continue;
                ++count;
            }
            if (count > 0) {
                vaws = new ViewerAssociated[count];
                en = this.windows.elements();
                while (en.hasMoreElements() && ctr < count) {
                    vaw = en.nextElement();
                    if (!vaw.getWindow().isVisible()) continue;
                    vaws[ctr] = vaw;
                    ++ctr;
                }
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return vaws;
    }

    public void deassociate(ViewerAssociated vaw) {
        this.windows.remove(vaw);
        vaw.getWindow().removeWindowListener(this);
    }

    public void associate(ViewerAssociated vaw) {
        this.windows.add(vaw);
        JFrame aWindow = vaw.getWindow();
        aWindow.setIconImage(MangoStyle.ICON_APP.getImage());
        aWindow.addWindowListener(this);
    }

    public void clear() {
        this.viewer = null;
        this.windows.clear();
        this.windows = null;
    }

    public void closeAllAssociatedWindows() {
        Enumeration<ViewerAssociated> en = this.windows.elements();
        while (en.hasMoreElements()) {
            ViewerAssociated va = en.nextElement();
            JFrame tempWindow = va.getWindow();
            if (tempWindow == null) continue;
            tempWindow.setVisible(false);
            tempWindow.dispose();
        }
    }

    public void closeAssociatedWindow(String des) {
        Enumeration<ViewerAssociated> en = this.windows.elements();
        while (en.hasMoreElements()) {
            ViewerAssociated va = en.nextElement();
            JFrame tempWindow = va.getWindow();
            String description = va.getDescription();
            if (!des.equals(description)) continue;
            tempWindow.setVisible(false);
            tempWindow.dispose();
        }
    }

    @Override
    public void windowActivated(WindowEvent we) {
        if (this.viewer != null) {
            Mango.getInstance().getToolBox().setCurrentViewer(this.viewer);
            Mango.getInstance().setCurrentViewer(this.viewer);
            if ((Mango.getInstance().getToolBox().isActive() || Mango.getInstance().getToolBox().isTextFieldMinTouched() || Mango.getInstance().getToolBox().isTextFieldMaxTouched()) && this.viewer == Mango.getInstance().getToolBox().getCurrentViewer()) {
                we.getWindow().toFront();
                Mango.getInstance().getToolBox().updateTextFields();
                Mango.getInstance().getToolBox().updateFocusState();
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }
}

