/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.screen.lut;

import edu.uthscsa.ric.utilities.AppLogger;

public class LookupTableKnot
implements Cloneable,
Comparable<LookupTableKnot> {
    public boolean useGradation;
    public double val;
    public int bVal;
    public int gVal;
    public int rVal;
    public static final int MAX = 255;

    public LookupTableKnot() {
    }

    public LookupTableKnot(double percent, double valR, double valG, double valB, boolean bool) {
        this.val = percent;
        this.rVal = (int)(valR * 255.0);
        this.gVal = (int)(valG * 255.0);
        this.bVal = (int)(valB * 255.0);
        this.useGradation = bool;
    }

    public LookupTableKnot(double percent, int valR, int valG, int valB) {
        this.val = percent;
        this.rVal = valR;
        this.gVal = valG;
        this.bVal = valB;
    }

    public Object clone() {
        Object ob = null;
        try {
            ob = super.clone();
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
        return ob;
    }

    public void setBlue(double aVal) {
        this.bVal = (int)(aVal * 255.0);
    }

    public void setBlue(int aVal) {
        this.bVal = aVal;
    }

    public void setGradient(boolean bool) {
        this.useGradation = bool;
    }

    public void setGreen(double aVal) {
        this.gVal = (int)(aVal * 255.0);
    }

    public void setGreen(int aVal) {
        this.gVal = aVal;
    }

    public void setRed(double aVal) {
        this.rVal = (int)(aVal * 255.0);
    }

    public void setRed(int aVal) {
        this.rVal = aVal;
    }

    public void setVal(double aVal) {
        this.val = aVal;
    }

    public String toString() {
        return this.val + " " + this.rVal + " " + this.gVal + " " + this.bVal + " " + (this.useGradation ? "1" : "0");
    }

    @Override
    public int compareTo(LookupTableKnot o) {
        return (int)Math.signum(this.val - o.val);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bVal;
        result = 31 * result + this.gVal;
        result = 31 * result + this.rVal;
        result = 31 * result + (this.useGradation ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.val);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LookupTableKnot other = (LookupTableKnot)obj;
        if (this.bVal != other.bVal) {
            return false;
        }
        if (this.gVal != other.gVal) {
            return false;
        }
        if (this.rVal != other.rVal) {
            return false;
        }
        if (this.useGradation != other.useGradation) {
            return false;
        }
        return Double.doubleToLongBits(this.val) == Double.doubleToLongBits(other.val);
    }
}

