/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.screen;

import Jama.Matrix;
import edu.uthscsa.ric.mango.ScreenImage;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterRejectionData;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayListener;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.ClusterFilter;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Transform;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeListener;
import java.awt.image.LookupTable;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class ScreenVolume
implements ClusterFilter,
ScreenImage,
VolumeListener {
    private ClusterRejectionData clusterData;
    private WeakReference<Object> viewerToClose;
    private URI uri;
    private Vector<OverlayListener> listeners = new Vector();
    private boolean hidden;
    private boolean loaded;
    private boolean negative;
    private boolean parametric;
    private boolean logical;
    private double screenMax;
    private double screenMin;
    private double screenRatio;
    private final boolean baseImage;
    protected LookupTableManager lutManager;
    protected Volume volume;

    public ScreenVolume(Volume volume, URI uri, String lutName, boolean baseImage) {
        this.volume = volume;
        this.uri = uri;
        this.baseImage = baseImage;
        volume.addListener(this);
        this.lutManager = LookupTableManager.createLUTManager(lutName, baseImage);
        if (this.lutManager == null) {
            this.lutManager = LookupTableManager.createLookupTableManager(0, baseImage);
        }
        this.lutManager.initLUT();
        this.updateScreenRatio();
    }

    public void addOverlayListener(OverlayListener ol) {
        if (this.listeners != null && !this.listeners.contains(ol)) {
            this.listeners.add(ol);
        }
    }

    public void clear() {
        if (this.volume != null) {
            this.volume.removeListener(this);
            this.notifyListenersOfRemoval();
            this.volume.clear(false);
            this.lutManager = null;
            this.viewerToClose = null;
            if (this.listeners != null) {
                this.listeners.clear();
                this.listeners = null;
            }
            this.uri = null;
        }
    }

    public int getAlphaInteger() {
        return this.lutManager.getAlpha();
    }

    public ClusterRejectionData getClusterData() {
        return this.clusterData;
    }

    public boolean isUsingTransform() {
        return this.volume.isUsingTransform();
    }

    public double getDynamicScreenMax() {
        return (double)this.lutManager.getMaxLUT() / (255.0 / (this.screenMax - this.screenMin)) + this.screenMin;
    }

    public double getDynamicScreenMin() {
        return (double)this.lutManager.getMinLUT() / (255.0 / (this.screenMax - this.screenMin)) + this.screenMin;
    }

    public double getImageMax() {
        return this.volume.getImageMax();
    }

    public double getImageMin() {
        return this.volume.getImageMin();
    }

    public ImageVolume getImageVolume() {
        return this.volume;
    }

    public LookupTable getLookupTable() {
        return this.lutManager.getLookupTable();
    }

    public LookupTableManager getLookupTableManager() {
        return this.lutManager;
    }

    public int getMaxLUT() {
        return this.lutManager.getMaxLUT();
    }

    public int getMinLUT() {
        return this.lutManager.getMinLUT();
    }

    public String getName() {
        String name = null;
        if (this.getVolume() != null && StringUtils.isBlank((CharSequence)(name = this.getVolume().getTitle()))) {
            name = StringUtilities.makeNiceImageName((String)FileUtilities.getName((URI)this.uri));
        }
        return name;
    }

    public double getScreenMax() {
        return this.screenMax;
    }

    public double getScreenMaxLog() {
        return Math.log10(Math.max(1.0, this.screenMax));
    }

    public double getScreenMin() {
        return this.screenMin;
    }

    public double getScreenMinLog() {
        return Math.log10(Math.max(1.0, this.screenMin));
    }

    public double getScreenRatio() {
        return this.screenRatio;
    }

    public double getScreenRatioLog() {
        return 255.0 / (this.getScreenMaxLog() - this.getScreenMinLog());
    }

    public int getTransparency() {
        return 100 - (int)((double)this.lutManager.getAlpha() / 255.0 * 100.0 + 0.5);
    }

    public URI getURI() {
        return this.uri;
    }

    public Object getViewerToClose() {
        return this.viewerToClose.get();
    }

    @Override
    public Volume getVolume() {
        return this.volume;
    }

    public boolean hasOverlayListener(OverlayListener ol) {
        if (this.listeners != null) {
            Enumeration<OverlayListener> en = this.listeners.elements();
            while (en.hasMoreElements()) {
                if (en.nextElement() != ol) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBaseImage() {
        return this.baseImage;
    }

    public boolean isOverlay() {
        return !this.isBaseImage();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isLogical() {
        return this.logical;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public boolean isParametric() {
        return this.parametric;
    }

    public void notifyListenersOfChange(boolean overlaySelected) {
        Enumeration<OverlayListener> en = this.listeners.elements();
        while (en.hasMoreElements()) {
            en.nextElement().overlayChanged(this, overlaySelected);
        }
    }

    public void removeOverlayListener(OverlayListener ol) {
        if (this.listeners != null) {
            this.listeners.remove(ol);
        }
    }

    public boolean isBinary() {
        return this.volume.isBinary();
    }

    public void setAlpha(double val) {
        this.lutManager.setAlpha((int)Math.round(255.0 * val));
    }

    public double getAlpha() {
        return (float)this.lutManager.getAlpha() / 255.0f;
    }

    public void setClusterData(ClusterRejectionData clusterData) {
        this.clusterData = clusterData;
    }

    public void setUsingTransform(boolean usingTransform) {
        this.volume.setUsingTransform(usingTransform);
    }

    public void setLoaded(boolean bool) {
        this.loaded = bool;
    }

    public void setLogical(boolean logical) {
        this.logical = logical;
        if (this.logical) {
            this.lutManager.setAlpha(255);
        }
    }

    public void setNegativeState(boolean bool) {
        this.negative = bool;
    }

    public Coordinate getOrigin() {
        return this.volume.getOrigin();
    }

    public void setParametricState(boolean bool) {
        this.parametric = bool;
    }

    public void setScreenMax(double val) {
        this.screenMax = val;
        this.updateScreenRatio();
    }

    public void setScreenMin(double val) {
        this.screenMin = val;
        this.updateScreenRatio();
    }

    public void setScreenRatio(double val) {
        this.screenRatio = val;
    }

    public void setTransformToIdentity() {
        double[][] transform = this.volume.convertFromCoordinateTransform(Transform.IDENTITY.getArrayCopy(), false, false, null);
        this.volume.loadTransform(new Matrix(transform), 0, null);
        this.volume.setUsingTransform(false);
    }

    public void setTransformToMNI() {
        Coordinate origin = this.volume.getOrigin();
        double[][] transform = this.volume.convertFromCoordinateTransform(Transform.MNI2TAL.getArrayCopy(), true, false, null);
        this.volume.loadTransform(new Matrix(transform), 1, origin);
        this.volume.setUsingTransform(true);
    }

    public void setTransformToTalairach() {
        Coordinate origin = this.volume.getOrigin();
        double[][] transform = this.volume.convertFromCoordinateTransform(Transform.MNI2TAL.inverse().getArrayCopy(), true, false, null);
        this.volume.loadTransform(new Matrix(transform), 1, origin);
        this.volume.setUsingTransform(true);
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void setViewerToClose(Object viewer) {
        this.viewerToClose = new WeakReference<Object>(viewer);
    }

    public boolean toggleHiddenState() {
        this.hidden = !this.hidden;
        return this.hidden;
    }

    public String toString() {
        if (this.lutManager != null && this.uri != null) {
            return "ScreenVolume [ File=" + this.uri.toString() + " LUT=" + this.lutManager.toString() + " ScreenMin=" + this.screenMin + " ScreenMax=" + this.screenMax + " ]";
        }
        return "ScreenVolume [ ]";
    }

    public final void updateScreenRatio() {
        this.screenRatio = 255.0 / (this.screenMax - this.screenMin);
    }

    private void notifyListenersOfRemoval() {
        if (this.listeners != null) {
            Enumeration<OverlayListener> en = this.listeners.elements();
            while (en.hasMoreElements()) {
                en.nextElement().overlayRemoved(this);
            }
        }
    }

    @Override
    public void volumeChanged(Volume volume, boolean forceUpdate) {
    }

    @Override
    public void volumeTransformChanged(Volume volume) {
    }

    @Override
    public void volumeRangeChanged(Volume volume, Object source, boolean sameThread) {
    }

    @Override
    public void volumeTimepointChanged(Volume volume) {
    }

    @Override
    public void volumeSaved(Volume vol, boolean success, boolean reload, ProgressBar pb, Volume overlayToClear, boolean isCopy, boolean sameThread) {
    }

    @Override
    public void volumeChanged() {
    }

    @Override
    public void volumeRevertedToSaved(boolean success) {
    }

    @Override
    public void volumeLoaded(boolean success) {
    }

    @Override
    public void volumeReloaded(boolean success) {
    }

    @Override
    public void volumeOperationCompleted(boolean success, Volume volume) {
    }

    @Override
    public void volumeDataLoaded(int volIndex) {
    }

    @Override
    public void volumeTransformLoaded() {
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean passesClusterFilter(int xLoc, int yLoc, int zLoc, int xDim, int yDim) {
        if (this.clusterData != null) {
            if (this.clusterData.hiding || this.clusterData.contains == null) {
                return true;
            }
            int index = zLoc * xDim * yDim + yLoc * xDim + xLoc;
            int value = this.clusterData.buffer.get(index);
            return this.clusterData.contains[value];
        }
        return true;
    }
}

