/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.screen;

import com.davekoelle.AlphanumComparator;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.SliceListener;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureListener;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureManager;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.histogram.HistogramPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalAnalysisTool;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ContextMenuListener;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ImageContextMenu;
import edu.uthscsa.ric.mango.viewerslice.menus.context.LineContextMenu;
import edu.uthscsa.ric.mango.viewerslice.menus.context.PointContextMenu;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ROIContextMenu;
import edu.uthscsa.ric.mango.viewerslice.operations.ShrinkWrapOperations;
import edu.uthscsa.ric.mango.viewerslice.screen.Annotation;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.TransformableShape;
import edu.uthscsa.ric.mango.window.Toolbox;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.roi.lines.manager.LOIManager;
import edu.uthscsa.ric.roi.lines.manager.LOISpecialManager;
import edu.uthscsa.ric.roi.mask.display.ROIShape;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.roi.points.manager.POIManager;
import edu.uthscsa.ric.roi.points.manager.POISpecialManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.BitUtilities;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.SeriesDefaultLabels;
import edu.uthscsa.ric.volume.Volume;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;

public class ScreenSlice
extends JComponent
implements ContextMenuListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
VideoCaptureManager {
    private AffineTransform finalNoRadioTransform;
    private AffineTransform finalTransform;
    private AffineTransform finalTransformImage;
    private AffineTransform finalTransformNoScale;
    private AffineTransform finalTransformRetina;
    private AffineTransform polyLineScreenTransform;
    private AffineTransform radiologicalTransform;
    private AffineTransform scaleFileNoRadioTransform;
    private AffineTransform scaleFinalNoRadioTransformImage;
    private AffineTransform scaleFinalNoRadioTransformRetina;
    private AffineTransform scaleFinalTransform;
    private AffineTransform scaleFinalTransformImage;
    private AffineTransform scaleFinalTransformRetina;
    private AffineTransform scaleTransform;
    private AffineTransform screenTransform;
    private AffineTransform screenTransformNoScale;
    private AffineTransform shapeTransform;
    private AffineTransform zoomTransform;
    private AffineTransform zoomTransformImage;
    private Ellipse2D.Double centroidMarker;
    private Ellipse2D.Double centroidMarkerOutter;
    private Ellipse2D.Double crosssectionMarker;
    private Ellipse2D.Double handle;
    private GeneralPath allSelectedBoundsPath;
    private GeneralPath polyLinePath;
    private GeneralPath[] handlesPath;
    private Point adjustingLOIShapeGrabPoint;
    private Point adjustingRealShapeStartPoint;
    private Point adjustingShapeGrabPoint;
    private Point calcLabel;
    private Point checkBoundsPoint;
    private Point current;
    private Point editingPoint;
    private Point orientA;
    private Point orientL;
    private Point orientP;
    private Point orientR;
    private Point polyLineLast;
    private Point polyLineStart;
    private Point selectionShapeStartPoint;
    private Point tempPOIPoint;
    private Point2D.Double centroidImage;
    private Point2D.Double centroidTransformed;
    private Point2D.Double crosssectionPoint;
    private Point2D.Double horizontalLeft;
    private Point2D.Double horizontalRight;
    private Point2D.Double tempTransformedPoint;
    private Point2D.Double verticalBottom;
    private Point2D.Double verticalTop;
    private Point[] eastHandle;
    private Point[] northEastHandle;
    private Point[] northHandle;
    private Point[] northWestHandle;
    private Point[] southEastHandle;
    private Point[] southHandle;
    private Point[] southWestHandle;
    private Point[] westHandle;
    private Rectangle adjustingRealShapeBounds;
    private Rectangle adjustingShapeBounds;
    private Rectangle boundingBox;
    private Rectangle selectionShapeBounds;
    private Rectangle[] bounds;
    private RectangularShape structureElement;
    private SliceViewer viewer;
    private Toolbox toolBox;
    private boolean angleShapeChanged;
    private boolean capturingVideo;
    private boolean containsMouse;
    private boolean incrementShapeFlag;
    private boolean initializedSliceListeners;
    private boolean isAdjusting;
    private boolean isAdjustingLOI;
    private boolean isAdjustingPOI;
    private boolean isAdjustingRealShape;
    private boolean isAdjustingSelectionShape;
    private boolean isConnectingLOI;
    private boolean isDragging;
    private boolean isEditingLOI;
    private boolean isGrabMode;
    private boolean isLOIMode;
    private boolean isMainImage;
    private boolean isMetaDown;
    private boolean isPOIMode;
    private boolean isPanning;
    private boolean isPressed;
    private boolean isROIMagicWandMode;
    private boolean isROIMode;
    private boolean isROIPolyLineMode;
    private boolean isROIRealShapeMode;
    private boolean isROIToolMode;
    private boolean isShiftDown;
    private boolean isUpdatingLOI;
    private boolean isUpdatingPolyLine;
    private boolean isWindowMode;
    private boolean isZoomMode;
    private boolean loiSelectionChanged;
    private boolean mouseDragged;
    private boolean mouseWheelStarted;
    private boolean needUpdateScaledDicomOverlaySlice;
    private boolean needUpdateScaledHistogramSlice;
    private boolean needUpdateScaledOverlaySlices;
    private boolean needUpdateScaledSlice;
    private boolean poiSelectionChanged;
    private boolean polyLineCloseArmed;
    private boolean previewOutOfBoundsMaxX;
    private boolean previewOutOfBoundsMaxY;
    private boolean previewOutOfBoundsMinX;
    private boolean previewOutOfBoundsMinY;
    private boolean realShapeAdjusted;
    private boolean roiCurrentExists;
    private boolean roiExists;
    private boolean roiFill;
    private boolean roiSelectionChanged;
    private boolean rulerShapeChanged;
    private boolean selectionShapeAdjusted;
    private boolean shapeAdjusted;
    private boolean shapeLOIAdjusted;
    private boolean shapePOIAdjusted;
    private boolean showCrosshairs;
    private boolean showCrosssectionMarker;
    private boolean showEdge;
    private boolean showHistogram;
    private boolean showLineAngle;
    private boolean showLineLength;
    private boolean showMask;
    private boolean showOrientation;
    private boolean showingContextMenu;
    private boolean useHistogram;
    private boolean usePreview;
    private boolean[] hasOverlay;
    private boolean[] selectedHasBounds;
    private double calcSum;
    private double centroidCount;
    private double centroidSumABS;
    private double centroidSumOfSquares;
    private double centroidXSum;
    private double centroidYSum;
    private double longestDimSize;
    private double previewSliceSize;
    private double sliceSize;
    private double xSize;
    private double ySize;
    private double[] histogramMaxs;
    private double[] histogramMins;
    private int adjustingNum;
    private int adjustingPOIGrabDiffX;
    private int adjustingPOIGrabDiffY;
    private int clickCount;
    private int crosssectionDirection;
    private int currentCursorType;
    private int currentCursorX;
    private int currentCursorY;
    private int currentROI;
    private int currentSlice;
    private int currentToolSize;
    private int currentX;
    private int currentY;
    private int draggingCursorType;
    private int grabLocation;
    private int histogramAlpha;
    private int longestDim;
    private int maxColors;
    private int mouseWheelPrimed;
    private int numSlices;
    private int originalMouseY;
    private int previewEndX;
    private int previewEndY;
    private int previewStartX;
    private int previewStartY;
    private int previousMouseX;
    private int previousMouseY;
    private int roiMode;
    private int sliceDirection;
    private int targetSize;
    private int textureXdim;
    private int videoCaptureFps;
    private int xDim;
    private int yDim;
    private int[] dicomOverlayData;
    private int[] histogramData;
    private int[] histogramFirsts;
    private int[] histogramSeconds;
    private int[] overlayMixerData;
    private int[] rgbData;
    private int[] shrinkWrapper;
    private int[] textureData;
    private int[][] overlayRGBData;
    private final AffineTransform finalTransform2 = new AffineTransform();
    private final AffineTransform zoomTransform2 = new AffineTransform();
    private static final Color COLOR_CROSSHAIRS = new Color(28, 134, 238);
    private static final Color[] ORIENTATION_CERTAINTY_COLORS = new Color[]{new Color(255, 0, 0, 200), new Color(255, 255, 0, 200), new Color(255, 255, 255, 200)};
    private static final Color[] ORIENTATION_CERTAINTY_COLORS_BACKGROUND = new Color[]{new Color(255, 0, 0, 128), new Color(255, 255, 0, 128), new Color(255, 255, 255, 128)};
    private static final MangoNumberFormatter FOMATTER_LONG = new MangoNumberFormatter(1);
    private static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    private static final Stroke STOKE_TOOL = new BasicStroke(2.0f);
    private static final Stroke STROKE_DASH = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private static final int CURSOR_TYPE_CROSSHAIRS = 2;
    private static final int CURSOR_TYPE_EMPTY = 0;
    private static final int CURSOR_TYPE_HAND_CLOSED = 20;
    private static final int CURSOR_TYPE_HAND_OPEN = 12;
    private static final int CURSOR_TYPE_MAGIC_WAND = 1024;
    private static final int CURSOR_TYPE_RESIZE = 32;
    private static final int CURSOR_TYPE_RESIZE_HORIZONTAL = 160;
    private static final int CURSOR_TYPE_RESIZE_NESW = 288;
    private static final int CURSOR_TYPE_RESIZE_NWSE = 544;
    private static final int CURSOR_TYPE_RESIZE_VERTICAL = 96;
    private static final int CURSOR_TYPE_SYSTEM = 1;
    private static final int DIR_EAST = 2;
    private static final int DIR_NORTH = 1;
    private static final int DIR_SOUTH = 4;
    private static final int DIR_WEST = 8;
    private static final int INSIDE = 16;
    private static final int NORTH_EAST = 3;
    private static final int NORTH_WEST = 9;
    private static final int SOUTH_EAST = 6;
    private static final int SOUTH_WEST = 12;
    private static final long serialVersionUID = 1L;
    private transient BufferedImage currentVideoFrame;
    private transient BufferedImage dicomOverlay;
    private transient BufferedImage dicomOverlayScaled;
    private transient BufferedImage histogramOverlay;
    private transient BufferedImage histogramOverlayScaled;
    private transient BufferedImage overlayMixer;
    private transient BufferedImage overlayMixerScaled;
    private transient List<BufferedImage> pluginOverlays;
    private transient BufferedImage radiologicalFiltered;
    private transient BufferedImage screenSlice;
    private transient BufferedImage screenSliceFiltered;
    private transient BufferedImage screenSliceFilteredRetina;
    private transient BufferedImage screenSliceFilteredScaled;
    private transient BufferedImage textureImage;
    private transient BufferedImage[] overlayScreenSlice;
    private transient BufferedImage[] overlayScreenSliceFiltered;
    private transient BufferedImage[] overlayScreenSliceFilteredScaled;
    private transient Coordinate centroidCoor;
    private transient Coordinate centroidCoorType;
    private transient LOIManager managerLOI;
    private transient LOIShape adjustingLOI;
    private transient LOIShape angleShape;
    private transient LOIShape editingLOI;
    private transient LOIShape rulerShape;
    private transient LOISpecialManager managerSpecialLOI;
    private transient Mango mango;
    private transient POI adjustingPOI;
    private transient POIManager managerPOI;
    private transient POISpecialManager managerSpecialPOI;
    private transient ROIShape adjustingShape;
    private transient ROIShape[] roi;
    private transient ScreenVolume[] overlays;
    private transient Timer videoCaptureTimer;
    private transient TransformableShape adjustingLOITransformableShape;
    private transient TransformableShape adjustingRealShape;
    private transient TransformableShape selectionShape;
    private transient Vector<BufferedImage> videoFrames;
    private transient Vector<SliceListener> sliceListeners = new Vector();
    private transient VideoCaptureListener videoCaptureListener;
    private transient Volume volume;
    public static final AffineTransform RETINA_INVERSE_XFORM = new AffineTransform(0.5, 0.0, 0.0, 0.5, 0.0, 0.0);
    public static final AffineTransform RETINA_XFORM = new AffineTransform(2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f);
    public static final Color COLOR_WHITE_ALPHA = new Color(255, 255, 255, 128);
    public static final Cursor CUSTOM_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(Mango.class.getResource("images/cursor_orange.gif")).getImage(), new Point(15, 15), "Custom Cursor");
    public static final Cursor CUSTOM_CURSOR_EMPTY = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(Mango.class.getResource("images/cursor_empty.gif")).getImage(), new Point(15, 15), "Custom Cursor Empty");
    public static final Cursor CUSTOM_CURSOR_HAND_CLOSED = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(Mango.class.getResource("images/cursor_hand_closed.gif")).getImage(), new Point(15, 15), "Custom Cursor Hand Closed");
    public static final Cursor CUSTOM_CURSOR_HAND_OPEN = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(Mango.class.getResource("images/cursor_hand_open.gif")).getImage(), new Point(15, 15), "Custom Cursor Hand Open");
    public static final Cursor CUSTOM_CURSOR_MAGIC_WAND = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(Mango.class.getResource("images/cursor_magic_wand.gif")).getImage(), new Point(11, 11), "Custom Cursor Magic Wand");
    public static final Cursor CUSTOM_CURSOR_RESIZE_HORIZONTAL = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(Mango.class.getResource("images/cursor_resize_horizontal.gif")).getImage(), new Point(15, 15), "Custom Cursor Resize Horizontal");
    public static final Cursor CUSTOM_CURSOR_RESIZE_NESW = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(Mango.class.getResource("images/cursor_resize_nesw.gif")).getImage(), new Point(15, 15), "Custom Cursor Resize NESW");
    public static final Cursor CUSTOM_CURSOR_RESIZE_NWSE = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(Mango.class.getResource("images/cursor_resize_nwse.gif")).getImage(), new Point(15, 15), "Custom Cursor Resize NWSE");
    public static final Cursor CUSTOM_CURSOR_RESIZE_VERTICAL = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(Mango.class.getResource("images/cursor_resize_vertical.gif")).getImage(), new Point(15, 15), "Custom Cursor Resize Vertical");
    public static final Font LABEL_FONT = new Font("SanSerif", 1, 16);
    public static final Font ORIENTATION_FONT = new Font("SanSerif", 1, 14);
    public static final Font ZOOM_FONT = new Font("SanSerif", 1, 42);
    public static final Image CURSOR_WHITE = new ImageIcon(Mango.class.getResource("images/cursor_white.gif")).getImage();
    public static final String TEXT_SELECT = "select";
    public static final double ROI_TOOL_SIZE_MULTIPLIER_NORMAL = 1.0;
    public static final double ROI_TOOL_SIZE_MULTIPLIER_SMALL = 0.25;
    public static final int ANGLE_COLOR_INDEX = 4;
    public static final int CROSSSECTION_MARKER_SIZE = 7;
    public static final int MAX_LABELS_DRAWN = 8;
    public static final int MOUSE_SCROLL_THRESHLD = 5;
    public static final int OVERLAY_SLICE_MAX = -1;
    public static final int OVERLAY_SLICE_MIN = 0;
    public static final int PADDING = 8;
    public static final int RULER_COLOR_INDEX = 5;
    public static final int SCREEN_SLICE_MAX = -1;
    public static final int SCREEN_SLICE_MIN = -16777216;
    public static final int TOUCH_TARGET_DEFAULT_SIZE = 3;

    public ScreenSlice(SliceViewer viewer) {
        this.viewer = viewer;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.toolBox = viewer.getToolBox();
        this.mango = viewer.getMango();
        if (!this.mango.isApplet()) {
            new DropTarget(this, 1, viewer, true);
        }
        this.pluginOverlays = new ArrayList<BufferedImage>();
        this.needsImageUpdate();
    }

    public void addSliceListener(SliceListener sl) {
        this.sliceListeners.add(sl);
        this.initializedSliceListeners = true;
    }

    public boolean canTranslate() {
        return !this.incrementShapeFlag && !this.viewer.isEditingDisabled();
    }

    public void clear() {
        int ctr;
        this.removeAllSliceListeners();
        if (this.screenSlice != null) {
            this.screenSlice.flush();
            this.screenSlice = null;
        }
        if (this.screenSliceFiltered != null) {
            this.screenSliceFiltered.flush();
            this.screenSliceFiltered = null;
        }
        if (this.radiologicalFiltered != null) {
            this.radiologicalFiltered.flush();
            this.radiologicalFiltered = null;
        }
        if (this.screenSliceFilteredRetina != null) {
            this.screenSliceFilteredRetina.flush();
            this.screenSliceFilteredRetina = null;
        }
        if (this.overlayMixer != null) {
            this.overlayMixer.flush();
            this.overlayMixer = null;
        }
        if (this.overlayMixerScaled != null) {
            this.overlayMixerScaled.flush();
            this.overlayMixerScaled = null;
        }
        if (this.histogramOverlay != null) {
            this.histogramOverlay.flush();
            this.histogramOverlay = null;
        }
        if (this.histogramOverlayScaled != null) {
            this.histogramOverlayScaled.flush();
            this.histogramOverlayScaled = null;
        }
        if (this.dicomOverlay != null) {
            this.dicomOverlay.flush();
            this.dicomOverlay = null;
        }
        if (this.dicomOverlayScaled != null) {
            this.dicomOverlayScaled.flush();
            this.dicomOverlayScaled = null;
        }
        if (this.textureImage != null) {
            this.textureImage.flush();
            this.textureImage = null;
        }
        if (this.pluginOverlays != null) {
            this.pluginOverlays.clear();
            this.pluginOverlays = null;
        }
        if (this.overlayScreenSlice != null) {
            for (ctr = 0; ctr < this.overlayScreenSlice.length; ++ctr) {
                if (this.overlayScreenSlice[ctr] == null) continue;
                this.overlayScreenSlice[ctr].flush();
                this.overlayScreenSlice[ctr] = null;
            }
        }
        this.overlayScreenSlice = null;
        if (this.overlayScreenSliceFiltered != null) {
            for (ctr = 0; ctr < this.overlayScreenSliceFiltered.length; ++ctr) {
                if (this.overlayScreenSliceFiltered[ctr] == null) continue;
                this.overlayScreenSliceFiltered[ctr].flush();
                this.overlayScreenSliceFiltered[ctr] = null;
            }
        }
        if (this.overlayScreenSliceFilteredScaled != null) {
            for (ctr = 0; ctr < this.overlayScreenSliceFilteredScaled.length; ++ctr) {
                if (this.overlayScreenSliceFilteredScaled[ctr] == null) continue;
                this.overlayScreenSliceFilteredScaled[ctr].flush();
                this.overlayScreenSliceFilteredScaled[ctr] = null;
            }
        }
        this.overlayScreenSliceFiltered = null;
        this.overlayScreenSliceFilteredScaled = null;
        if (this.sliceListeners != null) {
            this.sliceListeners.clear();
            this.sliceListeners = null;
        }
        this.screenTransform = null;
        this.radiologicalTransform = null;
        this.radiologicalFiltered = null;
        this.screenSliceFilteredRetina = null;
        this.screenSliceFiltered = null;
        this.screenSlice = null;
        this.rgbData = null;
        this.boundingBox = null;
        this.tempTransformedPoint = null;
        this.verticalBottom = null;
        this.verticalTop = null;
        this.horizontalRight = null;
        this.horizontalLeft = null;
        this.current = null;
        this.structureElement = null;
        this.roi = null;
        this.viewer = null;
        this.volume = null;
        this.toolBox = null;
        this.mango = null;
        this.bounds = null;
        this.selectionShapeBounds = null;
        this.adjustingRealShapeBounds = null;
        this.adjustingShapeBounds = null;
        this.boundingBox = null;
        this.centroidTransformed = null;
        this.centroidImage = null;
        this.crosssectionPoint = null;
        this.tempTransformedPoint = null;
        this.verticalBottom = null;
        this.verticalTop = null;
        this.horizontalRight = null;
        this.horizontalLeft = null;
        this.northWestHandle = null;
        this.westHandle = null;
        this.southWestHandle = null;
        this.southHandle = null;
        this.southEastHandle = null;
        this.eastHandle = null;
        this.northEastHandle = null;
        this.northHandle = null;
        this.checkBoundsPoint = null;
        this.selectionShapeStartPoint = null;
        this.tempPOIPoint = null;
        this.editingPoint = null;
        this.polyLineLast = null;
        this.polyLineStart = null;
        this.adjustingLOIShapeGrabPoint = null;
        this.adjustingShapeGrabPoint = null;
        this.calcLabel = null;
        this.orientP = null;
        this.orientA = null;
        this.orientR = null;
        this.orientL = null;
        this.adjustingRealShapeStartPoint = null;
        this.current = null;
        this.structureElement = null;
        this.polyLinePath = null;
        this.allSelectedBoundsPath = null;
        this.handlesPath = null;
        this.handle = null;
        this.centroidMarkerOutter = null;
        this.centroidMarker = null;
        this.crosssectionMarker = null;
        this.centroidCoorType = null;
        this.centroidCoor = null;
        this.adjustingShape = null;
        this.selectionShape = null;
        this.adjustingLOITransformableShape = null;
        this.adjustingRealShape = null;
        this.managerLOI = null;
        this.managerSpecialLOI = null;
        this.editingLOI = null;
        this.adjustingLOI = null;
        this.managerPOI = null;
        this.managerSpecialPOI = null;
        this.adjustingPOI = null;
        this.overlays = null;
        this.overlayRGBData = null;
        this.hasOverlay = null;
        this.shrinkWrapper = null;
    }

    public void clearDicomOverlay() {
        if (this.dicomOverlayData != null) {
            for (int ctr = 0; ctr < this.dicomOverlayData.length; ++ctr) {
                this.dicomOverlayData[ctr] = 0;
            }
        }
    }

    public void clearForReload() {
        this.removeAllSliceListeners();
        this.sliceListeners = null;
        this.screenTransform = null;
        this.radiologicalTransform = null;
        this.radiologicalFiltered = null;
        this.screenSliceFilteredRetina = null;
        this.screenSliceFiltered = null;
        this.screenSlice = null;
        this.rgbData = null;
        this.boundingBox = null;
        this.tempTransformedPoint = null;
        this.verticalBottom = null;
        this.verticalTop = null;
        this.horizontalRight = null;
        this.horizontalLeft = null;
        this.current = null;
        this.structureElement = null;
        this.roi = null;
        this.viewer = null;
        this.volume = null;
        this.toolBox = null;
    }

    public void clearHistogram() {
        for (int ctr = 0; ctr < this.histogramData.length; ++ctr) {
            this.histogramData[ctr] = 0;
        }
    }

    public void clearOverlayData() {
        for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
            int offsetY = this.xDim * ctrY;
            for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                int offset = offsetY + ctrX;
                for (int ctr = 0; ctr < 8; ++ctr) {
                    if (!this.hasOverlay[ctr]) continue;
                    this.overlayRGBData[ctr][offset] = 0;
                }
            }
        }
    }

    public void removePluginOverlay(BufferedImage pluginOverlay) {
        this.pluginOverlays.remove(pluginOverlay);
    }

    public void clearPolyLine() {
        this.polyLinePath = null;
        this.polyLineStart = null;
        this.isUpdatingPolyLine = false;
        this.isUpdatingLOI = false;
        this.polyLineCloseArmed = false;
        this.repaint();
    }

    public void clearScaledImages() {
        this.screenSliceFilteredScaled = null;
        this.radiologicalFiltered = null;
        this.histogramOverlayScaled = null;
        this.dicomOverlayScaled = null;
        this.overlayMixerScaled = null;
        for (int ctr = 0; ctr < this.overlayScreenSliceFilteredScaled.length; ++ctr) {
            this.overlayScreenSliceFilteredScaled[ctr] = null;
        }
    }

    public void clearTextureData() {
        this.textureImage = null;
        this.textureData = null;
    }

    public boolean containsMouse() {
        return this.containsMouse;
    }

    @Override
    public void contextMenuItemSelected() {
        this.showingContextMenu = false;
    }

    public boolean decrementCurrentSlice() {
        if (this.currentSlice > 0) {
            --this.currentSlice;
            this.needsImageUpdate();
            this.updateScreenSlice();
            this.updateROIShape();
            this.repaint();
            return true;
        }
        return false;
    }

    public void deleteLOIPoint() {
        if (this.editingLOI != null && this.editingPoint != null) {
            this.editingLOI.deletePoint(this.editingPoint);
            int numPoints = this.editingLOI.getNumPoints();
            if (numPoints < 2) {
                this.managerLOI.removeShape(this.editingLOI);
            }
        }
        this.editingLOI = null;
        this.editingPoint = null;
        this.isEditingLOI = false;
        this.isConnectingLOI = false;
        this.repaint();
    }

    public void doROIFill() {
        this.updateBoundsAndHandles(this.currentROI);
        if ((this.roiMode & 8) != 0) {
            this.roiFill = (this.roiMode & 2) != 0 ? this.roi[this.currentROI].doClickCircle(this.current, this.currentToolSize) : this.roi[this.currentROI].doClick(this.current, this.currentToolSize);
        } else if ((this.roiMode & 0x10) != 0) {
            if ((this.roiMode & 2) != 0) {
                this.roi[this.currentROI].doClickCircle(this.current, this.currentToolSize, false);
            } else {
                this.roi[this.currentROI].doClick(this.current, this.currentToolSize, false);
            }
            this.roiFill = false;
        } else if ((this.roiMode & 0x20) != 0) {
            if ((this.roiMode & 2) != 0) {
                this.roi[this.currentROI].doClickCircle(this.current, this.currentToolSize, true);
            } else {
                this.roi[this.currentROI].doClick(this.current, this.currentToolSize, true);
            }
            this.roiFill = true;
        }
    }

    @Override
    public synchronized Vector<BufferedImage> endVideoCapture() {
        this.stopVideoCaptureTimer();
        this.setCapturingVideo(false);
        return this.videoFrames;
    }

    public Point getCurrentCursorPosition() {
        return new Point(this.currentCursorX, this.currentCursorY);
    }

    public int getCurrentSlice() {
        return this.currentSlice;
    }

    public int getCurrentX() {
        return this.currentX;
    }

    public int getCurrentY() {
        return this.currentY;
    }

    public AffineTransform getFinalTransform() {
        return this.finalTransform;
    }

    public BufferedImage getImage() {
        return this.getImage(new BufferedImage(this.getSize().width, this.getSize().height, 2), this.currentSlice, true, false, false);
    }

    public BufferedImage getImage(boolean excludeExtras) {
        return this.getImage(new BufferedImage(this.getSize().width, this.getSize().height, 2), this.currentSlice, true, excludeExtras, false);
    }

    public BufferedImage getImage(BufferedImage bi, int aSlice) {
        return this.getImage(bi, aSlice, true, false, false);
    }

    public BufferedImage getImage(BufferedImage bi, int aSlice, boolean excludeExtras) {
        return this.getImage(bi, aSlice, true, excludeExtras, false);
    }

    public BufferedImage getImage(BufferedImage bi, int slice, boolean fillBackground, boolean excludeExtras, boolean copyCurrentSlice) {
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        if (fillBackground) {
            g2d.setClip(0, 0, this.getSize().width, this.getSize().height);
            g2d.setColor(Color.BLACK);
            g2d.fill(g2d.getClipBounds());
        }
        if (slice < this.numSlices && slice >= 0) {
            if (!copyCurrentSlice) {
                this.updateScreenSlice(slice, false);
                this.updateROIShape(slice, null);
                this.needsImageUpdate();
            }
        } else {
            return bi;
        }
        this.viewer.getBaseScreenVolume().getLookupTableManager().getOp().filter(this.screenSlice, this.screenSliceFiltered);
        boolean useRadiological = this.mango.isRadiologicalMode() && this.isRadiologicalSensitive();
        boolean useInterpolation = this.useInterpolation();
        if (useInterpolation) {
            if (this.needUpdateScaledSlice) {
                this.needUpdateScaledSlice = false;
                this.updateScaledBaseImage();
            }
            g2d.drawImage(this.screenSliceFilteredScaled, this.finalTransformImage, this);
        } else if (useRadiological) {
            this.updateRadiologicalImage(this.screenSliceFiltered);
            g2d.drawImage(this.radiologicalFiltered, this.finalTransform2, this);
        } else {
            g2d.drawImage(this.screenSliceFiltered, this.finalTransform, this);
        }
        if (useInterpolation) {
            this.drawOverlays(g2d, true);
        } else {
            this.drawOverlays(g2d, false);
        }
        if (this.useHistogram || this.usePreview) {
            if (useInterpolation) {
                if (this.needUpdateScaledHistogramSlice) {
                    this.needUpdateScaledHistogramSlice = false;
                    this.updateScaledHistogramImage();
                }
                g2d.drawImage(this.histogramOverlayScaled, this.finalTransformImage, this);
            } else if (useRadiological) {
                this.updateRadiologicalImage(this.histogramOverlay);
                g2d.drawImage(this.radiologicalFiltered, this.finalTransform2, this);
            } else {
                g2d.drawImage(this.histogramOverlay, this.finalTransform, this);
            }
        }
        if (this.dicomOverlayData != null) {
            if (useInterpolation) {
                if (this.needUpdateScaledDicomOverlaySlice) {
                    this.needUpdateScaledDicomOverlaySlice = false;
                    this.updateScaledDicomOverlayImage();
                }
                g2d.drawImage(this.dicomOverlayScaled, this.finalTransformImage, this);
            } else if (useRadiological) {
                this.updateRadiologicalImage(this.dicomOverlay);
                g2d.drawImage(this.radiologicalFiltered, this.finalTransform2, this);
            } else {
                g2d.drawImage(this.dicomOverlay, this.finalTransform, this);
            }
        }
        if (this.pluginOverlays.size() > 0) {
            for (BufferedImage pluginOverlay : this.pluginOverlays) {
                if (useRadiological) {
                    this.updateRadiologicalImage(pluginOverlay);
                    g2d.drawImage(this.radiologicalFiltered, this.finalTransform2, this);
                    continue;
                }
                g2d.drawImage(pluginOverlay, this.finalTransform, this);
            }
        }
        if (!excludeExtras) {
            this.drawShapes(g2d, slice);
        }
        g2d.dispose();
        return bi;
    }

    public LOIManager getLOIManager() {
        return this.managerLOI;
    }

    public int getNumSlices() {
        return this.numSlices;
    }

    public BufferedImage getScreenSlice() {
        return this.screenSlice;
    }

    public boolean isShowCrosshairs() {
        return this.showCrosshairs;
    }

    public int getSliceDirection() {
        return this.sliceDirection;
    }

    public BufferedImage getTextureImage() {
        return this.textureImage;
    }

    @Override
    public Dimension getVideoFrameDimensions() {
        return this.getSize();
    }

    public BufferedImage getVideoImage() {
        return this.getImage(new BufferedImage(this.getSize().width, this.getSize().height, 1), this.currentSlice, true, false, true);
    }

    public int getXdim() {
        return this.xDim;
    }

    public double getXmm() {
        return (double)this.xDim * this.xSize;
    }

    public double getXSize() {
        return this.xSize;
    }

    public double getXYratio() {
        return this.xSize / this.ySize;
    }

    public int getYdim() {
        return this.yDim;
    }

    public double getYmm() {
        return (double)this.yDim * this.ySize;
    }

    public double getYSize() {
        return this.ySize;
    }

    public double getYXratio() {
        return this.ySize / this.xSize;
    }

    public boolean hasActivePolyLine() {
        return this.isUpdatingPolyLine;
    }

    public boolean incrementCurrentSlice() {
        if (this.currentSlice < this.numSlices - 1) {
            ++this.currentSlice;
            this.needsImageUpdate();
            this.updateScreenSlice();
            this.updateROIShape();
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean incrementShape(double xTrans, double yTrans, int roiNum) {
        boolean didOperation = false;
        if (this.canTranslate() && this.viewer.getROIManager().isSelected(roiNum)) {
            this.incrementShapeFlag = true;
            this.setShapeTransform(1.0, 1.0, xTrans, yTrans, roiNum);
            didOperation = true;
            if (this.viewer.isMultiSliceMode()) {
                this.viewer.getROIManager().propagateSetShape(this.sliceDirection, (AffineTransform)this.shapeTransform.clone(), this.screenTransform, roiNum, false);
                this.clearShapeTransform();
            } else {
                this.viewer.getROIManager().setShape(this.currentSlice, this.sliceDirection, this.adjustingShape, roiNum, false);
                this.clearShapeTransform();
                this.viewer.updateROISlices();
                this.updateSelectedBoundsAndHandles();
                this.viewer.repaint();
            }
        }
        return didOperation;
    }

    public boolean isCapturingVideo() {
        return this.capturingVideo;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public boolean isEditingLOI() {
        return this.isEditingLOI;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean isRadiologicalSensitive() {
        return this.sliceDirection == 0 || this.sliceDirection == 1;
    }

    public boolean isShowingPreview() {
        return this.usePreview;
    }

    public boolean isUpdatingPolyline() {
        return this.isUpdatingPolyLine;
    }

    public void makeLOI() {
        if (this.isUpdatingLOI) {
            this.viewer.resetAllClipboardsUndo();
            this.managerLOI.storeUndoCopy();
            AffineTransform inverseTrans = null;
            try {
                inverseTrans = this.finalTransform.createInverse();
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
            PathIterator it = this.polyLinePath.getPathIterator(inverseTrans);
            LOIShape shapeLOI = new LOIShape(it, this.currentSlice, this.viewer.getRoiColor(), this.viewer, this.viewer);
            if (this.isEditingLOI) {
                this.managerLOI.updateStateLOIChanged();
                this.editingLOI.connect(shapeLOI, this.editingPoint);
            } else {
                this.managerLOI.addLOI(shapeLOI, true, true);
            }
            this.isEditingLOI = false;
            this.editingPoint = null;
            this.editingLOI = null;
            this.isConnectingLOI = false;
            this.polyLinePath = null;
            this.polyLineStart = null;
            this.isUpdatingPolyLine = false;
            this.isUpdatingLOI = false;
            this.polyLineCloseArmed = false;
            this.viewer.repaint();
        }
    }

    public BufferedImage addPluginOverlay() {
        BufferedImage pluginOverlay = new BufferedImage(this.xDim, this.yDim, 2);
        this.pluginOverlays.add(pluginOverlay);
        return pluginOverlay;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.viewer == null || this.viewer.isInWorkingState()) {
            return;
        }
        this.mouseDragged = true;
        this.isDragging = true;
        this.draggingCursorType = this.currentCursorType;
        Point point = me.getPoint();
        if (this.isPanning) {
            this.needsImageUpdate();
            this.convertScreenToImageLocation(point);
            this.viewer.setCurrentPanLocation(point.x, point.y, this.sliceDirection);
            return;
        }
        this.updateCurrentLocation(point);
        if (this.isZoomMode && !this.isWindowMode && this.containsMouse) {
            double zoomFactorCurrent = (double)(this.originalMouseY - this.currentCursorY) * 0.05;
            this.viewer.setZoomFactor(this.viewer.getZoomFactorPrevious() - zoomFactorCurrent, true);
            this.updateTransforms();
            this.updateROIShape();
            this.repaint();
        }
        if (this.isWindowMode && !this.isZoomMode) {
            if (this.previousMouseX != -1 && this.previousMouseY != -1) {
                this.viewer.windowLevelChanged(this.previousMouseX - this.currentCursorX, this.previousMouseY - this.currentCursorY);
            }
            this.previousMouseX = this.currentCursorX;
            this.previousMouseY = this.currentCursorY;
        }
        if (!this.isZoomMode && !this.isWindowMode && this.isMainImage && this.isGrabMode && this.isAdjustingPOI && this.clickCount == 1) {
            this.adjustingPOI.updatePOI(new Point(this.current.x + this.adjustingPOIGrabDiffX, this.current.y + this.adjustingPOIGrabDiffY), this.currentSlice, this.sliceDirection);
            this.shapePOIAdjusted = true;
            if (this.adjustingPOI.isSpecial()) {
                this.viewer.pointChanged(this.adjustingPOI);
            }
            this.repaint();
        }
        if (!this.isZoomMode && !this.isWindowMode && this.isMainImage && !this.isGrabMode && this.isEditingLOI && !this.isConnectingLOI) {
            this.editingPoint.setLocation(this.current);
            this.repaint();
        }
        if (!this.isZoomMode && !this.isWindowMode && this.isMainImage && this.isGrabMode && this.isAdjustingLOI && this.clickCount == 1) {
            int xTrans = this.current.x - this.adjustingLOIShapeGrabPoint.x;
            int yTrans = this.current.y - this.adjustingLOIShapeGrabPoint.y;
            this.adjustingLOITransformableShape.setTransform(1.0, 0.0, 0.0, 1.0, xTrans, yTrans);
            this.shapeLOIAdjusted = true;
            this.repaint();
        }
        if (!this.isZoomMode && !this.isWindowMode && this.isMainImage && this.isGrabMode && this.isAdjusting && this.clickCount == 1) {
            double yScale = 1.0;
            double xScale = 1.0;
            double yTrans = 0.0;
            double xTrans = 0.0;
            if ((this.grabLocation & 2) == 2) {
                xScale = (this.adjustingShapeBounds.getWidth() + (double)(this.current.x - this.adjustingShapeGrabPoint.x)) / this.adjustingShapeBounds.getWidth();
                xTrans = this.adjustingShapeBounds.getX() - this.adjustingShapeBounds.getX() * xScale;
            } else if ((this.grabLocation & 8) == 8) {
                xScale = (this.adjustingShapeBounds.getWidth() + (double)(this.adjustingShapeGrabPoint.x - this.current.x)) / this.adjustingShapeBounds.getWidth();
                xTrans = this.adjustingShapeBounds.getX() + this.adjustingShapeBounds.getWidth() - (this.adjustingShapeBounds.getX() + this.adjustingShapeBounds.getWidth()) * xScale;
            }
            if ((this.grabLocation & 4) == 4) {
                yScale = (this.adjustingShapeBounds.getHeight() + (double)(this.current.y - this.adjustingShapeGrabPoint.y)) / this.adjustingShapeBounds.getHeight();
                yTrans = this.adjustingShapeBounds.getY() - this.adjustingShapeBounds.getY() * yScale;
            } else if ((this.grabLocation & 1) == 1) {
                yScale = (this.adjustingShapeBounds.getHeight() + (double)(this.adjustingShapeGrabPoint.y - this.current.y)) / this.adjustingShapeBounds.getHeight();
                yTrans = this.adjustingShapeBounds.getY() + this.adjustingShapeBounds.getHeight() - (this.adjustingShapeBounds.getY() + this.adjustingShapeBounds.getHeight()) * yScale;
            }
            if ((this.grabLocation & 0x10) == 16) {
                xTrans = this.current.x - this.adjustingShapeGrabPoint.x;
                yTrans = this.current.y - this.adjustingShapeGrabPoint.y;
            }
            this.shapeTransform.setTransform(xScale, 0.0, 0.0, yScale, xTrans, yTrans);
            this.adjustingShape.setShapeTransform(this.shapeTransform);
            this.repaint();
        }
        if (this.isMainImage && !this.isGrabMode && this.isROIPolyLineMode && !this.isZoomMode && !this.isWindowMode) {
            this.updatePolyLine(false, point);
            this.repaint();
        }
        if (!this.isZoomMode && !this.isWindowMode && this.isMainImage && !this.isGrabMode && this.isAdjustingRealShape) {
            this.updateAdjustingRealShapePoint();
        }
        if (!(this.isZoomMode || this.isWindowMode || !this.isMainImage || this.isGrabMode || !this.isROIToolMode || this.isROIRealShapeMode || this.isROIPolyLineMode || this.isROIMagicWandMode || !this.containsMouse)) {
            double screenToolSizeX = Math.max((double)(this.currentToolSize * 2) * Math.abs(this.finalTransform.getScaleX()), Math.abs(this.finalTransform.getScaleX()));
            double screenToolSizeY = Math.max((double)(this.currentToolSize * 2) * Math.abs(this.finalTransform.getScaleY()), Math.abs(this.finalTransform.getScaleY()));
            this.structureElement.setFrame((double)this.currentCursorX - screenToolSizeX / 2.0, (double)this.currentCursorY - screenToolSizeY / 2.0, screenToolSizeX, screenToolSizeY);
            if (this.roiCurrentExists) {
                this.updateBoundsAndHandles(this.currentROI);
                if (this.containsMouse) {
                    if ((this.roiMode & 2) != 0) {
                        this.roi[this.currentROI].doDragCircle(this.current, this.currentToolSize, this.roiFill);
                    } else {
                        this.roi[this.currentROI].doDrag(this.current, this.currentToolSize, this.roiFill);
                    }
                }
            }
            this.repaint();
        }
        if (!(this.isZoomMode || this.isWindowMode || this.rulerShapeChanged || this.angleShapeChanged || this.isMainImage && (this.isGrabMode || this.isROIMode || this.isAdjusting))) {
            if (this.isAdjustingSelectionShape && this.isMainImage && this.isShiftDown) {
                this.updateSelectionBox();
            } else if (this.setCrosshairPosition(this.current.x, this.current.y)) {
                this.viewer.updateCrosshairSelection(this);
            }
            this.repaint();
        }
        this.checkToolBoxMouseLabels();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (this.viewer == null) {
            return;
        }
        this.updateCurrentLocation(me.getPoint());
        if (this.viewer.isROIToolMode()) {
            this.updateStructureElement();
        }
        this.checkToolBoxTextFields();
        this.containsMouse = true;
        this.viewer.setContainsMouse(true);
        if (this.mango.isCurrentActiveViewer(this.viewer)) {
            this.checkToolBoxMouseLabels();
        }
        this.updateCursor();
        if (!this.viewer.isInWorkingState()) {
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (this.viewer == null) {
            return;
        }
        this.toolBox.updateMouseLabelOutOfBounds();
        this.containsMouse = false;
        this.viewer.setContainsMouse(false);
        this.updateCursor();
        if (!this.viewer.isInWorkingState()) {
            this.repaint();
        }
        this.isZoomMode = false;
        this.mouseWheelPrimed = 0;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this.viewer == null) {
            return;
        }
        if (this.mouseWheelStarted) {
            if (!this.viewer.isSpecialNavFunctionPrimed()) {
                this.toolBox.setSelectionMode(0);
            }
            this.mouseWheelStarted = false;
        }
        this.updateCurrentLocation(me.getPoint());
        if (this.viewer.isROIToolMode()) {
            this.updateStructureElement();
        }
        if (this.mango.isCurrentActiveViewer(this.viewer)) {
            this.checkToolBoxMouseLabels();
        }
        this.updateCursor();
        if (this.isZoomMode || this.isMainImage && (this.isUpdatingPolyLine || this.viewer.isROIToolMode()) && !this.viewer.isInWorkingState()) {
            this.repaint();
        }
        this.isZoomMode = false;
        this.mouseWheelPrimed = 0;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        try {
            if (this.viewer.isInWorkingState()) {
                return;
            }
            this.checkToolBoxTextFields();
            Point point = me.getPoint();
            this.updateCurrentLocation(point);
            this.previousMouseX = -1;
            this.previousMouseY = -1;
            this.originalMouseY = this.currentCursorY;
            this.clickCount = me.getClickCount();
            this.isShiftDown = me.isShiftDown();
            this.isMetaDown = me.isMetaDown();
            this.isZoomMode = me.isAltDown();
            this.isWindowMode = this.isMetaDown && this.clickCount == 1;
            this.roiExists = this.viewer.getROIManager().hasROI();
            this.currentROI = this.viewer.getROIManager().getCurrentROI();
            this.roiCurrentExists = this.viewer.getROIManager().hasROI(this.currentROI);
            this.roiMode = this.viewer.getROIMode();
            this.isROIMode = this.viewer.isROIMode();
            this.isROIToolMode = this.viewer.isROIToolMode();
            this.isROIRealShapeMode = this.viewer.isROIRealShapeMode();
            this.isROIPolyLineMode = this.viewer.isROIPolyLineMode();
            this.isLOIMode = this.viewer.isLOIMode();
            this.isPOIMode = this.viewer.isPOIMode();
            this.isROIMagicWandMode = this.viewer.isROIMagicWandMode();
            this.isPressed = true;
            this.isAdjusting = false;
            this.isAdjustingRealShape = false;
            this.isAdjustingLOI = false;
            this.isAdjustingPOI = false;
            this.realShapeAdjusted = false;
            this.selectionShapeAdjusted = false;
            this.roiSelectionChanged = false;
            this.loiSelectionChanged = false;
            this.poiSelectionChanged = false;
            this.mouseDragged = false;
            this.shapeAdjusted = false;
            this.shapeLOIAdjusted = false;
            this.isGrabMode = false;
            this.rulerShapeChanged = false;
            this.angleShapeChanged = false;
            this.grabLocation = 0;
            if (this.showingContextMenu) {
                this.showingContextMenu = false;
                return;
            }
            if (this.viewer.isZooming() && this.isZoomMode && this.isShiftDown && !this.isWindowMode) {
                this.isPanning = true;
                this.convertScreenToImageLocation(point);
                this.viewer.setStartPanLocation(point.x, point.y, this.sliceDirection);
                this.toolBox.setSelectionMode(3);
                return;
            }
            boolean isShowingROI = this.viewer.isShowingROI();
            if (!isShowingROI && this.roiMode != 0) {
                if (!this.viewer.isShowingROIEdge() && !this.viewer.isShowingROIMask()) {
                    this.viewer.setViewOptionROIEdge(true);
                }
                if (this.viewer.isViewerHideROI()) {
                    this.viewer.setViewerHideROI(false);
                }
                isShowingROI = this.viewer.isShowingROI();
            }
            if (this.isZoomMode) {
                if (this.clickCount == 2) {
                    this.viewer.setZoomFactor(1.0, true);
                } else {
                    this.viewer.setZoomLocation(this.currentX, this.currentY, this.sliceDirection);
                }
            } else if (!this.isMetaDown) {
                if (this.isMainImage && isShowingROI) {
                    POI proximalSpecialPOI;
                    POI proximalPOI;
                    LOIShape proximalLOIHandle = this.findProximalLOIHandle(true, this.isROIPolyLineMode);
                    if (proximalLOIHandle != null) {
                        this.isAdjustingLOI = true;
                        this.adjustingLOI = proximalLOIHandle;
                        this.adjustingLOIShapeGrabPoint.setLocation(this.current);
                        this.adjustingLOITransformableShape = new TransformableShape(this.adjustingLOI);
                        this.isGrabMode = true;
                    }
                    if ((proximalPOI = this.findProximalPOI(this.viewer.getROIMode() != 512)) != null) {
                        this.viewer.resetAllClipboardsUndo();
                        if (!proximalPOI.isSpecial()) {
                            this.managerPOI.storeUndoCopy();
                        }
                        this.isAdjustingPOI = true;
                        this.adjustingPOI = proximalPOI;
                        int[] offset = this.findProximalPOIOffset();
                        if (offset.length > 0) {
                            this.adjustingPOIGrabDiffX = offset[0];
                            this.adjustingPOIGrabDiffY = offset[1];
                        }
                        this.isGrabMode = true;
                    }
                    if (proximalPOI == null && (proximalSpecialPOI = this.findProximalSpecialPOI()) != null && !proximalSpecialPOI.isImmutable()) {
                        this.isAdjustingPOI = true;
                        this.adjustingPOI = proximalSpecialPOI;
                        int[] offset = this.findProximalPOIOffset();
                        if ((long)offset.length > 0L) {
                            this.adjustingPOIGrabDiffX = offset[0];
                            this.adjustingPOIGrabDiffY = offset[1];
                        }
                        this.isGrabMode = true;
                    }
                    Vector<Integer> selectedIndices = this.viewer.getROIManager().getSelectedIndices(false, true);
                    for (int colorIndex : selectedIndices) {
                        if (this.viewer.isSelected(this, this.currentSlice, this.sliceDirection, colorIndex)) {
                            this.grabLocation = this.findProximalHandle(colorIndex);
                            if (this.grabLocation != 0) {
                                this.updateAdjustingShape(this.roi[colorIndex], this.grabLocation, colorIndex);
                                this.isGrabMode = true;
                            }
                        }
                        if (!this.isGrabMode) continue;
                        break;
                    }
                    if (this.grabLocation == 0) {
                        for (int ctr : selectedIndices) {
                            if (this.viewer.isSelected(this, this.currentSlice, this.sliceDirection, ctr) && this.bounds[ctr].contains(this.currentCursorX, this.currentCursorY)) {
                                this.setCursor(CUSTOM_CURSOR_HAND_CLOSED);
                                this.currentCursorType = 20;
                                this.grabLocation = 16;
                                this.updateAdjustingShape(this.roi[ctr], this.grabLocation, ctr);
                                this.isGrabMode = true;
                            }
                            if (!this.isGrabMode) continue;
                            break;
                        }
                    }
                }
                boolean isROIMagicWandModeDelete = this.viewer.isROIMagicWandModeDelete();
                boolean isROIMagicWandModePreserve = this.viewer.isROIMagicWandModePreserve();
                boolean isROIMagicWandModeCopy = this.viewer.isROIMagicWandModeCopy();
                boolean isROIMagicWandModeDilate = this.viewer.isROIMagicWandModeDilate();
                boolean isROIMagicWandModeErode = this.viewer.isROIMagicWandModeErode();
                if (this.isMainImage && this.isROIMagicWandMode && isShowingROI) {
                    if (this.roiCurrentExists) {
                        if (isROIMagicWandModeDelete) {
                            if (this.viewer.isMultiSliceMode()) {
                                this.viewer.doSelectedComponentRemove3D(this.current, true);
                            } else {
                                this.viewer.doSelectedComponentRemove2D(this.current, true);
                            }
                        } else if (isROIMagicWandModePreserve) {
                            if (this.viewer.isMultiSliceMode()) {
                                this.viewer.doSelectedComponentRemove3D(this.current, false);
                            } else {
                                this.viewer.doSelectedComponentRemove2D(this.current, false);
                            }
                        } else if (isROIMagicWandModeErode) {
                            if (this.viewer.isMultiSliceMode()) {
                                if (this.isShiftDown) {
                                    this.viewer.doSelectedComponentErode3D(this.current, false, this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                                } else {
                                    this.viewer.doSelectedComponentDilate3D(this.current, false, this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                                }
                            } else if (this.isShiftDown) {
                                this.viewer.doSelectedComponentErode2D(this.current, false, this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                            } else {
                                this.viewer.doSelectedComponentDilate2D(this.current, false, this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                            }
                        } else if (isROIMagicWandModeCopy) {
                            if (this.viewer.isMultiSliceMode()) {
                                this.viewer.doSelectedComponentCopy3D(this.current);
                            } else {
                                this.viewer.doSelectedComponentCopy2D(this.current);
                            }
                        } else if (this.viewer.isMultiSliceMode()) {
                            this.viewer.doSelectedComponentValues3D(this.current, this.useSmartTools(), this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                        } else {
                            this.viewer.doSelectedComponentValues2D(this.current, this.useSmartTools(), this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                        }
                    } else if (!(isROIMagicWandModeDelete || isROIMagicWandModePreserve || isROIMagicWandModeDilate || isROIMagicWandModeErode || isROIMagicWandModeCopy)) {
                        if (this.viewer.isMultiSliceMode()) {
                            this.viewer.doSelectedComponentValues3D(this.current, this.useSmartTools(), this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                        } else {
                            this.viewer.doSelectedComponentValues2D(this.current, this.useSmartTools(), this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                        }
                    }
                }
                if (this.isMainImage && !this.isGrabMode && this.showLineLength) {
                    this.editingPoint = this.rulerShape.editLineAt(this.current, this.targetSize, false);
                    this.isEditingLOI = this.editingPoint != null;
                    this.editingLOI = this.rulerShape;
                    this.rulerShapeChanged = this.isEditingLOI;
                }
                if (this.isMainImage && !this.isGrabMode && !this.rulerShapeChanged && this.showLineAngle) {
                    this.editingPoint = this.angleShape.editLineAt(this.current, this.targetSize, false);
                    this.isEditingLOI = this.editingPoint != null;
                    this.editingLOI = this.angleShape;
                    this.angleShapeChanged = this.isEditingLOI;
                }
                boolean brokeLOI = false;
                if (this.isMainImage && !this.isGrabMode && this.isROIPolyLineMode) {
                    if (!this.isConnectingLOI && !this.isUpdatingPolyLine && (this.roiMode & 0x180) != 0) {
                        for (LOIShape currentLOI = this.managerLOI.getShape(this.currentSlice); currentLOI != null && !this.isEditingLOI; currentLOI = currentLOI.getNext()) {
                            if (currentLOI.isImmutable() || currentLOI.getColor() != this.currentROI) continue;
                            this.editingPoint = currentLOI.editLineAt(this.current, this.targetSize);
                            this.isEditingLOI = this.editingPoint != null;
                            this.editingLOI = currentLOI;
                            if (this.isEditingLOI) {
                                this.viewer.resetAllClipboardsUndo();
                                this.managerLOI.storeUndoCopy();
                                this.managerLOI.updateStateLOIChanged();
                            }
                            if (this.clickCount > 1 && this.isEditingLOI && this.editingLOI.isClosed()) {
                                this.editingLOI.breakClosedShape(this.editingPoint);
                                this.editingPoint = null;
                                this.isEditingLOI = false;
                                this.editingLOI = null;
                                this.isConnectingLOI = false;
                                brokeLOI = true;
                                continue;
                            }
                            if (this.clickCount <= 1 || !this.isEditingLOI || this.editingLOI.isClosed() || !this.editingPoint.equals(this.editingLOI.getStartPoint()) && !this.editingPoint.equals(this.editingLOI.getEndPoint())) continue;
                            this.isConnectingLOI = true;
                            this.updatePolyLine(true, point);
                        }
                    }
                    if (!brokeLOI && (!this.isEditingLOI || this.isEditingLOI && this.isConnectingLOI)) {
                        this.updatePolyLine(true, point);
                    }
                }
                if (this.isMainImage && !this.isGrabMode && this.isROIRealShapeMode) {
                    this.updateAdjustingRealShape();
                }
                boolean isROIDrawMode = this.viewer.isROIDrawMode();
                if (this.isMainImage && !this.isGrabMode && isROIDrawMode && !this.isLOIMode && !this.roiCurrentExists) {
                    this.viewer.initializeCurrentROI();
                }
                if (this.isMainImage && (this.isROIToolMode || this.isROIRealShapeMode || this.isROIPolyLineMode) && !this.isZoomMode && !this.isGrabMode && this.isROIMode && this.roiCurrentExists && (isROIDrawMode || this.viewer.isShowingROI()) && this.containsMouse && !this.isROIMagicWandMode) {
                    if (!isShowingROI) {
                        this.viewer.setViewOptionROIEdge(true);
                        isShowingROI = true;
                    }
                    if (this.roiMode == 69) {
                        this.adjustingRealShape = new TransformableShape(new Rectangle(this.currentCursorX, this.currentCursorY, 1, 1));
                        this.adjustingRealShapeBounds = this.adjustingRealShape.getBounds();
                        this.isAdjustingRealShape = true;
                    } else if (this.roiMode == 70) {
                        this.adjustingRealShape = new TransformableShape(new Ellipse2D.Double(this.currentCursorX, this.currentCursorY, 1.0, 1.0));
                        this.adjustingRealShapeBounds = this.adjustingRealShape.getBounds();
                        this.isAdjustingRealShape = true;
                    } else {
                        this.updateStructureElement();
                        this.draggingCursorType = 0;
                        if ((this.roiMode & 8) != 0) {
                            this.roiFill = (this.roiMode & 2) != 0 ? this.roi[this.currentROI].doClickCircle(this.current, this.currentToolSize) : this.roi[this.currentROI].doClick(this.current, this.currentToolSize);
                        } else if ((this.roiMode & 0x10) != 0) {
                            if ((this.roiMode & 2) != 0) {
                                this.roi[this.currentROI].doClickCircle(this.current, this.currentToolSize, false);
                            } else {
                                this.roi[this.currentROI].doClick(this.current, this.currentToolSize, false);
                            }
                            this.roiFill = false;
                        } else if ((this.roiMode & 0x20) != 0) {
                            if ((this.roiMode & 2) != 0) {
                                this.roi[this.currentROI].doClickCircle(this.current, this.currentToolSize, true);
                            } else {
                                this.roi[this.currentROI].doClick(this.current, this.currentToolSize, true);
                            }
                            this.roiFill = true;
                        }
                    }
                }
                boolean loiExists = this.managerLOI.hasShapes(this.currentSlice);
                if (this.isMainImage && !this.isZoomMode && !this.isROIMode && loiExists && isShowingROI) {
                    if (this.clickCount == 2) {
                        Point endPoint;
                        Point startPoint;
                        int currentColor;
                        LOIShape currentLOI;
                        boolean containsOfCurrentColor = false;
                        for (currentLOI = this.managerLOI.getShape(this.currentSlice); currentLOI != null; currentLOI = currentLOI.getNext()) {
                            currentColor = currentLOI.getColor();
                            startPoint = currentLOI.getStartPoint();
                            endPoint = currentLOI.getEndPoint();
                            if (!(endPoint != null && endPoint.distance(this.current) < 5.0) && !(startPoint.distance(this.current) < 5.0) || currentColor != this.currentROI) continue;
                            containsOfCurrentColor = true;
                            break;
                        }
                        for (currentLOI = this.managerLOI.getShape(this.currentSlice); currentLOI != null; currentLOI = currentLOI.getNext()) {
                            currentColor = currentLOI.getColor();
                            if (currentLOI.isClosed() && !currentLOI.isPOI()) {
                                if (!currentLOI.contains(this.current)) continue;
                                currentLOI.toggleSelectedState();
                                this.viewer.recordAction(TEXT_SELECT, new String[]{this.viewer.getScriptObjectName() + ".roiData.allROIs", ScriptUtils.convertBoolean(currentLOI.isSelected())}, true);
                                this.loiSelectionChanged = true;
                                continue;
                            }
                            startPoint = currentLOI.getStartPoint();
                            endPoint = currentLOI.getEndPoint();
                            if (startPoint.distance(this.current) < 5.0 && (!containsOfCurrentColor || currentColor == this.currentROI)) {
                                currentLOI.toggleSelectedState();
                                this.viewer.recordAction(TEXT_SELECT, new String[]{this.viewer.getScriptObjectName() + ".roiData.allROIs", ScriptUtils.convertBoolean(currentLOI.isSelected())}, true);
                                this.loiSelectionChanged = true;
                                continue;
                            }
                            if (currentLOI.isPOI() || !(endPoint.distance(this.current) < 5.0) || containsOfCurrentColor && currentColor != this.currentROI) continue;
                            currentLOI.toggleSelectedState();
                            this.viewer.recordAction(TEXT_SELECT, new String[]{this.viewer.getScriptObjectName() + ".roiData.allROIs", ScriptUtils.convertBoolean(currentLOI.isSelected())}, true);
                            this.loiSelectionChanged = true;
                        }
                    }
                    if (this.loiSelectionChanged) {
                        this.managerLOI.notifySelectionChanged();
                    }
                }
                boolean poiExists = this.managerPOI.hasPoints(this.currentSlice, this.sliceDirection);
                if (this.isMainImage && !this.isZoomMode && !this.isROIMode && poiExists && isShowingROI && this.clickCount == 2) {
                    POI currentPOI;
                    boolean containsOfCurrentColor = false;
                    for (currentPOI = this.managerPOI.getPOIs(this.currentSlice, this.sliceDirection); currentPOI != null; currentPOI = currentPOI.getNext(this.sliceDirection)) {
                        int currentColor = currentPOI.getColor();
                        if (this.sliceDirection == 0) {
                            this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getY());
                        } else if (this.sliceDirection == 1) {
                            this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getZ());
                        } else {
                            this.tempPOIPoint.setLocation(currentPOI.getY(), currentPOI.getZ());
                        }
                        if (!(this.tempPOIPoint.distance(this.current) < 5.0) || currentColor != this.currentROI) continue;
                        containsOfCurrentColor = true;
                        break;
                    }
                    for (currentPOI = this.managerPOI.getPOIs(this.currentSlice, this.sliceDirection); currentPOI != null; currentPOI = currentPOI.getNext(this.sliceDirection)) {
                        int currentColor = currentPOI.getColor();
                        if (this.sliceDirection == 0) {
                            this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getY());
                        } else if (this.sliceDirection == 1) {
                            this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getZ());
                        } else {
                            this.tempPOIPoint.setLocation(currentPOI.getY(), currentPOI.getZ());
                        }
                        if (!(this.tempPOIPoint.distance(this.current) < 5.0) || containsOfCurrentColor && currentColor != this.currentROI) continue;
                        currentPOI.toggleSelectedState();
                        this.viewer.recordAction(TEXT_SELECT, new String[]{this.viewer.getScriptObjectName() + ".roiData.allROIs", ScriptUtils.convertBoolean(currentPOI.isSelected())}, true);
                        this.poiSelectionChanged = true;
                        this.viewer.pointSelectionChanged();
                    }
                }
                if (!this.loiSelectionChanged && !this.poiSelectionChanged && this.isMainImage && !this.isZoomMode && !this.isROIMode && this.roiExists && isShowingROI) {
                    if (this.clickCount == 2) {
                        Vector<Integer> usedROIs = this.viewer.getROIManager().getUsedIndicesCurrentFirst();
                        for (int colorIndex : usedROIs) {
                            boolean isCurrent;
                            boolean bl = isCurrent = colorIndex == this.viewer.getROIManager().getCurrentROI();
                            if (!this.viewer.getROIManager().hasROI(colorIndex) || !this.roi[colorIndex].contains(this.current)) continue;
                            if (this.viewer.isMultiSliceMode()) {
                                this.viewer.getROIManager().toggleSelectedState(colorIndex);
                                this.viewer.recordAction(TEXT_SELECT, new String[]{this.viewer.getScriptObjectName() + ".roiData.allROIs", ScriptUtils.convertBoolean(this.viewer.getROIManager().isSelected(colorIndex))}, true);
                                this.roiSelectionChanged = true;
                                if (!isCurrent) continue;
                                break;
                            }
                            this.viewer.getROIManager().toggleSelectedState(colorIndex, this.currentSlice, this.sliceDirection);
                            this.viewer.recordAction(TEXT_SELECT, new String[]{this.viewer.getScriptObjectName() + ".roiData.allROIs", ScriptUtils.convertBoolean(this.viewer.getROIManager().isSelected(colorIndex))}, true);
                            this.roiSelectionChanged = true;
                            if (!isCurrent) continue;
                            break;
                        }
                    }
                    this.updateSelectedBoundsAndHandles();
                }
                if (!(this.clickCount != 2 || this.loiSelectionChanged || this.poiSelectionChanged || this.roiSelectionChanged || !this.isMainImage || this.isZoomMode || this.isROIMode)) {
                    this.viewer.deselectAll();
                    this.roiSelectionChanged = true;
                    this.viewer.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Deselect All")});
                    this.updateSelectedBoundsAndHandles();
                }
                if (this.isMainImage && this.isPOIMode && !this.isGrabMode) {
                    this.makePOI(this.current);
                }
                if (!(this.isZoomMode || this.rulerShapeChanged || this.angleShapeChanged || this.isMetaDown || this.viewer.getZoomFactor() != 1.0 || this.isMainImage && (this.isGrabMode || this.roiSelectionChanged || this.loiSelectionChanged || this.poiSelectionChanged || this.grabLocation != 0 || this.isROIMode))) {
                    if (this.isMainImage && this.isShiftDown) {
                        this.updateAdjustingSelectionShape();
                        this.selectionShape = new TransformableShape(new Rectangle(this.currentCursorX, this.currentCursorY, 1, 1));
                        this.selectionShapeBounds = this.selectionShape.getBounds();
                        this.isAdjustingSelectionShape = true;
                    } else if (this.setCrosshairPosition(this.current.x, this.current.y)) {
                        this.viewer.updateCrosshairSelection(this);
                    }
                }
            }
            this.updateCursor();
            this.updateTransforms();
            this.viewer.repaint();
            if (this.isMetaDown) {
                if (this.isZoomMode) {
                    this.toolBox.setSelectionMode(3);
                } else {
                    this.toolBox.setSelectionMode(1);
                }
            }
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        try {
            this.isZoomMode = false;
            this.mouseWheelPrimed = 0;
            this.isPressed = false;
            this.isDragging = false;
            this.isAdjustingRealShape = false;
            this.isAdjustingSelectionShape = false;
            this.isGrabMode = false;
            if (this.viewer == null || this.viewer.isInWorkingState()) {
                return;
            }
            if (!this.isMetaDown && (this.isDragging || this.isROIMode)) {
                this.viewer.recordAction("pauseScriptForUserInput");
            }
            Point point = me.getPoint();
            boolean separateThreadProcess = false;
            if (!this.mouseDragged && this.isMetaDown) {
                POI proximalPOIHandle;
                int currentROI = this.viewer.getROIManager().getCurrentROI();
                if (this.viewer.getROIManager().hasROI(currentROI) && this.roi[currentROI].contains(this.current)) {
                    this.showingContextMenu = true;
                    ROIContextMenu.doPop(this.viewer, this, currentROI, this, point);
                } else {
                    Vector<Integer> usedROIs = this.viewer.getROIManager().getUsedIndices();
                    for (int ctr : usedROIs) {
                        if (ctr == currentROI || !this.viewer.getROIManager().hasROI(ctr) || !this.roi[ctr].contains(this.current)) continue;
                        this.showingContextMenu = true;
                        ROIContextMenu.doPop(this.viewer, this, ctr, this, point);
                        break;
                    }
                }
                LOIShape proximalLOIHandle = this.findProximalLOIHandle(false, false);
                if (proximalLOIHandle != null) {
                    this.showingContextMenu = true;
                    LineContextMenu.doPop(this.viewer, this, proximalLOIHandle, this, point);
                }
                if ((proximalPOIHandle = this.findProximalPOI(false)) != null) {
                    this.showingContextMenu = true;
                    PointContextMenu.doPop(this.viewer, this, proximalPOIHandle, this, point);
                }
                if (!this.showingContextMenu) {
                    this.showingContextMenu = true;
                    if (this.sliceDirection == 0) {
                        ImageContextMenu.doPop(this.viewer, this, this, new Coordinate4D((double)this.current.x, (double)this.current.y, (double)this.currentSlice, this.viewer.getCurrentTimepoint()), point);
                    } else if (this.sliceDirection == 1) {
                        ImageContextMenu.doPop(this.viewer, this, this, new Coordinate4D((double)this.current.x, (double)this.currentSlice, (double)this.current.y, this.viewer.getCurrentTimepoint()), point);
                    } else {
                        ImageContextMenu.doPop(this.viewer, this, this, new Coordinate4D((double)this.currentSlice, (double)this.current.x, (double)this.current.y, this.viewer.getCurrentTimepoint()), point);
                    }
                }
            }
            if (this.editingLOI != null) {
                this.editingLOI.getUser().shapeChanged(this.editingLOI);
            }
            if (!(this.isZoomMode || this.isPanning || !(this.viewer.getZoomFactor() > 1.0) || this.isPOIMode || this.shapeAdjusted || this.realShapeAdjusted || this.roiSelectionChanged || this.loiSelectionChanged || this.poiSelectionChanged || this.isGrabMode || this.mouseDragged && this.isROIMode || this.isROIPolyLineMode || this.isROIMagicWandMode || !this.setCrosshairPosition(this.current.x, this.current.y))) {
                this.viewer.updateCrosshairSelection(this);
            }
            if (!this.isZoomMode && this.isMainImage && !this.isROIMagicWandMode && (this.isROIMode || this.isAdjusting || this.isAdjustingPOI || this.isAdjustingLOI) && this.viewer.isShowingROI()) {
                if (this.shapeAdjusted) {
                    if (!this.shapeTransform.isIdentity()) {
                        if (this.viewer.isMultiSliceMode()) {
                            this.viewer.getROIManager().propagateSetShape(this.sliceDirection, (AffineTransform)this.shapeTransform.clone(), this.screenTransform, this.adjustingNum);
                            separateThreadProcess = true;
                        } else {
                            this.viewer.getROIManager().setShape(this.currentSlice, this.sliceDirection, this.adjustingShape, this.adjustingNum);
                        }
                    }
                    this.clearShapeTransform();
                } else if (this.realShapeAdjusted) {
                    Shape adjustingRealShapeTransformed = null;
                    try {
                        adjustingRealShapeTransformed = this.finalTransform.createInverse().createTransformedShape(this.adjustingRealShape.createTransformedShape());
                    }
                    catch (Exception ex) {
                        AppLogger.error((Throwable)ex);
                    }
                    this.viewer.getROIManager().setShape(this.currentSlice, this.sliceDirection, adjustingRealShapeTransformed, true, this.useSmartTools(), this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                    this.updateROIShape();
                } else if (this.roiCurrentExists && !this.isROIPolyLineMode) {
                    this.viewer.getROIManager().setShape(this.currentSlice, this.sliceDirection, this.useSmartTools(), this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax(), this.roiFill, this.mango.getToolSliceRangeAbove(), this.mango.getToolSliceRangeBelow(), false);
                }
            }
            if (this.selectionShapeAdjusted) {
                this.selectAllROIsWithinBounds(this.selectionShape);
            }
            if (!this.isZoomMode && this.isMainImage && this.shapeLOIAdjusted) {
                this.viewer.resetAllClipboardsUndo();
                this.managerLOI.storeUndoCopy();
                this.managerLOI.updateStateLOIChanged();
                this.adjustingLOI.setPath(this.adjustingLOITransformableShape.createTransformedShape().getPathIterator(null));
            }
            if (this.loiSelectionChanged) {
                this.managerLOI.notifySelectionChanged();
            }
            if (!this.isZoomMode && this.isMainImage && this.shapePOIAdjusted) {
                if (this.adjustingPOI.isSpecial()) {
                    this.managerSpecialPOI.updatePOI(this.adjustingPOI);
                } else {
                    this.managerPOI.updatePOI(this.adjustingPOI);
                }
                this.shapePOIAdjusted = true;
                this.viewer.pointChangingStopped(this.adjustingPOI);
            }
            this.isAdjusting = false;
            this.isAdjustingLOI = false;
            this.isAdjustingPOI = false;
            this.shapeLOIAdjusted = false;
            this.shapePOIAdjusted = false;
            this.selectionShapeAdjusted = false;
            this.adjustingPOI = null;
            this.adjustingPOIGrabDiffY = 0;
            this.adjustingPOIGrabDiffX = 0;
            this.adjustingLOI = null;
            this.adjustingLOITransformableShape = null;
            this.isZoomMode = false;
            this.isMetaDown = false;
            this.mouseWheelPrimed = 0;
            this.isWindowMode = false;
            this.isPanning = false;
            this.isPressed = false;
            this.viewer.setZoomFactorPrevious(this.viewer.getZoomFactor());
            if (!this.isConnectingLOI) {
                this.editingLOI = null;
                this.editingPoint = null;
                this.isEditingLOI = false;
            }
            this.updateCursor();
            if (this.mango.getViewerSyncer().getType() != 0) {
                this.mango.updateSurfaces();
            } else {
                this.viewer.updateSurface();
            }
            if (!separateThreadProcess) {
                this.viewer.updateROISlices();
                this.updateSelectedBoundsAndHandles();
                this.viewer.repaint();
            }
            if (!this.viewer.isSpecialNavFunctionPrimed()) {
                this.toolBox.setSelectionMode(0);
            }
            this.checkToolBoxMouseLabels();
            this.viewer.updateWindowTitle();
        }
        catch (Exception ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        if (this.viewer.isScrollwheelSlices()) {
            int diff = (int)Math.signum(mwe.getWheelRotation());
            if (this.viewer.setMainSliceNumber(this.viewer.getMainSliceNumber() + diff)) {
                this.viewer.updateToolBoxSlice(this.sliceDirection, diff);
            }
        } else {
            if (this.isZoomMode || this.mouseWheelPrimed > 5) {
                this.isZoomMode = true;
                this.viewer.setZoomLocation(this.currentX, this.currentY, this.sliceDirection);
                double zoomFactorCurrent = (double)mwe.getWheelRotation() * 0.05;
                if (this.viewer.isScrollwheelDirectionFlip()) {
                    zoomFactorCurrent *= -1.0;
                }
                this.viewer.setZoomFactor(this.viewer.getZoomFactorPrevious() + zoomFactorCurrent, true);
                this.viewer.setZoomFactorPrevious(this.viewer.getZoomFactor());
                this.updateTransforms();
                this.updateROIShape();
                this.repaint();
                if (!this.mouseWheelStarted) {
                    this.toolBox.setSelectionMode(2);
                    this.mouseWheelStarted = true;
                }
            }
            this.mouseWheelPrimed += Math.abs(mwe.getWheelRotation());
        }
    }

    public void needsHistogramUpdate() {
        this.needUpdateScaledHistogramSlice = true;
    }

    public final void needsImageUpdate() {
        this.needUpdateScaledSlice = true;
        this.needUpdateScaledOverlaySlices = true;
        this.needUpdateScaledHistogramSlice = true;
        this.needUpdateScaledDicomOverlaySlice = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        if (this.viewer == null) {
            return;
        }
        if (!(this.viewer.isOrthoSliceMode() || this.viewer.isOrthoWide() || this.isMainImage)) {
            return;
        }
        if (this.viewer.isStopPainting() || !this.viewer.isReady()) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        boolean useInterpolation = this.useInterpolation();
        boolean useRadiological = this.mango.isRadiologicalMode() && this.isRadiologicalSensitive();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setColor(Color.BLACK);
        g2d.fill(g2d.getClip());
        BufferedImage tempImage = this.screenSliceFiltered;
        if (this.viewer.isARGB()) {
            this.screenSliceFiltered = this.screenSlice;
        } else {
            this.viewer.getBaseScreenVolume().getLookupTableManager().getOp().filter(this.screenSlice, this.screenSliceFiltered);
        }
        if (useInterpolation) {
            if (this.needUpdateScaledSlice) {
                this.needUpdateScaledSlice = false;
                this.updateScaledBaseImage();
            }
            g2d.drawImage(this.screenSliceFilteredScaled, this.finalTransformImage, this);
        } else if (useRadiological) {
            this.updateRadiologicalImage(this.screenSliceFiltered);
            g2d.drawImage(this.radiologicalFiltered, this.finalTransform2, this);
        } else {
            g2d.drawImage(this.screenSliceFiltered, this.finalTransform, this);
        }
        this.screenSliceFiltered = tempImage;
        if (useInterpolation) {
            this.drawOverlays(g2d, true);
        } else {
            this.drawOverlays(g2d, false);
        }
        if (this.useHistogram || this.usePreview) {
            if (useInterpolation) {
                if (this.needUpdateScaledHistogramSlice) {
                    this.needUpdateScaledHistogramSlice = false;
                    this.updateScaledHistogramImage();
                }
                g2d.drawImage(this.histogramOverlayScaled, this.finalTransformImage, this);
            } else if (useRadiological) {
                this.updateRadiologicalImage(this.histogramOverlay);
                g2d.drawImage(this.radiologicalFiltered, this.finalTransform2, this);
            } else {
                g2d.drawImage(this.histogramOverlay, this.finalTransform, this);
            }
        }
        if (this.dicomOverlayData != null) {
            if (useInterpolation) {
                if (this.needUpdateScaledDicomOverlaySlice) {
                    this.needUpdateScaledDicomOverlaySlice = false;
                    this.updateScaledDicomOverlayImage();
                }
                g2d.drawImage(this.dicomOverlayScaled, this.finalTransformImage, this);
            } else {
                g2d.drawImage(this.dicomOverlay, this.finalNoRadioTransform, this);
            }
        }
        if (this.pluginOverlays.size() > 0) {
            for (BufferedImage pluginOverlay : this.pluginOverlays) {
                if (useRadiological) {
                    this.updateRadiologicalImage(pluginOverlay);
                    g2d.drawImage(this.radiologicalFiltered, this.finalTransform2, this);
                    continue;
                }
                g2d.drawImage(pluginOverlay, this.finalTransform, this);
            }
        }
        this.drawShapes(g2d, this.currentSlice);
        if (this.isCapturingVideo()) {
            ScreenSlice screenSlice = this;
            synchronized (screenSlice) {
                this.currentVideoFrame = this.getVideoImage();
            }
        }
    }

    public void removeSliceListener(SliceListener sl) {
        this.sliceListeners.remove(sl);
    }

    public void setAngleShape(LOIShape angleShape) {
        this.angleShape = angleShape;
    }

    public void setBoundingBox(int x, int y, int w, int h) {
        this.boundingBox.setRect(x, y, w, h);
        this.setBounds((int)(this.boundingBox.getX() + 0.5), (int)(this.boundingBox.getY() + 0.5), (int)(this.boundingBox.getWidth() + 0.5), (int)(this.boundingBox.getHeight() + 0.5));
        this.calculateScreenTouchRatio();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.boundingBox != null) {
            super.setBounds((int)(this.boundingBox.getX() + 0.5), (int)(this.boundingBox.getY() + 0.5), (int)(this.boundingBox.getWidth() + 0.5), (int)(this.boundingBox.getHeight() + 0.5));
        } else {
            super.setBounds(x, y, w, h);
        }
    }

    public void setCapturingVideo(boolean capturingVideo) {
        this.capturingVideo = capturingVideo;
    }

    public boolean setCrosshairPosition(int aX, int aY) {
        return this.setCrosshairPosition(aX, aY, false, false, false);
    }

    public boolean setCrosshairPosition(int aX, int aY, boolean repaint, boolean force, boolean updateTransform) {
        if (aX == this.currentX && aY == this.currentY && !force) {
            return false;
        }
        if (aX < this.xDim && aX >= 0 && aY < this.yDim && aY >= 0) {
            this.currentX = aX;
            this.currentY = aY;
            this.horizontalLeft.setLocation(0.0, (double)aY + 0.5);
            this.horizontalRight.setLocation(this.xDim, (double)aY + 0.5);
            this.verticalTop.setLocation((double)aX + 0.5, 0.0);
            this.verticalBottom.setLocation((double)aX + 0.5, this.yDim);
            if (updateTransform) {
                this.updateTransforms();
                this.updateROIShape();
            }
            if (repaint) {
                this.repaint();
            }
        }
        return true;
    }

    public boolean setCurrentSlice(int slice) {
        if (slice < this.numSlices && slice >= 0) {
            if (this.currentSlice != slice) {
                this.currentSlice = slice;
                this.needsImageUpdate();
                this.updateScreenSlice();
                this.updateROIShape();
            }
            this.repaint();
            return true;
        }
        return false;
    }

    public void setHistogramAlpha(int val) {
        this.histogramAlpha = val << 24;
    }

    public void setHistogramState(boolean bool) {
        this.useHistogram = bool;
        if (this.useHistogram && this.histogramOverlay == null) {
            this.initializeHistogram();
        }
    }

    public void setInitData(Volume aVolume, ScreenVolume[] allOverlays, int dimX, int dimY, int aLongestDim, int aNumSlices, double sizeX, double sizeY, double aSliceSize, double aLongestDimSize, int aSliceDirection) {
        this.volume = aVolume;
        this.overlays = allOverlays;
        this.crosssectionMarker = new Ellipse2D.Double();
        this.centroidMarker = new Ellipse2D.Double();
        this.centroidMarkerOutter = new Ellipse2D.Double();
        this.horizontalLeft = new Point2D.Double();
        this.horizontalRight = new Point2D.Double();
        this.verticalTop = new Point2D.Double();
        this.verticalBottom = new Point2D.Double();
        this.tempTransformedPoint = new Point2D.Double();
        this.current = new Point();
        this.centroidImage = new Point2D.Double();
        this.centroidTransformed = new Point2D.Double();
        this.centroidCoor = new Coordinate();
        this.centroidCoorType = new Coordinate();
        this.adjustingShapeGrabPoint = new Point();
        this.handle = new Ellipse2D.Double();
        this.allSelectedBoundsPath = new GeneralPath();
        this.adjustingRealShapeStartPoint = new Point();
        this.selectionShapeStartPoint = new Point();
        this.checkBoundsPoint = new Point();
        this.adjustingLOIShapeGrabPoint = new Point();
        this.crosssectionPoint = new Point2D.Double();
        this.updateROIMaxColors(8);
        this.polyLineLast = new Point();
        this.tempPOIPoint = new Point();
        this.xDim = dimX;
        this.yDim = dimY;
        this.longestDim = aLongestDim;
        this.numSlices = aNumSlices;
        this.xSize = sizeX;
        this.ySize = sizeY;
        this.sliceSize = aSliceSize;
        this.longestDimSize = aLongestDimSize;
        this.currentSlice = aNumSlices / 2;
        this.sliceDirection = aSliceDirection;
        this.showCrosshairs = true;
        this.screenSlice = new BufferedImage(dimX, dimY, 2);
        this.screenSliceFiltered = new BufferedImage(dimX, dimY, 2);
        this.screenSliceFilteredRetina = new BufferedImage(dimX * 2, dimY * 2, 2);
        this.screenTransform = new AffineTransform();
        this.screenTransformNoScale = new AffineTransform();
        this.radiologicalTransform = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, this.xDim, 0.0f);
        this.finalTransform = new AffineTransform();
        this.finalNoRadioTransform = new AffineTransform();
        this.finalTransformNoScale = new AffineTransform();
        this.finalTransformRetina = new AffineTransform();
        this.scaleTransform = new AffineTransform();
        this.scaleFinalTransform = new AffineTransform();
        this.scaleFileNoRadioTransform = new AffineTransform();
        this.scaleFinalTransformRetina = new AffineTransform();
        this.scaleFinalNoRadioTransformRetina = new AffineTransform();
        this.shapeTransform = new AffineTransform();
        this.zoomTransform = new AffineTransform();
        this.zoomTransformImage = new AffineTransform();
        this.polyLineScreenTransform = new AffineTransform();
        this.boundingBox = new Rectangle(this.longestDim, this.longestDim);
        this.rgbData = ((DataBufferInt)this.screenSlice.getRaster().getDataBuffer()).getData();
        this.overlayScreenSlice = new BufferedImage[8];
        this.overlayScreenSliceFiltered = new BufferedImage[8];
        this.overlayScreenSliceFilteredScaled = new BufferedImage[8];
        this.hasOverlay = new boolean[8];
        this.overlayRGBData = new int[8][];
        this.overlayMixer = new BufferedImage(this.xDim, this.yDim, 2);
        this.overlayMixerData = ((DataBufferInt)this.overlayMixer.getRaster().getDataBuffer()).getData();
        this.orientL = new Point();
        this.orientR = new Point();
        this.orientA = new Point();
        this.orientP = new Point();
        this.calcLabel = new Point();
    }

    public void setLOIManager(LOIManager aManager, LOIManager aManagerA, LOIManager aManagerB) {
        this.managerLOI = aManager;
    }

    public void setLOISpecialManager(LOISpecialManager aManager) {
        this.managerSpecialLOI = aManager;
    }

    public void setMainImageState(boolean mainImage, boolean lowerLeft, boolean lowerRight) {
        this.isMainImage = mainImage;
    }

    public void setPOIManager(POIManager aManager, POISpecialManager aSpecialManager) {
        this.managerPOI = aManager;
        this.managerSpecialPOI = aSpecialManager;
    }

    public void setPreviewPosition(int startX, int endX, int startY, int endY, double sliceSize) {
        this.previewStartX = startX;
        this.previewEndX = endX;
        this.previewStartY = startY;
        this.previewEndY = endY;
        this.previewOutOfBoundsMaxX = endX > this.xDim;
        this.previewOutOfBoundsMaxY = endY > this.yDim;
        this.previewOutOfBoundsMinX = startX < 0;
        this.previewOutOfBoundsMinY = startY < 0;
        this.previewSliceSize = sliceSize;
    }

    public void setROIState(boolean has, boolean hasCurrent) {
        this.roiExists = has;
        this.roiCurrentExists = hasCurrent;
    }

    public void setRulerShape(LOIShape rulerShape) {
        this.rulerShape = rulerShape;
    }

    public void setShowCrosshairs(boolean show) {
        this.showCrosshairs = show;
        this.repaint();
    }

    public void setShowCrosssectionMarker(boolean bool) {
        this.showCrosssectionMarker = bool;
    }

    public void setShowHistogram(boolean bool) {
        this.showHistogram = bool;
    }

    public void setShowLineAngle(boolean bool) {
        this.showLineAngle = bool;
    }

    public void setShowLineLength(boolean bool) {
        this.showLineLength = bool;
    }

    public void setShowLinesGuide(boolean bool) {
    }

    public void setShowOrientation(boolean bool) {
        this.showOrientation = bool;
    }

    public void setShowPreview(boolean bool) {
        this.usePreview = bool;
        if (bool && this.histogramOverlay == null) {
            this.initializeHistogram();
        } else if (!bool && this.histogramOverlay != null) {
            this.clearHistogram();
        }
    }

    public void setTextureImage(BufferedImage bi) {
        this.shrinkWrapper = new int[this.xDim * this.yDim];
        this.textureImage = bi;
        this.textureXdim = bi.getWidth();
        this.textureData = ((DataBufferInt)this.textureImage.getRaster().getDataBuffer()).getData();
        this.updateScreenSlice();
    }

    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        if (this.polyLineLast != null) {
            try {
                AffineTransform temp = this.screenTransform.createInverse();
                temp.transform(this.polyLineLast, this.tempTransformedPoint);
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (this.isUpdatingPolyLine) {
            this.updatePolyLinePath(this.screenTransform.getScaleX(), m00, this.screenTransform.getScaleY(), m11);
        }
        this.screenTransform.setTransform(m00, m10, m01, m11, m02, m12);
        this.screenTransformNoScale.setTransform(1.0, 0.0, 0.0, 1.0, m02, m12);
        this.scaleTransform.setToScale(m00, m11);
        this.updateLabelPositions();
        this.updateTransforms();
        if (this.polyLineLast != null) {
            this.screenTransform.transform(this.tempTransformedPoint, this.polyLineLast);
        }
        this.clearScaledImages();
        this.needsImageUpdate();
        this.updateScreenSlice();
        this.repaint();
    }

    @Override
    public synchronized void startVideoCapture(int fps, VideoCaptureListener videoCaptureListener) {
        this.videoCaptureListener = videoCaptureListener;
        this.videoCaptureFps = fps;
        this.videoFrames = new Vector();
        this.setCapturingVideo(true);
        this.repaint();
        this.startVideoCaptureTimer();
    }

    public void updateCrosssectionMarker(Point2D aPoint, boolean isMM, int direction) {
        this.crosssectionDirection = direction;
        if (isMM) {
            this.crosssectionPoint.setLocation(aPoint.getX() / this.xSize, aPoint.getY() / this.ySize);
        } else {
            this.crosssectionPoint.setLocation(aPoint.getX(), aPoint.getY());
        }
    }

    public void updateCursor() {
        if (this.viewer == null) {
            return;
        }
        if (!this.isMainImage) {
            if (this.currentCursorType != 2) {
                this.setCursor(CUSTOM_CURSOR);
                this.currentCursorType = 2;
            }
        } else {
            boolean selectedBoundsContain;
            int proximalHandle = this.findProximalHandle();
            boolean nearHandle = proximalHandle != 0;
            boolean proximalMeasurementHandle = this.findProximalMeasurementLOIHandle() != null;
            boolean bl = selectedBoundsContain = this.allSelectedBoundsPath.contains(this.currentCursorX, this.currentCursorY) || this.findProximalLOIHandle(true, false) != null || this.findProximalPOI(true) != null || this.findProximalSpecialPOI() != null;
            if (!this.containsMouse || !this.mango.isCurrentActiveViewer(this.viewer)) {
                if (this.currentCursorType != 1) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    this.currentCursorType = 1;
                }
            } else if (this.viewer.isROIMagicWandMode()) {
                if (this.currentCursorType != 1024) {
                    this.setCursor(CUSTOM_CURSOR_MAGIC_WAND);
                    this.currentCursorType = 1024;
                }
            } else if (this.viewer.isROIToolMode()) {
                if (this.currentCursorType != 0) {
                    this.setCursor(CUSTOM_CURSOR_EMPTY);
                    this.currentCursorType = 0;
                }
            } else if (this.isUpdatingPolyLine && (this.viewer.isROIPolyLineMode() || this.viewer.isLOIMode())) {
                if (this.currentCursorType != 0) {
                    this.setCursor(CUSTOM_CURSOR_EMPTY);
                    this.currentCursorType = 0;
                }
            } else if (this.isAdjustingRealShape && this.viewer.isROIRealShapeMode()) {
                if (this.currentCursorType != 0) {
                    this.setCursor(CUSTOM_CURSOR_EMPTY);
                    this.currentCursorType = 0;
                }
            } else if (this.isDragging) {
                if (this.draggingCursorType == 96) {
                    this.setCursor(CUSTOM_CURSOR_RESIZE_VERTICAL);
                } else if (this.draggingCursorType == 160) {
                    this.setCursor(CUSTOM_CURSOR_RESIZE_HORIZONTAL);
                } else if (this.draggingCursorType == 288) {
                    this.setCursor(CUSTOM_CURSOR_RESIZE_NESW);
                } else if (this.draggingCursorType == 544) {
                    this.setCursor(CUSTOM_CURSOR_RESIZE_NWSE);
                } else if (this.draggingCursorType == 2) {
                    this.setCursor(CUSTOM_CURSOR);
                } else if (this.draggingCursorType == 20) {
                    this.setCursor(CUSTOM_CURSOR_HAND_CLOSED);
                }
                this.currentCursorType = this.draggingCursorType;
            } else if (!this.viewer.isROIMode() && nearHandle) {
                if ((this.currentCursorType & 0x20) == 0) {
                    if (proximalHandle == 1) {
                        this.setCursor(CUSTOM_CURSOR_RESIZE_VERTICAL);
                        this.currentCursorType = 96;
                    } else if (proximalHandle == 3) {
                        this.setCursor(CUSTOM_CURSOR_RESIZE_NESW);
                        this.currentCursorType = 288;
                    } else if (proximalHandle == 2) {
                        this.setCursor(CUSTOM_CURSOR_RESIZE_HORIZONTAL);
                        this.currentCursorType = 160;
                    } else if (proximalHandle == 6) {
                        this.setCursor(CUSTOM_CURSOR_RESIZE_NWSE);
                        this.currentCursorType = 544;
                    } else if (proximalHandle == 4) {
                        this.setCursor(CUSTOM_CURSOR_RESIZE_VERTICAL);
                        this.currentCursorType = 96;
                    } else if (proximalHandle == 12) {
                        this.setCursor(CUSTOM_CURSOR_RESIZE_NESW);
                        this.currentCursorType = 288;
                    } else if (proximalHandle == 8) {
                        this.setCursor(CUSTOM_CURSOR_RESIZE_HORIZONTAL);
                        this.currentCursorType = 160;
                    } else if (proximalHandle == 9) {
                        this.setCursor(CUSTOM_CURSOR_RESIZE_NWSE);
                        this.currentCursorType = 544;
                    }
                }
            } else if (!this.viewer.isROIMode() && (selectedBoundsContain || proximalMeasurementHandle)) {
                if (this.isGrabMode || proximalMeasurementHandle && this.isPressed) {
                    if (this.currentCursorType != 20) {
                        this.setCursor(CUSTOM_CURSOR_HAND_CLOSED);
                        this.currentCursorType = 20;
                    }
                } else if (this.currentCursorType != 12) {
                    this.setCursor(CUSTOM_CURSOR_HAND_OPEN);
                    this.currentCursorType = 12;
                }
            } else if (this.currentCursorType != 2) {
                this.setCursor(CUSTOM_CURSOR);
                this.currentCursorType = 2;
            }
        }
    }

    public void updateFinalTransform() {
        this.finalTransform.setTransform(this.screenTransform);
        this.finalNoRadioTransform.setTransform(this.screenTransform);
        this.finalTransform2.setTransform(this.screenTransform);
        this.finalTransformNoScale.setTransform(this.screenTransformNoScale);
        this.scaleFinalTransform.setTransform(this.scaleTransform);
        this.scaleFileNoRadioTransform.setTransform(this.scaleTransform);
        if (this.mango.isRadiologicalMode() && this.isRadiologicalSensitive()) {
            this.radiologicalTransform.setTransform(-1.0, 0.0, 0.0, 1.0, this.xDim, 0.0);
            this.finalTransform.concatenate(this.radiologicalTransform);
            this.radiologicalTransform.setTransform(-1.0, 0.0, 0.0, 1.0, this.viewer.isRetinaDisplay() && this.useInterpolation() ? (double)(this.xDim * 2) : (double)this.xDim, 0.0);
            this.scaleFinalTransform.concatenate(this.radiologicalTransform);
        }
        this.finalTransform.concatenate(this.zoomTransform);
        this.finalNoRadioTransform.concatenate(this.zoomTransform);
        this.finalTransform2.concatenate(this.zoomTransform2);
        this.finalTransformNoScale.concatenate(this.zoomTransformImage);
        this.scaleFinalTransformRetina.setTransform(this.scaleFinalTransform);
        this.scaleFinalTransformRetina.concatenate(RETINA_XFORM);
        this.scaleFinalNoRadioTransformRetina.setTransform(this.scaleFileNoRadioTransform);
        this.scaleFinalNoRadioTransformRetina.concatenate(RETINA_XFORM);
        this.finalTransformRetina.setTransform(this.finalTransformNoScale);
        this.finalTransformRetina.concatenate(RETINA_INVERSE_XFORM);
        if (this.viewer.isRetinaDisplay()) {
            this.finalTransformImage = this.finalTransformRetina;
            this.scaleFinalTransformImage = this.scaleFinalTransformRetina;
            this.scaleFinalNoRadioTransformImage = this.scaleFinalNoRadioTransformRetina;
        } else {
            this.finalTransformImage = this.finalTransformNoScale;
            this.scaleFinalTransformImage = this.scaleFinalTransform;
            this.scaleFinalNoRadioTransformImage = this.scaleFileNoRadioTransform;
        }
    }

    public void updateHistogram() {
        HistogramPanel hist = this.viewer.getHistogram();
        this.histogramMins = hist.getBinMins();
        this.histogramMaxs = hist.getBinMaxs();
        this.histogramFirsts = hist.getSelectedFirsts();
        this.histogramSeconds = hist.getSelectedSeconds();
    }

    public void updateLabelPositions() {
        this.orientL.setLocation(Math.round(((double)this.xDim * this.xSize - (double)this.longestDim * this.longestDimSize) / 2.0 / this.xSize), (double)(this.yDim / 2 + 1));
        this.orientR.setLocation(Math.round((double)this.xDim + ((double)this.longestDim * this.longestDimSize - (double)this.xDim * this.xSize) / 2.0 / this.xSize), (double)(this.yDim / 2 + 1));
        this.orientA.setLocation((double)(this.xDim / 2 + 1), Math.round(((double)this.yDim * this.ySize - (double)this.longestDim * this.longestDimSize) / 2.0 / this.ySize));
        this.orientP.setLocation((double)(this.xDim / 2 + 1), Math.round((double)this.yDim + ((double)this.longestDim * this.longestDimSize - (double)this.yDim * this.ySize) / 2.0 / this.ySize));
        this.screenTransform.transform(this.orientL, this.orientL);
        this.screenTransform.transform(this.orientR, this.orientR);
        this.screenTransform.transform(this.orientA, this.orientA);
        this.screenTransform.transform(this.orientP, this.orientP);
        this.orientL.setLocation(this.orientL.x + 8, this.orientL.y + 4);
        this.orientR.setLocation(this.orientR.x - 16, this.orientR.y + 4);
        this.orientA.setLocation(this.orientA.x - 4, this.orientA.y + 16);
        this.orientP.setLocation(this.orientP.x - 4, this.orientP.y - 8);
        if (this.mango.isRadiologicalMode() && this.isRadiologicalSensitive()) {
            Point temp = this.orientL;
            this.orientL = this.orientR;
            this.orientR = temp;
        }
    }

    public void updateOverlays() {
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] != null) {
                if (this.overlayScreenSlice[ctr] == null) {
                    this.overlayScreenSlice[ctr] = new BufferedImage(this.xDim, this.yDim, 2);
                    this.overlayScreenSliceFiltered[ctr] = new BufferedImage(this.xDim, this.yDim, 2);
                    this.overlayRGBData[ctr] = ((DataBufferInt)this.overlayScreenSlice[ctr].getRaster().getDataBuffer()).getData();
                }
                this.hasOverlay[ctr] = true;
                continue;
            }
            this.hasOverlay[ctr] = false;
        }
    }

    public void updateROIMaxColors(int maxColors) {
        if (maxColors != this.maxColors) {
            this.maxColors = maxColors;
            this.selectedHasBounds = new boolean[maxColors];
            this.northHandle = new Point[maxColors];
            this.northEastHandle = new Point[maxColors];
            this.eastHandle = new Point[maxColors];
            this.southEastHandle = new Point[maxColors];
            this.southHandle = new Point[maxColors];
            this.southWestHandle = new Point[maxColors];
            this.westHandle = new Point[maxColors];
            this.northWestHandle = new Point[maxColors];
            this.bounds = new Rectangle[maxColors];
            this.handlesPath = new GeneralPath[maxColors];
            for (int ctr = 0; ctr < maxColors; ++ctr) {
                this.northHandle[ctr] = new Point();
                this.northEastHandle[ctr] = new Point();
                this.eastHandle[ctr] = new Point();
                this.southEastHandle[ctr] = new Point();
                this.southHandle[ctr] = new Point();
                this.southWestHandle[ctr] = new Point();
                this.westHandle[ctr] = new Point();
                this.northWestHandle[ctr] = new Point();
                this.bounds[ctr] = new Rectangle();
                this.handlesPath[ctr] = new GeneralPath();
            }
        }
    }

    public void updateROIShape() {
        this.updateROIShape(this.currentSlice, null);
    }

    public void updateScreenSlice() {
        this.updateScreenSlice(this.currentSlice, true);
    }

    public void updateScreenSlice(boolean updateTexture) {
        this.updateScreenSlice(this.currentSlice, null, updateTexture);
    }

    public void updateScreenSlice(int updateSlice, ImageTransform xform, boolean updateTexture) {
        int num;
        boolean drawDicomOverlayMask;
        if (this.viewer == null) {
            return;
        }
        if (this.initializedSliceListeners) {
            this.notifyAllSliceListeners();
        }
        double surfaceThreshold = this.viewer.getSurfaceThreshold();
        double screenImageRatio = this.viewer.getScreenRatio();
        double screenImageBlack = this.viewer.getScreenSliceMin();
        double screenImageWhite = this.viewer.getScreenSliceMax();
        boolean hasLogicalOverlays = false;
        boolean usingTransform = this.viewer.getScreenVolume().isUsingTransform();
        Coordinate origin = this.viewer.getOrigin();
        Vector<Integer> usedROIIndicesHistogram = this.viewer.getHistogram().getUsedIndices(true);
        boolean doSurfaceShrinkWrap = this.viewer.doSurfaceCutPlaneShrinkWrap();
        boolean drawDicomOverlay = this.viewer.isShowingDicomOverlay();
        boolean hasCurrentROI = this.viewer.getROIManager().hasROI(this.viewer.getRoiColor());
        boolean hasOverlays = this.viewer.hasOverlays();
        boolean isHistogramOverlaySelected = this.viewer.getHistogramOverlayCode() > 0;
        boolean isHistogramUsingROI = this.viewer.isHistogramUsingROI();
        boolean isRGB = this.viewer.isRGB();
        boolean isARGB = this.viewer.isARGB();
        boolean isShowingStats = this.viewer.isShowingROIStats();
        boolean isWorldMode = this.toolBox.isWorldMode();
        int histogramOverlayIndex = this.viewer.getHistogramOverlayCode() - 1;
        int tempRGB = 0;
        boolean hasROIs = this.viewer.getROIManager().hasROI();
        boolean hasSelectedROIs = this.viewer.getROIManager().hasSelected();
        boolean isNegative = this.viewer.getBaseScreenVolume().isNegative();
        LogicalAnalysisTool logicalManager = this.viewer.getLogicalManager();
        double tempTexture = 0.0;
        double temp = 0.0;
        int textureOffsetY = 0;
        int textureOffset = 0;
        this.centroidCount = this.centroidSumOfSquares = (double)0;
        this.calcSum = this.centroidSumOfSquares;
        this.centroidSumABS = this.centroidSumOfSquares;
        this.centroidYSum = this.centroidSumOfSquares;
        this.centroidXSum = this.centroidSumOfSquares;
        short[] dicomOverlayMask = null;
        if (drawDicomOverlay && this.viewer.getNativeSliceDirection() == this.sliceDirection) {
            int timepoint = this.viewer.getCurrentTimepoint();
            int slice = this.viewer.getCurrentSliceNativeOrder();
            dicomOverlayMask = this.volume.getSliceAnnotation(slice, timepoint);
        }
        if ((drawDicomOverlayMask = CollectionUtilities.isNotEmpty(dicomOverlayMask)) && this.dicomOverlay == null) {
            this.initializeDicomOverlay();
        }
        for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
            int offsetY = this.xDim * ctrY;
            textureOffsetY = this.textureXdim * ctrY;
            for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                int offset = offsetY + ctrX;
                textureOffset = textureOffsetY + ctrX;
                if (isRGB) {
                    tempRGB = this.sliceDirection == 0 ? (int)this.volume.getNativeIntegerValueAtIndex(ctrX, ctrY, updateSlice, this.volume.getCurrentTimepoint()) : (this.sliceDirection == 1 ? (int)this.volume.getNativeIntegerValueAtIndex(ctrX, updateSlice, ctrY, this.volume.getCurrentTimepoint()) : (int)this.volume.getNativeIntegerValueAtIndex(updateSlice, ctrX, ctrY, this.volume.getCurrentTimepoint()));
                } else if (isWorldMode) {
                    if (this.sliceDirection == 0) {
                        temp = this.volume.getVoxelValueAtCoordinate((double)(ctrX - origin.xInt) * this.xSize, (double)(origin.yInt - ctrY) * this.ySize, (double)(origin.zInt - updateSlice) * this.sliceSize, usingTransform);
                    } else if (this.sliceDirection == 1) {
                        temp = this.volume.getVoxelValueAtCoordinate((double)(ctrX - origin.xInt) * this.xSize, (double)(origin.yInt - updateSlice) * this.sliceSize, (double)(origin.zInt - ctrY) * this.ySize, usingTransform);
                    } else if (this.sliceDirection == 2) {
                        temp = this.volume.getVoxelValueAtCoordinate((double)(updateSlice - origin.xInt) * this.sliceSize, (double)(origin.yInt - ctrX) * this.xSize, (double)(origin.zInt - ctrY) * this.ySize, usingTransform);
                    }
                } else {
                    temp = xform != null ? (this.sliceDirection == 0 ? this.volume.getVoxelValueAtIndex(ctrX, ctrY, updateSlice, this.volume.getCurrentTimepoint(), xform) : (this.sliceDirection == 1 ? this.volume.getVoxelValueAtIndex(ctrX, updateSlice, ctrY, this.volume.getCurrentTimepoint(), xform) : this.volume.getVoxelValueAtIndex(updateSlice, ctrX, ctrY, this.volume.getCurrentTimepoint(), xform))) : (this.sliceDirection == 0 ? this.volume.getVoxelValueAtIndex(ctrX, ctrY, updateSlice, usingTransform) : (this.sliceDirection == 1 ? this.volume.getVoxelValueAtIndex(ctrX, updateSlice, ctrY, usingTransform) : this.volume.getVoxelValueAtIndex(updateSlice, ctrX, ctrY, usingTransform)));
                }
                boolean isInsideMask = true;
                if (isShowingStats) {
                    if (hasCurrentROI) {
                        isInsideMask = this.sliceDirection == 0 ? this.viewer.getROIManager().isInside(ctrX, ctrY, updateSlice, this.viewer.getRoiColor()) : (this.sliceDirection == 1 ? this.viewer.getROIManager().isInside(ctrX, updateSlice, ctrY, this.viewer.getRoiColor()) : this.viewer.getROIManager().isInside(updateSlice, ctrX, ctrY, this.viewer.getRoiColor()));
                    } else {
                        boolean bl = isInsideMask = !hasCurrentROI;
                    }
                    if (isInsideMask) {
                        double tempABS = Math.abs(temp);
                        this.centroidXSum += tempABS * (double)ctrX;
                        this.centroidYSum += tempABS * (double)ctrY;
                        this.calcSum += temp;
                        this.centroidSumABS += tempABS;
                        this.centroidCount += 1.0;
                        this.centroidSumOfSquares += temp * temp;
                    }
                }
                if (isWorldMode && !usingTransform) {
                    tempTexture = xform != null ? (this.sliceDirection == 0 ? this.volume.getVoxelValueAtIndex(ctrX, ctrY, updateSlice, this.volume.getCurrentTimepoint(), xform) : (this.sliceDirection == 1 ? this.volume.getVoxelValueAtIndex(ctrX, updateSlice, ctrY, this.volume.getCurrentTimepoint(), xform) : this.volume.getVoxelValueAtIndex(updateSlice, ctrX, ctrY, this.volume.getCurrentTimepoint(), xform))) : (this.sliceDirection == 0 ? this.volume.getVoxelValueAtIndex(ctrX, ctrY, updateSlice, false) : (this.sliceDirection == 1 ? this.volume.getVoxelValueAtIndex(ctrX, updateSlice, ctrY, false) : this.volume.getVoxelValueAtIndex(updateSlice, ctrX, ctrY, false)));
                }
                if (isARGB) {
                    this.rgbData[offset] = tempRGB;
                } else if (isRGB) {
                    this.rgbData[offset] = tempRGB | 0xFF000000;
                } else if (!isNegative && temp <= screenImageBlack || isNegative && temp >= screenImageBlack) {
                    this.rgbData[offset] = -16777216;
                } else if (!isNegative && temp > screenImageWhite || isNegative && temp < screenImageWhite) {
                    this.rgbData[offset] = -1;
                } else {
                    num = (int)((temp - screenImageBlack) * screenImageRatio + 0.5);
                    this.rgbData[offset] = num | num << 8 | num << 16 | 0xFF000000;
                }
                if (updateTexture) {
                    if (isWorldMode && !usingTransform) {
                        if (this.textureData != null) {
                            if (!isNegative && (doSurfaceShrinkWrap && tempTexture <= surfaceThreshold || tempTexture <= screenImageBlack) || isNegative && (tempTexture >= surfaceThreshold || tempTexture >= screenImageBlack)) {
                                this.textureData[textureOffset] = -16777216;
                            } else if (!isNegative && tempTexture > screenImageWhite || isNegative && tempTexture < screenImageWhite) {
                                this.textureData[textureOffset] = -1;
                            } else {
                                num = (int)((tempTexture - screenImageBlack) * screenImageRatio + 0.5);
                                this.textureData[textureOffset] = num | num << 8 | num << 16 | 0xFF000000;
                            }
                        }
                    } else if (this.textureData != null) {
                        if (!isNegative && (doSurfaceShrinkWrap && temp <= surfaceThreshold || temp <= screenImageBlack) || isNegative && (temp >= surfaceThreshold || temp >= screenImageBlack)) {
                            this.textureData[textureOffset] = -16777216;
                        } else if (!isNegative && temp > screenImageWhite || isNegative && temp < screenImageWhite) {
                            this.textureData[textureOffset] = -1;
                        } else {
                            num = (int)((temp - screenImageBlack) * screenImageRatio + 0.5);
                            this.textureData[textureOffset] = num | num << 8 | num << 16 | 0xFF000000;
                        }
                    }
                }
                if (drawDicomOverlayMask) {
                    this.dicomOverlayData[offset] = dicomOverlayMask[offset] != 0 ? ROIColor.getColor(BitUtilities.findHighestOneBitIndex((long)dicomOverlayMask[offset])).getRGB() & 0xFFFFFF | 0xFF000000 : 0;
                } else if (this.dicomOverlayData != null) {
                    this.dicomOverlayData[offset] = 0;
                }
                if (this.useHistogram && this.showHistogram && !isHistogramOverlaySelected && !this.usePreview) {
                    boolean insideROI;
                    boolean added = false;
                    boolean bl = insideROI = !isHistogramUsingROI || !hasROIs;
                    if (!insideROI) {
                        insideROI = hasSelectedROIs ? (this.sliceDirection == 0 ? this.viewer.getROIManager().isInsideSelected(ctrX, ctrY, updateSlice) : (this.sliceDirection == 1 ? this.viewer.getROIManager().isInsideSelected(ctrX, updateSlice, ctrY) : this.viewer.getROIManager().isInsideSelected(updateSlice, ctrX, ctrY))) : (this.sliceDirection == 0 ? this.viewer.getROIManager().isInside(ctrX, ctrY, updateSlice) : (this.sliceDirection == 1 ? this.viewer.getROIManager().isInside(ctrX, updateSlice, ctrY) : this.viewer.getROIManager().isInside(updateSlice, ctrX, ctrY)));
                    }
                    if (insideROI) {
                        for (int ctrH : usedROIIndicesHistogram) {
                            if (this.histogramFirsts[ctrH] != -1 && this.histogramSeconds[ctrH] != -1) {
                                if (this.histogramSeconds[ctrH] > this.histogramFirsts[ctrH]) {
                                    if (temp >= this.histogramMins[this.histogramFirsts[ctrH]] && temp < this.histogramMaxs[this.histogramSeconds[ctrH]]) {
                                        added = true;
                                        this.histogramData[offset] = ROIColor.getColor(ctrH).getRGB() & 0xFFFFFF | this.histogramAlpha;
                                    }
                                } else if (temp >= this.histogramMins[this.histogramSeconds[ctrH]] && temp < this.histogramMaxs[this.histogramFirsts[ctrH]]) {
                                    added = true;
                                    this.histogramData[offset] = ROIColor.getColor(ctrH).getRGB() & 0xFFFFFF | this.histogramAlpha;
                                }
                            } else if (this.histogramFirsts[ctrH] != -1 && temp >= this.histogramMins[this.histogramFirsts[ctrH]] && temp < this.histogramMaxs[this.histogramFirsts[ctrH]]) {
                                added = true;
                                this.histogramData[offset] = ROIColor.getColor(ctrH).getRGB() & 0xFFFFFF | this.histogramAlpha;
                            }
                            if (!added) continue;
                            break;
                        }
                    }
                    if (!added) {
                        this.histogramData[offset] = 0;
                    }
                }
                if (this.usePreview) {
                    if (ctrX >= this.previewStartX && ctrX < this.previewEndX && ctrY >= this.previewStartY && ctrY < this.previewEndY) {
                        if (this.sliceDirection == 0) {
                            int tempVal = (int)((double)(ctrX - this.previewStartX) * this.xSize / this.previewSliceSize) % 3;
                            this.histogramData[offset] = this.previewOutOfBoundsMaxX && ctrX >= this.xDim - 3 ? -1 : (this.previewOutOfBoundsMinX && ctrX < 3 ? -1 : (tempVal == 0 ? -2130771968 : (tempVal == 1 ? -2147418368 : -2147483393)));
                        } else if (this.sliceDirection == 1) {
                            int tempVal = (int)((double)(ctrY - this.previewStartY) * this.ySize / this.previewSliceSize) % 3;
                            this.histogramData[offset] = this.previewOutOfBoundsMaxY && ctrY >= this.yDim - 3 ? -1 : (this.previewOutOfBoundsMinY && ctrY < 3 ? -1 : (tempVal == 0 ? -2130771968 : (tempVal == 1 ? -2147418368 : -2147483393)));
                        } else if (this.sliceDirection == 2) {
                            int tempVal = (int)((double)(ctrX - this.previewStartX) * this.xSize / this.previewSliceSize) % 3;
                            this.histogramData[offset] = this.previewOutOfBoundsMaxX && ctrX >= this.xDim - 3 ? -1 : (this.previewOutOfBoundsMinX && ctrX < 3 ? -1 : (tempVal == 0 ? -2130771968 : (tempVal == 1 ? -2147418368 : -2147483393)));
                        }
                    } else {
                        this.histogramData[offset] = 0;
                    }
                }
                this.overlayMixerData[offset] = 0;
            }
        }
        if (hasOverlays) {
            boolean allLogicalsHidden = logicalManager != null && logicalManager.allLogicalHidden();
            for (int ctr = 0; ctr < 8; ++ctr) {
                boolean isLogical;
                boolean bl = isLogical = this.hasOverlay[ctr] && this.overlays[ctr].isLogical() && !allLogicalsHidden;
                if (!this.hasOverlay[ctr] || this.overlays[ctr].isHidden() && !isLogical) continue;
                double overlayScreenMin = this.overlays[ctr].getScreenMin();
                double overlayScreenMax = this.overlays[ctr].getScreenMax();
                double overlayScreenRatio = this.overlays[ctr].getScreenRatio();
                hasLogicalOverlays |= isLogical;
                int alpha = this.overlays[ctr].getAlphaInteger();
                isNegative = this.overlays[ctr].isNegative();
                usingTransform = this.overlays[ctr].isUsingTransform();
                Coordinate tempCoor = new Coordinate();
                for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
                    int offsetY = this.xDim * ctrY;
                    for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        boolean insideROI;
                        int offset = offsetY + ctrX;
                        if (isWorldMode) {
                            if (xform != null) {
                                if (this.sliceDirection == 0) {
                                    tempCoor.setValues((double)ctrX, (double)ctrY, (double)updateSlice);
                                    tempCoor = xform.transformNative(tempCoor);
                                    temp = this.overlays[ctr].volume.getVoxelValueAtCoordinate((tempCoor.xDbl - (double)origin.xInt) * this.xSize, ((double)origin.yInt - tempCoor.yDbl) * this.ySize, ((double)origin.zInt - tempCoor.zDbl) * this.sliceSize, 0);
                                } else if (this.sliceDirection == 1) {
                                    tempCoor.setValues((double)ctrX, (double)updateSlice, (double)ctrY);
                                    tempCoor = xform.transformNative(tempCoor);
                                    temp = this.overlays[ctr].volume.getVoxelValueAtCoordinate((tempCoor.xDbl - (double)origin.xInt) * this.xSize, ((double)origin.yInt - tempCoor.yDbl) * this.sliceSize, ((double)origin.zInt - tempCoor.zDbl) * this.ySize, 0);
                                } else if (this.sliceDirection == 2) {
                                    tempCoor.setValues((double)updateSlice, (double)ctrX, (double)ctrY);
                                    tempCoor = xform.transformNative(tempCoor);
                                    temp = this.overlays[ctr].volume.getVoxelValueAtCoordinate((tempCoor.xDbl - (double)origin.xInt) * this.sliceSize, ((double)origin.yInt - tempCoor.yDbl) * this.xSize, ((double)origin.zInt - tempCoor.zDbl) * this.ySize, 0);
                                }
                            } else if (this.sliceDirection == 0) {
                                temp = this.overlays[ctr].volume.getVoxelValueAtCoordinate((double)(ctrX - origin.xInt) * this.xSize, (double)(origin.yInt - ctrY) * this.ySize, (double)(origin.zInt - updateSlice) * this.sliceSize, usingTransform);
                            } else if (this.sliceDirection == 1) {
                                temp = this.overlays[ctr].volume.getVoxelValueAtCoordinate((double)(ctrX - origin.xInt) * this.xSize, (double)(origin.yInt - updateSlice) * this.sliceSize, (double)(origin.zInt - ctrY) * this.ySize, usingTransform);
                            } else if (this.sliceDirection == 2) {
                                temp = this.overlays[ctr].volume.getVoxelValueAtCoordinate((double)(updateSlice - origin.xInt) * this.sliceSize, (double)(origin.yInt - ctrX) * this.xSize, (double)(origin.zInt - ctrY) * this.ySize, usingTransform);
                            }
                        } else if (xform != null) {
                            if (this.sliceDirection == 0) {
                                tempCoor.setValues((double)ctrX, (double)ctrY, (double)updateSlice);
                                tempCoor = xform.transformNative(tempCoor);
                                temp = this.overlays[ctr].volume.getVoxelValueAtMM(tempCoor.xDbl * this.xSize, tempCoor.yDbl * this.ySize, tempCoor.zDbl * this.sliceSize, 0);
                            } else if (this.sliceDirection == 1) {
                                tempCoor.setValues((double)ctrX, (double)updateSlice, (double)ctrY);
                                tempCoor = xform.transformNative(tempCoor);
                                temp = this.overlays[ctr].volume.getVoxelValueAtMM(tempCoor.xDbl * this.xSize, tempCoor.yDbl * this.sliceSize, tempCoor.zDbl * this.ySize, 0);
                            } else if (this.sliceDirection == 2) {
                                tempCoor.setValues((double)updateSlice, (double)ctrX, (double)ctrY);
                                tempCoor = xform.transformNative(tempCoor);
                                temp = this.overlays[ctr].volume.getVoxelValueAtMM(tempCoor.xDbl * this.sliceSize, tempCoor.yDbl * this.xSize, tempCoor.zDbl * this.ySize, 0);
                            }
                        } else if (this.sliceDirection == 0) {
                            temp = this.overlays[ctr].volume.getVoxelValueAtMM((double)ctrX * this.xSize, (double)ctrY * this.ySize, (double)updateSlice * this.sliceSize, usingTransform, 0);
                        } else if (this.sliceDirection == 1) {
                            temp = this.overlays[ctr].volume.getVoxelValueAtMM((double)ctrX * this.xSize, (double)updateSlice * this.sliceSize, (double)ctrY * this.ySize, usingTransform, 0);
                        } else if (this.sliceDirection == 2) {
                            temp = this.overlays[ctr].volume.getVoxelValueAtMM((double)updateSlice * this.sliceSize, (double)ctrX * this.xSize, (double)ctrY * this.ySize, usingTransform, 0);
                        }
                        if (isLogical) {
                            if (this.viewer.passesClusterRejection(ctr, ctrX, ctrY, updateSlice, this.sliceDirection) && (!isNegative && temp > overlayScreenMin || isNegative && temp < overlayScreenMin) && alpha == 255) {
                                int n = offset;
                                this.overlayMixerData[n] = this.overlayMixerData[n] + this.overlays[ctr].getVolume().hashCode();
                            }
                        } else if (!isNegative && temp < overlayScreenMin || isNegative && temp > overlayScreenMin) {
                            this.overlayRGBData[ctr][offset] = 0;
                        } else if (this.viewer.passesClusterRejection(ctr, ctrX, ctrY, updateSlice, this.sliceDirection)) {
                            if (!isNegative && temp > overlayScreenMax || isNegative && temp < overlayScreenMax) {
                                this.overlayRGBData[ctr][offset] = -1;
                            } else {
                                num = (int)((temp - overlayScreenMin) * overlayScreenRatio + 0.5);
                                this.overlayRGBData[ctr][offset] = num | num << 8 | num << 16 | num << 24;
                            }
                        } else {
                            this.overlayRGBData[ctr][offset] = 0;
                        }
                        if (!this.useHistogram || !this.showHistogram || !isHistogramOverlaySelected || histogramOverlayIndex != ctr) continue;
                        boolean added = false;
                        boolean bl2 = insideROI = !isHistogramUsingROI || !hasROIs;
                        if (!insideROI) {
                            insideROI = hasSelectedROIs ? (this.sliceDirection == 0 ? this.viewer.getROIManager().isInsideSelected(ctrX, ctrY, updateSlice) : (this.sliceDirection == 1 ? this.viewer.getROIManager().isInsideSelected(ctrX, updateSlice, ctrY) : this.viewer.getROIManager().isInsideSelected(updateSlice, ctrX, ctrY))) : (this.sliceDirection == 0 ? this.viewer.getROIManager().isInside(ctrX, ctrY, updateSlice) : (this.sliceDirection == 1 ? this.viewer.getROIManager().isInside(ctrX, updateSlice, ctrY) : this.viewer.getROIManager().isInside(updateSlice, ctrX, ctrY)));
                        }
                        if (insideROI) {
                            for (int ctrH : usedROIIndicesHistogram) {
                                if (this.histogramFirsts[ctrH] != -1 && this.histogramSeconds[ctrH] != -1) {
                                    if (this.histogramSeconds[ctrH] > this.histogramFirsts[ctrH]) {
                                        if (!(temp >= this.histogramMins[this.histogramFirsts[ctrH]]) || !(temp <= this.histogramMaxs[this.histogramSeconds[ctrH]])) continue;
                                        added = true;
                                        this.histogramData[offset] = ROIColor.getColor(ctrH).getRGB() & 0xFFFFFF | this.histogramAlpha;
                                        continue;
                                    }
                                    if (!(temp >= this.histogramMins[this.histogramSeconds[ctrH]]) || !(temp <= this.histogramMaxs[this.histogramFirsts[ctrH]])) continue;
                                    added = true;
                                    this.histogramData[offset] = ROIColor.getColor(ctrH).getRGB() & 0xFFFFFF | this.histogramAlpha;
                                    continue;
                                }
                                if (this.histogramFirsts[ctrH] == -1 || !(temp >= this.histogramMins[this.histogramFirsts[ctrH]]) || !(temp <= this.histogramMaxs[this.histogramFirsts[ctrH]])) continue;
                                added = true;
                                this.histogramData[offset] = ROIColor.getColor(ctrH).getRGB() & 0xFFFFFF | this.histogramAlpha;
                            }
                        }
                        if (added) continue;
                        this.histogramData[offset] = 0;
                    }
                }
            }
            if (hasLogicalOverlays && logicalManager != null) {
                for (int ctrY = 0; ctrY < this.yDim; ++ctrY) {
                    int offsetY = this.xDim * ctrY;
                    for (int ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        int offset = offsetY + ctrX;
                        int hashCode = this.overlayMixerData[offset];
                        if (hashCode == 0) continue;
                        this.overlayMixerData[offset] = logicalManager.getColorOfVoxel(hashCode);
                    }
                }
            }
        }
        if (updateTexture && this.textureData != null) {
            this.viewer.getBaseScreenVolume().getLookupTableManager().getOp().filter(this.textureImage, this.textureImage);
            if (doSurfaceShrinkWrap) {
                ShrinkWrapOperations.doShrinkWrap(this.textureData, this.shrinkWrapper, this.xDim, this.yDim, this.viewer.getBaseScreenVolume().getLookupTableManager().getMinimumColor().getRGB() | 0xFF000000, this.textureXdim);
            }
            Graphics g = this.textureImage.getGraphics();
            this.drawOverlaysSurface((Graphics2D)g, false);
            g.dispose();
        }
    }

    public void updateSelectedBoundsAndHandles() {
        this.updateSelectedBoundsAndHandles(null);
    }

    public void updateSetShape() {
        if (this.isDragging && this.roiCurrentExists && !this.isROIPolyLineMode) {
            this.viewer.getROIManager().setShape(this.currentSlice, this.sliceDirection, this.useSmartTools(), this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax(), this.roiFill);
        }
    }

    public void updateStructureElement() {
        if (this.viewer == null) {
            return;
        }
        this.currentToolSize = this.viewer.getROIToolSize();
        double screenToolSizeX = Math.max((double)(this.currentToolSize * 2) * Math.abs(this.finalTransform.getScaleX()), Math.abs(this.finalTransform.getScaleX()));
        double screenToolSizeY = Math.max((double)(this.currentToolSize * 2) * Math.abs(this.finalTransform.getScaleY()), Math.abs(this.finalTransform.getScaleY()));
        if (this.structureElement == null) {
            this.makeStructureElement();
        } else if (this.structureElement instanceof Ellipse2D.Double && !this.viewer.isROIEllipseMode()) {
            this.makeStructureElement();
        } else if (this.structureElement instanceof Rectangle2D.Double && this.viewer.isROIEllipseMode()) {
            this.makeStructureElement();
        }
        this.structureElement.setFrame((double)this.currentCursorX - screenToolSizeX / 2.0, (double)this.currentCursorY - screenToolSizeY / 2.0, screenToolSizeX, screenToolSizeY);
    }

    public void updateTransforms() {
        this.updateZoomTransform();
        this.updateFinalTransform();
    }

    private void calculateScreenTouchRatio() {
        double ratio = (float)this.xDim / (float)this.boundingBox.width;
        this.targetSize = Math.max(3, (int)Math.ceil(3.0 * ratio));
    }

    private synchronized void captureVideo() {
        if (this.currentVideoFrame != null) {
            this.videoFrames.add(this.currentVideoFrame);
            if (this.videoFrames.size() >= 1200) {
                this.videoCaptureListener.videoCaptureEnded();
            }
        }
    }

    private void checkBoundsCurrentLocation() {
        if (this.boundingBox != null) {
            this.checkBoundsPoint.x = Math.min(this.boundingBox.width - 2, Math.max(this.currentCursorX, 0));
            this.checkBoundsPoint.y = Math.min(this.boundingBox.height - 2, Math.max(this.currentCursorY, 0));
        }
    }

    private void checkToolBoxMouseLabels() {
        if (this.containsMouse && this.current.x >= 0 && this.current.x < this.xDim && this.current.y >= 0 && this.current.y < this.yDim) {
            this.toolBox.updateMouseLabelInfo(this, this.current, true);
        } else {
            this.toolBox.updateMouseLabelOutOfBounds();
        }
    }

    private void checkToolBoxTextFields() {
        if ((this.toolBox.isTextFieldMinTouched() || this.toolBox.isTextFieldMaxTouched()) && this.toolBox.getCurrentViewer() == this.viewer && (this.viewer.getFrameState() & 1) == 0) {
            this.toolBox.updateTextFields();
        }
    }

    private void clearShapeTransform() {
        if (this.shapeTransform != null && this.adjustingShape != null) {
            this.shapeTransform.setTransform(new AffineTransform());
            this.adjustingShape.setShapeTransform(this.shapeTransform);
        }
        this.isAdjusting = false;
    }

    private void convertScreenToImageLocation(Point point) {
        try {
            this.finalTransform.inverseTransform(point, this.tempTransformedPoint);
            point.x = (int)this.tempTransformedPoint.getX();
            point.y = (int)this.tempTransformedPoint.getY();
        }
        catch (Exception ex) {
            AppLogger.warn((Throwable)ex);
        }
    }

    private void drawOverlays(Graphics2D g2d, boolean drawScaled) {
        boolean isRadiological;
        boolean rgbOverlayDrawn = false;
        boolean hasOverlays = this.viewer.hasOverlays();
        boolean allLogicalsHidden = this.viewer.getLogicalManager() != null && this.viewer.getLogicalManager().allLogicalHidden();
        boolean useInterpolation = this.useInterpolation();
        boolean bl = isRadiological = this.mango.isRadiologicalMode() && this.isRadiologicalSensitive();
        if (hasOverlays) {
            for (int ctr = 0; ctr < 8; ++ctr) {
                boolean interpolate;
                if (!this.hasOverlay[ctr] || this.overlays[ctr].isHidden()) continue;
                boolean bl2 = interpolate = useInterpolation && this.overlays[ctr].getVolume().isAllowsLinearInterpolation();
                if (!this.overlays[ctr].isLogical() || allLogicalsHidden) {
                    this.overlays[ctr].lutManager.getOp().filter(this.overlayScreenSlice[ctr], this.overlayScreenSliceFiltered[ctr]);
                    if (drawScaled) {
                        if (interpolate) {
                            if (this.needUpdateScaledOverlaySlices) {
                                this.updateScaledOverlayImage(ctr);
                            }
                            g2d.drawImage(this.overlayScreenSliceFilteredScaled[ctr], this.finalTransformImage, this);
                            continue;
                        }
                        g2d.drawImage(this.overlayScreenSliceFiltered[ctr], this.finalTransform, this);
                        continue;
                    }
                    if (isRadiological) {
                        this.updateRadiologicalImage(this.overlayScreenSliceFiltered[ctr]);
                        g2d.drawImage(this.radiologicalFiltered, this.finalTransform2, this);
                        continue;
                    }
                    g2d.drawImage(this.overlayScreenSliceFiltered[ctr], this.finalTransform, this);
                    continue;
                }
                if (rgbOverlayDrawn) continue;
                if (drawScaled) {
                    if (interpolate) {
                        if (this.needUpdateScaledOverlaySlices) {
                            this.updateScaledOverlayMixerImage();
                        }
                        g2d.drawImage(this.overlayMixerScaled, this.finalTransformImage, this);
                    } else {
                        g2d.drawImage(this.overlayMixer, this.finalTransform, this);
                    }
                } else if (isRadiological) {
                    this.updateRadiologicalImage(this.overlayMixer);
                    g2d.drawImage(this.radiologicalFiltered, this.finalTransform2, this);
                } else {
                    g2d.drawImage(this.overlayMixer, this.finalTransform, this);
                }
                rgbOverlayDrawn = true;
            }
        }
        if (drawScaled) {
            this.needUpdateScaledOverlaySlices = false;
        }
    }

    private void drawOverlaysSurface(Graphics2D g2d, boolean drawScaled) {
        boolean allLogicalsHidden;
        boolean rgbOverlayDrawn = false;
        boolean hasOverlays = this.viewer.hasOverlays();
        boolean bl = allLogicalsHidden = this.viewer.getLogicalManager() != null && this.viewer.getLogicalManager().allLogicalHidden();
        if (hasOverlays) {
            for (int ctr = 0; ctr < 8; ++ctr) {
                if (!this.hasOverlay[ctr] || this.overlays[ctr].isHidden()) continue;
                if (!this.overlays[ctr].isLogical() || allLogicalsHidden) {
                    this.overlays[ctr].lutManager.getOp().filter(this.overlayScreenSlice[ctr], this.overlayScreenSliceFiltered[ctr]);
                    if (drawScaled) {
                        if (this.needUpdateScaledOverlaySlices) {
                            this.updateScaledOverlayImage(ctr);
                        }
                        g2d.drawImage(this.overlayScreenSliceFilteredScaled[ctr], this.finalTransformImage, this);
                        continue;
                    }
                    g2d.drawImage(this.overlayScreenSliceFiltered[ctr], null, this);
                    continue;
                }
                if (rgbOverlayDrawn) continue;
                if (drawScaled) {
                    if (this.needUpdateScaledOverlaySlices) {
                        this.updateScaledOverlayMixerImage();
                    }
                    g2d.drawImage(this.overlayMixerScaled, this.finalTransformImage, this);
                } else {
                    g2d.drawImage(this.overlayMixer, null, this);
                }
                rgbOverlayDrawn = true;
            }
        }
        if (drawScaled) {
            this.needUpdateScaledOverlaySlices = false;
        }
    }

    private void drawPOIs(Graphics2D g2d, int slice, AffineTransform useTransform) {
        for (POI current = this.managerPOI.getPOIs(slice, this.sliceDirection); current != null; current = current.getNext(this.sliceDirection)) {
            int color = current.getColor();
            g2d.setColor(ROIColor.getColor(color));
            current.setGraphics(g2d);
            Shape currentShape = useTransform.createTransformedShape(current.getShape(this.sliceDirection));
            g2d.draw(currentShape);
            if (!this.isMainImage || !this.viewer.isShowingLabels() || !StringUtils.isNotBlank((CharSequence)current.getName()) || current == this.adjustingPOI) continue;
            Rectangle bounds = currentShape.getBounds();
            TextLayout textLayout = new TextLayout(current.getName(), LABEL_FONT, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int startX = (int)Math.round((double)bounds.x + (double)bounds.width / 2.0 - (double)textLayoutWidth / 2.0);
            g2d.setFont(LABEL_FONT);
            if (current.isSelected()) {
                g2d.setColor(Color.WHITE);
                g2d.drawString(current.getName(), startX - 1, bounds.y + 25);
            }
            g2d.setColor(ROIColor.getColor(color));
            g2d.drawString(current.getName(), startX, bounds.y + 25);
        }
    }

    private void drawShapes(Graphics2D g2d, int aSlice) {
        this.drawShapes(g2d, aSlice, this.finalTransform, false);
    }

    private void drawShapes(Graphics2D g2d, int aSlice, AffineTransform useTransform, boolean isCapture) {
        int height;
        if (this.viewer == null) {
            return;
        }
        AffineTransform originalTransform = g2d.getTransform();
        Stroke defaultStroke = g2d.getStroke();
        Font originalFont = g2d.getFont();
        int lastLabelY = height = this.getHeight();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.viewer != null && this.viewer.isShowingROI()) {
            LOIShape currentLOI;
            if (this.showLineLength && this.isMainImage && this.rulerShape != null) {
                g2d.setColor(ROIColor.getColor(5));
                g2d.setStroke(STOKE_TOOL);
                this.rulerShape.setSliceDirection(this.sliceDirection);
                this.rulerShape.setGraphics(g2d);
                this.rulerShape.setShowLength(true);
                g2d.draw(useTransform.createTransformedShape(this.rulerShape));
                this.rulerShape.drawLabels();
                g2d.setStroke(defaultStroke);
            }
            if (this.showLineAngle && this.isMainImage && this.angleShape != null) {
                g2d.setColor(ROIColor.getColor(4));
                g2d.setStroke(STOKE_TOOL);
                this.angleShape.setSliceDirection(this.sliceDirection);
                this.angleShape.setGraphics(g2d);
                this.angleShape.setShowAngle(true);
                g2d.draw(useTransform.createTransformedShape(this.angleShape));
                this.angleShape.drawLabels();
                g2d.setStroke(defaultStroke);
            }
            if (this.managerSpecialLOI.hasShapes()) {
                for (currentLOI = this.managerSpecialLOI.getShape(aSlice); currentLOI != null; currentLOI = currentLOI.getNext()) {
                    if (currentLOI.isHighlighted()) {
                        g2d.setColor(Color.WHITE);
                    } else {
                        g2d.setColor(currentLOI.getSpecialColor());
                    }
                    currentLOI.setGraphics(g2d);
                    if (currentLOI.getSpecialStroke() != null) {
                        g2d.setStroke(currentLOI.getSpecialStroke());
                    }
                    g2d.draw(useTransform.createTransformedShape(currentLOI));
                    g2d.setStroke(defaultStroke);
                }
            }
            if (this.managerSpecialLOI.hasStaticShapes()) {
                for (currentLOI = this.managerSpecialLOI.getStaticShape(); currentLOI != null; currentLOI = currentLOI.getNext()) {
                    if (currentLOI.isHighlighted()) {
                        g2d.setColor(Color.WHITE);
                    } else {
                        g2d.setColor(currentLOI.getSpecialColor());
                    }
                    currentLOI.setGraphics(g2d);
                    if (currentLOI.getSpecialStroke() != null) {
                        g2d.setStroke(currentLOI.getSpecialStroke());
                    }
                    g2d.draw(useTransform.createTransformedShape(currentLOI));
                    g2d.setStroke(defaultStroke);
                }
            }
            if (this.managerLOI.hasShapes() && this.managerLOI.hasShapes(aSlice)) {
                for (currentLOI = this.managerLOI.getShape(aSlice); currentLOI != null; currentLOI = currentLOI.getNext()) {
                    int color = currentLOI.getColor();
                    if (currentLOI != this.adjustingLOI) {
                        if (currentLOI.isHighlighted()) {
                            g2d.setColor(Color.WHITE);
                        } else {
                            g2d.setColor(ROIColor.getColor(color));
                        }
                        currentLOI.setGraphics(g2d);
                        g2d.draw(useTransform.createTransformedShape(currentLOI));
                        if (!this.isMainImage) continue;
                        if (this.viewer.isShowingLabels()) {
                            currentLOI.drawName();
                        }
                        if (!this.showLineLength && !this.showLineAngle) continue;
                        currentLOI.drawLabels();
                        continue;
                    }
                    if (this.isDragging) {
                        g2d.setColor(ROIColor.getBrighterColor(color));
                        g2d.draw(useTransform.createTransformedShape(this.adjustingLOITransformableShape.createTransformedShape()));
                        continue;
                    }
                    g2d.setColor(ROIColor.getColor(color));
                    currentLOI.setGraphics(g2d);
                    g2d.draw(useTransform.createTransformedShape(currentLOI));
                }
            }
            if (this.managerPOI.hasPoints(aSlice, this.sliceDirection)) {
                this.drawPOIs(g2d, aSlice, useTransform);
            }
            if (this.managerSpecialPOI.hasPoints(aSlice, this.sliceDirection)) {
                POI current;
                if (this.sliceDirection == 0) {
                    for (current = this.managerSpecialPOI.getPOIs(aSlice, this.sliceDirection); current != null; current = current.getNextAxial()) {
                        current.setGraphics(g2d);
                        g2d.draw(useTransform.createTransformedShape(current.getAxialShape()));
                    }
                } else if (this.sliceDirection == 1) {
                    for (current = this.managerSpecialPOI.getPOIs(aSlice, this.sliceDirection); current != null; current = current.getNextCoronal()) {
                        current.setGraphics(g2d);
                        g2d.draw(useTransform.createTransformedShape(current.getCoronalShape()));
                    }
                } else if (this.sliceDirection == 2) {
                    for (current = this.managerSpecialPOI.getPOIs(aSlice, this.sliceDirection); current != null; current = current.getNextSagittal()) {
                        current.setGraphics(g2d);
                        g2d.draw(useTransform.createTransformedShape(current.getSagittalShape()));
                    }
                }
            }
            if (this.showCrosssectionMarker && this.sliceDirection == this.crosssectionDirection) {
                Stroke oldStroke = g2d.getStroke();
                g2d.setStroke(STOKE_TOOL);
                g2d.setColor(Color.WHITE);
                Point2D aPoint = useTransform.transform(this.crosssectionPoint, null);
                this.crosssectionMarker.setFrame(aPoint.getX() - 3.0, aPoint.getY() - 3.0, 7.0, 7.0);
                if (Platform.isRetinaCapable()) {
                    g2d.draw(this.crosssectionMarker);
                    g2d.setStroke(oldStroke);
                } else {
                    g2d.setXORMode(Color.BLACK);
                    g2d.draw(this.crosssectionMarker);
                    g2d.setStroke(oldStroke);
                    g2d.setPaintMode();
                }
            }
            if (this.isMainImage && this.isUpdatingPolyLine) {
                g2d.setColor(ROIColor.getBrighterColor(this.currentROI));
                g2d.draw(this.polyLinePath);
                g2d.drawLine((int)(this.polyLineLast.getX() + 0.5), (int)(this.polyLineLast.getY() + 0.5), this.currentCursorX, this.currentCursorY);
            }
            if (this.roiExists && this.roi != null) {
                this.showMask = this.viewer.isShowingROIMask();
                this.showEdge = this.viewer.isShowingROIEdge();
                int current = this.viewer.getROIManager().getCurrentROI();
                Vector<Integer> usedROIs = this.viewer.getROIManager().getUsedIndicesCurrentLast();
                for (int ctr : usedROIs) {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    if (this.showMask) {
                        if (this.viewer.getROIManager().isHighlighted(ctr)) {
                            if (this.showEdge) {
                                g2d.setColor(COLOR_WHITE_ALPHA);
                            } else {
                                g2d.setColor(Color.WHITE);
                            }
                        } else if (this.showEdge) {
                            g2d.setColor(ROIColor.getTransparentColor(ctr));
                        } else {
                            g2d.setColor(ROIColor.getColor(ctr));
                        }
                        g2d.fill(this.roi[ctr]);
                        if (originalTransform != null) {
                            g2d.setTransform(originalTransform);
                        }
                    }
                    if (this.showEdge || this.showMask) {
                        if (this.viewer.getROIManager().isHighlighted(ctr)) {
                            g2d.setColor(Color.WHITE);
                        } else {
                            g2d.setColor(ROIColor.getColor(ctr));
                        }
                        g2d.draw(this.roi[ctr]);
                        if (originalTransform != null) {
                            g2d.setTransform(originalTransform);
                        }
                    }
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                    if (this.viewer.getROIManager().isHighlighted(ctr)) {
                        g2d.setColor(Color.WHITE);
                    } else {
                        g2d.setColor(ROIColor.getColor(ctr));
                    }
                    if (this.isMainImage && current == ctr && this.viewer.isShowingROIStats()) {
                        g2d.setFont(originalFont);
                        int coorType = this.viewer.getCoordinateType();
                        Color oldColor = g2d.getColor();
                        double areaCalc = this.roi[ctr].getArea();
                        if (coorType != 0) {
                            areaCalc *= this.xSize * this.ySize;
                        }
                        double centroidX = this.centroidXSum / this.centroidSumABS;
                        double centroidY = this.centroidYSum / this.centroidSumABS;
                        if (this.sliceDirection == 0) {
                            this.centroidCoor.setValues(centroidX, centroidY, (double)this.currentSlice);
                        } else if (this.sliceDirection == 1) {
                            this.centroidCoor.setValues(centroidX, (double)this.currentSlice, centroidY);
                        } else if (this.sliceDirection == 2) {
                            this.centroidCoor.setValues((double)this.currentSlice, centroidX, centroidY);
                        }
                        this.viewer.getCurrentCoordinate(this.viewer.getScreenVolume(), this.centroidCoor, this.centroidCoorType, true);
                        if (this.sliceDirection == 0) {
                            centroidX = this.centroidCoorType.xDbl;
                            centroidY = this.centroidCoorType.yDbl;
                        } else if (this.sliceDirection == 1) {
                            centroidX = this.centroidCoorType.xDbl;
                            centroidY = this.centroidCoorType.zDbl;
                        } else if (this.sliceDirection == 2) {
                            centroidX = this.centroidCoorType.yDbl;
                            centroidY = this.centroidCoorType.zDbl;
                        }
                        double centerX = this.roi[ctr].getCentroidX();
                        double centerY = this.roi[ctr].getCentroidY();
                        if (this.sliceDirection == 0) {
                            this.centroidCoor.setValues(centerX, centerY, (double)this.currentSlice);
                        } else if (this.sliceDirection == 1) {
                            this.centroidCoor.setValues(centerX, (double)this.currentSlice, centerY);
                        } else if (this.sliceDirection == 2) {
                            this.centroidCoor.setValues((double)this.currentSlice, centerX, centerY);
                        }
                        this.viewer.getCurrentCoordinate(this.viewer.getScreenVolume(), this.centroidCoor, this.centroidCoorType, true);
                        if (this.sliceDirection == 0) {
                            centerX = this.centroidCoorType.xDbl;
                            centerY = this.centroidCoorType.yDbl;
                        } else if (this.sliceDirection == 1) {
                            centerX = this.centroidCoorType.xDbl;
                            centerY = this.centroidCoorType.zDbl;
                        } else if (this.sliceDirection == 2) {
                            centerX = this.centroidCoorType.yDbl;
                            centerY = this.centroidCoorType.zDbl;
                        }
                        if (areaCalc > 0.0) {
                            String areaString = (coorType == 0 ? "Voxels = " : "Area = ") + FORMATTER.format(areaCalc);
                            this.calcLabel.setLocation(Math.round(((double)this.xDim * this.xSize - (double)this.longestDim * this.longestDimSize) / 2.0 / this.xSize), Math.round((double)this.yDim + ((double)this.longestDim * this.longestDimSize - (double)this.yDim * this.ySize) / 2.0 / this.ySize));
                            this.screenTransform.transform(this.calcLabel, this.calcLabel);
                            g2d.drawString(areaString, this.calcLabel.x + 8, 16);
                            if (this.centroidSumABS != 0.0) {
                                String meanString = "Mean = " + FOMATTER_LONG.format(this.calcSum / this.centroidCount);
                                this.calcLabel.setLocation(Math.round(((double)this.xDim * this.xSize - (double)this.longestDim * this.longestDimSize) / 2.0 / this.xSize), Math.round((double)this.yDim + ((double)this.longestDim * this.longestDimSize - (double)this.yDim * this.ySize) / 2.0 / this.ySize));
                                this.screenTransform.transform(this.calcLabel, this.calcLabel);
                                g2d.drawString(meanString, this.calcLabel.x + 8, 36);
                                if (this.centroidCount > 1.0) {
                                    String stdevString = "SD = " + FOMATTER_LONG.format(Math.sqrt((this.centroidCount * this.centroidSumOfSquares - MathUtilities.pow((double)this.calcSum, (double)2.0)) / (this.centroidCount * (this.centroidCount - 1.0))));
                                    this.calcLabel.setLocation(Math.round(((double)this.xDim * this.xSize - (double)this.longestDim * this.longestDimSize) / 2.0 / this.xSize), Math.round((double)this.yDim + ((double)this.longestDim * this.longestDimSize - (double)this.yDim * this.ySize) / 2.0 / this.ySize));
                                    this.screenTransform.transform(this.calcLabel, this.calcLabel);
                                    g2d.drawString(stdevString, this.calcLabel.x + 8, 56);
                                }
                            }
                            String centroidString = "Centroid = (" + FORMATTER.format(this.viewer.convertCoordinateOriginMainX(centroidX)) + ", " + FORMATTER.format(this.viewer.convertCoordinateOriginMainY(centroidY)) + ")";
                            TextLayout textLayout = new TextLayout(centroidString, g2d.getFont(), g2d.getFontRenderContext());
                            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
                            this.calcLabel.setLocation(Math.round((double)this.xDim + ((double)this.longestDim * this.longestDimSize - (double)this.xDim * this.xSize) / 2.0 / this.xSize), Math.round((double)this.yDim + ((double)this.longestDim * this.longestDimSize - (double)this.yDim * this.ySize) / 2.0 / this.ySize));
                            this.screenTransform.transform(this.calcLabel, this.calcLabel);
                            if (this.centroidSumABS != 0.0) {
                                g2d.setColor(oldColor);
                                g2d.drawString(centroidString, this.calcLabel.x - textLayoutWidth - 8, 36);
                                this.centroidMarkerOutter.setFrame(this.calcLabel.x - textLayoutWidth - 8 - 12, 27.0, 7.0, 7.0);
                                g2d.setColor(Color.WHITE);
                                g2d.fill(this.centroidMarkerOutter);
                                this.centroidImage.setLocation(this.centroidXSum / this.centroidSumABS, this.centroidYSum / this.centroidSumABS);
                                useTransform.transform(this.centroidImage, this.centroidTransformed);
                                this.centroidMarker.setFrame(this.centroidTransformed.getX(), this.centroidTransformed.getY(), 5.0, 5.0);
                                this.centroidMarkerOutter.setFrame(this.centroidTransformed.getX() - 1.0, this.centroidTransformed.getY() - 1.0, 7.0, 7.0);
                                if (originalTransform != null) {
                                    g2d.setTransform(originalTransform);
                                }
                                g2d.setColor(Color.WHITE);
                                g2d.fill(this.centroidMarkerOutter);
                            }
                            String centerString = "Center = (" + FORMATTER.format(this.viewer.convertCoordinateOriginMainX(centerX)) + ", " + FORMATTER.format(this.viewer.convertCoordinateOriginMainY(centerY)) + ")";
                            textLayout = new TextLayout(centerString, g2d.getFont(), g2d.getFontRenderContext());
                            textLayoutWidth = (int)textLayout.getBounds().getWidth();
                            this.calcLabel.setLocation(Math.round((double)this.xDim + ((double)this.longestDim * this.longestDimSize - (double)this.xDim * this.xSize) / 2.0 / this.xSize), Math.round((double)this.yDim + ((double)this.longestDim * this.longestDimSize - (double)this.yDim * this.ySize) / 2.0 / this.ySize));
                            this.screenTransform.transform(this.calcLabel, this.calcLabel);
                            g2d.setColor(oldColor);
                            g2d.drawString(centerString, this.calcLabel.x - textLayoutWidth - 8, 16);
                            this.centroidImage.setLocation(this.roi[ctr].getCentroidX(), this.roi[ctr].getCentroidY());
                            useTransform.transform(this.centroidImage, this.centroidTransformed);
                            this.centroidMarker.setFrame(this.centroidTransformed.getX(), this.centroidTransformed.getY(), 7.0, 7.0);
                            if (originalTransform != null) {
                                g2d.setTransform(originalTransform);
                            }
                            g2d.setColor(oldColor);
                            g2d.fill(this.centroidMarker);
                            this.centroidMarker.setFrame(this.calcLabel.x - textLayoutWidth - 8 - 12, 7.0, 7.0, 7.0);
                            g2d.fill(this.centroidMarker);
                        }
                    }
                    if (originalTransform != null) {
                        g2d.setTransform(originalTransform);
                    }
                    if (this.viewer.isSelected(this, aSlice, this.sliceDirection, ctr)) {
                        if (!this.isAdjusting || !this.isDragging) {
                            if (this.selectedHasBounds[ctr]) {
                                Color strokeColor;
                                if (this.viewer.getROIManager().isHighlighted(ctr)) {
                                    strokeColor = Color.WHITE;
                                    g2d.setColor(strokeColor);
                                    g2d.setStroke(STROKE_DASH);
                                    g2d.draw(this.bounds[ctr]);
                                    g2d.setStroke(defaultStroke);
                                    g2d.draw(this.handlesPath[ctr]);
                                } else if (this.viewer.isActive()) {
                                    strokeColor = Color.WHITE;
                                    g2d.setColor(strokeColor);
                                    g2d.setStroke(STROKE_DASH);
                                    g2d.draw(this.bounds[ctr]);
                                    g2d.setStroke(defaultStroke);
                                    g2d.setColor(ROIColor.getBrighterColor(ctr));
                                    g2d.draw(this.handlesPath[ctr]);
                                } else {
                                    strokeColor = Color.GRAY;
                                    g2d.setColor(strokeColor);
                                    g2d.setStroke(STROKE_DASH);
                                    g2d.draw(this.bounds[ctr]);
                                    g2d.setStroke(defaultStroke);
                                    g2d.draw(this.handlesPath[ctr]);
                                }
                            }
                        } else {
                            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                            g2d.setColor(ROIColor.getBrighterColor(this.adjustingShape.getID()));
                            g2d.draw(this.adjustingShape);
                            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            if (originalTransform != null) {
                                g2d.setTransform(originalTransform);
                            }
                        }
                    }
                    if (!this.isMainImage || !this.isAdjustingRealShape) continue;
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    g2d.setColor(ROIColor.getBrighterColor(ctr));
                    g2d.draw(this.adjustingRealShape.createTransformedShape());
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
            }
        }
        if (this.isMainImage) {
            Annotation seriesLabel;
            List<Annotation> labels = this.makeROILabels();
            if (labels.size() > 0) {
                for (Annotation annotation : labels) {
                    g2d.setFont(LABEL_FONT);
                    TextLayout textLayout = new TextLayout(annotation.getText(), g2d.getFont(), g2d.getFontRenderContext());
                    int roiLabelHeight = (int)textLayout.getBounds().getHeight();
                    if (this.viewer.isSelected(this, this.currentSlice, this.sliceDirection, annotation.getCode())) {
                        g2d.setColor(Color.WHITE);
                        g2d.drawString(annotation.getText(), 7, lastLabelY - 8);
                    }
                    g2d.setColor(annotation.getColor());
                    g2d.drawString(annotation.getText(), 8, lastLabelY - 8);
                    lastLabelY -= roiLabelHeight + 8;
                    g2d.setFont(originalFont);
                }
            }
            if ((seriesLabel = this.makeSeriesLabel()) != null) {
                g2d.setFont(LABEL_FONT);
                TextLayout textLayout = new TextLayout(seriesLabel.getText(), g2d.getFont(), g2d.getFontRenderContext());
                int labelWidth = (int)textLayout.getBounds().getWidth();
                g2d.setColor(Color.WHITE);
                g2d.drawString(seriesLabel.getText(), this.getWidth() - labelWidth - 16, this.getHeight() - 8);
            }
            if (this.viewer.getToolBox().getSelectionMode() == 2) {
                String str = this.viewer.getZoomString() + "%";
                Font oldFont = g2d.getFont();
                g2d.setFont(ZOOM_FONT);
                TextLayout textLayout = new TextLayout(str, g2d.getFont(), g2d.getFontRenderContext());
                int textLayoutWidth = (int)textLayout.getBounds().getWidth();
                int textLayoutHeight = (int)textLayout.getBounds().getHeight();
                Point pt = new Point((int)Math.round((double)this.xDim / 2.0), (int)Math.round((double)this.yDim / 2.0));
                this.screenTransform.transform(pt, pt);
                g2d.setXORMode(Color.WHITE);
                g2d.setColor(Color.BLACK);
                g2d.drawString(str, pt.x - textLayoutWidth / 2, pt.y + textLayoutHeight / 2);
                g2d.setPaintMode();
                g2d.setFont(oldFont);
            }
        }
        if (this.isMainImage && this.selectionShapeAdjusted && !this.viewer.isROIMode() && this.viewer.isActive() && !this.isGrabMode && !this.isZoomMode) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setColor(Color.WHITE);
            g2d.setStroke(STROKE_DASH);
            g2d.draw(this.selectionShape.createTransformedShape());
            g2d.setStroke(defaultStroke);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.isMainImage && this.containsMouse && this.viewer.isROIToolMode() && this.viewer.isActive() && !this.isGrabMode && !this.isZoomMode) {
            if (this.mango.isMac()) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.isDragging || this.isPressed) {
                g2d.setColor(ROIColor.getColor(this.viewer.getRoiColor()));
            } else {
                g2d.setColor(ROIColor.getBrighterColor(this.viewer.getRoiColor()));
            }
            g2d.setStroke(STOKE_TOOL);
            g2d.draw(this.structureElement);
            g2d.setStroke(defaultStroke);
            if (this.mango.isMac()) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        if (this.isMainImage && (this.showOrientation || this.mango.isRadiologicalMode() && !isCapture)) {
            int orientationCertainty = this.viewer.getOrientationCertainty();
            if (this.showOrientation) {
                g2d.setColor(ORIENTATION_CERTAINTY_COLORS[orientationCertainty]);
            } else {
                g2d.setColor(ORIENTATION_CERTAINTY_COLORS_BACKGROUND[orientationCertainty]);
            }
            g2d.setFont(ORIENTATION_FONT);
            if (this.sliceDirection == 0) {
                if (this.showOrientation || this.mango.isRadiologicalMode()) {
                    g2d.drawString(orientationCertainty > 0 ? "R" : "?", this.orientR.x, this.orientR.y);
                    g2d.drawString(orientationCertainty > 0 ? "L" : "?", this.orientL.x, this.orientL.y);
                }
                if (this.showOrientation) {
                    g2d.drawString(orientationCertainty > 0 ? "A" : "?", this.orientA.x, this.orientA.y);
                    if (!this.viewer.isShowingLabels()) {
                        g2d.drawString(orientationCertainty > 0 ? "P" : "?", this.orientP.x, this.orientP.y);
                    }
                }
            } else if (this.sliceDirection == 1) {
                if (this.showOrientation || this.mango.isRadiologicalMode()) {
                    g2d.drawString(orientationCertainty > 0 ? "R" : "?", this.orientR.x, this.orientR.y);
                    g2d.drawString(orientationCertainty > 0 ? "L" : "?", this.orientL.x, this.orientL.y);
                }
                if (this.showOrientation) {
                    g2d.drawString(orientationCertainty > 0 ? "S" : "?", this.orientA.x, this.orientA.y);
                    if (!this.viewer.isShowingLabels()) {
                        g2d.drawString(orientationCertainty > 0 ? "I" : "?", this.orientP.x, this.orientP.y);
                    }
                }
            } else if (this.sliceDirection == 2 && this.showOrientation) {
                g2d.drawString(orientationCertainty > 0 ? "P" : "?", this.orientR.x, this.orientR.y);
                g2d.drawString(orientationCertainty > 0 ? "A" : "?", this.orientL.x, this.orientL.y);
                g2d.drawString(orientationCertainty > 0 ? "S" : "?", this.orientA.x, this.orientA.y);
                if (!this.viewer.isShowingLabels()) {
                    g2d.drawString(orientationCertainty > 0 ? "I" : "?", this.orientP.x, this.orientP.y);
                }
            }
        }
        if (this.showCrosshairs) {
            g2d.setColor(COLOR_CROSSHAIRS);
            g2d.drawLine((int)(useTransform.transform(this.horizontalLeft, this.tempTransformedPoint).getX() + 0.5), (int)(this.tempTransformedPoint.getY() + 0.5), (int)(useTransform.transform(this.horizontalRight, this.tempTransformedPoint).getX() + 0.5), (int)(this.tempTransformedPoint.getY() + 0.5));
            g2d.drawLine((int)(useTransform.transform(this.verticalTop, this.tempTransformedPoint).getX() + 0.5), (int)(this.tempTransformedPoint.getY() + 0.5), (int)(useTransform.transform(this.verticalBottom, this.tempTransformedPoint).getX() + 0.5), (int)(this.tempTransformedPoint.getY() + 0.5));
        }
    }

    private int findProximalHandle() {
        int proximalHandle = 0;
        Vector<Integer> usedIndices = this.viewer.getROIManager().getUsedIndices();
        for (int ctr : usedIndices) {
            if (this.viewer.getROIManager().isSelected(ctr)) {
                proximalHandle = this.findProximalHandle(ctr);
            }
            if (proximalHandle == 0) continue;
            break;
        }
        return proximalHandle;
    }

    private int findProximalHandle(int ctr) {
        int nt = (int)this.northHandle[ctr].distance(this.currentCursorX, this.currentCursorY);
        int ne = (int)this.northEastHandle[ctr].distance(this.currentCursorX, this.currentCursorY);
        int et = (int)this.eastHandle[ctr].distance(this.currentCursorX, this.currentCursorY);
        int se = (int)this.southEastHandle[ctr].distance(this.currentCursorX, this.currentCursorY);
        int st = (int)this.southHandle[ctr].distance(this.currentCursorX, this.currentCursorY);
        int sw = (int)this.southWestHandle[ctr].distance(this.currentCursorX, this.currentCursorY);
        int wt = (int)this.westHandle[ctr].distance(this.currentCursorX, this.currentCursorY);
        int nw = (int)this.northWestHandle[ctr].distance(this.currentCursorX, this.currentCursorY);
        if (nt < this.targetSize && nt <= ne && nt <= et && nt <= se && nt <= st && nt <= sw && nt <= wt && nt <= nw) {
            return 1;
        }
        if (nw < this.targetSize && nw <= ne && nw <= et && nw <= se && nw <= st && nw <= sw && nw <= wt && nw <= nt) {
            return 9;
        }
        if (ne < this.targetSize && ne <= nw && ne <= et && ne <= se && ne <= st && ne <= sw && ne <= wt && ne <= nt) {
            return 3;
        }
        if (et < this.targetSize && et <= nw && et <= ne && et <= se && et <= st && et <= sw && et <= wt && et <= nt) {
            return 2;
        }
        if (se < this.targetSize && se <= nw && se <= ne && se <= et && se <= st && se <= sw && se <= wt && se <= nt) {
            return 6;
        }
        if (st < this.targetSize && st <= nw && st <= ne && st <= et && st <= se && st <= sw && st <= wt && st <= nt) {
            return 4;
        }
        if (sw < this.targetSize && sw <= nw && sw <= ne && sw <= et && sw <= se && sw <= st && sw <= wt && sw <= nt) {
            return 12;
        }
        if (wt < this.targetSize && wt <= nw && wt <= ne && wt <= et && wt <= se && wt <= st && wt <= sw && wt <= nt) {
            return 8;
        }
        return 0;
    }

    private LOIShape findProximalLOIHandle(boolean selectedOnly, boolean ignoreSelected) {
        for (LOIShape currentShape = this.managerLOI.getShape(this.currentSlice); currentShape != null; currentShape = currentShape.getNext()) {
            if (selectedOnly && (!currentShape.isSelected() || ignoreSelected) || currentShape.isImmutable()) continue;
            if (currentShape.getStartPoint().distance(this.current) < (double)this.targetSize) {
                return currentShape;
            }
            if (currentShape.isClosed() || !(currentShape.getEndPoint().distance(this.current) < (double)this.targetSize)) continue;
            return currentShape;
        }
        return null;
    }

    private LOIShape findProximalMeasurementLOIHandle() {
        if (this.showLineLength) {
            if (this.rulerShape.getStartPoint().distance(this.current) < (double)this.targetSize) {
                return this.rulerShape;
            }
            if (this.rulerShape.getEndPoint().distance(this.current) < (double)this.targetSize) {
                return this.rulerShape;
            }
        }
        if (this.showLineAngle) {
            if (this.angleShape.getStartPoint().distance(this.current) < (double)this.targetSize) {
                return this.angleShape;
            }
            if (this.angleShape.getPoints().get(1).distance(this.current) < (double)this.targetSize) {
                return this.angleShape;
            }
            if (this.angleShape.getEndPoint().distance(this.current) < (double)this.targetSize) {
                return this.angleShape;
            }
        }
        return null;
    }

    private POI findProximalPOI(boolean selectedOnly) {
        for (POI currentPOI = this.managerPOI.getPOIs(this.currentSlice, this.sliceDirection); currentPOI != null; currentPOI = currentPOI.getNext(this.sliceDirection)) {
            if (selectedOnly && !currentPOI.isSelected()) continue;
            if (this.sliceDirection == 0) {
                this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getY());
            } else if (this.sliceDirection == 1) {
                this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getZ());
            } else {
                this.tempPOIPoint.setLocation(currentPOI.getY(), currentPOI.getZ());
            }
            if (!(this.tempPOIPoint.distance(this.current) < (double)this.targetSize)) continue;
            return currentPOI;
        }
        return null;
    }

    private int[] findProximalPOIOffset() {
        for (POI currentPOI = this.managerPOI.getPOIs(this.currentSlice, this.sliceDirection); currentPOI != null; currentPOI = currentPOI.getNext(this.sliceDirection)) {
            if (!currentPOI.isSelected()) continue;
            if (this.sliceDirection == 0) {
                this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getY());
            } else if (this.sliceDirection == 1) {
                this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getZ());
            } else {
                this.tempPOIPoint.setLocation(currentPOI.getY(), currentPOI.getZ());
            }
            if (!(this.tempPOIPoint.distance(this.current) < (double)this.targetSize)) continue;
            return new int[]{this.tempPOIPoint.x - this.current.x, this.tempPOIPoint.y - this.current.y};
        }
        return CollectionUtilities.EMPTY_INT_ARRAY;
    }

    private POI findProximalSpecialPOI() {
        for (POI currentPOI = this.managerSpecialPOI.getPOIs(this.currentSlice, this.sliceDirection); currentPOI != null; currentPOI = currentPOI.getNext(this.sliceDirection)) {
            if (currentPOI.isImmutable()) continue;
            if (this.sliceDirection == 0) {
                this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getY());
            } else if (this.sliceDirection == 1) {
                this.tempPOIPoint.setLocation(currentPOI.getX(), currentPOI.getZ());
            } else {
                this.tempPOIPoint.setLocation(currentPOI.getY(), currentPOI.getZ());
            }
            if (!(this.tempPOIPoint.distance(this.current) < (double)this.targetSize)) continue;
            return currentPOI;
        }
        return null;
    }

    private double getImageScaleX() {
        if (this.viewer.isRetinaDisplay()) {
            return this.scaleTransform.getScaleX() * 2.0;
        }
        return this.scaleTransform.getScaleX();
    }

    private double getImageScaleY() {
        if (this.viewer.isRetinaDisplay()) {
            return this.scaleTransform.getScaleY() * 2.0;
        }
        return this.scaleTransform.getScaleY();
    }

    private void initializeDicomOverlay() {
        this.dicomOverlay = new BufferedImage(this.xDim, this.yDim, 2);
        this.dicomOverlayData = ((DataBufferInt)this.dicomOverlay.getRaster().getDataBuffer()).getData();
    }

    private void initializeHistogram() {
        this.histogramOverlay = new BufferedImage(this.xDim, this.yDim, 2);
        this.histogramData = ((DataBufferInt)this.histogramOverlay.getRaster().getDataBuffer()).getData();
        this.updateHistogram();
    }

    private POI makePOI(Point pointVal) {
        Point point = pointVal;
        if (point == null) {
            point = new Point(this.currentX, this.currentY);
        }
        this.viewer.resetAllClipboardsUndo();
        POI poi = null;
        poi = this.sliceDirection == 0 ? new POI(point.x, point.y, this.currentSlice, this.viewer.getRoiColor()) : (this.sliceDirection == 1 ? new POI(point.x, this.currentSlice, point.y, this.viewer.getRoiColor()) : new POI(this.currentSlice, point.x, point.y, this.viewer.getRoiColor()));
        this.managerPOI.addPOI(poi, true, true);
        this.viewer.repaint();
        return poi;
    }

    private List<Annotation> makeROILabels() {
        ROIManager labelManager = this.viewer.getROIManager();
        List<Annotation> labels = new Vector<Annotation>();
        if (this.viewer.isShowingLabels() && this.roi != null) {
            int current = this.viewer.getROIManager().getCurrentROI();
            Vector<Integer> usedROIs = this.viewer.getROIManager().getUsedIndicesCurrentLast();
            Iterator it = usedROIs.iterator();
            String currentLabel = null;
            while (it.hasNext()) {
                double areaCalc;
                int ctr = (Integer)it.next();
                if (this.roi[ctr] == null || !((areaCalc = this.roi[ctr].getArea()) > 0.0)) continue;
                String labelString = labelManager.getLabel(ctr, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr, this.viewer.getROIManager().getMaximumColors()));
                if (ctr == current) {
                    currentLabel = labelString;
                    continue;
                }
                Annotation annotation = new Annotation(ROIColor.getColor(ctr), labelString);
                annotation.setCode(ctr);
                labels.add(annotation);
            }
            Collections.sort(labels, new AlphanumComparator());
            if (currentLabel != null) {
                Annotation annotation = new Annotation(ROIColor.getColor(current), currentLabel);
                annotation.setCode(current);
                labels.add(0, annotation);
            }
            if (labels.size() > 8) {
                labels = labels.subList(0, 9);
                labels.get(labels.size() - 1).setText("...");
                labels.get(labels.size() - 1).setColor(Color.WHITE);
            }
        }
        Collections.reverse(labels);
        return labels;
    }

    private Annotation makeSeriesLabel() {
        Annotation seriesLabel = null;
        int numTimepoints = this.viewer.getCurrentVolume().getNumTimepoints();
        if (this.viewer.isShowingLabels() && numTimepoints > 1) {
            int seriesPoint = this.viewer.getCurrentTimepoint();
            seriesLabel = new Annotation(Color.WHITE, this.viewer.getCurrentSeriesLabelManager().getLabel(seriesPoint, SeriesDefaultLabels.getDefaultLabel(seriesPoint, this.viewer.getCurrentVolume())));
        }
        return seriesLabel;
    }

    private void makeStructureElement() {
        this.structureElement = this.viewer.isROIEllipseMode() ? new Ellipse2D.Double() : new Rectangle2D.Double();
    }

    private void notifyAllSliceListeners() {
        Enumeration<SliceListener> en = this.sliceListeners.elements();
        while (en.hasMoreElements()) {
            en.nextElement().sliceChanged(this.currentSlice, this.sliceDirection, this.isMainImage);
        }
    }

    private void removeAllSliceListeners() {
        this.sliceListeners.removeAllElements();
    }

    private void selectAllROIsWithinBounds(TransformableShape shape) {
        try {
            Rectangle bounds = this.finalTransform.createInverse().createTransformedShape(shape.createTransformedShape()).getBounds();
            bounds.x = Math.max(0, bounds.x);
            bounds.y = Math.max(0, bounds.y);
            bounds.width = Math.min(this.xDim, bounds.width);
            bounds.height = Math.min(this.yDim, bounds.height);
            if (bounds.width > 1 && bounds.height > 1) {
                Vector<POI> allPOIs = this.managerPOI.findAllPOIsWithinBounds(bounds, this.viewer.getMainSliceNumber(), this.viewer.getMainSliceDirection());
                for (POI poi : allPOIs) {
                    poi.setSelectedState(true);
                }
                Vector<LOIShape> allLOIs = this.managerLOI.findAllLOIsWithinBounds(bounds, this.currentSlice);
                for (LOIShape loi : allLOIs) {
                    loi.setSelectedState(true);
                }
                long selectMask = 0L;
                if (this.roi != null) {
                    Vector<Integer> usedIndices = this.viewer.getROIManager().getUsedIndices();
                    for (int ctr : usedIndices) {
                        if (this.roi[ctr] == null || !bounds.contains(this.roi[ctr].getBounds())) continue;
                        selectMask |= 1L << ctr;
                    }
                }
                this.viewer.getROIManager().selectSome(selectMask |= this.viewer.getROIManager().getBuffer().getSelected());
            }
        }
        catch (NoninvertibleTransformException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private void setShapeTransform(double xScale, double yScale, double xTrans, double yTrans, int roiNum) {
        this.shapeTransform.setTransform(xScale, 0.0, 0.0, yScale, xTrans, yTrans);
        this.adjustingShape = this.roi[roiNum];
        this.adjustingShape.setShapeTransform(this.shapeTransform);
        this.isAdjusting = true;
    }

    private synchronized void startVideoCaptureTimer() {
        this.stopVideoCaptureTimer();
        this.videoCaptureTimer = new Timer();
        TimerTask videoCaptureTask = new TimerTask(){

            @Override
            public void run() {
                ScreenSlice.this.captureVideo();
            }
        };
        this.videoCaptureTimer.scheduleAtFixedRate(videoCaptureTask, 0L, (long)(1000 / this.videoCaptureFps));
    }

    private synchronized void stopVideoCaptureTimer() {
        if (this.videoCaptureTimer != null) {
            this.videoCaptureTimer.cancel();
            this.videoCaptureTimer = null;
        }
    }

    private void updateAdjustingRealShape() {
        this.realShapeAdjusted = true;
        this.adjustingRealShapeStartPoint.setLocation(this.currentCursorX, this.currentCursorY);
    }

    private void updateAdjustingRealShapePoint() {
        this.checkBoundsCurrentLocation();
        double xScale = (double)(this.adjustingRealShapeBounds.width + (this.currentCursorX - this.adjustingRealShapeStartPoint.x)) / (double)this.adjustingRealShapeBounds.width;
        double yScale = (double)(this.adjustingRealShapeBounds.height + (this.currentCursorY - this.adjustingRealShapeStartPoint.y)) / (double)this.adjustingRealShapeBounds.height;
        double xTrans = (double)this.adjustingRealShapeBounds.x - (double)this.adjustingRealShapeBounds.x * xScale;
        double yTrans = (double)this.adjustingRealShapeBounds.y - (double)this.adjustingRealShapeBounds.y * yScale;
        this.adjustingRealShape.setTransform(xScale, 0.0, 0.0, yScale, xTrans, yTrans);
        this.repaint();
    }

    private void updateAdjustingSelectionShape() {
        this.selectionShapeAdjusted = true;
        this.selectionShapeStartPoint.setLocation(this.currentCursorX, this.currentCursorY);
    }

    private void updateAdjustingShape(ROIShape shape, int grabLocation, int num) {
        this.shapeAdjusted = true;
        this.isAdjusting = true;
        this.adjustingNum = num;
        this.adjustingShape = shape;
        this.adjustingShapeBounds = shape.getBounds();
        try {
            if (grabLocation == 6) {
                this.finalTransform.inverseTransform(this.southEastHandle[num], this.tempTransformedPoint);
            } else if (grabLocation == 4) {
                this.finalTransform.inverseTransform(this.southHandle[num], this.tempTransformedPoint);
            } else if (grabLocation == 12) {
                this.finalTransform.inverseTransform(this.southWestHandle[num], this.tempTransformedPoint);
            } else if (grabLocation == 8) {
                this.finalTransform.inverseTransform(this.westHandle[num], this.tempTransformedPoint);
            } else if (grabLocation == 9) {
                this.finalTransform.inverseTransform(this.northWestHandle[num], this.tempTransformedPoint);
            } else if (grabLocation == 1) {
                this.finalTransform.inverseTransform(this.northHandle[num], this.tempTransformedPoint);
            } else if (grabLocation == 3) {
                this.finalTransform.inverseTransform(this.northEastHandle[num], this.tempTransformedPoint);
            } else if (grabLocation == 2) {
                this.finalTransform.inverseTransform(this.eastHandle[num], this.tempTransformedPoint);
            } else if (grabLocation == 16) {
                this.tempTransformedPoint.setLocation(this.current.x, this.current.y);
            }
        }
        catch (NoninvertibleTransformException ex) {
            AppLogger.warn((Throwable)ex);
        }
        this.adjustingShapeGrabPoint.setLocation(this.tempTransformedPoint);
    }

    private void updateBoundsAndHandles(int ctr) {
        this.updateBoundsAndHandles(ctr, null);
    }

    private void updateBoundsAndHandles(int ctr, AffineTransform useTransformVal) {
        AffineTransform useTransform = useTransformVal;
        if (useTransform == null) {
            useTransform = this.finalTransform;
        }
        Rectangle currentBounds = this.roi[ctr].getBounds();
        this.selectedHasBounds[ctr] = currentBounds.width > 0 && currentBounds.height > 0;
        this.bounds[ctr] = useTransform.createTransformedShape(currentBounds).getBounds();
        this.northHandle[ctr].setLocation(this.bounds[ctr].x + this.bounds[ctr].width / 2 - 1, this.bounds[ctr].y - 2);
        this.northEastHandle[ctr].setLocation(this.bounds[ctr].x + this.bounds[ctr].width - 1, this.bounds[ctr].y - 2);
        this.eastHandle[ctr].setLocation(this.bounds[ctr].x + this.bounds[ctr].width - 1, this.bounds[ctr].y + this.bounds[ctr].height / 2 - 2);
        this.southEastHandle[ctr].setLocation(this.bounds[ctr].x + this.bounds[ctr].width - 1, this.bounds[ctr].y + this.bounds[ctr].height - 2);
        this.southHandle[ctr].setLocation(this.bounds[ctr].x + this.bounds[ctr].width / 2 - 1, this.bounds[ctr].y + this.bounds[ctr].height - 2);
        this.southWestHandle[ctr].setLocation(this.bounds[ctr].x - 1, this.bounds[ctr].y + this.bounds[ctr].height - 2);
        this.westHandle[ctr].setLocation(this.bounds[ctr].x - 1, this.bounds[ctr].y + this.bounds[ctr].height / 2 - 2);
        this.northWestHandle[ctr].setLocation(this.bounds[ctr].x - 1, this.bounds[ctr].y - 2);
        this.handlesPath[ctr].reset();
        this.handle.setFrame(this.northHandle[ctr].x - 1, this.northHandle[ctr].y - 1, 4.0, 4.0);
        this.handlesPath[ctr].append(this.handle, false);
        this.handle.setFrame(this.northEastHandle[ctr].x - 1, this.northEastHandle[ctr].y - 1, 4.0, 4.0);
        this.handlesPath[ctr].append(this.handle, false);
        this.handle.setFrame(this.eastHandle[ctr].x - 1, this.eastHandle[ctr].y - 1, 4.0, 4.0);
        this.handlesPath[ctr].append(this.handle, false);
        this.handle.setFrame(this.southEastHandle[ctr].x - 1, this.southEastHandle[ctr].y - 1, 4.0, 4.0);
        this.handlesPath[ctr].append(this.handle, false);
        this.handle.setFrame(this.southHandle[ctr].x - 1, this.southHandle[ctr].y - 1, 4.0, 4.0);
        this.handlesPath[ctr].append(this.handle, false);
        this.handle.setFrame(this.southWestHandle[ctr].x - 1, this.southWestHandle[ctr].y - 1, 4.0, 4.0);
        this.handlesPath[ctr].append(this.handle, false);
        this.handle.setFrame(this.westHandle[ctr].x - 1, this.westHandle[ctr].y - 1, 4.0, 4.0);
        this.handlesPath[ctr].append(this.handle, false);
        this.handle.setFrame(this.northWestHandle[ctr].x - 1, this.northWestHandle[ctr].y - 1, 4.0, 4.0);
        this.handlesPath[ctr].append(this.handle, false);
    }

    private void updateCurrentLocation(Point point) {
        this.currentCursorX = point.x;
        this.currentCursorY = point.y;
        try {
            this.finalTransform.inverseTransform(point, this.tempTransformedPoint);
            this.current.setLocation((int)this.tempTransformedPoint.getX(), (int)this.tempTransformedPoint.getY());
        }
        catch (Exception ex) {
            AppLogger.warn((Throwable)ex);
        }
    }

    private void updatePolyLine(boolean mousePressed, Point point) {
        if (this.viewer == null) {
            return;
        }
        int polyCursorX = (int)((double)point.x + 0.5);
        int polyCursorY = (int)((double)point.y + 0.5);
        if (this.isUpdatingPolyLine) {
            this.polyLinePath.lineTo(polyCursorX, polyCursorY);
            if (this.isLOIMode) {
                this.isUpdatingLOI = true;
            }
            if (this.polyLineStart.distance(polyCursorX, polyCursorY) >= 4.0) {
                this.polyLineCloseArmed = true;
            }
            if (this.isLOIMode) {
                if (this.polyLineCloseArmed && this.polyLineStart.distance(polyCursorX, polyCursorY) < 4.0) {
                    this.polyLinePath.closePath();
                    this.makeLOI();
                }
            } else if (this.polyLineCloseArmed && this.polyLineStart.distance(polyCursorX, polyCursorY) < 4.0) {
                this.polyLinePath.closePath();
                Shape shapeTransformed = null;
                try {
                    shapeTransformed = this.finalTransform.createInverse().createTransformedShape(this.polyLinePath);
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
                if (shapeTransformed != null) {
                    this.viewer.getROIManager().setShape(this.currentSlice, this.sliceDirection, shapeTransformed, true, this.useSmartTools(), this.mango.getSmartToolsRangeMin(), this.mango.getSmartToolsRangeMax());
                }
                this.polyLinePath = null;
                this.polyLineStart = null;
                this.viewer.updateROISlices();
                this.viewer.repaint();
                this.updateROIShape();
                this.isUpdatingPolyLine = false;
                this.polyLineCloseArmed = false;
            }
            this.polyLineLast.setLocation(polyCursorX, polyCursorY);
        } else if (mousePressed) {
            this.polyLinePath = new GeneralPath();
            this.polyLinePath.moveTo(polyCursorX, polyCursorY);
            this.polyLineStart = new Point(polyCursorX, polyCursorY);
            this.isUpdatingPolyLine = true;
            this.polyLineLast.setLocation(polyCursorX, polyCursorY);
        }
    }

    private void updatePolyLinePath(double scaleXOld, double scaleXNew, double scaleYOld, double scaleYNew) {
        this.polyLineScreenTransform.setTransform(scaleXNew / scaleXOld, 0.0, 0.0, scaleYNew / scaleYOld, 0.0, 0.0);
        this.polyLinePath.transform(this.polyLineScreenTransform);
        this.polyLineScreenTransform.transform(this.polyLineStart, this.polyLineStart);
    }

    private void updateRadiologicalImage(BufferedImage image) {
        if (this.radiologicalFiltered == null) {
            this.radiologicalFiltered = new BufferedImage(this.xDim, this.yDim, 2);
        }
        AffineTransformOp scaleOp = new AffineTransformOp(this.radiologicalTransform, 1);
        scaleOp.filter(image, this.radiologicalFiltered);
    }

    private void updateROIShape(int updateSlice, AffineTransform useTransformVal) {
        if (this.viewer == null) {
            return;
        }
        AffineTransform useTransform = useTransformVal;
        if (useTransform == null) {
            useTransform = this.finalTransform;
        }
        if (this.viewer.getROIManager().hasROI()) {
            this.roi = this.viewer.getROIManager().getShape(updateSlice, this.sliceDirection, useTransform);
        }
        this.updateSelectedBoundsAndHandles(useTransform);
        this.incrementShapeFlag = false;
    }

    private void updateScaledBaseImage() {
        if (this.screenSliceFilteredScaled == null) {
            int w = (int)((double)this.xDim * this.getImageScaleX());
            int h = (int)((double)this.yDim * this.getImageScaleY());
            this.screenSliceFilteredScaled = new BufferedImage(w, h, 2);
        }
        AffineTransformOp scaleOp = null;
        scaleOp = this.useInterpolation() ? new AffineTransformOp(this.scaleFinalTransformImage, 2) : new AffineTransformOp(this.scaleFinalTransformImage, 1);
        scaleOp.filter(this.screenSliceFiltered, this.screenSliceFilteredScaled);
    }

    private void updateScaledDicomOverlayImage() {
        if (this.dicomOverlayScaled == null) {
            int w = (int)((double)this.xDim * this.getImageScaleX());
            int h = (int)((double)this.yDim * this.getImageScaleY());
            this.dicomOverlayScaled = new BufferedImage(w, h, 2);
        }
        AffineTransformOp scaleOp = new AffineTransformOp(this.scaleFinalNoRadioTransformImage, 1);
        scaleOp.filter(this.dicomOverlay, this.dicomOverlayScaled);
    }

    private void updateScaledHistogramImage() {
        if (this.histogramOverlayScaled == null) {
            int w = (int)((double)this.xDim * this.getImageScaleX());
            int h = (int)((double)this.yDim * this.getImageScaleY());
            this.histogramOverlayScaled = new BufferedImage(w, h, 2);
        }
        AffineTransformOp scaleOp = new AffineTransformOp(this.scaleFinalTransformImage, 1);
        scaleOp.filter(this.histogramOverlay, this.histogramOverlayScaled);
    }

    private void updateScaledOverlayImage(int index) {
        if (this.overlayScreenSliceFilteredScaled[index] == null) {
            int w = (int)((double)this.xDim * this.getImageScaleX());
            int h = (int)((double)this.yDim * this.getImageScaleY());
            this.overlayScreenSliceFilteredScaled[index] = new BufferedImage(w, h, 2);
        }
        AffineTransformOp scaleOp = null;
        scaleOp = this.useInterpolation() && this.overlays[index].getVolume().isAllowsLinearInterpolation() ? new AffineTransformOp(this.scaleFinalTransformImage, 2) : new AffineTransformOp(this.scaleFinalTransformImage, 1);
        scaleOp.filter(this.overlayScreenSliceFiltered[index], this.overlayScreenSliceFilteredScaled[index]);
    }

    private void updateScaledOverlayMixerImage() {
        if (this.overlayMixerScaled == null) {
            int w = (int)((double)this.xDim * this.getImageScaleX());
            int h = (int)((double)this.yDim * this.getImageScaleY());
            this.overlayMixerScaled = new BufferedImage(w, h, 2);
        }
        AffineTransformOp scaleOp = new AffineTransformOp(this.scaleFinalTransformImage, 1);
        scaleOp.filter(this.overlayMixer, this.overlayMixerScaled);
    }

    private void updateScreenSlice(int updateSlice, boolean updateTexture) {
        this.updateScreenSlice(updateSlice, null, updateTexture);
    }

    private void updateSelectedBoundsAndHandles(AffineTransform useTransformVal) {
        if (this.viewer == null) {
            return;
        }
        AffineTransform useTransform = useTransformVal;
        if (useTransform == null) {
            useTransform = this.finalTransform;
        }
        this.allSelectedBoundsPath.reset();
        Vector<Integer> selectedIndices = this.viewer.getROIManager().getSelectedIndices(false, false);
        for (int ctr : selectedIndices) {
            if (!this.viewer.isShowingROI() || !this.viewer.isSelected(this, this.currentSlice, this.sliceDirection, ctr)) continue;
            this.updateBoundsAndHandles(ctr, useTransform);
            this.allSelectedBoundsPath.append(this.bounds[ctr], false);
        }
    }

    private void updateSelectionBox() {
        this.checkBoundsCurrentLocation();
        double xScale = (double)(this.selectionShapeBounds.width + (this.checkBoundsPoint.x - this.selectionShapeStartPoint.x)) / (double)this.selectionShapeBounds.width;
        double yScale = (double)(this.selectionShapeBounds.height + (this.checkBoundsPoint.y - this.selectionShapeStartPoint.y)) / (double)this.selectionShapeBounds.height;
        double xTrans = (double)this.selectionShapeBounds.x - (double)this.selectionShapeBounds.x * xScale;
        double yTrans = (double)this.selectionShapeBounds.y - (double)this.selectionShapeBounds.y * yScale;
        this.selectionShape.setTransform(xScale, 0.0, 0.0, yScale, xTrans, yTrans);
        this.repaint();
    }

    private void updateZoomTransform() {
        double zoomFactor = this.viewer.getZoomFactor();
        double xZoomTrans = 0.0;
        double yZoomTrans = 0.0;
        double xPanTrans = 0.0;
        double yPanTrans = 0.0;
        if (this.sliceDirection == 0) {
            xZoomTrans = ((double)this.viewer.getZoomLocationX() + 0.5) * (zoomFactor - 1.0) * -1.0;
            yZoomTrans = ((double)this.viewer.getZoomLocationY() + 0.5) * (zoomFactor - 1.0) * -1.0;
            xPanTrans = (double)this.viewer.getPanAmountX() * (zoomFactor - 1.0);
            yPanTrans = (double)this.viewer.getPanAmountY() * (zoomFactor - 1.0);
        } else if (this.sliceDirection == 1) {
            xZoomTrans = ((double)this.viewer.getZoomLocationX() + 0.5) * (zoomFactor - 1.0) * -1.0;
            yZoomTrans = ((double)this.viewer.getZoomLocationZ() + 0.5) * (zoomFactor - 1.0) * -1.0;
            xPanTrans = (double)this.viewer.getPanAmountX() * (zoomFactor - 1.0);
            yPanTrans = (double)this.viewer.getPanAmountZ() * (zoomFactor - 1.0);
        } else if (this.sliceDirection == 2) {
            xZoomTrans = ((double)this.viewer.getZoomLocationY() + 0.5) * (zoomFactor - 1.0) * -1.0;
            yZoomTrans = ((double)this.viewer.getZoomLocationZ() + 0.5) * (zoomFactor - 1.0) * -1.0;
            xPanTrans = (double)this.viewer.getPanAmountY() * (zoomFactor - 1.0);
            yPanTrans = (double)this.viewer.getPanAmountZ() * (zoomFactor - 1.0);
        }
        double xTrans = xZoomTrans + xPanTrans;
        double yTrans = yZoomTrans + yPanTrans;
        double maxTranslateX = -(zoomFactor - 1.0) * (double)this.xDim;
        if (xTrans > 0.0) {
            xTrans = 0.0;
        } else if (xTrans < maxTranslateX) {
            xTrans = maxTranslateX;
        }
        double maxTranslateY = -(zoomFactor - 1.0) * (double)this.yDim;
        if (yTrans > 0.0) {
            yTrans = 0.0;
        } else if (yTrans < maxTranslateY) {
            yTrans = maxTranslateY;
        }
        if (this.sliceDirection == 0) {
            this.viewer.setPanAmountX((int)Math.round((xTrans - xZoomTrans) / (zoomFactor - 1.0)));
            this.viewer.setPanAmountY((int)Math.round((yTrans - yZoomTrans) / (zoomFactor - 1.0)));
        } else if (this.sliceDirection == 1) {
            this.viewer.setPanAmountX((int)Math.round((xTrans - xZoomTrans) / (zoomFactor - 1.0)));
            this.viewer.setPanAmountZ((int)Math.round((yTrans - yZoomTrans) / (zoomFactor - 1.0)));
        } else if (this.sliceDirection == 2) {
            this.viewer.setPanAmountY((int)Math.round((xTrans - xZoomTrans) / (zoomFactor - 1.0)));
            this.viewer.setPanAmountZ((int)Math.round((yTrans - yZoomTrans) / (zoomFactor - 1.0)));
        }
        this.zoomTransform.setTransform(zoomFactor, 0.0, 0.0, zoomFactor, xTrans, yTrans);
        if (this.mango.isRadiologicalMode() && this.isRadiologicalSensitive()) {
            this.zoomTransform2.setTransform(zoomFactor, 0.0, 0.0, zoomFactor, maxTranslateX - xTrans, yTrans);
        } else {
            this.zoomTransform2.setTransform(zoomFactor, 0.0, 0.0, zoomFactor, xTrans, yTrans);
        }
        if (this.mango.isRadiologicalMode() && this.isRadiologicalSensitive()) {
            this.zoomTransformImage.setTransform(zoomFactor, 0.0, 0.0, zoomFactor, (maxTranslateX - xTrans) * this.scaleTransform.getScaleX(), yTrans * this.scaleTransform.getScaleY());
        } else {
            this.zoomTransformImage.setTransform(zoomFactor, 0.0, 0.0, zoomFactor, xTrans * this.scaleTransform.getScaleX(), yTrans * this.scaleTransform.getScaleY());
        }
    }

    private boolean useInterpolation() {
        return !Mango.isVoxelDisplay() && !this.viewer.isVoxelDisplayMode();
    }

    private boolean useSmartTools() {
        return this.mango.isUsingSmartTools() && (!this.mango.isUsingSmartToolsToggle() || this.isShiftDown);
    }
}

