/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.screen;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.ScreenImage;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayManagerListener;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.volume.Volume;
import java.lang.ref.WeakReference;
import java.util.Vector;
import org.apache.commons.lang3.ArrayUtils;

public class OverlayManager {
    private Vector<WeakReference<OverlayManagerListener>> listeners = new Vector();
    private final ScreenVolume[] overlays = new ScreenVolume[8];
    public static final int MAX_NUM = 8;

    public void addListener(OverlayManagerListener oml) {
        this.listeners.add(new WeakReference<OverlayManagerListener>(oml));
    }

    public void removeListener(OverlayManagerListener searchOml) {
        WeakReference<OverlayManagerListener> foundRef = null;
        for (int ctr = 0; ctr < this.listeners.size(); ++ctr) {
            WeakReference<OverlayManagerListener> ref = this.listeners.get(ctr);
            OverlayManagerListener oml = (OverlayManagerListener)ref.get();
            if (oml != searchOml) continue;
            foundRef = ref;
            break;
        }
        this.listeners.remove(foundRef);
    }

    public void addOverlay(ScreenVolume overlay) {
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] != null) continue;
            this.overlays[ctr] = overlay;
            overlay.setLoaded(true);
            this.notifyListenersOfAddition(overlay);
            break;
        }
    }

    public void clear() {
        this.listeners.clear();
        this.listeners = null;
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] == null) continue;
            this.overlays[ctr].clear();
        }
    }

    public ScreenVolume[] getAllOverlays() {
        return this.overlays;
    }

    public int getIndex(ScreenVolume overlay) {
        int index = -1;
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] != overlay) continue;
            index = ctr;
        }
        return index;
    }

    public int getIndex(Volume overlay) {
        int index = -1;
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] == null || this.overlays[ctr].getVolume() != overlay) continue;
            index = ctr;
        }
        return index;
    }

    public String getNextLUTType() {
        int numMagentaUsed = 0;
        int numCyanUsed = 0;
        int numBlueUsed = 0;
        int numGreenUsed = 0;
        int numRedUsed = 0;
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] == null) continue;
            if (this.overlays[ctr].lutManager.getName().equals(Mango.getInstance().getOverlayColorTable1()) || this.overlays[ctr].lutManager.getName().equals("Red")) {
                ++numRedUsed;
            }
            if (this.overlays[ctr].lutManager.getName().equals(Mango.getInstance().getOverlayColorTable2()) || this.overlays[ctr].lutManager.getName().equals("Green")) {
                ++numGreenUsed;
            }
            if (!this.overlays[ctr].lutManager.getName().equals(Mango.getInstance().getOverlayColorTable3()) && !this.overlays[ctr].lutManager.getName().equals("Blue")) continue;
            ++numBlueUsed;
        }
        if (numRedUsed <= numGreenUsed && numRedUsed <= numBlueUsed && numRedUsed <= numCyanUsed && numRedUsed <= numMagentaUsed) {
            return Mango.getInstance().getOverlayColorTable1();
        }
        if (numGreenUsed <= numRedUsed && numGreenUsed <= numBlueUsed && numGreenUsed <= numCyanUsed && numGreenUsed <= numMagentaUsed) {
            return Mango.getInstance().getOverlayColorTable2();
        }
        if (numBlueUsed <= numRedUsed && numBlueUsed <= numGreenUsed && numBlueUsed <= numCyanUsed && numBlueUsed <= numMagentaUsed) {
            return Mango.getInstance().getOverlayColorTable3();
        }
        return Mango.getInstance().getOverlayColorTable1();
    }

    public int getNumInStack() {
        int num = 0;
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] == null) continue;
            ++num;
        }
        return num;
    }

    public ScreenVolume getOverlay(int index) {
        return this.overlays[index];
    }

    public ScreenVolume getOverlay(Volume volume) {
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] == null || this.overlays[ctr].getVolume() != volume) continue;
            return this.overlays[ctr];
        }
        return null;
    }

    public Vector<ScreenImage> getScreenImages() {
        Vector<ScreenImage> vec = new Vector<ScreenImage>();
        for (ScreenVolume overlay : this.overlays) {
            if (overlay == null) continue;
            vec.add(overlay);
        }
        return vec;
    }

    public void hideAll() {
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] == null) continue;
            this.overlays[ctr].setHidden(true);
        }
    }

    public void moveOverlayDown(ScreenVolume overlay) {
        ScreenVolume volDownOne;
        int index = -1;
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] != overlay) continue;
            index = ctr;
        }
        if (index > 0 && (volDownOne = this.overlays[index - 1]) != null) {
            this.overlays[index] = volDownOne;
            this.overlays[index - 1] = overlay;
        }
    }

    public void setOverlayIndex(ScreenVolume overlay, int indexNew) {
        int ctr;
        int index = -1;
        for (int ctr2 = 0; ctr2 < 8; ++ctr2) {
            if (this.overlays[ctr2] != overlay) continue;
            index = ctr2;
        }
        Object[] arrayRemoved = (ScreenVolume[])ArrayUtils.remove((Object[])this.overlays, (int)index);
        ScreenVolume[] arrayInserted = (ScreenVolume[])ArrayUtils.add((Object[])arrayRemoved, (int)indexNew, (Object)overlay);
        int index2 = 0;
        for (ctr = 0; ctr < 8; ++ctr) {
            if (arrayInserted[ctr] == null) continue;
            this.overlays[index2++] = arrayInserted[ctr];
        }
        for (ctr = index2; ctr < 8; ++ctr) {
            this.overlays[ctr] = null;
        }
    }

    public void moveOverlayUp(ScreenVolume overlay) {
        ScreenVolume volUpOne;
        int index = -1;
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] != overlay) continue;
            index = ctr;
        }
        if (index >= 0 && index < 6 && (volUpOne = this.overlays[index + 1]) != null) {
            this.overlays[index] = volUpOne;
            this.overlays[index + 1] = overlay;
        }
    }

    public void removeOverlay(ScreenVolume overlay) {
        int ctr;
        int index = -1;
        for (ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] != overlay) continue;
            index = ctr;
        }
        if (index >= 0) {
            this.overlays[index].clear();
            this.overlays[index] = null;
            for (ctr = 1; ctr < 8; ++ctr) {
                if (this.overlays[ctr - 1] != null) continue;
                this.overlays[ctr - 1] = this.overlays[ctr];
                this.overlays[ctr] = null;
            }
        }
        this.notifyListenersOfRemoval(overlay);
        JVMUtilities.clearGarbage();
    }

    public void showAll() {
        for (int ctr = 0; ctr < 8; ++ctr) {
            if (this.overlays[ctr] == null) continue;
            this.overlays[ctr].setHidden(false);
        }
    }

    private void notifyListenersOfAddition(ScreenVolume vol) {
        for (int ctr = 0; ctr < this.listeners.size(); ++ctr) {
            WeakReference<OverlayManagerListener> ref = this.listeners.get(ctr);
            OverlayManagerListener oml = (OverlayManagerListener)ref.get();
            if (oml == null) continue;
            oml.overlayAdded(vol);
        }
    }

    private void notifyListenersOfRemoval(ScreenVolume vol) {
        for (int ctr = 0; ctr < this.listeners.size(); ++ctr) {
            WeakReference<OverlayManagerListener> ref = this.listeners.get(ctr);
            OverlayManagerListener oml = (OverlayManagerListener)ref.get();
            if (oml == null) continue;
            oml.overlayRemoved(vol);
        }
    }
}

