/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.operations;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.roi.Line;
import edu.uthscsa.ric.volume.VolumeData;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Vector;

public class LineOps {
    private final VolumeManager user;

    public LineOps(VolumeManager user) {
        this.user = user;
    }

    public double[] getValues(Line line, boolean millimeter, double multiplier) {
        Vector points = null;
        points = millimeter ? line.makeInterpolatedPointsMM(multiplier) : line.makeInterpolatedPoints();
        double[] values = new double[points.size()];
        Iterator it = points.iterator();
        int sliceDirection = line.getSliceDirection();
        int sliceNum = line.getSliceNum();
        VolumeData volData = new VolumeData(this.user);
        double xSize = this.user.getBaseVolume().getXSize();
        double ySize = this.user.getBaseVolume().getYSize();
        double zSize = this.user.getBaseVolume().getZSize();
        int index = 0;
        while (it.hasNext()) {
            double ctrZ;
            double ctrY;
            double ctrX;
            Point2D currentPoint = (Point2D)it.next();
            if (sliceDirection == 0) {
                ctrX = currentPoint.getX();
                ctrY = currentPoint.getY();
                ctrZ = sliceNum;
            } else if (sliceDirection == 1) {
                ctrX = currentPoint.getX();
                ctrY = sliceNum;
                ctrZ = currentPoint.getY();
            } else {
                ctrX = sliceNum;
                ctrY = currentPoint.getX();
                ctrZ = currentPoint.getY();
            }
            if (millimeter) {
                if (sliceDirection == 0) {
                    ctrZ *= zSize;
                } else if (sliceDirection == 1) {
                    ctrY *= ySize;
                } else {
                    ctrX *= xSize;
                }
                values[index++] = volData.getValueMM(ctrX, ctrY, ctrZ);
                continue;
            }
            values[index++] = volData.getValue((int)ctrX, (int)ctrY, (int)ctrZ);
        }
        return values;
    }
}

