/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.menus.context;

import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ContextMenuListener;
import edu.uthscsa.ric.roi.points.POI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;

public class PointContextMenuActions
extends AbstractAction {
    private final ContextMenuListener listener;
    private final SliceViewer viewer;
    private final POI point;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_ANALYZE = "Analyze";
    public static final String ACTION_DELETE = "Delete";
    public static final String ACTION_EDIT_LABEL = "Edit Label...";

    protected PointContextMenuActions(SliceViewer viewer, ContextMenuListener listener, POI point, String actionName) {
        super(actionName);
        this.viewer = viewer;
        this.listener = listener;
        this.point = point;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals(ACTION_ANALYZE)) {
            this.doAnalyze();
        } else if (actionCommand.equals(ACTION_DELETE)) {
            this.doDelete();
        } else if (actionCommand.equals(ACTION_EDIT_LABEL)) {
            this.doEditLabel();
        }
    }

    private void doAnalyze() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                PointContextMenuActions.this.viewer.runStat(PointContextMenuActions.this.point);
            }
        });
        workThread.start();
        this.notifyListener();
    }

    private void doDelete() {
        this.viewer.doDeleteROI(this.point, true);
        this.notifyListener();
    }

    private void doEditLabel() {
        String name;
        String currentName = this.point.getName();
        if (StringUtils.isBlank((CharSequence)currentName)) {
            currentName = "";
        }
        if ((name = (String)JOptionPane.showInputDialog(this.viewer.getViewerFrame(), "Enter New Label", "", -1, null, null, currentName)) != null) {
            this.viewer.setLabel(this.point, name);
        }
        this.notifyListener();
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.contextMenuItemSelected();
        }
    }
}

