/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.menus.context;

import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ContextMenuListener;
import edu.uthscsa.ric.mango.viewerslice.menus.context.ImageContextMenuActions;
import edu.uthscsa.ric.volume.Bookmark;
import edu.uthscsa.ric.volume.Coordinate4D;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public final class ImageContextMenu
extends JPopupMenu {
    private final ContextMenuListener listener;
    private final SliceViewer viewer;
    private final Coordinate4D coordinate;
    private static ImageContextMenu menu;
    private static final long serialVersionUID = 1L;
    public static final Font FONT;

    public static void doPop(SliceViewer viewer, ContextMenuListener listener, Component comp, Coordinate4D coordinate, Point loc) {
        menu = new ImageContextMenu(viewer, listener, coordinate);
        menu.show(comp, loc.x, loc.y);
    }

    private ImageContextMenu(SliceViewer viewer, ContextMenuListener listener, Coordinate4D coordinate) {
        this.viewer = viewer;
        this.listener = listener;
        this.coordinate = coordinate;
        this.add(this.makeMenuItem("Analyze"));
        this.add(new JToolBar.Separator(new Dimension(0, 6)));
        this.add(this.makeMenuItem("Go To..."));
        this.add(this.makeMenuItem("Bookmark..."));
        JMenu loggedMenu = new JMenu("Bookmarks");
        loggedMenu.setFont(FONT);
        this.add(loggedMenu);
        List<Bookmark> points = viewer.getVolume().getBookmarks();
        for (Bookmark point : points) {
            JMenuItem item = this.makeMenuItem("GoTo " + point.getLabel());
            item.setText(point.getLabel());
            item.setActionCommand("GoTo " + point.hashCode());
            loggedMenu.add(item);
        }
        if (points.size() > 0) {
            loggedMenu.add(new JToolBar.Separator(new Dimension(0, 6)));
        }
        loggedMenu.add(this.makeMenuItem("Delete"));
        loggedMenu.add(this.makeMenuItem("Delete All"));
    }

    private JMenuItem makeMenuItem(String actionName) {
        JMenuItem menuItem = new JMenuItem(new ImageContextMenuActions(this.viewer, this.listener, this.coordinate, actionName));
        menuItem.setFont(FONT);
        return menuItem;
    }

    static {
        FONT = new Font("SansSerif", 0, 11);
    }
}

