/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.menus;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoDropDownButton;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPaneUser;
import edu.uthscsa.ric.mango.dialogs.dicomchooser.DicomChooser;
import edu.uthscsa.ric.mango.dialogs.faq.GettingStarted;
import edu.uthscsa.ric.mango.dialogs.modal.AddImageDialog;
import edu.uthscsa.ric.mango.dialogs.modal.ColorTableManagerDialog;
import edu.uthscsa.ric.mango.dialogs.modal.FilterManagerDialog;
import edu.uthscsa.ric.mango.dialogs.modal.LicenseDialog;
import edu.uthscsa.ric.mango.dialogs.modal.NavigationReferenceDialog;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.dialogs.modal.RawImageDialog;
import edu.uthscsa.ric.mango.dialogs.modal.URLLoaderDialog;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.modal.preferences.PreferencesDialog;
import edu.uthscsa.ric.mango.dialogs.modal.utilities.InstallUtilitiesDialog;
import edu.uthscsa.ric.mango.dialogs.script.ScriptManager;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerprojection.dialogs.modal.BuildProjectionDialog;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cine.CineSlice;
import edu.uthscsa.ric.mango.viewerslice.dialogs.histogram.HistogramPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.histogram.HistogramTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.FileSaveAsChooser;
import edu.uthscsa.ric.mango.viewerslice.dialogs.modal.ROISliceRangeDialog;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.Webpage;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.viewersurface.dialogs.modal.BuildSurfaceDialog;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceReader;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.URLUtilities;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.FilterException;
import edu.uthscsa.ric.volume.operations.filter.FilterManager;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ViewerMenuAction
extends AbstractAction {
    public static final String TEXT_SAVE = "Save";
    private final Mango mango;
    private final SliceViewer viewer;
    private final URI file;
    private final Window frame;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_CANCEL = "Cancel";
    public static final String ANALYSIS_OPTION_CLUSTER = "Find Overlay Clusters";
    public static final String ANALYSIS_OPTION_CROSSSECTION = "Cross-section";
    public static final String ANALYSIS_OPTION_HISTOGRAM = "Histogram";
    public static final String ANALYSIS_OPTION_ROI_COMPONENTS = "Find ROI Components";
    public static final String ANALYSIS_OPTION_SERIES = "Series";
    public static final String EDIT_OPTION_COPY = "Copy";
    public static final String EDIT_OPTION_CUT = "Cut";
    public static final String EDIT_OPTION_DELETE = "Delete";
    public static final String EDIT_OPTION_DESELECT_ALL = "Deselect All";
    public static final String EDIT_OPTION_PASTE = "Paste";
    public static final String EDIT_OPTION_REDO = "Redo";
    public static final String EDIT_OPTION_SELECT_ALL = "Select All";
    public static final String EDIT_OPTION_UNDO = "Undo";
    public static final String FILE_OPTION_IMAGE_INFO = "Image Info";
    public static final String FILE_OPTION_REMOVE_OVERLAYS = "Remove Overlays";
    public static final String FILE_OPTION_SHOW_FILE = "Show File";
    public static final String IMAGE_OPTION_LAYOUT = "Create Layout...";
    public static final String IMAGE_OPTION_SNAPSHOT = "Create Snapshot...";
    public static final String IMAGE_OPTION_TRANSFORM = "Transform...";
    public static final String TEXT_BUILD_OPTIONS = "Build Options";
    public static final String TEXT_ERROR_IMAGE_URL = "There was a problem opening that image URL!\n";
    public static final String TEXT_OPEN_IMAGE_ERROR = "Open Image Error";
    public static final String TEXT_ROI_OPERATION_FAILED = "ROI Operation Failed";
    public static final String VIEW_OPTION_ANGLE = "Angle";
    public static final String VIEW_OPTION_CROSSHAIRS_LOWER = "Lower Crosshairs";
    public static final String VIEW_OPTION_CROSSHAIRS_MAIN = "Main Crosshairs";
    public static final String VIEW_OPTION_DISPLAY_ORTHO_TALL = "Orthogonal (Tall)";
    public static final String VIEW_OPTION_DISPLAY_ORTHO_WIDE = "Orthogonal (Wide)";
    public static final String VIEW_OPTION_DISPLAY_SLICE = "Slice";
    public static final String VIEW_OPTION_ORIENTATION = "Orientation";
    public static final String VIEW_OPTION_RULER = "Ruler";
    public static final String VIEW_OPTION_SHOW_ALL_OVERLAYS = "All Overlays";
    public static final String VIEW_OPTION_SHOW_LABELS = "Labels";
    public static final String VIEW_OPTION_SHOW_OVERLAY_CURRENT = "Current Overlay";
    public static final String VIEW_OPTION_SHOW_ROI_EDGE = "ROI Edge";
    public static final String VIEW_OPTION_SHOW_ROI_MASK = "ROI Mask";
    public static final String VIEW_OPTION_SHOW_ROI_STATS = "ROI Slice Stats";
    public static final String VIEW_OPTION_SLICE_DIRECTION_AXIAL = "Set Main Slice Axial";
    public static final String VIEW_OPTION_SLICE_DIRECTION_CORONAL = "Set Main Slice Coronal";
    public static final String VIEW_OPTION_SLICE_DIRECTION_SAGITTAL = "Set Main Slice Sagittal";
    public static final String VIEW_OPTION_DICOM_OVERLAY = "Annotations";
    public static final String VIEW_ZOOM_TOGGLE = "Toggle Zoom";
    public static final String WINDOW_OPTION_MAXIMIZE = "Maximize";
    public static final String WINDOW_OPTION_MINIMIZE = "Dock";
    public static final String WINDOW_OPTION_ZOOM_IN = "Zoom In";
    public static final String WINDOW_OPTION_ZOOM_OUT = "Zoom Out";

    public static File makeOpenFileChooser(String[] extensions, String dir, String description) {
        return OpenFileDialog.showOpenFileChooser(Mango.getInstance().getToolBox(), dir, extensions, description);
    }

    public static File makeSaveFileChooser(String dir, String filename) {
        return SaveFileDialog.showSaveFileChooser(Mango.getInstance().getToolBox(), dir, filename);
    }

    public static void showPreferences() {
        Frame frame = Mango.getInstance().getDialogParentFrame();
        final PreferencesDialog dialog = new PreferencesDialog(Mango.getInstance());
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, (Object)dialog, "Preferences", -1);
        final JOptionPane jop = jopf.getJOptionPane();
        JButton buttonOk = new JButton(TEXT_SAVE);
        buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
                boolean needUpdate = dialog.storePreferences();
                Mango.calculateScreenSliceTransforms();
                Mango.updateScreenTransforms();
                Mango.forceImageUpdate();
                Mango.updateAllViewers();
                Mango.updateAllSurfaces();
                Mango.getInstance().getResultsManager().updateTables();
                if (needUpdate) {
                    Mango.getInstance().showWarningDialog("One or more changes require a restart of the application. ", "Preferences Changed");
                }
            }
        });
        JButton buttonCancel = new JButton(ACTION_CANCEL);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(2);
                jop.setVisible(false);
            }
        });
        JButton buttonDefaults = new JButton("Defaults");
        buttonDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.restoreDefaults();
            }
        });
        Object[] options = new Object[]{buttonOk, buttonCancel, buttonDefaults};
        jopf.setOptions(options);
        jopf.setInitialValue(buttonOk);
        jopf.show(true);
    }

    public ViewerMenuAction(Mango mango) {
        this(null, mango, null, null, null);
    }

    public ViewerMenuAction(String name, Mango mango) {
        this(name, mango, null, null, null);
    }

    public ViewerMenuAction(String name, Mango mango, URI file) {
        this(name, mango, null, null, file);
    }

    protected ViewerMenuAction(String name, Mango mango, SliceViewer viewer) {
        this(name, mango, viewer, null, null);
    }

    public ViewerMenuAction(String name, Mango mango, SliceViewer viewer, Window frame) {
        this(name, mango, viewer, frame, null);
    }

    public ViewerMenuAction(String name, Mango mango, Window frame) {
        this(name, mango, null, frame, null);
    }

    private ViewerMenuAction(String name, Mango mango, SliceViewer viewer, Window frame, URI file) {
        super(name);
        this.mango = mango;
        this.viewer = viewer;
        this.frame = frame;
        this.file = file;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        block332: {
            String command = ae.getActionCommand();
            Object source = ae.getSource();
            if (this.frame != null) {
                this.frame.toFront();
            } else if (command.equals("Volume Stats")) {
                this.viewer.doActionVolumeStats();
            } else if (command.equals("Time-series Stats")) {
                this.viewer.doActionTimeseriesStats();
            } else if (command.equals("Time-series ROI Stats")) {
                this.viewer.doActionTimeseriesStatsROI();
            } else if (command.equals("Volume ROI Stats")) {
                this.viewer.doActionVolumeStatsROI();
            } else if (command.equals("Current Slice Stats")) {
                this.viewer.doActionSliceStats();
            } else if (command.equals("Current Slice ROI Stats")) {
                this.viewer.doActionSliceStatsROI();
            } else if (command.equals("All Slices Stats")) {
                this.viewer.doActionAllSliceStats();
            } else if (command.equals("All Volumes Stats")) {
                this.viewer.doActionAllVolumeStats();
            } else if (command.equals("All Slices ROI Stats")) {
                this.viewer.doActionAllSliceStatsROI();
            } else if (command.equals("All Volumes ROI Stats")) {
                this.viewer.doActionAllVolumeStatsROI();
            } else if (command.equals(VIEW_OPTION_SHOW_OVERLAY_CURRENT)) {
                this.viewer.setViewOptionShowCurrentOverlay(!this.viewer.isShowingCurrentOverlay());
            } else if (command.equals(VIEW_OPTION_SHOW_ALL_OVERLAYS)) {
                this.viewer.setViewOptionShowAllOverlays(!this.viewer.isShowingAllOverlay());
            } else if (command.equals("Hide Results") || command.equals("Show Results")) {
                JMenuItem menuItem = (JMenuItem)source;
                if (Mango.getInstance().getResultsManager().isVisible()) {
                    Mango.getInstance().getResultsManager().setVisible(false);
                    menuItem.setText("Show Results");
                } else {
                    if ((Mango.getInstance().getResultsManager().getState() & 1) != 0) {
                        Mango.getInstance().getResultsManager().setState(0);
                    }
                    Mango.getInstance().getResultsManager().setVisible(true);
                    menuItem.setText("Hide Results");
                }
            } else if (command.equals(VIEW_OPTION_SHOW_ROI_EDGE)) {
                this.viewer.setViewOptionROIEdge(!this.viewer.isShowingROIEdge() || this.viewer.isViewerHideROI());
            } else if (command.equals(VIEW_OPTION_SHOW_ROI_MASK)) {
                this.viewer.setViewOptionROIMask(!this.viewer.isShowingROIMask() || this.viewer.isViewerHideROI());
            } else if (command.equals("Build Projection...")) {
                BuildProjectionDialog dialog = new BuildProjectionDialog(this.viewer);
                MangoFocusableOptionPane jopf = null;
                jopf = this.mango.isApplet() ? new MangoFocusableOptionPane((MangoFocusableOptionPaneUser)((Object)Mango.getMangoApplet()), (Object)dialog, TEXT_BUILD_OPTIONS, -1) : new MangoFocusableOptionPane(this.viewer.getFrame(), (Object)dialog, TEXT_BUILD_OPTIONS, -1);
                int selection = jopf.show();
                if (selection == 0) {
                    if (this.viewer.getProjection() != null) {
                        this.viewer.getProjection().getProjectionView().clear();
                        this.viewer.setProjection(null);
                    }
                    this.viewer.buildProjection(dialog.getParameters());
                }
            } else if (command.equals("Build Surface...")) {
                SurfaceViewer renderer = this.viewer.getSurfaceRender();
                if (renderer != null) {
                    renderer.getFrame().setVisible(true);
                }
                final BuildSurfaceDialog dialog = new BuildSurfaceDialog(this.viewer);
                dialog.createSurfacePanel();
                final MangoFocusableOptionPane jopf = this.mango.isApplet() ? new MangoFocusableOptionPane((MangoFocusableOptionPaneUser)((Object)Mango.getMangoApplet()), (Object)dialog, TEXT_BUILD_OPTIONS, -1) : new MangoFocusableOptionPane(this.viewer.getFrame(), (Object)dialog, TEXT_BUILD_OPTIONS, -1);
                dialog.setDialog(jopf);
                final JOptionPane jOptionPane = jopf.getJOptionPane();
                JButton buttonOk = new JButton("OK");
                buttonOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (dialog.passZeroThresholdCheck()) {
                            jOptionPane.setValue(0);
                            jOptionPane.setVisible(false);
                        }
                    }
                });
                JButton buttonCancel = new JButton(ACTION_CANCEL);
                buttonCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        jOptionPane.setValue(2);
                        jOptionPane.setVisible(false);
                    }
                });
                JButton buttonLoad = new JButton("Load...");
                buttonLoad.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        File selectedFile = OpenFileDialog.showOpenFileChooser(jopf.getJDialog(), ViewerMenuAction.this.mango.getLoadFileDirectory(), SurfaceReader.getFormatExtensions(), "All Surface Files");
                        if (selectedFile != null) {
                            dialog.setVisible(false);
                            ViewerMenuAction.this.viewer.recordAction("loadSurface", new String[]{ScriptUtils.convertString(selectedFile.toString())}, true);
                            SurfaceReader sr = new SurfaceReader();
                            sr.readFile(selectedFile, ViewerMenuAction.this.viewer, ViewerMenuAction.this.viewer, true);
                            jOptionPane.setValue(2);
                            jOptionPane.setVisible(false);
                        }
                    }
                });
                Object[] options = null;
                options = this.mango.isApplet() ? new Object[]{buttonOk, buttonCancel} : new Object[]{buttonOk, buttonCancel, buttonLoad};
                jopf.setOptions(options);
                jopf.setInitialValue(buttonOk);
                int selection = jopf.show();
                if (selection == 0) {
                    this.viewer.buildSurface(dialog.getBuildParameters(), false);
                }
            } else if (command.equals(VIEW_OPTION_DISPLAY_ORTHO_TALL)) {
                this.viewer.setViewOptionDisplayOrthoTall();
            } else if (command.equals(VIEW_OPTION_DISPLAY_ORTHO_WIDE)) {
                this.viewer.setViewOptionDisplayOrthoWide();
            } else if (command.equals(VIEW_OPTION_DISPLAY_SLICE)) {
                this.viewer.setViewOptionDisplaySlice();
            } else if (command.equals(FILE_OPTION_IMAGE_INFO)) {
                this.viewer.showImageInfoDialog();
            } else if (command.equals(FILE_OPTION_SHOW_FILE)) {
                this.viewer.showFile();
            } else if (command.equals("User Guide")) {
                this.openUserGuide();
            } else if (command.equals("Getting Started")) {
                GettingStarted.showInFrame(this.mango);
            } else if (command.equals("Video Tutorials")) {
                DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//videos.html");
            } else if (command.equals("Quit")) {
                this.mango.exitProgram();
            } else if (command.equals("About Mango")) {
                this.mango.showAbout();
            } else if (command.equals("Preferences...")) {
                ViewerMenuAction.showPreferences();
            } else if (command.equals(VIEW_OPTION_CROSSHAIRS_MAIN)) {
                this.viewer.setViewOptionMainCrosshairs(!this.viewer.isShowingMainCrosshairs());
            } else if (command.equals(VIEW_OPTION_CROSSHAIRS_LOWER)) {
                this.viewer.setViewOptionLowerCrosshairs(!this.viewer.isShowingLowerCrosshairs());
            } else if (command.equals("Close")) {
                this.viewer.close();
            } else if (command.equals("Close All")) {
                this.mango.closeAllViewers();
                Mango.getInstance().getToolBox().disposeAssociatedWindows();
            } else if (command.equals(TEXT_SAVE)) {
                this.viewer.saveViewer(false);
            } else if (command.equals("Save As...")) {
                FileSaveAsChooser fileChooser = new FileSaveAsChooser(this.mango, this.viewer);
                int value = fileChooser.showSaveDialog(this.viewer);
                this.viewer.setShowPreview(false);
                if (value == 0) {
                    HistogramPanel hist = this.viewer.getHistogram();
                    if (hist != null) {
                        HistogramTool histogramTool = hist.getHistogramDialog();
                        hist.setParentFrame(null);
                        if (histogramTool != null) {
                            histogramTool.dispose();
                        }
                    }
                    if (fileChooser.isUsingFitPrecision() || fileChooser.isThreshold()) {
                        this.viewer.setSaveAsAfterRangeUpdate(fileChooser);
                        this.viewer.getBaseScreenVolume().getVolume().findRangeInBoundsAsync(this.viewer.getBaseScreenVolume(), fileChooser.getSelectedImageBounds());
                    } else {
                        File file = fileChooser.getSaveAsFile();
                        this.viewer.saveImageAs(file, fileChooser.getSelectedTransform(), fileChooser.getSelectedOverlay(), fileChooser.getOrientation(), fileChooser.getSelectedFileImageType(), fileChooser.getSelectedFileHeaderType(), fileChooser.isApplyDataScales(), fileChooser.isNearestNeighbor(), fileChooser.isTrilinear(), fileChooser.isSinc(), fileChooser.isThreshold(), fileChooser.isMix(), fileChooser.isCompress(), fileChooser.isUsingFitPrecision(), fileChooser.isMaintainZero(), fileChooser.getSelectedImageBounds(), fileChooser.getSelectedSizeX(), fileChooser.getSelectedSizeY(), fileChooser.getSelectedSizeZ(), fileChooser.getSelectedSizeT(), false);
                    }
                }
            } else if (command.equals("Reload")) {
                this.viewer.reloadImage();
            } else if (command.equals("Left-Right") || command.equals("Flip Left-Right")) {
                Volume baseVolume;
                Volume screenVolume = this.viewer.getCurrentScreenVolume().getVolume();
                if (screenVolume == (baseVolume = this.viewer.getBaseScreenVolume().getVolume())) {
                    this.viewer.flipAlongAxis(2);
                } else {
                    this.viewer.flipAlongAxis(screenVolume, 2);
                }
            } else if (command.equals("Anterior-Posterior") || command.equals("Flip Anterior-Posterior")) {
                Volume baseVolume;
                Volume screenVolume = this.viewer.getCurrentScreenVolume().getVolume();
                if (screenVolume == (baseVolume = this.viewer.getBaseScreenVolume().getVolume())) {
                    this.viewer.flipAlongAxis(1);
                } else {
                    this.viewer.flipAlongAxis(screenVolume, 1);
                }
            } else if (command.equals("Superior-Inferior") || command.equals("Flip Superior-Inferior")) {
                Volume baseVolume;
                Volume screenVolume = this.viewer.getCurrentScreenVolume().getVolume();
                if (screenVolume == (baseVolume = this.viewer.getBaseScreenVolume().getVolume())) {
                    this.viewer.flipAlongAxis(0);
                } else {
                    this.viewer.flipAlongAxis(screenVolume, 0);
                }
            } else if (command.equals("Origin...")) {
                this.viewer.editOrigin();
            } else if (command.equals("Voxel...")) {
                this.viewer.editPixel();
            } else if (command.equals("Notes...")) {
                this.viewer.editNotes();
            } else if (command.equals("Update to Image Range")) {
                this.viewer.updateImageRange();
            } else if (command.equals("Update to Series Range")) {
                this.viewer.updateSeriesRange();
            } else if (command.equals(EDIT_OPTION_CUT)) {
                this.viewer.doCut(false);
            } else if (command.equals(EDIT_OPTION_COPY)) {
                this.viewer.doCopy(false);
            } else if (command.equals(EDIT_OPTION_PASTE)) {
                this.viewer.doPaste(false);
            } else if (command.equals(EDIT_OPTION_SELECT_ALL)) {
                this.viewer.doSelectAll();
            } else if (command.equals(EDIT_OPTION_DESELECT_ALL)) {
                this.viewer.deselectAll();
            } else if (command.equals("Open Image...")) {
                this.openFile();
            } else if (command.equals("Open Online Image...")) {
                this.openFromURL(0);
            } else if (command.equals("Open Sample Image")) {
                File samplefile = Mango.unpackStandardImage();
                this.mango.addViewer(samplefile);
            } else if (command.equals("Load Online Overlay...")) {
                this.openFromURL(1);
            } else if (command.equals("Load Online ROI...")) {
                this.openFromURL(2);
            } else if (command.equals("Open DICOM Folder...")) {
                this.openDICOMFolder();
            } else if (command.equals("Open Raw Image...")) {
                final RawImageDialog dialog = new RawImageDialog(this.mango);
                Frame frame = Mango.getInstance().getDialogParentFrame();
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Open Raw Image", -1, null);
                final JOptionPane jOptionPane = jopf.getJOptionPane();
                JButton buttonOpen = new JButton("Open");
                buttonOpen.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        boolean success = dialog.openImage();
                        if (success) {
                            jOptionPane.setValue(0);
                            jOptionPane.setVisible(false);
                        }
                    }
                });
                JButton buttonCancel = new JButton(ACTION_CANCEL);
                buttonCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        jOptionPane.setValue(2);
                        jOptionPane.setVisible(false);
                    }
                });
                Object[] options = new Object[]{buttonOpen, buttonCancel};
                jopf.setOptions(options);
                jopf.setInitialValue(buttonOpen);
                jopf.show(true);
            } else if (command.equals("Add New Image...")) {
                final AddImageDialog dialog = new AddImageDialog(this.mango);
                Frame frame = Mango.getInstance().getDialogParentFrame();
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Add New Image", -1, null);
                final JOptionPane jOptionPane = jopf.getJOptionPane();
                JButton buttonOpen = new JButton("Add");
                buttonOpen.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        boolean success = dialog.addImage();
                        if (success) {
                            jOptionPane.setValue(0);
                            jOptionPane.setVisible(false);
                        }
                    }
                });
                JButton buttonCancel = new JButton(ACTION_CANCEL);
                buttonCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        jOptionPane.setValue(2);
                        jOptionPane.setVisible(false);
                    }
                });
                Object[] options = new Object[]{buttonOpen, buttonCancel};
                jopf.setOptions(options);
                jopf.setInitialValue(buttonOpen);
                jopf.show(true);
            } else if (command.equals("Load ROI...")) {
                File selectedFile = this.makeOpenFileChooser(null, "All Files");
                if (selectedFile != null) {
                    this.viewer.loadROI(selectedFile.toURI(), false);
                    this.mango.setLastAccessedDirectory(selectedFile.getParent());
                }
            } else if (command.equals("Add Overlay...")) {
                File selectedFile = this.makeOpenFileChooser(null, "All Files");
                this.mango.getToolBox().setSelectionMode(0);
                if (selectedFile != null) {
                    this.viewer.recordAction("addOverlay", new String[]{ScriptUtils.convertString(selectedFile.toString()), ScriptUtils.convertBoolean(false)}, true);
                    this.viewer.loadOverlay(selectedFile.toURI(), this.viewer.getOverlayManager().getNextLUTType(), false);
                    this.mango.setLastAccessedDirectory(selectedFile.getParent());
                }
            } else if (command.equals("Add Parametric Overlay...")) {
                File selectedFile = this.makeOpenFileChooser(null, "All Files");
                if (selectedFile != null) {
                    this.viewer.recordAction("addOverlay", new String[]{ScriptUtils.convertString(selectedFile.toString()), ScriptUtils.convertBoolean(true)}, true);
                    this.viewer.loadOverlay(selectedFile.toURI(), this.viewer.getOverlayManager().getNextLUTType(), true);
                    this.mango.setLastAccessedDirectory(selectedFile.getParent());
                }
            } else if (this.file != null) {
                if (FileUtilities.uriIsFile((URI)this.file)) {
                    File aFile = null;
                    aFile = this.file.isAbsolute() ? new File(this.file) : new File(this.file.toString());
                    if (aFile.exists()) {
                        if (aFile.isDirectory()) {
                            this.makeDICOMChooser(aFile);
                        } else {
                            this.mango.addViewer(aFile);
                        }
                    } else {
                        this.openFile(aFile.getParent());
                    }
                } else {
                    this.openImageURL(this.file.toString());
                }
            } else if (command.equals("Overlay Onto...")) {
                this.viewer.showOverlayOntoDialog();
            } else if (command.equals(WINDOW_OPTION_MINIMIZE)) {
                this.viewer.selectWindowMenuOptionMinimize();
            } else if (command.equals(WINDOW_OPTION_MAXIMIZE)) {
                this.viewer.selectWindowMenuOptionMaximize();
            } else if (command.equals(WINDOW_OPTION_ZOOM_IN)) {
                this.viewer.selectWindowMenuOptionZoomIn();
            } else if (command.equals(WINDOW_OPTION_ZOOM_OUT)) {
                this.viewer.selectWindowMenuOptionZoomOut();
            } else if (command.indexOf("Dock All") != -1 || command.indexOf("Minimize All") != -1) {
                Vector<SliceViewer> allViewers = this.mango.getAllViewers();
                for (SliceViewer current : allViewers) {
                    current.selectWindowMenuOptionMinimize();
                    ViewerAssociated[] viewerAssociatedArray = current.getAllAssociatedWindows();
                    if (viewerAssociatedArray == null) continue;
                    for (ViewerAssociated otherWindow : viewerAssociatedArray) {
                        otherWindow.getWindow().setState(1);
                    }
                }
                if (Mango.getInstance().getImageBrowser().isVisible()) {
                    Mango.getInstance().getImageBrowser().setState(1);
                }
                if (Mango.getInstance().getResultsManager().isVisible()) {
                    Mango.getInstance().getResultsManager().setState(1);
                }
                if (Mango.getInstance().getConsole().isVisible()) {
                    Mango.getInstance().getConsole().setState(1);
                }
                Mango.getInstance().getToolBox().minimizeAllAssociatedWindows();
            } else if (command.equals("Bring All to Front")) {
                Mango.getInstance().getImageBrowser().setState(0);
                Mango.getInstance().getResultsManager().setState(0);
                Mango.getInstance().getConsole().setState(0);
                Mango.getInstance().getConsole().toFront();
                Mango.getInstance().getResultsManager().toFront();
                Mango.getInstance().getImageBrowser().toFront();
                Mango.getInstance().getToolBox().bringToFrontAllAssociatedWindows();
                SliceViewer aViewer = Mango.getInstance().getToolBox().getCurrentViewer();
                Vector<SliceViewer> allViewers = this.mango.getAllViewers();
                for (SliceViewer sliceViewer : allViewers) {
                    ViewerAssociated[] otherWindows = sliceViewer.getAllAssociatedWindows();
                    if (otherWindows != null) {
                        for (ViewerAssociated otherWindow : otherWindows) {
                            otherWindow.getWindow().setState(0);
                            otherWindow.getWindow().toFront();
                        }
                    }
                    sliceViewer.getViewerFrame().setState(0);
                    sliceViewer.frameToFront();
                }
                if (aViewer != null) {
                    ViewerAssociated[] otherWindows = aViewer.getAllAssociatedWindows();
                    if (otherWindows != null) {
                        for (ViewerAssociated otherWindow : otherWindows) {
                            otherWindow.getWindow().setState(0);
                            otherWindow.getWindow().toFront();
                        }
                    }
                    aViewer.getViewerFrame().setState(0);
                    aViewer.frameToFront();
                }
            } else if (command.equals("Install Utilities...")) {
                InstallUtilitiesDialog dialog = new InstallUtilitiesDialog();
                Frame frame = Mango.getInstance().getDialogParentFrame();
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Install Utilities", -1, null);
                final JOptionPane jOptionPane = jopf.getJOptionPane();
                JButton buttonDone = new JButton("OK");
                buttonDone.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        jOptionPane.setValue(0);
                        jOptionPane.setVisible(false);
                    }
                });
                Object[] options = new Object[]{buttonDone, dialog.getInstallButton(), dialog.getShowButton()};
                jopf.setOptions(options);
                jopf.setInitialValue(buttonDone);
                jopf.show(true);
            } else if (command.equals("Plugin Manager...")) {
                this.openPluginManager();
            } else if (command.equals("Dilate...")) {
                this.viewer.showDilateDialog();
            } else if (command.equals("Erode...")) {
                this.viewer.showErodeDialog();
            } else if (command.equals("Open...")) {
                this.viewer.showOpenROIDialog();
            } else if (command.equals("Close...")) {
                this.viewer.showCloseROIDialog();
            } else if (command.equals("Convex Hull")) {
                this.viewer.doConvexHull(0.0, 0.0, false, false, true, this.viewer.getROIManager().getBuffer().getSelected(), false, false, false);
            } else if (command.equals("Threshold to ROI...")) {
                this.viewer.showThresholdToROIDialog();
            } else if (command.equals("Reflect...")) {
                this.viewer.showReflectDialog();
            } else if (command.equals("Image Calculator...")) {
                this.viewer.showImageCalculatorDialog();
            } else if (command.equals("ROI Logic Calculator...")) {
                this.viewer.showROILogicCalculator();
            } else if (command.equals("Shrink Wrap...")) {
                this.viewer.showShrinkWrapROIDialog();
            } else if (command.equals(EDIT_OPTION_DELETE)) {
                this.viewer.deleteAction(false);
            } else if (command.equals(EDIT_OPTION_UNDO)) {
                this.viewer.doUndo(false);
            } else if (command.equals(EDIT_OPTION_REDO)) {
                this.viewer.doRedo(false);
            } else if (command.equals("Propagate...")) {
                this.viewer.showPropagateROIDialog();
            } else if (command.equals("Add ROI...")) {
                this.viewer.showAddROIDialog();
            } else if (command.equals("Set Tool Slice Range...")) {
                SliceViewer aViewer = Mango.getInstance().getCurrentSliceViewer();
                int mainSliceDirection = 0;
                if (aViewer != null) {
                    mainSliceDirection = aViewer.getMainSliceDirection();
                }
                ROISliceRangeDialog dialog = new ROISliceRangeDialog(this.mango.getToolSliceRangeBelow(), this.mango.getToolSliceRangeAbove(), mainSliceDirection);
                MangoFocusableOptionPane mangoFocusableOptionPane = new MangoFocusableOptionPane(this.viewer.getViewerFrame(), (Object)dialog, "Set Tool Slice Range", 3);
                int selection = mangoFocusableOptionPane.show();
                if (selection == 0) {
                    this.mango.setToolSliceRange(dialog.getAbove(), dialog.getBelow());
                }
            } else if (command.equals("Make Statistical Image from Series...")) {
                this.viewer.makeSeriesStatImage();
            } else if (command.equals(FILE_OPTION_REMOVE_OVERLAYS)) {
                this.viewer.doRemoveAllOverlays();
            } else if (command.equals("Save Overlays")) {
                this.viewer.doSaveOverlays(false);
            } else if (command.equals("Stack Viewers")) {
                this.mango.arrangeViewersToStack();
            } else if (command.equals("Filter Manager...")) {
                final FilterManagerDialog dialog = new FilterManagerDialog();
                Frame frame = Mango.getInstance().getDialogParentFrame();
                final MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Filter Manager", -1, null);
                final JOptionPane jOptionPane = jopf.getJOptionPane();
                JButton buttonOk = new JButton("Done");
                buttonOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        jOptionPane.setValue(0);
                        jOptionPane.setVisible(false);
                    }
                });
                JButton buttonSave = new JButton(TEXT_SAVE);
                buttonSave.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        dialog.doSave();
                    }
                });
                JButton buttonDelete = new JButton(EDIT_OPTION_DELETE);
                buttonDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        dialog.doDelete();
                    }
                });
                dialog.setDeleteButton(buttonDelete);
                JButton buttonImport = new JButton("Import...");
                buttonImport.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        AbstractFilter filter;
                        File selectedFile = OpenFileDialog.showOpenFileChooser(jopf.getJDialog(), ViewerMenuAction.this.mango.getLoadFileDirectory(), new String[]{".flt"}, "Filter Files");
                        if (selectedFile != null && (filter = FilterManager.readFilter(selectedFile)) != null) {
                            dialog.setFilter(filter);
                        }
                    }
                });
                JButton buttonExport = new JButton("Export...");
                buttonExport.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        String fileName = dialog.getName() + ".flt";
                        File selectedFile = SaveFileDialog.showSaveFileChooser(jopf.getJDialog(), ViewerMenuAction.this.mango.getLoadFileDirectory(), fileName);
                        if (selectedFile != null) {
                            AbstractFilter filter = null;
                            try {
                                filter = FilterManager.makeFilter(dialog.getName(), dialog.getDimensionsString(), dialog.isNormalize() ? "true" : "false", String.valueOf(dialog.getKernelSize()), dialog.isKernel() ? dialog.getFilterData() : null, dialog.isFormula() ? dialog.getFilterData() : null);
                                if (filter != null) {
                                    FilterManager.saveUserFilter(filter, selectedFile);
                                }
                            }
                            catch (FilterException ex) {
                                AppLogger.error((Throwable)ex);
                                Mango.showErrorDialogStatic("Not a valid filter!", "Add Filter Error");
                            }
                        }
                    }
                });
                Object[] options = new Object[]{buttonOk, buttonImport, buttonExport, buttonDelete, buttonSave};
                jopf.setOptions(options);
                jopf.setInitialValue(buttonOk);
                jopf.show(true);
            } else if (command.equals("Color Table Manager...")) {
                final ColorTableManagerDialog dialog = new ColorTableManagerDialog(this.mango);
                Frame frame = Mango.getInstance().getDialogParentFrame();
                final MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Color Table Manager", -1, null);
                final JOptionPane jOptionPane = jopf.getJOptionPane();
                JButton buttonSave = new JButton(TEXT_SAVE);
                buttonSave.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        dialog.doSave();
                    }
                });
                JButton buttonDelete = new JButton(EDIT_OPTION_DELETE);
                buttonDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        dialog.doDelete();
                    }
                });
                dialog.setDeleteButton(buttonDelete);
                JButton buttonImport = new JButton("Import...");
                buttonImport.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        dialog.doImport(jopf.getJDialog());
                    }
                });
                JButton buttonExport = new JButton("Export...");
                buttonExport.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        dialog.doExport(jopf.getJDialog());
                    }
                });
                JButton buttonDone = new JButton("Done");
                buttonDone.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        jOptionPane.setValue(2);
                    }
                });
                Object[] options = new Object[]{buttonDone, buttonImport, buttonExport, buttonDelete, buttonSave};
                jopf.setOptions(options);
                jopf.setInitialValue(buttonDone);
                int selection = jopf.show(true);
                if (selection == 0) {
                    LookupTableManager lutNew = dialog.getLookupTableManager();
                    StringBuffer sbName = new StringBuffer(lutNew.getName());
                    for (String element : LookupTableManager.NAMES) {
                        if (!sbName.toString().equals(element)) continue;
                        sbName.append(" New");
                    }
                    LookupTableManager.addLUT(sbName.toString(), lutNew.getExpression(), lutNew.getKnots());
                    SliceViewer currentViewer = Mango.getInstance().getToolBox().getCurrentViewer();
                    if (currentViewer != null) {
                        Mango.getInstance().getToolBox().setLUT(sbName.toString());
                    }
                }
            } else if (command.equals("Show Labels")) {
                boolean currentShowing = Mango.getInstance().getToolBox().isShowingLabels();
                Mango.getInstance().getToolBox().setShowLabels(!currentShowing);
            } else if (command.equals(IMAGE_OPTION_TRANSFORM)) {
                this.viewer.showTransformManualPanel();
            } else if (command.equals(ANALYSIS_OPTION_HISTOGRAM)) {
                this.viewer.showHistogramTool(true);
            } else if (command.equals(ANALYSIS_OPTION_CROSSSECTION)) {
                this.viewer.showCrosssectionTool();
            } else if (command.equals(ANALYSIS_OPTION_SERIES)) {
                this.viewer.showSeriesTool();
            } else if (command.equals("ROI Inspector")) {
                this.viewer.showROIInspector();
            } else if (command.equals(ANALYSIS_OPTION_CLUSTER)) {
                this.viewer.showClusterAnalysisTool();
            } else if (command.equals(ANALYSIS_OPTION_ROI_COMPONENTS)) {
                this.viewer.showROIComponentAnalysisTool();
            } else if (command.equals("Create Overlay Logicals")) {
                this.viewer.showLogicalManager(false);
            } else if (command.equals("Save ROI...")) {
                this.viewer.showSaveROIDialog();
            } else if (command.equals(VIEW_OPTION_ORIENTATION)) {
                this.viewer.setViewOptionOrientation(!this.viewer.isShowingOrientation());
            } else if (command.equals(VIEW_OPTION_SLICE_DIRECTION_AXIAL)) {
                this.viewer.setMainSliceDirection(0);
            } else if (command.equals(VIEW_OPTION_SLICE_DIRECTION_CORONAL)) {
                this.viewer.setMainSliceDirection(1);
            } else if (command.equals(VIEW_OPTION_SLICE_DIRECTION_SAGITTAL)) {
                this.viewer.setMainSliceDirection(2);
            } else if (command.equals(VIEW_OPTION_SHOW_ROI_STATS)) {
                this.viewer.setViewOptionROIStats(!this.viewer.isShowingROIStats());
            } else if (command.equals(VIEW_OPTION_SHOW_LABELS)) {
                this.viewer.setShowLabels(!this.viewer.isShowingLabels());
            } else if (command.equals(VIEW_OPTION_DICOM_OVERLAY)) {
                this.viewer.setShowDicomOverlay(!this.viewer.isShowingDicomOverlay());
            } else if (command.startsWith(VIEW_ZOOM_TOGGLE)) {
                this.viewer.zoomToggle();
            } else if (command.startsWith("Plugin|")) {
                String name = command.substring(command.indexOf(124) + 1);
                Mango.usePlugin(this.viewer, name);
            } else if (command.startsWith("Script|")) {
                String name = command.substring(command.indexOf(124) + 1);
                this.viewer.recordAction("runScript", new String[]{ScriptUtils.convertString(name)});
                ScriptManager.runScriptSilently(name, Mango.getInstance(), this.viewer);
            } else if (command.equals("Show Console") || command.equals("Hide Console")) {
                this.mango.setShowConsole(!this.mango.isShowingConsole());
            } else if (command.equals("Single Slice")) {
                this.viewer.setViewOptionDisplaySlice();
            } else if (command.equals("Multiple Slices")) {
                this.viewer.setToMultiSliceMode();
            } else if (command.equals("Orthogonal Slices")) {
                this.viewer.setViewOptionDisplayOrthoTall();
            } else if (command.startsWith("Filter|")) {
                AbstractFilter myFilter = FilterManager.getFilter(command.substring(command.indexOf(124) + 1));
                if (myFilter != null) {
                    this.viewer.doOperationFilterImage(myFilter);
                }
            } else if (command.startsWith("Rank Filter...")) {
                this.viewer.showRankFilterDialog();
            } else if (command.equals("Force Open Image Browser")) {
                Mango.getInstance().getImageBrowser().setLocation(DisplayUtils.getCenterDialogLocation(Mango.getInstance().getToolBox(), Mango.getInstance().getImageBrowser().getSize()));
                Mango.getInstance().getImageBrowser().setVisible(true);
                Mango.getInstance().getToolBox().updateImageBrowserItem();
            } else if (command.indexOf("Image Browser") != -1) {
                if (Mango.getInstance().getImageBrowser().getState() == 1) {
                    Mango.getInstance().getImageBrowser().setState(0);
                } else {
                    this.openImageBrowser();
                }
            } else if (command.indexOf("Get More Plugins...") != -1) {
                DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//mango.html#pluginslist");
            } else if (command.indexOf("License Agreement") != -1) {
                LicenseDialog.showInFrame(this.mango.getToolBox());
            } else if (command.indexOf("Mouse & Keyboard Reference") != -1) {
                NavigationReferenceDialog.showInFrame(this.mango);
            } else if (command.indexOf("Check for Updates") != -1) {
                this.mango.checkForUpdate();
            } else if (command.equals("Use Explicit Range")) {
                this.mango.setUseSmartROITools(!this.mango.isUsingSmartTools());
            } else if (command.indexOf("Questions, Bugs & Feedback") != -1) {
                DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//forum/");
            } else if (command.indexOf("Get Desktop Version") != -1) {
                DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//mango.html");
            } else if (command.indexOf("Sync to iPad...") != -1) {
                try {
                    File syncServerFile = new File(new File(Mango.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParent(), "MangoSyncServerC.app");
                    if (!syncServerFile.exists()) {
                        syncServerFile = new File(new File(Mango.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParent() + "/Resources", "MangoSyncServerC.app");
                    }
                    if (syncServerFile.exists()) {
                        Runtime.getRuntime().exec("open " + syncServerFile);
                        break block332;
                    }
                    AppLogger.error((String)"Cannot find MangoSyncServerC.app");
                }
                catch (URISyntaxException ex) {
                    AppLogger.error((Throwable)ex);
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
            } else if (command.equals(VIEW_OPTION_RULER)) {
                this.viewer.setViewOptionRuler(!this.viewer.isShowingRuler());
            } else if (command.equals(VIEW_OPTION_ANGLE)) {
                this.viewer.setViewOptionAngle(!this.viewer.isShowingAngle());
            } else if (command.equals("Series Labels")) {
                this.viewer.getViewerFrame().addSeriesLabelEditor();
            } else if (command.equals("Create Video...")) {
                new CineSlice(this.viewer, this.viewer.getMainScreenSlice());
            } else if (command.equals(IMAGE_OPTION_LAYOUT)) {
                this.viewer.showLayoutTool(false);
            } else if (command.equals(IMAGE_OPTION_SNAPSHOT)) {
                this.viewer.showSnapshotDialog();
            } else if (command.equals("Create Webpage...")) {
                new Webpage(this.viewer);
            } else if (command.equals("Edit Header...")) {
                File selectedFile = OpenFileDialog.showOpenFileChooser(this.mango.getToolBox(), null, null, null);
                if (selectedFile != null) {
                    this.mango.openHeaderEditor(selectedFile, null);
                }
            } else if (command.equals("Edit Script...")) {
                this.mango.showScriptTool(false, false, this.viewer);
            } else if (command.equals("Record Script With User Input...")) {
                this.mango.showScriptTool(true, true, this.viewer);
            } else if (command.equals("Record Script Without User Input...")) {
                this.mango.showScriptTool(true, false, this.viewer);
            } else if (command.equals("Script Manager...")) {
                this.mango.showScriptTool(false, false);
            }
        }
        if (this.viewer != null) {
            this.viewer.updateFrameMenu();
        }
    }

    public void makeDICOMChooser(File selectedFile) {
        this.mango.addToRecentFilesList(selectedFile.toURI());
        DicomChooser chooser = new DicomChooser(this.mango, selectedFile);
        Mango.getInstance().getToolBox().associateWindow(chooser);
        chooser.readDICOM();
    }

    public void openFile() {
        this.openFile(null);
    }

    public void openImageBrowser() {
        Mango.getInstance().getImageBrowser().setLocation(DisplayUtils.getCenterDialogLocation(Mango.getInstance().getToolBox(), Mango.getInstance().getImageBrowser().getSize()));
        Mango.getInstance().getImageBrowser().toggleVisible();
        Mango.getInstance().getToolBox().updateImageBrowserItem();
    }

    public void openPluginManager() {
        final PluginManagerDialog dialog = new PluginManagerDialog(this.mango);
        Frame frame = Mango.getInstance().getDialogParentFrame();
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, "Plugin Manager", -1, null);
        final JOptionPane jop = jopf.getJOptionPane();
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
            }
        });
        MangoDropDownButton buttonAdd = new MangoDropDownButton("Add");
        buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.showAddOptions();
            }
        });
        JButton buttonUninstall = new JButton("Remove");
        buttonUninstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.removePlugin();
            }
        });
        Object[] options = new Object[]{buttonOk, buttonAdd, buttonUninstall};
        jopf.setOptions(options);
        jopf.setInitialValue(buttonOk);
        dialog.setRemoveButton(buttonUninstall);
        dialog.setAddButton(buttonAdd);
        jopf.show(true);
    }

    private void openUserGuide() {
        DesktopUtilities.openURL((String)"http://rii.uthscsa.edu/mango//userguide.html");
    }

    private File makeOpenFileChooser(String[] extensions, String description) {
        return OpenFileDialog.showOpenFileChooser(Mango.getInstance().getToolBox(), this.mango.getLoadFileDirectory(), extensions, description);
    }

    private void openDICOMFolder() {
        this.openDICOMFolder(null);
    }

    private void openDICOMFolder(String directoryVal) {
        File selectedFile;
        String directory = directoryVal;
        if (directory == null) {
            directory = this.mango.getLoadFileDirectory();
        }
        if ((selectedFile = OpenFileDialog.showOpenFolderChooser(Mango.getInstance().getToolBox(), directory)) != null) {
            this.makeDICOMChooser(selectedFile);
        }
    }

    private void openFile(String directoryVal) {
        File selectedFile;
        String directory = directoryVal;
        if (directory == null) {
            directory = this.mango.getLoadFileDirectory();
        }
        if ((selectedFile = OpenFileDialog.showOpenFileChooser(Mango.getInstance().getToolBox(), directory, null, null)) != null && !selectedFile.isDirectory() && selectedFile.exists()) {
            this.mango.addViewer(selectedFile);
        }
    }

    private void openFromURL(final int mode) {
        JButton buttonLoad = new JButton("Load");
        final URLLoaderDialog dialog = new URLLoaderDialog(this.mango, this.viewer, mode, buttonLoad);
        String title = null;
        title = mode == 1 ? "Load Online Overlay" : (mode == 2 ? "Load Online ROI" : "Open Online Image");
        Frame frame = Mango.getInstance().getDialogParentFrame();
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(frame, dialog, title, -1, null);
        final JOptionPane jop = jopf.getJOptionPane();
        JButton buttonCancel = new JButton(ACTION_CANCEL);
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
            }
        });
        buttonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
                String url = dialog.getURL();
                if (url != null) {
                    if (!url.startsWith("http://")) {
                        url = "http://" + url;
                    }
                    try {
                        if (URLUtilities.urlExists((String)url, (int)4000)) {
                            if (mode == 0) {
                                ViewerMenuAction.this.openImageURL(url);
                            } else if (mode == 1) {
                                ViewerMenuAction.this.openOverlayURL(url, dialog.isParametricOverlay());
                            } else if (mode == 2) {
                                ViewerMenuAction.this.openROIURL(url, dialog.isImportingROI(), dialog.isImportingInWorldSpace());
                            }
                        } else {
                            ViewerMenuAction.this.mango.showErrorDialog("The URL does not exist!\n" + url, ViewerMenuAction.TEXT_OPEN_IMAGE_ERROR);
                        }
                    }
                    catch (IOException ex) {
                        AppLogger.error((Throwable)ex);
                        ViewerMenuAction.this.showImageURLError(url, ex.getMessage());
                    }
                }
            }
        });
        Object[] options = new Object[]{buttonLoad, buttonCancel};
        jopf.setOptions(options);
        jopf.setInitialValue(buttonCancel);
        dialog.setCancelButton(buttonCancel);
        jopf.setFocusableItem(dialog);
        jopf.show(true);
    }

    private void showImageURLError(String url, String message) {
        this.mango.showErrorDialog(TEXT_ERROR_IMAGE_URL + url + "\n(" + message + ")", TEXT_OPEN_IMAGE_ERROR);
    }

    private void openImageURL(String url) {
        try {
            URI uri = new URL(url).toURI();
            this.mango.addViewer(uri, true);
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
            this.showImageURLError(url, ex.getMessage());
        }
        catch (MalformedURLException ex) {
            AppLogger.error((Throwable)ex);
            this.showImageURLError(url, ex.getMessage());
        }
    }

    private void openOverlayURL(String url, boolean isParametric) {
        this.viewer.recordAction("addOverlayURL", new String[]{ScriptUtils.convertString(url)}, true);
        try {
            URI uri = new URL(url).toURI();
            this.viewer.loadOverlay(uri, this.viewer.getOverlayManager().getNextLUTType(), isParametric);
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
            this.showImageURLError(url, ex.getMessage());
        }
        catch (MalformedURLException ex) {
            AppLogger.error((Throwable)ex);
            this.showImageURLError(url, ex.getMessage());
        }
    }

    private void openROIURL(String url, boolean isImporting, boolean forceWorld) {
        this.viewer.recordAction("loadROIURL", new String[]{ScriptUtils.convertString(url), ScriptUtils.convertBoolean(isImporting), ScriptUtils.convertBoolean(forceWorld)});
        try {
            URI uri = new URL(url).toURI();
            if (isImporting) {
                this.viewer.importROI(uri, forceWorld);
            } else {
                this.viewer.loadROI(uri, false);
            }
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
            this.showImageURLError(url, ex.getMessage());
        }
        catch (MalformedURLException ex) {
            AppLogger.error((Throwable)ex);
            this.showImageURLError(url, ex.getMessage());
        }
    }
}

