/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.menus;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoPreferences;
import edu.uthscsa.ric.mango.components.menus.MangoCheckBoxMenuItem;
import edu.uthscsa.ric.mango.components.menus.MangoMenu;
import edu.uthscsa.ric.mango.components.menus.MangoMenuItem;
import edu.uthscsa.ric.mango.components.menus.MangoMenuPlaceholderItem;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.menus.ViewerMenuAction;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.lang3.StringUtils;

public class ViewerMenu
implements MenuListener {
    private JLabel dynamicROIFlag;
    private JMenu analysisMenu;
    private JMenu editFlip;
    private JMenu editMenu;
    private JMenu fileMenu;
    private JMenu filter;
    private JMenu imageOpMenu;
    private JMenu imageStats;
    private JMenu pluginsMenu;
    private JMenu scriptsMenu;
    private JMenu roiOpMenu;
    private JMenu roiStats;
    private JMenu viewMenu;
    private JMenu windowMenu;
    private JMenu newScriptMenu;
    private JMenuBar mainMenuBar;
    private JMenuItem addROI;
    private JMenuItem helpUserGuide;
    private JMenuItem navReference;
    private JMenuItem helpVersion;
    private JMenuItem helpLicense;
    private JMenuItem helpDesktop;
    private JMenuItem helpForum;
    private JMenuItem editScriptMenuItem;
    private JMenuItem analysisAllROISliceStats;
    private JMenuItem analysisAllROIVolsStats;
    private JMenuItem analysisAllSliceStats;
    private JMenuItem analysisAllVolsStats;
    private JMenuItem analysisCrosssection;
    private JMenuItem analysisHistrogram;
    private JMenuItem analysisROISliceStats;
    private JMenuItem analysisROITimeStats;
    private JMenuItem analysisROIVolStats;
    private JMenuItem analysisSliceStats;
    private JMenuItem analysisTimeStats;
    private JMenuItem analysisTimeseries;
    private JMenuItem analysisVolStats;
    private JMenuItem arithmetic;
    private JMenuItem clearROI;
    private JMenuItem closeROI;
    private JMenuItem clusterAnalysis;
    private JMenuItem clusterROIAnalysis;
    private JMenuItem convexHullROI;
    private JMenuItem dilateROI;
    private JMenuItem editCopy;
    private JMenuItem editCut;
    private JMenuItem editDeselectAll;
    private JMenuItem editFlipAP;
    private JMenuItem editFlipLR;
    private JMenuItem editFlipSI;
    private JMenuItem editMaxMin;
    private JMenuItem editNotes;
    private JMenuItem editOrigin;
    private JMenuItem editPaste;
    private JMenuItem editPixel;
    private JMenuItem editSelectAll;
    private JMenuItem editSeriesLabels;
    private JMenuItem editTimeseriesRange;
    private JMenuItem erodeROI;
    private JMenuItem fileAddOverlay;
    private JMenuItem fileClose;
    private JMenuItem fileLoadROI;
    private JMenuItem fileOnlineOverlay;
    private JMenuItem fileOnlineROI;
    private JMenuItem fileOverlay;
    private JMenuItem fileParametric;
    private JMenuItem fileRemoveOverlay;
    private JMenuItem fileRevert;
    private JMenuItem fileSave;
    private JMenuItem fileSaveAs;
    private JMenuItem fileSaveOverlays;
    private JMenuItem getMorePlugins;
    private JMenuItem logicalManager;
    private JMenuItem mathROI;
    private JMenuItem openROI;
    private JMenuItem propogateROI;
    private JMenuItem rankFilter;
    private JMenuItem redoROI;
    private JMenuItem reflectROI;
    private JMenuItem roiCounts;
    private JMenuItem saveROI;
    private JMenuItem shapesROI;
    private JMenuItem showFile;
    private JMenuItem shrinkWrapROI;
    private JMenuItem timeseriesMake;
    private JMenuItem transformTools;
    private JMenuItem undoROI;
    private JMenuItem utilityInfo;
    private JMenuItem viewLabels;
    private JMenuItem viewLowerCrosshairs;
    private JMenuItem viewMainCrosshairs;
    private JMenuItem viewMainSliceAxial;
    private JMenuItem viewMainSliceCoronal;
    private JMenuItem viewMainSliceSagittal;
    private JMenuItem viewOrientation;
    private JMenuItem viewOrtho;
    private JMenuItem viewOverlaysAll;
    private JMenuItem viewOverlaysCurrent;
    private JMenuItem viewProjection;
    private JMenuItem viewROIEdge;
    private JMenuItem viewROILinesAngles;
    private JMenuItem viewROILinesMeasure;
    private JMenuItem viewROIMask;
    private JMenuItem viewROIStats;
    private JMenuItem viewSingle;
    private JMenuItem viewSurface;
    private JMenuItem viewWide;
    private JMenuItem viewDicomOverlay;
    private JMenuItem viewerZoomToggle;
    private JMenuItem windowDecrement;
    private JMenuItem windowIncrement;
    private JMenuItem windowMax;
    private JMenuItem windowMin;
    private JMenuItem newScriptMenuItem;
    private JMenuItem newScriptMenuDialogsItem;
    private Mango mango;
    private SliceViewer viewer;
    private final int fontSize;
    public static final String FLAG_DYNAMIC_ROI = "Dynamic ROI";
    public static final int FONT_SIZE_DEFAULT = 11;
    public static final int FONT_SIZE_DEFAULT_APPLET = 15;
    public final Map<String, JMenuItem> MENU_ACTION_MAP = new TreeMap<String, JMenuItem>();
    public final Map<String, JMenuItem> MENU_NAME_MAP = new TreeMap<String, JMenuItem>();

    public ViewerMenu(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
        this.mainMenuBar = new JMenuBar();
        this.mainMenuBar.setBorder(BorderFactory.createLineBorder((Color)UIManager.get("MenuItem.background")));
        this.fontSize = mango.isApplet() ? 15 : 11;
        this.mainMenuBar.setFont(this.mainMenuBar.getFont().deriveFont((float)this.fontSize));
        this.makeAndAddFileMenu();
        this.makeAndAddEditMenu();
        this.makeAndAddViewMenu();
        this.makeAndAddAnalysisMenu();
        this.makeAndAddROIMenu();
        this.makeAndAddImageMenu();
        this.makeAndAddScriptsMenu();
        this.makeAndAddPluginsMenu();
        this.makeAndAddWindowMenu();
        this.makeAndAddHelpMenu();
        if (!mango.isApplet()) {
            this.makeFlags();
        }
        this.updateMenu();
        this.addAllMenuItemFieldsToMap();
    }

    public void addFilterMenuItem(String string) {
        MangoMenuItem tempItem = new MangoMenuItem(new ViewerMenuAction(string, this.mango, this.viewer), "Filter - " + string, this.fontSize, false);
        tempItem.setText(string);
        tempItem.setActionCommand("Filter|" + string);
        this.filter.add((Component)tempItem, 3);
    }

    public void addPluginMenuItem(String string) {
        MangoMenuItem tempItem = new MangoMenuItem(new ViewerMenuAction(string, this.mango, this.viewer), "Plugin - " + string, this.fontSize, false);
        tempItem.setText(string);
        tempItem.setActionCommand("Plugin|" + string);
        this.pluginsMenu.add((Component)tempItem, 1);
        if (Mango.getPluginNames().length == 1) {
            this.pluginsMenu.add((Component)new JToolBar.Separator(new Dimension(0, 10)), 2);
        }
    }

    public void addScriptMenuItem(String string) {
        MangoMenuItem tempItem = new MangoMenuItem(new ViewerMenuAction(string, this.mango, this.viewer), "Script - " + string, this.fontSize, false);
        tempItem.setText(string);
        tempItem.setActionCommand("Script|" + string);
        this.scriptsMenu.add((Component)tempItem, 1);
        if (Mango.getScriptNames().length == 1) {
            this.scriptsMenu.add((Component)new JToolBar.Separator(new Dimension(0, 10)), 2);
        }
    }

    public void clear() {
        this.mango = null;
        this.viewer = null;
        this.fileMenu.removeAll();
        this.fileMenu = null;
        this.editMenu.removeAll();
        this.editMenu = null;
        this.editFlip.removeAll();
        this.editFlip = null;
        this.viewMenu.removeAll();
        this.viewMenu = null;
        this.analysisMenu.removeAll();
        this.analysisMenu = null;
        this.imageOpMenu.removeAll();
        this.imageOpMenu = null;
        this.roiOpMenu.removeAll();
        this.roiOpMenu = null;
        this.windowMenu.removeAll();
        this.windowMenu = null;
        this.mainMenuBar.removeAll();
        this.mainMenuBar = null;
        this.imageStats = null;
        this.roiStats = null;
        this.pluginsMenu = null;
        this.filter = null;
        this.fileClose = null;
        this.fileSave = null;
        this.fileSaveOverlays = null;
        this.fileSaveAs = null;
        this.fileRevert = null;
        this.fileLoadROI = null;
        this.fileAddOverlay = null;
        this.fileRemoveOverlay = null;
        this.fileOverlay = null;
        this.fileParametric = null;
        this.fileOnlineOverlay = null;
        this.fileOnlineROI = null;
        this.editFlipLR = null;
        this.editFlipAP = null;
        this.editFlipSI = null;
        this.editOrigin = null;
        this.editMaxMin = null;
        this.editCopy = null;
        this.editPaste = null;
        this.editSelectAll = null;
        this.editDeselectAll = null;
        this.editCut = null;
        this.editPixel = null;
        this.editNotes = null;
        this.editTimeseriesRange = null;
        this.viewLowerCrosshairs = null;
        this.viewMainCrosshairs = null;
        this.viewROIMask = null;
        this.viewROIEdge = null;
        this.viewOverlaysCurrent = null;
        this.viewOverlaysAll = null;
        this.viewOrientation = null;
        this.viewROILinesMeasure = null;
        this.viewROILinesAngles = null;
        this.viewROIStats = null;
        this.viewSingle = null;
        this.viewLabels = null;
        this.viewOrtho = null;
        this.viewWide = null;
        this.viewDicomOverlay = null;
        this.viewerZoomToggle = null;
        this.clusterAnalysis = null;
        this.clusterROIAnalysis = null;
        this.analysisVolStats = null;
        this.analysisROIVolStats = null;
        this.analysisSliceStats = null;
        this.analysisROISliceStats = null;
        this.analysisAllSliceStats = null;
        this.analysisAllROISliceStats = null;
        this.roiCounts = null;
        this.logicalManager = null;
        this.analysisHistrogram = null;
        this.analysisCrosssection = null;
        this.analysisTimeseries = null;
        this.analysisTimeStats = null;
        this.analysisROITimeStats = null;
        this.analysisAllVolsStats = null;
        this.analysisAllROIVolsStats = null;
        this.showFile = null;
        this.utilityInfo = null;
        this.addROI = null;
        this.clearROI = null;
        this.undoROI = null;
        this.saveROI = null;
        this.redoROI = null;
        this.propogateROI = null;
        this.shrinkWrapROI = null;
        this.convexHullROI = null;
        this.mathROI = null;
        this.arithmetic = null;
        this.reflectROI = null;
        this.transformTools = null;
        this.closeROI = null;
        this.openROI = null;
        this.dilateROI = null;
        this.erodeROI = null;
        this.shapesROI = null;
        this.rankFilter = null;
        this.timeseriesMake = null;
        this.viewSurface = null;
        this.windowMax = null;
        this.windowMin = null;
        this.windowIncrement = null;
        this.windowDecrement = null;
        this.getMorePlugins = null;
        this.viewMainSliceAxial = null;
        this.viewMainSliceCoronal = null;
        this.viewMainSliceSagittal = null;
    }

    public JMenuBar getMenuBar() {
        return this.mainMenuBar;
    }

    @Override
    public void menuCanceled(MenuEvent me) {
    }

    @Override
    public void menuDeselected(MenuEvent me) {
    }

    @Override
    public void menuSelected(MenuEvent me) {
        this.updateMenu();
    }

    public final void updateMenu() {
        boolean enable = this.viewer.isImageLoaded();
        if (enable && this.viewer.canUpdateMenu()) {
            this.updateFileMenu(enable);
            this.updateEditMenu(enable);
            this.updateViewMenu(enable);
            this.updateAnalysisMenu(enable);
            this.updateImageMenu(enable);
            this.updateROIMenu(enable);
            this.updatePluginMenu(enable);
            this.updateWindowMenu(enable);
            this.updateFlags();
        }
        if (this.mango.isApplet()) {
            this.updateHelpMenu(true);
        }
    }

    private void initializeFiltersMenu() {
        String[] allFilters = Mango.getInstance().getFilterManager().getAllFilterNames();
        if (CollectionUtilities.isNotEmpty((Object)allFilters)) {
            this.filter.removeAll();
            this.filter.add(new JToolBar.Separator(new Dimension(0, 10)));
            this.filter.add(this.rankFilter);
            this.filter.add(new JToolBar.Separator(new Dimension(0, 10)));
            for (String allFilter : allFilters) {
                MangoMenuItem tempItem = new MangoMenuItem(new ViewerMenuAction(allFilter, this.mango, this.viewer), "Filter - " + allFilter, this.fontSize, false);
                tempItem.setText(allFilter);
                tempItem.setActionCommand("Filter|" + allFilter);
                tempItem.setEnabled(true);
                this.filter.add(tempItem);
            }
            this.filter.add(new JToolBar.Separator(new Dimension(0, 10)));
        }
    }

    private void initializePluginsMenu() {
        String[] allPlugins = Mango.getPluginNames();
        boolean added = false;
        this.pluginsMenu.removeAll();
        this.pluginsMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        if (CollectionUtilities.isNotEmpty((Object)allPlugins)) {
            for (String plugin : allPlugins) {
                MangoMenuItem tempItem = new MangoMenuItem(new ViewerMenuAction(plugin, this.mango, this.viewer), "Plugin - " + plugin, this.fontSize, false);
                tempItem.setText(plugin);
                tempItem.setActionCommand("Plugin|" + plugin);
                this.addMenuItemToMap(tempItem);
                this.pluginsMenu.add(tempItem);
                added = true;
            }
        }
        if (added) {
            this.pluginsMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        }
        this.pluginsMenu.add(this.scriptsMenu);
        this.pluginsMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.pluginsMenu.add(this.getMorePlugins);
        this.pluginsMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
    }

    public final void updateScriptsMenu() {
        String[] allScripts = Mango.getScriptNames();
        boolean added = false;
        this.scriptsMenu.removeAll();
        this.scriptsMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        if (CollectionUtilities.isNotEmpty((Object)allScripts)) {
            for (String script : allScripts) {
                MangoMenuItem tempItem = new MangoMenuItem(new ViewerMenuAction(script, this.mango, this.viewer), "Script - " + script, this.fontSize, false);
                tempItem.setText(script);
                tempItem.setActionCommand("Script|" + script);
                this.addMenuItemToMap(tempItem);
                this.scriptsMenu.add(tempItem);
                added = true;
            }
        }
        if (added) {
            this.scriptsMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        }
        this.newScriptMenu.add(this.newScriptMenuDialogsItem);
        this.newScriptMenu.add(this.newScriptMenuItem);
        this.scriptsMenu.add(this.editScriptMenuItem);
        this.scriptsMenu.add(this.newScriptMenu);
        this.scriptsMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
    }

    private void makeAndAddHelpMenu() {
        MangoMenu helpMenu = new MangoMenu("Help", this.fontSize, false);
        helpMenu.setEnabled(true);
        this.helpUserGuide = new MangoMenuItem(new ViewerMenuAction("User Guide", this.mango, this.viewer), null, this.fontSize, false);
        this.navReference = new MangoMenuItem(new ViewerMenuAction("Mouse & Keyboard Reference", this.mango, this.viewer), "Mouse & Keyboard Reference", this.fontSize, false);
        this.helpVersion = new MangoMenuItem(new ViewerMenuAction("About Mango", this.mango, this.viewer), null, this.fontSize, false);
        this.helpLicense = new MangoMenuItem(new ViewerMenuAction("License Agreement", this.mango, this.viewer), null, this.fontSize, false);
        this.helpDesktop = new MangoMenuItem(new ViewerMenuAction("Get Desktop Version", this.mango, this.viewer), null, this.fontSize, false);
        this.helpForum = new MangoMenuItem(new ViewerMenuAction("Visit Forum", this.mango, this.viewer), null, this.fontSize, false);
        helpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        helpMenu.add(this.helpVersion);
        helpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        helpMenu.add(this.helpUserGuide);
        helpMenu.add(this.navReference);
        helpMenu.add(this.helpForum);
        helpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        helpMenu.add(this.helpDesktop);
        helpMenu.add(this.helpLicense);
        helpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        if (this.mango.isApplet()) {
            this.mainMenuBar.add(helpMenu);
        }
    }

    private void updateHelpMenu(boolean enable) {
        this.helpUserGuide.setEnabled(enable);
        this.navReference.setEnabled(enable);
        this.helpVersion.setEnabled(enable);
        this.helpLicense.setEnabled(enable);
        this.helpDesktop.setEnabled(enable);
        this.helpForum.setEnabled(enable);
    }

    private void makeAndAddAnalysisMenu() {
        this.analysisTimeStats = new MangoMenuItem(new ViewerMenuAction("Time-series Stats", this.mango, this.viewer), "Time-series Stats", this.fontSize, false);
        this.analysisTimeStats.setText("Series");
        this.analysisTimeStats.setActionCommand("Time-series Stats");
        this.analysisROITimeStats = new MangoMenuItem(new ViewerMenuAction("Time-series ROI Stats", this.mango, this.viewer), "Time-series ROI Stats", this.fontSize, false);
        this.analysisROITimeStats.setText("Series");
        this.analysisROITimeStats.setActionCommand("Time-series ROI Stats");
        this.analysisAllVolsStats = new MangoMenuItem(new ViewerMenuAction("All Volumes Stats", this.mango, this.viewer), "All Volumes Stats", this.fontSize, false);
        this.analysisAllVolsStats.setText("All Volumes");
        this.analysisAllVolsStats.setActionCommand("All Volumes Stats");
        this.analysisAllROIVolsStats = new MangoMenuItem(new ViewerMenuAction("All Volumes ROI Stats", this.mango, this.viewer), "All Volumes ROI Stats", this.fontSize, false);
        this.analysisAllROIVolsStats.setText("All Volumes");
        this.analysisAllROIVolsStats.setActionCommand("All Volumes ROI Stats");
        this.analysisVolStats = new MangoMenuItem(new ViewerMenuAction("Volume Stats", this.mango, this.viewer), "Volume Stats", this.fontSize, false);
        this.analysisVolStats.setText("Volume");
        this.analysisVolStats.setActionCommand("Volume Stats");
        this.analysisROIVolStats = new MangoMenuItem(new ViewerMenuAction("Volume ROI Stats", this.mango, this.viewer), "Volume ROI Stats", this.fontSize, false);
        this.analysisROIVolStats.setText("Volume");
        this.analysisROIVolStats.setActionCommand("Volume ROI Stats");
        this.analysisSliceStats = new MangoMenuItem(new ViewerMenuAction("Current Slice Stats", this.mango, this.viewer), "Current Slice Stats", this.fontSize, false);
        this.analysisSliceStats.setText("Current Slice");
        this.analysisSliceStats.setActionCommand("Current Slice Stats");
        this.analysisROISliceStats = new MangoMenuItem(new ViewerMenuAction("Current Slice ROI Stats", this.mango, this.viewer), "Current Slice ROI Stats", this.fontSize, false);
        this.analysisROISliceStats.setText("Current Slice");
        this.analysisROISliceStats.setActionCommand("Current Slice ROI Stats");
        this.analysisAllSliceStats = new MangoMenuItem(new ViewerMenuAction("All Slices Stats", this.mango, this.viewer), "All Slices Stats", this.fontSize, false);
        this.analysisAllSliceStats.setText("All Slices");
        this.analysisAllSliceStats.setActionCommand("All Slices Stats");
        this.analysisAllROISliceStats = new MangoMenuItem(new ViewerMenuAction("All Slices ROI Stats", this.mango, this.viewer), "All Slices ROI Stats", this.fontSize, false);
        this.analysisAllROISliceStats.setText("All Slices");
        this.analysisAllROISliceStats.setActionCommand("All Slices ROI Stats");
        this.analysisROIVolStats.setEnabled(false);
        this.analysisROISliceStats.setEnabled(false);
        this.clusterAnalysis = new MangoMenuItem(new ViewerMenuAction("Find Overlay Clusters", this.mango, this.viewer), "Find Overlay Clusters", this.fontSize, false);
        this.clusterROIAnalysis = new MangoMenuItem(new ViewerMenuAction("Find ROI Components", this.mango, this.viewer), "Find ROI Components", this.fontSize, false);
        this.logicalManager = new MangoMenuItem(new ViewerMenuAction("Create Overlay Logicals", this.mango, this.viewer), "Create Overlay Logicals", this.fontSize, false);
        this.analysisMenu = new MangoMenu("Analysis", this.fontSize, false);
        this.analysisMenu.addMenuListener(this);
        this.analysisMenu.setEnabled(true);
        this.imageStats = new MangoMenu("Image Statistics", this.fontSize, false);
        this.roiStats = new MangoMenu("ROI Statistics", this.fontSize, false);
        this.analysisHistrogram = new MangoMenuItem(new ViewerMenuAction("Histogram", this.mango, this.viewer), "Histogram", this.fontSize, false);
        this.analysisCrosssection = new MangoMenuItem(new ViewerMenuAction("Cross-section", this.mango, this.viewer), "Cross-section", this.fontSize, false);
        this.analysisTimeseries = new MangoMenuItem(new ViewerMenuAction("Series", this.mango, this.viewer), "Series", this.fontSize, false);
        this.analysisMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.analysisMenu.add(this.imageStats);
        this.analysisMenu.add(this.roiStats);
        this.analysisMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.analysisMenu.add(this.clusterAnalysis);
        this.analysisMenu.add(this.clusterROIAnalysis);
        this.analysisMenu.add(this.logicalManager);
        this.analysisMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.analysisMenu.add(this.analysisHistrogram);
        this.analysisMenu.add(this.analysisCrosssection);
        this.analysisMenu.add(this.analysisTimeseries);
        this.analysisMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.imageStats.add(this.analysisTimeStats);
        this.imageStats.add(this.analysisAllVolsStats);
        this.imageStats.add(this.analysisVolStats);
        this.imageStats.add(this.analysisAllSliceStats);
        this.imageStats.add(this.analysisSliceStats);
        this.roiStats.add(this.analysisROITimeStats);
        this.roiStats.add(this.analysisAllROIVolsStats);
        this.roiStats.add(this.analysisROIVolStats);
        this.roiStats.add(this.analysisAllROISliceStats);
        this.roiStats.add(this.analysisROISliceStats);
        this.mainMenuBar.add((Component)this.analysisMenu, 3);
    }

    private void makeAndAddEditMenu() {
        this.editFlip = new MangoMenu("Orientation", this.fontSize, false);
        this.editFlipLR = new MangoMenuItem(new ViewerMenuAction("Flip Left-Right", this.mango, this.viewer), "Flip Left-Right", this.fontSize, false);
        this.editFlipAP = new MangoMenuItem(new ViewerMenuAction("Flip Anterior-Posterior", this.mango, this.viewer), "Flip Anterior-Posterior", this.fontSize, false);
        this.editFlipSI = new MangoMenuItem(new ViewerMenuAction("Flip Superior-Inferior", this.mango, this.viewer), "Flip Superior-Inferior", this.fontSize, false);
        this.editOrigin = new MangoMenuItem(new ViewerMenuAction("Origin...", this.mango, this.viewer), "Edit Origin", this.fontSize, false);
        this.editPixel = new MangoMenuItem(new ViewerMenuAction("Voxel...", this.mango, this.viewer), "Edit Voxel", this.fontSize, false);
        this.editNotes = new MangoMenuItem(new ViewerMenuAction("Notes...", this.mango, this.viewer), "Edit Notes", this.fontSize, false);
        this.editMaxMin = new MangoMenuItem(new ViewerMenuAction("Update to Image Range", this.mango, this.viewer), "Update to Image Range", this.fontSize, false);
        this.editTimeseriesRange = new MangoMenuItem(new ViewerMenuAction("Update to Series Range", this.mango, this.viewer), "Update to Series Range", this.fontSize, false);
        this.editCopy = new MangoMenuItem(new ViewerMenuAction("Copy", this.mango, this.viewer), null, this.fontSize, false);
        this.editCopy.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.editCut = new MangoMenuItem(new ViewerMenuAction("Cut", this.mango, this.viewer), null, this.fontSize, false);
        this.editCut.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.editPaste = new MangoMenuItem(new ViewerMenuAction("Paste", this.mango, this.viewer), null, this.fontSize, false);
        this.editPaste.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.editSelectAll = new MangoMenuItem(new ViewerMenuAction("Select All", this.mango, this.viewer), null, this.fontSize, false);
        this.editSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.editDeselectAll = new MangoMenuItem(new ViewerMenuAction("Deselect All", this.mango, this.viewer), null, this.fontSize, false);
        this.editDeselectAll.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.clearROI = new MangoMenuItem(new ViewerMenuAction("Delete", this.mango, this.viewer), null, this.fontSize, false);
        this.clearROI.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.undoROI = new MangoMenuItem(new ViewerMenuAction("Undo", this.mango, this.viewer), null, this.fontSize, false);
        this.undoROI.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.redoROI = new MangoMenuItem(new ViewerMenuAction("Redo", this.mango, this.viewer), null, this.fontSize, false);
        this.redoROI.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.editSeriesLabels = new MangoMenuItem(new ViewerMenuAction("Series Labels", this.mango, this.viewer), "Edit Series Labels", this.fontSize, true);
        this.editMenu = new MangoMenu("Edit", this.fontSize, false);
        this.editMenu.addMenuListener(this);
        this.editMenu.setEnabled(true);
        this.editFlip.add(this.editFlipLR);
        this.editFlip.add(this.editFlipAP);
        this.editFlip.add(this.editFlipSI);
        this.editMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.editMenu.add(this.undoROI);
        this.editMenu.add(this.redoROI);
        this.editMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.editMenu.add(this.editCut);
        this.editMenu.add(this.editCopy);
        this.editMenu.add(this.editPaste);
        this.editMenu.add(this.clearROI);
        this.editMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.editMenu.add(this.editSelectAll);
        this.editMenu.add(this.editDeselectAll);
        this.editMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.editMenu.add(this.editFlip);
        this.editMenu.add(this.editOrigin);
        this.editMenu.add(this.editPixel);
        this.editMenu.add(this.editNotes);
        this.editMenu.add(this.editSeriesLabels);
        this.editMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.editMenu.add(this.editMaxMin);
        this.editMenu.add(this.editTimeseriesRange);
        this.editMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.mainMenuBar.add((Component)this.editMenu, 1);
    }

    private void makeAndAddFileMenu() {
        this.fileLoadROI = new MangoMenuItem(new ViewerMenuAction("Load ROI...", this.mango, this.viewer), "Load ROI", this.fontSize, true);
        this.fileOnlineOverlay = new MangoMenuItem(new ViewerMenuAction("Load Online Overlay...", this.mango, this.viewer), "Load Online Overlay", this.fontSize, true);
        this.fileOnlineROI = new MangoMenuItem(new ViewerMenuAction("Load Online ROI...", this.mango, this.viewer), "Load Online ROI", this.fontSize, true);
        this.fileAddOverlay = new MangoMenuItem(new ViewerMenuAction("Add Overlay...", this.mango, this.viewer), null, this.fontSize, true);
        this.fileAddOverlay.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.fileParametric = new MangoMenuItem(new ViewerMenuAction("Add Parametric Overlay...", this.mango, this.viewer), "Add Parametric Overlay", this.fontSize, true);
        this.fileClose = new MangoMenuItem(new ViewerMenuAction("Close", this.mango, this.viewer), null, this.fontSize, true);
        this.fileClose.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.utilityInfo = new MangoMenuItem(new ViewerMenuAction("Image Info", this.mango, this.viewer), null, this.fontSize, false);
        this.utilityInfo.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.showFile = new MangoMenuItem(new ViewerMenuAction("Show File", this.mango, this.viewer), "Show File", this.fontSize, true);
        this.saveROI = new MangoMenuItem(new ViewerMenuAction("Save ROI...", this.mango, this.viewer), "Save ROI", this.fontSize, true);
        this.fileSave = new MangoMenuItem(new ViewerMenuAction("Save", this.mango, this.viewer), null, this.fontSize, true);
        this.fileSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileSaveOverlays = new MangoMenuItem(new ViewerMenuAction("Save Overlays", this.mango, this.viewer), "Save Overlays", this.fontSize, true);
        this.fileSaveAs = new MangoMenuItem(new ViewerMenuAction("Save As...", this.mango, this.viewer), null, this.fontSize, true);
        this.fileSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.fileRevert = new MangoMenuItem(new ViewerMenuAction("Reload", this.mango, this.viewer), "Reload", this.fontSize, false);
        this.fileRemoveOverlay = new MangoMenuItem(new ViewerMenuAction("Remove Overlays", this.mango, this.viewer), "Remove Overlays", this.fontSize, false);
        this.fileOverlay = new MangoMenuItem(new ViewerMenuAction("Overlay Onto...", this.mango, this.viewer), "Overlay Onto", this.fontSize, true);
        this.fileMenu = new MangoMenu("File", this.fontSize, false);
        this.fileMenu.setEnabled(true);
        this.fileMenu.addMenuListener(this);
        this.fileMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        if (!this.mango.isApplet()) {
            this.fileMenu.add(this.fileAddOverlay);
            this.fileMenu.add(this.fileParametric);
            this.fileMenu.add(this.fileOnlineOverlay);
            this.fileMenu.add(this.fileOverlay);
            this.fileMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
            this.fileMenu.add(this.fileLoadROI);
            this.fileMenu.add(this.fileOnlineROI);
            this.fileMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        }
        this.fileMenu.add(this.utilityInfo);
        this.fileMenu.add(this.showFile);
        this.fileMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.fileMenu.add(this.fileClose);
        this.fileMenu.add(this.fileRemoveOverlay);
        this.fileMenu.add(this.fileRevert);
        if (!this.mango.isApplet()) {
            this.fileMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
            this.fileMenu.add(this.fileSave);
            this.fileMenu.add(this.fileSaveAs);
            this.fileMenu.add(this.fileSaveOverlays);
            this.fileMenu.add(this.saveROI);
        }
        this.fileMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.mainMenuBar.add((Component)this.fileMenu, 0);
    }

    private void makeAndAddImageMenu() {
        this.arithmetic = new MangoMenuItem(new ViewerMenuAction("Image Calculator...", this.mango, this.viewer), "Image Calculator", this.fontSize, false);
        this.rankFilter = new MangoMenuItem(new ViewerMenuAction("Rank Filter...", this.mango, this.viewer), "Rank Filter", this.fontSize, false);
        this.timeseriesMake = new MangoMenuItem(new ViewerMenuAction("Make Statistical Image from Series...", this.mango, this.viewer), "Make Statistical Image from Series", this.fontSize, true);
        this.transformTools = new MangoMenuItem(new ViewerMenuAction("Transform...", this.mango, this.viewer), "Transform", this.fontSize, false);
        this.imageOpMenu = new MangoMenu("Image", this.fontSize, false);
        this.imageOpMenu.setEnabled(true);
        this.filter = new MangoMenu("Filter", this.fontSize, false);
        this.initializeFiltersMenu();
        this.viewSurface = new MangoMenuItem("Build Surface...", "Build Surface", this.fontSize, false);
        this.viewSurface.setAction(new ViewerMenuAction("Build Surface...", this.mango, this.viewer));
        this.viewProjection = new MangoMenuItem("Build Projection...", "Build Projection", this.fontSize, false);
        this.viewProjection.setAction(new ViewerMenuAction("Build Projection...", this.mango, this.viewer));
        MangoMenuItem createCapture = new MangoMenuItem("Create Snapshot...", null, this.fontSize, true);
        createCapture.setAction(new ViewerMenuAction("Create Snapshot...", this.mango, this.viewer));
        MangoMenuItem createVideo = new MangoMenuItem("Create Video...", "Create Video", this.fontSize, true);
        createVideo.setAction(new ViewerMenuAction("Create Video...", this.mango, this.viewer));
        MangoMenuItem createLayout = new MangoMenuItem("Create Layout...", "Create Layout", this.fontSize, true);
        createLayout.setAction(new ViewerMenuAction("Create Layout...", this.mango, this.viewer));
        MangoMenuItem createWebpage = new MangoMenuItem("Create Webpage...", "Create Webpage", this.fontSize, true);
        createWebpage.setAction(new ViewerMenuAction("Create Webpage...", this.mango, this.viewer));
        this.imageOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.imageOpMenu.addMenuListener(this);
        this.imageOpMenu.add(this.arithmetic);
        this.imageOpMenu.add(this.timeseriesMake);
        this.imageOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.imageOpMenu.add(this.transformTools);
        this.imageOpMenu.add(this.filter);
        this.imageOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        if (!this.mango.isApplet()) {
            this.imageOpMenu.add(createCapture);
            this.imageOpMenu.add(createLayout);
            this.imageOpMenu.add(createVideo);
            this.imageOpMenu.add(createWebpage);
            this.imageOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        }
        this.imageOpMenu.add(this.viewSurface);
        this.imageOpMenu.add(this.viewProjection);
        this.imageOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.mainMenuBar.add((Component)this.imageOpMenu, 5);
    }

    private void makeAndAddPluginsMenu() {
        this.pluginsMenu = new MangoMenu("Plugins", this.fontSize, true);
        this.pluginsMenu.addMenuListener(this);
        this.pluginsMenu.setEnabled(true);
        this.getMorePlugins = new MangoMenuItem(new ViewerMenuAction("Get More Plugins...", this.mango, this.viewer), null, true, this.fontSize, false);
        this.initializePluginsMenu();
        this.mainMenuBar.add((Component)this.pluginsMenu, 6);
    }

    private void makeAndAddScriptsMenu() {
        this.scriptsMenu = new MangoMenu("Scripts", this.fontSize, true);
        this.scriptsMenu.addMenuListener(this);
        this.scriptsMenu.setEnabled(true);
        this.editScriptMenuItem = new MangoMenuItem(new ViewerMenuAction("Edit Script...", this.mango, this.viewer), "Edit Script", this.fontSize, false);
        this.newScriptMenu = new MangoMenu("Record Script", this.fontSize, true);
        this.newScriptMenuItem = new MangoMenuItem(new ViewerMenuAction("Without User Input...", this.mango, this.viewer), "Record Script (Without User Input)", this.fontSize, false);
        this.newScriptMenuItem.setActionCommand("Record Script Without User Input...");
        this.newScriptMenuDialogsItem = new MangoMenuItem(new ViewerMenuAction("With User Input...", this.mango, this.viewer), "Record Script (With User Input)", this.fontSize, false);
        this.newScriptMenuDialogsItem.setActionCommand("Record Script With User Input...");
        if (!this.mango.isApplet()) {
            this.updateScriptsMenu();
        }
    }

    private void makeAndAddROIMenu() {
        this.addROI = new MangoMenuItem(new ViewerMenuAction("Threshold to ROI...", this.mango, this.viewer), "Threshold to ROI", this.fontSize, false);
        this.shapesROI = new MangoMenuItem(new ViewerMenuAction("Add ROI...", this.mango, this.viewer), "Add ROI", this.fontSize, false);
        this.propogateROI = new MangoMenuItem(new ViewerMenuAction("Propagate...", this.mango, this.viewer), "Propagate ROI", this.fontSize, false);
        this.shrinkWrapROI = new MangoMenuItem(new ViewerMenuAction("Shrink Wrap...", this.mango, this.viewer), "Shrink Wrap ROI", this.fontSize, false);
        this.convexHullROI = new MangoMenuItem(new ViewerMenuAction("Convex Hull", this.mango, this.viewer), "Convex Hull ROI", this.fontSize, false);
        this.closeROI = new MangoMenuItem(new ViewerMenuAction("Close...", this.mango, this.viewer), "Close ROI", this.fontSize, false);
        this.openROI = new MangoMenuItem(new ViewerMenuAction("Open...", this.mango, this.viewer), "Open ROI", this.fontSize, false);
        this.dilateROI = new MangoMenuItem(new ViewerMenuAction("Dilate...", this.mango, this.viewer), "Dilate ROI", this.fontSize, false);
        this.erodeROI = new MangoMenuItem(new ViewerMenuAction("Erode...", this.mango, this.viewer), "Erode ROI", this.fontSize, false);
        this.roiCounts = new MangoMenuItem(new ViewerMenuAction("ROI Inspector", this.mango, this.viewer), "ROI Inspector", this.fontSize, false);
        this.mathROI = new MangoMenuItem(new ViewerMenuAction("ROI Logic Calculator...", this.mango, this.viewer), "ROI Logic Calculator", this.fontSize, false);
        this.reflectROI = new MangoMenuItem(new ViewerMenuAction("Reflect...", this.mango, this.viewer), "Reflect", this.fontSize, false);
        this.roiOpMenu = new MangoMenu("ROI", this.fontSize, false);
        this.roiOpMenu.setEnabled(true);
        this.roiOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.roiOpMenu.addMenuListener(this);
        this.roiOpMenu.add(this.mathROI);
        this.roiOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.roiOpMenu.add(this.shapesROI);
        this.roiOpMenu.add(this.addROI);
        this.roiOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.roiOpMenu.add(this.roiCounts);
        this.roiOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.roiOpMenu.add(this.dilateROI);
        this.roiOpMenu.add(this.erodeROI);
        this.roiOpMenu.add(this.closeROI);
        this.roiOpMenu.add(this.openROI);
        this.roiOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.roiOpMenu.add(this.shrinkWrapROI);
        this.roiOpMenu.add(this.convexHullROI);
        this.roiOpMenu.add(this.propogateROI);
        this.roiOpMenu.add(this.reflectROI);
        this.roiOpMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.mainMenuBar.add((Component)this.roiOpMenu, 4);
    }

    private void makeAndAddViewMenu() {
        this.viewMenu = new MangoMenu("View", this.fontSize, false);
        this.viewMenu.setEnabled(true);
        this.viewROIEdge = new MangoCheckBoxMenuItem("ROI Edge", "Toggle ROI Edge", this.fontSize, false);
        this.viewROIMask = new MangoCheckBoxMenuItem("ROI Mask", "Toggle ROI Mask", this.fontSize, false);
        this.viewROIEdge.setAction(new ViewerMenuAction("ROI Edge", this.mango, this.viewer));
        this.viewROIMask.setAction(new ViewerMenuAction("ROI Mask", this.mango, this.viewer));
        this.viewOverlaysCurrent = new MangoCheckBoxMenuItem("Current Overlay", "View Current Overlay", this.fontSize, false);
        this.viewOverlaysAll = new MangoCheckBoxMenuItem("All Overlays", "View All Overlays", this.fontSize, false);
        this.viewOverlaysCurrent.setAction(new ViewerMenuAction("Current Overlay", this.mango, this.viewer));
        this.viewOverlaysAll.setAction(new ViewerMenuAction("All Overlays", this.mango, this.viewer));
        this.viewLowerCrosshairs = new MangoCheckBoxMenuItem("Lower Crosshairs", "Toggle Lower Crosshairs", this.fontSize, false);
        this.viewLowerCrosshairs.setAction(new ViewerMenuAction("Lower Crosshairs", this.mango, this.viewer));
        this.viewMainCrosshairs = new MangoCheckBoxMenuItem("Main Crosshairs", "Toggle Main Crosshairs", this.fontSize, false);
        this.viewMainCrosshairs.setAction(new ViewerMenuAction("Main Crosshairs", this.mango, this.viewer));
        this.viewOrientation = new MangoCheckBoxMenuItem("Orientation", "Toggle Orientation", this.fontSize, false);
        this.viewOrientation.setAction(new ViewerMenuAction("Orientation", this.mango, this.viewer));
        this.viewMainSliceAxial = new MangoCheckBoxMenuItem(new ViewerMenuAction("Set Main Slice Axial", this.mango, this.viewer), "Set Main Slice Axial", this.fontSize, false);
        this.viewMainSliceAxial.setText("Axial");
        this.viewMainSliceAxial.setActionCommand("Set Main Slice Axial");
        this.viewMainSliceCoronal = new MangoCheckBoxMenuItem(new ViewerMenuAction("Set Main Slice Coronal", this.mango, this.viewer), "Set Main Slice Coronal", this.fontSize, false);
        this.viewMainSliceCoronal.setText("Coronal");
        this.viewMainSliceCoronal.setActionCommand("Set Main Slice Coronal");
        this.viewMainSliceSagittal = new MangoCheckBoxMenuItem(new ViewerMenuAction("Set Main Slice Sagittal", this.mango, this.viewer), "Set Main Slice Sagittal", this.fontSize, false);
        this.viewMainSliceSagittal.setText("Sagittal");
        this.viewMainSliceSagittal.setActionCommand("Set Main Slice Sagittal");
        MangoMenu mainSliceMenu = new MangoMenu("Main Slice", this.fontSize, false);
        mainSliceMenu.add(this.viewMainSliceAxial);
        mainSliceMenu.add(this.viewMainSliceCoronal);
        mainSliceMenu.add(this.viewMainSliceSagittal);
        this.viewROIStats = new MangoCheckBoxMenuItem("ROI Slice Stats", "Toggle ROI Slice Stats", this.fontSize, false);
        this.viewROIStats.setAction(new ViewerMenuAction("ROI Slice Stats", this.mango, this.viewer));
        this.viewLabels = new MangoCheckBoxMenuItem("Labels", "Toggle Labels", this.fontSize, false);
        this.viewLabels.setAction(new ViewerMenuAction("Labels", this.mango, this.viewer));
        this.viewROILinesMeasure = new MangoCheckBoxMenuItem("Ruler", "Toggle Ruler", this.fontSize, false);
        this.viewROILinesMeasure.setAction(new ViewerMenuAction("Ruler", this.mango, this.viewer));
        this.viewROILinesAngles = new MangoCheckBoxMenuItem("Angle", "Toggle Angle", this.fontSize, false);
        this.viewROILinesAngles.setAction(new ViewerMenuAction("Angle", this.mango, this.viewer));
        this.viewSingle = new MangoCheckBoxMenuItem("Slice", "View Slice Only", this.fontSize, true);
        this.viewSingle.setAction(new ViewerMenuAction("Slice", this.mango, this.viewer));
        this.viewOrtho = new MangoCheckBoxMenuItem("Orthogonal (Tall)", "View Orthogonal (Tall)", this.fontSize, true);
        this.viewOrtho.setAction(new ViewerMenuAction("Orthogonal (Tall)", this.mango, this.viewer));
        this.viewWide = new MangoCheckBoxMenuItem("Orthogonal (Wide)", "View Orthogonal (Wide)", this.fontSize, true);
        this.viewWide.setAction(new ViewerMenuAction("Orthogonal (Wide)", this.mango, this.viewer));
        this.viewDicomOverlay = new MangoCheckBoxMenuItem("Annotations", "Annotations", this.fontSize, false);
        this.viewDicomOverlay.setAction(new ViewerMenuAction("Annotations", this.mango, this.viewer));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.viewSingle);
        bg.add(this.viewOrtho);
        bg.add(this.viewWide);
        this.viewerZoomToggle = new MangoMenuItem(new ViewerMenuAction("Toggle Zoom", this.mango, this.viewer), "Toggle Zoom", this.fontSize, false);
        this.viewMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.viewMenu.add(this.viewOrientation);
        this.viewMenu.add(mainSliceMenu);
        this.viewMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.viewMenu.add(this.viewROILinesMeasure);
        this.viewMenu.add(this.viewROILinesAngles);
        this.viewMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.viewMenu.add(this.viewMainCrosshairs);
        this.viewMenu.add(this.viewLowerCrosshairs);
        this.viewMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.viewMenu.add(this.viewROIEdge);
        this.viewMenu.add(this.viewROIMask);
        this.viewMenu.add(this.viewROIStats);
        this.viewMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.viewMenu.add(this.viewDicomOverlay);
        this.viewMenu.add(this.viewLabels);
        this.viewMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.viewMenu.add(this.viewOverlaysCurrent);
        this.viewMenu.add(this.viewOverlaysAll);
        this.viewMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.viewMenu.add(this.viewerZoomToggle);
        this.viewMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        if (!this.mango.isApplet()) {
            this.viewMenu.add(this.viewSingle);
            this.viewMenu.add(this.viewOrtho);
            this.viewMenu.add(this.viewWide);
            this.viewMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        }
        this.viewMenu.addMenuListener(this);
        this.mainMenuBar.add((Component)this.viewMenu, 2);
    }

    private void makeAndAddWindowMenu() {
        this.windowMenu = new MangoMenu("Window", this.fontSize, true);
        this.windowMenu.setEnabled(true);
        this.windowMax = new MangoMenuItem(new ViewerMenuAction("Maximize", this.mango, this.viewer), "Maximize Window", this.fontSize, true);
        this.windowMin = new MangoMenuItem(new ViewerMenuAction("Dock", this.mango, this.viewer), null, this.fontSize, true);
        this.windowMin.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.windowIncrement = new MangoMenuItem(new ViewerMenuAction("Zoom In", this.mango, this.viewer), null, this.fontSize, true);
        this.windowIncrement.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.windowDecrement = new MangoMenuItem(new ViewerMenuAction("Zoom Out", this.mango, this.viewer), null, this.fontSize, true);
        this.windowDecrement.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.windowMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.windowMenu.add(this.windowMax);
        this.windowMenu.add(this.windowMin);
        this.windowMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.windowMenu.add(this.windowIncrement);
        this.windowMenu.add(this.windowDecrement);
        this.windowMenu.add(new JToolBar.Separator(new Dimension(0, 10)));
        this.windowMenu.addMenuListener(this);
        this.mainMenuBar.add((Component)this.windowMenu, 7);
    }

    private void makeFlags() {
        this.dynamicROIFlag = new JLabel(FLAG_DYNAMIC_ROI);
        this.dynamicROIFlag.setForeground(Color.RED);
        this.dynamicROIFlag.setVisible(false);
        this.mainMenuBar.add(Box.createHorizontalGlue());
        this.mainMenuBar.add(this.dynamicROIFlag);
        this.mainMenuBar.add(Box.createHorizontalStrut(8));
    }

    private void updateAnalysisMenu(boolean enable) {
        ROIManager manager = this.viewer.getROIManager();
        boolean hasManager = manager != null;
        boolean hasROI = hasManager && manager.hasROI();
        boolean hasSelectedROI = hasManager && this.viewer.hasSelectedROIs();
        boolean hasSelectedLOI = this.viewer.hasSelectedLOIs();
        boolean hasSelectedPOI = this.viewer.hasSelectedPOIs();
        boolean showROIs = this.viewer.isShowingROI();
        boolean inWorkingState = this.viewer.isInWorkingState();
        boolean isTimeseries = this.viewer.getCurrentVolume().getNumTimepoints() > 1;
        boolean isRGB = this.viewer.isRGB();
        this.analysisMenu.setEnabled(enable);
        this.roiStats.setEnabled(enable && !isRGB);
        this.imageStats.setEnabled(enable && !isRGB);
        this.analysisTimeStats.setEnabled(!inWorkingState && isTimeseries && !isRGB);
        this.analysisAllVolsStats.setEnabled(!inWorkingState && isTimeseries && !isRGB);
        this.analysisVolStats.setEnabled(!inWorkingState && !isRGB);
        this.analysisAllSliceStats.setEnabled(!inWorkingState && !isRGB);
        this.analysisSliceStats.setEnabled(!inWorkingState && !isRGB);
        this.analysisTimeStats.setVisible(!isRGB);
        this.analysisAllVolsStats.setVisible(!isRGB);
        this.analysisROITimeStats.setEnabled((hasROI && hasSelectedROI || hasSelectedLOI || hasSelectedPOI) && showROIs && !inWorkingState && isTimeseries && !isRGB);
        this.analysisAllROIVolsStats.setEnabled((hasROI && hasSelectedROI || hasSelectedLOI || hasSelectedPOI) && showROIs && !inWorkingState && isTimeseries && !isRGB);
        this.analysisROIVolStats.setEnabled((hasROI && hasSelectedROI || hasSelectedLOI || hasSelectedPOI) && showROIs && !inWorkingState && !isRGB);
        this.analysisROISliceStats.setEnabled((hasROI && hasSelectedROI || hasSelectedLOI || hasSelectedPOI) && showROIs && !inWorkingState && !isRGB);
        this.analysisAllROISliceStats.setEnabled((hasROI && hasSelectedROI || hasSelectedLOI || hasSelectedPOI) && showROIs && !inWorkingState && !isRGB);
        this.analysisROITimeStats.setVisible(!isRGB);
        this.analysisAllROIVolsStats.setVisible(!isRGB);
        this.analysisHistrogram.setEnabled(!inWorkingState && !isRGB);
        this.analysisCrosssection.setEnabled(!inWorkingState && !isRGB);
        this.analysisTimeseries.setEnabled(!inWorkingState && isTimeseries && !isRGB);
        this.analysisTimeseries.setVisible(true);
        this.clusterAnalysis.setEnabled(!inWorkingState && !isRGB);
        this.clusterROIAnalysis.setEnabled(!inWorkingState && !isRGB);
        this.logicalManager.setEnabled(!inWorkingState && !isRGB);
        this.roiCounts.setEnabled(!inWorkingState && !isRGB);
    }

    private void updateEditMenu(boolean enable) {
        this.editMenu.setEnabled(enable);
        boolean hasUndo = this.viewer.hasUndo();
        boolean hasRedo = this.viewer.hasRedo();
        boolean hasSelected = this.viewer.hasSelected();
        boolean canPaste = this.viewer.canPaste();
        boolean inWorkingState = this.viewer.isInWorkingState();
        boolean hasActivePolyline = this.viewer.hasActivePolyLine();
        boolean isTimeseries = this.viewer.isCurrentVolumeSeries();
        boolean isUsingTransform = this.viewer.isUsingTransform();
        boolean isRGB = this.viewer.isRGB();
        this.editFlip.setEnabled(enable);
        this.undoROI.setEnabled(enable && hasUndo && !inWorkingState && !isRGB);
        this.redoROI.setEnabled(enable && hasRedo && !inWorkingState && !isRGB);
        this.editCopy.setEnabled(enable && hasSelected && !inWorkingState && !isRGB);
        this.editCut.setEnabled(enable && hasSelected && !inWorkingState && !isRGB);
        this.editPaste.setEnabled(enable && canPaste && !inWorkingState && !isRGB);
        this.clearROI.setEnabled(enable && (hasSelected || hasActivePolyline) && !inWorkingState && !isRGB);
        this.editSelectAll.setEnabled(enable && !inWorkingState && !isRGB);
        this.editDeselectAll.setEnabled(enable && !inWorkingState && !isRGB);
        this.editPixel.setEnabled(enable && !isUsingTransform && !inWorkingState && !isRGB);
        this.editNotes.setEnabled(enable && !inWorkingState && !isRGB);
        this.editFlipLR.setEnabled(enable && !inWorkingState);
        this.editFlipAP.setEnabled(enable && !inWorkingState);
        this.editFlipSI.setEnabled(enable && !inWorkingState);
        this.editOrigin.setEnabled(enable && !inWorkingState);
        this.editMaxMin.setEnabled(enable && !inWorkingState);
        this.editTimeseriesRange.setEnabled(enable && !inWorkingState);
        this.editTimeseriesRange.setVisible(isTimeseries);
        this.editSeriesLabels.setVisible(isTimeseries && !this.mango.isApplet() && !isRGB);
    }

    private void updateFileMenu(boolean enable) {
        this.fileLoadROI.setEnabled(enable);
        boolean imageLoaded = this.viewer.isImageLoaded();
        boolean canBeSaved = this.viewer.canBeSaved();
        boolean roiCanBeSaved = this.viewer.roiCanBeSaved(true);
        boolean overlaysCanBeSaved = this.viewer.overlayCanBeSaved();
        boolean canAddOverlay = this.viewer.getOverlayManager().getNumInStack() < 8;
        boolean hasOverlays = this.viewer.getNumOverlays() > 0;
        boolean inWorkingState = this.viewer.isInWorkingState();
        boolean enoughViewers = this.mango.getNumViewers() > 1;
        boolean isTempImage = this.viewer.isTempImage();
        boolean isRGB = this.viewer.isRGB();
        this.fileSave.setEnabled(canBeSaved && !inWorkingState && imageLoaded && !isRGB);
        this.fileSaveAs.setEnabled(!inWorkingState && imageLoaded && !isRGB);
        this.fileRevert.setEnabled(!isTempImage && !inWorkingState && imageLoaded);
        this.fileAddOverlay.setEnabled(canAddOverlay && !inWorkingState && imageLoaded && !isRGB);
        this.fileParametric.setEnabled(canAddOverlay && !inWorkingState && imageLoaded && !isRGB);
        this.fileOnlineOverlay.setEnabled(canAddOverlay && !inWorkingState && imageLoaded && !isRGB);
        this.fileOnlineROI.setEnabled(canAddOverlay && !inWorkingState && imageLoaded && !isRGB);
        this.fileClose.setEnabled(canAddOverlay && !inWorkingState && imageLoaded);
        this.showFile.setEnabled(canAddOverlay && !inWorkingState && imageLoaded);
        this.utilityInfo.setEnabled(canAddOverlay && !inWorkingState && imageLoaded);
        this.saveROI.setEnabled(roiCanBeSaved && !inWorkingState && imageLoaded && !isRGB);
        this.fileRemoveOverlay.setEnabled(hasOverlays && !inWorkingState && imageLoaded && !isRGB);
        this.fileLoadROI.setEnabled(!inWorkingState && imageLoaded && !isRGB);
        this.fileOverlay.setEnabled(!inWorkingState && enoughViewers && imageLoaded && !isRGB);
        this.fileSaveOverlays.setEnabled(!inWorkingState && hasOverlays && overlaysCanBeSaved && imageLoaded && !isRGB);
        this.viewer.updateWindowTitle();
    }

    private void updateFlags() {
        if (this.dynamicROIFlag != null) {
            this.dynamicROIFlag.setVisible(this.viewer.getROIManager().isUsing4dROI());
        }
    }

    private void updateImageMenu(boolean enable) {
        boolean inWorkingState = this.viewer.isInWorkingState();
        boolean isTimeseries = this.viewer.getVolume().getNumTimepoints() > 1;
        boolean canShowSurface = !Platform.isSandboxed();
        boolean isRGB = this.viewer.isRGB();
        this.arithmetic.setEnabled(enable && !inWorkingState && !isRGB);
        this.filter.setEnabled(enable && !inWorkingState && !isRGB);
        this.rankFilter.setEnabled(enable && !inWorkingState && !isRGB);
        this.transformTools.setEnabled(enable && !inWorkingState && !isRGB);
        this.timeseriesMake.setEnabled(enable && !inWorkingState && !isRGB);
        this.timeseriesMake.setVisible(isTimeseries && !this.mango.isApplet() && !isRGB);
        this.viewSurface.setEnabled(enable && !inWorkingState && !isRGB);
        this.viewProjection.setEnabled(enable && !inWorkingState && !isRGB);
        this.viewSurface.setVisible(canShowSurface);
    }

    private void updatePluginMenu(boolean enable) {
        boolean isInWorkingState = this.viewer.isInWorkingState();
        if (this.pluginsMenu != null) {
            int count = this.pluginsMenu.getItemCount();
            for (int ctr = 0; ctr < count; ++ctr) {
                JMenuItem jmi = this.pluginsMenu.getItem(ctr);
                if (jmi == null) continue;
                if (jmi instanceof MangoMenuPlaceholderItem) {
                    jmi.setEnabled(enable && !isInWorkingState && Mango.getInstance().getMovedMenuMap().get(((MangoMenuPlaceholderItem)jmi).getPreference()) == false);
                    continue;
                }
                jmi.setEnabled(enable && !isInWorkingState);
            }
        }
        this.getMorePlugins.setEnabled(true);
    }

    private void updateROIMenu(boolean enable) {
        this.roiOpMenu.setEnabled(enable);
        ROIManager manager = this.viewer.getROIManager();
        boolean hasManager = manager != null;
        boolean hasROI = hasManager && manager.hasROI();
        boolean hasSelected = this.viewer.hasSelected();
        boolean hasSelectedROI = hasManager && this.viewer.hasSelectedROIs();
        boolean inWorkingState = this.viewer.isInWorkingState();
        boolean isRGB = this.viewer.isRGB();
        this.propogateROI.setEnabled(hasROI && hasSelectedROI && !inWorkingState && !isRGB);
        this.shrinkWrapROI.setEnabled(hasROI && hasSelectedROI && !inWorkingState && !isRGB);
        this.convexHullROI.setEnabled(hasROI && hasSelectedROI && !inWorkingState && !isRGB);
        this.reflectROI.setEnabled(hasSelected && !inWorkingState && !isRGB);
        this.mathROI.setEnabled(hasROI && !inWorkingState && !isRGB);
        this.closeROI.setEnabled(hasROI && hasSelectedROI && !inWorkingState && !isRGB);
        this.openROI.setEnabled(hasROI && hasSelectedROI && !inWorkingState && !isRGB);
        this.dilateROI.setEnabled(hasROI && hasSelectedROI && !inWorkingState && !isRGB);
        this.erodeROI.setEnabled(hasROI && hasSelectedROI && !inWorkingState && !isRGB);
        this.addROI.setEnabled(!inWorkingState && !isRGB);
        this.shapesROI.setEnabled(!inWorkingState && !isRGB);
    }

    private void updateWindowMenu(boolean enable) {
        this.windowDecrement.setEnabled(enable);
        this.windowIncrement.setEnabled(enable);
        this.windowMax.setEnabled(enable);
        this.windowMin.setEnabled(enable);
    }

    private void updateViewMenu(boolean enable) {
        this.viewMenu.setEnabled(enable);
        boolean showLowerCrosshairs = this.viewer.isShowingLowerCrosshairs();
        boolean showMainCrosshairs = this.viewer.isShowingMainCrosshairs();
        boolean showAllOverlay = this.viewer.isShowingAllOverlay();
        boolean showCurrentOverlay = this.viewer.isShowingCurrentOverlay();
        boolean showOrientation = this.viewer.isShowingOrientation();
        boolean showStats = this.viewer.isShowingROIStats();
        boolean isInWorkingState = this.viewer.isInWorkingState();
        this.viewLowerCrosshairs.setSelected(showLowerCrosshairs);
        this.viewMainCrosshairs.setSelected(showMainCrosshairs);
        this.viewROIEdge.setSelected(this.viewer.isShowingROIEdge() && !this.viewer.isViewerHideROI());
        this.viewROIMask.setSelected(this.viewer.isShowingROIMask() && !this.viewer.isViewerHideROI());
        this.viewROILinesMeasure.setSelected(this.viewer.isShowingRuler());
        this.viewROILinesAngles.setSelected(this.viewer.isShowingAngle());
        this.viewOrientation.setSelected(showOrientation);
        this.viewOverlaysCurrent.setSelected(showCurrentOverlay);
        this.viewOverlaysAll.setSelected(showAllOverlay);
        this.viewROIStats.setSelected(showStats);
        this.viewLabels.setSelected(this.viewer.isShowingLabels());
        this.viewSingle.setSelected(this.viewer.isSingleSliceMode());
        this.viewWide.setSelected(this.viewer.isOrthoWide());
        this.viewOrtho.setSelected(this.viewer.isOrthoSliceMode());
        this.viewMainSliceAxial.setSelected(this.viewer.getMainSliceDirection() == 0);
        this.viewMainSliceCoronal.setSelected(this.viewer.getMainSliceDirection() == 1);
        this.viewMainSliceSagittal.setSelected(this.viewer.getMainSliceDirection() == 2);
        this.viewLowerCrosshairs.setEnabled(!isInWorkingState);
        this.viewMainCrosshairs.setEnabled(!isInWorkingState);
        this.viewROIMask.setEnabled(!isInWorkingState);
        this.viewROIEdge.setEnabled(!isInWorkingState);
        this.viewOverlaysCurrent.setEnabled(!isInWorkingState);
        this.viewOverlaysAll.setEnabled(!isInWorkingState);
        this.viewOrientation.setEnabled(!isInWorkingState);
        this.viewROILinesMeasure.setEnabled(!isInWorkingState);
        this.viewROILinesAngles.setEnabled(!isInWorkingState);
        this.viewROIStats.setEnabled(!isInWorkingState);
        this.viewLabels.setEnabled(!isInWorkingState);
        this.viewOrtho.setEnabled(!isInWorkingState);
        this.viewWide.setEnabled(!isInWorkingState);
        this.viewSingle.setEnabled(!isInWorkingState);
        this.viewMainSliceAxial.setEnabled(!isInWorkingState);
        this.viewMainSliceCoronal.setEnabled(!isInWorkingState);
        this.viewMainSliceSagittal.setEnabled(!isInWorkingState);
        this.viewerZoomToggle.setText("Toggle Zoom (" + this.viewer.getZoomString() + "%)");
        this.viewerZoomToggle.setEnabled(!isInWorkingState);
        this.viewDicomOverlay.setSelected(this.viewer.isShowingDicomOverlay());
        this.viewDicomOverlay.setEnabled(!isInWorkingState);
    }

    private void addAllMenuItemFieldsToMap() {
        Field[] allFields;
        for (Field field : allFields = this.getClass().getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(JMenuItem.class)) continue;
            JMenuItem item = null;
            try {
                item = (JMenuItem)field.get(this);
            }
            catch (IllegalArgumentException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                AppLogger.error((Throwable)ex);
            }
            if (item == null) continue;
            this.addMenuItemToMap(item);
        }
    }

    private void addMenuItemToMap(JMenuItem item) {
        String text;
        String name = item.getName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            this.MENU_ACTION_MAP.put(name, item);
        }
        if (StringUtils.isNotBlank((CharSequence)(text = item.getText()))) {
            this.MENU_NAME_MAP.put(text, item);
        }
    }

    private void clearAllAccelerators() {
        Collection<JMenuItem> items = this.MENU_ACTION_MAP.values();
        for (JMenuItem item : items) {
            item.setAccelerator(null);
        }
    }

    public void updateAllAccelerators(String[] actions) {
        this.clearAllAccelerators();
        for (int ctr = 0; ctr < actions.length; ++ctr) {
            String actionLabel = actions[ctr];
            JMenuItem item = this.MENU_ACTION_MAP.get(actionLabel);
            if (item == null) continue;
            item.setAccelerator(KeyStroke.getKeyStroke(MangoPreferences.FUNCTION_KEY_CODES.get(ctr), 0));
        }
    }

    public JMenuItem getMenuItem(String action) {
        JMenuItem item = this.MENU_ACTION_MAP.get(action);
        if (item == null) {
            item = this.MENU_NAME_MAP.get(action);
        }
        return item;
    }
}

