/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.roiinspector;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.MangoPlaceholderTextField;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.roiinspector.ROIInspectorPanel;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.roi.points.manager.POIManager;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class ROIInspectorTool
extends JFrame
implements ActionListener,
KeyListener,
ViewerAssociated,
WindowListener {
    private JCheckBox selectBox;
    private JCheckBox deselectBox;
    private JPanel labelPanel;
    private JPanel mainPanel;
    private MangoPlaceholderTextField labelText;
    private boolean hasBeenDisplayed;
    private final ROIInspectorPanel[] lineCountsLabels = new ROIInspectorPanel[64];
    private final ROIInspectorPanel[] maskIconLabels = new ROIInspectorPanel[64];
    private final ROIInspectorPanel[] pointCountsLabels = new ROIInspectorPanel[64];
    private final SliceViewer viewer;
    private final transient Mango mango;
    private int numLineColors;
    private int numPointColors;
    private int numRegionColors;
    private long lineMask;
    private long pointMask;
    private long regionMask;
    private static final long serialVersionUID = 1L;
    private transient Coordinate lastFoundCoordinate;
    private transient LOIShape currentLOI;
    private transient Object lastSelected;
    private transient POI currentPOI;
    public static final String NAME = "ROI Inspector";
    public static final String PLACEHOLDER_TEXT = "Enter a label";
    public static final int PADDING = 6;

    public ROIInspectorTool(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
        this.createLabels();
        this.updateCountLabels();
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.updateLabel();
        this.viewer.setShowLabels(true);
        this.viewer.updateViewer();
        this.updateEnabledItems();
    }

    private void updateEnabledItems() {
        this.deselectBox.setEnabled(this.selectBox.isSelected());
        if (!this.selectBox.isSelected()) {
            this.deselectBox.setSelected(false);
        }
    }

    @Override
    public String getDescription() {
        return NAME;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        this.updateLabel();
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void setVisible(boolean bool) {
        if (bool) {
            if (!this.hasBeenDisplayed) {
                this.setLocation(DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), this.getSize(), null, this.mango.isApplet()));
                this.hasBeenDisplayed = true;
            }
            this.updateCounts();
        }
        super.setVisible(bool);
        this.updateEnabledItems();
    }

    public void updateCounts() {
        this.updateMasks();
        this.updateUI();
        this.updateCountLabels();
    }

    public void updateLabels() {
        int ctr;
        POIManager poiManager = this.viewer.getPOIManager();
        for (ctr = 0; ctr < 64; ++ctr) {
            if ((this.pointMask & 1L << ctr) == 0L) continue;
            this.pointCountsLabels[ctr].setLabel(poiManager.getAllLabelsForColor(ctr));
        }
        for (ctr = 0; ctr < 64; ++ctr) {
            if ((this.lineMask & 1L << ctr) == 0L) continue;
            this.lineCountsLabels[ctr].setLabel(this.viewer.getAllShapeLabelsForColor(ctr));
        }
        ROIManager roiManager = this.viewer.getROIManager();
        int maxColors = roiManager.getMaximumColors();
        for (int ctr2 = 0; ctr2 < 64; ++ctr2) {
            if ((this.regionMask & 1L << ctr2) == 0L) continue;
            this.maskIconLabels[ctr2].setLabel(this.viewer.getROIManager().getLabel(ctr2, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr2, maxColors)));
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
        this.updateLabelEnabled(false);
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    private void createLabels() {
        MangoColorSelectedListener pointSelector = new MangoColorSelectedListener(){

            public void colorSelected(int colorNum) {
                ROIInspectorTool.this.findNextPoint(colorNum);
            }
        };
        MangoColorSelectedListener lineSelector = new MangoColorSelectedListener(){

            public void colorSelected(int colorNum) {
                ROIInspectorTool.this.findNextLine(colorNum);
            }
        };
        MangoColorSelectedListener regionSelector = new MangoColorSelectedListener(){

            public void colorSelected(int colorNum) {
                ROIInspectorTool.this.findMask(colorNum);
            }
        };
        ROIColor[] colorSet = ROIColor.getROIColors();
        for (int ctr = 0; ctr < 64; ++ctr) {
            ROIColor color = colorSet[ctr];
            this.pointCountsLabels[ctr] = new ROIInspectorPanel(this.viewer.getROIManager(), pointSelector, color, this.viewer.getROIManager().getLabel(color.getIndex(), ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr, this.viewer.getROIManager().getBuffer().getMaximumColors())));
            this.lineCountsLabels[ctr] = new ROIInspectorPanel(this.viewer.getROIManager(), lineSelector, color, this.viewer.getROIManager().getLabel(color.getIndex(), ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr, this.viewer.getROIManager().getBuffer().getMaximumColors())));
            this.maskIconLabels[ctr] = new ROIInspectorPanel(this.viewer.getROIManager(), regionSelector, color, this.viewer.getROIManager().getLabel(color.getIndex(), ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr, this.viewer.getROIManager().getBuffer().getMaximumColors())));
        }
    }

    private void createUI() {
        this.labelText = new MangoPlaceholderTextField(PLACEHOLDER_TEXT);
        this.labelText.setMinimumSize(this.labelText.getPreferredSize());
        this.labelText.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.labelText.getPreferredSize().height));
        this.labelText.addActionListener(this);
        this.labelText.addKeyListener(this);
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new BoxLayout(this.labelPanel, 0));
        this.labelPanel.add(Box.createHorizontalGlue());
        this.labelPanel.add(this.labelText);
        this.labelPanel.add(Box.createHorizontalGlue());
        this.updateUI();
        this.addWindowListener(this);
        this.setTitle("ROI Inspector: " + this.viewer.getImageTitle());
        this.setBackground(this.mango.getPanelOutsideColor());
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.updateEnabledItems();
        this.setVisible(false);
    }

    private void findMask(int color) {
        int lastColor;
        Coordinate4D coord = null;
        boolean useLastFoundCoord = false;
        if (this.lastSelected instanceof Integer && (lastColor = ((Integer)this.lastSelected).intValue()) == color) {
            boolean bl = useLastFoundCoord = this.lastFoundCoordinate != null;
        }
        if (useLastFoundCoord) {
            coord = this.viewer.getROIManager().findROI(color, this.viewer.getCurrentIndex(), this.viewer.getMainSliceDirection(), false);
            this.lastFoundCoordinate = coord;
        } else {
            coord = this.viewer.getROIManager().findROI(color, this.viewer.getCurrentIndex(), this.viewer.getMainSliceDirection(), true);
            this.lastFoundCoordinate = coord;
        }
        if (coord != null) {
            this.viewer.setCurrentCoordinate((Coordinate)coord, true, -1);
            this.viewer.setCurrentTimepoint(coord.getSeriesPoint(), null);
            this.labelText.setText(this.viewer.getROIManager().getLabel(color, null));
            if (this.deselectBox.isSelected()) {
                this.viewer.deselectAll();
            }
            if (this.selectBox.isSelected()) {
                this.viewer.getROIManager().select(color);
            }
            this.lastSelected = color;
        }
        this.updateLabelEnabled(true);
        this.getContentPane().requestFocus();
        this.viewer.updateViewer();
    }

    private void findNextLine(int color) {
        LOIShape shape;
        int direction = this.viewer.getMainSliceDirection();
        int sliceNum = this.viewer.getMainSliceNumber();
        if (this.currentLOI != null) {
            if (this.currentLOI.getColor() == color) {
                direction = this.currentLOI.getSliceDirection();
                sliceNum = this.currentLOI.getSliceNum();
            } else {
                this.currentLOI = null;
            }
        }
        if ((shape = this.viewer.getNextShape(sliceNum, direction, this.currentLOI, color)) != null) {
            Point pt = shape.getPoints().get(0);
            direction = shape.getSliceDirection();
            Coordinate coor = null;
            if (direction == 0) {
                coor = new Coordinate((double)pt.x, (double)pt.y, (double)shape.getSliceNum());
            } else if (direction == 1) {
                coor = new Coordinate((double)pt.x, (double)shape.getSliceNum(), (double)pt.y);
            } else if (direction == 2) {
                coor = new Coordinate((double)shape.getSliceNum(), (double)pt.x, (double)pt.y);
            }
            this.viewer.setMainSliceDirection(direction);
            this.viewer.setCurrentCoordinate(coor, true, -1);
            this.currentLOI = shape;
            this.labelText.setText(shape.getName());
            if (this.deselectBox.isSelected()) {
                this.viewer.deselectAll();
            }
            if (this.selectBox.isSelected()) {
                this.currentLOI.setSelectedState(true);
            }
            this.lastSelected = shape;
        }
        this.updateLabelEnabled(true);
        this.getContentPane().requestFocus();
        this.viewer.updateViewer();
    }

    private void findNextPoint(int color) {
        POI poi = null;
        if (this.currentPOI != null) {
            if (this.currentPOI.getColor() != color) {
                this.currentPOI = null;
            } else {
                poi = this.viewer.getPOIManager().getNextPOI(this.viewer.getMainSliceNumber(), this.viewer.getMainSliceDirection(), this.currentPOI);
            }
        }
        if (poi == null) {
            poi = this.viewer.getPOIManager().getFirstPOI(this.viewer.getMainSliceDirection(), color);
        }
        if (poi != null) {
            Coordinate coor = new Coordinate((double)poi.getX(), (double)poi.getY(), (double)poi.getZ());
            this.viewer.setCurrentCoordinate(coor, true, -1);
            this.currentPOI = poi;
            this.labelText.setText(poi.getName());
            if (this.deselectBox.isSelected()) {
                this.viewer.deselectAll();
            }
            if (this.selectBox.isSelected()) {
                this.currentPOI.setSelectedState(true);
            }
            this.lastSelected = poi;
        }
        this.updateLabelEnabled(true);
        this.getContentPane().requestFocus();
        this.viewer.updateViewer();
    }

    private void updateCountLabels() {
        for (int ctr = 0; ctr < 64; ++ctr) {
            int pointCount = this.viewer.getPOIManager().getPointCount(ctr);
            this.pointCountsLabels[ctr].setCount(pointCount);
            int lineCount = this.viewer.getShapeCount(ctr);
            this.lineCountsLabels[ctr].setCount(lineCount);
        }
    }

    private void updateLabel() {
        if (this.lastSelected != null) {
            if (this.lastSelected instanceof POI) {
                POI point = (POI)this.lastSelected;
                point.setName(this.labelText.getText());
            } else if (this.lastSelected instanceof LOIShape) {
                LOIShape line = (LOIShape)this.lastSelected;
                line.setName(this.labelText.getText());
            } else if (this.lastSelected instanceof Integer) {
                int color = (Integer)this.lastSelected;
                this.viewer.setLabel(this.viewer.getROIManager().getROI(color), this.labelText.getText());
            }
        }
        this.viewer.updateViewer();
    }

    private void updateLabelEnabled(boolean enabled) {
        this.labelText.setEnabled(enabled);
        if (!enabled) {
            this.labelText.setText("");
        }
    }

    private void updateMasks() {
        long pointMaskNew = 0L;
        long lineMaskNew = 0L;
        long regionMaskNew = 0L;
        this.numPointColors = 0;
        this.numLineColors = 0;
        this.numRegionColors = this.viewer.getROIManager().getNumUsed();
        for (int ctr = 0; ctr < 64; ++ctr) {
            if (this.viewer.getPOIManager().getPointCount(ctr) > 0) {
                pointMaskNew |= 1L << ctr;
                ++this.numPointColors;
            }
            if (this.viewer.getShapeCount(ctr) > 0) {
                lineMaskNew |= 1L << ctr;
                ++this.numLineColors;
            }
            regionMaskNew = this.viewer.getROIManager().getBuffer().getUsed();
        }
        this.pointMask = pointMaskNew;
        this.lineMask = lineMaskNew;
        this.regionMask = regionMaskNew;
    }

    private void updateUI() {
        if (this.mainPanel != null) {
            this.getContentPane().remove(this.mainPanel);
        }
        JPanel mainPointsPanel = new JPanel();
        int rows = (int)Math.ceil((float)this.numPointColors / 8.0f);
        mainPointsPanel.setLayout(new GridLayout(rows > 0 ? rows : 1, 8, 0, 6));
        mainPointsPanel.setBorder(BorderFactory.createTitledBorder("Points"));
        POIManager poiManager = this.viewer.getPOIManager();
        for (int ctr = 0; ctr < 64; ++ctr) {
            if ((this.pointMask & 1L << ctr) == 0L) continue;
            mainPointsPanel.add(this.pointCountsLabels[ctr]);
            this.pointCountsLabels[ctr].setLabel(poiManager.getAllLabelsForColor(ctr));
        }
        int pointDiff = this.numPointColors % 8;
        if (pointDiff > 0 || rows == 0) {
            pointDiff = 8 - pointDiff;
            for (int ctr = 0; ctr < pointDiff; ++ctr) {
                mainPointsPanel.add(Box.createRigidArea(new Dimension(50, 25)));
            }
        }
        JPanel mainLinesPanel = new JPanel();
        rows = (int)Math.ceil((float)this.numLineColors / 8.0f);
        mainLinesPanel.setLayout(new GridLayout(rows > 0 ? rows : 1, 8, 0, 6));
        mainLinesPanel.setBorder(BorderFactory.createTitledBorder("Lines"));
        for (int ctr = 0; ctr < 64; ++ctr) {
            if ((this.lineMask & 1L << ctr) == 0L) continue;
            mainLinesPanel.add(this.lineCountsLabels[ctr]);
            this.lineCountsLabels[ctr].setLabel(this.viewer.getAllShapeLabelsForColor(ctr));
        }
        int lineDiff = this.numLineColors % 8;
        if (lineDiff > 0 || rows == 0) {
            lineDiff = 8 - lineDiff;
            for (int ctr = 0; ctr < lineDiff; ++ctr) {
                mainLinesPanel.add(Box.createRigidArea(new Dimension(50, 25)));
            }
        }
        JPanel mainMaskPanel = new JPanel();
        rows = (int)Math.ceil((float)this.numRegionColors / 8.0f);
        mainMaskPanel.setLayout(new GridLayout(rows > 0 ? rows : 1, 8, 0, 6));
        mainMaskPanel.setBorder(BorderFactory.createTitledBorder("Regions"));
        ROIManager roiManager = this.viewer.getROIManager();
        int maxColors = roiManager.getMaximumColors();
        for (int ctr = 0; ctr < 64; ++ctr) {
            if ((this.regionMask & 1L << ctr) == 0L) continue;
            mainMaskPanel.add(this.maskIconLabels[ctr]);
            this.maskIconLabels[ctr].setLabel(this.viewer.getROIManager().getLabel(ctr, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr, maxColors)));
        }
        int regionDiff = this.numRegionColors % 8;
        if (regionDiff > 0 || rows == 0) {
            regionDiff = 8 - regionDiff;
            for (int ctr = 0; ctr < regionDiff; ++ctr) {
                mainMaskPanel.add(Box.createRigidArea(new Dimension(50, 25)));
            }
        }
        this.selectBox = new JCheckBox("Select");
        this.selectBox.addActionListener(this);
        this.deselectBox = new JCheckBox("Deselect others");
        this.deselectBox.addActionListener(this);
        JPanel optionBoxPanel = new JPanel();
        optionBoxPanel.setLayout(new BoxLayout(optionBoxPanel, 0));
        optionBoxPanel.add(Box.createHorizontalGlue());
        optionBoxPanel.add(new JLabel("Options when clicked:"));
        optionBoxPanel.add(this.selectBox);
        optionBoxPanel.add(this.deselectBox);
        optionBoxPanel.add(Box.createHorizontalGlue());
        JLabel instructions = new JLabel("Click buttons to find the ROI point, line, or region.");
        JLabel instructions2 = new JLabel("Repeated clicks find the next point or slice of the ROI.");
        instructions.setForeground(Color.GRAY);
        instructions2.setForeground(Color.GRAY);
        JPanel instructionsPanel = new JPanel();
        instructionsPanel.setLayout(new BoxLayout(instructionsPanel, 0));
        instructionsPanel.add(Box.createHorizontalGlue());
        instructionsPanel.add(instructions);
        instructionsPanel.add(Box.createHorizontalGlue());
        JPanel instructionsPanel2 = new JPanel();
        instructionsPanel2.setLayout(new BoxLayout(instructionsPanel2, 0));
        instructionsPanel2.add(Box.createHorizontalGlue());
        instructionsPanel2.add(instructions2);
        instructionsPanel2.add(Box.createHorizontalGlue());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(mainPointsPanel);
        mainPanel.add(mainLinesPanel);
        mainPanel.add(mainMaskPanel);
        mainPanel.add(this.labelPanel);
        mainPanel.add(optionBoxPanel);
        mainPanel.add(instructionsPanel);
        mainPanel.add(instructionsPanel2);
        mainPanel.add(Box.createVerticalStrut(6));
        JPanel mainPanelOut = new JPanel(new BorderLayout());
        mainPanelOut.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanelOut.add((Component)mainPanel, "Center");
        this.updateLabelEnabled(false);
        this.mainPanel = mainPanelOut;
        this.getContentPane().add((Component)mainPanelOut, "Center");
        this.pack();
        this.validate();
        this.getContentPane().requestFocus();
    }
}

