/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoPlaceholderTextField;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPaneItem;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.OperationBuilder;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.range.Range;
import edu.uthscsa.ric.volume.operations.range.SeriesRangeOp;
import edu.uthscsa.ric.volume.operations.range.VolumeRangeOp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.commons.lang3.StringUtils;

public class ThresholdToROIDialog
extends JPanel
implements ActionListener,
MangoFocusableOptionPaneItem {
    private JCheckBox convexHull;
    private JCheckBox exclude0;
    private JCheckBox percentMax;
    private JCheckBox range;
    private JCheckBox shrinkWrap;
    private JCheckBox timeseries;
    private JLabel maxLabel;
    private JPanel warningPanel;
    private JRadioButton percentMaxDynamic;
    private JRadioButton percentMaxSeries;
    private JRadioButton wrap3D;
    private JRadioButton wrapAxial;
    private JRadioButton wrapCoronal;
    private JRadioButton wrapSagittal;
    private MangoFocusableOptionPane dialog;
    private MangoTextField labelText;
    private MangoTextField maxText;
    private MangoTextField minText;
    private boolean percentMaxRun;
    private final SliceViewer viewer;
    private final String defaultMax;
    private final String defaultMin;
    private final boolean allOptionsMode;
    private final boolean wrapOptionsMode;
    private static final long serialVersionUID = 1L;
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(1, false);
    public static final String PLACEHOLDER_TEXT = "Enter an optional label for this ROI";

    public ThresholdToROIDialog(SliceViewer viewer, String defaultMin, String defaultMax, boolean allOptionsMode, boolean wrapOptionsMode) {
        this.viewer = viewer;
        this.defaultMin = defaultMin;
        this.defaultMax = defaultMax;
        this.allOptionsMode = allOptionsMode;
        this.wrapOptionsMode = wrapOptionsMode;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("Range")) {
            this.updateRangeOptions();
            this.updatePercentMaxOptions();
            if (this.range.isSelected()) {
                this.shrinkWrap.setSelected(false);
                this.convexHull.setSelected(false);
            }
            this.updateShrinkWrapOptions();
        } else if (actionCommand.equals("% Max")) {
            if (this.percentMax.isSelected()) {
                if (this.percentMaxRun) {
                    this.doPercentMax();
                } else {
                    this.percentMaxRun = true;
                    if (this.viewer.getCurrentVolume().getNumTimepoints() > 1) {
                        this.updateSeriesVolumeRange();
                    } else {
                        this.updateCurrentVolumeRange();
                    }
                }
            } else {
                this.doPercentMax();
            }
        } else if (actionCommand.equals("Wrap")) {
            if (this.shrinkWrap.isSelected()) {
                this.convexHull.setSelected(false);
                this.range.setSelected(false);
            }
            this.updateShrinkWrapOptions();
            this.updateRangeOptions();
            this.updatePercentMaxOptions();
        } else if (actionCommand.equals("Convex")) {
            if (this.convexHull.isSelected()) {
                this.shrinkWrap.setSelected(false);
                this.range.setSelected(false);
            }
            this.updateShrinkWrapOptions();
            this.updateRangeOptions();
            this.updatePercentMaxOptions();
        } else if (actionCommand.equals("Series")) {
            boolean showWarning = false;
            if (this.viewer.getROIManager().isUsing4dROI() ^ this.timeseries.isSelected() && this.viewer.getROIManager().getBuffer().getUsed() != 0L) {
                showWarning = true;
            }
            this.warningPanel.setVisible(showWarning);
            if (this.dialog != null) {
                this.dialog.showAndCenter();
            }
            this.updatePercentMaxOptions();
        }
    }

    @Override
    public void doFocus() {
        this.minText.requestFocusInWindow();
        this.minText.requestFocus();
    }

    public String getLabelText() {
        return this.labelText.getText();
    }

    public String getMax() {
        return this.maxText.getText();
    }

    public String getMin() {
        return this.minText.getText();
    }

    public int getSliceDirection() {
        if (this.wrapAxial.isSelected()) {
            return 0;
        }
        if (this.wrapCoronal.isSelected()) {
            return 1;
        }
        if (this.wrapSagittal.isSelected()) {
            return 2;
        }
        return -1;
    }

    public boolean isConvexHull() {
        return this.convexHull.isSelected();
    }

    public boolean isDynamicThreshold() {
        return this.percentMaxDynamic.isSelected();
    }

    public boolean isExcludeZero() {
        return this.exclude0.isSelected();
    }

    public boolean isPercentMax() {
        return this.percentMax.isSelected();
    }

    public boolean isRange() {
        return this.range.isSelected();
    }

    public boolean isSeries() {
        return this.timeseries.isSelected();
    }

    public boolean isShrinkWrap() {
        return this.shrinkWrap.isSelected();
    }

    public void setDialog(MangoFocusableOptionPane dialog) {
        this.dialog = dialog;
    }

    private void createUI() {
        this.range = new JCheckBox("Range ");
        this.range.setActionCommand("Range");
        this.range.addActionListener(this);
        this.shrinkWrap = new JCheckBox("Shrink Wrap");
        this.shrinkWrap.setActionCommand("Wrap");
        this.shrinkWrap.addActionListener(this);
        this.exclude0 = new JCheckBox("Exclude Zero");
        this.exclude0.setActionCommand("Zero");
        this.exclude0.addActionListener(this);
        this.timeseries = new JCheckBox("Make Dynamic ROI");
        this.timeseries.setActionCommand("Series");
        this.timeseries.addActionListener(this);
        this.timeseries.setSelected(this.viewer.getROIManager().isUsing4dROI());
        this.convexHull = new JCheckBox("Convex Hull");
        this.convexHull.setActionCommand("Convex");
        this.convexHull.addActionListener(this);
        this.maxText = new MangoTextField(this.defaultMax, 6);
        this.minText = new MangoTextField(this.defaultMin, 6);
        this.maxLabel = new JLabel("Max");
        this.maxLabel.setEnabled(false);
        JLabel minLabel = new JLabel("Min");
        this.percentMax = new JCheckBox("% Max");
        this.percentMax.addActionListener(this);
        JPanel typePanelTop = new JPanel();
        typePanelTop.setLayout(new BoxLayout(typePanelTop, 0));
        typePanelTop.add(this.range);
        typePanelTop.add(this.shrinkWrap);
        typePanelTop.add(this.convexHull);
        JPanel minPanel = new JPanel();
        minPanel.add(minLabel);
        minPanel.add(this.minText);
        JPanel maxPanel = new JPanel();
        maxPanel.add(this.maxLabel);
        maxPanel.add(this.maxText);
        this.maxText.setEnabled(false);
        boolean isVOIMode = this.viewer.isMultiSliceMode();
        this.wrapAxial = new JRadioButton("Axial");
        this.wrapAxial.setEnabled(!this.allOptionsMode && isVOIMode);
        this.wrapCoronal = new JRadioButton("Coronal");
        this.wrapCoronal.setEnabled(!this.allOptionsMode && isVOIMode);
        this.wrapSagittal = new JRadioButton("Sagittal");
        this.wrapSagittal.setEnabled(!this.allOptionsMode && isVOIMode);
        this.wrap3D = new JRadioButton("3D");
        this.wrap3D.setEnabled(!this.allOptionsMode && isVOIMode);
        ButtonGroup group = new ButtonGroup();
        group.add(this.wrapAxial);
        group.add(this.wrapCoronal);
        group.add(this.wrapSagittal);
        group.add(this.wrap3D);
        int sliceDirection = this.viewer.getMainSliceDirection();
        if (sliceDirection == 0) {
            this.wrapAxial.setSelected(true);
        } else if (sliceDirection == 1) {
            this.wrapCoronal.setSelected(true);
        } else if (sliceDirection == 2) {
            this.wrapSagittal.setSelected(true);
        }
        JPanel wrapOptionsPanel = new JPanel();
        wrapOptionsPanel.add(this.wrapAxial);
        wrapOptionsPanel.add(this.wrapCoronal);
        wrapOptionsPanel.add(this.wrapSagittal);
        wrapOptionsPanel.add(this.wrap3D);
        this.setLayout(new BoxLayout(this, 1));
        if (this.allOptionsMode) {
            this.add(typePanelTop);
        }
        this.shrinkWrap.setVisible(this.allOptionsMode);
        this.convexHull.setVisible(this.allOptionsMode);
        if (this.wrapOptionsMode) {
            this.add(wrapOptionsPanel);
        }
        this.labelText = new MangoPlaceholderTextField(PLACEHOLDER_TEXT, 10);
        this.labelText.setMinimumSize(this.labelText.getPreferredSize());
        this.labelText.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.labelText.getPreferredSize().height));
        String currentLabel = this.viewer.getROIManager().getLabel(this.viewer.getROIManager().getCurrentROI(), null);
        if (StringUtils.isNotBlank((CharSequence)currentLabel)) {
            this.labelText.setText(currentLabel);
        }
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(this.labelText);
        labelPanel.add(Box.createHorizontalGlue());
        if (this.allOptionsMode) {
            this.add(labelPanel);
            this.add(Box.createVerticalStrut(8));
        }
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new BoxLayout(rangePanel, 0));
        rangePanel.add(minPanel);
        rangePanel.add(maxPanel);
        rangePanel.add(this.percentMax);
        if (this.allOptionsMode) {
            this.add(rangePanel);
        }
        this.percentMaxSeries = new JRadioButton("% Series Max");
        this.percentMaxDynamic = new JRadioButton("% Max Dynamic");
        ButtonGroup percentGroup = new ButtonGroup();
        percentGroup.add(this.percentMaxSeries);
        percentGroup.add(this.percentMaxDynamic);
        this.percentMaxSeries.setSelected(true);
        JPanel percentPanel = new JPanel();
        percentPanel.setLayout(new BoxLayout(percentPanel, 0));
        percentPanel.add(this.percentMaxSeries);
        percentPanel.add(this.percentMaxDynamic);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.exclude0);
        if (!this.allOptionsMode) {
            bottomPanel.add(this.range);
        }
        if (this.allOptionsMode && this.viewer.getCurrentScreenVolume().getVolume().getNumTimepoints() > 1) {
            bottomPanel.add(this.timeseries);
        }
        bottomPanel.add(Box.createHorizontalGlue());
        if (this.allOptionsMode) {
            this.add(bottomPanel);
        }
        if (this.viewer.getCurrentScreenVolume().getVolume().getNumTimepoints() > 1) {
            this.add(percentPanel);
        }
        if (this.allOptionsMode) {
            this.add(Box.createVerticalStrut(8));
        }
        JLabel warningLabel = new JLabel("<html><center>Warning: The existing ROI will be overwritten.<br>This operation cannot be undone.</center></html>", 0);
        warningLabel.setFont(warningLabel.getFont().deriveFont((float)warningLabel.getFont().getSize() - 2.0f));
        warningLabel.setForeground(Color.RED);
        this.warningPanel = new JPanel();
        this.warningPanel.setLayout(new BoxLayout(this.warningPanel, 0));
        this.warningPanel.add(Box.createHorizontalGlue());
        this.warningPanel.add(warningLabel);
        this.warningPanel.add(Box.createHorizontalGlue());
        this.warningPanel.setVisible(false);
        if (this.allOptionsMode) {
            this.add(this.warningPanel);
        }
        this.updatePercentMaxOptions();
    }

    private void doPercentMax() {
        double imageMax = this.viewer.getCurrentVolume().getImageMax();
        try {
            double minNum;
            if (this.percentMax.isSelected()) {
                minNum = Double.parseDouble(this.minText.getText());
                this.minText.setText(FORMATTER.format(minNum / imageMax * 100.0));
            } else {
                minNum = Double.parseDouble(this.minText.getText());
                this.minText.setText(FORMATTER.format(minNum / 100.0 * imageMax));
            }
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        try {
            if (this.percentMax.isSelected()) {
                double maxNum = Double.parseDouble(this.maxText.getText());
                this.maxText.setText(FORMATTER.format(maxNum / imageMax * 100.0));
            } else {
                double maxNum = Double.parseDouble(this.maxText.getText());
                this.maxText.setText(FORMATTER.format(maxNum / 100.0 * imageMax));
            }
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        this.updatePercentMaxOptions();
    }

    private void updatePercentMaxOptions() {
        this.percentMaxSeries.setEnabled(this.percentMax.isSelected());
        this.percentMaxDynamic.setEnabled(this.percentMax.isSelected() && this.timeseries.isSelected());
        if (!this.percentMaxSeries.isEnabled()) {
            this.percentMaxSeries.setSelected(false);
        }
        if (this.percentMaxDynamic.isEnabled()) {
            this.percentMaxDynamic.setSelected(true);
        } else {
            this.percentMaxSeries.setSelected(true);
        }
    }

    private void updateRangeOptions() {
        boolean isRange = this.range.isSelected();
        this.maxText.setEnabled(isRange);
        this.maxLabel.setEnabled(isRange);
    }

    private void updateSeriesVolumeRange() {
        final Volume vol = this.viewer.getCurrentVolume();
        SeriesRangeOp op = new SeriesRangeOp(this.viewer, vol);
        OperationBuilder<Range> builder = new OperationBuilder<Range>(this.viewer, op);
        builder.runAsynchronously(new OperationListener(){

            @Override
            public void operationFinished(Object result, ImageVolume volume) {
                vol.updateMaxMin((Range)result);
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ThresholdToROIDialog.this.doPercentMax();
                    }
                });
            }
        });
    }

    private void updateCurrentVolumeRange() {
        final Volume vol = this.viewer.getCurrentVolume();
        VolumeRangeOp op = new VolumeRangeOp(this.viewer, vol);
        OperationBuilder<Range> builder = new OperationBuilder<Range>(this.viewer, op);
        builder.runAsynchronously(new OperationListener(){

            @Override
            public void operationFinished(Object result, ImageVolume volume) {
                vol.updateMaxMin((Range)result);
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ThresholdToROIDialog.this.doPercentMax();
                    }
                });
            }
        });
    }

    private void updateShrinkWrapOptions() {
        boolean isVOIMode = this.viewer.isMultiSliceMode();
        this.wrapAxial.setEnabled(this.shrinkWrap.isSelected() && isVOIMode);
        this.wrapCoronal.setEnabled(this.shrinkWrap.isSelected() && isVOIMode);
        this.wrapSagittal.setEnabled(this.shrinkWrap.isSelected() && isVOIMode);
        this.wrap3D.setEnabled(this.shrinkWrap.isSelected() && isVOIMode);
    }
}

