/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ROISliceRangeDialog
extends JPanel
implements ActionListener {
    private final JCheckBox all = new JCheckBox("All Slices");
    private final JLabel aboveLabel;
    private final JLabel belowLabel;
    private final JTextField aboveNum;
    private final JTextField belowNum;
    private static final String[][] DIRECTION_NAMES = new String[][]{{"Above", "Below"}, {"Front", "Back"}, {"Left", "Right"}};
    private static final long serialVersionUID = 1L;

    public ROISliceRangeDialog(int below, int above, int sliceDirection) {
        this.all.setFocusable(false);
        this.all.setActionCommand("All");
        this.all.addActionListener(this);
        this.aboveLabel = new JLabel(DIRECTION_NAMES[sliceDirection][0]);
        this.aboveNum = new MangoTextField(String.valueOf(above), 4);
        JPanel abovePanel = new JPanel();
        abovePanel.add(this.aboveLabel);
        abovePanel.add(this.aboveNum);
        this.belowLabel = new JLabel(DIRECTION_NAMES[sliceDirection][1]);
        this.belowNum = new MangoTextField(String.valueOf(below), 4);
        JPanel belowPanel = new JPanel();
        belowPanel.add(this.belowLabel);
        belowPanel.add(this.belowNum);
        if (below == -1 && above == -1) {
            this.all.setSelected(true);
            this.aboveLabel.setEnabled(!this.all.isSelected());
            this.belowLabel.setEnabled(!this.all.isSelected());
            this.aboveNum.setEnabled(!this.all.isSelected());
            this.belowNum.setEnabled(!this.all.isSelected());
            this.aboveNum.setText("0");
            this.belowNum.setText("0");
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(abovePanel);
        this.add(belowPanel);
        this.add(this.all);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("All")) {
            this.aboveLabel.setEnabled(!this.all.isSelected());
            this.belowLabel.setEnabled(!this.all.isSelected());
            this.aboveNum.setEnabled(!this.all.isSelected());
            this.belowNum.setEnabled(!this.all.isSelected());
        }
    }

    public int getAbove() {
        if (this.all.isSelected()) {
            return -1;
        }
        int aboveVal = 0;
        try {
            aboveVal = Math.abs(Integer.parseInt(this.aboveNum.getText()));
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return aboveVal;
    }

    public int getBelow() {
        if (this.all.isSelected()) {
            return -1;
        }
        int belowVal = 0;
        try {
            belowVal = Math.abs(Integer.parseInt(this.belowNum.getText()));
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return belowVal;
    }
}

