/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPicker;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class ROICalculatorDialog
extends JPanel
implements ActionListener,
KeyListener,
MangoColorSelectedListener {
    public static final String ACTION_UNION = "union";
    private JButton andButton;
    private JButton clearButton;
    private JButton closeButton;
    private JButton intersectButton;
    private JButton notButton;
    private JButton openButton;
    private JButton orButton;
    private JButton unionButton;
    private JButton xorButton;
    private JButton[] colorButtons;
    private JTextArea textArea;
    private MangoColorButton roiButton;
    private Popup popupROI;
    private final SliceViewer viewer;
    private static AtomicReference<String> lastOperation = new AtomicReference();
    private static final long serialVersionUID = 1L;
    public static final int PADDING = 6;

    public ROICalculatorDialog(SliceViewer viewer) {
        this.viewer = viewer;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int selectionEnd;
        String string = ae.getActionCommand();
        if (string.equals("roiButtonToggle")) {
            if (this.popupROI != null) {
                this.popupROI.hide();
                this.popupROI = null;
            } else {
                this.showROIColorPicker();
            }
            return;
        }
        if (string.equals("clear")) {
            this.textArea.setText("");
            return;
        }
        if (string.equals(ACTION_UNION)) {
            StringBuffer union = new StringBuffer("(");
            for (JButton colorButton : this.colorButtons) {
                if (!colorButton.isEnabled()) continue;
                if (union.length() > 1) {
                    union.append(" or ");
                    union.append(colorButton.getActionCommand());
                    continue;
                }
                union.append(colorButton.getActionCommand());
            }
            union.append(')');
            this.textArea.setText(union.toString());
            return;
        }
        if (string.equals("intersection")) {
            StringBuffer union = new StringBuffer("(");
            for (JButton colorButton : this.colorButtons) {
                if (!colorButton.isEnabled()) continue;
                if (union.length() > 1) {
                    union.append(" and ");
                    union.append(colorButton.getActionCommand());
                    continue;
                }
                union.append(colorButton.getActionCommand());
            }
            union.append(')');
            this.textArea.setText(union.toString());
            return;
        }
        if (string.equals(ACTION_UNION)) {
            StringBuffer union = new StringBuffer("(");
            for (JButton colorButton : this.colorButtons) {
                if (!colorButton.isEnabled()) continue;
                if (union.length() > 1) {
                    union.append(" or ");
                    union.append(colorButton.getActionCommand());
                    continue;
                }
                union.append(colorButton.getActionCommand());
            }
            union.append(')');
            this.textArea.setText(union.toString());
            return;
        }
        int position = this.textArea.getCaretPosition();
        String oldText = this.textArea.getText();
        if (!(oldText.length() == 0 || string.equals(")") || position != 0 && oldText.charAt(position - 1) == '(' || position != oldText.length())) {
            string = " " + string;
        }
        StringBuffer newText = new StringBuffer(oldText);
        int selectionStart = this.textArea.getSelectionStart();
        if (selectionStart != (selectionEnd = this.textArea.getSelectionEnd())) {
            newText.replace(selectionStart, selectionEnd, string);
            this.textArea.setText(newText.toString());
            this.textArea.setCaretPosition(selectionStart + string.length());
        } else {
            newText.insert(position, string);
            this.textArea.setText(newText.toString());
            this.textArea.setCaretPosition(position + string.length());
        }
    }

    public void colorSelected(int colorNum) {
        this.closePopups();
        this.roiButton.setColor(colorNum);
    }

    public synchronized String getResults() {
        lastOperation.set(this.textArea.getText().trim());
        return lastOperation.get();
    }

    public int getROIColor() {
        return this.roiButton.getColor();
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 10) {
            this.getRootPane().getDefaultButton().doClick();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    private void closePopups() {
        if (this.popupROI != null) {
            this.popupROI.hide();
            this.popupROI = null;
        }
    }

    private final void createUI() {
        ROIManager roi = this.viewer.getROIManager();
        int maxColors = roi.getBuffer().getMaximumColors();
        Vector<ROIColor> colorSet = ROIColor.getColorsDisplayOrder(maxColors / 8);
        Iterator<ROIColor> it = colorSet.iterator();
        this.colorButtons = new JButton[maxColors];
        int index = 0;
        while (it.hasNext()) {
            ROIColor roiColor = it.next();
            this.colorButtons[index] = new MangoColorButton(roiColor.getIndex(), (ColorManager)this.viewer.getROIManager(), this.viewer);
            this.colorButtons[index].setEnabled(roi.hasROI(roiColor.getIndex()));
            this.colorButtons[index].addActionListener(this);
            this.colorButtons[index].setActionCommand("[" + this.viewer.getROIManager().getLabel(roiColor.getIndex(), ROIDefaultLabels.getDefaultLabelBitPlaneOrder(roiColor.getIndex(), this.viewer.getROIManager().getBuffer().getMaximumColors())) + "]");
            ++index;
        }
        JButton[] allOperatorButtons = new JButton[4];
        allOperatorButtons[0] = this.notButton = new JButton("not");
        this.notButton.setActionCommand("not");
        this.notButton.setMargin(new Insets(0, 0, 0, 0));
        allOperatorButtons[1] = this.andButton = new JButton("and");
        this.andButton.setActionCommand("and");
        this.andButton.setMargin(new Insets(0, 0, 0, 0));
        allOperatorButtons[2] = this.xorButton = new JButton("xor");
        this.xorButton.setActionCommand("xor");
        this.xorButton.setMargin(new Insets(0, 0, 0, 0));
        allOperatorButtons[3] = this.orButton = new JButton("or");
        this.orButton.setActionCommand("or");
        this.orButton.setMargin(new Insets(0, 0, 0, 0));
        JButton[] allOtherButtons = new JButton[3];
        allOtherButtons[0] = this.openButton = new JButton("(");
        this.openButton.setActionCommand("(");
        allOtherButtons[1] = this.closeButton = new JButton(")");
        this.closeButton.setActionCommand(")");
        allOtherButtons[2] = this.clearButton = new JButton("clear");
        this.clearButton.setActionCommand("clear");
        JButton[] allShortcutButtons = new JButton[2];
        allShortcutButtons[0] = this.intersectButton = new JButton("intersection");
        this.intersectButton.setActionCommand("intersection");
        allShortcutButtons[1] = this.unionButton = new JButton(ACTION_UNION);
        this.unionButton.setActionCommand(ACTION_UNION);
        for (JButton allOperatorButton : allOperatorButtons) {
            allOperatorButton.addActionListener(this);
        }
        for (JButton allOtherButton : allOtherButtons) {
            allOtherButton.addActionListener(this);
        }
        for (JButton allShortcutButton : allShortcutButtons) {
            allShortcutButton.addActionListener(this);
        }
        JPanel colorButtonPanel = new JPanel(new GridLayout(maxColors / 8, 8));
        for (int ctr = 0; ctr < maxColors; ++ctr) {
            colorButtonPanel.add(this.colorButtons[ctr]);
        }
        JPanel operatorButtonPanel = new JPanel(new GridLayout(1, 4));
        operatorButtonPanel.add(this.notButton, 0, 0);
        operatorButtonPanel.add(this.andButton, 0, 1);
        operatorButtonPanel.add(this.xorButton, 0, 2);
        operatorButtonPanel.add(this.orButton, 0, 3);
        JPanel otherButtonPanel = new JPanel(new GridLayout(1, 3));
        otherButtonPanel.add(this.openButton, 1, 0);
        otherButtonPanel.add(this.closeButton, 1, 1);
        otherButtonPanel.add(this.clearButton, 1, 2);
        JPanel shortcutButtonPanel = new JPanel(new GridLayout(1, 2));
        shortcutButtonPanel.add(this.unionButton, 0, 0);
        shortcutButtonPanel.add(this.intersectButton, 0, 1);
        this.textArea = new JTextArea(4, 20);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setText(lastOperation.get().trim());
        this.textArea.addKeyListener(this);
        JScrollPane textAreaScroller = new JScrollPane(this.textArea, 20, 31);
        this.roiButton = new MangoColorButton(this.viewer.getROIManager().getCurrentROI(), (ColorManager)this.viewer.getROIManager(), this.viewer);
        this.roiButton.setActionCommand("roiButtonToggle");
        this.roiButton.addActionListener(this);
        JPanel roiButtonPanel = new JPanel();
        roiButtonPanel.setLayout(new BoxLayout(roiButtonPanel, 0));
        roiButtonPanel.add(this.roiButton);
        JPanel textPanel = new JPanel();
        textPanel.add(roiButtonPanel);
        textPanel.add(new JLabel("="));
        textPanel.add(textAreaScroller);
        this.setLayout(new BoxLayout(this, 1));
        this.add(colorButtonPanel);
        this.add(Box.createVerticalStrut(6));
        this.add(otherButtonPanel);
        this.add(operatorButtonPanel);
        this.add(shortcutButtonPanel);
        this.add(Box.createVerticalStrut(6));
        this.add(textPanel);
    }

    private void showROIColorPicker() {
        this.popupROI = PopupFactory.getSharedInstance().getPopup(this.roiButton, new MangoColorPicker((ColorManager)this.viewer.getROIManager(), this, this.viewer.getROIManager(), this.viewer.getROIManager().getBuffer().getMaximumColors(), true), this.roiButton.getLocationOnScreen().x, this.roiButton.getLocationOnScreen().y + 35);
        this.popupROI.show();
    }

    static {
        lastOperation.set("");
    }
}

