/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.ScreenImage;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPicker;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPickerPopupManager;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.WritableHeader;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class FileSaveAsChooser
extends JFileChooser
implements ActionListener,
KeyListener,
MangoColorPickerPopupManager,
MangoColorSelectedListener {
    private JButton roiButton;
    private JCheckBox applyDataScales;
    private JCheckBox compression;
    private JCheckBox fitPrecision;
    private JCheckBox maintainZero;
    private JCheckBox mix;
    private JCheckBox threshold;
    private JPanel orientation1Panel;
    private JPanel orientation2Panel;
    private JPanel orientationCustomPanel;
    private JPanel orientationPanel;
    private JRadioButton big;
    private JRadioButton little;
    private JRadioButton nearest;
    private JRadioButton sinc;
    private JRadioButton trilinear;
    private JRadioButton type16;
    private JRadioButton type32;
    private JRadioButton type8;
    private JRadioButton typeFloat;
    private JRadioButton typeSigned;
    private JRadioButton typeUnsigned;
    private JTextField dimX;
    private JTextField dimY;
    private JTextField dimZ;
    private JTextField startX;
    private JTextField startY;
    private JTextField startZ;
    private JTextField textField;
    private JTextField timeSize;
    private JTextField timeStart;
    private JTextField timeTR;
    private JTextField voxSizeX;
    private JTextField voxSizeY;
    private JTextField voxSizeZ;
    private JToggleButton previewButton;
    private MangoComboBox<String> formatBox;
    private MangoComboBox<String> orientation1;
    private MangoComboBox<String> orientation2;
    private MangoComboBox<String> orientationCustom;
    private MangoComboBox<String> overlayBox;
    private MangoComboBox<String> transformBox;
    private String loadedHeaderFormat;
    private boolean freezeActions;
    private boolean freezeDatatypeChanges;
    private static final String[] ORIENTATION = new String[]{"XYZ", "XZY", "YXZ", "YZX", "ZXY", "ZYX"};
    private static final String[] SENSE = new String[]{"+++", "++-", "+-+", "-++", "+--", "-+-", "--+", "---"};
    private static final long serialVersionUID = 1L;
    private final transient Mango mango;
    private transient Popup popupROI;
    private transient WritableHeader currentOutputFormat;
    private final transient SliceViewer viewer;
    public static final Dimension ACCESSORY_SIZE = new Dimension(180, 250);
    public static final Dimension ACCESSORY_SIZE_MAC = new Dimension(245, 280);
    public static final Dimension START_SIZE = new Dimension(600, 450);
    public static final Dimension START_SIZE_MAC = new Dimension(545, 525);
    public static final String ACTION_COMPRESSION = "ACTION_COMPRESSION";
    public static final String ACTION_DIM_X = "ACTION_DIM_X";
    public static final String ACTION_DIM_Y = "ACTION_DIM_Y";
    public static final String ACTION_DIM_Z = "ACTION_DIM_Z";
    public static final String ACTION_FIT_PRECISION = "ACTION_FIT_PRECISION";
    public static final String ACTION_FORMAT_SELECTED = "ACTION_FORMAT_SELECTED";
    public static final String ACTION_MIX = "ACTION_MIX";
    public static final String ACTION_ORIENTATION_CHANGED = "ACTION_ORIENTATION_CHANGED";
    public static final String ACTION_OVERLAY = "ACTION_OVERLAY";
    public static final String ACTION_PREVIEW = "ACTION_PREVIEW";
    public static final String ACTION_RESET_BOUNDS = "ACTION_RESET_BOUNDS";
    public static final String ACTION_ROI_PICKER = "ACTION_ROI_PICKER";
    public static final String ACTION_START = "ACTION_START";
    public static final String ACTION_THRESHOLD = "ACTION_THRESHOLD";
    public static final String ACTION_TRANSFORM = "ACTION_TRANSFORM";
    public static final String ACTION_TYPE16 = "ACTION_TYPE16";
    public static final String ACTION_TYPE32 = "ACTION_TYPE32";
    public static final String ACTION_TYPE8 = "ACTION_TYPE8";
    public static final String ACTION_TYPE_FLOAT = "ACTION_TYPE_FLOAT";
    public static final String ACTION_TYPE_SIGNED = "ACTION_TYPE_SIGNED";
    public static final String ACTION_TYPE_UNSIGNED = "ACTION_TYPE_UNSIGNED";
    public static final String ACTION_VOX_X = "ACTION_VOX_X";
    public static final String ACTION_VOX_Y = "ACTION_VOX_Y";
    public static final String ACTION_VOX_Z = "ACTION_VOX_Z";
    public static final int INTERPOLATION_LINEAR = 1;
    public static final int INTERPOLATION_NN = 0;
    public static final int INTERPOLATION_SINC = 2;

    public static int getInterpolationCode(boolean nn, boolean linear, boolean sinc) {
        if (nn) {
            return 0;
        }
        if (sinc) {
            return 2;
        }
        return 1;
    }

    public FileSaveAsChooser(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
        this.buildUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.freezeActions) {
            return;
        }
        String command = ae.getActionCommand();
        if (command.equals(ACTION_DIM_X)) {
            JTextField field = (JTextField)ae.getSource();
            field.setText(String.valueOf(Math.abs(NumberUtils.toInt((String)field.getText(), (int)this.viewer.getVolume().getXDim()))));
        } else if (command.equals(ACTION_DIM_Y)) {
            JTextField field = (JTextField)ae.getSource();
            field.setText(String.valueOf(Math.abs(NumberUtils.toInt((String)field.getText(), (int)this.viewer.getVolume().getYDim()))));
        } else if (command.equals(ACTION_DIM_Z)) {
            JTextField field = (JTextField)ae.getSource();
            field.setText(String.valueOf(Math.abs(NumberUtils.toInt((String)field.getText(), (int)this.viewer.getVolume().getZDim()))));
        } else if (command.equals(ACTION_START)) {
            JTextField field = (JTextField)ae.getSource();
            field.setText(String.valueOf(NumberUtils.toInt((String)field.getText(), (int)0)));
        } else if (command.equals(ACTION_VOX_X)) {
            JTextField field = (JTextField)ae.getSource();
            field.setText(String.valueOf(Math.abs(NumberUtils.toDouble((String)field.getText(), (double)this.viewer.getVolume().getXSize()))));
        } else if (command.equals(ACTION_VOX_Y)) {
            JTextField field = (JTextField)ae.getSource();
            field.setText(String.valueOf(Math.abs(NumberUtils.toDouble((String)field.getText(), (double)this.viewer.getVolume().getYSize()))));
        } else if (command.equals(ACTION_VOX_Z)) {
            JTextField field = (JTextField)ae.getSource();
            field.setText(String.valueOf(Math.abs(NumberUtils.toDouble((String)field.getText(), (double)this.viewer.getVolume().getZSize()))));
        } else if (command.equals(ACTION_FIT_PRECISION)) {
            this.updateApplyDataScaleButton();
            this.updateMaintainZero();
        } else if (command.equals(ACTION_TRANSFORM)) {
            this.updateThreshold();
            this.updateMixed();
        } else if (command.equals(ACTION_OVERLAY)) {
            this.updateThreshold();
            this.updateMixed();
        } else if (command.equals(ACTION_FORMAT_SELECTED)) {
            this.doFormatSelected();
        } else if (command.equals(ACTION_TYPE_FLOAT)) {
            this.updateDatatype(this.currentOutputFormat, ACTION_TYPE_FLOAT);
            this.updateFitPrecision();
            this.updateApplyDataScaleButton();
        } else if (command.equals(ACTION_TYPE_SIGNED)) {
            this.updateDatatype(this.currentOutputFormat, ACTION_TYPE_SIGNED);
            this.updateFitPrecision();
            this.updateApplyDataScaleButton();
        } else if (command.equals(ACTION_TYPE_UNSIGNED)) {
            this.updateDatatype(this.currentOutputFormat, ACTION_TYPE_UNSIGNED);
            this.updateFitPrecision();
            this.updateApplyDataScaleButton();
        } else if (command.equals(ACTION_TYPE8)) {
            this.updateDatatype(this.currentOutputFormat, ACTION_TYPE8);
            this.updateFitPrecision();
            this.updateApplyDataScaleButton();
        } else if (command.equals(ACTION_TYPE16)) {
            this.updateDatatype(this.currentOutputFormat, ACTION_TYPE16);
            this.updateFitPrecision();
            this.updateApplyDataScaleButton();
        } else if (command.equals(ACTION_TYPE32)) {
            this.updateDatatype(this.currentOutputFormat, ACTION_TYPE32);
            this.updateFitPrecision();
            this.updateApplyDataScaleButton();
        } else if (command.equals(ACTION_THRESHOLD)) {
            this.updateMixed();
        } else if (command.equals(ACTION_COMPRESSION)) {
            this.updateSelectedFilename();
        } else if (command.equals(ACTION_MIX)) {
            this.updateApplyDataScaleButton();
        } else if (command.equals(ACTION_ROI_PICKER)) {
            this.toggleROIColorChooser();
        } else if (command.equals(ACTION_PREVIEW)) {
            boolean show = this.previewButton.isSelected();
            this.viewer.setShowPreview(show);
            this.viewer.forceImageUpdate();
            if (show) {
                this.updatePreview();
            } else {
                this.viewer.updateViewer();
            }
        } else if (command.equals(ACTION_RESET_BOUNDS)) {
            this.resetResliceBounds();
            if (this.previewButton.isSelected()) {
                this.updatePreview();
            }
        } else if (command.equals(ACTION_ORIENTATION_CHANGED)) {
            this.updateFitPrecision();
            this.updateApplyDataScaleButton();
        }
    }

    private void doFormatSelected() {
        this.loadedHeaderFormat = this.formatBox.getSelectedItem().toString();
        this.currentOutputFormat = Header.makeWritableHeader(this.loadedHeaderFormat);
        this.updateCompression();
        this.updateSelectedFilename();
        this.verifyDatatype(this.currentOutputFormat);
        this.updateOrientation();
        this.updateApplyDataScaleButton();
    }

    @Override
    public void approveSelection() {
        int response;
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null && selectedFile.exists() && (response = JOptionPane.showConfirmDialog(this, "The file \"" + selectedFile.getName() + "\" already exists. \nDo you want to replace it?", "", 2)) != 0) {
            return;
        }
        super.approveSelection();
    }

    @Override
    public void closeColorPickerPopup() {
        this.closePopups();
    }

    public void colorSelected(int colorNum) {
        this.closePopups();
        this.doROIButtonChosen(colorNum);
    }

    private boolean usesCustomOrientation() {
        boolean usesCustomOrientation = false;
        try {
            usesCustomOrientation = ArrayUtils.isNotEmpty((Object[])this.currentOutputFormat.getSupportedOrientations());
        }
        catch (AbstractMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        catch (NoSuchMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        return usesCustomOrientation;
    }

    public String getOrientation() {
        if (this.usesCustomOrientation()) {
            return this.orientationCustom.getSelectedItem().toString();
        }
        return this.orientation1.getSelectedItem().toString() + this.orientation2.getSelectedItem().toString();
    }

    public File getSaveAsFile() {
        return new File(this.getCurrentDirectory(), this.getSelectedFilename());
    }

    public String getSelectedFileHeaderType() {
        return (String)this.formatBox.getSelectedItem();
    }

    public ImageType getSelectedFileImageType() {
        int byteType = 0;
        int numBytes = 0;
        boolean isLittleEndian = false;
        if (this.type8.isSelected()) {
            numBytes = 1;
        } else if (this.type16.isSelected()) {
            numBytes = 2;
        } else if (this.type32.isSelected()) {
            numBytes = 4;
        }
        if (this.typeSigned.isSelected()) {
            byteType = 2;
        } else if (this.typeUnsigned.isSelected()) {
            byteType = 3;
        } else if (this.typeFloat.isSelected()) {
            byteType = 4;
        }
        isLittleEndian = this.little.isSelected();
        ImageType it = new ImageType(numBytes, byteType, numBytes * 8, isLittleEndian);
        it.setCompressionType(this.isCompress() ? 1 : 0);
        return it;
    }

    public String getSelectedFilename() {
        String filename = null;
        if (this.textField != null) {
            filename = this.textField.getText();
        }
        return filename;
    }

    public ImageBounds getSelectedImageBounds() {
        int tMax = 0;
        int tMin = 0;
        int sZ = 0;
        int sY = 0;
        int sX = 0;
        int dZ = 0;
        int dY = 0;
        int dX = 0;
        try {
            dX = Integer.parseInt(this.dimX.getText());
            dY = Integer.parseInt(this.dimY.getText());
            dZ = Integer.parseInt(this.dimZ.getText());
            sX = Integer.parseInt(this.startX.getText());
            sY = Integer.parseInt(this.startY.getText());
            sZ = Integer.parseInt(this.startZ.getText());
            tMin = Integer.parseInt(this.timeStart.getText()) - 1;
            int tSize = Integer.parseInt(this.timeSize.getText());
            tMax = tMin + tSize - 1;
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        ImageBounds ib = new ImageBounds(sX, sX + dX - 1, sY, sY + dY - 1, sZ, sZ + dZ - 1);
        ib.setRangeT(tMin, tMax);
        return ib;
    }

    public int getSelectedOverlay() {
        return this.overlayBox.getSelectedIndex();
    }

    public double getSelectedSizeT() {
        double tSize = 0.0;
        try {
            double oldTR = this.viewer.getVolume().getTR();
            if (oldTR == 0.0) {
                oldTR = 1.0;
            }
            tSize = Double.parseDouble(this.timeTR.getText()) / oldTR;
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return tSize;
    }

    public double getSelectedSizeX() {
        double xSize = 0.0;
        try {
            xSize = Double.parseDouble(this.voxSizeX.getText());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return xSize;
    }

    public double getSelectedSizeY() {
        double ySize = 0.0;
        try {
            ySize = Double.parseDouble(this.voxSizeY.getText());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return ySize;
    }

    public double getSelectedSizeZ() {
        double zSize = 0.0;
        try {
            zSize = Double.parseDouble(this.voxSizeZ.getText());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return zSize;
    }

    public int getSelectedTransform() {
        return this.transformBox.getSelectedIndex();
    }

    public boolean isApplyDataScales() {
        return this.applyDataScales.isSelected();
    }

    public boolean isCompress() {
        return this.compression.isSelected();
    }

    public boolean isMaintainZero() {
        return this.maintainZero.isSelected();
    }

    public boolean isMix() {
        return this.mix.isSelected();
    }

    public boolean isNearestNeighbor() {
        return this.nearest.isSelected();
    }

    public boolean isSinc() {
        return this.sinc.isSelected();
    }

    public boolean isThreshold() {
        return this.threshold.isSelected();
    }

    public boolean isTrilinear() {
        return this.trilinear.isSelected();
    }

    public boolean isUsingFitPrecision() {
        return this.fitPrecision.isSelected();
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (this.previewButton.isSelected()) {
            this.updatePreview();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void setSelectedFile(File aFile) {
        if (aFile != null && !aFile.isDirectory()) {
            super.setSelectedFile(aFile);
        }
    }

    @Override
    protected JDialog createDialog(Component com) {
        JDialog aDialog = super.createDialog(com);
        aDialog.setResizable(true);
        return aDialog;
    }

    private JPanel buildMiscTabUI() {
        JLabel rescaleLabel = new JLabel("Rescale Options", 0);
        rescaleLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel rescaleLabelPanel = new JPanel();
        rescaleLabelPanel.setLayout(new BoxLayout(rescaleLabelPanel, 0));
        rescaleLabelPanel.add(Box.createHorizontalGlue());
        rescaleLabelPanel.add(rescaleLabel);
        rescaleLabelPanel.add(Box.createHorizontalGlue());
        rescaleLabelPanel.setBackground(Color.LIGHT_GRAY);
        this.applyDataScales = new JCheckBox("Apply Data Scales");
        this.applyDataScales.setBackground(Color.LIGHT_GRAY);
        JPanel dataScalePanel = new JPanel();
        dataScalePanel.setLayout(new BoxLayout(dataScalePanel, 0));
        dataScalePanel.add(Box.createHorizontalGlue());
        dataScalePanel.add(this.applyDataScales);
        dataScalePanel.add(Box.createHorizontalGlue());
        dataScalePanel.setBackground(Color.LIGHT_GRAY);
        this.fitPrecision = new JCheckBox("Fit Precision");
        this.fitPrecision.setBackground(Color.LIGHT_GRAY);
        this.fitPrecision.addActionListener(this);
        this.fitPrecision.setActionCommand(ACTION_FIT_PRECISION);
        JPanel fitPrecisionPanel = new JPanel();
        fitPrecisionPanel.setLayout(new BoxLayout(fitPrecisionPanel, 0));
        fitPrecisionPanel.add(Box.createHorizontalGlue());
        fitPrecisionPanel.add(this.fitPrecision);
        fitPrecisionPanel.add(Box.createHorizontalGlue());
        fitPrecisionPanel.setBackground(Color.LIGHT_GRAY);
        this.maintainZero = new JCheckBox("Maintain Zero");
        this.maintainZero.setBackground(Color.LIGHT_GRAY);
        JPanel maintainZeroPanel = new JPanel();
        maintainZeroPanel.setLayout(new BoxLayout(maintainZeroPanel, 0));
        maintainZeroPanel.add(Box.createHorizontalGlue());
        maintainZeroPanel.add(this.maintainZero);
        maintainZeroPanel.add(Box.createHorizontalGlue());
        maintainZeroPanel.setBackground(Color.LIGHT_GRAY);
        JLabel compressLabel = new JLabel("Compression", 0);
        compressLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel compressLabelPanel = new JPanel();
        compressLabelPanel.setLayout(new BoxLayout(compressLabelPanel, 0));
        compressLabelPanel.add(Box.createHorizontalGlue());
        compressLabelPanel.add(compressLabel);
        compressLabelPanel.add(Box.createHorizontalGlue());
        compressLabelPanel.setBackground(Color.LIGHT_GRAY);
        this.compression = new JCheckBox("GZIP");
        this.compression.setActionCommand(ACTION_COMPRESSION);
        this.compression.addActionListener(this);
        this.compression.setBackground(Color.LIGHT_GRAY);
        this.compression.setSelected(this.currentOutputFormat.canCompress());
        JPanel compressionPanel = new JPanel();
        compressionPanel.setLayout(new BoxLayout(compressionPanel, 0));
        compressionPanel.add(Box.createHorizontalGlue());
        compressionPanel.add(this.compression);
        compressionPanel.add(Box.createHorizontalGlue());
        compressionPanel.setBackground(Color.LIGHT_GRAY);
        JLabel orientationLabel = new JLabel("Data Orientation", 0);
        orientationLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel orientationLabelPanel = new JPanel();
        orientationLabelPanel.setLayout(new BoxLayout(orientationLabelPanel, 0));
        orientationLabelPanel.add(Box.createHorizontalGlue());
        orientationLabelPanel.add(orientationLabel);
        orientationLabelPanel.add(Box.createHorizontalGlue());
        orientationLabelPanel.setBackground(Color.LIGHT_GRAY);
        this.orientation1 = new MangoComboBox<String>((T[])ORIENTATION);
        this.orientation1.setActionCommand(ACTION_ORIENTATION_CHANGED);
        this.orientation1.addActionListener(this);
        this.orientation1.setMaximumSize(this.orientation1.getPreferredSize());
        this.orientation1.setPrototypeDisplayValue("      ");
        this.orientation1Panel = new JPanel();
        this.orientation1Panel.setLayout(new BoxLayout(this.orientation1Panel, 0));
        this.orientation1Panel.add(Box.createHorizontalGlue());
        this.orientation1Panel.add(this.orientation1);
        this.orientation1Panel.add(Box.createHorizontalGlue());
        this.orientation1Panel.setBackground(Color.LIGHT_GRAY);
        this.orientation2 = new MangoComboBox<String>((T[])SENSE);
        this.orientation2.setActionCommand(ACTION_ORIENTATION_CHANGED);
        this.orientation2.addActionListener(this);
        this.orientation2.setMaximumSize(this.orientation2.getPreferredSize());
        this.orientation2.setPrototypeDisplayValue("      ");
        this.orientation2Panel = new JPanel();
        this.orientation2Panel.setLayout(new BoxLayout(this.orientation2Panel, 0));
        this.orientation2Panel.add(Box.createHorizontalGlue());
        this.orientation2Panel.add(this.orientation2);
        this.orientation2Panel.add(Box.createHorizontalGlue());
        this.orientation2Panel.setBackground(Color.LIGHT_GRAY);
        this.orientationCustom = new MangoComboBox();
        this.orientationCustom.setActionCommand(ACTION_ORIENTATION_CHANGED);
        this.orientationCustom.addActionListener(this);
        this.orientationCustom.setMaximumSize(this.orientationCustom.getPreferredSize());
        this.orientationCustom.setPrototypeDisplayValue("XYZ+++");
        this.orientationCustomPanel = new JPanel();
        this.orientationCustomPanel.setLayout(new BoxLayout(this.orientationCustomPanel, 0));
        this.orientationCustomPanel.add(Box.createHorizontalGlue());
        this.orientationCustomPanel.add(this.orientationCustom);
        this.orientationCustomPanel.add(Box.createHorizontalGlue());
        this.orientationCustomPanel.setBackground(Color.LIGHT_GRAY);
        this.orientationPanel = new JPanel();
        this.orientationPanel.setLayout(new BoxLayout(this.orientationPanel, 1));
        this.orientationPanel.setBackground(Color.LIGHT_GRAY);
        JPanel miscPanel = new JPanel();
        miscPanel.setLayout(new BoxLayout(miscPanel, 1));
        miscPanel.add(Box.createVerticalGlue());
        miscPanel.add(rescaleLabelPanel);
        miscPanel.add(Box.createVerticalStrut(4));
        miscPanel.add(dataScalePanel);
        miscPanel.add(Box.createVerticalStrut(4));
        miscPanel.add(fitPrecisionPanel);
        miscPanel.add(Box.createVerticalStrut(4));
        miscPanel.add(maintainZeroPanel);
        miscPanel.add(Box.createVerticalGlue());
        miscPanel.add(compressLabelPanel);
        miscPanel.add(Box.createVerticalStrut(4));
        miscPanel.add(compressionPanel);
        miscPanel.add(Box.createVerticalGlue());
        miscPanel.add(orientationLabelPanel);
        miscPanel.add(Box.createVerticalStrut(4));
        miscPanel.add(this.orientationPanel);
        miscPanel.add(Box.createVerticalGlue());
        miscPanel.setBackground(Color.LIGHT_GRAY);
        return miscPanel;
    }

    private JPanel buildResliceTabUI() {
        ImageDimensions id = this.viewer.getVolume().getImageDimensions();
        VoxelDimensions vd = this.viewer.getVolume().getVoxelDimensions();
        JLabel voxSizeLabel = new JLabel("Voxel Size (mm)", 0);
        voxSizeLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel voxSizeLabelPanel = new JPanel();
        voxSizeLabelPanel.setLayout(new BoxLayout(voxSizeLabelPanel, 0));
        voxSizeLabelPanel.add(Box.createHorizontalGlue());
        voxSizeLabelPanel.add(voxSizeLabel);
        voxSizeLabelPanel.add(Box.createHorizontalGlue());
        voxSizeLabelPanel.setBackground(Color.LIGHT_GRAY);
        JLabel voxSizeLabelX = new JLabel("X");
        voxSizeLabelX.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        JLabel voxSizeLabelY = new JLabel("Y");
        voxSizeLabelY.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        JLabel voxSizeLabelZ = new JLabel("Z");
        voxSizeLabelZ.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        this.voxSizeX = new MangoTextField(String.valueOf(vd.getXSize()), 3, this, true);
        this.voxSizeX.setActionCommand(ACTION_VOX_X);
        this.voxSizeX.addActionListener(this);
        this.voxSizeX.setCaretPosition(0);
        this.voxSizeX.setMaximumSize(this.voxSizeX.getPreferredSize());
        this.voxSizeY = new MangoTextField(String.valueOf(vd.getYSize()), 3, this, true);
        this.voxSizeY.setActionCommand(ACTION_VOX_Y);
        this.voxSizeY.addActionListener(this);
        this.voxSizeY.setCaretPosition(0);
        this.voxSizeY.setMaximumSize(this.voxSizeY.getPreferredSize());
        this.voxSizeZ = new MangoTextField(String.valueOf(vd.getZSize()), 3, this, true);
        this.voxSizeZ.setActionCommand(ACTION_VOX_Z);
        this.voxSizeZ.addActionListener(this);
        this.voxSizeZ.setCaretPosition(0);
        this.voxSizeZ.setMaximumSize(this.voxSizeZ.getPreferredSize());
        JPanel voxSizePanelX = new JPanel();
        voxSizePanelX.setLayout(new BoxLayout(voxSizePanelX, 0));
        voxSizePanelX.add(Box.createHorizontalGlue());
        voxSizePanelX.add(voxSizeLabelX);
        voxSizePanelX.add(this.voxSizeX);
        voxSizePanelX.add(Box.createHorizontalGlue());
        voxSizePanelX.setBackground(Color.LIGHT_GRAY);
        JPanel voxSizePanelY = new JPanel();
        voxSizePanelY.setLayout(new BoxLayout(voxSizePanelY, 0));
        voxSizePanelY.add(Box.createHorizontalGlue());
        voxSizePanelY.add(voxSizeLabelY);
        voxSizePanelY.add(this.voxSizeY);
        voxSizePanelY.add(Box.createHorizontalGlue());
        voxSizePanelY.setBackground(Color.LIGHT_GRAY);
        JPanel voxSizePanelZ = new JPanel();
        voxSizePanelZ.setLayout(new BoxLayout(voxSizePanelZ, 0));
        voxSizePanelZ.add(Box.createHorizontalGlue());
        voxSizePanelZ.add(voxSizeLabelZ);
        voxSizePanelZ.add(this.voxSizeZ);
        voxSizePanelZ.add(Box.createHorizontalGlue());
        voxSizePanelZ.setBackground(Color.LIGHT_GRAY);
        JPanel voxSizesPanel = new JPanel();
        voxSizesPanel.setLayout(new BoxLayout(voxSizesPanel, 0));
        voxSizesPanel.add(Box.createHorizontalGlue());
        voxSizesPanel.add(voxSizePanelX);
        voxSizesPanel.add(voxSizePanelY);
        voxSizesPanel.add(voxSizePanelZ);
        voxSizesPanel.add(Box.createHorizontalGlue());
        voxSizesPanel.setBackground(Color.LIGHT_GRAY);
        JPanel voxSizePanel = new JPanel();
        voxSizePanel.setLayout(new BoxLayout(voxSizePanel, 1));
        voxSizePanel.add(voxSizeLabelPanel);
        voxSizePanel.add(voxSizesPanel);
        voxSizePanel.setBackground(Color.LIGHT_GRAY);
        JLabel startLabel = new JLabel("Start Voxel", 0);
        startLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel startLabelPanel = new JPanel();
        startLabelPanel.setLayout(new BoxLayout(startLabelPanel, 0));
        startLabelPanel.add(Box.createHorizontalGlue());
        startLabelPanel.add(startLabel);
        startLabelPanel.add(Box.createHorizontalGlue());
        startLabelPanel.setBackground(Color.LIGHT_GRAY);
        JLabel startLabelX = new JLabel("X");
        startLabelX.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        JLabel startLabelY = new JLabel("Y");
        startLabelY.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        JLabel startLabelZ = new JLabel("Z");
        startLabelZ.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        this.startX = new MangoTextField("0", 3, this, true);
        this.startX.setActionCommand(ACTION_START);
        this.startX.addActionListener(this);
        this.startX.setCaretPosition(0);
        this.startX.setMaximumSize(this.startX.getPreferredSize());
        this.startY = new MangoTextField("0", 3, this, true);
        this.startY.setActionCommand(ACTION_START);
        this.startY.addActionListener(this);
        this.startY.setCaretPosition(0);
        this.startY.setMaximumSize(this.startY.getPreferredSize());
        this.startZ = new MangoTextField("0", 3, this, true);
        this.startZ.setActionCommand(ACTION_START);
        this.startZ.addActionListener(this);
        this.startZ.setCaretPosition(0);
        this.startZ.setMaximumSize(this.startZ.getPreferredSize());
        JPanel startPanelX = new JPanel();
        startPanelX.setLayout(new BoxLayout(startPanelX, 0));
        startPanelX.add(Box.createHorizontalGlue());
        startPanelX.add(startLabelX);
        startPanelX.add(this.startX);
        startPanelX.add(Box.createHorizontalGlue());
        startPanelX.setBackground(Color.LIGHT_GRAY);
        JPanel startPanelY = new JPanel();
        startPanelY.setLayout(new BoxLayout(startPanelY, 0));
        startPanelY.add(Box.createHorizontalGlue());
        startPanelY.add(startLabelY);
        startPanelY.add(this.startY);
        startPanelY.add(Box.createHorizontalGlue());
        startPanelY.setBackground(Color.LIGHT_GRAY);
        JPanel startPanelZ = new JPanel();
        startPanelZ.setLayout(new BoxLayout(startPanelZ, 0));
        startPanelZ.add(Box.createHorizontalGlue());
        startPanelZ.add(startLabelZ);
        startPanelZ.add(this.startZ);
        startPanelZ.add(Box.createHorizontalGlue());
        startPanelZ.setBackground(Color.LIGHT_GRAY);
        JPanel startsPanel = new JPanel();
        startsPanel.setLayout(new BoxLayout(startsPanel, 0));
        startsPanel.add(Box.createHorizontalGlue());
        startsPanel.add(startPanelX);
        startsPanel.add(startPanelY);
        startsPanel.add(startPanelZ);
        startsPanel.add(Box.createHorizontalGlue());
        startsPanel.setBackground(Color.LIGHT_GRAY);
        JPanel startPanel = new JPanel();
        startPanel.setLayout(new BoxLayout(startPanel, 1));
        startPanel.add(startLabelPanel);
        startPanel.add(startsPanel);
        startPanel.setBackground(Color.LIGHT_GRAY);
        JLabel dimLabel = new JLabel("Image Size (voxels)", 0);
        dimLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel dimLabelPanel = new JPanel();
        dimLabelPanel.setLayout(new BoxLayout(dimLabelPanel, 0));
        dimLabelPanel.add(Box.createHorizontalGlue());
        dimLabelPanel.add(dimLabel);
        dimLabelPanel.add(Box.createHorizontalGlue());
        dimLabelPanel.setBackground(Color.LIGHT_GRAY);
        JLabel dimLabelX = new JLabel("X");
        dimLabelX.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        JLabel dimLabelY = new JLabel("Y");
        dimLabelY.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        JLabel dimLabelZ = new JLabel("Z");
        dimLabelZ.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        JLabel dimLabelT = new JLabel("T");
        dimLabelT.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1));
        this.dimX = new MangoTextField(String.valueOf(id.getX()), 3, this, true);
        this.dimX.setActionCommand(ACTION_DIM_X);
        this.dimX.addActionListener(this);
        this.dimX.setCaretPosition(0);
        this.dimX.setMaximumSize(this.dimX.getPreferredSize());
        this.dimY = new MangoTextField(String.valueOf(id.getY()), 3, this, true);
        this.dimY.setActionCommand(ACTION_DIM_X);
        this.dimY.addActionListener(this);
        this.dimY.setCaretPosition(0);
        this.dimY.setMaximumSize(this.dimY.getPreferredSize());
        this.dimZ = new MangoTextField(String.valueOf(id.getZ()), 3, this, true);
        this.dimZ.setActionCommand(ACTION_DIM_X);
        this.dimZ.addActionListener(this);
        this.dimZ.setCaretPosition(0);
        this.dimZ.setMaximumSize(this.dimZ.getPreferredSize());
        JPanel dimPanelX = new JPanel();
        dimPanelX.setLayout(new BoxLayout(dimPanelX, 0));
        dimPanelX.add(Box.createHorizontalGlue());
        dimPanelX.add(dimLabelX);
        dimPanelX.add(this.dimX);
        dimPanelX.add(Box.createHorizontalGlue());
        dimPanelX.setBackground(Color.LIGHT_GRAY);
        JPanel dimPanelY = new JPanel();
        dimPanelY.setLayout(new BoxLayout(dimPanelY, 0));
        dimPanelY.add(Box.createHorizontalGlue());
        dimPanelY.add(dimLabelY);
        dimPanelY.add(this.dimY);
        dimPanelY.add(Box.createHorizontalGlue());
        dimPanelY.setBackground(Color.LIGHT_GRAY);
        JPanel dimPanelZ = new JPanel();
        dimPanelZ.setLayout(new BoxLayout(dimPanelZ, 0));
        dimPanelZ.add(Box.createHorizontalGlue());
        dimPanelZ.add(dimLabelZ);
        dimPanelZ.add(this.dimZ);
        dimPanelZ.add(Box.createHorizontalGlue());
        dimPanelZ.setBackground(Color.LIGHT_GRAY);
        JPanel dimsPanel = new JPanel();
        dimsPanel.setLayout(new BoxLayout(dimsPanel, 0));
        dimsPanel.add(Box.createHorizontalGlue());
        dimsPanel.add(dimPanelX);
        dimsPanel.add(dimPanelY);
        dimsPanel.add(dimPanelZ);
        dimsPanel.add(Box.createHorizontalGlue());
        dimsPanel.setBackground(Color.LIGHT_GRAY);
        JPanel dimPanel = new JPanel();
        dimPanel.setLayout(new BoxLayout(dimPanel, 1));
        dimPanel.add(dimLabelPanel);
        dimPanel.add(dimsPanel);
        dimPanel.setBackground(Color.LIGHT_GRAY);
        this.roiButton = new JButton("");
        this.roiButton.addActionListener(this);
        this.roiButton.setFont(MangoStyle.FONT_SMALL);
        this.roiButton.setBackground(Color.LIGHT_GRAY);
        if (this.viewer.getROIManager().hasROI()) {
            this.roiButton.setText("Set Bounds");
            this.roiButton.setActionCommand(ACTION_ROI_PICKER);
        } else {
            this.roiButton.setText("Reset");
            this.roiButton.setActionCommand(ACTION_RESET_BOUNDS);
        }
        this.previewButton = new JToggleButton("Preview");
        this.previewButton.setActionCommand(ACTION_PREVIEW);
        this.previewButton.addActionListener(this);
        this.previewButton.setFont(MangoStyle.FONT_SMALL);
        this.previewButton.setEnabled(true);
        this.previewButton.setBackground(Color.LIGHT_GRAY);
        JPanel roiButtonPanel = new JPanel();
        roiButtonPanel.setLayout(new BoxLayout(roiButtonPanel, 0));
        roiButtonPanel.add(this.roiButton);
        roiButtonPanel.setBackground(Color.WHITE);
        JPanel roiPanel = new JPanel();
        roiPanel.setLayout(new BoxLayout(roiPanel, 0));
        roiPanel.add(Box.createHorizontalGlue());
        roiPanel.add(this.roiButton);
        roiPanel.add(this.previewButton);
        roiPanel.add(Box.createHorizontalGlue());
        roiPanel.setBackground(Color.LIGHT_GRAY);
        JLabel timeLabel = new JLabel("Series", 0);
        timeLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel timeLabelPanel = new JPanel();
        timeLabelPanel.setLayout(new BoxLayout(timeLabelPanel, 0));
        timeLabelPanel.add(Box.createHorizontalGlue());
        timeLabelPanel.add(timeLabel);
        timeLabelPanel.add(Box.createHorizontalGlue());
        timeLabelPanel.setBackground(Color.LIGHT_GRAY);
        JLabel timeSizeLabel = new JLabel("Length ");
        boolean isVariableTiming = this.viewer.getVolume().isVariableVolumeTiming();
        String timeStr = String.valueOf(this.viewer.getVolume().getNumTimepoints());
        if (isVariableTiming) {
            timeStr = String.valueOf(Header.calculateNumVolumesForVariableTiming(this.viewer.getVolume().getVolumeTiming(), this.viewer.getVolume().getNumTimepoints()));
        }
        this.timeSize = new MangoTextField(String.valueOf(timeStr), 3, this, true);
        this.timeSize.setActionCommand("time size");
        this.timeSize.addActionListener(this);
        this.timeSize.setCaretPosition(0);
        this.timeSize.setMaximumSize(this.timeSize.getPreferredSize());
        JPanel timeSizePanel = new JPanel();
        timeSizePanel.setLayout(new BoxLayout(timeSizePanel, 0));
        timeSizePanel.add(Box.createHorizontalGlue());
        timeSizePanel.add(timeSizeLabel);
        timeSizePanel.add(this.timeSize);
        timeSizePanel.add(Box.createHorizontalGlue());
        timeSizePanel.setBackground(Color.LIGHT_GRAY);
        JLabel timeStartLabel = new JLabel("Start ");
        this.timeStart = new MangoTextField("1", 3, this, true);
        this.timeStart.setActionCommand("time start");
        this.timeStart.addActionListener(this);
        this.timeStart.setCaretPosition(0);
        this.timeStart.setMaximumSize(this.timeStart.getPreferredSize());
        JPanel timeStartPanel = new JPanel();
        timeStartPanel.setLayout(new BoxLayout(timeStartPanel, 0));
        timeStartPanel.add(Box.createHorizontalGlue());
        timeStartPanel.add(timeStartLabel);
        timeStartPanel.add(this.timeStart);
        timeStartPanel.add(Box.createHorizontalGlue());
        timeStartPanel.setBackground(Color.LIGHT_GRAY);
        JPanel timeRangePanel = new JPanel();
        timeRangePanel.setLayout(new BoxLayout(timeRangePanel, 0));
        timeRangePanel.add(Box.createHorizontalGlue());
        timeRangePanel.add(timeSizePanel);
        timeRangePanel.add(timeStartPanel);
        timeRangePanel.add(Box.createHorizontalGlue());
        timeRangePanel.setBackground(Color.LIGHT_GRAY);
        JLabel timeTRLabel = new JLabel("Series Point Size (s) ");
        String timeTRStr = String.valueOf(this.viewer.getVolume().getTR());
        if (isVariableTiming) {
            timeTRStr = String.valueOf(Header.getSmallestVolumeTiming(this.viewer.getVolume().getVolumeTiming()));
        }
        this.timeTR = new MangoTextField(String.valueOf(timeTRStr), 3, this, true);
        this.timeTR.setActionCommand("time tr");
        this.timeTR.addActionListener(this);
        this.timeTR.setCaretPosition(0);
        this.timeTR.setMaximumSize(this.timeTR.getPreferredSize());
        JPanel timeTRPanel = new JPanel();
        timeTRPanel.setLayout(new BoxLayout(timeTRPanel, 0));
        timeTRPanel.add(Box.createHorizontalGlue());
        timeTRPanel.add(timeTRLabel);
        timeTRPanel.add(this.timeTR);
        timeTRPanel.add(Box.createHorizontalGlue());
        timeTRPanel.setBackground(Color.LIGHT_GRAY);
        JPanel reslicePanel = new JPanel();
        reslicePanel.setLayout(new BoxLayout(reslicePanel, 1));
        reslicePanel.setBackground(Color.LIGHT_GRAY);
        reslicePanel.add(Box.createVerticalGlue());
        reslicePanel.add(voxSizePanel);
        reslicePanel.add(Box.createVerticalStrut(4));
        reslicePanel.add(dimPanel);
        reslicePanel.add(Box.createVerticalStrut(4));
        reslicePanel.add(startPanel);
        reslicePanel.add(Box.createVerticalStrut(4));
        reslicePanel.add(roiPanel);
        reslicePanel.add(Box.createVerticalGlue());
        reslicePanel.add(timeLabelPanel);
        reslicePanel.add(Box.createVerticalStrut(4));
        reslicePanel.add(timeRangePanel);
        reslicePanel.add(Box.createVerticalStrut(4));
        reslicePanel.add(timeTRPanel);
        reslicePanel.add(Box.createVerticalGlue());
        return reslicePanel;
    }

    private JPanel buildTransformTabUI() {
        this.transformBox = new MangoComboBox();
        this.transformBox.setPrototypeDisplayValue("    No Transform   ");
        this.transformBox.setMaximumSize(this.transformBox.getPreferredSize());
        this.transformBox.addItem("   No Transform    ");
        this.transformBox.addItem("  Apply Transform  ");
        this.transformBox.addActionListener(this);
        this.transformBox.setActionCommand(ACTION_TRANSFORM);
        JPanel transformBoxPanel = new JPanel();
        transformBoxPanel.setLayout(new BoxLayout(transformBoxPanel, 0));
        transformBoxPanel.add(Box.createHorizontalGlue());
        transformBoxPanel.add(this.transformBox);
        transformBoxPanel.add(Box.createHorizontalGlue());
        transformBoxPanel.setBackground(Color.LIGHT_GRAY);
        JLabel useTransformLabel = new JLabel("Transform", 0);
        useTransformLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel useTransformLabelPanel = new JPanel();
        useTransformLabelPanel.setLayout(new BoxLayout(useTransformLabelPanel, 0));
        useTransformLabelPanel.add(Box.createHorizontalGlue());
        useTransformLabelPanel.add(useTransformLabel);
        useTransformLabelPanel.add(Box.createHorizontalGlue());
        useTransformLabelPanel.setBackground(Color.LIGHT_GRAY);
        JPanel useTransformPanel = new JPanel();
        useTransformPanel.setLayout(new BoxLayout(useTransformPanel, 1));
        useTransformPanel.add(useTransformLabelPanel);
        useTransformPanel.add(transformBoxPanel);
        useTransformPanel.setBackground(Color.LIGHT_GRAY);
        this.overlayBox = new MangoComboBox();
        this.overlayBox.setPrototypeDisplayValue("    No Transform   ");
        this.overlayBox.setMaximumSize(this.overlayBox.getPreferredSize());
        this.overlayBox.addItem(StringUtilities.makeNiceImageName((String)this.viewer.getLoadedFile().getName()));
        Vector<ScreenImage> overlays = this.viewer.getOverlayManager().getScreenImages();
        for (ScreenImage overlay : overlays) {
            this.overlayBox.addItem(StringUtilities.makeNiceImageName((String)new File(overlay.getURI()).getName()));
        }
        this.overlayBox.addActionListener(this);
        this.overlayBox.setActionCommand(ACTION_OVERLAY);
        JPanel overlayBoxPanel = new JPanel();
        overlayBoxPanel.setLayout(new BoxLayout(overlayBoxPanel, 0));
        overlayBoxPanel.add(Box.createHorizontalGlue());
        overlayBoxPanel.add(this.overlayBox);
        overlayBoxPanel.add(Box.createHorizontalGlue());
        overlayBoxPanel.setBackground(Color.LIGHT_GRAY);
        JLabel overlayLabel = new JLabel("Output Volume", 0);
        overlayLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel overlayLabelPanel = new JPanel();
        overlayLabelPanel.setLayout(new BoxLayout(overlayLabelPanel, 0));
        overlayLabelPanel.add(Box.createHorizontalGlue());
        overlayLabelPanel.add(overlayLabel);
        overlayLabelPanel.add(Box.createHorizontalGlue());
        overlayLabelPanel.setBackground(Color.LIGHT_GRAY);
        JPanel useOverlayPanel = new JPanel();
        useOverlayPanel.setLayout(new BoxLayout(useOverlayPanel, 1));
        useOverlayPanel.add(overlayLabelPanel);
        useOverlayPanel.add(overlayBoxPanel);
        useOverlayPanel.setBackground(Color.LIGHT_GRAY);
        this.threshold = new JCheckBox("Threshold");
        this.threshold.setActionCommand(ACTION_THRESHOLD);
        this.threshold.addActionListener(this);
        this.threshold.setBackground(Color.LIGHT_GRAY);
        this.mix = new JCheckBox("Mix");
        this.mix.setActionCommand(ACTION_MIX);
        this.mix.addActionListener(this);
        this.mix.setBackground(Color.LIGHT_GRAY);
        JPanel overlayOptionsPanel = new JPanel();
        overlayOptionsPanel.setLayout(new BoxLayout(overlayOptionsPanel, 0));
        overlayOptionsPanel.add(Box.createHorizontalGlue());
        overlayOptionsPanel.add(this.threshold);
        overlayOptionsPanel.add(this.mix);
        overlayOptionsPanel.add(Box.createHorizontalGlue());
        overlayOptionsPanel.setBackground(Color.LIGHT_GRAY);
        JLabel interpolationLabel = new JLabel("Interpolation");
        interpolationLabel.setFont(new Font("SansSerif", 1, 12));
        JPanel interpLabelPanel = new JPanel();
        interpLabelPanel.setLayout(new BoxLayout(interpLabelPanel, 0));
        interpLabelPanel.add(Box.createHorizontalGlue());
        interpLabelPanel.add(interpolationLabel);
        interpLabelPanel.add(Box.createHorizontalGlue());
        interpLabelPanel.setBackground(Color.LIGHT_GRAY);
        this.nearest = new JRadioButton("Nearest Neighbor");
        this.nearest.setBackground(Color.LIGHT_GRAY);
        JPanel nearestRadioPanel = new JPanel();
        nearestRadioPanel.setLayout(new BoxLayout(nearestRadioPanel, 0));
        nearestRadioPanel.add(this.nearest);
        nearestRadioPanel.add(Box.createHorizontalGlue());
        nearestRadioPanel.setBackground(Color.LIGHT_GRAY);
        this.trilinear = new JRadioButton("Trilinear");
        this.trilinear.setBackground(Color.LIGHT_GRAY);
        JPanel triRadioPanel = new JPanel();
        triRadioPanel.setLayout(new BoxLayout(triRadioPanel, 0));
        triRadioPanel.add(this.trilinear);
        triRadioPanel.add(Box.createHorizontalGlue());
        triRadioPanel.setBackground(Color.LIGHT_GRAY);
        this.sinc = new JRadioButton("Sinc");
        this.sinc.setBackground(Color.LIGHT_GRAY);
        JPanel sincRadioPanel = new JPanel();
        sincRadioPanel.setLayout(new BoxLayout(sincRadioPanel, 0));
        sincRadioPanel.add(this.sinc);
        sincRadioPanel.add(Box.createHorizontalGlue());
        sincRadioPanel.setBackground(Color.LIGHT_GRAY);
        ButtonGroup interpGroup = new ButtonGroup();
        interpGroup.add(this.nearest);
        interpGroup.add(this.trilinear);
        interpGroup.add(this.sinc);
        this.trilinear.setSelected(true);
        JPanel interpTypePanel = new JPanel();
        interpTypePanel.setLayout(new BoxLayout(interpTypePanel, 1));
        interpTypePanel.setBackground(Color.LIGHT_GRAY);
        interpTypePanel.add(nearestRadioPanel);
        interpTypePanel.add(triRadioPanel);
        interpTypePanel.add(sincRadioPanel);
        JPanel transformTabPanel = new JPanel();
        transformTabPanel.setLayout(new BoxLayout(transformTabPanel, 1));
        transformTabPanel.setBackground(Color.LIGHT_GRAY);
        transformTabPanel.add(Box.createVerticalGlue());
        transformTabPanel.add(useTransformPanel);
        transformTabPanel.add(Box.createVerticalGlue());
        transformTabPanel.add(useOverlayPanel);
        transformTabPanel.add(Box.createVerticalStrut(2));
        transformTabPanel.add(overlayOptionsPanel);
        transformTabPanel.add(Box.createVerticalGlue());
        transformTabPanel.add(interpLabelPanel);
        transformTabPanel.add(Box.createVerticalStrut(2));
        transformTabPanel.add(interpTypePanel);
        transformTabPanel.add(Box.createVerticalGlue());
        return transformTabPanel;
    }

    private JPanel buildTypeTabUI() {
        JLabel headerLabel = new JLabel("Header Format", 0);
        headerLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel headerLabelPanel = new JPanel();
        headerLabelPanel.setLayout(new BoxLayout(headerLabelPanel, 0));
        headerLabelPanel.add(Box.createHorizontalGlue());
        headerLabelPanel.add(headerLabel);
        headerLabelPanel.add(Box.createHorizontalGlue());
        headerLabelPanel.setBackground(Color.LIGHT_GRAY);
        this.formatBox = new MangoComboBox();
        this.formatBox.setPrototypeDisplayValue("                        ");
        this.formatBox.setActionCommand(ACTION_FORMAT_SELECTED);
        this.formatBox.addActionListener(this);
        this.formatBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.formatBox.getPreferredSize().height));
        int numWritable = Header.LOADED_WRITABLE_FORMATS.size();
        for (int ctr = 0; ctr < numWritable; ++ctr) {
            WritableHeader wh = Header.LOADED_WRITABLE_FORMATS.elementAt(ctr);
            this.formatBox.addItem(PluginManagerDialog.getPluginName(wh));
        }
        JPanel formatBoxPanel = new JPanel();
        formatBoxPanel.setLayout(new BoxLayout(formatBoxPanel, 0));
        formatBoxPanel.add(Box.createHorizontalStrut(10));
        formatBoxPanel.add(this.formatBox);
        formatBoxPanel.add(Box.createHorizontalStrut(10));
        formatBoxPanel.setBackground(Color.LIGHT_GRAY);
        JLabel imageLabel = new JLabel("Data Type", 0);
        imageLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel imageLabelPanel = new JPanel();
        imageLabelPanel.setLayout(new BoxLayout(imageLabelPanel, 0));
        imageLabelPanel.add(Box.createHorizontalGlue());
        imageLabelPanel.add(imageLabel);
        imageLabelPanel.add(Box.createHorizontalGlue());
        imageLabelPanel.setBackground(Color.LIGHT_GRAY);
        this.typeSigned = new JRadioButton("Integer (Signed)");
        this.typeSigned.setActionCommand(ACTION_TYPE_SIGNED);
        this.typeSigned.addActionListener(this);
        this.typeSigned.setBackground(Color.LIGHT_GRAY);
        JPanel typeSignedRadioPanel = new JPanel();
        typeSignedRadioPanel.setLayout(new BoxLayout(typeSignedRadioPanel, 0));
        typeSignedRadioPanel.add(this.typeSigned);
        typeSignedRadioPanel.add(Box.createHorizontalGlue());
        typeSignedRadioPanel.setBackground(Color.LIGHT_GRAY);
        this.typeUnsigned = new JRadioButton("Integer (Unsigned)");
        this.typeUnsigned.setActionCommand(ACTION_TYPE_UNSIGNED);
        this.typeUnsigned.addActionListener(this);
        this.typeUnsigned.setBackground(Color.LIGHT_GRAY);
        JPanel typeUnsignedRadioPanel = new JPanel();
        typeUnsignedRadioPanel.setLayout(new BoxLayout(typeUnsignedRadioPanel, 0));
        typeUnsignedRadioPanel.add(this.typeUnsigned);
        typeUnsignedRadioPanel.add(Box.createHorizontalGlue());
        typeUnsignedRadioPanel.setBackground(Color.LIGHT_GRAY);
        this.typeFloat = new JRadioButton("Floating Point");
        this.typeFloat.setActionCommand(ACTION_TYPE_FLOAT);
        this.typeFloat.addActionListener(this);
        this.typeFloat.setBackground(Color.LIGHT_GRAY);
        JPanel typeFloatRadioPanel = new JPanel();
        typeFloatRadioPanel.setLayout(new BoxLayout(typeFloatRadioPanel, 0));
        typeFloatRadioPanel.add(this.typeFloat);
        typeFloatRadioPanel.add(Box.createHorizontalGlue());
        typeFloatRadioPanel.setBackground(Color.LIGHT_GRAY);
        ButtonGroup typeGroup = new ButtonGroup();
        typeGroup.add(this.typeSigned);
        typeGroup.add(this.typeUnsigned);
        typeGroup.add(this.typeFloat);
        JPanel byteTypePanel = new JPanel();
        byteTypePanel.setLayout(new BoxLayout(byteTypePanel, 1));
        byteTypePanel.setBackground(Color.LIGHT_GRAY);
        byteTypePanel.add(typeSignedRadioPanel);
        byteTypePanel.add(typeUnsignedRadioPanel);
        byteTypePanel.add(typeFloatRadioPanel);
        JLabel bitsLabel = new JLabel("Bit Depth");
        bitsLabel.setFont(MangoStyle.FONT_BOLD);
        this.type8 = new JRadioButton("8");
        this.type8.setActionCommand(ACTION_TYPE8);
        this.type8.addActionListener(this);
        this.type8.setBackground(Color.LIGHT_GRAY);
        this.type16 = new JRadioButton("16");
        this.type16.setActionCommand(ACTION_TYPE16);
        this.type16.addActionListener(this);
        this.type16.setBackground(Color.LIGHT_GRAY);
        this.type32 = new JRadioButton("32");
        this.type32.setActionCommand(ACTION_TYPE32);
        this.type32.addActionListener(this);
        this.type32.setBackground(Color.LIGHT_GRAY);
        ButtonGroup typeBytes = new ButtonGroup();
        typeBytes.add(this.type8);
        typeBytes.add(this.type16);
        typeBytes.add(this.type32);
        JPanel bitsTitlePanel = new JPanel();
        bitsTitlePanel.setLayout(new BoxLayout(bitsTitlePanel, 0));
        bitsTitlePanel.add(bitsLabel);
        bitsTitlePanel.setBackground(Color.LIGHT_GRAY);
        JPanel bitsPanel = new JPanel();
        bitsPanel.setLayout(new BoxLayout(bitsPanel, 0));
        bitsPanel.add(this.type8);
        bitsPanel.add(this.type16);
        bitsPanel.add(this.type32);
        bitsPanel.setBackground(Color.LIGHT_GRAY);
        this.little = new JRadioButton("Little");
        this.little.setBackground(Color.LIGHT_GRAY);
        this.big = new JRadioButton("Big");
        this.big.setBackground(Color.LIGHT_GRAY);
        ButtonGroup orderGroup = new ButtonGroup();
        orderGroup.add(this.little);
        orderGroup.add(this.big);
        JLabel byteOrderLabel = new JLabel("Byte Order");
        byteOrderLabel.setFont(MangoStyle.FONT_BOLD);
        JPanel byteOrderTitlePanel = new JPanel();
        byteOrderTitlePanel.setLayout(new BoxLayout(byteOrderTitlePanel, 0));
        byteOrderTitlePanel.add(byteOrderLabel);
        byteOrderTitlePanel.setBackground(Color.LIGHT_GRAY);
        JPanel byteOrderPanel = new JPanel();
        byteOrderPanel.setLayout(new BoxLayout(byteOrderPanel, 0));
        byteOrderPanel.add(this.little);
        byteOrderPanel.add(this.big);
        byteOrderPanel.setBackground(Color.LIGHT_GRAY);
        JPanel imageTypePanel = new JPanel();
        imageTypePanel.setLayout(new BoxLayout(imageTypePanel, 1));
        imageTypePanel.add(Box.createVerticalGlue());
        imageTypePanel.add(headerLabelPanel);
        imageTypePanel.add(Box.createVerticalStrut(2));
        imageTypePanel.add(formatBoxPanel);
        imageTypePanel.add(Box.createVerticalGlue());
        imageTypePanel.add(imageLabelPanel);
        imageTypePanel.add(Box.createVerticalStrut(2));
        imageTypePanel.add(byteTypePanel);
        imageTypePanel.add(Box.createVerticalGlue());
        imageTypePanel.add(bitsTitlePanel);
        imageTypePanel.add(Box.createVerticalStrut(2));
        imageTypePanel.add(bitsPanel);
        imageTypePanel.add(Box.createVerticalGlue());
        imageTypePanel.add(byteOrderTitlePanel);
        imageTypePanel.add(Box.createVerticalStrut(2));
        imageTypePanel.add(byteOrderPanel);
        imageTypePanel.add(Box.createVerticalGlue());
        imageTypePanel.setBackground(Color.LIGHT_GRAY);
        return imageTypePanel;
    }

    private void buildUI() {
        this.textField = (JTextField)SwingWidgetUtilities.findComponentOfType((Component)this, JTextField.class);
        this.loadedHeaderFormat = this.viewer.getVolume().getLoadedHeaderType();
        this.currentOutputFormat = Header.makeWritableHeader(this.loadedHeaderFormat);
        if (this.currentOutputFormat == null) {
            this.currentOutputFormat = new NIFTI();
            this.loadedHeaderFormat = "NIFTI";
        }
        this.freezeActions = true;
        JPanel typeTabPanel = this.buildTypeTabUI();
        JPanel resliceTabPanel = this.buildResliceTabUI();
        JPanel transformTabPanel = this.buildTransformTabUI();
        JPanel miscTabPanel = this.buildMiscTabUI();
        JTabbedPane saveOptionPanelOut = null;
        saveOptionPanelOut = Platform.MAC ? new JTabbedPane(2) : new JTabbedPane(1);
        saveOptionPanelOut.addTab("Type", typeTabPanel);
        saveOptionPanelOut.addTab("Reslice", resliceTabPanel);
        saveOptionPanelOut.addTab("Transform", transformTabPanel);
        saveOptionPanelOut.addTab("Misc", miscTabPanel);
        saveOptionPanelOut.setTabLayoutPolicy(1);
        saveOptionPanelOut.setPreferredSize(Platform.MAC ? ACCESSORY_SIZE_MAC : ACCESSORY_SIZE);
        this.setAccessory(saveOptionPanelOut);
        this.resetChoosableFileFilters();
        this.setFileSelectionMode(0);
        this.setDialogType(1);
        this.setMultiSelectionEnabled(false);
        this.setDialogTitle("Save As");
        this.setPreferredSize(Platform.MAC ? START_SIZE_MAC : START_SIZE);
        this.freezeActions = false;
        if (Header.makeWritableHeader(this.loadedHeaderFormat) != null) {
            this.formatBox.setSelectedItem(this.loadedHeaderFormat);
        } else {
            this.formatBox.setSelectedItem("NIFTI");
        }
        this.initializeSelectedFile();
        this.doFormatSelected();
        this.initializeTransforms();
        this.initializeOverlayBox();
        this.initializeSelectedFolder();
    }

    private void closePopups() {
        if (this.popupROI != null) {
            this.popupROI.hide();
            this.popupROI = null;
        }
    }

    private boolean contains(int[] array, int value) {
        for (int element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    private void doROIButtonChosen(int colorNum) {
        int roiColor = colorNum;
        if (roiColor == -1) {
            VoxelDimensions vd = this.viewer.getVolume().getVoxelDimensions();
            this.voxSizeX.setText(String.valueOf(vd.getXSize()));
            this.voxSizeY.setText(String.valueOf(vd.getYSize()));
            this.voxSizeZ.setText(String.valueOf(vd.getZSize()));
            ImageDimensions id = this.viewer.getVolume().getImageDimensions();
            this.dimX.setText(String.valueOf(id.getX()));
            this.dimY.setText(String.valueOf(id.getY()));
            this.dimZ.setText(String.valueOf(id.getZ()));
            this.startX.setText("0");
            this.startY.setText("0");
            this.startZ.setText("0");
        } else {
            VoxelDimensions vd = this.viewer.getVolume().getVoxelDimensions();
            this.voxSizeX.setText(String.valueOf(vd.getXSize()));
            this.voxSizeY.setText(String.valueOf(vd.getYSize()));
            this.voxSizeZ.setText(String.valueOf(vd.getZSize()));
            ImageBounds ib = this.viewer.getROIManager().getROIBounds(1L << roiColor);
            this.dimX.setText(String.valueOf(ib.getMaxX() - ib.getMinX() + 1));
            this.dimY.setText(String.valueOf(ib.getMaxY() - ib.getMinY() + 1));
            this.dimZ.setText(String.valueOf(ib.getMaxZ() - ib.getMinZ() + 1));
            this.startX.setText(String.valueOf(ib.getMinX()));
            this.startY.setText(String.valueOf(ib.getMinY()));
            this.startZ.setText(String.valueOf(ib.getMinZ()));
        }
        if (this.textField != null) {
            this.textField.repaint();
        }
        if (this.previewButton.isSelected()) {
            this.updatePreview();
        }
    }

    private boolean findBestFloatDatatype(WritableHeader wh, boolean matchOnly) {
        int byteType = this.viewer.getVolume().getImageType().getByteType();
        int numBytes = this.viewer.getVolume().getImageType().getNumBytesPerVoxel();
        int[] numBytesSupported = wh.getSupportedBytesForType(4);
        if ((!matchOnly || byteType == 4) && CollectionUtilities.isNotEmpty((Object)numBytesSupported)) {
            if (this.contains(numBytesSupported, numBytes)) {
                this.typeFloat.setSelected(true);
                this.getDatatypeRadioButton(numBytes).setSelected(true);
                return true;
            }
            if (this.contains(numBytesSupported, 4)) {
                this.typeFloat.setSelected(true);
                this.type32.setSelected(true);
                return true;
            }
        }
        return false;
    }

    private boolean findBestSignedIntegerDatatype(WritableHeader wh, boolean matchOnly) {
        int byteType = this.viewer.getVolume().getImageType().getByteType();
        int numBytes = this.viewer.getVolume().getImageType().getNumBytesPerVoxel();
        int[] numBytesSupported = wh.getSupportedBytesForType(2);
        if ((!matchOnly || byteType == 2) && CollectionUtilities.isNotEmpty((Object)numBytesSupported)) {
            if (this.contains(numBytesSupported, numBytes)) {
                this.typeSigned.setSelected(true);
                this.getDatatypeRadioButton(numBytes).setSelected(true);
                return true;
            }
            if (this.contains(numBytesSupported, 2)) {
                this.typeSigned.setSelected(true);
                this.type16.setSelected(true);
                return true;
            }
            if (this.contains(numBytesSupported, 4)) {
                this.typeSigned.setSelected(true);
                this.type32.setSelected(true);
                return true;
            }
            if (this.contains(numBytesSupported, 1)) {
                this.typeSigned.setSelected(true);
                this.type8.setSelected(true);
                return true;
            }
        }
        return false;
    }

    private boolean findBestUnsignedIntegerDatatype(WritableHeader wh, boolean matchOnly) {
        int byteType = this.viewer.getVolume().getImageType().getByteType();
        int numBytes = this.viewer.getVolume().getImageType().getNumBytesPerVoxel();
        int[] numBytesSupported = wh.getSupportedBytesForType(3);
        if ((!matchOnly || byteType == 3) && CollectionUtilities.isNotEmpty((Object)numBytesSupported)) {
            if (this.contains(numBytesSupported, numBytes)) {
                this.typeUnsigned.setSelected(true);
                this.getDatatypeRadioButton(numBytes).setSelected(true);
                return true;
            }
            if (this.contains(numBytesSupported, 2)) {
                this.typeUnsigned.setSelected(true);
                this.type16.setSelected(true);
                return true;
            }
            if (this.contains(numBytesSupported, 4)) {
                this.typeUnsigned.setSelected(true);
                this.type32.setSelected(true);
                return true;
            }
            if (this.contains(numBytesSupported, 1)) {
                this.typeUnsigned.setSelected(true);
                this.type8.setSelected(true);
                return true;
            }
        }
        return false;
    }

    private JRadioButton getDatatypeRadioButton(int numBytes) {
        if (numBytes == 1) {
            return this.type8;
        }
        if (numBytes == 2) {
            return this.type16;
        }
        if (numBytes == 4) {
            return this.type32;
        }
        return null;
    }

    private void initializeSelectedFolder() {
        File loadedFile = this.viewer.getLoadedFile();
        File folder = loadedFile.getParentFile();
        if (folder.equals(Platform.getTempDir())) {
            this.setCurrentDirectory(new File(this.mango.getLoadFileDirectory()));
        } else {
            this.setCurrentDirectory(folder);
        }
    }

    private void initializeSelectedFile() {
        this.setSelectedFile(this.viewer.getLoadedFile());
    }

    private void resetResliceBounds() {
        VoxelDimensions vd = this.viewer.getVolume().getVoxelDimensions();
        this.voxSizeX.setText(String.valueOf(vd.getXSize()));
        this.voxSizeY.setText(String.valueOf(vd.getYSize()));
        this.voxSizeZ.setText(String.valueOf(vd.getZSize()));
        ImageDimensions id = this.viewer.getVolume().getImageDimensions();
        this.dimX.setText(String.valueOf(id.getX()));
        this.dimY.setText(String.valueOf(id.getY()));
        this.dimZ.setText(String.valueOf(id.getZ()));
        this.startX.setText("0");
        this.startY.setText("0");
        this.startZ.setText("0");
    }

    private void showROIColorPicker() {
        this.popupROI = PopupFactory.getSharedInstance().getPopup(this.roiButton, new MangoColorPicker((ColorManager)this.viewer.getROIManager(), this, this.viewer.getROIManager(), this.viewer.getROIManager().getBuffer().getMaximumColors(), false), this.roiButton.getLocationOnScreen().x, this.roiButton.getLocationOnScreen().y + 35);
        this.popupROI.show();
    }

    private void toggleROIColorChooser() {
        if (this.popupROI != null) {
            this.popupROI.hide();
            this.popupROI = null;
        } else {
            this.showROIColorPicker();
        }
    }

    private void updateApplyDataScaleButton() {
        ImageType itImage = this.viewer.getVolume().getImageType();
        ImageType itSelected = this.getSelectedFileImageType();
        int byteTypeImage = itImage.getByteType();
        int byteTypeSelected = itSelected.getByteType();
        int numBytesImage = itImage.getNumBytesPerVoxel();
        int numBytesSelected = itSelected.getNumBytesPerVoxel();
        if (!this.viewer.getVolume().hasGlobalDataScale()) {
            if (numBytesSelected == numBytesImage && itImage.isInteger() && itSelected.isInteger() && byteTypeImage != byteTypeSelected && numBytesImage < 4) {
                this.applyDataScales.setSelected(false);
            } else if (this.mix.isSelected() || this.fitPrecision.isSelected()) {
                this.applyDataScales.setSelected(true);
            } else if (this.viewer.getVolume().hasDefaultDataScales()) {
                this.applyDataScales.setSelected(false);
            } else {
                boolean transformBoxEqualsDefault = this.transformBox.getSelectedItem() != null && ((String)this.transformBox.getSelectedItem()).equals("   No Transform    ");
                boolean orientationEqualsDefault = true;
                boolean headerTypeNotSupportSlicewiseScales = true;
                try {
                    headerTypeNotSupportSlicewiseScales = !this.currentOutputFormat.isSupportedMultipleDataScales();
                }
                catch (AbstractMethodError err) {
                    AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                }
                catch (NoSuchMethodError err) {
                    AppLogger.warn((String)("This plugin is missing required methods and should be updated.. (" + err.getMessage() + ")"));
                }
                if (this.usesCustomOrientation()) {
                    orientationEqualsDefault = this.viewer.getVolume().getOrientationString().equals(this.orientationCustom.getSelectedItem());
                } else {
                    String orientationString = this.viewer.getVolume().getOrientationString();
                    boolean orientation1EqualsDefault = orientationString.substring(0, 3).equals(this.orientation1.getSelectedItem());
                    boolean orientation2EqualsDefault = orientationString.substring(3).equals(this.orientation2.getSelectedItem());
                    boolean bl = orientationEqualsDefault = orientation1EqualsDefault && orientation2EqualsDefault;
                }
                if (!transformBoxEqualsDefault || !orientationEqualsDefault || headerTypeNotSupportSlicewiseScales) {
                    this.applyDataScales.setSelected(true);
                }
            }
        }
        this.updateMaintainZero();
    }

    private void updateCompression() {
        this.compression.setEnabled(this.currentOutputFormat.canCompress());
        this.compression.setSelected(this.currentOutputFormat.canCompress());
    }

    private void updateDatatype(WritableHeader wh, String command) {
        if (!this.freezeDatatypeChanges) {
            int byteTypeSelected;
            int[] types;
            int numBytesSelected;
            int[] bytes;
            this.freezeDatatypeChanges = true;
            if (command.equals(ACTION_TYPE_FLOAT)) {
                this.type32.setSelected(true);
                bytes = wh.getSupportedBytesForType(4);
                boolean supported = false;
                if (CollectionUtilities.isNotEmpty((Object)bytes)) {
                    for (int b : bytes) {
                        if (b != 4) continue;
                        supported = true;
                    }
                }
                if (!supported) {
                    this.verifyDatatype(wh);
                }
            } else if (command.equals(ACTION_TYPE_SIGNED)) {
                bytes = wh.getSupportedBytesForType(2);
                numBytesSelected = this.getSelectedFileImageType().getNumBytesPerVoxel();
                boolean supported = false;
                if (CollectionUtilities.isNotEmpty((Object)bytes)) {
                    for (int b : bytes) {
                        if (b != numBytesSelected) continue;
                        supported = true;
                    }
                }
                if (!supported) {
                    if (CollectionUtilities.isNotEmpty((Object)bytes)) {
                        if (bytes[0] == 1) {
                            this.type8.setSelected(true);
                        } else if (bytes[0] == 2) {
                            this.type16.setSelected(true);
                        } else if (bytes[0] == 4) {
                            this.type32.setSelected(true);
                        } else {
                            this.verifyDatatype(wh);
                        }
                    } else {
                        this.verifyDatatype(wh);
                    }
                }
            } else if (command.equals(ACTION_TYPE_UNSIGNED)) {
                bytes = wh.getSupportedBytesForType(3);
                numBytesSelected = this.getSelectedFileImageType().getNumBytesPerVoxel();
                boolean supported = false;
                if (CollectionUtilities.isNotEmpty((Object)bytes)) {
                    for (int b : bytes) {
                        if (b != numBytesSelected) continue;
                        supported = true;
                    }
                }
                if (!supported) {
                    if (CollectionUtilities.isNotEmpty((Object)bytes)) {
                        if (bytes[0] == 1) {
                            this.type8.setSelected(true);
                        } else if (bytes[0] == 2) {
                            this.type16.setSelected(true);
                        } else if (bytes[0] == 4) {
                            this.type32.setSelected(true);
                        } else {
                            this.verifyDatatype(wh);
                        }
                    } else {
                        this.verifyDatatype(wh);
                    }
                }
            } else if (command.equals(ACTION_TYPE8)) {
                if (this.typeFloat.isSelected()) {
                    this.typeSigned.setSelected(true);
                }
                types = wh.getSupportedTypesForBytes(1);
                byteTypeSelected = this.getSelectedFileImageType().getByteType();
                boolean supported = false;
                if (CollectionUtilities.isNotEmpty((Object)types)) {
                    for (int type : types) {
                        if (type != byteTypeSelected) continue;
                        supported = true;
                    }
                }
                if (!supported) {
                    if (CollectionUtilities.isNotEmpty((Object)types)) {
                        if (types[0] == 2) {
                            this.typeSigned.setSelected(true);
                        } else if (types[0] == 3) {
                            this.typeUnsigned.setSelected(true);
                        } else if (types[0] == 4) {
                            this.typeFloat.setSelected(true);
                        } else {
                            this.verifyDatatype(wh);
                        }
                    } else {
                        this.verifyDatatype(wh);
                    }
                }
            } else if (command.equals(ACTION_TYPE16)) {
                if (this.typeFloat.isSelected()) {
                    this.typeSigned.setSelected(true);
                }
                types = wh.getSupportedTypesForBytes(2);
                byteTypeSelected = this.getSelectedFileImageType().getByteType();
                boolean supported = false;
                if (CollectionUtilities.isNotEmpty((Object)types)) {
                    for (int type : types) {
                        if (type != byteTypeSelected) continue;
                        supported = true;
                    }
                }
                if (!supported) {
                    if (CollectionUtilities.isNotEmpty((Object)types)) {
                        if (types[0] == 2) {
                            this.typeSigned.setSelected(true);
                        } else if (types[0] == 3) {
                            this.typeUnsigned.setSelected(true);
                        } else if (types[0] == 4) {
                            this.typeFloat.setSelected(true);
                        } else {
                            this.verifyDatatype(wh);
                        }
                    } else {
                        this.verifyDatatype(wh);
                    }
                }
            } else if (command.equals(ACTION_TYPE32)) {
                types = wh.getSupportedTypesForBytes(4);
                byteTypeSelected = this.getSelectedFileImageType().getByteType();
                boolean supported = false;
                if (CollectionUtilities.isNotEmpty((Object)types)) {
                    for (int type : types) {
                        if (type != byteTypeSelected) continue;
                        supported = true;
                    }
                }
                if (!supported) {
                    if (CollectionUtilities.isNotEmpty((Object)types)) {
                        if (types[0] == 2) {
                            this.typeSigned.setSelected(true);
                        } else if (types[0] == 3) {
                            this.typeUnsigned.setSelected(true);
                        } else if (types[0] == 4) {
                            this.typeFloat.setSelected(true);
                        } else {
                            this.verifyDatatype(wh);
                        }
                    } else {
                        this.verifyDatatype(wh);
                    }
                }
            }
            boolean enableByteOrders = !this.type8.isSelected();
            boolean bigEndianSupported = false;
            boolean littleEndianSupported = false;
            try {
                bigEndianSupported = wh.isSupportedBigEndian();
                littleEndianSupported = wh.isSupportedLittleEndian();
            }
            catch (AbstractMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
            }
            catch (NoSuchMethodError err) {
                AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
            }
            if (!(enableByteOrders &= bigEndianSupported && littleEndianSupported)) {
                if (bigEndianSupported) {
                    this.big.setSelected(true);
                } else {
                    this.little.setSelected(true);
                }
            }
            this.little.setEnabled(enableByteOrders);
            this.big.setEnabled(enableByteOrders);
            this.freezeDatatypeChanges = false;
        }
        this.updateMixed();
    }

    private void updateFitPrecision() {
        ImageType itImage = this.viewer.getVolume().getImageType();
        ImageType itSelected = this.getSelectedFileImageType();
        int byteTypeImage = itImage.getByteType();
        int byteTypeSelected = itSelected.getByteType();
        int numBytesImage = itImage.getNumBytesPerVoxel();
        int numBytesSelected = itSelected.getNumBytesPerVoxel();
        if (this.mix.isSelected()) {
            this.fitPrecision.setSelected(false);
            this.applyDataScales.setSelected(true);
        } else if (numBytesSelected < numBytesImage) {
            this.fitPrecision.setSelected(true);
            this.applyDataScales.setSelected(true);
        } else if (this.type32.isSelected() && !this.typeFloat.isSelected() && byteTypeImage == 4) {
            this.fitPrecision.setSelected(true);
            this.applyDataScales.setSelected(true);
        } else if (numBytesSelected == numBytesImage && itImage.isInteger() && itSelected.isInteger() && byteTypeImage != byteTypeSelected && numBytesImage < 4) {
            this.fitPrecision.setSelected(true);
            this.applyDataScales.setSelected(false);
        } else {
            double typeRange;
            ImageType it = this.getSelectedFileImageType();
            double typeMax = it.getTypeMax(false);
            double typeMin = it.getTypeMin(false);
            double imageMin = this.viewer.getVolume().getMinImageDiskValue();
            double imageMax = this.viewer.getVolume().getMaxImageDiskValue();
            double imageRange = imageMax - imageMin;
            this.fitPrecision.setSelected((imageRange > (typeRange = typeMax - typeMin) || imageMin < typeMin || imageMax > typeMax) && it.getByteType() != 4);
            this.applyDataScales.setSelected((imageRange > typeRange || imageMin < typeMin || imageMax > typeMax) && it.getByteType() != 4);
        }
        this.updateMaintainZero();
    }

    private void updateMaintainZero() {
        boolean supportsDataScaleIntercept = true;
        try {
            supportsDataScaleIntercept = this.currentOutputFormat.isSupportedDataScaleIntercept();
        }
        catch (AbstractMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        catch (NoSuchMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        this.maintainZero.setEnabled(this.fitPrecision.isSelected() && supportsDataScaleIntercept);
        if (!this.fitPrecision.isSelected()) {
            this.maintainZero.setSelected(false);
        }
        if (this.fitPrecision.isSelected() && !supportsDataScaleIntercept) {
            this.maintainZero.setSelected(true);
        }
    }

    private void updateThreshold() {
        int overlayNum = this.getSelectedOverlay();
        if (overlayNum == 0) {
            this.threshold.setSelected(false);
            this.threshold.setEnabled(false);
        } else {
            this.threshold.setEnabled(overlayNum > 0);
        }
    }

    private void updateMixed() {
        this.mix.setEnabled(!this.typeFloat.isSelected() && this.threshold.isSelected());
        this.mix.setSelected(!this.typeFloat.isSelected());
        if (!this.threshold.isSelected()) {
            this.mix.setSelected(false);
        }
    }

    private void updateOrientation() {
        Object[] supportedOrientations = null;
        try {
            supportedOrientations = this.currentOutputFormat.getSupportedOrientations();
        }
        catch (AbstractMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        catch (NoSuchMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        boolean supportsAllOrientations = ArrayUtils.isEmpty((Object[])supportedOrientations);
        String orientation = this.viewer.getVolume().getOrientationString();
        if (supportsAllOrientations) {
            this.orientationPanel.removeAll();
            this.orientationPanel.add(this.orientation1Panel);
            this.orientationPanel.add(Box.createVerticalStrut(2));
            this.orientationPanel.add(this.orientation2Panel);
            String order = orientation.substring(0, 3);
            for (int ctr = 0; ctr < ORIENTATION.length; ++ctr) {
                if (!order.equals(ORIENTATION[ctr])) continue;
                this.orientation1.setSelectedIndex(ctr);
            }
            String sense = orientation.substring(3);
            for (int ctr = 0; ctr < SENSE.length; ++ctr) {
                if (!sense.equals(SENSE[ctr])) continue;
                this.orientation2.setSelectedIndex(ctr);
            }
        } else {
            this.orientationCustom.removeAllItems();
            for (Object supportedOrientation : supportedOrientations) {
                this.orientationCustom.addItem(supportedOrientation);
            }
            this.orientationPanel.removeAll();
            this.orientationPanel.add(this.orientationCustomPanel);
            this.orientationCustom.setSelectedItem(orientation);
        }
        this.orientationPanel.revalidate();
    }

    private void initializeOverlayBox() {
        int numOverlays = this.viewer.getNumOverlays();
        if (numOverlays == 0) {
            this.overlayBox.setEnabled(false);
        }
    }

    private void updatePreview() {
        ImageBounds ib = this.getSelectedImageBounds();
        this.viewer.setPreviewPosition(ib.getMinX(), ib.getMaxX() - ib.getMinX() + 1, ib.getMinY(), ib.getMaxY() - ib.getMinY() + 1, ib.getMinZ(), ib.getMaxZ() - ib.getMinZ() + 1, (float)this.getSelectedSizeX(), (float)this.getSelectedSizeY(), (float)this.getSelectedSizeZ());
        this.viewer.updateViewer();
    }

    private void updateSelectedFilename() {
        String name = this.getSelectedFilename();
        name = FileUtilities.removeExtension((String)name);
        name = name + this.currentOutputFormat.getPreferredFileExtension();
        if (this.compression.isSelected()) {
            name = name + ".gz";
        }
        this.setSelectedFile(new File(this.getCurrentDirectory(), name));
    }

    private void initializeTransforms() {
        if (this.viewer.isUsingTransform()) {
            this.transformBox.setSelectedIndex(1);
        } else {
            this.transformBox.setSelectedIndex(0);
        }
    }

    private void verifyDatatype(WritableHeader wh) {
        if (this.findBestFloatDatatype(wh, true)) {
            this.updateEndianness(wh);
            return;
        }
        if (this.findBestSignedIntegerDatatype(wh, true)) {
            this.updateEndianness(wh);
            return;
        }
        if (this.findBestUnsignedIntegerDatatype(wh, true)) {
            this.updateEndianness(wh);
            return;
        }
        if (this.findBestSignedIntegerDatatype(wh, false)) {
            this.updateEndianness(wh);
            return;
        }
        if (this.findBestUnsignedIntegerDatatype(wh, false)) {
            this.updateEndianness(wh);
            return;
        }
        if (this.findBestFloatDatatype(wh, false)) {
            this.updateEndianness(wh);
            return;
        }
    }

    private void updateEndianness(WritableHeader wh) {
        boolean enableByteOrders = !this.type8.isSelected();
        boolean bigEndianSupported = false;
        boolean littleEndianSupported = false;
        try {
            bigEndianSupported = wh.isSupportedBigEndian();
            littleEndianSupported = wh.isSupportedLittleEndian();
        }
        catch (AbstractMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        catch (NoSuchMethodError err) {
            AppLogger.warn((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
        }
        if (!(enableByteOrders &= bigEndianSupported && littleEndianSupported)) {
            if (bigEndianSupported) {
                this.big.setSelected(true);
            } else {
                this.little.setSelected(true);
            }
        }
        this.little.setEnabled(enableByteOrders);
        this.big.setEnabled(enableByteOrders);
        if (!this.little.isSelected() && !this.big.isSelected()) {
            if (!this.viewer.getVolume().getImageType().isLittleEndian() && bigEndianSupported) {
                this.big.setSelected(true);
            } else {
                this.little.setSelected(true);
            }
        }
    }
}

