/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoColorIconPanel;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPaneItem;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.volume.LabelList;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EditROILabelDialog
extends JPanel
implements MangoFocusableOptionPaneItem,
FocusListener {
    private MangoTextField[] labelText;
    private final SliceViewer viewer;
    private final LabelList roiLabels;
    private final int startIndex;
    private static final long serialVersionUID = 1L;
    public static final Dimension START_SIZE = new Dimension(350, 300);
    public static final int SCROLLER_THRESHOLD = 8;

    public EditROILabelDialog(SliceViewer viewer, LabelList roiLabels, int startIndex) {
        this.viewer = viewer;
        this.roiLabels = roiLabels;
        this.startIndex = startIndex;
        this.createGUI();
    }

    @Override
    public void doFocus() {
        this.labelText[this.startIndex].requestFocusInWindow();
        this.labelText[this.startIndex].requestFocus();
    }

    @Override
    public void focusGained(FocusEvent fe) {
        Object obj = fe.getSource();
        if (obj instanceof MangoTextField) {
            MangoTextField stf = (MangoTextField)obj;
            int index = stf.getCode();
            this.viewer.setROIColor(index);
            this.updateScrollPosition(index);
        }
    }

    @Override
    public void focusLost(FocusEvent fe) {
    }

    public void saveLabels() {
        for (int ctr = 0; ctr < this.labelText.length; ++ctr) {
            this.viewer.recordAction("setLabel", new String[]{this.viewer.getScriptObjectName() + ".roiData.allROIs", ScriptUtils.convertString(this.labelText[ctr].getText())}, true);
            this.roiLabels.setLabel(ctr, this.labelText[ctr].getText());
        }
    }

    private void createGUI() {
        int numColors = this.viewer.getROIManager().getBuffer().getMaximumColors();
        String[] labels = this.roiLabels.getLabelModelCopy();
        this.labelText = new MangoTextField[labels.length];
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        this.setLayout(new BoxLayout(this, 1));
        Vector<ROIColor> colors = ROIColor.getColorsDisplayOrder(labels.length / 8);
        for (ROIColor color : colors) {
            int index = color.getIndex();
            MangoColorIconPanel roiIconLabel = new MangoColorIconPanel(this.viewer.getROIManager(), color, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(index, labels.length), false);
            this.labelText[index] = new MangoTextField(labels[index], 20);
            this.labelText[index].setCode(index);
            this.labelText[index].addFocusListener(this);
            JPanel labelTextPanel = new JPanel();
            labelTextPanel.setLayout(new BoxLayout(labelTextPanel, 0));
            labelTextPanel.add(Box.createHorizontalGlue());
            labelTextPanel.add(this.labelText[index]);
            labelTextPanel.add(Box.createHorizontalStrut(8));
            labelTextPanel.add(roiIconLabel);
            labelTextPanel.add(Box.createHorizontalGlue());
            content.add(labelTextPanel);
            content.add(Box.createVerticalStrut(2));
        }
        if (numColors > 8) {
            JScrollPane scroller = new JScrollPane(content);
            scroller.setPreferredSize(START_SIZE);
            this.add(scroller);
        } else {
            this.add(content);
        }
        this.add(Box.createVerticalStrut(8));
        JLabel messageLabel = new JLabel("<html>Enter descriptive labels for ROI colors</html>", 0);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BoxLayout(messagePanel, 0));
        messagePanel.add(Box.createHorizontalGlue());
        messagePanel.add(messageLabel);
        messagePanel.add(Box.createHorizontalGlue());
        this.add(messagePanel);
        this.add(Box.createVerticalStrut(8));
    }

    private void updateScrollPosition(int toIndex) {
        ((JComponent)this.labelText[toIndex].getParent()).scrollRectToVisible(this.labelText[toIndex].getBounds());
    }
}

