/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.menus.ViewerMenuAction;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.Transform;
import edu.uthscsa.ric.volume.Volume;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AddTransformDialog
extends JPanel
implements ActionListener {
    private double xSize;
    private double ySize;
    private double zSize;
    private final JButton selectRefButton;
    private final JPanel centerPanel;
    private final JPanel fslPanel;
    private final JRadioButton centerButton;
    private final JRadioButton coordinate;
    private final JRadioButton currentButton;
    private final JRadioButton diffOrientBox;
    private final JRadioButton image;
    private final JRadioButton originButton;
    private final JTextField t00;
    private final JTextField t01;
    private final JTextField t02;
    private final JTextField t03;
    private final JTextField t10;
    private final JTextField t11;
    private final JTextField t12;
    private final JTextField t13;
    private final JTextField t20;
    private final JTextField t21;
    private final JTextField t22;
    private final JTextField t23;
    private final JTextField t30;
    private final JTextField t31;
    private final JTextField t32;
    private final JTextField t33;
    private final MangoComboBox<String> orientation1;
    private final MangoComboBox<String> orientation2;
    private final SliceViewer viewer;
    private static final String[] ORIENTATION = new String[]{"XYZ", "XZY", "YXZ", "YZX", "ZXY", "ZYX"};
    private static final String[] SENSE = new String[]{"+++", "++-", "+-+", "-++", "+--", "-+-", "--+", "---"};
    private static final long serialVersionUID = 1L;

    public AddTransformDialog(SliceViewer viewer) {
        this.viewer = viewer;
        this.t00 = new MangoTextField("1", 6);
        this.t00.setMinimumSize(this.t00.getPreferredSize());
        this.t00.setMaximumSize(this.t00.getPreferredSize());
        this.t01 = new MangoTextField("0", 6);
        this.t01.setMinimumSize(this.t01.getPreferredSize());
        this.t01.setMaximumSize(this.t01.getPreferredSize());
        this.t02 = new MangoTextField("0", 6);
        this.t02.setMinimumSize(this.t02.getPreferredSize());
        this.t02.setMaximumSize(this.t02.getPreferredSize());
        this.t03 = new MangoTextField("0", 6);
        this.t03.setMinimumSize(this.t03.getPreferredSize());
        this.t03.setMaximumSize(this.t03.getPreferredSize());
        JPanel tPanel0 = new JPanel();
        tPanel0.setLayout(new BoxLayout(tPanel0, 0));
        tPanel0.add(this.t00);
        tPanel0.add(this.t01);
        tPanel0.add(this.t02);
        tPanel0.add(this.t03);
        this.t10 = new MangoTextField("0", 6);
        this.t10.setMinimumSize(this.t10.getPreferredSize());
        this.t10.setMaximumSize(this.t10.getPreferredSize());
        this.t11 = new MangoTextField("1", 6);
        this.t11.setMinimumSize(this.t11.getPreferredSize());
        this.t11.setMaximumSize(this.t11.getPreferredSize());
        this.t12 = new MangoTextField("0", 6);
        this.t12.setMinimumSize(this.t12.getPreferredSize());
        this.t12.setMaximumSize(this.t12.getPreferredSize());
        this.t13 = new MangoTextField("0", 6);
        this.t13.setMinimumSize(this.t13.getPreferredSize());
        this.t13.setMaximumSize(this.t13.getPreferredSize());
        JPanel tPanel1 = new JPanel();
        tPanel1.setLayout(new BoxLayout(tPanel1, 0));
        tPanel1.add(this.t10);
        tPanel1.add(this.t11);
        tPanel1.add(this.t12);
        tPanel1.add(this.t13);
        this.t20 = new MangoTextField("0", 6);
        this.t20.setMinimumSize(this.t20.getPreferredSize());
        this.t20.setMaximumSize(this.t20.getPreferredSize());
        this.t21 = new MangoTextField("0", 6);
        this.t21.setMinimumSize(this.t21.getPreferredSize());
        this.t21.setMaximumSize(this.t21.getPreferredSize());
        this.t22 = new MangoTextField("1", 6);
        this.t22.setMinimumSize(this.t22.getPreferredSize());
        this.t22.setMaximumSize(this.t22.getPreferredSize());
        this.t23 = new MangoTextField("0", 6);
        this.t23.setMinimumSize(this.t23.getPreferredSize());
        this.t23.setMaximumSize(this.t23.getPreferredSize());
        JPanel tPanel2 = new JPanel();
        tPanel2.setLayout(new BoxLayout(tPanel2, 0));
        tPanel2.add(this.t20);
        tPanel2.add(this.t21);
        tPanel2.add(this.t22);
        tPanel2.add(this.t23);
        this.t30 = new MangoTextField("0", 6);
        this.t30.setMinimumSize(this.t30.getPreferredSize());
        this.t30.setMaximumSize(this.t30.getPreferredSize());
        this.t31 = new MangoTextField("0", 6);
        this.t31.setMinimumSize(this.t31.getPreferredSize());
        this.t31.setMaximumSize(this.t31.getPreferredSize());
        this.t32 = new MangoTextField("0", 6);
        this.t32.setMinimumSize(this.t32.getPreferredSize());
        this.t32.setMaximumSize(this.t32.getPreferredSize());
        this.t33 = new MangoTextField("1", 6);
        this.t33.setMinimumSize(this.t33.getPreferredSize());
        this.t33.setMaximumSize(this.t33.getPreferredSize());
        JPanel tPanel3 = new JPanel();
        tPanel3.setLayout(new BoxLayout(tPanel3, 0));
        tPanel3.add(this.t30);
        tPanel3.add(this.t31);
        tPanel3.add(this.t32);
        tPanel3.add(this.t33);
        JPanel transformPanel = new JPanel();
        transformPanel.setLayout(new BoxLayout(transformPanel, 1));
        transformPanel.add(tPanel0);
        transformPanel.add(tPanel1);
        transformPanel.add(tPanel2);
        transformPanel.add(tPanel3);
        this.image = new JRadioButton("Image");
        this.image.setFocusable(false);
        this.image.addActionListener(this);
        this.image.setActionCommand("update");
        this.coordinate = new JRadioButton("World");
        this.coordinate.setFocusable(false);
        this.coordinate.addActionListener(this);
        this.coordinate.setActionCommand("update");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.image);
        bg.add(this.coordinate);
        this.image.setSelected(true);
        JButton loadFileButton = new JButton("Load From File...");
        loadFileButton.setFocusable(false);
        loadFileButton.setActionCommand("file");
        loadFileButton.addActionListener(this);
        this.centerButton = new JRadioButton("Use Image Center");
        this.centerButton.setFocusable(false);
        this.originButton = new JRadioButton("Use Image Origin");
        this.originButton.setFocusable(false);
        this.currentButton = new JRadioButton("Use Current Coordinate");
        this.currentButton.setFocusable(false);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.centerButton);
        bg2.add(this.originButton);
        bg2.add(this.currentButton);
        this.centerButton.setSelected(true);
        this.centerButton.setEnabled(false);
        this.originButton.setEnabled(false);
        this.currentButton.setEnabled(false);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        this.centerPanel.add(Box.createHorizontalGlue());
        this.centerPanel.add(this.originButton);
        this.centerPanel.add(this.centerButton);
        this.centerPanel.add(this.currentButton);
        this.centerPanel.add(Box.createHorizontalGlue());
        this.centerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Center of Rotation"));
        this.centerPanel.setEnabled(false);
        JRadioButton sameOrientBox = new JRadioButton("Same");
        sameOrientBox.addActionListener(this);
        this.diffOrientBox = new JRadioButton("Different");
        this.diffOrientBox.addActionListener(this);
        ButtonGroup bg3 = new ButtonGroup();
        bg3.add(sameOrientBox);
        bg3.add(this.diffOrientBox);
        sameOrientBox.setSelected(true);
        this.orientation1 = new MangoComboBox<String>((T[])ORIENTATION);
        this.orientation1.setActionCommand("orientation1");
        this.orientation1.addActionListener(this);
        this.orientation1.setMaximumSize(this.orientation1.getPreferredSize());
        this.orientation1.setPrototypeDisplayValue("        ");
        this.orientation2 = new MangoComboBox<String>((T[])SENSE);
        this.orientation2.setActionCommand("orientation2");
        this.orientation2.addActionListener(this);
        this.orientation2.setMaximumSize(this.orientation2.getPreferredSize());
        this.orientation2.setPrototypeDisplayValue("        ");
        this.setDefaultOrientation();
        this.selectRefButton = new JButton("Reference...");
        this.selectRefButton.addActionListener(this);
        this.fslPanel = new JPanel();
        this.fslPanel.setLayout(new BoxLayout(this.fslPanel, 0));
        this.fslPanel.add(Box.createHorizontalGlue());
        this.fslPanel.add(sameOrientBox);
        this.fslPanel.add(this.diffOrientBox);
        this.fslPanel.add(Box.createHorizontalGlue());
        this.fslPanel.add(this.selectRefButton);
        this.fslPanel.add(Box.createHorizontalGlue());
        this.fslPanel.add(this.orientation1);
        this.fslPanel.add(this.orientation2);
        this.fslPanel.add(Box.createHorizontalGlue());
        this.fslPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Reference Image Orientation"));
        this.fslPanel.setVisible(false);
        this.centerPanel.setPreferredSize(this.fslPanel.getPreferredSize());
        this.updateFSLOptions();
        JLabel typeLabel = new JLabel("Type");
        typeLabel.setFont(typeLabel.getFont().deriveFont(1));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(typeLabel);
        labelPanel.add(Box.createHorizontalGlue());
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.add(labelPanel);
        optionsPanel.add(this.image);
        optionsPanel.add(this.coordinate);
        optionsPanel.add(Box.createVerticalStrut(8));
        optionsPanel.add(loadFileButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add(optionsPanel);
        mainPanel.add(Box.createHorizontalStrut(8));
        mainPanel.add(transformPanel);
        mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Transform"));
        this.updateTransform(viewer.getVolume().getIndexTransform(0).getMatrixCopySingleInverse());
        this.setLayout(new BoxLayout(this, 1));
        this.add(mainPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(this.centerPanel);
        this.add(this.fslPanel);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        File selectedFile;
        String command = ae.getActionCommand();
        if (command.equals("file")) {
            File selectedFile2 = ViewerMenuAction.makeOpenFileChooser(CollectionUtilities.array(Transform.COMMON_EXTENSIONS), Mango.getInstance().getLoadFileDirectory(), "All Transform Files");
            if (selectedFile2 != null) {
                double[] params = Volume.readTransformFile(selectedFile2);
                if (params != null) {
                    this.updateTransform(params);
                } else {
                    this.viewer.showErrorDialog("Problem reading that transform!", "File Load Failed");
                }
            }
        } else if (command.equals("update")) {
            boolean enable = this.coordinate.isSelected();
            this.centerButton.setEnabled(enable);
            this.originButton.setEnabled(enable);
            this.currentButton.setEnabled(enable);
            this.centerPanel.setEnabled(enable);
            this.fslPanel.setVisible(false);
            this.centerPanel.setVisible(true);
        } else if (command.equals("fsl")) {
            this.fslPanel.setVisible(true);
            this.centerPanel.setVisible(false);
        } else if (command.equals("Same")) {
            this.updateFSLOptions();
            this.setDefaultOrientation();
        } else if (command.equals("Different")) {
            this.updateFSLOptions();
        } else if (command.equals("Reference...") && (selectedFile = ViewerMenuAction.makeOpenFileChooser(null, Mango.getInstance().getLoadFileDirectory(), "All Files")) != null) {
            try {
                Header header = new Header(selectedFile);
                String orientationStr = header.getOrientationString();
                this.orientation1.setSelectedItem(orientationStr.substring(0, 3));
                this.orientation2.setSelectedItem(orientationStr.substring(3));
                new Orientation(header.getOrientationString(), header.getImageDimensions(), header.getVoxelDimensions(), header.getOrigin());
                this.xSize = (double)header.getImageDimensions().getX() * header.getVoxelDimensions().getXSize();
                this.ySize = (double)header.getImageDimensions().getY() * header.getVoxelDimensions().getYSize();
                this.zSize = (double)header.getImageDimensions().getZ() * header.getVoxelDimensions().getZSize();
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    public String getReferenceOrientation() {
        return this.orientation1.getSelectedItem().toString() + this.orientation2.getSelectedItem().toString();
    }

    public double getRefX() {
        return this.xSize;
    }

    public double getRefY() {
        return this.ySize;
    }

    public double getRefZ() {
        return this.zSize;
    }

    public double[][] getTransform() {
        double[][] params = new double[4][4];
        try {
            params[0][0] = Double.parseDouble(this.t00.getText());
            params[0][1] = Double.parseDouble(this.t01.getText());
            params[0][2] = Double.parseDouble(this.t02.getText());
            params[0][3] = Double.parseDouble(this.t03.getText());
            params[1][0] = Double.parseDouble(this.t10.getText());
            params[1][1] = Double.parseDouble(this.t11.getText());
            params[1][2] = Double.parseDouble(this.t12.getText());
            params[1][3] = Double.parseDouble(this.t13.getText());
            params[2][0] = Double.parseDouble(this.t20.getText());
            params[2][1] = Double.parseDouble(this.t21.getText());
            params[2][2] = Double.parseDouble(this.t22.getText());
            params[2][3] = Double.parseDouble(this.t23.getText());
            params[3][0] = Double.parseDouble(this.t30.getText());
            params[3][1] = Double.parseDouble(this.t31.getText());
            params[3][2] = Double.parseDouble(this.t32.getText());
            params[3][3] = Double.parseDouble(this.t33.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return params;
    }

    public boolean isCoordinate() {
        return this.coordinate.isSelected();
    }

    public boolean isCurrentAsCenter() {
        return this.currentButton.isSelected();
    }

    public boolean isImage() {
        return this.image.isSelected();
    }

    public boolean isOriginAsCenter() {
        return this.originButton.isSelected();
    }

    private void setDefaultOrientation() {
        this.orientation1.setSelectedItem(this.viewer.getVolume().getOrientationString().substring(0, 3));
        this.orientation2.setSelectedItem(this.viewer.getVolume().getOrientationString().substring(3));
    }

    private void updateFSLOptions() {
        this.selectRefButton.setEnabled(this.diffOrientBox.isSelected());
        this.orientation1.setEnabled(this.diffOrientBox.isSelected());
        this.orientation2.setEnabled(this.diffOrientBox.isSelected());
    }

    private void updateTransform(double[] params) {
        this.t00.setText(String.valueOf(params[0]));
        this.t01.setText(String.valueOf(params[1]));
        this.t02.setText(String.valueOf(params[2]));
        this.t03.setText(String.valueOf(params[3]));
        this.t10.setText(String.valueOf(params[4]));
        this.t11.setText(String.valueOf(params[5]));
        this.t12.setText(String.valueOf(params[6]));
        this.t13.setText(String.valueOf(params[7]));
        this.t20.setText(String.valueOf(params[8]));
        this.t21.setText(String.valueOf(params[9]));
        this.t22.setText(String.valueOf(params[10]));
        this.t23.setText(String.valueOf(params[11]));
        this.t30.setText(String.valueOf(params[12]));
        this.t31.setText(String.valueOf(params[13]));
        this.t32.setText(String.valueOf(params[14]));
        this.t33.setText(String.valueOf(params[15]));
        this.t00.setCaretPosition(0);
        this.t01.setCaretPosition(0);
        this.t02.setCaretPosition(0);
        this.t03.setCaretPosition(0);
        this.t10.setCaretPosition(0);
        this.t11.setCaretPosition(0);
        this.t12.setCaretPosition(0);
        this.t13.setCaretPosition(0);
        this.t20.setCaretPosition(0);
        this.t21.setCaretPosition(0);
        this.t22.setCaretPosition(0);
        this.t23.setCaretPosition(0);
        this.t30.setCaretPosition(0);
        this.t31.setCaretPosition(0);
        this.t32.setCaretPosition(0);
        this.t33.setCaretPosition(0);
    }
}

