/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoPlaceholderTextField;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.commons.lang3.StringUtils;

public class AddROIDialog
extends JPanel
implements ActionListener {
    private final JRadioButton buttonCube;
    private final JRadioButton buttonSphere;
    private final MangoPlaceholderTextField labelText;
    private final MangoTextField cubeText;
    private final MangoTextField sphereText;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_CUBE_BUTTON = "ACTION_CUBE_BUTTON";
    public static final String ACTION_CUBE_TEXT = "ACTION_CUBE_TEXT";
    public static final String ACTION_SPHERE_BUTTON = "ACTION_SPHERE_BUTTON";
    public static final String ACTION_SPHERE_TEXT = "ACTION_SPHERE_TEXT";
    public static final String PLACEHOLDER_TEXT = "Enter an optional label for this ROI";
    public static final double DEFAULT_SIZE = 12.0;

    public AddROIDialog(SliceViewer viewer) {
        this.buttonCube = new JRadioButton(viewer.isMultiSliceMode() ? "Cube" : "Square");
        this.buttonCube.addActionListener(this);
        this.buttonCube.setActionCommand(ACTION_CUBE_BUTTON);
        JLabel cubeLabel = new JLabel("Width (mm) ");
        this.cubeText = new MangoTextField(String.valueOf(12.0), 4);
        this.cubeText.setMaximumSize(this.cubeText.getPreferredSize());
        this.cubeText.setMinimumSize(this.cubeText.getPreferredSize());
        this.cubeText.setActionCommand(ACTION_CUBE_TEXT);
        this.cubeText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                AddROIDialog.this.buttonCube.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        JPanel cubePanel = new JPanel();
        cubePanel.setLayout(new BoxLayout(cubePanel, 0));
        cubePanel.add(this.buttonCube);
        cubePanel.add(Box.createHorizontalGlue());
        cubePanel.add(Box.createHorizontalStrut(8));
        cubePanel.add(Box.createHorizontalGlue());
        cubePanel.add(cubeLabel);
        cubePanel.add(Box.createHorizontalGlue());
        cubePanel.add(this.cubeText);
        this.buttonSphere = new JRadioButton(viewer.isMultiSliceMode() ? "Sphere" : "Circle");
        this.buttonSphere.addActionListener(this);
        this.buttonSphere.setActionCommand(ACTION_SPHERE_BUTTON);
        JLabel sphereLabel = new JLabel("Radius (mm) ");
        this.sphereText = new MangoTextField(String.valueOf(12.0), 4);
        this.sphereText.setMaximumSize(this.sphereText.getPreferredSize());
        this.sphereText.setMinimumSize(this.sphereText.getPreferredSize());
        this.sphereText.setActionCommand(ACTION_SPHERE_TEXT);
        this.sphereText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AddROIDialog.this.buttonSphere.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        JPanel spherePanel = new JPanel();
        spherePanel.setLayout(new BoxLayout(spherePanel, 0));
        spherePanel.add(this.buttonSphere);
        spherePanel.add(Box.createHorizontalGlue());
        spherePanel.add(Box.createHorizontalStrut(8));
        spherePanel.add(Box.createHorizontalGlue());
        spherePanel.add(sphereLabel);
        spherePanel.add(Box.createHorizontalGlue());
        spherePanel.add(this.sphereText);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.buttonCube);
        bg.add(this.buttonSphere);
        this.buttonCube.setSelected(true);
        this.labelText = new MangoPlaceholderTextField(PLACEHOLDER_TEXT, 10);
        this.labelText.setMinimumSize(this.labelText.getPreferredSize());
        this.labelText.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.labelText.getPreferredSize().height));
        String currentLabel = viewer.getROIManager().getLabel(viewer.getROIManager().getCurrentROI(), null);
        if (StringUtils.isNotBlank((CharSequence)currentLabel)) {
            this.labelText.setText(currentLabel);
        }
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(this.labelText);
        labelPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 1));
        this.add(cubePanel);
        this.add(spherePanel);
        this.add(Box.createVerticalStrut(8));
        this.add(labelPanel);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_CUBE_BUTTON)) {
            this.cubeText.requestFocus();
        } else if (command.equals(ACTION_SPHERE_BUTTON)) {
            this.sphereText.requestFocus();
        }
    }

    public String getLabelText() {
        return this.labelText.getText();
    }

    public double getShapeSize() {
        try {
            if (this.isCube()) {
                return Double.parseDouble(this.cubeText.getText());
            }
            if (this.isSphere()) {
                return Double.parseDouble(this.sphereText.getText());
            }
        }
        catch (Exception ex) {
            AppLogger.warn((Throwable)ex);
        }
        return 0.0;
    }

    public boolean isCube() {
        return this.buttonCube.isSelected();
    }

    public boolean isSphere() {
        return this.buttonSphere.isSelected();
    }
}

