/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.logical.operations;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.Logical;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.operations.LogicalOpListener;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class LogicalOperations {
    private double centroid;
    private double comSum;
    private double current;
    private double max;
    private double mean;
    private double min;
    private double stdev;
    private double sum;
    private double sumSquared;
    private double weightedSumX;
    private double weightedSumY;
    private double weightedSumZ;
    private int size;
    private final LogicalOpListener listener;
    private final VolumeManager manager;
    private final int xDim;
    private final int yDim;
    private final int zDim;

    public LogicalOperations(VolumeManager viewer, LogicalOpListener listener) {
        this.manager = viewer;
        this.listener = listener;
        this.xDim = viewer.getBaseVolume().getXDim();
        this.yDim = viewer.getBaseVolume().getYDim();
        this.zDim = viewer.getBaseVolume().getZDim();
    }

    public void analyze(final Logical logical) {
        boolean isVOIMode = this.manager.isMultiSliceMode();
        int sliceStatsDirection = this.manager.getSliceDirection();
        int sliceStatsCurrentSlice = this.manager.getSliceNumber();
        final Volume volume = (Volume)this.manager.getBaseVolume();
        if (isVOIMode) {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AnalysisImpl stat = LogicalOperations.this.doAnalyze(logical, 0, volume.getXDim() - 1, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1);
                    if (LogicalOperations.this.listener != null) {
                        LogicalOperations.this.listener.logicalCalculationFinished(stat);
                    }
                }
            }, "LogicalOperations.analyze() Thread");
            workThread.start();
        } else if (sliceStatsDirection == 0) {
            this.doAnalyze(logical, 0, volume.getXDim() - 1, 0, volume.getYDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice);
        } else if (sliceStatsDirection == 1) {
            this.doAnalyze(logical, 0, volume.getXDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, volume.getZDim() - 1);
        } else if (sliceStatsDirection == 2) {
            this.doAnalyze(logical, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1);
        }
    }

    public void analyzeAll(final Vector<Logical> logicals) {
        boolean isVOIMode = this.manager.isMultiSliceMode();
        int sliceStatsDirection = this.manager.getSliceDirection();
        int sliceStatsCurrentSlice = this.manager.getSliceNumber();
        final Volume volume = (Volume)this.manager.getBaseVolume();
        if (isVOIMode) {
            Thread workThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (Logical logical : logicals) {
                        AnalysisImpl stat = LogicalOperations.this.doAnalyze(logical, 0, volume.getXDim() - 1, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1);
                        if (LogicalOperations.this.listener == null) continue;
                        LogicalOperations.this.listener.logicalCalculationFinished(stat);
                    }
                }
            }, "LogicalOperations.analyzeAll() Thread");
            workThread.start();
        } else {
            for (Logical logical : logicals) {
                AnalysisImpl stat = null;
                if (sliceStatsDirection == 0) {
                    stat = this.doAnalyze(logical, 0, volume.getXDim() - 1, 0, volume.getYDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice);
                } else if (sliceStatsDirection == 1) {
                    stat = this.doAnalyze(logical, 0, volume.getXDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, volume.getZDim() - 1);
                } else if (sliceStatsDirection == 2) {
                    stat = this.doAnalyze(logical, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1);
                }
                if (this.listener == null) continue;
                this.listener.logicalCalculationFinished(stat);
            }
        }
    }

    public void findNext(final Logical logical) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LogicalOperations.this.doFindNext(logical);
            }
        }, "LogicalOperations.findNext() Thread");
        workThread.start();
    }

    private List<ImageVolume> getOverlays() {
        List allOverlays = this.manager.getOverlays();
        HashSet overlaySet = new HashSet(allOverlays);
        allOverlays.clear();
        allOverlays.addAll(overlaySet);
        return allOverlays;
    }

    public AnalysisImpl doAnalyze(Logical logical, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        List<ImageVolume> allOverlays = this.getOverlays();
        int logicalHash = logical.hashCode();
        int numOverlaysInSet = logical.getNumOverlays();
        Coordinate maxVoxel = new Coordinate();
        Coordinate minVoxel = new Coordinate();
        Coordinate centerOfMass = new Coordinate();
        boolean notInitialized = true;
        boolean isSingleSlice = xMin == xMax || yMin == yMax || zMin == zMax;
        ProgressMeter progress = null;
        if (!isSingleSlice) {
            progress = this.manager.makeProgressMeter();
            progress.setDescription("Calculating Stats");
            progress.start(0, 0, this.zDim);
        }
        VolumeData[] volsData = new VolumeData[allOverlays.size()];
        for (int ctr = 0; ctr < allOverlays.size(); ++ctr) {
            volsData[ctr] = new VolumeData(this.manager, (Volume)allOverlays.get(ctr));
        }
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            if (progress != null) {
                progress.setValue(ctrZ);
            }
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    int overlaysHash = 0;
                    double overlaySum = 0.0;
                    for (int ctr = 0; ctr < allOverlays.size(); ++ctr) {
                        boolean logicalContains;
                        Volume volume = (Volume)allOverlays.get(ctr);
                        double value = volsData[ctr].getValue(ctrX, ctrY, ctrZ);
                        double overlayScreenMin = this.manager.getVolumeDisplayRangeMin((ImageVolume)volume);
                        boolean isNegative = this.manager.isVolumeDisplayNegative((ImageVolume)volume);
                        boolean aboveThreshold = !isNegative && value > overlayScreenMin || isNegative && value < overlayScreenMin;
                        if (aboveThreshold ^ (logicalContains = logical.contains(volume))) {
                            overlaysHash = 0;
                            break;
                        }
                        if (!aboveThreshold || !logicalContains) continue;
                        overlaySum += value;
                        overlaysHash += volume.hashCode();
                    }
                    if (logicalHash != overlaysHash) continue;
                    this.current = overlaySum / (double)numOverlaysInSet;
                    if (notInitialized) {
                        notInitialized = false;
                        this.max = this.min = this.current;
                        maxVoxel.xInt = minVoxel.xInt = ctrX;
                        maxVoxel.yInt = minVoxel.yInt = ctrY;
                        maxVoxel.zInt = minVoxel.zInt = ctrZ;
                    }
                    if (this.max < this.current) {
                        this.max = this.current;
                        maxVoxel.xInt = ctrX;
                        maxVoxel.yInt = ctrY;
                        maxVoxel.zInt = ctrZ;
                    } else if (this.min > this.current) {
                        this.min = this.current;
                        minVoxel.xInt = ctrX;
                        minVoxel.yInt = ctrY;
                        minVoxel.zInt = ctrZ;
                    }
                    double currentABS = Math.abs(this.current);
                    this.weightedSumX += currentABS * (double)ctrX;
                    this.weightedSumY += currentABS * (double)ctrY;
                    this.weightedSumZ += currentABS * (double)ctrZ;
                    this.sum += this.current;
                    this.comSum += currentABS;
                    this.sumSquared += MathUtilities.pow((double)this.current, (double)2.0);
                    ++this.size;
                }
            }
        }
        this.mean = this.sum / (double)this.size;
        this.stdev = Math.sqrt(((double)this.size * this.sumSquared - MathUtilities.pow((double)this.sum, (double)2.0)) / (double)((float)this.size * ((float)this.size - 1.0f)));
        centerOfMass.setValues(this.weightedSumX / this.comSum, this.weightedSumY / this.comSum, this.weightedSumZ / this.comSum);
        double centroidSum = 0.0;
        double value = 0.0;
        for (int ctr = 0; ctr < allOverlays.size(); ++ctr) {
            value = volsData[ctr].getValue(centerOfMass.xInt, centerOfMass.yInt, centerOfMass.zInt);
            centroidSum += value;
        }
        this.centroid = centroidSum / (double)numOverlaysInSet;
        if (progress != null) {
            progress.setValue(progress.getMax());
        }
        return this.makeAnalysis((Volume)this.manager.getBaseVolume(), minVoxel, maxVoxel, centerOfMass, logical.getColor(), logical, isSingleSlice);
    }

    private void doFindNext(Logical logical) {
        int startSlice;
        final SliceViewer viewer = (SliceViewer)this.manager;
        Coordinate foundCoordinate = null;
        Coordinate currentCoordinate = viewer.getCurrentCoordinate(null, null, null, false, true, false);
        int sliceDirection = viewer.getSliceDirection();
        ScreenVolume[] allOverlays = viewer.getOverlayManager().getAllOverlays();
        int logicalHash = logical.hashCode();
        VolumeData[] volsData = new VolumeData[allOverlays.length];
        for (int ctr = 0; ctr < allOverlays.length; ++ctr) {
            if (allOverlays[ctr] == null) continue;
            volsData[ctr] = new VolumeData(this.manager, allOverlays[ctr].getVolume());
        }
        if (sliceDirection == 0) {
            boolean logicalContains;
            boolean aboveThreshold;
            boolean isNegative;
            double overlayScreenMin;
            double value;
            Volume volume;
            ScreenVolume overlay;
            int ctr;
            int overlaysHash;
            int ctrX;
            int ctrY;
            int ctrZ;
            startSlice = currentCoordinate.zInt + 1;
            ProgressMeter progress = this.manager.makeProgressMeter();
            progress.setDescription("Searching");
            progress.start(0, 0, this.zDim);
            int progressCtr = 0;
            block1: for (ctrZ = startSlice %= this.zDim; ctrZ < this.zDim; ++ctrZ) {
                progress.setValue(progressCtr++);
                for (ctrY = 0; ctrY < this.yDim; ++ctrY) {
                    for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        overlaysHash = 0;
                        for (ctr = 0; ctr < allOverlays.length; ++ctr) {
                            overlay = allOverlays[ctr];
                            if (overlay == null) continue;
                            volume = overlay.getVolume();
                            value = volsData[ctr].getValue(ctrX, ctrY, ctrZ);
                            overlayScreenMin = overlay.getScreenMin();
                            isNegative = overlay.isNegative();
                            aboveThreshold = !isNegative && value > overlayScreenMin || isNegative && value < overlayScreenMin;
                            if (aboveThreshold ^ (logicalContains = logical.contains(volume))) {
                                overlaysHash = 0;
                                break;
                            }
                            if (!aboveThreshold || !logicalContains) continue;
                            overlaysHash += volume.hashCode();
                        }
                        if (logicalHash != overlaysHash) continue;
                        foundCoordinate = new Coordinate((double)ctrX, (double)ctrY, (double)ctrZ);
                        break block1;
                    }
                }
            }
            if (foundCoordinate == null) {
                block5: for (ctrZ = 0; ctrZ < startSlice; ++ctrZ) {
                    progress.setValue(progressCtr++);
                    for (ctrY = 0; ctrY < this.yDim; ++ctrY) {
                        for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                            overlaysHash = 0;
                            for (ctr = 0; ctr < allOverlays.length; ++ctr) {
                                overlay = allOverlays[ctr];
                                if (overlay == null) continue;
                                volume = overlay.getVolume();
                                value = volsData[ctr].getValue(ctrX, ctrY, ctrZ);
                                overlayScreenMin = overlay.getScreenMin();
                                isNegative = overlay.isNegative();
                                aboveThreshold = !isNegative && value > overlayScreenMin || isNegative && value < overlayScreenMin;
                                if (aboveThreshold ^ (logicalContains = logical.contains(volume))) {
                                    overlaysHash = 0;
                                    break;
                                }
                                if (!aboveThreshold || !logicalContains) continue;
                                overlaysHash += volume.hashCode();
                            }
                            if (logicalHash != overlaysHash) continue;
                            foundCoordinate = new Coordinate((double)ctrX, (double)ctrY, (double)ctrZ);
                            break block5;
                        }
                    }
                }
            }
            progress.setValue(progress.getMax());
        } else if (sliceDirection == 1) {
            boolean logicalContains;
            boolean aboveThreshold;
            boolean isNegative;
            double overlayScreenMin;
            double value;
            Volume volume;
            ScreenVolume overlay;
            int ctr;
            int overlaysHash;
            int ctrX;
            int ctrZ;
            int ctrY;
            startSlice = currentCoordinate.yInt + 1;
            ProgressMeter progress = this.manager.makeProgressMeter();
            progress.setDescription("Searching");
            progress.start(0, 0, this.yDim);
            int progressCtr = 0;
            block9: for (ctrY = startSlice %= this.yDim; ctrY < this.yDim; ++ctrY) {
                progress.setValue(progressCtr++);
                for (ctrZ = 0; ctrZ < this.zDim; ++ctrZ) {
                    for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                        overlaysHash = 0;
                        for (ctr = 0; ctr < allOverlays.length; ++ctr) {
                            overlay = allOverlays[ctr];
                            if (overlay == null) continue;
                            volume = overlay.getVolume();
                            value = volsData[ctr].getValue(ctrX, ctrY, ctrZ);
                            overlayScreenMin = overlay.getScreenMin();
                            isNegative = overlay.isNegative();
                            aboveThreshold = !isNegative && value > overlayScreenMin || isNegative && value < overlayScreenMin;
                            if (aboveThreshold ^ (logicalContains = logical.contains(volume))) {
                                overlaysHash = 0;
                                break;
                            }
                            if (!aboveThreshold || !logicalContains) continue;
                            overlaysHash += volume.hashCode();
                        }
                        if (logicalHash != overlaysHash) continue;
                        foundCoordinate = new Coordinate((double)ctrX, (double)ctrY, (double)ctrZ);
                        break block9;
                    }
                }
            }
            if (foundCoordinate == null) {
                block13: for (ctrY = 0; ctrY < startSlice; ++ctrY) {
                    progress.setValue(progressCtr++);
                    for (ctrZ = 0; ctrZ < this.zDim; ++ctrZ) {
                        for (ctrX = 0; ctrX < this.xDim; ++ctrX) {
                            overlaysHash = 0;
                            for (ctr = 0; ctr < allOverlays.length; ++ctr) {
                                overlay = allOverlays[ctr];
                                if (overlay == null) continue;
                                volume = overlay.getVolume();
                                value = volsData[ctr].getValue(ctrX, ctrY, ctrZ);
                                overlayScreenMin = overlay.getScreenMin();
                                isNegative = overlay.isNegative();
                                aboveThreshold = !isNegative && value > overlayScreenMin || isNegative && value < overlayScreenMin;
                                if (aboveThreshold ^ (logicalContains = logical.contains(volume))) {
                                    overlaysHash = 0;
                                    break;
                                }
                                if (!aboveThreshold || !logicalContains) continue;
                                overlaysHash += volume.hashCode();
                            }
                            if (logicalHash != overlaysHash) continue;
                            foundCoordinate = new Coordinate((double)ctrX, (double)ctrY, (double)ctrZ);
                            break block13;
                        }
                    }
                }
            }
            progress.setValue(progress.getMax());
        } else if (sliceDirection == 2) {
            boolean logicalContains;
            boolean aboveThreshold;
            boolean isNegative;
            double overlayScreenMin;
            double value;
            Volume volume;
            ScreenVolume overlay;
            int ctr;
            int overlaysHash;
            int ctrY;
            int ctrZ;
            int ctrX;
            startSlice = currentCoordinate.xInt + 1;
            ProgressMeter progress = this.manager.makeProgressMeter();
            progress.setDescription("Searching");
            progress.start(0, 0, this.xDim);
            int progressCtr = 0;
            block17: for (ctrX = startSlice %= this.xDim; ctrX < this.xDim; ++ctrX) {
                progress.setValue(progressCtr++);
                for (ctrZ = 0; ctrZ < this.zDim; ++ctrZ) {
                    for (ctrY = 0; ctrY < this.yDim; ++ctrY) {
                        overlaysHash = 0;
                        for (ctr = 0; ctr < allOverlays.length; ++ctr) {
                            overlay = allOverlays[ctr];
                            if (overlay == null) continue;
                            volume = overlay.getVolume();
                            value = volsData[ctr].getValue(ctrX, ctrY, ctrZ);
                            overlayScreenMin = overlay.getScreenMin();
                            isNegative = overlay.isNegative();
                            aboveThreshold = !isNegative && value > overlayScreenMin || isNegative && value < overlayScreenMin;
                            if (aboveThreshold ^ (logicalContains = logical.contains(volume))) {
                                overlaysHash = 0;
                                break;
                            }
                            if (!aboveThreshold || !logicalContains) continue;
                            overlaysHash += volume.hashCode();
                        }
                        if (logicalHash != overlaysHash) continue;
                        foundCoordinate = new Coordinate((double)ctrX, (double)ctrY, (double)ctrZ);
                        break block17;
                    }
                }
            }
            if (foundCoordinate == null) {
                block21: for (ctrX = 0; ctrX < startSlice; ++ctrX) {
                    progress.setValue(progressCtr++);
                    for (ctrZ = 0; ctrZ < this.zDim; ++ctrZ) {
                        for (ctrY = 0; ctrY < this.yDim; ++ctrY) {
                            overlaysHash = 0;
                            for (ctr = 0; ctr < allOverlays.length; ++ctr) {
                                overlay = allOverlays[ctr];
                                if (overlay == null) continue;
                                volume = overlay.getVolume();
                                value = volsData[ctr].getValue(ctrX, ctrY, ctrZ);
                                overlayScreenMin = overlay.getScreenMin();
                                isNegative = overlay.isNegative();
                                aboveThreshold = !isNegative && value > overlayScreenMin || isNegative && value < overlayScreenMin;
                                if (aboveThreshold ^ (logicalContains = logical.contains(volume))) {
                                    overlaysHash = 0;
                                    break;
                                }
                                if (!aboveThreshold || !logicalContains) continue;
                                overlaysHash += volume.hashCode();
                            }
                            if (logicalHash != overlaysHash) continue;
                            foundCoordinate = new Coordinate((double)ctrX, (double)ctrY, (double)ctrZ);
                            break block21;
                        }
                    }
                }
            }
            progress.setValue(progress.getMax());
        }
        final Coordinate foundCoordinateF = foundCoordinate;
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (foundCoordinateF != null) {
                    viewer.setCurrentCoordinate(foundCoordinateF, true, -1);
                } else {
                    viewer.showWarningDialog("This logical combination was not found! ", "Logical Warning");
                }
            }
        });
    }

    private AnalysisImpl makeAnalysis(Volume referenceVol, Coordinate minVoxel, Coordinate maxVoxel, Coordinate centerOfMass, Color color, Logical logical, boolean isSingleSlice) {
        AnalysisImpl analysis = new AnalysisImpl(this.mean, this.min, this.max, this.sum, this.stdev, this.size);
        analysis.setMinCoordinate(new Coordinate4D((double)minVoxel.xInt, (double)minVoxel.yInt, (double)minVoxel.zInt, 0));
        analysis.setMaxCoordinate(new Coordinate4D((double)maxVoxel.xInt, (double)maxVoxel.yInt, (double)maxVoxel.zInt, 0));
        analysis.setCentroidCoordinate(new Coordinate4D((double)centerOfMass.xInt, (double)centerOfMass.yInt, (double)centerOfMass.zInt, 0));
        analysis.setCentroid(this.centroid);
        analysis.setUnitSize(referenceVol.getVoxelVolume());
        analysis.setType(6);
        analysis.setColor(color);
        analysis.setDescription("Logical " + (isSingleSlice ? "Slice" : "Volume"));
        Volume[] vols = logical.getOverlaySetArray();
        analysis.setName(vols.length > 1 ? "Multiple" : vols[0].toString());
        return analysis;
    }
}

