/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.logical;

import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.Logical;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalAnalysisTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalPanel;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.TransferHandler;

public class LogicalTransferHandler
extends TransferHandler
implements Transferable {
    private Image image;
    private final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
    private final LogicalAnalysisTool logicalManager;
    private static final long serialVersionUID = 1L;

    protected LogicalTransferHandler(LogicalAnalysisTool lm) {
        this.logicalManager = lm;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        if (!(comp instanceof LogicalPanel)) {
            return false;
        }
        for (DataFlavor element : flavor) {
            for (DataFlavor flavor2 : this.flavors) {
                if (!element.equals(flavor2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Transferable createTransferable(JComponent comp) {
        JLabel label;
        Icon icon;
        this.image = null;
        if (comp instanceof JLabel && (icon = (label = (JLabel)comp).getIcon()) instanceof ImageIcon) {
            this.image = ((ImageIcon)icon).getImage();
            return this;
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        if (this.isDataFlavorSupported(flavor)) {
            return this.image;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (comp instanceof LogicalPanel) {
            LogicalPanel panel = (LogicalPanel)comp;
            if (t.isDataFlavorSupported(this.flavors[0])) {
                Logical logical = panel.getLogical();
                logical.clearRGBFlags();
                ScreenVolume sv = this.logicalManager.getViewer().getOverlayManager().getOverlay(this.logicalManager.getDraggingIndex());
                logical.addOverlay(sv.getVolume());
                logical.setColor(logical.deriveBestColor());
                panel.updateDisplay();
                if (!this.logicalManager.hasEmptyLogical()) {
                    this.logicalManager.addLogicalPanel();
                }
                this.logicalManager.updateAllLogicals();
                this.logicalManager.getViewer().getToolBox().updateSlider();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavors[0].equals(flavor);
    }
}

