/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.logical;

import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.Logical;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalListener;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.volume.Volume;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Date;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class LogicalPanel
extends JPanel
implements ActionListener,
PopupMenuListener {
    private JButton optionsButton;
    private JColorChooser colorChooser;
    private JPanel colorSwatchPanel;
    private JPanel colorSwatchPanelOut;
    private Logical logical;
    private long popupTimeCanceled;
    private final SliceViewer viewer;
    private final BufferedImage[] overlayImagesFiltered;
    private final BufferedImage[] overlayImages;
    private final ImageIcon[] overlayImageIcons;
    private final JMenuItem hideItem;
    private final JPopupMenu popup;
    private final LogicalListener listener;
    private final int[][] overlayData;
    private static final long serialVersionUID = 1L;
    public static final Color ACTIVE_BACKGROUND = new Color(200, 200, 200);
    public static final Color HIDDEN_BACKGROUND = new Color(175, 175, 175);
    public static final String ACTION_FIND = "Find next region";
    public static final String ACTION_REMOVE = "Remove this logical";
    public static final String ACTION_ROI = "Create ROI of region";
    public static final String ACTION_STATS = "Create stats of region";
    public static final int HEIGHT = 50;
    public static final int ICON_SIZE = 30;
    public static final int SWATCH_SIZE = 26;

    protected LogicalPanel(SliceViewer viewer, TransferHandler th, LogicalListener aListener) {
        this.listener = aListener;
        this.logical = new Logical(viewer);
        this.viewer = viewer;
        this.overlayImages = new BufferedImage[8];
        this.overlayImagesFiltered = new BufferedImage[8];
        this.overlayData = new int[8][];
        this.overlayImageIcons = new ImageIcon[8];
        for (int ctr = 0; ctr < 8; ++ctr) {
            this.overlayImages[ctr] = new BufferedImage(30, 30, 2);
            this.overlayImagesFiltered[ctr] = new BufferedImage(30, 30, 2);
            this.overlayData[ctr] = ((DataBufferInt)this.overlayImages[ctr].getRaster().getDataBuffer()).getData();
            this.overlayImageIcons[ctr] = new ImageIcon(this.overlayImagesFiltered[ctr]);
        }
        this.initializeOverlayImageLUTImages();
        JLabel label = new JLabel("Drop overlays here...");
        label.setFont(label.getFont().deriveFont(2));
        this.popup = new JPopupMenu();
        this.popup.addPopupMenuListener(this);
        JMenuItem findItem = new JMenuItem(ACTION_FIND);
        findItem.addActionListener(this);
        this.popup.add(findItem);
        JMenuItem analyzeItem = new JMenuItem(ACTION_STATS);
        analyzeItem.addActionListener(this);
        this.popup.add(analyzeItem);
        JMenuItem roiItem = new JMenuItem(ACTION_ROI);
        roiItem.addActionListener(this);
        this.popup.add(roiItem);
        this.hideItem = new JMenuItem();
        this.popup.add(new JToolBar.Separator(new Dimension(0, 8)));
        JMenuItem removeItem = new JMenuItem(ACTION_REMOVE);
        removeItem.addActionListener(this);
        this.popup.add(removeItem);
        this.setBackground(ACTIVE_BACKGROUND);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalGlue());
        this.add(label);
        this.add(Box.createHorizontalGlue());
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setPreferredSize(new Dimension(340, 50));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setTransferHandler(th);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("OK")) {
            this.logical.setColor(this.colorChooser.getColor());
            this.colorSwatchPanel.repaint();
            this.listener.logicalColorChanged(this.logical);
        } else if (actionCommand.equals("show popup")) {
            this.showPopup();
        } else if (actionCommand.equals(ACTION_REMOVE)) {
            this.listener.setRemoving(true);
            this.listener.logicalRemoved(this.logical);
            this.listener.updateAllLogicals();
            this.listener.setRemoving(false);
        } else if (actionCommand.equals("Disable") || actionCommand.equals("Enable")) {
            this.logical.setHidden(!this.logical.isHidden());
            if (this.logical.isHidden()) {
                this.hideItem.setText("Enable");
                this.setBackground(HIDDEN_BACKGROUND);
            } else {
                this.hideItem.setText("Disable");
                this.setBackground(ACTIVE_BACKGROUND);
            }
            this.listener.updateAllLogicals();
        } else if (actionCommand.equals(ACTION_FIND)) {
            this.listener.findLogical(this.logical);
        } else if (actionCommand.equals(ACTION_STATS)) {
            this.listener.analyzeLogical(this.logical);
        } else if (actionCommand.equals(ACTION_ROI)) {
            this.listener.createROILogical(this.logical);
        }
    }

    public Logical getLogical() {
        return this.logical;
    }

    public JButton getOptionsButton() {
        return this.optionsButton;
    }

    public boolean isEmptyLogical() {
        return this.logical.getNumOverlays() == 0;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popup) {
            this.popupTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    public void setLogical(Logical aLogical) {
        this.logical = aLogical;
    }

    public void setOptionsButton(JButton optionsButton) {
        this.optionsButton = optionsButton;
        optionsButton.setEnabled(this.logical.getNumOverlays() > 0);
    }

    protected boolean contains(Volume sv) {
        return this.logical.contains(sv);
    }

    protected boolean hasActiveLogical() {
        return this.logical.getNumOverlays() > 0;
    }

    protected void updateDisplay() {
        this.updateOverlayButtonIcons();
        this.removeAll();
        JLabel label = new JLabel(" = ");
        label.setFont(label.getFont().deriveFont(20.0f).deriveFont(1));
        this.colorSwatchPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(LogicalPanel.this.logical.getColor().getRed(), LogicalPanel.this.logical.getColor().getGreen(), LogicalPanel.this.logical.getColor().getBlue()));
                g.fillRect(0, 0, 26, 26);
            }
        };
        this.colorSwatchPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.colorSwatchPanel.setPreferredSize(new Dimension(26, 26));
        this.colorSwatchPanel.setMaximumSize(this.colorSwatchPanel.getPreferredSize());
        this.colorSwatchPanel.setMinimumSize(this.colorSwatchPanel.getPreferredSize());
        this.colorSwatchPanelOut = new JPanel(new BorderLayout());
        this.colorSwatchPanelOut.add((Component)this.colorSwatchPanel, "Center");
        this.colorSwatchPanelOut.setBorder(BorderFactory.createEtchedBorder());
        this.colorSwatchPanelOut.setPreferredSize(new Dimension(31, 31));
        this.colorSwatchPanelOut.setMaximumSize(this.colorSwatchPanelOut.getPreferredSize());
        this.colorSwatchPanelOut.setMinimumSize(this.colorSwatchPanelOut.getPreferredSize());
        this.colorSwatchPanelOut.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                LogicalPanel.this.colorSwatchPanelOut.setBorder(BorderFactory.createLoweredBevelBorder());
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                LogicalPanel.this.colorSwatchPanelOut.setBorder(BorderFactory.createEtchedBorder());
                LogicalPanel.this.showColorChooser();
            }
        });
        this.add(Box.createHorizontalStrut(6));
        this.add(Box.createHorizontalGlue());
        JLabel startLabel = new JLabel("{ ");
        startLabel.setFont(startLabel.getFont().deriveFont(20.0f).deriveFont(1));
        this.add(startLabel);
        Iterator<Volume> it = this.logical.getIterator();
        int index = 0;
        while (it.hasNext()) {
            if (index != 0) {
                this.add(Box.createHorizontalStrut(4));
            }
            Volume sv = it.next();
            JLabel logicalLabel = new JLabel(this.overlayImageIcons[index]);
            logicalLabel.setToolTipText(sv.toString());
            this.add(logicalLabel);
            ++index;
        }
        JLabel endLabel = new JLabel(" }");
        endLabel.setFont(endLabel.getFont().deriveFont(20.0f).deriveFont(1));
        this.add(endLabel);
        this.add(Box.createHorizontalGlue());
        this.add(label);
        this.add(this.colorSwatchPanelOut);
        this.add(Box.createHorizontalStrut(6));
        this.optionsButton.setEnabled(this.logical.getNumOverlays() > 0);
        this.validate();
        this.repaint();
    }

    protected void updateHideButton() {
        if (this.logical.isHidden()) {
            this.hideItem.setText("Enable");
            this.setBackground(HIDDEN_BACKGROUND);
        } else {
            this.hideItem.setText("Disable");
            this.setBackground(ACTIVE_BACKGROUND);
        }
    }

    private void initializeOverlayImageLUTImages() {
        double ratio = 8.5;
        int value = 0;
        for (int ctrOvly = 0; ctrOvly < 8; ++ctrOvly) {
            for (int ctr = 0; ctr < 30; ++ctr) {
                for (int ctrIn = 0; ctrIn < 30; ++ctrIn) {
                    value = (int)(8.5 * (double)ctrIn + 0.5);
                    this.overlayData[ctrOvly][ctr * 30 + ctrIn] = value | value << 8 | value << 16 | value << 24;
                }
            }
        }
    }

    private void showColorChooser() {
        this.colorChooser = new JColorChooser(this.logical.getColor());
        JDialog dialog = JColorChooser.createDialog(this, "Colors", true, this.colorChooser, this, this);
        dialog.setVisible(true);
    }

    private void showPopup() {
        long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
        if (timeSinceCancel > 250L) {
            this.popup.show(this.optionsButton, this.optionsButton.getPreferredSize().width, 0);
        }
    }

    private void updateOverlayButtonIcons() {
        this.updateOverlayImageIconLUTImages();
        for (int ctr = 0; ctr < 8; ++ctr) {
            this.overlayImageIcons[ctr] = new ImageIcon(this.overlayImagesFiltered[ctr]);
        }
    }

    private void updateOverlayImageIconLUTImages() {
        Iterator<Volume> it = this.logical.getIterator();
        int index = 0;
        while (it.hasNext()) {
            ScreenVolume sv = this.viewer.findOverlay(it.next());
            sv.getLookupTableManager().getOp().filter(this.overlayImages[index], this.overlayImagesFiltered[index]);
            ++index;
        }
    }
}

