/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.logical;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.Logical;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalListener;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.LogicalTransferHandler;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.operations.LogicalOperations;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayListener;
import edu.uthscsa.ric.mango.viewerslice.screen.OverlayManagerListener;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.utilities.CombinationGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;

public final class LogicalAnalysisTool
extends JFrame
implements ViewerAssociated,
LogicalListener,
OverlayManagerListener,
OverlayListener,
ActionListener {
    private Dimension startSize;
    private Logical[] allLogicals;
    private boolean hasBeenDisplayed;
    private boolean isGeneratingAll;
    private boolean isRemoving;
    private boolean preventProcessOnOpen;
    private int draggingIndex;
    private int numOverlays;
    private final BufferedImage[] overlayImagesFiltered;
    private final BufferedImage[] overlayImages;
    private final ImageIcon[] overlayImageIcons;
    private final JButton hideAllButton;
    private final JPanel buttonPanel;
    private final JPanel mainLogicalPanel;
    private final JScrollPane scroller;
    private final Mango mango;
    private final SliceViewer viewer;
    private final Vector<LogicalPanel> logicalPanels = new Vector();
    private final int[][] overlayData;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Create Logicals";
    public static final int GAP = 2;
    public static final int ICON_SIZE = 30;
    public static final int NUM_MAX_DISPLAY_PORT = 5;
    public static final int RESET_HEIGHT = 450;
    public static final int WIDTH = 375;
    public static final String ACTION_DISABLE_ALL = "Disable All";

    public LogicalAnalysisTool(Mango mango, SliceViewer viewer) {
        this.mango = mango;
        this.viewer = viewer;
        viewer.getOverlayManager().addListener(this);
        this.overlayImages = new BufferedImage[8];
        this.overlayImagesFiltered = new BufferedImage[8];
        this.overlayData = new int[8][];
        this.overlayImageIcons = new ImageIcon[8];
        for (int ctr = 0; ctr < 8; ++ctr) {
            this.overlayImages[ctr] = new BufferedImage(30, 30, 2);
            this.overlayImagesFiltered[ctr] = new BufferedImage(30, 30, 2);
            this.overlayData[ctr] = ((DataBufferInt)this.overlayImages[ctr].getRaster().getDataBuffer()).getData();
            this.overlayImageIcons[ctr] = new ImageIcon(this.overlayImagesFiltered[ctr]);
        }
        this.initializeOverlayImageLUTImages();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setPreferredSize(new Dimension(375, 70));
        this.buttonPanel.setMinimumSize(this.buttonPanel.getPreferredSize());
        this.buttonPanel.setMaximumSize(this.buttonPanel.getPreferredSize());
        this.buttonPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Drag and drop to create a logical overlay"));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JButton addAllButton = new JButton("Generate All");
        addAllButton.addActionListener(this);
        addAllButton.setFocusable(false);
        this.hideAllButton = new JButton(ACTION_DISABLE_ALL);
        this.hideAllButton.addActionListener(this);
        this.hideAllButton.setFocusable(false);
        JButton clearAllButton = new JButton("Remove All");
        clearAllButton.addActionListener(this);
        clearAllButton.setFocusable(false);
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(addAllButton);
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(clearAllButton);
        controlPanel.add(Box.createHorizontalGlue());
        this.mainLogicalPanel = new JPanel();
        this.mainLogicalPanel.setLayout(new BoxLayout(this.mainLogicalPanel, 1));
        this.scroller = new JScrollPane(this.mainLogicalPanel);
        this.scroller.setBorder(null);
        this.scroller.setMaximumSize(new Dimension(375, 52));
        this.scroller.setMinimumSize(new Dimension(375, 52));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.buttonPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(this.scroller);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(controlPanel);
        JPanel mainPanelOut = new JPanel(new BorderLayout());
        mainPanelOut.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanelOut.add((Component)mainPanel, "Center");
        this.setTitle("Create Logicals: " + viewer.getImageTitle());
        this.setBackground(mango.getPanelOutsideColor());
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setVisible(false);
        this.addLogicalPanel();
        this.updateLogicals();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent we) {
                LogicalAnalysisTool.this.repaint();
            }
        });
        this.getContentPane().add((Component)mainPanelOut, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("Remove All")) {
            this.removeAllLogicals();
        } else if (command.equals("Generate All")) {
            this.generateAllLogicals();
        } else if (command.equals(ACTION_DISABLE_ALL)) {
            this.disableAllLogicals();
        } else if (command.equals("Enable All")) {
            this.enableAllLogicals();
        }
    }

    public boolean allLogicalHidden() {
        for (int ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            LogicalPanel lp = this.logicalPanels.get(ctr);
            if (lp.getLogical().getNumOverlays() <= 0 || lp.getLogical().isHidden()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void analyzeLogical(Logical log) {
        LogicalOperations ops = new LogicalOperations(this.viewer, this.viewer);
        ops.analyze(log);
    }

    @Override
    public void createROILogical(Logical log) {
        this.viewer.recordAction("runGenerateLogicalROI", new String[]{null}, true);
        if (this.viewer.isMultiSliceMode()) {
            this.viewer.getROIManager().makeLogicalROI(log);
        } else {
            this.viewer.getROIManager().makeLogicalROI(log, this.viewer.getMainSliceNumber(), this.viewer.getMainSliceDirection());
        }
    }

    @Override
    public void findLogical(Logical log) {
        LogicalOperations ops = new LogicalOperations(this.viewer, this.viewer);
        ops.findNext(log);
    }

    public int getColorOfVoxel(int hash) {
        int color = 0;
        if (this.allLogicals != null) {
            for (Logical log : this.allLogicals) {
                if (log.hashCode() != hash) continue;
                color = log.isHidden() ? 0 : log.getColor().getRGB();
            }
        }
        return color;
    }

    @Override
    public String getDescription() {
        return NAME;
    }

    public int getDraggingIndex() {
        return this.draggingIndex;
    }

    public Vector<LogicalPanel> getLogicalPanels() {
        return this.logicalPanels;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    public boolean hasLogicals() {
        for (int ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            if (this.logicalPanels.get(ctr).isEmptyLogical()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void logicalColorChanged(Logical log) {
        this.viewer.updateScreenSlices();
    }

    @Override
    public void logicalRemoved(Logical log) {
        int foundIndex = -1;
        for (int ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            if (this.logicalPanels.get(ctr).getLogical() != log) continue;
            foundIndex = ctr;
        }
        if (foundIndex != -1) {
            this.logicalPanels.remove(foundIndex);
            this.updateLogicals();
            this.viewer.updateScreenSlices();
            this.viewer.getToolBox().updateSlider();
        }
    }

    @Override
    public void overlayAdded(ScreenVolume vol) {
        this.updateOverlayButtons();
    }

    @Override
    public void overlayChanged(Object overlay, boolean overlaySelected) {
    }

    @Override
    public void overlayRemoved(Object overlay) {
        int ctr;
        Vector<LogicalPanel> panelsToRemove = new Vector<LogicalPanel>();
        for (ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            LogicalPanel lp = this.logicalPanels.get(ctr);
            if (!lp.contains(((ScreenVolume)overlay).getVolume())) continue;
            panelsToRemove.add(lp);
        }
        for (ctr = 0; ctr < panelsToRemove.size(); ++ctr) {
            this.logicalPanels.remove(panelsToRemove.get(ctr));
        }
        this.updateLogicals();
    }

    @Override
    public void overlayRemoved(ScreenVolume vol) {
        this.overlayRemoved((Object)vol);
    }

    public void setAsBlue(ScreenVolume sv) {
        this.setAsRGB(sv, 2);
    }

    public void setAsGreen(ScreenVolume sv) {
        this.setAsRGB(sv, 1);
    }

    public void setAsRed(ScreenVolume sv) {
        this.setAsRGB(sv, 0);
    }

    public void setPreventProcessOnOpen(boolean bool) {
        this.preventProcessOnOpen = bool;
    }

    @Override
    public void setRemoving(boolean bool) {
        this.isRemoving = bool;
        if (!this.isRemoving) {
            if (this.logicalPanels.size() <= 5) {
                this.updateLogicalPanels();
            } else if (!this.resetSize()) {
                this.updateLogicalPanels();
            }
        }
    }

    @Override
    public void setVisible(boolean bool) {
        if (this.viewer.isClosing()) {
            super.setVisible(bool);
        } else {
            if (bool) {
                if (!this.hasBeenDisplayed) {
                    this.setLocation(DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), this.getSize(), null, this.mango.isApplet()));
                    this.hasBeenDisplayed = true;
                }
                this.enableAllLogicals();
                this.updateLogicals();
            } else {
                this.disableAllLogicals();
            }
            super.setVisible(bool);
            if (bool) {
                if (this.startSize == null) {
                    this.startSize = this.getSize();
                }
                if (!this.preventProcessOnOpen) {
                    this.updateLogicalManager();
                } else {
                    this.preventProcessOnOpen = false;
                }
            }
        }
    }

    @Override
    public void updateAllLogicals() {
        this.viewer.forceImageUpdate();
        this.viewer.updateScreenSlices();
        this.viewer.updateSurface();
        this.viewer.updateSurfaceColors();
        this.viewer.repaint();
        this.updateHideButton();
    }

    public void updateLogicals() {
        if (!this.viewer.isClosing()) {
            this.updateOverlayButtons();
            this.updateLogicalPanels();
        }
    }

    protected LogicalPanel addLogicalPanel() {
        LogicalPanel logicalPanel = new LogicalPanel(this.viewer, new LogicalTransferHandler(this), this);
        JButton optionsButton = new JButton(MangoStyle.ICON_OPTIONS);
        optionsButton.setActionCommand("show popup");
        optionsButton.addActionListener(logicalPanel);
        logicalPanel.setOptionsButton(optionsButton);
        this.logicalPanels.add(logicalPanel);
        this.updateLogicalPanels();
        this.updateHideButton();
        return logicalPanel;
    }

    protected boolean hasEmptyLogical() {
        for (int ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            if (!this.logicalPanels.get(ctr).isEmptyLogical()) continue;
            return true;
        }
        return false;
    }

    private void analyzeAllLogicalCombos() {
        this.viewer.recordAction("runLogicalAnalysis", new String[]{null}, true);
        Vector<Logical> logicalsToAnalyze = new Vector<Logical>();
        for (LogicalPanel lp : this.logicalPanels) {
            if (lp.getLogical().getNumOverlays() <= 1) continue;
            logicalsToAnalyze.add(lp.getLogical());
        }
        LogicalOperations ops = new LogicalOperations(this.viewer, this.viewer);
        ops.analyzeAll(logicalsToAnalyze);
    }

    private void clearOverlayLogicalFlags() {
        List<ScreenVolume> allOverlays = this.getAllOverlays();
        for (ScreenVolume allOverlay : allOverlays) {
            if (allOverlay == null) continue;
            allOverlay.setLogical(false);
        }
    }

    private void disableAllLogicals() {
        for (int ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            LogicalPanel lp = this.logicalPanels.get(ctr);
            lp.getLogical().setHidden(true);
            this.hideAllButton.setText("Enable All");
            lp.updateHideButton();
        }
        this.updateAllLogicals();
    }

    private void enableAllLogicals() {
        for (int ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            LogicalPanel lp = this.logicalPanels.get(ctr);
            lp.getLogical().setHidden(false);
            this.hideAllButton.setText(ACTION_DISABLE_ALL);
            lp.updateHideButton();
        }
        this.updateAllLogicals();
    }

    private List<ScreenVolume> getAllOverlays() {
        ScreenVolume[] allOverlaysNulls = this.viewer.getOverlayManager().getAllOverlays();
        ArrayList<ScreenVolume> allOverlays = new ArrayList<ScreenVolume>();
        for (int ctr = 0; ctr < this.numOverlays; ++ctr) {
            if (allOverlaysNulls[ctr] == null || allOverlaysNulls[ctr].isParametric() && allOverlaysNulls[ctr].isNegative()) continue;
            allOverlays.add(allOverlaysNulls[ctr]);
        }
        return allOverlays;
    }

    private void generateAll() {
        int numOverlays = this.viewer.getOverlayManager().getNumInStack();
        if (numOverlays > 0) {
            boolean numCombiniationElements = true;
            List<ScreenVolume> allOverlays = this.getAllOverlays();
            for (int ctrC = 1; ctrC <= allOverlays.size(); ++ctrC) {
                CombinationGenerator cg = new CombinationGenerator(allOverlays.size(), ctrC);
                while (cg.hasMore()) {
                    int[] indices = cg.getNext();
                    LogicalPanel lp = this.addLogicalPanel();
                    Logical logical = lp.getLogical();
                    for (int indice : indices) {
                        logical.addOverlay(allOverlays.get(indice).getVolume());
                    }
                    logical.setColor(logical.deriveBestColor());
                    lp.updateDisplay();
                }
            }
        }
        if (!this.hasEmptyLogical()) {
            this.addLogicalPanel();
        }
    }

    private void generateAllLogicals() {
        this.isGeneratingAll = true;
        this.logicalPanels.removeAllElements();
        this.generateAll();
        this.updateAllLogicals();
        this.analyzeAllLogicalCombos();
        this.viewer.getToolBox().updateSlider();
        this.setSize(this.getSize().width, 500);
        this.resetSize();
        this.isGeneratingAll = false;
    }

    private void initializeOverlayImageLUTImages() {
        double ratio = 8.5;
        int value = 0;
        for (int ctrOvly = 0; ctrOvly < 8; ++ctrOvly) {
            for (int ctr = 0; ctr < 30; ++ctr) {
                for (int ctrIn = 0; ctrIn < 30; ++ctrIn) {
                    value = (int)(8.5 * (double)ctrIn + 0.5);
                    this.overlayData[ctrOvly][ctr * 30 + ctrIn] = value | value << 8 | value << 16 | value << 24;
                }
            }
        }
    }

    private void makeRGBIntersections() {
        Logical logical;
        int ctr;
        Vector<LogicalPanel> panelsToRemove = new Vector<LogicalPanel>();
        for (ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            LogicalPanel lp = this.logicalPanels.get(ctr);
            if (!lp.getLogical().isCYMW()) continue;
            panelsToRemove.add(lp);
        }
        for (ctr = 0; ctr < panelsToRemove.size(); ++ctr) {
            this.logicalPanels.remove(panelsToRemove.get(ctr));
        }
        LogicalPanel redPanel = null;
        LogicalPanel greenPanel = null;
        LogicalPanel bluePanel = null;
        for (int ctr2 = 0; ctr2 < this.logicalPanels.size(); ++ctr2) {
            LogicalPanel lp = this.logicalPanels.get(ctr2);
            if (lp.getLogical().isRed()) {
                redPanel = lp;
                continue;
            }
            if (lp.getLogical().isGreen()) {
                greenPanel = lp;
                continue;
            }
            if (!lp.getLogical().isBlue()) continue;
            bluePanel = lp;
        }
        if (redPanel != null && greenPanel != null) {
            LogicalPanel lp = this.addLogicalPanel();
            logical = lp.getLogical();
            logical.setAsYellow();
            logical.addOverlay(redPanel.getLogical().getIterator().next());
            logical.addOverlay(greenPanel.getLogical().getIterator().next());
            lp.updateDisplay();
        }
        if (bluePanel != null && greenPanel != null) {
            LogicalPanel lp = this.addLogicalPanel();
            logical = lp.getLogical();
            logical.setAsCyan();
            logical.addOverlay(greenPanel.getLogical().getIterator().next());
            logical.addOverlay(bluePanel.getLogical().getIterator().next());
            lp.updateDisplay();
        }
        if (redPanel != null && bluePanel != null) {
            LogicalPanel lp = this.addLogicalPanel();
            logical = lp.getLogical();
            logical.setAsMagenta();
            logical.addOverlay(redPanel.getLogical().getIterator().next());
            logical.addOverlay(bluePanel.getLogical().getIterator().next());
            lp.updateDisplay();
        }
        if (bluePanel != null && redPanel != null && greenPanel != null) {
            LogicalPanel lp = this.addLogicalPanel();
            logical = lp.getLogical();
            logical.setAsWhite();
            logical.addOverlay(redPanel.getLogical().getIterator().next());
            logical.addOverlay(bluePanel.getLogical().getIterator().next());
            logical.addOverlay(greenPanel.getLogical().getIterator().next());
            lp.updateDisplay();
        }
        if (!this.hasEmptyLogical()) {
            this.addLogicalPanel();
        }
        this.updateLogicals();
        this.viewer.updateScreenSlices();
        this.viewer.getToolBox().updateSlider();
    }

    public void removeAllLogicals() {
        this.logicalPanels.removeAllElements();
        this.addLogicalPanel();
        this.updateLogicals();
        this.updateAllLogicals();
        this.viewer.getToolBox().updateSlider();
        this.updateHideButton();
    }

    private boolean resetSize() {
        this.pack();
        this.validate();
        if (this.getSize().height >= 450) {
            this.setSize(this.getSize().width, 450);
            return true;
        }
        return false;
    }

    private void setAsRGB(ScreenVolume sv, int rgbIndex) {
        int ctr;
        Vector<LogicalPanel> panelsToRemove = new Vector<LogicalPanel>();
        for (ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            LogicalPanel lp = this.logicalPanels.get(ctr);
            if (!lp.getLogical().isRGB(rgbIndex)) continue;
            panelsToRemove.add(lp);
        }
        for (ctr = 0; ctr < panelsToRemove.size(); ++ctr) {
            this.logicalPanels.remove(panelsToRemove.get(ctr));
        }
        LogicalPanel emptyPanel = null;
        for (int ctr2 = 0; ctr2 < this.logicalPanels.size(); ++ctr2) {
            LogicalPanel lp = this.logicalPanels.get(ctr2);
            if (!lp.isEmptyLogical()) continue;
            emptyPanel = lp;
            break;
        }
        if (emptyPanel != null) {
            Logical logical = emptyPanel.getLogical();
            logical.setRGB(rgbIndex);
            logical.addOverlay(sv.getVolume());
            emptyPanel.updateDisplay();
            this.viewer.updateScreenSlices();
            this.viewer.getToolBox().updateSlider();
            this.makeRGBIntersections();
        }
    }

    private void updateHideButton() {
        boolean hasNonHidden = false;
        boolean found = false;
        for (int ctr = 0; ctr < this.logicalPanels.size(); ++ctr) {
            if (this.logicalPanels.get(ctr).getLogical().getNumOverlays() <= 0) continue;
            found = true;
            if (this.logicalPanels.get(ctr).getLogical().isHidden()) continue;
            hasNonHidden = true;
            break;
        }
        if (hasNonHidden || !found) {
            this.hideAllButton.setText(ACTION_DISABLE_ALL);
        } else {
            this.hideAllButton.setText("Enable All");
        }
    }

    private void updateLogicalManager() {
        boolean hasActiveLogicals = false;
        for (LogicalPanel lp : this.logicalPanels) {
            hasActiveLogicals |= lp.hasActiveLogical();
        }
        if (!hasActiveLogicals) {
            this.generateAllLogicals();
        }
    }

    private void updateLogicalPanels() {
        int numPanels = this.logicalPanels.size();
        this.mainLogicalPanel.removeAll();
        this.clearOverlayLogicalFlags();
        this.allLogicals = new Logical[numPanels];
        for (int ctr = 0; ctr < numPanels; ++ctr) {
            JPanel addLogicalPanel = new JPanel();
            addLogicalPanel.setLayout(new BoxLayout(addLogicalPanel, 0));
            LogicalPanel logicalPanel = this.logicalPanels.get(ctr);
            this.allLogicals[ctr] = logicalPanel.getLogical();
            this.allLogicals[ctr].setLogicalFlags();
            addLogicalPanel.add(logicalPanel);
            addLogicalPanel.add(Box.createHorizontalStrut(2));
            addLogicalPanel.add(logicalPanel.getOptionsButton());
            this.mainLogicalPanel.add(addLogicalPanel);
        }
        this.scroller.setMaximumSize(new Dimension(425, 52 * numPanels));
        this.scroller.setMinimumSize(new Dimension(425, 52));
        this.validate();
        if (!this.isGeneratingAll && !this.isRemoving) {
            this.pack();
        }
        this.repaint();
        this.updateOverlayButtons();
    }

    private void updateOverlayButtonIcons() {
        this.updateOverlayImageIconLUTImages();
        for (int ctr = 0; ctr < 8; ++ctr) {
            this.overlayImageIcons[ctr] = new ImageIcon(this.overlayImagesFiltered[ctr]);
        }
    }

    private void updateOverlayButtons() {
        this.updateOverlayButtonIcons();
        this.buttonPanel.removeAll();
        this.numOverlays = this.viewer.getOverlayManager().getNumInStack();
        this.buttonPanel.add(Box.createHorizontalGlue());
        for (int ctr = 0; ctr < this.numOverlays; ++ctr) {
            if (ctr != 0) {
                this.buttonPanel.add(Box.createHorizontalStrut(6));
            }
            final int ctrF = ctr;
            ScreenVolume sv = this.viewer.getOverlayManager().getOverlay(ctr);
            if (!sv.hasOverlayListener(this)) {
                sv.addOverlayListener(this);
            }
            JLabel label = new JLabel(this.overlayImageIcons[ctr]);
            label.setToolTipText(sv.getName());
            label.setTransferHandler(new LogicalTransferHandler(this));
            MouseAdapter listener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    LogicalAnalysisTool.this.draggingIndex = ctrF;
                    JComponent comp = (JComponent)me.getSource();
                    TransferHandler handler = comp.getTransferHandler();
                    handler.exportAsDrag(comp, me, 1);
                }
            };
            label.addMouseListener(listener);
            this.buttonPanel.add(label);
        }
        if (this.viewer.getOverlayManager().getNumInStack() == 0) {
            JLabel label = new JLabel("Load overlays to begin.");
            label.setFont(label.getFont().deriveFont(2));
            this.buttonPanel.add(label);
        }
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    private void updateOverlayImageIconLUTImages() {
        List<ScreenVolume> allOverlays = this.getAllOverlays();
        for (int ctr = 0; ctr < allOverlays.size(); ++ctr) {
            if (allOverlays.get(ctr) == null || allOverlays.get(ctr).getLookupTableManager() == null) continue;
            allOverlays.get(ctr).getLookupTableManager().getOp().filter(this.overlayImages[ctr], this.overlayImagesFiltered[ctr]);
        }
    }
}

