/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.logical;

import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.ScreenVolumeComparator;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.volume.Volume;
import java.awt.Color;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class Logical {
    private Color color;
    private Volume[] overlayArray;
    private boolean blue;
    private boolean cyan;
    private boolean green;
    private boolean hidden;
    private boolean magenta;
    private boolean red;
    private boolean white;
    private boolean yellow;
    private int hashCode;
    private final SliceViewer viewer;
    private final Set<Volume> overlaySet = new TreeSet<Volume>(new ScreenVolumeComparator());
    private static int colorIndex;

    public Logical(SliceViewer viewer) {
        this.viewer = viewer;
        this.pickNewColor();
    }

    public boolean contains(Volume sv) {
        return this.overlaySet.contains(sv);
    }

    public Color getColor() {
        return this.color;
    }

    public Iterator<Volume> getIterator() {
        return this.overlaySet.iterator();
    }

    public int getNumOverlays() {
        return this.overlaySet.size();
    }

    public Volume[] getOverlaySetArray() {
        return this.overlayArray;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isBlue() {
        return this.blue;
    }

    public boolean isCyan() {
        return this.cyan;
    }

    public boolean isCYMW() {
        return this.yellow || this.magenta || this.cyan || this.white;
    }

    public boolean isGreen() {
        return this.green;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isMagenta() {
        return this.magenta;
    }

    public boolean isRed() {
        return this.red;
    }

    public boolean isRGB() {
        return this.red || this.green || this.blue || this.yellow || this.magenta || this.cyan || this.white;
    }

    public boolean isWhite() {
        return this.white;
    }

    public boolean isYellow() {
        return this.yellow;
    }

    public void setAsGreen() {
        this.clearRGBFlags();
        this.green = true;
        this.color = new Color(-16711936);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden && this.overlaySet.size() > 0;
    }

    public void setRGB(int rgbIndex) {
        if (rgbIndex == 0) {
            this.setAsRed();
        } else if (rgbIndex == 1) {
            this.setAsGreen();
        } else if (rgbIndex == 2) {
            this.setAsBlue();
        }
    }

    public void addOverlay(Volume sv) {
        this.overlaySet.add(sv);
        this.updateOverlayArray();
        this.updateHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Logical other = (Logical)obj;
        return this.hashCode == other.hashCode;
    }

    protected void clearRGBFlags() {
        this.white = false;
        this.cyan = false;
        this.magenta = false;
        this.yellow = false;
        this.red = false;
        this.blue = false;
        this.green = false;
    }

    protected Color deriveBestColor() {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (Volume element : this.overlayArray) {
            int highBlue;
            int highGreen;
            int highRed;
            int highSum;
            int lowBlue;
            int lowGreen;
            ScreenVolume overlay = this.viewer.findOverlay(element);
            int lowRed = overlay.getLookupTableManager().lookupRed(0);
            int lowSum = lowRed + (lowGreen = overlay.getLookupTableManager().lookupGreen(0)) + (lowBlue = overlay.getLookupTableManager().lookupBlue(0));
            if (lowSum < (highSum = (highRed = overlay.getLookupTableManager().lookupRed(255)) + (highGreen = overlay.getLookupTableManager().lookupGreen(255)) + (highBlue = overlay.getLookupTableManager().lookupBlue(255)))) {
                red += lowRed;
                green += lowGreen;
                blue += lowBlue;
                continue;
            }
            red += highRed;
            green += highGreen;
            blue += highBlue;
        }
        double avgRed = (float)red / (float)this.overlayArray.length;
        double avgGreen = (float)green / (float)this.overlayArray.length;
        double avgBlue = (float)blue / (float)this.overlayArray.length;
        if (avgRed >= avgGreen && avgRed >= avgBlue) {
            double factor = 255.0 / avgRed;
            avgRed = 255.0;
            avgGreen = Math.min(255.0, avgGreen * factor);
            avgBlue = Math.min(255.0, avgBlue * factor);
        } else if (avgGreen >= avgRed && avgGreen >= avgBlue) {
            double factor = 255.0 / avgGreen;
            avgRed = Math.min(255.0, avgRed * factor);
            avgGreen = 255.0;
            avgBlue = Math.min(255.0, avgBlue * factor);
        } else {
            double factor = 255.0 / avgGreen;
            avgRed = Math.min(255.0, avgRed * factor);
            avgGreen = Math.min(255.0, avgGreen * factor);
            avgBlue = 255.0;
        }
        return new Color((int)avgRed, (int)avgGreen, (int)avgBlue);
    }

    protected boolean isRGB(int rgbIndex) {
        if (rgbIndex == 0) {
            return this.isRed();
        }
        if (rgbIndex == 1) {
            return this.isGreen();
        }
        if (rgbIndex == 2) {
            return this.isBlue();
        }
        return false;
    }

    protected void setAsCyan() {
        this.clearRGBFlags();
        this.cyan = true;
        this.color = new Color(-16711681);
    }

    protected void setAsMagenta() {
        this.clearRGBFlags();
        this.magenta = true;
        this.color = new Color(-65281);
    }

    protected void setAsWhite() {
        this.clearRGBFlags();
        this.white = true;
        this.color = new Color(-1);
    }

    protected void setAsYellow() {
        this.clearRGBFlags();
        this.yellow = true;
        this.color = new Color(-256);
    }

    protected void setLogicalFlags() {
        Iterator<Volume> it = this.overlaySet.iterator();
        while (it.hasNext()) {
            if (this.viewer == null) continue;
            this.viewer.findOverlay(it.next()).setLogical(true);
        }
    }

    private void pickNewColor() {
        this.color = ROIColor.getColor(colorIndex %= 6);
        ++colorIndex;
    }

    private void setAsBlue() {
        this.clearRGBFlags();
        this.blue = true;
        this.color = new Color(-16776961);
    }

    private void setAsRed() {
        this.clearRGBFlags();
        this.red = true;
        this.color = new Color(-65536);
    }

    private void updateHashCode() {
        this.hashCode = 0;
        for (Volume element : this.overlayArray) {
            this.hashCode += element.hashCode();
        }
    }

    private void updateOverlayArray() {
        this.overlayArray = new Volume[this.overlaySet.size()];
        Iterator<Volume> it = this.overlaySet.iterator();
        int index = 0;
        while (it.hasNext()) {
            this.overlayArray[index] = it.next();
            if (this.viewer != null) {
                this.viewer.findOverlay(this.overlayArray[index]).setLogical(true);
            }
            ++index;
        }
    }
}

