/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.layout;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.MangoData;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.ScreenImage;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.core.SliceDirectionListener;
import edu.uthscsa.ric.mango.viewerslice.dialogs.layout.MarkupPanel;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.LookupOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Layout
implements ActionListener,
SliceDirectionListener {
    private JFrame frame;
    private JTextField fileText;
    private AffineTransform colorBarImageTransform;
    private AffineTransform fullPreviewTransform;
    private AffineTransform previewTransform;
    private AffineTransform sliceTransform;
    private BufferedImage layoutImage;
    private BufferedImage lutImage;
    private BufferedImage lutImageFiltered;
    private BufferedImage sliceImage;
    private Color backgroundColor;
    private Color colorBarTextColor;
    private Color footnoteColor;
    private Color labelColor;
    private Color orientationColor;
    private Color titleColor;
    private JButton showFileButton;
    private JButton openFileButton;
    private JCheckBox addColorBar;
    private JCheckBox addSliceNumbers;
    private JCheckBox addText;
    private JCheckBox onlyImageBox;
    private JFrame fullPreviewFrame;
    private JLabel desLabel;
    private JLabel overlaysLabel;
    private JLabel titleLabel;
    private JPanel fullPreviewPanel;
    private JRadioButton acrossTimeButton;
    private JRadioButton acrossViewersButton;
    private JTextField cols;
    private JTextField description;
    private JTextField imageWidth;
    private JTextField overlayName;
    private JTextField skip;
    private JTextField start;
    private JTextField statName;
    private JTextField title;
    private MangoComboBox<String> overlaysBox;
    private MangoData data;
    private JTextField rows;
    private MarkupPanel markupPanel;
    private String footnoteFontFamily;
    private String sliceLabel;
    private String titleFontFamily;
    private String[] overlayNames;
    private String[] sliceStrings;
    private String[] statNames;
    private boolean freezeOverlayBoxState;
    private boolean fullPreviewInitialized;
    private boolean isIndexLabel;
    private boolean isReverse;
    private boolean isUsingColorBars;
    private boolean isUsingSliceLabels;
    private boolean isUsingText;
    private boolean isWorking;
    private double scale;
    private double sliceMultiplier;
    private int colorBarHeight;
    private int colorBarMaxTextDrawLocX;
    private int colorBarMaxTextDrawLocY;
    private int colorBarMinTextDrawLocX;
    private int colorBarMinTextDrawLocY;
    private int colorBarStatsTextDrawLocX;
    private int colorBarStatsTextDrawLocY;
    private int colorBarTextDrawLocX;
    private int colorBarTextDrawLocY;
    private int colorBarTextHeight;
    private boolean worldMode;
    private int edgeOffset;
    private int footnoteDrawLocX;
    private int footnoteDrawLocY;
    private int footnoteFontType;
    private int footnoteHeight;
    private int footnoteJustification;
    private int imageWidthNum;
    private int labelHeight;
    private int numCols;
    private int numRows;
    private int numSlices;
    private int orientationDrawLocXL;
    private int orientationDrawLocXR;
    private int orientationDrawLocY;
    private int showSlicesType;
    private int skipNum;
    private int sliceNumberDrawLocX;
    private int sliceNumberDrawLocY;
    private int sliceOffset;
    private int startSlice;
    private int titleDrawLocX;
    private int titleDrawLocY;
    private int titleFontType;
    private int titleJustification;
    private final MangoNumberFormatter formatter = new MangoNumberFormatter(0);
    private final VolumeManager viewer;
    private final MangoContext mango;
    private static final int[] FONT_TYPES = new int[]{0, 2, 1, 3};
    public static final Color BORDER_COLOR = new Color(185, 185, 185);
    public static final Color COLOR_BACKGROUND_DEFAULT = Color.BLACK;
    public static final Color COLOR_DEFAULT1 = Color.WHITE;
    public static final Color COLOR_DEFAULT2 = new Color(-5171);
    public static final Font FONT_BOLD = new Font("SansSerif", 1, 12);
    public static final Font FONT_VERY_SMALL_BOLD = new Font("SansSerif", 1, 8);
    public static final List<String> FONTS = CollectionUtilities.immutable((String[])new String[]{"Serif", "SansSerif", "Fixed-width", "Serif Italic", "SansSerif Italic", "Fixed-width Italic", "Serif Bold", "SansSerif Bold", "Fixed-width Bold", "Serif Bold Italic", "SansSerif Bold Italic", "Fixed-width Bold Italic"});
    public static final List<String> FONT_FAMILY = CollectionUtilities.immutable((String[])new String[]{"Serif", "SansSerif", "Monospaced"});
    public static final String DEFAULT_EXT = ".png";
    public static final String DEFAULT_NAME = "layout";
    public static final String FONT_TYPE = "SansSerif";
    public static final String NAME = "Create Layout";
    public static final String SPECIAL_MAX_Y_EXTENT_STRING = "gP";
    public static final String STAT_NAME_DEFAULT = "z";
    public static final int COLOR_BAR_HEIGHT_DIVISOR = 2;
    public static final int COLOR_BAR_WIDTH_DIVISOR = 7;
    public static final int EDGE_OFFSET_INDEX_COORDINATE = 4;
    public static final int EDGE_OFFSET_MINIMUM = 12;
    public static final int IMAGE_WIDTH_NUM_START = 1600;
    public static final int JUSTIFICATION_CENTER = 0;
    public static final int JUSTIFICATION_LEFT = 1;
    public static final int JUSTIFICATION_RIGHT = 2;
    public static final int MAX_RESOLUTION = 12000;
    public static final int PREVIEW_IMAGE_HEIGHT_MAX = 175;
    public static final int PREVIEW_IMAGE_TRANSLATE_X = 10;
    public static final int PREVIEW_IMAGE_TRANSLATE_Y = 5;
    public static final int PREVIEW_IMAGE_WIDTH_MAX = 175;
    public static final int SHOW_SLICES_ALL = 0;
    public static final int SHOW_SLICES_OTHER = 2;
    public static final int SHOW_SLICES_STANDARD = 1;
    public static final String ACTION_SELECT_FILE = "ACTION_SELECT_FILE";
    public static final String EXTENSION = ".png";
    public static final String ACTION_PLAY = "ACTION_PLAY";
    public static final String ACTION_SHOW = "ACTION_SHOW";
    public static final String EXT_JPEG = "jpeg";
    public static final String EXT_BMP = "bmp";
    public static final String EXT_PNG = "png";
    public static final String EXT_JPG = "jpg";

    public Layout(MangoContext mango, VolumeManager viewer) {
        this(mango, viewer, false);
    }

    public Layout(MangoContext mango, VolumeManager viewer, boolean silent) {
        this.mango = mango;
        this.viewer = viewer;
        this.data = viewer.getMangoData();
        if (viewer instanceof SliceViewer) {
            ((SliceViewer)viewer).addSliceDirectionListener(this);
        }
        this.createUI(silent);
    }

    public void setParametersAndSave(String saveLocation, int rowVal, int columns, int startSlice, int skipSlices, boolean series, boolean useLabels, boolean useColorBars, boolean useText, String titleVal, String footnote) {
        this.fileText.setText(saveLocation);
        this.rows.setText(String.valueOf(rowVal));
        this.cols.setText(String.valueOf(columns));
        this.start.setText(String.valueOf(startSlice));
        this.skip.setText(String.valueOf(skipSlices));
        this.acrossTimeButton.setSelected(series);
        this.addSliceNumbers.setSelected(useLabels);
        this.addColorBar.setSelected(useColorBars);
        this.addText.setSelected(useText);
        this.title.setText(titleVal);
        this.description.setText(footnote);
        this.doUpdate(true);
        this.doSave();
    }

    private void doSave() {
        File selectedFile = new File(this.fileText.getText());
        if (selectedFile.exists()) {
            MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.frame, (Object)"<html>This file already exists and will be overwritten.</html>", "Warning: File Exists", 2, null, 2, (Object[])new String[]{"Continue", "Cancel"}, (Object)"Cancel");
            jopf.show();
            String returnValue = jopf.getReturnOption();
            if (returnValue.equals("Cancel")) {
                return;
            }
        }
        String format = null;
        String selectedFileString = selectedFile.getName();
        String selectedDirString = selectedFile.getParent();
        if (selectedFileString.indexOf(46) != -1) {
            String extension = selectedFileString.substring(selectedFileString.indexOf(46) + 1).toLowerCase();
            if (extension.equals(EXT_BMP)) {
                format = EXT_BMP;
            } else if (extension.equals(EXT_JPEG) || extension.equals(EXT_JPG)) {
                format = EXT_JPEG;
            } else if (extension.equals(EXT_PNG)) {
                format = EXT_PNG;
            } else {
                selectedFileString = selectedFileString.substring(0, selectedFileString.indexOf(46)) + ".jpg";
                format = EXT_JPEG;
            }
        } else {
            selectedFileString = selectedFileString + ".jpg";
            format = EXT_JPEG;
        }
        File saveFile = new File(selectedDirString, selectedFileString);
        if (this.viewer instanceof SliceViewer) {
            ((SliceViewer)this.viewer).recordAction("captureLayout", new String[]{this.viewer.getScriptObjectName() + ".makeFilename(\"_layout." + format + "\")", this.rows.getText(), this.cols.getText(), String.valueOf(0), String.valueOf(0), ScriptUtils.convertBoolean(this.acrossTimeButton.isSelected()), ScriptUtils.convertBoolean(this.addSliceNumbers.isSelected()), ScriptUtils.convertBoolean(this.addColorBar.isSelected()), ScriptUtils.convertBoolean(this.addText.isSelected()), ScriptUtils.convertString(this.title.getText()), ScriptUtils.convertString(this.description.getText())}, true);
        }
        try {
            ImageIO.write((RenderedImage)this.layoutImage, format, saveFile);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        this.updateEnabled();
    }

    private void doUpdate(boolean silent) {
        ScreenImage[] mangoOverlays = this.data.getOverlayScreenImages();
        this.data = this.viewer.getMangoData();
        ScreenImage[] mangoOverlaysNew = this.data.getOverlayScreenImages();
        this.isReverse = false;
        this.isUsingText = this.addText.isSelected();
        this.isUsingColorBars = this.addColorBar.isSelected();
        this.isUsingSliceLabels = this.addSliceNumbers.isSelected();
        boolean overlaysChanged = false;
        if (mangoOverlays != null ^ mangoOverlaysNew != null) {
            overlaysChanged = true;
        } else if (mangoOverlays != null && mangoOverlaysNew != null) {
            if (mangoOverlays.length != mangoOverlaysNew.length) {
                overlaysChanged = true;
            } else {
                for (int ctr = 0; ctr < mangoOverlays.length; ++ctr) {
                    if (mangoOverlays[ctr].getURI() != null && mangoOverlays[ctr].getURI().equals(mangoOverlaysNew[ctr].getURI())) continue;
                    overlaysChanged = true;
                }
            }
        }
        if (overlaysChanged) {
            this.updateOverlayBox();
            this.updateOverlayNameBox();
        }
        this.updateLayout(silent);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals("preview")) {
            this.showFullPreview();
        } else if (actionCommand.equals("save")) {
            this.doSave();
        } else if (actionCommand.equals("update")) {
            this.doUpdate(false);
        } else if (actionCommand.equals("color bars")) {
            this.updateEnabledItems();
        } else if (actionCommand.equals("text")) {
            this.updateEnabledItems();
        } else if (actionCommand.equals("slice labels")) {
            this.updateEnabledItems();
        } else if (actionCommand.equals("overlay selection")) {
            if (!this.freezeOverlayBoxState) {
                this.updateOverlayNameBox();
            }
        } else if (actionCommand.equals("across viewers")) {
            this.markupPanel.setAllSliceLabels(true);
        } else if (actionCommand.equals("across slices")) {
            this.markupPanel.setPartialSliceLabels(true);
        } else if (actionCommand.equals("across time")) {
            this.markupPanel.setAllSliceLabels(true);
        } else if (actionCommand.equals(ACTION_SELECT_FILE)) {
            this.editSaveFile();
            this.updateEnabled();
        } else if (actionCommand.equals(ACTION_PLAY)) {
            this.play();
        } else if (actionCommand.equals(ACTION_SHOW)) {
            this.showFile();
        }
    }

    private void editSaveFile() {
        File snapshotFile = new File(this.fileText.getText());
        File saveFile = SaveFileDialog.showSaveFileChooser(this.frame, snapshotFile.getParent(), snapshotFile.getName());
        if (saveFile != null) {
            this.fileText.setText(saveFile.toString());
        }
        this.updateEnabled();
    }

    private void play() {
        DesktopUtilities.openFile((File)new File(this.fileText.getText()));
    }

    private void showFile() {
        DesktopUtilities.revealAndSelect((File)new File(this.fileText.getText()));
    }

    private void updateEnabled() {
        File file = new File(this.fileText.getText());
        this.openFileButton.setEnabled(file.exists());
        this.showFileButton.setEnabled(file.exists());
    }

    private File makeSaveFile() {
        String filename = FileUtilities.removeExtension((String)FileUtilities.getName((URI)this.viewer.getLoadedURI())) + "_" + DEFAULT_NAME + ".png";
        File imageDir = Mango.getInstance().isCaptureToDesktop() ? Platform.getDesktopDir() : (FileUtilities.uriIsFile((URI)this.viewer.getLoadedURI()) ? new File(this.viewer.getLoadedURI()).getParentFile() : Platform.getDesktopDir());
        File file = new File(imageDir, filename);
        return FileUtilities.findUniqueFilename((File)file);
    }

    private void updateSaveFileText() {
        this.fileText.setText(this.makeSaveFile().toString());
    }

    public final String getMarkupSlicesString() {
        if (this.sliceLabel == null) {
            return null;
        }
        String string = null;
        StringBuffer sb = new StringBuffer();
        List allControllers = this.mango.getAllVolumeManagers();
        for (int ctrRows = 0; ctrRows < this.numRows; ++ctrRows) {
            for (int ctrCols = 0; ctrCols < this.numCols; ++ctrCols) {
                int sliceNum = (ctrRows * this.numCols + ctrCols) * (this.skipNum + 1) + this.startSlice;
                String sliceString = null;
                if (this.acrossTimeButton.isSelected()) {
                    int index = (int)((double)(this.sliceOffset - sliceNum) * this.sliceMultiplier);
                    sliceString = this.viewer.getMangoData().getBaseScreenImage().getImageVolume().getLabel(index);
                    if (sliceString == null) {
                        sliceString = this.formatter.format(index) + this.sliceLabel;
                    }
                } else if (this.acrossViewersButton.isSelected()) {
                    if (sliceNum < allControllers.size()) {
                        sliceString = FileUtilities.getName((URI)((VolumeManager)allControllers.get(sliceNum)).getLoadedURI());
                        if (sliceString.indexOf(46) != -1) {
                            sliceString = sliceString.substring(0, sliceString.lastIndexOf(46));
                        }
                    } else {
                        sliceString = "";
                    }
                } else {
                    sliceString = this.sliceLabel + this.formatter.format((double)(this.sliceOffset - sliceNum) * this.sliceMultiplier);
                }
                sb.append("\"" + sliceString + "\", ");
            }
        }
        string = sb.toString();
        string = string.substring(0, string.length() - 2);
        return string;
    }

    public String getMinimumVersionSupported() {
        return null;
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public boolean isUsingSliceLabelRow() {
        return this.isUsingSliceLabels && (!this.isIndexLabel || this.acrossViewersButton.isSelected() || this.markupPanel.isOtherSliceText());
    }

    private void blankImage(BufferedImage bi) {
        int[] rgbData = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        for (int ctr = 0; ctr < rgbData.length; ++ctr) {
            rgbData[ctr] = -16777216;
        }
    }

    private void blankImage(BufferedImage bi, Color aColor) {
        int[] rgbData = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        int colorVal = 0xFF000000 | aColor.getRed() << 16 | aColor.getGreen() << 8 | aColor.getBlue();
        for (int ctr = 0; ctr < rgbData.length; ++ctr) {
            rgbData[ctr] = colorVal;
        }
    }

    private final void createUI(boolean silent) {
        this.markupPanel = new MarkupPanel();
        this.titleColor = COLOR_DEFAULT2;
        this.labelColor = COLOR_DEFAULT1;
        this.footnoteColor = COLOR_DEFAULT2;
        this.orientationColor = COLOR_DEFAULT2;
        this.backgroundColor = COLOR_BACKGROUND_DEFAULT;
        this.colorBarTextColor = COLOR_DEFAULT1;
        JPanel previewPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                if (Layout.this.isWorking) {
                    g2d.setBackground(Color.BLACK);
                } else {
                    g2d.drawImage(Layout.this.layoutImage, Layout.this.previewTransform, null);
                }
            }
        };
        previewPanel.setPreferredSize(new Dimension(195, 185));
        previewPanel.setMinimumSize(previewPanel.getPreferredSize());
        previewPanel.setMaximumSize(previewPanel.getPreferredSize());
        JRadioButton acrossSlicesButton = new JRadioButton("Slices");
        acrossSlicesButton.setFocusable(false);
        acrossSlicesButton.setActionCommand("across slices");
        acrossSlicesButton.addActionListener(this);
        this.acrossTimeButton = new JRadioButton("Series");
        this.acrossTimeButton.setFocusable(false);
        this.acrossTimeButton.setActionCommand("across time");
        this.acrossTimeButton.addActionListener(this);
        this.acrossViewersButton = new JRadioButton("Viewers");
        this.acrossViewersButton.setFocusable(false);
        this.acrossViewersButton.setActionCommand("across viewers");
        this.acrossViewersButton.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(acrossSlicesButton);
        group.add(this.acrossTimeButton);
        group.add(this.acrossViewersButton);
        if (this.viewer.getBaseVolume().getSeriesLength() > 1) {
            this.acrossTimeButton.setSelected(true);
        } else {
            acrossSlicesButton.setSelected(true);
        }
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        typePanel.add(Box.createHorizontalStrut(4));
        typePanel.add(acrossSlicesButton);
        typePanel.add(Box.createHorizontalStrut(2));
        typePanel.add(this.acrossTimeButton);
        typePanel.add(Box.createHorizontalStrut(2));
        typePanel.add(this.acrossViewersButton);
        typePanel.add(Box.createHorizontalGlue());
        this.rows = new MangoTextField(String.valueOf(this.numRows), 3);
        this.rows.setActionCommand("rows");
        this.rows.addActionListener(this);
        this.rows.setMaximumSize(this.rows.getPreferredSize());
        this.rows.setMinimumSize(this.rows.getPreferredSize());
        this.cols = new MangoTextField(String.valueOf(this.numCols), 3);
        this.cols.setActionCommand("cols");
        this.cols.addActionListener(this);
        this.cols.setMaximumSize(this.cols.getPreferredSize());
        this.cols.setMinimumSize(this.cols.getPreferredSize());
        this.start = new MangoTextField(String.valueOf(this.startSlice), 3);
        this.start.setActionCommand("start");
        this.start.addActionListener(this);
        this.start.setMaximumSize(this.start.getPreferredSize());
        this.start.setMinimumSize(this.start.getPreferredSize());
        this.skip = new MangoTextField(String.valueOf(this.skipNum), 3);
        this.skip.setActionCommand("skip");
        this.skip.addActionListener(this);
        this.skip.setMaximumSize(this.skip.getPreferredSize());
        this.skip.setMinimumSize(this.skip.getPreferredSize());
        JLabel rowLabel = new JLabel("Rows");
        JPanel rowsPanel = new JPanel();
        rowsPanel.setLayout(new BoxLayout(rowsPanel, 0));
        rowsPanel.add(rowLabel);
        rowsPanel.add(Box.createHorizontalStrut(2));
        rowsPanel.add(this.rows);
        JLabel colLabel = new JLabel("Cols");
        JPanel colsPanel = new JPanel();
        colsPanel.setLayout(new BoxLayout(colsPanel, 0));
        colsPanel.add(colLabel);
        colsPanel.add(Box.createHorizontalStrut(2));
        colsPanel.add(this.cols);
        JLabel startLabel = new JLabel("Start");
        JPanel startPanel = new JPanel();
        startPanel.setLayout(new BoxLayout(startPanel, 0));
        startPanel.add(startLabel);
        startPanel.add(Box.createHorizontalStrut(2));
        startPanel.add(this.start);
        JLabel skipLabel = new JLabel("Skip");
        JPanel skipPanel = new JPanel();
        skipPanel.setLayout(new BoxLayout(skipPanel, 0));
        skipPanel.add(skipLabel);
        skipPanel.add(Box.createHorizontalStrut(2));
        skipPanel.add(this.skip);
        JPanel slicePanelGrid = new JPanel(new GridLayout(2, 2));
        slicePanelGrid.add(startPanel, 0, 0);
        slicePanelGrid.add(skipPanel, 0, 1);
        slicePanelGrid.add(rowsPanel, 1, 0);
        slicePanelGrid.add(colsPanel, 1, 1);
        JPanel slicePanel = new JPanel();
        slicePanel.setLayout(new BoxLayout(slicePanel, 0));
        slicePanel.add(Box.createHorizontalGlue());
        slicePanel.add(slicePanelGrid);
        slicePanel.add(Box.createHorizontalGlue());
        this.imageWidth = new MangoTextField(String.valueOf(this.imageWidthNum), 3);
        this.imageWidth.setActionCommand("width");
        this.imageWidth.addActionListener(this);
        this.imageWidth.setMaximumSize(this.imageWidth.getPreferredSize());
        this.imageWidth.setMinimumSize(this.imageWidth.getPreferredSize());
        JLabel imageWidthLabel = new JLabel("Resolution (width)", 0);
        JPanel imageWidthPanel = new JPanel();
        imageWidthPanel.setLayout(new BoxLayout(imageWidthPanel, 0));
        imageWidthPanel.add(Box.createHorizontalGlue());
        imageWidthPanel.add(Box.createHorizontalStrut(2));
        imageWidthPanel.add(imageWidthLabel);
        imageWidthPanel.add(Box.createHorizontalStrut(2));
        imageWidthPanel.add(this.imageWidth);
        imageWidthPanel.add(Box.createHorizontalStrut(2));
        imageWidthPanel.add(new JLabel("pixels"));
        imageWidthPanel.add(Box.createHorizontalGlue());
        this.addColorBar = new JCheckBox("Color Bars");
        this.addColorBar.setSelected(this.isUsingColorBars);
        this.addColorBar.setFocusable(false);
        this.addColorBar.setActionCommand("color bars");
        this.addColorBar.addActionListener(this);
        this.addSliceNumbers = new JCheckBox("Slice Labels");
        this.addSliceNumbers.setSelected(this.isUsingSliceLabels);
        this.addSliceNumbers.setFocusable(false);
        this.addSliceNumbers.setActionCommand("slice labels");
        this.addSliceNumbers.addActionListener(this);
        this.onlyImageBox = new JCheckBox("Image Only");
        this.onlyImageBox.setActionCommand("ignore");
        this.onlyImageBox.addActionListener(this);
        this.onlyImageBox.setSelected(true);
        this.onlyImageBox.setFocusable(false);
        this.addText = new JCheckBox("Text");
        this.addText.setActionCommand("text");
        this.addText.addActionListener(this);
        this.addText.setSelected(this.isUsingText);
        this.addText.setFocusable(false);
        JPanel optionsPanelGrid = new JPanel(new GridLayout(2, 2));
        optionsPanelGrid.add(this.onlyImageBox, 0, 0);
        optionsPanelGrid.add(this.addText, 0, 1);
        optionsPanelGrid.add(this.addSliceNumbers, 1, 0);
        optionsPanelGrid.add(this.addColorBar, 1, 1);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 0));
        optionsPanel.add(Box.createHorizontalGlue());
        optionsPanel.add(optionsPanelGrid);
        optionsPanel.add(Box.createHorizontalGlue());
        this.title = new MangoTextField("");
        this.title.setEnabled(this.isUsingText);
        this.titleLabel = new JLabel("Title:");
        this.titleLabel.setEnabled(this.isUsingText);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(Box.createHorizontalStrut(6));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalStrut(2));
        titlePanel.add(this.title);
        titlePanel.add(Box.createHorizontalStrut(6));
        this.description = new MangoTextField("");
        this.description.setEnabled(this.isUsingText);
        this.desLabel = new JLabel("Footnote:");
        this.desLabel.setEnabled(this.isUsingText);
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setLayout(new BoxLayout(descriptionPanel, 0));
        descriptionPanel.add(Box.createHorizontalStrut(6));
        descriptionPanel.add(this.desLabel);
        descriptionPanel.add(Box.createHorizontalStrut(2));
        descriptionPanel.add(this.description);
        descriptionPanel.add(Box.createHorizontalStrut(6));
        this.overlaysLabel = new JLabel("Color Bars:");
        this.overlaysLabel.setEnabled(this.isUsingText);
        this.overlaysBox = new MangoComboBox();
        this.overlaysBox.setFocusable(false);
        this.overlaysBox.setEnabled(this.isUsingText);
        this.overlaysBox.setActionCommand("overlay selection");
        this.overlaysBox.addActionListener(this);
        this.overlaysBox.setPrototypeDisplayValue("                     ");
        if (Platform.WINDOWS) {
            this.overlaysBox.setBackground(Color.WHITE);
        }
        this.updateOverlayBox();
        this.overlayName = new MangoTextField("");
        this.overlayName.setEnabled(this.isUsingText);
        this.overlayName.setText(this.overlayNames[this.overlaysBox.getSelectedIndex()]);
        this.overlayName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                int index = Layout.this.overlaysBox.getSelectedIndex();
                ((Layout)Layout.this).overlayNames[index] = Layout.this.overlayName.getText();
            }
        });
        this.statName = new MangoTextField("", 2);
        this.statName.setText(this.statNames[this.overlaysBox.getSelectedIndex()]);
        this.statName.setEnabled(this.isUsingText);
        this.statName.setMaximumSize(this.statName.getPreferredSize());
        this.statName.setMinimumSize(this.statName.getPreferredSize());
        this.statName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                int index = Layout.this.overlaysBox.getSelectedIndex();
                ((Layout)Layout.this).statNames[index] = Layout.this.statName.getText();
            }
        });
        JPanel overlaysPanel = new JPanel();
        overlaysPanel.setLayout(new BoxLayout(overlaysPanel, 0));
        overlaysPanel.add(Box.createHorizontalStrut(6));
        overlaysPanel.add(this.overlaysLabel);
        overlaysPanel.add(Box.createHorizontalStrut(4));
        overlaysPanel.add(this.overlaysBox);
        overlaysPanel.add(Box.createHorizontalStrut(4));
        overlaysPanel.add(this.overlayName);
        overlaysPanel.add(Box.createHorizontalStrut(4));
        overlaysPanel.add(this.statName);
        overlaysPanel.add(Box.createHorizontalStrut(6));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.add(titlePanel);
        textPanel.add(Box.createVerticalStrut(2));
        textPanel.add(overlaysPanel);
        textPanel.add(Box.createVerticalStrut(2));
        textPanel.add(descriptionPanel);
        JButton fullPreviewButton = new JButton("Show Full Preview");
        fullPreviewButton.setFocusable(false);
        fullPreviewButton.setActionCommand("preview");
        fullPreviewButton.addActionListener(this);
        JButton updateButton = new JButton("Update Layout");
        updateButton.setFocusable(false);
        updateButton.setActionCommand("update");
        updateButton.addActionListener(this);
        JPanel buttonUpperPanel = new JPanel();
        buttonUpperPanel.setLayout(new BoxLayout(buttonUpperPanel, 0));
        buttonUpperPanel.add(Box.createHorizontalStrut(8));
        buttonUpperPanel.add(fullPreviewButton);
        buttonUpperPanel.add(Box.createHorizontalGlue());
        buttonUpperPanel.add(updateButton);
        buttonUpperPanel.add(Box.createHorizontalStrut(8));
        this.openFileButton = new JButton("Open Layout");
        this.openFileButton.setFocusable(false);
        this.openFileButton.setActionCommand(ACTION_PLAY);
        this.openFileButton.addActionListener(this);
        this.showFileButton = new JButton("Show File");
        this.showFileButton.setFocusable(false);
        this.showFileButton.setActionCommand(ACTION_SHOW);
        this.showFileButton.addActionListener(this);
        JButton saveButton = new JButton("Save");
        saveButton.setFocusable(false);
        saveButton.setActionCommand("save");
        saveButton.addActionListener(this);
        JPanel buttonLowerPanel = new JPanel();
        buttonLowerPanel.setLayout(new BoxLayout(buttonLowerPanel, 0));
        buttonLowerPanel.add(Box.createHorizontalStrut(8));
        buttonLowerPanel.add(this.openFileButton);
        buttonLowerPanel.add(Box.createHorizontalStrut(8));
        buttonLowerPanel.add(this.showFileButton);
        buttonLowerPanel.add(Box.createHorizontalStrut(8));
        buttonLowerPanel.add(Box.createHorizontalGlue());
        buttonLowerPanel.add(saveButton);
        buttonLowerPanel.add(Box.createHorizontalStrut(8));
        JLabel fileLabel = new JLabel("File: ");
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                Layout.this.updateEnabled();
            }
        };
        this.fileText = new MangoTextField("", 25, kl, false, true);
        this.fileText.setMinimumSize(this.fileText.getPreferredSize());
        this.fileText.setMaximumSize(this.fileText.getPreferredSize());
        JButton fileSelectButton = new JButton("Select...");
        fileSelectButton.setActionCommand(ACTION_SELECT_FILE);
        fileSelectButton.addActionListener(this);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        filePanel.add(fileLabel);
        filePanel.add(this.fileText);
        filePanel.add(Box.createHorizontalGlue());
        filePanel.add(fileSelectButton);
        filePanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        JLabel infoLabel = new JLabel("<html><center>Creates a layout of slices, including title, color bars and labels.</center></html>", 0);
        infoLabel.setForeground(Color.GRAY);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        infoPanel.add(infoLabel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(Box.createVerticalStrut(6));
        leftPanel.add(typePanel);
        leftPanel.add(Box.createVerticalStrut(6));
        leftPanel.add(slicePanel);
        leftPanel.add(imageWidthPanel);
        leftPanel.add(optionsPanel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(Box.createHorizontalStrut(8));
        topPanel.add(leftPanel);
        topPanel.add(previewPanel);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(topPanel);
        mainPanel.add(textPanel);
        mainPanel.add(Box.createVerticalStrut(4));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Layout", mainPanel);
        tabbedPane.addTab("Style Settings", this.markupPanel);
        JPanel mainPanel2 = new JPanel();
        mainPanel2.setLayout(new BoxLayout(mainPanel2, 1));
        mainPanel2.add(Box.createVerticalStrut(8));
        mainPanel2.add(buttonUpperPanel);
        mainPanel2.add(Box.createVerticalStrut(8));
        mainPanel2.add(tabbedPane);
        mainPanel2.add(Box.createVerticalStrut(8));
        mainPanel2.add(filePanel);
        mainPanel2.add(Box.createVerticalStrut(8));
        mainPanel2.add(buttonLowerPanel);
        mainPanel2.add(Box.createVerticalStrut(8));
        mainPanel2.add(infoPanel);
        mainPanel2.add(Box.createVerticalStrut(8));
        mainPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.showSlicesType = 1;
        int sliceDirection = this.viewer.getSliceDirection();
        this.updateNumSlices(sliceDirection);
        this.imageWidthNum = 1600;
        this.imageWidth.setText(String.valueOf(this.imageWidthNum));
        Dimension initialDims = this.findInitialDimensions(this.numSlices);
        this.numCols = (int)initialDims.getWidth();
        this.numRows = (int)initialDims.getHeight();
        this.rows.setText(String.valueOf(this.numRows));
        this.cols.setText(String.valueOf(this.numCols));
        if (!silent) {
            this.frame = new JFrame();
            this.frame.setTitle("Create Layout: " + this.viewer.getManagerTitle());
            this.frame.setContentPane(mainPanel2);
            this.frame.setResizable(false);
            this.frame.setDefaultCloseOperation(2);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent we) {
                    if (Layout.this.fullPreviewFrame != null) {
                        Layout.this.fullPreviewFrame.setVisible(false);
                        Layout.this.fullPreviewFrame.dispose();
                    }
                    if (Layout.this.viewer instanceof SliceViewer) {
                        ((SliceViewer)Layout.this.viewer).removeSliceDirectionListener(Layout.this);
                    }
                }

                @Override
                public void windowClosing(WindowEvent we) {
                    if (Layout.this.fullPreviewFrame != null) {
                        Layout.this.fullPreviewFrame.setVisible(false);
                        Layout.this.fullPreviewFrame.dispose();
                    }
                    if (Layout.this.viewer instanceof SliceViewer) {
                        ((SliceViewer)Layout.this.viewer).removeSliceDirectionListener(Layout.this);
                    }
                }
            });
            this.viewer.associatePluginWindow("Layout", this.frame);
            this.frame.pack();
            this.frame.setLocation(this.viewer.findGoodPluginWindowLocation(this.frame.getSize()));
            this.frame.validate();
            this.frame.setVisible(true);
            this.frame.repaint();
            mainPanel.repaint();
            this.markupPanel.updateSlicesText(this.getMarkupSlicesString());
            this.updateSaveFileText();
            this.updateEnabled();
            this.updateLayout(false);
        }
    }

    private void filterLUTImage(int index) {
        LookupOp lutOp = null;
        lutOp = index == 0 ? new LookupOp(this.data.getBaseScreenImage().getLookupTable(), null) : new LookupOp(this.data.getOverlayScreenImages()[index - 1].getLookupTable(), null);
        lutOp.filter(this.lutImage, this.lutImageFiltered);
    }

    private void findColorBarMaxTextLocation(String stringVal, int index, int ofSoMany) {
        String string = stringVal;
        if (string == null || string.length() == 0) {
            string = " ";
        }
        int emptySpace = this.layoutImage.getWidth() - this.layoutImage.getWidth() / 7 * ofSoMany;
        this.colorBarMaxTextDrawLocX = (int)((double)(this.layoutImage.getWidth() / 7 * index) + (double)emptySpace / ((double)ofSoMany + 1.0) * (double)(index + 1) + (double)this.layoutImage.getWidth() / 7.0 + (double)this.edgeOffset / 2.0);
        this.colorBarMaxTextDrawLocY = this.layoutImage.getHeight() - this.footnoteHeight - (this.isUsingText ? this.colorBarTextHeight : 0) - (int)((double)this.colorBarHeight - (double)this.colorBarHeight * 0.5) + this.colorBarHeight / 2;
    }

    private void findColorBarMinTextLocation(Graphics2D g2d, String stringVal, Font aFont, int index, int ofSoMany) {
        String string = stringVal;
        if (string == null || string.length() == 0) {
            string = " ";
        }
        TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
        int textLayoutWidth = (int)textLayout.getBounds().getWidth();
        int emptySpace = this.layoutImage.getWidth() - this.layoutImage.getWidth() / 7 * ofSoMany;
        this.colorBarMinTextDrawLocX = (int)((double)(this.layoutImage.getWidth() / 7 * index) + (double)emptySpace / ((double)ofSoMany + 1.0) * (double)(index + 1) - (double)textLayoutWidth - (double)this.edgeOffset / 2.0);
        this.colorBarMinTextDrawLocY = this.layoutImage.getHeight() - this.footnoteHeight - (this.isUsingText ? this.colorBarTextHeight : 0) - (int)((double)this.colorBarHeight - (double)this.colorBarHeight * 0.5) + this.colorBarHeight / 2;
    }

    private void findColorBarStatTextLocation(Graphics2D g2d, String stringVal, Font aFont, int index, int ofSoMany) {
        String string = stringVal;
        if (string == null || string.length() == 0) {
            string = " ";
        }
        TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
        int textLayoutWidth = (int)textLayout.getBounds().getWidth();
        int textLayoutHeight = (int)textLayout.getBounds().getHeight();
        int emptySpace = this.layoutImage.getWidth() - this.layoutImage.getWidth() / 7 * ofSoMany;
        this.colorBarStatsTextDrawLocX = (int)((double)(this.layoutImage.getWidth() / 7 * index) + (double)emptySpace / ((double)ofSoMany + 1.0) * (double)(index + 1) + (double)this.layoutImage.getWidth() / 7.0 / 2.0 - (double)textLayoutWidth / 2.0);
        this.colorBarStatsTextDrawLocY = (int)Math.round((double)(this.layoutImage.getHeight() - this.footnoteHeight - (this.isUsingText ? this.colorBarTextHeight : 0)) - ((double)this.colorBarHeight - (double)this.colorBarHeight * 0.5) + (double)this.colorBarHeight / 2.0 - ((double)this.colorBarHeight / 2.0 - (double)textLayoutHeight) / 2.0);
    }

    private void findColorBarTextLocation(Graphics2D g2d, String stringVal, Font aFont, int index, int ofSoMany) {
        String string = stringVal;
        if (string == null || string.length() == 0) {
            string = " ";
        }
        TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
        int textLayoutWidth = (int)textLayout.getBounds().getWidth();
        textLayout = new TextLayout(string + SPECIAL_MAX_Y_EXTENT_STRING, aFont, g2d.getFontRenderContext());
        int textLayoutHeight = (int)textLayout.getBounds().getHeight();
        int emptySpace = this.layoutImage.getWidth() - this.layoutImage.getWidth() / 7 * ofSoMany;
        this.colorBarTextDrawLocX = (int)((double)this.layoutImage.getWidth() / 7.0 * (double)index + (double)emptySpace / ((double)ofSoMany + 1.0) * (double)(index + 1) + ((double)this.layoutImage.getWidth() / 7.0 - (double)textLayoutWidth) / 2.0);
        this.colorBarTextDrawLocY = this.layoutImage.getHeight() - this.footnoteHeight - (this.colorBarTextHeight - textLayoutHeight);
    }

    private void findFootnoteLocation(Graphics2D g2d, String stringVal, Font aFont) {
        String string = stringVal;
        if (string == null || string.length() == 0) {
            string = " ";
        }
        TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
        int textLayoutWidth = (int)textLayout.getBounds().getWidth();
        int textLayoutHeight = (int)textLayout.getBounds().getHeight();
        if (this.footnoteJustification == 1) {
            this.footnoteDrawLocX = this.edgeOffset * 6;
        } else if (this.footnoteJustification == 0) {
            this.footnoteDrawLocX = (this.layoutImage.getWidth() - textLayoutWidth) / 2;
        } else if (this.footnoteJustification == 2) {
            this.footnoteDrawLocX = this.layoutImage.getWidth() - textLayoutWidth - 6 * this.edgeOffset;
        }
        this.footnoteDrawLocY = this.layoutImage.getHeight() - (this.footnoteHeight - textLayoutHeight) / 2;
    }

    private Dimension findInitialDimensions(int numSlices) {
        int limit = numSlices / 2;
        int rowDim = 0x7FFFFFFE;
        int colDim = 0;
        for (int ctr = 2; ctr < limit; ++ctr) {
            int colDimTemp;
            int rowDimTemp;
            if (numSlices % ctr != 0 || Math.abs((rowDimTemp = ctr) - (colDimTemp = numSlices / ctr)) >= Math.abs(rowDim - colDim)) continue;
            if (rowDimTemp > colDimTemp) {
                colDim = rowDimTemp;
                rowDim = colDimTemp;
                continue;
            }
            colDim = colDimTemp;
            rowDim = rowDimTemp;
        }
        if (rowDim == 0x7FFFFFFE || colDim == 0 || rowDim < colDim / 2) {
            return new Dimension((int)Math.sqrt(numSlices) + 1, (int)Math.sqrt(numSlices));
        }
        return new Dimension(colDim, rowDim);
    }

    private void findOrientationLabelLocation(Graphics2D g2d, String stringVal, Font aFont) {
        String string = stringVal;
        if (string == null || string.length() == 0) {
            string = " ";
        }
        TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
        int textLayoutWidth = (int)textLayout.getBounds().getWidth();
        int textLayoutHeight = (int)textLayout.getBounds().getHeight();
        this.orientationDrawLocXR = this.layoutImage.getWidth() - textLayoutWidth - this.edgeOffset;
        this.orientationDrawLocXL = this.edgeOffset;
        this.orientationDrawLocY = this.layoutImage.getHeight() - (this.footnoteHeight - textLayoutHeight) / 2;
    }

    private Font findTextFont(Graphics2D g2d, String[] strings) {
        String stringToUse = strings[0];
        for (int ctr = 1; ctr < strings.length; ++ctr) {
            if (strings[ctr].length() <= stringToUse.length()) continue;
            stringToUse = strings[ctr];
        }
        if (stringToUse.length() == 0) {
            stringToUse = "x";
        }
        return this.makeTextFont(g2d, stringToUse);
    }

    private void findTitleTextLocation(Graphics2D g2d, String string, Font aFont) {
        TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
        int textLayoutWidth = (int)textLayout.getBounds().getWidth();
        int textLayoutHeight = (int)textLayout.getBounds().getHeight();
        double titleSize = (double)this.layoutImage.getWidth() / (double)this.numCols / 2.0;
        if (this.titleJustification == 1) {
            this.titleDrawLocX = 2 * this.edgeOffset;
        } else if (this.titleJustification == 0) {
            this.titleDrawLocX = (this.layoutImage.getWidth() - textLayoutWidth) / 2;
        } else if (this.titleJustification == 2) {
            this.titleDrawLocX = this.layoutImage.getWidth() - textLayoutWidth - 2 * this.edgeOffset;
        }
        this.titleDrawLocY = (int)((double)textLayoutHeight + (titleSize - (double)textLayoutHeight) / 2.0);
    }

    private BufferedImage getImage() {
        return this.layoutImage;
    }

    private void initializeLUTImage() {
        int[] lutData = ((DataBufferInt)this.lutImage.getRaster().getDataBuffer()).getData();
        int lutImageWidth = this.lutImage.getWidth();
        int lutImageHeight = this.lutImage.getHeight();
        double ratio = 255.0 / (double)lutImageWidth;
        int value = 0;
        for (int ctr = 0; ctr < lutImageHeight; ++ctr) {
            for (int ctrIn = 0; ctrIn < lutImageWidth; ++ctrIn) {
                value = (int)(ratio * (double)ctrIn + 0.5);
                lutData[ctr * lutImageWidth + ctrIn] = value | value << 8 | value << 16 | value << 24;
            }
        }
    }

    private Font makeColorBarFont(Graphics2D g2d, String string) {
        int ctr;
        double widthMax = this.imageWidthNum / 7 * 2;
        double heightMax = (double)this.layoutImage.getWidth() / (double)this.numCols / 6.0;
        for (ctr = 4; ctr < 1000; ++ctr) {
            Font aFont = new Font(FONT_TYPE, 1, ctr);
            TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            if ((double)textLayoutHeight >= heightMax || (double)textLayoutWidth >= widthMax) break;
        }
        return new Font(FONT_TYPE, 1, ctr - 1);
    }

    private Font makeColorBarLevelsFont(Graphics2D g2d, String string) {
        int ctr;
        double widthMax = (double)this.layoutImage.getWidth() / 7.0;
        double heightMax = (double)this.colorBarHeight / 2.0;
        for (ctr = 4; ctr < 1000; ++ctr) {
            Font aFont = new Font(FONT_TYPE, 1, ctr);
            TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            if ((double)textLayoutHeight >= heightMax || (double)textLayoutWidth >= widthMax) break;
        }
        return new Font(FONT_TYPE, 1, ctr - 1);
    }

    private Font makeColorBarStatFont(Graphics2D g2d, String string) {
        int ctr;
        double widthMax = (double)this.layoutImage.getWidth() / 7.0;
        double heightMax = (double)this.colorBarHeight / 2.0 * 0.75;
        for (ctr = 4; ctr < 1000; ++ctr) {
            Font aFont = new Font(FONT_TYPE, 1, ctr);
            TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            if ((double)textLayoutHeight >= heightMax || (double)textLayoutWidth >= widthMax) break;
        }
        return new Font(FONT_TYPE, 1, ctr - 1);
    }

    private Font makeFootnoteFont(Graphics2D g2d, String string) {
        int ctr;
        double widthMax = this.layoutImage.getWidth() - 12 * this.edgeOffset;
        double heightMax = (double)this.layoutImage.getWidth() / (double)this.numCols / 8.0;
        for (ctr = 4; ctr < 1000; ++ctr) {
            Font aFont = new Font(this.footnoteFontFamily, this.footnoteFontType, ctr);
            TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            if ((double)textLayoutHeight >= heightMax || (double)textLayoutWidth >= widthMax) break;
        }
        return new Font(this.footnoteFontFamily, this.footnoteFontType, ctr - 1);
    }

    private Font makeTextFont(Graphics2D g2d, String string) {
        int ctr;
        double widthMax = (double)this.layoutImage.getWidth() / (double)this.numCols;
        double heightMax = (double)this.layoutImage.getWidth() / (double)this.numCols / 12.0;
        for (ctr = 8; ctr < 1000; ++ctr) {
            Font aFont = new Font(FONT_TYPE, 1, ctr);
            TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            if ((double)textLayoutHeight >= heightMax || (double)textLayoutWidth >= widthMax) break;
        }
        return new Font(FONT_TYPE, 1, ctr - 1);
    }

    private Font makeTitleFont(Graphics2D g2d, String string) {
        int ctr;
        double widthMax = this.layoutImage.getWidth() - 4 * this.edgeOffset;
        double heightMax = (double)this.layoutImage.getWidth() / (double)this.numCols / 4.0;
        for (ctr = 8; ctr < 1000; ++ctr) {
            Font aFont = new Font(this.titleFontFamily, this.titleFontType, ctr);
            TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            if ((double)textLayoutHeight >= heightMax || (double)textLayoutWidth >= widthMax) break;
        }
        return new Font(this.titleFontFamily, this.titleFontType, ctr - 1);
    }

    private void processMarkupSlicesString() {
        StringTokenizer tokenizer = new StringTokenizer(this.markupPanel.getSliceText(), ",");
        int numTokens = tokenizer.countTokens();
        this.sliceStrings = new String[numTokens];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ((token = token.trim()).length() > 0) {
                if (token.charAt(0) == '\"') {
                    token = token.substring(1);
                }
                if (token.charAt(token.length() - 1) == '\"') {
                    token = token.substring(0, token.length() - 1);
                }
                token = token.trim();
            }
            this.sliceStrings[index++] = token;
        }
    }

    private void readMarkup() {
        this.titleColor = this.markupPanel.getTitleColor();
        this.footnoteColor = this.markupPanel.getFootnoteColor();
        this.labelColor = this.markupPanel.getSlicesColor();
        this.orientationColor = this.markupPanel.getOrientColor();
        this.backgroundColor = this.markupPanel.getBackgroundColor();
        this.colorBarTextColor = this.markupPanel.getBarsColor();
        this.titleJustification = this.markupPanel.getTitleLocation();
        this.footnoteJustification = this.markupPanel.getFootnoteLocation();
        int titleFontCode = this.markupPanel.getTitleFontCode();
        this.titleFontFamily = FONT_FAMILY.get(titleFontCode % 3);
        this.titleFontType = FONT_TYPES[titleFontCode / 3];
        int footnoteFontCode = this.markupPanel.getFootnoteFontCode();
        this.footnoteFontFamily = FONT_FAMILY.get(footnoteFontCode % 3);
        this.footnoteFontType = FONT_TYPES[footnoteFontCode / 3];
        this.showSlicesType = this.markupPanel.getShowSlicesType();
    }

    private void showFullPreview() {
        if (!this.fullPreviewInitialized) {
            int fullPreviewInitialWidth = this.getImage().getWidth();
            Dimension screenSize = DisplayUtils.findSizeOfDisplay(DisplayUtils.findCurrentDisplayIndex(this.viewer.getFrame()));
            Insets screenInsets = DisplayUtils.findInsetsOfDisplay(DisplayUtils.findCurrentDisplayIndex(this.viewer.getFrame()));
            int screenWidth = screenSize.width - (screenInsets.left + screenInsets.right);
            int fullPreviewInitialHeight = this.getImage().getHeight();
            int screenHeight = screenSize.height - (screenInsets.top + screenInsets.bottom);
            this.fullPreviewTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (fullPreviewInitialWidth >= screenWidth || fullPreviewInitialHeight >= screenHeight) {
                this.scale = 1.0;
                this.scale = fullPreviewInitialWidth - screenWidth > fullPreviewInitialHeight - screenHeight ? (double)screenWidth / (double)fullPreviewInitialWidth : (double)screenHeight / (double)fullPreviewInitialHeight;
                this.fullPreviewTransform.setTransform(this.scale, 0.0, 0.0, this.scale, 0.0, 0.0);
                fullPreviewInitialWidth = (int)(this.scale * (double)fullPreviewInitialWidth);
                fullPreviewInitialHeight = (int)(this.scale * (double)fullPreviewInitialHeight);
            }
            this.fullPreviewPanel = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.drawImage(Layout.this.getImage(), Layout.this.fullPreviewTransform, null);
                }
            };
            this.fullPreviewPanel.setPreferredSize(new Dimension(fullPreviewInitialWidth, fullPreviewInitialHeight));
            this.fullPreviewFrame = new JFrame();
            this.fullPreviewFrame.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    int keyCode = ke.getKeyCode();
                    if (keyCode == 27) {
                        Layout.this.fullPreviewFrame.setVisible(false);
                    }
                    if ((ke.isMetaDown() && Platform.MAC || ke.isControlDown() && (Platform.WINDOWS || Platform.UNIX)) && keyCode == 87) {
                        Layout.this.fullPreviewFrame.setVisible(false);
                    }
                }
            });
            this.fullPreviewFrame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ce) {
                    Layout.this.updateFullPreview(false);
                    Layout.this.fullPreviewFrame.repaint();
                }
            });
            this.fullPreviewFrame.setTitle("Full Preview (" + (int)(this.scale * 100.0) + "%)");
            this.fullPreviewFrame.getContentPane().add((Component)this.fullPreviewPanel, "Center");
            this.fullPreviewFrame.setDefaultCloseOperation(1);
            this.fullPreviewFrame.pack();
            this.fullPreviewFrame.setLocation(DisplayUtils.getCenterDialogLocation(this.viewer.getFrame(), this.fullPreviewFrame.getSize()));
            this.fullPreviewFrame.setVisible(true);
            this.fullPreviewFrame.toFront();
            this.fullPreviewInitialized = true;
        } else {
            this.fullPreviewFrame.setVisible(true);
        }
    }

    private void updateColorBarImageTransform(int index, int ofSoMany) {
        int emptySpace = this.layoutImage.getWidth() - this.layoutImage.getWidth() / 7 * ofSoMany;
        double colorBarImageDrawLocX = (double)(this.layoutImage.getWidth() / 7 * index) + (double)emptySpace / ((double)ofSoMany + 1.0) * (double)(index + 1);
        double colorBarImageDrawLocY = (double)this.layoutImage.getHeight() - (this.isUsingText ? (double)this.footnoteHeight : (double)this.edgeOffset / 2.0) - (double)(this.isUsingText ? this.colorBarTextHeight : 0) - ((double)this.colorBarHeight - (double)this.colorBarHeight * 0.5);
        this.colorBarImageTransform.setTransform(1.0, 0.0, 0.0, 1.0, colorBarImageDrawLocX, colorBarImageDrawLocY);
    }

    private void updateEnabledItems() {
        this.isUsingText = this.addText.isSelected();
        this.isUsingColorBars = this.addColorBar.isSelected();
        this.title.setEnabled(this.isUsingText);
        this.titleLabel.setEnabled(this.isUsingText);
        this.description.setEnabled(this.isUsingText);
        this.desLabel.setEnabled(this.isUsingText);
        this.overlaysLabel.setEnabled(this.isUsingText && this.isUsingColorBars);
        this.overlaysBox.setEnabled(this.isUsingText && this.isUsingColorBars);
        this.overlayName.setEnabled(this.isUsingText && this.isUsingColorBars);
        this.statName.setEnabled(this.isUsingText && this.isUsingColorBars);
    }

    private void updateFromTextFields() {
        try {
            this.startSlice = Integer.parseInt(this.start.getText());
            if (this.startSlice < 0 || this.startSlice > this.numSlices - 1) {
                throw new IllegalArgumentException();
            }
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            this.startSlice = 0;
            this.start.setText("0");
        }
        catch (IllegalArgumentException ex) {
            AppLogger.info((Throwable)ex);
            this.startSlice = 0;
            this.start.setText("0");
        }
        try {
            this.skipNum = Integer.parseInt(this.skip.getText());
            if (this.skipNum < 0 || this.skipNum >= this.numSlices) {
                throw new IllegalArgumentException();
            }
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            this.skipNum = 0;
            this.skip.setText("0");
        }
        catch (IllegalArgumentException ex) {
            AppLogger.info((Throwable)ex);
            this.skipNum = 0;
            this.skip.setText("0");
        }
        try {
            int numRowsNew = Integer.parseInt(this.rows.getText());
            if (numRowsNew < 1) {
                throw new IllegalArgumentException();
            }
            this.numRows = numRowsNew;
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            this.rows.setText(String.valueOf(this.numRows));
        }
        catch (IllegalArgumentException ex) {
            AppLogger.info((Throwable)ex);
            this.rows.setText(String.valueOf(this.numRows));
        }
        try {
            int numColsNew = Integer.parseInt(this.cols.getText());
            if (numColsNew < 1) {
                throw new IllegalArgumentException();
            }
            this.numCols = numColsNew;
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            this.cols.setText(String.valueOf(this.numCols));
        }
        catch (IllegalArgumentException ex) {
            AppLogger.info((Throwable)ex);
            this.cols.setText(String.valueOf(this.numCols));
        }
        try {
            int imageWidthNew = Integer.parseInt(this.imageWidth.getText());
            if (imageWidthNew < 1 || imageWidthNew >= 12000) {
                throw new IllegalArgumentException();
            }
            this.imageWidthNum = imageWidthNew;
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
            this.imageWidth.setText(String.valueOf(this.imageWidthNum));
        }
        catch (IllegalArgumentException ex) {
            AppLogger.info((Throwable)ex);
            this.imageWidth.setText(String.valueOf(this.imageWidthNum));
        }
    }

    private void updateFullPreview() {
        this.updateFullPreview(true);
    }

    private void updateFullPreview(boolean resizeFrame) {
        double heightScale;
        int frameSizeWidth = this.fullPreviewPanel.getSize().width;
        int frameSizeHeight = this.fullPreviewPanel.getSize().height;
        double widthScale = (double)frameSizeWidth / (double)this.getImage().getWidth();
        this.scale = widthScale < (heightScale = (double)frameSizeHeight / (double)this.getImage().getHeight()) ? widthScale : heightScale;
        if (resizeFrame) {
            this.fullPreviewFrame.setSize((int)((double)this.getImage().getWidth() * this.scale), 18 + (int)((double)this.getImage().getHeight() * this.scale));
        }
        this.fullPreviewTransform.setTransform(this.scale, 0.0, 0.0, this.scale, 0.0, 0.0);
        this.fullPreviewFrame.setTitle("Full Preview: " + this.viewer.getManagerTitle() + " (" + (int)(this.scale * 100.0) + "%)");
    }

    private void updateImage(ProgressMeter progress) {
        boolean imageBlanked = false;
        int imageHeightNum = (int)((double)this.imageWidthNum / (double)this.numCols * (double)this.numRows);
        this.labelHeight = (int)((double)this.imageWidthNum / (double)this.numCols / 8.0);
        this.footnoteHeight = (int)((double)this.imageWidthNum / (double)this.numCols / 4.0);
        int titleHeight = (int)((double)this.imageWidthNum / (double)this.numCols / 2.0);
        this.colorBarHeight = (int)((double)this.imageWidthNum / (double)this.numCols / 4.0);
        this.colorBarTextHeight = (int)((double)this.imageWidthNum / (double)this.numCols / 4.0);
        if (this.isUsingSliceLabelRow()) {
            imageHeightNum += this.numRows * this.labelHeight;
        }
        if (this.isUsingText) {
            imageHeightNum += titleHeight + this.footnoteHeight;
        }
        if (this.isUsingColorBars) {
            imageHeightNum += this.colorBarHeight;
            if (this.isUsingText) {
                imageHeightNum += this.colorBarTextHeight;
            }
        }
        this.layoutImage = new BufferedImage(this.imageWidthNum, imageHeightNum, 1);
        this.updateLUTImages();
        this.initializeLUTImage();
        this.edgeOffset = (int)((double)this.layoutImage.getWidth() * 0.015);
        if (this.edgeOffset < 12) {
            this.edgeOffset = 12;
        }
        if (!this.backgroundColor.equals(Color.BLACK)) {
            this.blankImage(this.layoutImage, this.backgroundColor);
        }
        Graphics2D imageGraphics = (Graphics2D)this.layoutImage.getGraphics();
        imageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Font titleFont = null;
        Font footnoteFont = null;
        Font textFont = this.makeTextFont(imageGraphics, this.sliceLabel + this.formatter.format((double)(this.sliceOffset - this.numSlices / 2) * this.sliceMultiplier));
        if (this.isUsingText) {
            if (this.title.getText() != null && this.title.getText().length() > 0) {
                titleFont = this.makeTitleFont(imageGraphics, this.title.getText());
                if (titleFont.getSize() > textFont.getSize() * 2) {
                    titleFont = new Font(this.titleFontFamily, this.titleFontType, textFont.getSize() * 2);
                }
                this.findTitleTextLocation(imageGraphics, this.title.getText(), titleFont);
                imageGraphics.setFont(titleFont);
                imageGraphics.setColor(this.titleColor);
                imageGraphics.drawString(this.title.getText(), this.titleDrawLocX, this.titleDrawLocY);
            }
            boolean showingFootnote = false;
            if (this.description.getText() != null && this.description.getText().length() > 0) {
                showingFootnote = true;
                footnoteFont = this.makeFootnoteFont(imageGraphics, this.description.getText());
                if (footnoteFont.getSize() > textFont.getSize()) {
                    footnoteFont = textFont;
                }
                this.findFootnoteLocation(imageGraphics, this.description.getText(), footnoteFont);
                imageGraphics.setFont(footnoteFont);
                imageGraphics.setColor(this.footnoteColor);
                imageGraphics.drawString(this.description.getText(), this.footnoteDrawLocX, this.footnoteDrawLocY);
            }
            Font orientationFont = textFont;
            boolean isSagittal = this.viewer.getSliceDirection() == 2;
            boolean isRadiologicalMode = this.mango.isRadiologicalMode();
            String westText = "";
            String eastText = "";
            if (isSagittal) {
                westText = "A";
                eastText = "P";
            } else if (isRadiologicalMode) {
                westText = "R";
                eastText = "L";
            } else {
                westText = "L";
                eastText = "R";
            }
            imageGraphics.setFont(orientationFont);
            imageGraphics.setColor(this.orientationColor);
            this.findOrientationLabelLocation(imageGraphics, westText, orientationFont);
            imageGraphics.drawString(westText, this.orientationDrawLocXL, showingFootnote ? this.footnoteDrawLocY : this.orientationDrawLocY);
            this.findOrientationLabelLocation(imageGraphics, eastText, orientationFont);
            imageGraphics.drawString(eastText, this.orientationDrawLocXR, showingFootnote ? this.footnoteDrawLocY : this.orientationDrawLocY);
        }
        imageGraphics.setFont(textFont);
        int meterValue = 0;
        int currentTimepoint = this.viewer.getCurrentVolume().getCurrentSeriesPoint();
        List allControllers = this.mango.getAllVolumeManagers();
        for (int ctrRows = 0; ctrRows < this.numRows; ++ctrRows) {
            for (int ctrCols = 0; ctrCols < this.numCols; ++ctrCols) {
                int sliceNum = (ctrRows * this.numCols + ctrCols) * (this.skipNum + 1) + this.startSlice;
                if (sliceNum < this.numSlices) {
                    if (this.acrossTimeButton.isSelected()) {
                        this.viewer.getCurrentVolume().setCurrentSeriesPoint(sliceNum);
                        this.sliceImage = this.viewer.getMainImage(this.sliceImage, this.viewer.getSliceNumber(), this.onlyImageBox.isSelected());
                    } else if (this.acrossViewersButton.isSelected()) {
                        this.blankImage(this.sliceImage);
                        this.sliceImage = ((VolumeManager)allControllers.get(sliceNum)).getMainImage(this.sliceImage, ((VolumeManager)allControllers.get(sliceNum)).getSliceNumber(), this.onlyImageBox.isSelected());
                    } else {
                        this.sliceImage = this.viewer.getMainImage(this.sliceImage, sliceNum, this.onlyImageBox.isSelected());
                    }
                } else if (!imageBlanked) {
                    this.blankImage(this.sliceImage);
                    imageBlanked = true;
                }
                this.updateSliceTransform(ctrCols, ctrRows, this.sliceImage);
                imageGraphics.drawImage(this.sliceImage, this.sliceTransform, null);
                if (this.showSlicesType == 2) {
                    textFont = this.findTextFont(imageGraphics, this.sliceStrings);
                } else if (this.acrossViewersButton.isSelected()) {
                    String[] allViewerNames = new String[allControllers.size()];
                    for (int ctr = 0; ctr < allControllers.size(); ++ctr) {
                        allViewerNames[ctr] = FileUtilities.getName((URI)((VolumeManager)allControllers.get(ctr)).getLoadedURI());
                    }
                    textFont = this.findTextFont(imageGraphics, allViewerNames);
                }
                if (this.isUsingSliceLabels) {
                    String sliceString;
                    imageGraphics.setFont(textFont);
                    if (this.showSlicesType == 2) {
                        sliceString = "";
                        int sliceStringIndex = ctrRows * this.numCols + ctrCols;
                        if (sliceStringIndex < this.sliceStrings.length) {
                            sliceString = this.sliceStrings[sliceStringIndex];
                        }
                        this.updateSliceNumberLocation(ctrCols, ctrRows, imageGraphics, sliceString, textFont);
                        imageGraphics.setColor(this.labelColor);
                        imageGraphics.drawString(sliceString, this.sliceNumberDrawLocX, this.sliceNumberDrawLocY);
                    } else if (this.showSlicesType == 0 || this.showSlicesType == 1 && (!this.isReverse && ctrCols == 0 || this.isReverse && ctrCols == this.numCols - 1) || this.showSlicesType == 1 && this.worldMode && (double)(this.sliceOffset - sliceNum) * this.sliceMultiplier == 0.0 || this.showSlicesType == 2) {
                        sliceString = null;
                        if (this.acrossTimeButton.isSelected()) {
                            sliceString = this.formatter.format((double)(this.sliceOffset - sliceNum) * this.sliceMultiplier) + this.sliceLabel;
                        } else if (this.acrossViewersButton.isSelected()) {
                            if (sliceNum < allControllers.size()) {
                                sliceString = FileUtilities.getName((URI)((VolumeManager)allControllers.get(sliceNum)).getLoadedURI());
                                if (sliceString.indexOf(46) != -1) {
                                    sliceString = sliceString.substring(0, sliceString.lastIndexOf(46));
                                }
                            } else {
                                sliceString = "";
                            }
                        } else {
                            sliceString = this.sliceLabel + this.formatter.format((double)(this.sliceOffset - sliceNum) * this.sliceMultiplier);
                        }
                        this.updateSliceNumberLocation(ctrCols, ctrRows, imageGraphics, sliceString, textFont);
                        imageGraphics.setColor(this.labelColor);
                        imageGraphics.drawString(sliceString, this.sliceNumberDrawLocX, this.sliceNumberDrawLocY);
                    }
                }
                progress.setValue(meterValue++);
            }
        }
        this.viewer.getCurrentVolume().setCurrentSeriesPoint(currentTimepoint);
        if (this.isUsingColorBars) {
            int numOverlays = 0;
            ScreenImage[] mangoOverlays = this.data.getOverlayScreenImages();
            if (mangoOverlays != null) {
                for (int ctr = 0; ctr < mangoOverlays.length; ++ctr) {
                    if (mangoOverlays[ctr].isHidden()) continue;
                    ++numOverlays;
                }
            }
            if (numOverlays > 3) {
                numOverlays = 3;
            }
            int numImages = numOverlays > 0 ? numOverlays : 1;
            Font colorBarLevelsFont = this.makeColorBarLevelsFont(imageGraphics, "123");
            Font tempFont = null;
            Font smallestFont = null;
            for (int ctr = 0; ctr < numImages; ++ctr) {
                tempFont = null;
                if (this.overlayNames[ctr] != null && this.overlayNames[ctr].length() > 0) {
                    tempFont = this.makeColorBarFont(imageGraphics, this.overlayNames[ctr]);
                }
                if (tempFont == null || smallestFont != null && tempFont.getSize() >= smallestFont.getSize()) continue;
                smallestFont = tempFont;
            }
            Font overlayFont = smallestFont;
            if (overlayFont == null) {
                overlayFont = textFont;
            }
            smallestFont = null;
            for (int ctr = 0; ctr < numImages; ++ctr) {
                tempFont = null;
                if (this.statNames[ctr] != null && this.statNames[ctr].length() > 0) {
                    tempFont = this.makeColorBarStatFont(imageGraphics, this.statNames[ctr]);
                }
                if (tempFont == null || smallestFont != null && tempFont.getSize() >= smallestFont.getSize()) continue;
                smallestFont = tempFont;
            }
            Font colorBarStatFont = smallestFont;
            if (colorBarStatFont == null) {
                colorBarStatFont = textFont;
            }
            if (numOverlays == 0) {
                this.updateColorBarImageTransform(0, 1);
                this.filterLUTImage(0);
                imageGraphics.drawImage(this.lutImageFiltered, this.colorBarImageTransform, null);
                if (this.isUsingText) {
                    imageGraphics.setColor(this.colorBarTextColor);
                    imageGraphics.setFont(overlayFont);
                    this.findColorBarTextLocation(imageGraphics, this.overlayNames[0], overlayFont, 0, 1);
                    imageGraphics.drawString(this.overlayNames[0], this.colorBarTextDrawLocX, this.colorBarTextDrawLocY);
                    imageGraphics.setFont(colorBarLevelsFont);
                    this.findColorBarMinTextLocation(imageGraphics, this.formatter.format(this.data.getBaseScreenImage().getScreenMin()), colorBarLevelsFont, 0, 1);
                    imageGraphics.drawString(this.formatter.format(this.data.getBaseScreenImage().getScreenMin()), this.colorBarMinTextDrawLocX, this.colorBarMinTextDrawLocY);
                    this.findColorBarMaxTextLocation(this.formatter.format(this.data.getBaseScreenImage().getScreenMax()), 0, 1);
                    imageGraphics.drawString(this.formatter.format(this.data.getBaseScreenImage().getScreenMax()), this.colorBarMaxTextDrawLocX, this.colorBarMaxTextDrawLocY);
                    imageGraphics.setFont(colorBarStatFont);
                    imageGraphics.setColor(Color.BLACK);
                    this.findColorBarStatTextLocation(imageGraphics, this.statNames[0], colorBarStatFont, 0, 1);
                    imageGraphics.drawString(this.statNames[0], this.colorBarStatsTextDrawLocX, this.colorBarStatsTextDrawLocY);
                }
            } else {
                int count = 0;
                for (int ctr = 0; ctr < numOverlays; ++ctr) {
                    if (mangoOverlays[ctr].isHidden()) continue;
                    this.updateColorBarImageTransform(count, numOverlays);
                    this.filterLUTImage(ctr + 1);
                    imageGraphics.drawImage(this.lutImageFiltered, this.colorBarImageTransform, null);
                    if (this.isUsingText) {
                        imageGraphics.setColor(this.colorBarTextColor);
                        imageGraphics.setFont(overlayFont);
                        this.findColorBarTextLocation(imageGraphics, this.overlayNames[ctr], overlayFont, count, numOverlays);
                        imageGraphics.drawString(this.overlayNames[ctr], this.colorBarTextDrawLocX, this.colorBarTextDrawLocY);
                        imageGraphics.setFont(colorBarLevelsFont);
                        this.findColorBarMinTextLocation(imageGraphics, this.formatter.format(this.data.getOverlayScreenImages()[ctr].getScreenMin()), colorBarLevelsFont, count, numOverlays);
                        imageGraphics.drawString(this.formatter.format(this.data.getOverlayScreenImages()[ctr].getScreenMin()), this.colorBarMinTextDrawLocX, this.colorBarMinTextDrawLocY);
                        this.findColorBarMaxTextLocation(this.formatter.format(this.data.getOverlayScreenImages()[ctr].getScreenMax()), count, numOverlays);
                        imageGraphics.drawString(this.formatter.format(this.data.getOverlayScreenImages()[ctr].getScreenMax()), this.colorBarMaxTextDrawLocX, this.colorBarMaxTextDrawLocY);
                        imageGraphics.setFont(colorBarStatFont);
                        imageGraphics.setColor(Color.BLACK);
                        this.findColorBarStatTextLocation(imageGraphics, this.statNames[ctr], colorBarStatFont, count, numOverlays);
                        imageGraphics.drawString(this.statNames[ctr], this.colorBarStatsTextDrawLocX, this.colorBarStatsTextDrawLocY);
                    }
                    ++count;
                }
            }
        }
        this.viewer.updateViewer();
    }

    private final void updateLayout(boolean silent) {
        if (silent) {
            this.doUpdateLayout();
        } else {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    Thread workThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Layout.this.doUpdateLayout();
                        }
                    });
                    workThread.start();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doUpdateLayout() {
        block26: {
            ProgressMeter progress = null;
            this.isWorking = true;
            try {
                this.readMarkup();
                if (this.showSlicesType == 2) {
                    this.processMarkupSlicesString();
                }
                this.sliceImage = this.viewer.getMainImage(this.onlyImageBox.isSelected());
                int sliceDirectionNew = this.viewer.getSliceDirection();
                this.worldMode = this.viewer.isWorldMode();
                Coordinate origin = this.data.getBaseScreenImage().getImageVolume().getOrigin();
                if (!this.worldMode) {
                    this.isIndexLabel = true;
                    this.sliceLabel = "";
                    this.sliceOffset = 0;
                    this.sliceMultiplier = -1.0;
                } else {
                    this.isIndexLabel = false;
                    if (this.acrossTimeButton.isSelected()) {
                        this.sliceLabel = " s";
                        this.sliceOffset = 0;
                        this.sliceMultiplier = -1.0 * this.data.getBaseScreenImage().getImageVolume().getVoxelDimensions().getTR();
                    } else if (sliceDirectionNew == 0) {
                        this.sliceLabel = "z = ";
                        this.sliceOffset = origin.zInt;
                        this.sliceMultiplier = this.data.getBaseScreenImage().getImageVolume().getVoxelDimensions().getZSize();
                    } else if (sliceDirectionNew == 1) {
                        this.sliceLabel = "y = ";
                        this.sliceOffset = origin.yInt;
                        this.sliceMultiplier = this.data.getBaseScreenImage().getImageVolume().getVoxelDimensions().getYSize();
                    } else {
                        this.sliceLabel = "x = ";
                        this.sliceOffset = origin.xInt;
                        this.sliceMultiplier = this.data.getBaseScreenImage().getImageVolume().getVoxelDimensions().getXSize() * -1.0;
                    }
                }
                this.updateNumSlices(sliceDirectionNew);
                progress = this.viewer.makeProgressMeter();
                progress.setDescription("Making Layout");
                progress.start(0, 0, this.numRows * this.numCols + 1);
                this.updateFromTextFields();
                this.previewTransform = new AffineTransform();
                this.sliceTransform = new AffineTransform();
                this.colorBarImageTransform = new AffineTransform();
                this.updateImage(progress);
                this.updatePreviewTransform();
                if (this.frame != null) {
                    this.frame.repaint();
                }
                if (this.fullPreviewInitialized) {
                    this.updateFullPreview();
                    this.fullPreviewFrame.repaint();
                }
                this.markupPanel.updateSlicesText(this.getMarkupSlicesString());
                if (progress == null) break block26;
            }
            catch (Throwable throwable) {
                if (progress != null) {
                    progress.setValue(progress.getMax());
                }
                if (EventQueue.isDispatchThread()) {
                    this.viewer.updateViewer();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                Layout.this.viewer.updateViewer();
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        AppLogger.error((Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        AppLogger.error((Throwable)ex);
                    }
                }
                this.isWorking = false;
                if (this.frame != null) {
                    this.frame.repaint();
                }
                throw throwable;
            }
            progress.setValue(progress.getMax());
        }
        if (EventQueue.isDispatchThread()) {
            this.viewer.updateViewer();
        } else {
            try {
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        this.isWorking = false;
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    private void updateLUTImages() {
        this.lutImage = new BufferedImage(this.imageWidthNum / 7, this.colorBarHeight / 2, 2);
        this.lutImageFiltered = new BufferedImage(this.imageWidthNum / 7, this.colorBarHeight / 2, 2);
    }

    private void updateNumSlices(int sliceDirectionNew) {
        this.numSlices = this.acrossTimeButton.isSelected() ? this.data.getBaseScreenImage().getImageVolume().getImageDimensions().getTimepoints() : (this.acrossViewersButton.isSelected() ? this.mango.getAllVolumeManagers().size() : (sliceDirectionNew == 0 ? this.data.getBaseScreenImage().getImageVolume().getImageDimensions().getZ() : (sliceDirectionNew == 1 ? this.data.getBaseScreenImage().getImageVolume().getImageDimensions().getY() : this.data.getBaseScreenImage().getImageVolume().getImageDimensions().getX())));
    }

    private final void updateOverlayBox() {
        int numOverlays;
        this.freezeOverlayBoxState = true;
        this.overlaysBox.removeAllItems();
        ScreenImage[] mangoOverlays = this.data.getOverlayScreenImages();
        int n = numOverlays = mangoOverlays != null ? mangoOverlays.length : 0;
        if (numOverlays > 3) {
            numOverlays = 3;
        }
        if (numOverlays == 0) {
            this.overlayNames = new String[1];
            this.statNames = new String[1];
            this.overlayNames[0] = FileUtilities.getName((URI)this.data.getBaseScreenImage().getURI());
            this.statNames[0] = STAT_NAME_DEFAULT;
            this.overlaysBox.addItem("Base Image");
        } else {
            this.overlayNames = new String[3];
            this.statNames = new String[3];
            for (int ctr = 0; ctr < numOverlays; ++ctr) {
                this.overlayNames[ctr] = FileUtilities.getName((URI)this.data.getOverlayScreenImages()[ctr].getURI());
                this.statNames[ctr] = STAT_NAME_DEFAULT;
                this.overlaysBox.addItem("Overlay " + (ctr + 1));
            }
        }
        this.overlaysBox.setSelectedIndex(0);
        this.freezeOverlayBoxState = false;
    }

    private void updateOverlayNameBox() {
        int index = this.overlaysBox.getSelectedIndex();
        this.overlayName.setText(this.overlayNames[index]);
        this.statName.setText(this.statNames[index]);
    }

    private void updatePreviewTransform() {
        double shrinkPercent = 0.0;
        if (this.layoutImage.getWidth() > this.layoutImage.getHeight()) {
            shrinkPercent = 175.0 / (double)this.layoutImage.getWidth();
            double startY = (double)(this.layoutImage.getWidth() - this.layoutImage.getHeight()) * shrinkPercent / 2.0;
            this.previewTransform.setTransform(shrinkPercent, 0.0, 0.0, shrinkPercent, 10.0, startY);
        } else {
            shrinkPercent = 175.0 / (double)this.layoutImage.getHeight();
            double startX = 10.0 + (double)(this.layoutImage.getHeight() - this.layoutImage.getWidth()) * shrinkPercent / 2.0;
            this.previewTransform.setTransform(shrinkPercent, 0.0, 0.0, shrinkPercent, startX, 5.0);
        }
    }

    private void updateSliceNumberLocation(int currentColVal, int currentRowVal, Graphics2D g2d, String stringVal, Font aFont) {
        int currentCol = currentColVal;
        int currentRow = currentRowVal;
        String string = stringVal;
        if (string == null || string.length() == 0) {
            string = " ";
        }
        if (this.isReverse) {
            currentCol = this.numCols - 1 - currentCol;
            currentRow = this.numRows - 1 - currentRow;
        }
        if (this.acrossViewersButton.isSelected() || this.markupPanel.isOtherSliceText()) {
            double sliceSize = (double)this.layoutImage.getWidth() / (double)this.numCols;
            boolean hasTitle = this.addText.isSelected();
            TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            textLayout = new TextLayout(SPECIAL_MAX_Y_EXTENT_STRING, aFont, g2d.getFontRenderContext());
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            this.sliceNumberDrawLocX = (int)((double)currentCol * sliceSize + (sliceSize - (double)textLayoutWidth) / 2.0);
            this.sliceNumberDrawLocY = (int)((double)(currentRow + 1) * (sliceSize + (double)this.labelHeight) - (double)(this.labelHeight - textLayoutHeight) + (hasTitle ? sliceSize / 2.0 : 0.0));
        } else {
            TextLayout textLayout = new TextLayout(string, aFont, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            double sliceSize = (double)this.layoutImage.getWidth() / (double)this.numCols;
            boolean hasTitle = this.addText.isSelected();
            if (this.isIndexLabel) {
                this.sliceNumberDrawLocX = (int)((double)currentCol * sliceSize + 4.0);
                this.sliceNumberDrawLocY = (int)((double)currentRow * sliceSize + (double)textLayoutHeight + (hasTitle ? sliceSize / 2.0 : 0.0) + 4.0);
            } else {
                this.sliceNumberDrawLocX = (int)((double)currentCol * sliceSize + (sliceSize - (double)textLayoutWidth) / 2.0);
                this.sliceNumberDrawLocY = (int)((double)(currentRow + 1) * (sliceSize + (double)this.labelHeight) - (double)(this.labelHeight - textLayoutHeight) / 2.0 + (hasTitle ? sliceSize / 2.0 : 0.0));
            }
        }
    }

    private void updateSliceTransform(int currentColVal, int currentRowVal, BufferedImage sliceImage) {
        double sliceSize = (double)this.layoutImage.getWidth() / (double)this.numCols;
        double shrinkPercent = sliceSize / (double)sliceImage.getWidth();
        int currentCol = currentColVal;
        int currentRow = currentRowVal;
        boolean hasTitle = this.addText.isSelected();
        if (this.isReverse) {
            currentCol = this.numCols - 1 - currentCol;
            currentRow = this.numRows - 1 - currentRow;
        }
        this.sliceTransform.setTransform(shrinkPercent, 0.0, 0.0, shrinkPercent, (double)currentCol * sliceSize, (double)currentRow * sliceSize + (double)(this.isUsingSliceLabelRow() ? currentRow * this.labelHeight : 0) + (hasTitle ? sliceSize / 2.0 : 0.0));
    }

    @Override
    public void sliceDirectionChanged(int sliceDirection) {
        this.updateNumSlices(sliceDirection);
        Dimension initialDims = this.findInitialDimensions(this.numSlices);
        this.numCols = (int)initialDims.getWidth();
        this.numRows = (int)initialDims.getHeight();
        this.rows.setText(String.valueOf(this.numRows));
        this.cols.setText(String.valueOf(this.numCols));
        this.doUpdate(false);
    }
}

