/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo;

import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo.HeaderPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.imageinfo.SummaryPanel;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ImageInfoDialog
extends JFrame
implements ViewerAssociated,
ComponentListener {
    private JTabbedPane allTabs;
    private JTabbedPane singleTab;
    private final SliceViewer viewer;
    private static final String DESCRIPTION = "Image Info";
    private static final long serialVersionUID = 1L;
    public static final Dimension START_SIZE = new Dimension(450, 510);
    public static final int SCROLL_INCREMENT = 20;
    public static final String TEXT_SUMMARY = "Summary";
    public static final String TEXT_HEADER = "Header";

    public ImageInfoDialog(SliceViewer viewer, ScreenVolume screenVol) {
        this.viewer = viewer;
        this.createUI(screenVol);
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        if (this.allTabs != null) {
            int tabCount = this.allTabs.getTabCount();
            for (int ctr = 0; ctr < tabCount; ++ctr) {
                JTabbedPane tp = (JTabbedPane)this.allTabs.getComponentAt(ctr);
                SummaryPanel sp = (SummaryPanel)tp.getComponentAt(0);
                sp.getTextArea().setSize(this.getSize().width - 50, this.getSize().height - 50);
                HeaderPanel hp = (HeaderPanel)tp.getComponentAt(1);
                hp.getTextArea().setSize(this.getSize().width - 50, this.getSize().height - 50);
            }
        } else if (this.singleTab != null) {
            SummaryPanel sp = (SummaryPanel)this.singleTab.getComponentAt(0);
            sp.getTextArea().setSize(this.getSize().width - 50, this.getSize().height - 50);
            HeaderPanel hp = (HeaderPanel)this.singleTab.getComponentAt(1);
            hp.getTextArea().setSize(this.getSize().width - 50, this.getSize().height - 50);
        }
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    @Override
    public void setVisible(boolean bool) {
        this.updateInfo(this.viewer.getScreenVolume());
        super.setVisible(bool);
        this.requestFocus();
        this.toFront();
    }

    private void createUI(ScreenVolume screenVol) {
        this.setTitle("Info: " + this.viewer.getImageTitle());
        this.updateInfo(screenVol);
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.addComponentListener(this);
        this.getContentPane().setPreferredSize(START_SIZE);
        this.setBackground(MangoStyle.COLOR_BACKGROUND);
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
        this.setVisible(true);
        this.viewer.associateWindow(this);
    }

    private void updateInfo(ScreenVolume screenVol) {
        boolean hasOverlays = this.viewer.hasOverlays();
        boolean hasROI = this.viewer.getROIManager().getLoadedROIVolume() != null;
        JTabbedPane overlayToSelect = null;
        this.singleTab = null;
        this.allTabs = null;
        if (hasOverlays || hasROI) {
            this.allTabs = new JTabbedPane();
            JTabbedPane tabbedPaneMain = new JTabbedPane();
            SummaryPanel summaryPanelMain = new SummaryPanel(this.viewer, this.viewer.getBaseScreenVolume().getURI(), this.viewer.getBaseScreenVolume().getVolume());
            final HeaderPanel headerPanelMain = new HeaderPanel(this.viewer, this.viewer.getBaseScreenVolume().getVolume());
            tabbedPaneMain.addTab(TEXT_SUMMARY, summaryPanelMain);
            tabbedPaneMain.addTab(TEXT_HEADER, headerPanelMain);
            tabbedPaneMain.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    if (!headerPanelMain.hasBeenViewed()) {
                        headerPanelMain.getScrollPane().getVerticalScrollBar().setValue(0);
                        headerPanelMain.resetLastFound();
                        headerPanelMain.setHasBeenViewed(true);
                    }
                }
            });
            this.allTabs.addTab("Image", tabbedPaneMain);
            if (hasROI) {
                JTabbedPane tabbedPane = new JTabbedPane();
                SummaryPanel summaryPanel = new SummaryPanel(this.viewer, this.viewer.getROIManager().getLoadedROIVolume().getImageFile(), this.viewer.getROIManager().getLoadedROIVolume());
                final HeaderPanel headerPanel = new HeaderPanel(this.viewer, this.viewer.getROIManager().getLoadedROIVolume());
                tabbedPane.addTab(TEXT_SUMMARY, summaryPanel);
                tabbedPane.addTab(TEXT_HEADER, headerPanel);
                tabbedPane.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent ce) {
                        if (!headerPanel.hasBeenViewed()) {
                            headerPanel.getScrollPane().getVerticalScrollBar().setValue(0);
                            headerPanel.resetLastFound();
                            headerPanel.setHasBeenViewed(true);
                        }
                    }
                });
                this.allTabs.addTab("ROI", tabbedPane);
            }
            if (hasOverlays) {
                ScreenVolume[] allOverlays = this.viewer.getOverlayManager().getAllOverlays();
                for (int ctr = 0; ctr < 8; ++ctr) {
                    if (allOverlays[ctr] == null) continue;
                    JTabbedPane tabbedPane = new JTabbedPane();
                    SummaryPanel summaryPanel = new SummaryPanel(this.viewer, allOverlays[ctr].getURI(), allOverlays[ctr].getVolume());
                    final HeaderPanel headerPanel = new HeaderPanel(this.viewer, allOverlays[ctr].getVolume());
                    tabbedPane.addTab(TEXT_SUMMARY, summaryPanel);
                    tabbedPane.addTab(TEXT_HEADER, headerPanel);
                    tabbedPane.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent ce) {
                            if (!headerPanel.hasBeenViewed()) {
                                headerPanel.getScrollPane().getVerticalScrollBar().setValue(0);
                                headerPanel.resetLastFound();
                                headerPanel.setHasBeenViewed(true);
                            }
                        }
                    });
                    if (screenVol == allOverlays[ctr]) {
                        overlayToSelect = tabbedPane;
                    }
                    this.allTabs.addTab("Overlay", tabbedPane);
                }
            }
        } else {
            this.singleTab = new JTabbedPane();
            SummaryPanel summaryPanel = new SummaryPanel(this.viewer, screenVol.getURI(), screenVol.getVolume());
            final HeaderPanel headerPanel = new HeaderPanel(this.viewer, screenVol.getVolume());
            this.singleTab.addTab(TEXT_SUMMARY, summaryPanel);
            this.singleTab.addTab(TEXT_HEADER, headerPanel);
            this.singleTab.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    if (!headerPanel.hasBeenViewed()) {
                        headerPanel.getScrollPane().getVerticalScrollBar().setValue(0);
                        headerPanel.resetLastFound();
                        headerPanel.setHasBeenViewed(true);
                    }
                }
            });
        }
        if (this.allTabs != null && overlayToSelect != null) {
            this.allTabs.setSelectedComponent(overlayToSelect);
        }
        this.getContentPane().removeAll();
        if (this.allTabs != null) {
            this.getContentPane().add((Component)this.allTabs, "Center");
        } else {
            this.getContentPane().add((Component)this.singleTab, "Center");
        }
        this.setSize(START_SIZE);
        this.setLocation(DisplayUtils.getCenterDialogLocationRelative(this.viewer.getViewerContainer(), this.getSize()));
    }
}

