/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.histogram;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoSquareButton;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.transparencyslider.MangoTransparencySlider;
import edu.uthscsa.ric.mango.components.transparencyslider.MangoTransparencySliderUser;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.histogram.HistogramPanel;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.operations.histogram.HistogramOp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class HistogramTool
extends JFrame
implements ActionListener,
MangoTransparencySliderUser,
ViewerAssociated {
    private HistogramPanel histogram;
    private JButton generateROIButton;
    private JCheckBox excludeZeroBox;
    private JCheckBox integerBox;
    private JCheckBox useROIBox;
    private JComboBox<String> showBox;
    private JTextField binCount;
    private JTextField userMax;
    private JTextField userMin;
    private final Mango mango;
    private final SliceViewer viewer;
    private MangoTransparencySlider sliderTransparency;
    private final boolean runAuto;
    private static final long serialVersionUID = 1L;
    public static final Dimension HISTOGRAM_SIZE = new Dimension(350, 210);
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(1);
    public static final String DESCRIPTION = "Histogram";
    public static final int MINIMUM_HEIGHT = 375;
    public static final int MINIMUM_WIDTH = 550;

    public HistogramTool(Mango mango, SliceViewer viewer, boolean runAuto) {
        this.mango = mango;
        this.viewer = viewer;
        this.runAuto = runAuto;
        this.createUI();
    }

    private void createUI() {
        this.histogram = this.viewer.getHistogram();
        this.histogram.setParentFrame(this);
        this.binCount = new MangoTextField(String.valueOf(this.histogram.getNumBins()), 4);
        this.binCount.setMaximumSize(this.binCount.getPreferredSize());
        this.userMin = new MangoTextField(String.valueOf(this.histogram.getBinsMin()), 5);
        this.userMin.setMaximumSize(this.userMin.getPreferredSize());
        this.userMax = new MangoTextField(String.valueOf(this.histogram.getBinsMax()), 5);
        this.userMax.setMaximumSize(this.userMax.getPreferredSize());
        JLabel binCountLabel = new JLabel("Bins");
        JLabel userMinLabel = new JLabel("Min");
        JLabel userMaxLabel = new JLabel("Max");
        this.useROIBox = new JCheckBox("Within ROI");
        this.useROIBox.setVerticalTextPosition(1);
        this.useROIBox.setHorizontalTextPosition(0);
        this.useROIBox.setActionCommand("use roi");
        this.useROIBox.addActionListener(this);
        this.excludeZeroBox = new JCheckBox("Exclude Zero");
        this.excludeZeroBox.setVerticalTextPosition(1);
        this.excludeZeroBox.setHorizontalTextPosition(0);
        this.excludeZeroBox.setSelected(true);
        this.integerBox = new JCheckBox("Auto Binning");
        this.integerBox.setVerticalTextPosition(1);
        this.integerBox.setHorizontalTextPosition(0);
        this.integerBox.setActionCommand("Integer Mode");
        this.integerBox.addActionListener(this);
        boolean isInteger = this.viewer.getCurrentScreenVolume().getVolume().getImageType().getByteType() != 4 && this.viewer.getCurrentScreenVolume().getVolume().getImageRange().hasGlobalDataScaleSlope() && !this.viewer.getCurrentScreenVolume().getVolume().isImageDirty();
        this.integerBox.setSelected(isInteger || this.histogram.isIntegerMode());
        this.binCount.setEnabled(!isInteger);
        JButton goButton = new JButton("Calculate");
        goButton.setActionCommand("Calculate");
        goButton.addActionListener(this);
        JPanel binCountLabelPanel = new JPanel();
        binCountLabelPanel.setLayout(new BoxLayout(binCountLabelPanel, 0));
        binCountLabelPanel.add(Box.createHorizontalGlue());
        binCountLabelPanel.add(binCountLabel);
        binCountLabelPanel.add(Box.createHorizontalGlue());
        JPanel binCountTextFieldPanel = new JPanel();
        binCountTextFieldPanel.setLayout(new BoxLayout(binCountTextFieldPanel, 0));
        binCountTextFieldPanel.add(Box.createHorizontalGlue());
        binCountTextFieldPanel.add(this.binCount);
        binCountTextFieldPanel.add(Box.createHorizontalGlue());
        JPanel binCountPanel = new JPanel();
        binCountPanel.setLayout(new BoxLayout(binCountPanel, 1));
        binCountPanel.add(binCountLabelPanel);
        binCountPanel.add(binCountTextFieldPanel);
        JPanel userMinLabelPanel = new JPanel();
        userMinLabelPanel.setLayout(new BoxLayout(userMinLabelPanel, 0));
        userMinLabelPanel.add(Box.createHorizontalGlue());
        userMinLabelPanel.add(userMinLabel);
        userMinLabelPanel.add(Box.createHorizontalGlue());
        JPanel userMinTextFieldPanel = new JPanel();
        userMinTextFieldPanel.setLayout(new BoxLayout(userMinTextFieldPanel, 0));
        userMinTextFieldPanel.add(Box.createHorizontalGlue());
        userMinTextFieldPanel.add(this.userMin);
        userMinTextFieldPanel.add(Box.createHorizontalGlue());
        JPanel userMinPanel = new JPanel();
        userMinPanel.setLayout(new BoxLayout(userMinPanel, 1));
        userMinPanel.add(userMinLabelPanel);
        userMinPanel.add(userMinTextFieldPanel);
        JPanel userMaxLabelPanel = new JPanel();
        userMaxLabelPanel.setLayout(new BoxLayout(userMaxLabelPanel, 0));
        userMaxLabelPanel.add(Box.createHorizontalGlue());
        userMaxLabelPanel.add(userMaxLabel);
        userMaxLabelPanel.add(Box.createHorizontalGlue());
        JPanel userMaxTextFieldPanel = new JPanel();
        userMaxTextFieldPanel.setLayout(new BoxLayout(userMaxTextFieldPanel, 0));
        userMaxTextFieldPanel.add(Box.createHorizontalGlue());
        userMaxTextFieldPanel.add(this.userMax);
        userMaxTextFieldPanel.add(Box.createHorizontalGlue());
        JPanel userMaxPanel = new JPanel();
        userMaxPanel.setLayout(new BoxLayout(userMaxPanel, 1));
        userMaxPanel.add(userMaxLabelPanel);
        userMaxPanel.add(userMaxTextFieldPanel);
        JPanel useROIPanel = new JPanel();
        useROIPanel.setLayout(new BoxLayout(useROIPanel, 0));
        useROIPanel.add(this.useROIBox);
        JPanel excludeZeroPanel = new JPanel();
        excludeZeroPanel.setLayout(new BoxLayout(excludeZeroPanel, 0));
        excludeZeroPanel.add(this.excludeZeroBox);
        JPanel integerBoxPanel = new JPanel();
        integerBoxPanel.setLayout(new BoxLayout(integerBoxPanel, 0));
        integerBoxPanel.add(this.integerBox);
        JPanel goButtonPanel = new JPanel();
        goButtonPanel.add(goButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalStrut(8));
        buttonsPanel.add(binCountPanel);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(userMinPanel);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(userMaxPanel);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(useROIPanel);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(excludeZeroPanel);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(integerBoxPanel);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(goButton);
        buttonsPanel.add(Box.createHorizontalStrut(8));
        this.showBox = new JComboBox<String>(new String[]{"Data", "Rate", "Cumulative"});
        this.showBox.setActionCommand("show box");
        this.showBox.addActionListener(this);
        this.showBox.setEditable(false);
        this.showBox.setPrototypeDisplayValue("Cumulative");
        this.showBox.setMaximumSize(this.showBox.getPreferredSize());
        if (!this.histogram.isInitialized()) {
            this.histogram.setTransparency(0);
        }
        this.sliderTransparency = new MangoTransparencySlider(0, 0, 100, this.histogram.getTransparency(), this, false);
        this.sliderTransparency.setMajorTickSpacing(10);
        this.sliderTransparency.setSnapToTicks(true);
        this.sliderTransparency.setPreferredSize(new Dimension(80, 30));
        this.sliderTransparency.setMaximumSize(new Dimension(80, 30));
        this.sliderTransparency.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
        sliderPanel.add(this.sliderTransparency);
        this.generateROIButton = new JButton("Generate ROI");
        this.generateROIButton.setActionCommand("generate");
        this.generateROIButton.addActionListener(this);
        this.generateROIButton.setPressedIcon(MangoStyle.ICON_CAMERA.get(1));
        JButton clearButton = new JButton("Clear");
        clearButton.setActionCommand("clear");
        clearButton.addActionListener(this);
        MangoSquareButton exportButton = new MangoSquareButton(MangoStyle.ICON_EXPORT, false, this.mango);
        exportButton.setActionCommand("export");
        exportButton.addActionListener(this);
        JPanel exportButtonPanel = new JPanel();
        exportButtonPanel.setLayout(new BoxLayout(exportButtonPanel, 0));
        exportButtonPanel.add(exportButton);
        MangoSquareButton cameraButton = new MangoSquareButton(MangoStyle.ICON_CAMERA.get(0), false, this.mango);
        cameraButton.setActionCommand("cameraButton");
        cameraButton.addActionListener(this);
        cameraButton.setPressedIcon(MangoStyle.ICON_CAMERA.get(1));
        JPanel cameraButtonPanel = new JPanel();
        cameraButtonPanel.setLayout(new BoxLayout(cameraButtonPanel, 0));
        cameraButtonPanel.add(cameraButton);
        JPanel buttonsPanelLower = new JPanel();
        buttonsPanelLower.setLayout(new BoxLayout(buttonsPanelLower, 0));
        buttonsPanelLower.add(Box.createHorizontalStrut(8));
        buttonsPanelLower.add(sliderPanel);
        buttonsPanelLower.add(this.showBox);
        buttonsPanelLower.add(Box.createHorizontalGlue());
        buttonsPanelLower.add(Box.createHorizontalStrut(8));
        buttonsPanelLower.add(this.generateROIButton);
        buttonsPanelLower.add(clearButton);
        if (!this.mango.isApplet()) {
            buttonsPanelLower.add(Box.createHorizontalStrut(8));
            buttonsPanelLower.add(Box.createHorizontalGlue());
            buttonsPanelLower.add(exportButtonPanel);
            buttonsPanelLower.add(cameraButtonPanel);
        }
        buttonsPanelLower.add(Box.createHorizontalStrut(8));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.add(Box.createVerticalStrut(4));
        optionsPanel.add(buttonsPanel);
        optionsPanel.add(buttonsPanelLower);
        optionsPanel.add(Box.createVerticalStrut(4));
        optionsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 75));
        SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)optionsPanel, (Color)this.mango.getPanelOutsideColor(), (Class[])new Class[]{JTextField.class});
        cameraButtonPanel.setBackground(Color.WHITE);
        exportButtonPanel.setBackground(Color.WHITE);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        mainPanel.add(this.histogram);
        mainPanel.add(optionsPanel);
        JPanel mainPanelOut = new JPanel(new BorderLayout());
        mainPanelOut.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanelOut.add((Component)mainPanel, "Center");
        mainPanelOut.setBackground(this.mango.getPanelOutsideColor());
        this.updateROIGenerate(false);
        this.setTitle("Histogram: " + this.viewer.getImageTitle());
        this.getContentPane().add((Component)mainPanelOut, "Center");
        this.setBackground(this.mango.getPanelOutsideColor());
        this.pack();
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setLocation(DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), new Dimension(550, 375), null, this.mango.isApplet()));
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setVisible(true);
        this.validate();
        this.requestFocus();
        this.toFront();
        this.repaint();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                Dimension dim = HistogramTool.this.getSize();
                if (dim.width < 550 && dim.height >= 375) {
                    HistogramTool.this.setSize(550, dim.height);
                } else if (dim.width >= 550 && dim.height < 375) {
                    HistogramTool.this.setSize(dim.width, 375);
                } else if (dim.width < 550 && dim.height < 375) {
                    HistogramTool.this.setSize(550, 375);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                if (HistogramTool.this.isVisible()) {
                    HistogramTool.this.viewer.setHistogramOverlayState(false);
                    HistogramTool.this.histogram.setParentFrame(null);
                    HistogramTool.this.viewer.updateViewer();
                }
            }

            @Override
            public void windowClosing(WindowEvent we) {
                if (HistogramTool.this.isVisible()) {
                    HistogramTool.this.viewer.setHistogramOverlayState(false);
                    HistogramTool.this.histogram.setParentFrame(null);
                    HistogramTool.this.viewer.updateViewer();
                }
            }

            @Override
            public void windowOpened(WindowEvent we) {
                HistogramTool.this.viewer.setHistogramOverlayState(true);
                HistogramTool.this.viewer.forceImageUpdate();
            }
        });
        if (this.runAuto) {
            this.run();
        }
        this.viewer.associateWindow(this);
    }

    public void run() {
        this.setUserMin(this.viewer.getCurrentScreenVolume().getScreenMin());
        this.setUserMax(this.viewer.getCurrentScreenVolume().getScreenMax());
        double[] range = new double[]{this.viewer.getCurrentScreenVolume().getScreenMin(), this.viewer.getCurrentScreenVolume().getScreenMax()};
        this.histogram.setNumBins(this.getCalculatedBinCount(range));
        this.binCount.setText(String.valueOf(this.histogram.getNumBins()));
        this.setUserMin(range[0]);
        this.setUserMax(range[1]);
        this.histogram.setBinsMin(range[0]);
        this.histogram.setBinsMax(range[1]);
        this.histogram.setSelectedScreenVolumeIndex(this.viewer.getCurrentOverlayIndex());
        this.histogram.updateStats(false, true, this.excludeZeroBox.isSelected(), this.integerBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Integer Mode")) {
            this.updateEnabledState();
        } else if (ae.getActionCommand().equals("Calculate")) {
            if (!this.histogram.isCalculating()) {
                this.clearData(-1);
                boolean everythingOk = true;
                int numBinsText = 0;
                double binsMinText = 0.0;
                double binsMaxText = 0.0;
                try {
                    binsMinText = Double.parseDouble(this.userMin.getText().trim());
                    binsMaxText = Double.parseDouble(this.userMax.getText().trim());
                    double[] range = new double[]{binsMinText, binsMaxText};
                    numBinsText = this.getCalculatedBinCount(range);
                    binsMinText = range[0];
                    binsMaxText = range[1];
                    this.binCount.setText(String.valueOf(numBinsText));
                    this.setUserMin(range[0]);
                    this.setUserMax(range[1]);
                    if (numBinsText < 1 || numBinsText > 1024) {
                        everythingOk = false;
                    }
                    if (binsMinText >= binsMaxText) {
                        everythingOk = false;
                    }
                }
                catch (NumberFormatException ex) {
                    AppLogger.info((Throwable)ex);
                    everythingOk = false;
                }
                if (everythingOk) {
                    this.histogram.setNumBins(numBinsText);
                    this.histogram.setBinsMin(binsMinText);
                    this.histogram.setBinsMax(binsMaxText);
                    boolean useROI = this.useROIBox.isSelected() && this.useROIBox.isEnabled();
                    this.histogram.updateStats(useROI, true, this.excludeZeroBox.isSelected(), this.integerBox.isSelected());
                    this.requestFocus();
                } else {
                    this.histogram.paintError();
                }
            }
        } else if (ae.getActionCommand().equals("show box")) {
            int selectedIndex = this.showBox.getSelectedIndex();
            if (selectedIndex == 0) {
                this.histogram.setAsDataMode();
            } else if (selectedIndex == 1) {
                this.histogram.setAsDerivativesMode();
            } else if (selectedIndex == 2) {
                this.histogram.setAsCumulativesMode();
            }
        } else if (ae.getActionCommand().equals("use roi")) {
            this.viewer.updateViewer();
        } else if (ae.getActionCommand().equals("cameraButton")) {
            boolean isShiftDown = (ae.getModifiers() & 1) != 0;
            this.mango.doCapture(isShiftDown, this.histogram);
        } else if (ae.getActionCommand().equals("clear")) {
            this.clearData(-1);
            this.repaint();
        } else if (ae.getActionCommand().equals("generate")) {
            this.viewer.doActionHistogramGenerateROIs(this.histogram.makeStat(), this.useROIBox.isSelected());
        } else if (ae.getActionCommand().equals("export")) {
            this.export();
        }
    }

    public void setCurrentState(int bins, double min, double max, boolean excludeZero, boolean integerMode, boolean roi) {
        int numBins = bins;
        double[] range = new double[]{min, max};
        if (integerMode) {
            numBins = this.getCalculatedBinCount(range);
        }
        this.binCount.setText(String.valueOf(numBins));
        this.userMin.setText(String.valueOf(min));
        this.userMax.setText(String.valueOf(max));
        this.excludeZeroBox.setSelected(excludeZero);
        this.integerBox.setSelected(integerMode);
        this.useROIBox.setSelected(roi);
        this.histogram.setNumBins(numBins);
        this.histogram.setBinsMin(min);
        this.histogram.setBinsMax(max);
        this.updateEnabledState();
    }

    @Override
    public boolean canEnable(MangoTransparencySlider slider) {
        return true;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    public boolean isUsingROI() {
        return this.useROIBox.isSelected();
    }

    public void setUserMax(double val) {
        this.userMax.setText(FORMATTER.format(val));
    }

    public void setUserMin(double val) {
        this.userMin.setText(FORMATTER.format(val));
    }

    @Override
    public void sliderChanged(MangoTransparencySlider slider) {
        int oldVal = this.histogram.getTransparency();
        int newVal = this.sliderTransparency.getValue();
        if (newVal != oldVal) {
            this.histogram.updateTransparency(newVal);
            this.repaint();
        }
    }

    @Override
    public void sliderControlReleased(MangoTransparencySlider slider) {
    }

    private void checkMinMax(double[] range) {
        double imageMin = this.viewer.getCurrentScreenVolume().getVolume().getImageMin();
        double imageMax = this.viewer.getCurrentScreenVolume().getVolume().getImageMax();
        if (range[0] < imageMin) {
            range[0] = imageMin;
        }
        if (range[1] > imageMax) {
            range[1] = imageMax;
        }
    }

    private void clearData(int color) {
        if (color == -1) {
            this.histogram.clearSelected();
        } else {
            this.histogram.clearSelected(color);
        }
        this.viewer.forceHistogramUpdate();
        this.viewer.clearHistogram();
        this.viewer.setShowHistogram(false);
        this.viewer.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        File oldFile = this.viewer.getLoadedFile();
        String fileName = oldFile.getName();
        File selectedFile = null;
        File startFile = null;
        startFile = fileName.indexOf(46) != -1 ? new File(oldFile.getParent(), fileName.substring(0, fileName.indexOf(46)) + "_histogram.csv") : new File(oldFile.getParent(), fileName + "_histogram.csv");
        selectedFile = this.mango.makeSaveFileChooser(this.viewer.getSaveDirectory(), startFile.getName());
        if (selectedFile != null) {
            try (PrintWriter writer = null;){
                int ctr;
                writer = new PrintWriter(new BufferedWriter(new FileWriter(selectedFile)));
                int maxColors = this.viewer.getROIManager().getMaximumColors();
                int numBins = this.histogram.getNumBins();
                int[] bins = this.histogram.getBins();
                double[] mins = this.histogram.getBinMins();
                int[] firstBins = this.histogram.getSelectedFirsts();
                int[] secondBins = this.histogram.getSelectedSeconds();
                StringBuffer sbLabels = new StringBuffer("Bin Minimum,Bin Count");
                int highestColor = -1;
                for (ctr = 0; ctr < maxColors; ++ctr) {
                    if (firstBins[ctr] == -1) continue;
                    highestColor = ctr;
                }
                for (ctr = 0; ctr <= highestColor; ++ctr) {
                    sbLabels.append(',');
                    sbLabels.append(this.viewer.getROIManager().getLabel(ctr, ROIDefaultLabels.getDefaultLabelBitPlaneOrder(ctr, this.viewer.getROIManager().getBuffer().getMaximumColors())));
                }
                writer.println(sbLabels.toString());
                for (ctr = 0; ctr < numBins; ++ctr) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(mins[ctr]).append(',').append(bins[ctr]);
                    for (int ctrColor = 0; ctrColor < maxColors; ++ctrColor) {
                        if (firstBins[ctrColor] != -1) {
                            if (secondBins[ctrColor] != -1) {
                                if (ctr >= firstBins[ctrColor] && ctr <= secondBins[ctrColor]) {
                                    sb.append(",1");
                                    continue;
                                }
                                sb.append(',');
                                continue;
                            }
                            if (ctr == firstBins[ctrColor]) {
                                sb.append(",1");
                                continue;
                            }
                            sb.append(',');
                            continue;
                        }
                        sb.append(',');
                    }
                    writer.println(sb.toString());
                }
            }
        }
    }

    private int getCalculatedBinCount(double[] range) {
        if (this.integerBox.isSelected()) {
            this.checkMinMax(range);
            return HistogramOp.getValidAutoBinNumber(this.viewer.getCurrentVolume(), range);
        }
        int numBins = 128;
        try {
            numBins = Integer.parseInt(this.binCount.getText());
        }
        catch (NumberFormatException ex) {
            AppLogger.info((Throwable)ex);
        }
        return numBins;
    }

    private void updateEnabledState() {
        this.binCount.setEnabled(!this.integerBox.isSelected());
    }

    protected void updateROIGenerate(boolean hasSelected) {
        this.generateROIButton.setEnabled(hasSelected);
    }
}

