/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.histogram;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.core.Capturable;
import edu.uthscsa.ric.mango.core.Paintable;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.histogram.HistogramTool;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.Histogram;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.OperationBuilder;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.histogram.AnalysisHistogramImpl;
import edu.uthscsa.ric.volume.operations.histogram.HistogramOp;
import edu.uthscsa.ric.volume.operations.histogram.HistogramROIOp;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class HistogramPanel
extends JComponent
implements Capturable,
MouseListener,
MouseMotionListener,
Paintable,
OperationListener {
    private Ellipse2D.Double leftHandleRound;
    private Ellipse2D.Double rightHandleRound;
    private JFrame parentFrame;
    private Polygon leftHandleArrow;
    private Polygon rightHandleArrow;
    private Rectangle2D.Double leftHandle;
    private Rectangle2D.Double rightHandle;
    private Rectangle2D.Double[] binRects;
    private boolean initialized;
    private boolean isCalculating;
    private boolean isCumulativesMode;
    private boolean isDataMode;
    private boolean isDerivativesMode;
    private boolean leftHandleGrabbed;
    private boolean paintError;
    private boolean rightHandleGrabbed;
    private boolean selectionGrabbed;
    private double binsMax;
    private double binsMin;
    private double[] binMaxs;
    private double[] binMins;
    private int currentBin;
    private int currentOverlayCode;
    private int grabOffset;
    private int leftGrabOffset;
    private int lowest;
    private int maxColors;
    private int numBins;
    private int screenVolumeIndex;
    private int rightGrabOffset;
    private int transparency;
    private int[] bins;
    private int[] cumulatives;
    private int[] derivatives;
    private int[] selectedBin;
    private int[] selectedBinSecond;
    private boolean excludeZero;
    private boolean integerMode;
    private final SliceViewer viewer;
    private static final long serialVersionUID = 1L;
    public static final Color COLOR_VALUE = new Color(255, 255, 255, 225);
    public static final Color HANDLE_ARROW_COLOR = new Color(200, 200, 200, 128);
    public static final Color SELECTED_COLOR = new Color(255, 255, 255, 128);
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    public static final MangoNumberFormatter FORMATTER_LONG = new MangoNumberFormatter(1);
    public static final Font FONT = new Font("SansSerif", 1, 10);
    public static final Font FONT_LABEL = new Font("SansSerif", 2, 22);
    public static final Font FONT_LARGE = new Font("SansSerif", 1, 40);
    public static final Font FONT_MEDIUM = new Font("SansSerif", 1, 14);
    public static final int DEFAULT_NUM_BINS = 128;
    public static final int HANDLE_SIZE = 25;
    public static final int INSETS_BOTTOM = 30;
    public static final int INSETS_LEFT = 60;
    public static final int INSETS_RIGHT = 25;
    public static final int INSETS_TOP = 15;
    public static final int MAX_BINS = 1024;

    public HistogramPanel(SliceViewer viewer) {
        this.viewer = viewer;
        this.numBins = 128;
        this.currentBin = -1;
        this.maxColors = viewer.getROIManager().getMaximumColors();
        this.binsMax = viewer.getCurrentVolume().getImageMax();
        this.binsMin = viewer.getCurrentVolume().getImageMin();
        this.selectedBin = new int[this.maxColors];
        this.selectedBinSecond = new int[this.maxColors];
        this.clearSelected();
        this.setPreferredSize(HistogramTool.HISTOGRAM_SIZE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.isDataMode = true;
    }

    @Override
    public BufferedImage captureImage() {
        BufferedImage bi = new BufferedImage(this.getSize().width, this.getSize().height, 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setClip(0, 0, this.getSize().width, this.getSize().height);
        this.doPaint(g2d, this.getSize().width, this.getSize().height);
        return bi;
    }

    public void finishedCalculation(Histogram stat) {
        if (stat != null) {
            System.arraycopy(stat.getBinCounts(), 0, this.bins, 0, this.bins.length);
            System.arraycopy(stat.getBinRangeMinimums(), 0, this.binMins, 0, this.bins.length);
            System.arraycopy(stat.getBinRangeMaximums(), 0, this.binMaxs, 0, this.bins.length);
        }
        this.setCalculating(false);
        this.updateViewer();
        this.repaint();
    }

    public double[] getBinMaxs() {
        return this.binMaxs;
    }

    public double[] getBinMins() {
        return this.binMins;
    }

    public int[] getBins() {
        int[] someBins = null;
        if (this.isDataMode) {
            someBins = this.bins;
        } else if (this.isDerivativesMode) {
            someBins = this.derivatives;
        } else if (this.isCumulativesMode) {
            someBins = this.cumulatives;
        }
        return someBins;
    }

    public double getBinsMax() {
        return this.binsMax;
    }

    public double getBinsMin() {
        return this.binsMin;
    }

    @Override
    public File getCaptureDir() {
        return this.viewer.getLoadedFile().getParentFile();
    }

    @Override
    public String getCaptureName() {
        String name = this.viewer.getLoadedFile().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(0, name.indexOf(46));
        }
        name = name + "_histogram";
        return name;
    }

    public int getCurrentOverlayCode() {
        return this.currentOverlayCode;
    }

    public HistogramTool getHistogramDialog() {
        return (HistogramTool)this.parentFrame;
    }

    public int getNumBins() {
        return this.numBins;
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public int[] getSelectedFirsts() {
        return this.selectedBin;
    }

    public int[] getSelectedSeconds() {
        return this.selectedBinSecond;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void increaseColors(int maxColors) {
        int ctr;
        int[] selectedBinNew = new int[maxColors];
        int[] selectedBinSecondNew = new int[maxColors];
        for (ctr = 0; ctr < this.selectedBin.length; ++ctr) {
            selectedBinNew[ctr] = this.selectedBin[ctr];
            selectedBinSecondNew[ctr] = this.selectedBinSecond[ctr];
        }
        for (ctr = this.selectedBin.length; ctr < maxColors; ++ctr) {
            selectedBinNew[ctr] = -1;
            selectedBinSecondNew[ctr] = -1;
        }
        this.selectedBin = selectedBinNew;
        this.selectedBinSecond = selectedBinSecondNew;
        this.maxColors = maxColors;
    }

    public boolean isCalculating() {
        return this.isCalculating;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.leftHandleGrabbed) {
            this.leftHandleMoved(me.getPoint());
        } else if (this.rightHandleGrabbed) {
            this.rightHandleMoved(me.getPoint());
        } else if (this.selectionGrabbed) {
            this.selectionMoved(me.getPoint());
        } else {
            this.updateCurrentBin(me.getPoint());
            this.updateSelectedBin(me.isShiftDown(), me.getPoint());
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.currentBin = -1;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.updateCurrentBin(me.getPoint());
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Point point = me.getPoint();
        this.leftHandleGrabbed = this.leftHandleTest(point);
        this.rightHandleGrabbed = this.rightHandleTest(point);
        this.selectionGrabbed = this.grabTest(point);
        if (this.leftHandleGrabbed) {
            this.leftGrabOffset = point.x - (int)Math.round(this.leftHandleRound.getX() + 25.0);
        } else if (this.rightHandleGrabbed) {
            this.rightGrabOffset = point.x - (int)Math.round(this.rightHandleRound.getX());
        } else if (this.selectionGrabbed) {
            this.updateGrabOffset(point);
        } else {
            this.updateSelectedBin(me.isShiftDown(), point);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.leftHandleGrabbed = false;
        this.rightHandleGrabbed = false;
        this.selectionGrabbed = false;
        ((HistogramTool)this.parentFrame).updateROIGenerate(this.hasSelected());
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isInitialized()) {
            this.doPaint((Graphics2D)g, this.getSize().width, this.getSize().height);
        } else {
            super.paintComponent(g);
        }
    }

    public void setBinsMax(double val) {
        this.binsMax = val;
    }

    public void setBinsMin(double val) {
        this.binsMin = val;
    }

    public void setCalculating(boolean isCalculating) {
        this.isCalculating = isCalculating;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setNumBins(int val) {
        this.numBins = val;
    }

    public void setParentFrame(JFrame aFrame) {
        this.parentFrame = aFrame;
    }

    public void setSelectedScreenVolumeIndex(int val) {
        this.screenVolumeIndex = val;
    }

    public void setTransparency(int val) {
        this.transparency = val;
        int alpha = (int)((double)(100 - val) * 0.01 * 255.0 + 0.5);
        this.viewer.setHistogramAlpha(alpha);
        this.updateViewer();
    }

    private boolean binContainsTest(int ctr, Point point) {
        return this.binRects[ctr].contains(point) || this.binRects[ctr].outcode(point) == 2 || this.binRects[ctr].outcode(point) == 8;
    }

    private void doPaint(Graphics2D g2d, int sizeWidth, int sizeHeight) {
        int textLayoutWidth;
        int ctr;
        int color = this.viewer.getRoiColor();
        if (this.isDerivativesMode || this.isCumulativesMode) {
            this.derivatives[0] = 0;
            this.cumulatives[0] = this.bins[0];
            for (int ctr2 = 1; ctr2 < this.numBins; ++ctr2) {
                this.derivatives[ctr2] = this.bins[ctr2] - this.bins[ctr2 - 1];
                this.cumulatives[ctr2] = this.bins[ctr2] + this.cumulatives[ctr2 - 1];
            }
        }
        int[] someBins = this.getBins();
        int width = sizeWidth - 85;
        int height = sizeHeight - 45;
        double binWidth = (double)width / (double)this.numBins;
        int highest = this.lowest = someBins[0];
        for (int ctr3 = 1; ctr3 < this.numBins; ++ctr3) {
            if (someBins[ctr3] > highest) {
                highest = someBins[ctr3];
            }
            if (someBins[ctr3] >= this.lowest) continue;
            this.lowest = someBins[ctr3];
        }
        if (this.isDataMode) {
            this.lowest = 0;
        }
        AffineTransform originalTrans = g2d.getTransform();
        g2d.setFont(FONT);
        g2d.setColor(Color.GRAY);
        g2d.fill(g2d.getClip());
        for (ctr = 0; ctr < this.numBins; ++ctr) {
            g2d.setTransform(originalTrans);
            boolean drawn = false;
            if (this.isDataMode) {
                double barHeight = (double)height * ((double)someBins[ctr] / (double)highest);
                this.binRects[ctr] = new Rectangle2D.Double((double)ctr * binWidth + 60.0, (double)height - barHeight + 15.0, binWidth, barHeight + 1.0);
            } else if (this.isDerivativesMode) {
                double barHeight = Math.abs((double)(height + 15) - (double)height * ((double)(someBins[ctr] - this.lowest) / ((double)highest - (double)this.lowest)) - ((double)height / 2.0 + 15.0));
                this.binRects[ctr] = Math.signum(someBins[ctr]) > 0.0f ? new Rectangle2D.Double((double)ctr * binWidth + 60.0, (double)height / 2.0 + 15.0 - barHeight, binWidth, barHeight) : new Rectangle2D.Double((double)ctr * binWidth + 60.0, (double)height / 2.0 + 15.0, binWidth, barHeight);
            } else if (this.isCumulativesMode) {
                double barHeight = (double)height * ((double)someBins[ctr] / (double)highest);
                this.binRects[ctr] = new Rectangle2D.Double((double)ctr * binWidth + 60.0, (double)height - barHeight + 15.0, binWidth, barHeight + 1.0);
            }
            for (int ctrColor = 0; ctrColor < this.maxColors; ++ctrColor) {
                if (ctrColor == color || !this.drawBinTest(ctr, ctrColor)) continue;
                g2d.setColor(ROIColor.getColor(ctrColor));
                g2d.fill(this.binRects[ctr]);
                drawn = true;
            }
            if (this.drawBinTest(ctr, color)) {
                g2d.setColor(ROIColor.getColor(color));
                g2d.fill(this.binRects[ctr]);
                drawn = true;
            }
            if (drawn) continue;
            g2d.setColor(Color.BLACK);
            g2d.fill(this.binRects[ctr]);
        }
        this.updateHandles();
        if (!(this.leftHandleGrabbed || this.rightHandleGrabbed || this.selectionGrabbed || this.currentBin == -1)) {
            int lineLoc = 0;
            if (this.isDataMode || this.isCumulativesMode) {
                int barHeight = (int)((double)height * ((double)someBins[this.currentBin] / (double)highest));
                lineLoc = height - barHeight + 15;
            } else if (this.isDerivativesMode) {
                double barHeight = Math.abs((double)(height + 15) - (double)height * ((double)(someBins[this.currentBin] - this.lowest) / ((double)highest - (double)this.lowest)) - ((double)height / 2.0 + 15.0));
                lineLoc = Math.signum(someBins[this.currentBin]) > 0.0f ? (int)Math.round((double)height / 2.0 + 15.0 - barHeight) : (int)Math.round((double)height / 2.0 + 15.0 + barHeight);
            }
            g2d.setColor(ROIColor.getColor(color));
            g2d.drawLine(60, lineLoc, (int)((double)this.currentBin * binWidth + 60.0 + binWidth / 2.0), lineLoc);
            if (this.drawBinTest(this.currentBin, color)) {
                g2d.setColor(SELECTED_COLOR);
            } else {
                g2d.setColor(ROIColor.getColor(color));
            }
            g2d.fill(this.binRects[this.currentBin]);
        }
        if (this.selectedBin[color] != -1) {
            g2d.setColor(HANDLE_ARROW_COLOR);
            g2d.fillPolygon(this.leftHandleArrow);
            g2d.fillPolygon(this.rightHandleArrow);
        }
        g2d.setColor(Color.WHITE);
        g2d.drawLine(60, height + 15, width + 60, height + 15);
        g2d.drawLine(60, 15, 60, height + 15);
        for (ctr = 0; ctr < 5; ++ctr) {
            String string = FORMATTER.format((this.binsMax - this.binsMin) * (0.25 * (double)ctr) + this.binsMin);
            TextLayout textLayout = new TextLayout(string, FONT, g2d.getFontRenderContext());
            textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int startX = (int)((double)width * (0.25 * (double)ctr)) + 60;
            g2d.drawLine(startX, height + 15, startX, height + 15 + 2);
            g2d.drawString(string, startX - textLayoutWidth / 2, height + 30);
        }
        for (ctr = 0; ctr < 5; ++ctr) {
            String string = FORMATTER_LONG.format((int)((double)(highest - this.lowest) * (0.25 * (double)(4 - ctr)) + (double)this.lowest));
            TextLayout textLayout = new TextLayout(string, FONT, g2d.getFontRenderContext());
            textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int startY = (int)((double)height * (0.25 * (double)ctr)) + 15 + 5;
            g2d.drawLine(58, startY - 5, 60, startY - 5);
            g2d.drawString(string, 30 - textLayoutWidth / 2, startY);
        }
        g2d.setColor(COLOR_VALUE);
        if (!this.paintError) {
            if (this.currentBin != -1) {
                String label;
                g2d.setFont(FONT_LARGE);
                g2d.setTransform(originalTrans);
                String binText = String.valueOf(someBins[this.currentBin]);
                int textLayoutWidth2 = (int)new TextLayout(binText, FONT_LARGE, g2d.getFontRenderContext()).getBounds().getWidth();
                int textLayoutHeight = (int)new TextLayout("Pq", FONT_LARGE, g2d.getFontRenderContext()).getBounds().getHeight();
                g2d.drawString(binText, width / 2 - textLayoutWidth2 / 2 + 60, height / 2 - textLayoutHeight / 2);
                g2d.setFont(FONT_MEDIUM);
                String rangeText = "Current: (" + FORMATTER_LONG.format(this.binMins[this.currentBin]) + " to " + FORMATTER_LONG.format(this.binMaxs[this.currentBin]) + ")";
                textLayoutWidth2 = (int)new TextLayout(rangeText, FONT_MEDIUM, g2d.getFontRenderContext()).getBounds().getWidth();
                int textLayoutHeight2 = (int)new TextLayout("Pq", FONT_MEDIUM, g2d.getFontRenderContext()).getBounds().getHeight();
                int stringLoc = height / 2 - textLayoutHeight / 2 + textLayoutHeight2 / 2 + 15;
                g2d.drawString(rangeText, width / 2 - textLayoutWidth2 / 2 + 60, stringLoc);
                if (this.selectedBin[color] != -1 && this.selectedBinSecond[color] != -1) {
                    double selectionMax;
                    double selectionMin;
                    if (this.selectedBin[color] < this.selectedBinSecond[color]) {
                        selectionMin = this.binMins[this.selectedBin[color]];
                        selectionMax = this.binMaxs[this.selectedBinSecond[color]];
                    } else {
                        selectionMin = this.binMins[this.selectedBinSecond[color]];
                        selectionMax = this.binMaxs[this.selectedBin[color]];
                    }
                    g2d.setFont(FONT_MEDIUM);
                    rangeText = "Selection: (" + FORMATTER_LONG.format(selectionMin) + " to " + FORMATTER_LONG.format(selectionMax) + ")";
                    textLayoutWidth2 = (int)new TextLayout(rangeText, FONT_MEDIUM, g2d.getFontRenderContext()).getBounds().getWidth();
                    int textLayoutHeight3 = (int)new TextLayout("Pq", FONT_MEDIUM, g2d.getFontRenderContext()).getBounds().getHeight();
                    stringLoc = stringLoc + textLayoutHeight3 + 5;
                    g2d.drawString(rangeText, width / 2 - textLayoutWidth2 / 2 + 60, stringLoc);
                }
                if (StringUtils.isNotBlank((CharSequence)(label = this.viewer.getROIManager().getLabel(color, "")))) {
                    g2d.setFont(FONT_LABEL);
                    int labelTextWidth = (int)new TextLayout(label, FONT_LABEL, g2d.getFontRenderContext()).getBounds().getWidth();
                    int labelTextHeight = (int)new TextLayout(label, FONT_LABEL, g2d.getFontRenderContext()).getBounds().getHeight();
                    g2d.drawString(label, width / 2 - labelTextWidth / 2 + 60, stringLoc + (int)((double)labelTextHeight * 1.5));
                }
            }
        } else {
            g2d.setFont(FONT_LARGE);
            g2d.setTransform(originalTrans);
            String binText = "ERROR";
            TextLayout textLayout = new TextLayout("ERROR", FONT_LARGE, g2d.getFontRenderContext());
            int textLayoutWidth3 = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            g2d.drawString("ERROR", width / 2 - textLayoutWidth3 / 2 + 60, height / 2 - textLayoutHeight / 2);
            this.paintError = false;
        }
    }

    private boolean drawBinTest(int ctr, int ctrColor) {
        return ctr == this.selectedBin[ctrColor] || this.selectedBinSecond[ctrColor] != -1 && (this.selectedBinSecond[ctrColor] > this.selectedBin[ctrColor] && ctr >= this.selectedBin[ctrColor] && ctr <= this.selectedBinSecond[ctrColor] || this.selectedBinSecond[ctrColor] < this.selectedBin[ctrColor] && ctr <= this.selectedBin[ctrColor] && ctr >= this.selectedBinSecond[ctrColor]);
    }

    private boolean grabTest(Point point) {
        return (double)point.x > this.leftHandleRound.getX() + 25.0 && (double)point.x < this.rightHandleRound.getX();
    }

    private boolean hasSelected() {
        for (int element : this.selectedBin) {
            if (element == -1) continue;
            return true;
        }
        for (int element : this.selectedBinSecond) {
            if (element == -1) continue;
            return true;
        }
        return false;
    }

    private void leftHandleMoved(Point point) {
        int color = this.viewer.getRoiColor();
        point.x -= this.leftGrabOffset;
        int bin = -1;
        if (point.x > 60 && point.x < this.getBounds().width - 25 && point.y > 15 && point.y < this.getBounds().height - 15) {
            for (int ctr = 0; ctr < this.numBins; ++ctr) {
                if (this.binRects == null || this.binRects[ctr] == null || !this.binContainsTest(ctr, point)) continue;
                bin = ctr;
            }
        }
        if (bin != -1) {
            if (this.selectedBin[color] == -1) {
                this.selectedBin[color] = this.selectedBinSecond[color];
            } else if (this.selectedBinSecond[color] == -1) {
                this.selectedBinSecond[color] = this.selectedBin[color];
            }
            if (this.selectedBin[color] < this.selectedBinSecond[color]) {
                this.selectedBin[color] = Math.max(0, bin);
            } else {
                this.selectedBinSecond[color] = Math.max(0, bin);
            }
            this.viewer.setShowHistogram(true);
            this.updateViewer();
            this.repaint();
        }
    }

    private void updateViewer() {
        this.viewer.forceHistogramUpdate();
        this.viewer.updateScreenSlices();
        this.viewer.repaint();
    }

    private boolean leftHandleTest(Point point) {
        return this.leftHandle.contains(point) || this.leftHandleRound.contains(point);
    }

    private void rightHandleMoved(Point point) {
        int color = this.viewer.getRoiColor();
        point.x -= this.rightGrabOffset;
        int bin = -1;
        if (point.x > 60 && point.x < this.getBounds().width - 25 && point.y > 15 && point.y < this.getBounds().height - 15) {
            for (int ctr = 0; ctr < this.numBins; ++ctr) {
                if (this.binRects == null || this.binRects[ctr] == null || !this.binContainsTest(ctr, point)) continue;
                bin = ctr;
            }
        }
        if (bin != -1) {
            if (this.selectedBin[color] == -1) {
                this.selectedBin[color] = this.selectedBinSecond[color];
            } else if (this.selectedBinSecond[color] == -1) {
                this.selectedBinSecond[color] = this.selectedBin[color];
            }
            if (this.selectedBin[color] > this.selectedBinSecond[color]) {
                this.selectedBin[color] = Math.min(this.numBins - 1, bin);
            } else {
                this.selectedBinSecond[color] = Math.min(this.numBins - 1, bin);
            }
            this.viewer.setShowHistogram(true);
            this.updateViewer();
            this.repaint();
        }
    }

    private boolean rightHandleTest(Point point) {
        return this.rightHandle.contains(point) || this.rightHandleRound.contains(point);
    }

    private void selectionMoved(Point pt) {
        int color = this.viewer.getRoiColor();
        Point point = new Point(pt);
        point.setLocation((double)((int)Math.round(point.getX() - (double)this.grabOffset)), point.getY());
        int bin = -1;
        if (point.x < this.getBounds().width - 25) {
            int diff;
            for (int ctr = 0; ctr < this.numBins; ++ctr) {
                if (this.binRects == null || this.binRects[ctr] == null || !this.binContainsTest(ctr, point)) continue;
                bin = ctr;
            }
            if (this.selectedBin[color] < this.selectedBinSecond[color]) {
                diff = bin - this.selectedBin[color];
                this.selectedBin[color] = bin;
                int n = color;
                this.selectedBinSecond[n] = this.selectedBinSecond[n] + diff;
                if (this.selectedBin[color] < 0) {
                    this.updateGrabOffset(pt);
                }
                this.selectedBin[color] = Math.max(0, this.selectedBin[color]);
                this.selectedBinSecond[color] = Math.min(this.numBins - 1, this.selectedBinSecond[color]);
            } else {
                diff = bin - this.selectedBinSecond[color];
                this.selectedBinSecond[color] = bin;
                int n = color;
                this.selectedBin[n] = this.selectedBin[n] + diff;
                if (this.selectedBinSecond[color] < 0) {
                    this.updateGrabOffset(pt);
                }
                this.selectedBinSecond[color] = Math.max(0, this.selectedBinSecond[color]);
                this.selectedBin[color] = Math.min(this.numBins - 1, this.selectedBin[color]);
            }
            this.viewer.setShowHistogram(true);
            this.updateViewer();
            this.repaint();
        }
    }

    private void updateCurrentBin(Point point) {
        this.currentBin = -1;
        if (point.x > 60 && point.x < this.getBounds().width - 25 && point.y > 15 && point.y < this.getBounds().height - 15 && this.currentBin == -1) {
            for (int ctr = 0; ctr < this.numBins; ++ctr) {
                if (this.binRects == null || this.binRects[ctr] == null || !this.binContainsTest(ctr, point)) continue;
                this.currentBin = ctr;
            }
        }
        this.repaint();
    }

    private void updateGrabOffset(Point point) {
        this.grabOffset = point.x - (int)Math.round(this.leftHandleRound.getX() + 25.0);
    }

    private void updateHandles() {
        int color = this.viewer.getRoiColor();
        int width = this.getSize().width - 85;
        int height = this.getSize().height - 45;
        double binWidth = (double)width / (double)this.numBins;
        int leftBin = -1;
        int rightBin = -1;
        if (this.selectedBin[color] != -1) {
            leftBin = rightBin = this.selectedBin[color];
            if (this.selectedBinSecond[color] != -1) {
                if (this.selectedBin[color] < this.selectedBinSecond[color]) {
                    rightBin = this.selectedBinSecond[color];
                } else {
                    leftBin = this.selectedBinSecond[color];
                }
            }
        }
        this.leftHandle = new Rectangle2D.Double((double)leftBin * binWidth + 60.0 - 12.0 + binWidth, height + 15 - 25, 12.0, 25.0);
        this.leftHandleRound = new Ellipse2D.Double((double)leftBin * binWidth + 60.0 - 25.0, height + 15 - 25, 25.0, 25.0);
        this.rightHandle = new Rectangle2D.Double((double)rightBin * binWidth + 60.0 + binWidth, height + 15 - 25, 12.0, 25.0);
        this.rightHandleRound = new Ellipse2D.Double((double)rightBin * binWidth + 60.0 + binWidth, height + 15 - 25, 25.0, 25.0);
        this.leftHandleArrow = new Polygon();
        this.leftHandleArrow.addPoint((int)Math.round(this.leftHandleRound.getX() + 6.0), (int)Math.round(this.leftHandleRound.getY() + 12.0));
        this.leftHandleArrow.addPoint((int)Math.round(this.leftHandleRound.getX() + 25.0 - 6.0), (int)Math.round(this.leftHandleRound.getY() + 18.75));
        this.leftHandleArrow.addPoint((int)Math.round(this.leftHandleRound.getX() + 25.0 - 6.0), (int)Math.round(this.leftHandleRound.getY() + 6.25));
        this.rightHandleArrow = new Polygon();
        this.rightHandleArrow.addPoint((int)Math.round(this.rightHandleRound.getX() + 25.0 - 6.0), (int)Math.round(this.rightHandleRound.getY() + 12.0));
        this.rightHandleArrow.addPoint((int)Math.round(this.rightHandleRound.getX() + 6.0), (int)Math.round(this.rightHandleRound.getY() + 6.25));
        this.rightHandleArrow.addPoint((int)Math.round(this.rightHandleRound.getX() + 6.0), (int)Math.round(this.rightHandleRound.getY() + 18.75));
    }

    protected final void clearSelected() {
        for (int ctr = 0; ctr < this.maxColors; ++ctr) {
            this.selectedBinSecond[ctr] = -1;
            this.selectedBin[ctr] = -1;
        }
    }

    protected final void clearSelected(int color) {
        this.selectedBinSecond[color] = -1;
        this.selectedBin[color] = -1;
    }

    protected void decrementCurrentBin(boolean shiftDown) {
        if (this.currentBin > 0) {
            --this.currentBin;
            if (shiftDown) {
                this.updateSelectedBin(shiftDown, null);
            }
            this.repaint();
        }
    }

    protected void incrementCurrentBin(boolean shiftDown) {
        if (this.currentBin < this.numBins - 1) {
            ++this.currentBin;
            if (shiftDown) {
                this.updateSelectedBin(shiftDown, null);
            }
            this.repaint();
        }
    }

    protected void paintError() {
        this.paintError = true;
        this.repaint();
    }

    protected void setAsCumulativesMode() {
        this.isDataMode = false;
        this.isDerivativesMode = false;
        this.isCumulativesMode = true;
        this.repaint();
    }

    protected void setAsDataMode() {
        this.isDataMode = true;
        this.isDerivativesMode = false;
        this.isCumulativesMode = false;
        this.repaint();
    }

    protected void setAsDerivativesMode() {
        this.isDataMode = false;
        this.isDerivativesMode = true;
        this.isCumulativesMode = false;
        this.repaint();
    }

    protected void updateSelectedBin(boolean shiftDown, Point point) {
        int color = this.viewer.getRoiColor();
        if (shiftDown && this.selectedBin[color] != -1) {
            if (point == null || point.x > 60 && point.x < this.getBounds().width - 25 && point.y > 15 && point.y < this.getBounds().height - 15) {
                this.viewer.setShowHistogram(true);
                this.selectedBinSecond[color] = this.currentBin;
                this.updateViewer();
                this.repaint();
            }
        } else {
            this.selectedBinSecond[color] = -1;
            if (this.selectedBin[color] != this.currentBin) {
                if (point == null || point.x > 60 && point.x < this.getBounds().width - 25 && point.y > 15 && point.y < this.getBounds().height - 15) {
                    this.viewer.setShowHistogram(true);
                    this.selectedBin[color] = this.currentBin;
                    if (this.selectedBin[color] != -1) {
                        this.updateViewer();
                    }
                } else {
                    this.selectedBin[color] = -1;
                    this.updateViewer();
                }
                this.repaint();
            }
        }
    }

    public Histogram makeStat() {
        return new AnalysisHistogramImpl(this.numBins, this.bins, this.binsMin, this.binsMax, this.binMins, this.binMaxs, this.selectedBin, this.selectedBinSecond);
    }

    protected void updateStats(boolean useROI, boolean clearSelected, boolean excludeZero, boolean isIntegerMode) {
        this.setCalculating(true);
        this.bins = new int[this.numBins];
        this.binMins = new double[this.numBins];
        this.binMaxs = new double[this.numBins];
        this.binRects = new Rectangle2D.Double[this.numBins];
        this.derivatives = new int[this.numBins];
        this.cumulatives = new int[this.numBins];
        this.viewer.updateHistogram();
        this.currentBin = -1;
        this.setInitialized(true);
        if (clearSelected) {
            this.clearSelected();
        }
        this.repaint();
        AnalysisHistogramImpl stat = (AnalysisHistogramImpl)this.makeStat();
        stat.setExcludeZero(excludeZero);
        stat.setIntegerMode(isIntegerMode);
        this.setExcludeZero(excludeZero);
        this.setIntegerMode(isIntegerMode);
        if (useROI) {
            if (this.viewer.getROIManager().hasROI()) {
                this.viewer.recordAction("runHistogramROI", new String[]{String.valueOf(128), String.valueOf(this.binsMin), String.valueOf(this.binsMax), this.viewer.getScriptObjectName() + ".roiData.availableMask", ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(isIntegerMode)}, true);
                if (Mango.getInstance().isMultisliceMode()) {
                    HistogramROIOp op = new HistogramROIOp(this.viewer, this.viewer.getCurrentVolume(), this.viewer.getROIManager().getBuffer(), this.viewer.getROIManager().getAvailableMask(), stat);
                    OperationBuilder<Histogram> builder = new OperationBuilder<Histogram>(this.viewer, op);
                    builder.runAsynchronously(this);
                } else {
                    int sliceDirection = this.viewer.getSliceDirection();
                    int sliceNumber = this.viewer.getSliceNumber();
                    HistogramROIOp op = new HistogramROIOp(this.viewer, this.viewer.getCurrentVolume(), this.viewer.getROIManager().getBuffer(), this.viewer.getROIManager().getAvailableMask(), stat);
                    Volume volume = this.viewer.getVolume();
                    stat = sliceDirection == 0 ? (AnalysisHistogramImpl)op.process(new ImageBounds(0, volume.getXDim() - 1, 0, volume.getYDim() - 1, sliceNumber, sliceNumber)) : (sliceDirection == 1 ? (AnalysisHistogramImpl)op.process(new ImageBounds(0, volume.getXDim() - 1, sliceNumber, sliceNumber, 0, volume.getZDim() - 1)) : (AnalysisHistogramImpl)op.process(new ImageBounds(sliceNumber, sliceNumber, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1)));
                    this.finishedCalculation(stat);
                }
            } else {
                this.finishedCalculation(null);
            }
        } else {
            this.viewer.recordAction("runHistogram", new String[]{String.valueOf(128), String.valueOf(this.binsMin), String.valueOf(this.binsMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(isIntegerMode)}, true);
            if (Mango.getInstance().isMultisliceMode()) {
                HistogramOp op = new HistogramOp(this.viewer, this.viewer.getCurrentVolume(), stat);
                OperationBuilder<Histogram> builder = new OperationBuilder<Histogram>(this.viewer, op);
                builder.runAsynchronously(this);
            } else {
                int sliceDirection = this.viewer.getSliceDirection();
                int sliceNumber = this.viewer.getSliceNumber();
                HistogramOp op = new HistogramOp(this.viewer, this.viewer.getCurrentVolume(), stat);
                Volume volume = this.viewer.getVolume();
                stat = sliceDirection == 0 ? (AnalysisHistogramImpl)op.process(new ImageBounds(0, volume.getXDim() - 1, 0, volume.getYDim() - 1, sliceNumber, sliceNumber)) : (sliceDirection == 1 ? (AnalysisHistogramImpl)op.process(new ImageBounds(0, volume.getXDim() - 1, sliceNumber, sliceNumber, 0, volume.getZDim() - 1)) : (AnalysisHistogramImpl)op.process(new ImageBounds(sliceNumber, sliceNumber, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1)));
                this.finishedCalculation(stat);
            }
        }
        this.currentOverlayCode = this.screenVolumeIndex;
    }

    public Histogram updateStatsSync(int binCount, double min, double max, boolean useROI, boolean clearSelected, boolean excludeZero, boolean isIntegerMode, long roiMask) {
        this.setCalculating(true);
        if (isIntegerMode) {
            double[] range = new double[]{min, max};
            this.numBins = HistogramOp.getValidAutoBinNumber(this.viewer.getCurrentVolume(), range);
        } else {
            this.numBins = binCount;
        }
        this.binsMax = max;
        this.binsMin = min;
        this.bins = new int[this.numBins];
        this.binMins = new double[this.numBins];
        this.binMaxs = new double[this.numBins];
        this.binRects = new Rectangle2D.Double[this.numBins];
        this.derivatives = new int[this.numBins];
        this.cumulatives = new int[this.numBins];
        this.viewer.updateHistogram();
        this.currentBin = -1;
        this.setInitialized(true);
        if (clearSelected) {
            this.clearSelected();
        }
        AnalysisHistogramImpl stat = (AnalysisHistogramImpl)this.makeStat();
        stat.setExcludeZero(excludeZero);
        stat.setIntegerMode(isIntegerMode);
        if (useROI) {
            if (this.viewer.getROIManager().hasROI()) {
                this.viewer.recordAction("runHistogramROI", new String[]{String.valueOf(128), String.valueOf(this.binsMin), String.valueOf(this.binsMax), this.viewer.getScriptObjectName() + ".roiData.availableMask", ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(isIntegerMode)});
                if (Mango.getInstance().isMultisliceMode()) {
                    HistogramROIOp op = new HistogramROIOp(this.viewer, this.viewer.getCurrentVolume(), this.viewer.getROIManager().getBuffer(), this.viewer.getROIManager().getAvailableMask(), stat);
                    OperationBuilder<Histogram> builder = new OperationBuilder<Histogram>(this.viewer, op);
                    stat = (AnalysisHistogramImpl)builder.runSynchronously();
                } else {
                    int sliceDirection = this.viewer.getSliceDirection();
                    int sliceNumber = this.viewer.getSliceNumber();
                    HistogramROIOp op = new HistogramROIOp(this.viewer, this.viewer.getCurrentVolume(), this.viewer.getROIManager().getBuffer(), this.viewer.getROIManager().getAvailableMask(), stat);
                    Volume volume = this.viewer.getVolume();
                    stat = sliceDirection == 0 ? (AnalysisHistogramImpl)op.process(new ImageBounds(0, volume.getXDim() - 1, 0, volume.getYDim() - 1, sliceNumber, sliceNumber)) : (sliceDirection == 1 ? (AnalysisHistogramImpl)op.process(new ImageBounds(0, volume.getXDim() - 1, sliceNumber, sliceNumber, 0, volume.getZDim() - 1)) : (AnalysisHistogramImpl)op.process(new ImageBounds(sliceNumber, sliceNumber, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1)));
                }
            } else {
                stat = null;
            }
        } else {
            this.viewer.recordAction("runHistogram", new String[]{String.valueOf(128), String.valueOf(this.binsMin), String.valueOf(this.binsMax), ScriptUtils.convertBoolean(excludeZero), ScriptUtils.convertBoolean(isIntegerMode)}, true);
            if (Mango.getInstance().isMultisliceMode()) {
                HistogramOp op = new HistogramOp(this.viewer, this.viewer.getCurrentVolume(), stat);
                OperationBuilder<Histogram> builder = new OperationBuilder<Histogram>(this.viewer, op);
                stat = (AnalysisHistogramImpl)builder.runSynchronously();
            } else {
                int sliceDirection = this.viewer.getSliceDirection();
                int sliceNumber = this.viewer.getSliceNumber();
                HistogramOp op = new HistogramOp(this.viewer, this.viewer.getCurrentVolume(), stat);
                Volume volume = this.viewer.getVolume();
                stat = sliceDirection == 0 ? (AnalysisHistogramImpl)op.process(new ImageBounds(0, volume.getXDim() - 1, 0, volume.getYDim() - 1, sliceNumber, sliceNumber)) : (sliceDirection == 1 ? (AnalysisHistogramImpl)op.process(new ImageBounds(0, volume.getXDim() - 1, sliceNumber, sliceNumber, 0, volume.getZDim() - 1)) : (AnalysisHistogramImpl)op.process(new ImageBounds(sliceNumber, sliceNumber, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1)));
            }
        }
        this.currentOverlayCode = this.screenVolumeIndex;
        final AnalysisHistogramImpl statF = stat;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HistogramPanel.this.finishedCalculation(statF);
                }
            });
        }
        catch (InterruptedException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            AppLogger.error((Throwable)ex);
        }
        return stat;
    }

    protected void updateTransparency(int val) {
        this.transparency = val;
        int alpha = (int)((double)(100 - val) * 0.01 * 255.0 + 0.5);
        this.viewer.setHistogramAlpha(alpha);
        this.updateViewer();
    }

    public Vector<Integer> getUsedIndices(boolean currentFirst) {
        Vector<Integer> indices = new Vector<Integer>();
        int currentROI = this.viewer.getRoiColor();
        boolean currentUsed = false;
        for (int ctr = 0; ctr < this.maxColors; ++ctr) {
            if (this.selectedBin[ctr] == -1) continue;
            if (ctr == currentROI) {
                if (currentFirst) {
                    currentUsed = true;
                    continue;
                }
                indices.add(ctr);
                continue;
            }
            indices.add(ctr);
        }
        if (currentUsed) {
            indices.insertElementAt(currentROI, 0);
        }
        return indices;
    }

    @Override
    public String getCaptureType() {
        return "histogram";
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput) {
    }

    @Override
    public void operationFinished(Object result, ImageVolume volume) {
        this.finishedCalculation((AnalysisHistogramImpl)result);
    }

    public boolean isExcludeZero() {
        return this.excludeZero;
    }

    public void setExcludeZero(boolean excludeZero) {
        this.excludeZero = excludeZero;
    }

    public boolean isIntegerMode() {
        return this.integerMode;
    }

    public void setIntegerMode(boolean integerMode) {
        this.integerMode = integerMode;
    }
}

