/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.crosssection;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.core.Capturable;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.crosssection.CrosssectionTool;
import edu.uthscsa.ric.mango.viewerslice.dialogs.series.AxisPanel;
import edu.uthscsa.ric.mango.viewerslice.operations.LineOps;
import edu.uthscsa.ric.roi.Line;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.apache.commons.lang3.StringUtils;

public class Crosssection
extends JComponent
implements MouseListener,
MouseMotionListener,
Capturable {
    private CrosssectionTool dialog;
    private Line currentShape;
    private Line[] shapes;
    private Vector<Point2D> allPoints;
    private boolean isCumulativesMode;
    private boolean isDataMode;
    private boolean isDerivativesMode;
    private boolean isMillimeterMode;
    private boolean isPressed;
    private boolean mouseIsInside;
    private boolean yAxisSelected;
    private boolean yAxisSet;
    private double highest;
    private double lowest;
    private double mean;
    private double multiplier;
    private double[] cumulatives;
    private double[] derivatives;
    private double[] values;
    private int currentIndex;
    private int longest;
    private final Ellipse2D.Double marker = new Ellipse2D.Double();
    private final Vector<double[]> storedValues = new Vector();
    private final SliceViewer viewer;
    private final double xSize;
    private final double ySize;
    private final double zSize;
    private static final long serialVersionUID = 1L;
    public static final Color DATA_COLOR = new Color(0, 0, 0, 128);
    public static final Color Y_AXIS_COLOR = new Color(200, 200, 200, 128);
    public static final Color Y_AXIS_COLOR_SELECTED = new Color(200, 200, 200);
    public static final Font FONT = new Font("SansSerif", 1, 10);
    public static final Font FONT_LABEL = new Font("SansSerif", 0, 14);
    public static final Font FONT_LARGE = new Font("SansSerif", 0, 40);
    public static final Font FONT_MEDIUM = new Font("SansSerif", 1, 14);
    public static final Font FONT_MEDIUM2 = new Font("SansSerif", 0, 14);
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0);
    public static final MangoNumberFormatter FORMATTER_LARGE = new MangoNumberFormatter(1);
    public static final Stroke STROKE = new BasicStroke(2.0f);
    public static final Stroke STROKE_DASH = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    public static final Stroke STROKE_STORED = new BasicStroke(3.0f);
    public static final int INSETS_BOTTOM = 30;
    public static final int INSETS_LEFT = 60;
    public static final int INSETS_RIGHT = 25;
    public static final int INSETS_TOP = 15;

    public Crosssection(SliceViewer viewer) {
        this.viewer = viewer;
        Volume volume = viewer.getVolume();
        this.xSize = volume.getXSize();
        this.ySize = volume.getYSize();
        this.zSize = volume.getZSize();
        this.currentIndex = -1;
        this.multiplier = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(CrosssectionTool.CROSSSECTION_SIZE);
        this.isDataMode = true;
    }

    @Override
    public BufferedImage captureImage() {
        BufferedImage bi = new BufferedImage(this.getSize().width, this.getSize().height, 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setClip(0, 0, this.getSize().width, this.getSize().height);
        this.doPaint(g2d, this.getSize().width, this.getSize().height);
        return bi;
    }

    public void clear() {
        this.storedValues.clear();
        this.updateHighestAndLongest();
        this.repaint();
    }

    public double[][] getAllData() {
        double[][] data = new double[this.shapes.length][];
        VolumeData volData = new VolumeData(this.viewer);
        for (int ctrS = 0; ctrS < data.length; ++ctrS) {
            Line shape = this.shapes[ctrS];
            int currentSliceDirection = shape.getSliceDirection();
            int currentSliceNum = shape.getSliceNum();
            Vector points = null;
            double ctrZ = 0.0;
            double ctrY = 0.0;
            double ctrX = 0.0;
            double previous = 0.0;
            points = this.isMillimeterMode ? shape.makeInterpolatedPointsMM(this.multiplier) : shape.makeInterpolatedPoints();
            data[ctrS] = new double[points.size()];
            int ctr = 0;
            for (Point2D currentPoint : this.allPoints) {
                double value = 0.0;
                if (currentSliceDirection == 0) {
                    ctrX = currentPoint.getX();
                    ctrY = currentPoint.getY();
                    ctrZ = currentSliceNum;
                } else if (currentSliceDirection == 1) {
                    ctrX = currentPoint.getX();
                    ctrY = currentSliceNum;
                    ctrZ = currentPoint.getY();
                } else if (currentSliceDirection == 2) {
                    ctrX = currentSliceNum;
                    ctrY = currentPoint.getX();
                    ctrZ = currentPoint.getY();
                }
                if (this.isMillimeterMode) {
                    if (currentSliceDirection == 0) {
                        ctrZ *= this.zSize;
                    } else if (currentSliceDirection == 1) {
                        ctrY *= this.ySize;
                    } else if (currentSliceDirection == 2) {
                        ctrX *= this.xSize;
                    }
                    value = volData.getValueMM(ctrX, ctrY, ctrZ);
                } else {
                    value = volData.getValue((int)ctrX, (int)ctrY, (int)ctrZ);
                }
                if (this.isDataMode) {
                    data[ctrS][ctr] = value;
                } else if (this.isDerivativesMode) {
                    data[ctrS][ctr] = ctr == 0 ? 0.0 : value - previous;
                    previous = value;
                } else if (this.isCumulativesMode) {
                    data[ctrS][ctr] = ctr == 0 ? value : value + data[ctrS][ctr - 1];
                }
                ++ctr;
                previous = value;
            }
        }
        return data;
    }

    @Override
    public File getCaptureDir() {
        return this.viewer.getLoadedFile().getParentFile();
    }

    @Override
    public String getCaptureName() {
        String name = this.viewer.getLoadedFile().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(0, name.indexOf(46));
        }
        name = name + "_crosssection";
        return name;
    }

    public Line getCurrentShape() {
        return this.currentShape;
    }

    public Vector<double[]> getStoredValues() {
        return this.storedValues;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public JFrame getParentFrame() {
        return this.dialog;
    }

    public Line[] getShapes() {
        return this.shapes;
    }

    public double[] getValues() {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        return drawValues;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0 && this.updateSelectedPoint(me.getPoint())) {
            if (this.currentIndex != -1) {
                this.viewer.setShowCrosssectionMarker(true);
                this.viewer.updateCrosssection(this.allPoints.elementAt(this.currentIndex), this.isMillimeterMode, this.currentShape.getSliceDirection());
            } else {
                this.viewer.setShowCrosssectionMarker(false);
            }
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        double[] drawValues = null;
        this.mouseIsInside = true;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0) {
            if (this.updateSelectedPoint(me.getPoint()) && this.isPressed) {
                if (this.currentIndex != -1) {
                    this.viewer.setShowCrosssectionMarker(true);
                    this.viewer.updateCrosssection(this.allPoints.elementAt(this.currentIndex), this.isMillimeterMode, this.currentShape.getSliceDirection());
                } else {
                    this.viewer.setShowCrosssectionMarker(false);
                }
            } else {
                this.viewer.setShowCrosssectionMarker(false);
            }
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.mouseIsInside = false;
        this.currentIndex = -1;
        this.viewer.setShowCrosssectionMarker(false);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        double[] drawValues = null;
        this.mouseIsInside = true;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0 && this.updateSelectedPoint(me.getPoint())) {
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        this.navigateViewerToCurrentShape();
        if (drawValues != null && drawValues.length > 0) {
            this.updateSelectedPoint(me.getPoint());
            this.isPressed = true;
            if (me.getClickCount() == 2) {
                this.yAxisSelected = true;
                this.repaint();
                Volume currentVolume = this.viewer.getCurrentVolume();
                AxisPanel dialogPanel = new AxisPanel(this.lowest, this.highest, this.yAxisSet, currentVolume.getImageMin(), currentVolume.getImageMax());
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.dialog, (Object)dialogPanel, "Set Y-Axis", -1);
                int selection = jopf.show();
                if (selection == 0) {
                    this.yAxisSet = dialogPanel.isGlobalAxisMode();
                    if (this.yAxisSet) {
                        this.lowest = dialogPanel.getMin();
                        this.highest = dialogPanel.getMax();
                    } else {
                        this.updateHighestAndLongest();
                    }
                }
                this.mouseIsInside = false;
                this.yAxisSelected = false;
                this.viewer.setShowCrosssectionMarker(false);
            } else if (this.currentIndex != -1) {
                this.viewer.setShowCrosssectionMarker(true);
                this.viewer.updateCrosssection(this.allPoints.elementAt(this.currentIndex), this.isMillimeterMode, this.currentShape.getSliceDirection());
            } else {
                this.viewer.setShowCrosssectionMarker(false);
            }
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.isPressed = false;
        this.viewer.setShowCrosssectionMarker(false);
        this.dialog.requestFocus();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        this.doPaint(g2d, this.getSize().width, this.getSize().height);
    }

    public void setIsPressedState(boolean bool) {
        if (this.currentShape != null) {
            this.isPressed = bool;
            if (this.isPressed) {
                if (this.currentIndex == -1) {
                    this.currentIndex = 0;
                }
                this.viewer.setShowCrosssectionMarker(this.isPressed);
                this.viewer.updateCrosssection(this.allPoints.elementAt(this.currentIndex), this.isMillimeterMode, this.currentShape.getSliceDirection());
            }
        }
        this.repaint();
    }

    public void setMillimeterMode(boolean bool) {
        this.isMillimeterMode = bool;
    }

    public void setMultiplier(double mul) {
        this.multiplier = mul;
    }

    public void setParentFrame(CrosssectionTool aFrame) {
        this.dialog = aFrame;
    }

    public void setShapes(Line[] someShape) {
        this.updateHighlighting(true);
        this.shapes = someShape;
        if (this.shapes != null && this.shapes.length > 0) {
            int currentIndex = 0;
            if (this.currentShape != null) {
                for (int ctr = 0; ctr < this.shapes.length; ++ctr) {
                    if (this.currentShape != this.shapes[ctr]) continue;
                    currentIndex = ctr;
                }
            }
            this.currentShape = this.shapes[currentIndex];
        } else {
            this.currentShape = null;
        }
        this.updateHighlighting();
        if (this.isMillimeterMode) {
            this.viewer.recordAction("runCrosssectionMM", new String[]{this.viewer.getScriptObjectName() + ".roiData.selectedLines", String.valueOf(this.multiplier)}, true);
        } else {
            this.viewer.recordAction("runCrosssectionVoxels", new String[]{this.viewer.getScriptObjectName() + ".roiData.selectedLines"}, true);
        }
        this.updateCrosssection();
    }

    public void shapeChanged(LOIShape aShape) {
        if (aShape == this.currentShape) {
            this.updateCrosssection();
        }
    }

    public void shapeLabelChanged(LOIShape shape) {
        this.repaint();
    }

    public void shapeSelectionChanged() {
        if (this.dialog != null) {
            this.setShapes(this.viewer.getAllSelectedLOIs());
            this.selectShapeOnCurrentSlice();
            this.dialog.selectionChanged();
        }
    }

    public void updateCrosssection() {
        if (this.currentShape != null) {
            this.mean = 0.0;
            this.allPoints = this.isMillimeterMode ? this.currentShape.makeInterpolatedPointsMM(this.multiplier) : this.currentShape.makeInterpolatedPoints();
            LineOps op = new LineOps(this.viewer);
            this.values = op.getValues(this.currentShape, this.isMillimeterMode, this.multiplier);
            this.derivatives = new double[this.values.length];
            this.cumulatives = new double[this.values.length];
            for (int ctr = 0; ctr < this.values.length; ++ctr) {
                if (ctr == 0) {
                    this.derivatives[0] = 0.0;
                } else {
                    this.derivatives[ctr] = this.values[ctr] - this.values[ctr - 1];
                }
                this.cumulatives[ctr] = ctr == 0 ? this.values[ctr] : this.values[ctr] + this.cumulatives[ctr - 1];
                if (this.isDataMode) {
                    this.mean += this.values[ctr];
                    continue;
                }
                if (this.isDerivativesMode) {
                    this.mean += this.derivatives[ctr];
                    continue;
                }
                if (!this.isCumulativesMode) continue;
                this.mean += this.cumulatives[ctr];
            }
            if (this.isDataMode) {
                this.mean /= (double)this.values.length;
            } else if (this.isDerivativesMode) {
                this.mean /= (double)this.derivatives.length;
            } else if (this.isCumulativesMode) {
                this.mean /= (double)this.cumulatives.length;
            }
            this.updateHighestAndLongest();
        } else {
            this.clearCurrent();
        }
        this.repaint();
    }

    public boolean updateSelectedPoint(Point aPoint) {
        int oldCurrentIndex = this.currentIndex;
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        int width = (int)(this.getSize().getWidth() - 85.0);
        this.currentIndex = (int)(((double)aPoint.x - 60.0) / (double)width * ((double)this.longest - 1.0) + 0.5);
        if (drawValues != null && drawValues.length > 0 && (this.currentIndex < 0 || this.currentIndex >= drawValues.length)) {
            this.currentIndex = -1;
        }
        return oldCurrentIndex != this.currentIndex;
    }

    protected boolean canKeep() {
        return this.currentShape != null;
    }

    protected void clearCurrent() {
        this.currentShape = null;
        this.updateHighlighting();
        this.values = null;
        this.derivatives = null;
        this.cumulatives = null;
    }

    protected boolean hasKeptValues() {
        return this.storedValues.size() > 0;
    }

    protected boolean hasNextShape() {
        return this.shapes != null && this.shapes.length > 0;
    }

    protected boolean hasPrevShape() {
        int currentIndex = this.getCurrentIndex();
        return this.shapes != null && this.shapes.length > 0 && currentIndex > 0;
    }

    protected void keep() {
        if (this.isDataMode && this.values != null && this.values.length > 0) {
            this.storedValues.add(this.values);
        } else if (this.isDerivativesMode && this.derivatives != null && this.derivatives.length > 0) {
            this.storedValues.add(this.derivatives);
        } else if (this.isCumulativesMode && this.cumulatives != null && this.cumulatives.length > 0) {
            this.storedValues.add(this.cumulatives);
        }
        this.repaint();
    }

    protected void navigateViewerToCurrentShape() {
        Line shape = this.getCurrentShape();
        if (shape != null) {
            this.viewer.setMainSliceDirection(shape.getSliceDirection());
            if (shape.getSliceDirection() == 0) {
                this.viewer.setAxialSliceNumber(shape.getSliceNum());
            } else if (shape.getSliceDirection() == 1) {
                this.viewer.setCoronalSliceNumber(shape.getSliceNum());
            } else {
                this.viewer.setSagittalSliceNumber(shape.getSliceNum());
            }
        }
        this.updateHighlighting();
        this.updateCrosssection();
    }

    protected void nextShape() {
        int currentIndex = this.getCurrentIndex();
        ++currentIndex;
        this.currentShape = this.shapes[currentIndex %= this.shapes.length];
        this.updateHighlighting();
        if (this.isMillimeterMode) {
            this.viewer.recordAction("runCrosssectionMM", new String[]{this.viewer.getScriptObjectName() + ".roiData.selectedLines", String.valueOf(this.multiplier)}, true);
        } else {
            this.viewer.recordAction("runCrosssectionVoxels", new String[]{this.viewer.getScriptObjectName() + ".roiData.selectedLines"}, true);
        }
        this.updateCrosssection();
    }

    public void setCurrentLine(Line line) {
        int index = -1;
        if (this.shapes != null) {
            for (int ctr = 0; ctr < this.shapes.length; ++ctr) {
                if (this.shapes[ctr] != line) continue;
                index = ctr;
                break;
            }
        }
        if (index != -1) {
            this.currentIndex = index;
            this.currentShape = line;
            this.updateHighlighting();
            this.updateCrosssection();
        }
    }

    protected void prevShape() {
        int currentIndex = this.getCurrentIndex();
        this.currentShape = this.shapes[currentIndex - 1];
        this.updateHighlighting();
        if (this.isMillimeterMode) {
            this.viewer.recordAction("runCrosssectionMM", new String[]{this.viewer.getScriptObjectName() + ".roiData.selectedLines", String.valueOf(this.multiplier)}, true);
        } else {
            this.viewer.recordAction("runCrosssectionVoxels", new String[]{this.viewer.getScriptObjectName() + ".roiData.selectedLines"}, true);
        }
        this.updateCrosssection();
    }

    protected void resetYAxis() {
        this.yAxisSet = false;
    }

    protected void selectShapeOnCurrentSlice() {
        int sliceNum = this.viewer.getMainSliceNumber();
        int sliceDir = this.viewer.getMainSliceDirection();
        if (this.shapes != null && this.shapes.length > 0) {
            for (Line shape : this.shapes) {
                if (shape.getSliceNum() != sliceNum || shape.getSliceDirection() != sliceDir) continue;
                this.currentShape = shape;
                break;
            }
        }
        this.updateHighlighting();
        this.updateCrosssection();
    }

    protected void setAsCumulativesMode() {
        this.isDataMode = false;
        this.isDerivativesMode = false;
        this.isCumulativesMode = true;
        if (this.currentShape != null) {
            this.clear();
            this.updateCrosssection();
        }
    }

    protected void setAsDataMode() {
        this.isDataMode = true;
        this.isDerivativesMode = false;
        this.isCumulativesMode = false;
        if (this.currentShape != null) {
            this.clear();
            this.updateCrosssection();
        }
    }

    protected void setAsDerivativesMode() {
        this.isDataMode = false;
        this.isDerivativesMode = true;
        this.isCumulativesMode = false;
        if (this.currentShape != null) {
            this.clear();
            this.updateCrosssection();
        }
    }

    private void doPaint(Graphics2D g2d, int sizeWidth, int sizeHeight) {
        int width = sizeWidth - 85;
        int height = sizeHeight - 45;
        int keepIndex = 0;
        Stroke oldStroke = g2d.getStroke();
        g2d.setFont(FONT);
        g2d.setColor(Color.GRAY);
        g2d.fill(g2d.getClip());
        g2d.setColor(Color.WHITE);
        g2d.drawLine(60, height + 15, width + 60, height + 15);
        g2d.drawLine(60, 15, 60, height + 15);
        double[] drawValues = null;
        if (this.isDataMode) {
            drawValues = this.values;
        } else if (this.isDerivativesMode) {
            drawValues = this.derivatives;
        } else if (this.isCumulativesMode) {
            drawValues = this.cumulatives;
        }
        if (drawValues != null && drawValues.length > 0 || this.storedValues.size() > 0) {
            int textLayoutWidth;
            String string;
            int ctr;
            for (ctr = 0; ctr < 5; ++ctr) {
                string = "";
                double temp = this.isMillimeterMode ? (double)(this.longest - 1) * (0.25 * (double)ctr) * this.multiplier : (double)(this.longest - 1) * (0.25 * (double)ctr) + 1.0;
                if (this.longest >= 5) {
                    temp = (int)temp;
                }
                string = string + FORMATTER.format(temp);
                TextLayout textLayout = new TextLayout(string, FONT, g2d.getFontRenderContext());
                int textLayoutWidth2 = (int)textLayout.getBounds().getWidth();
                int startX = (int)((double)width * (0.25 * (double)ctr)) + 60;
                g2d.drawLine(startX, height + 15, startX, height + 15 + 2);
                g2d.drawString(string, startX - textLayoutWidth2 / 2, height + 30);
            }
            for (ctr = 0; ctr < 5; ++ctr) {
                string = String.valueOf(FORMATTER_LARGE.format((this.highest - this.lowest) * (0.25 * (double)(4 - ctr)) + this.lowest));
                TextLayout textLayout = new TextLayout(string, FONT, g2d.getFontRenderContext());
                textLayoutWidth = (int)textLayout.getBounds().getWidth();
                int startY = (int)((double)height * (0.25 * (double)ctr)) + 15 + 5;
                g2d.drawLine(58, startY - 5, 60, startY - 5);
                g2d.drawString(string, 30 - textLayoutWidth / 2, startY);
            }
            g2d.setStroke(STROKE_STORED);
            g2d.setColor(Color.DARK_GRAY);
            Enumeration<double[]> en = this.storedValues.elements();
            while (en.hasMoreElements()) {
                double[] someValues = en.nextElement();
                if (someValues == drawValues) continue;
                g2d.setColor(ROIColor.getTransparentColor(keepIndex++));
                g2d.draw(this.getLineGraph(someValues));
                keepIndex %= 64;
            }
            g2d.setStroke(STROKE);
            if (drawValues != null && drawValues.length > 0) {
                g2d.setColor(Color.WHITE);
                g2d.draw(this.getLineGraph(drawValues));
                if (this.currentIndex != -1) {
                    g2d.setColor(DATA_COLOR);
                    this.marker.setFrame((int)(60.0 + (double)width * ((double)this.currentIndex / ((double)this.longest - 1.0))) - 2, (int)((double)(height + 15) - (double)height * ((drawValues[this.currentIndex] - this.lowest) / (this.highest - this.lowest))) - 2, 5.0, 5.0);
                    g2d.draw(this.marker);
                    g2d.setFont(FONT_LARGE);
                    String valueText = FORMATTER_LARGE.format(drawValues[this.currentIndex]);
                    TextLayout textLayout = new TextLayout(valueText, FONT_LARGE, g2d.getFontRenderContext());
                    textLayoutWidth = (int)textLayout.getBounds().getWidth();
                    int textLayoutHeight = (int)Math.round(textLayout.getBounds().getHeight());
                    g2d.drawString(valueText, width / 2 - textLayoutWidth / 2 + 60, height / 2 + textLayoutHeight / 1);
                    g2d.setFont(FONT_MEDIUM);
                    String pointText = null;
                    pointText = this.isMillimeterMode ? " (Distance = " + FORMATTER.format((double)this.currentIndex * this.multiplier) + " mm)" : " (Index = " + (this.currentIndex + 1) + ")";
                    textLayout = new TextLayout(pointText, FONT_MEDIUM, g2d.getFontRenderContext());
                    textLayoutWidth = (int)textLayout.getBounds().getWidth();
                    int textLayoutHeight2 = (int)textLayout.getBounds().getHeight();
                    int yLoc = height / 2 + textLayoutHeight / 1 + textLayoutHeight2 / 2 + 10;
                    g2d.drawString(pointText, width / 2 - textLayoutWidth / 2 + 60, yLoc);
                    String label = this.currentShape.getLabel(true);
                    if (StringUtils.isNotBlank((CharSequence)label)) {
                        g2d.setFont(FONT_LABEL);
                        int labelTextWidth = (int)new TextLayout(label, FONT_LABEL, g2d.getFontRenderContext()).getBounds().getWidth();
                        int labelTextHeight = (int)new TextLayout(label, FONT_LABEL, g2d.getFontRenderContext()).getBounds().getHeight();
                        g2d.setColor(ROIColor.getColor(this.currentShape.getColor()));
                        g2d.drawString(label, width / 2 - labelTextWidth / 2 + 60, yLoc + (int)((double)labelTextHeight * 1.5));
                    }
                } else if (this.mouseIsInside) {
                    g2d.setStroke(STROKE_DASH);
                    if (this.yAxisSelected) {
                        g2d.setColor(Y_AXIS_COLOR_SELECTED);
                    } else {
                        g2d.setColor(Y_AXIS_COLOR);
                    }
                    g2d.drawRect(4, 4, 52, height + 30 - 8);
                }
            }
            if (this.isDataMode && this.currentIndex != -1) {
                g2d.setFont(FONT);
                g2d.setStroke(oldStroke);
                String meanString = String.valueOf(FORMATTER_LARGE.format(this.mean));
                int startY = (int)((this.highest - this.mean) / (this.highest - this.lowest) * (double)height + 15.0 + 5.0);
                g2d.setColor(Color.BLACK);
                g2d.drawLine(58, startY - 5, 60, startY - 5);
                g2d.drawString(meanString, 64, startY);
            }
        } else {
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.setFont(FONT_MEDIUM2);
            String valueText = "Select a line to begin.";
            TextLayout textLayout = new TextLayout("Select a line to begin.", FONT_MEDIUM2, g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int textLayoutHeight = (int)textLayout.getBounds().getHeight();
            g2d.drawString("Select a line to begin.", width / 2 - textLayoutWidth / 2 + 60, height / 2 + textLayoutHeight / 2 + 10);
        }
    }

    private int getCurrentIndex() {
        int currentIndex = 0;
        if (this.currentShape != null) {
            for (int ctr = 0; ctr < this.shapes.length; ++ctr) {
                if (this.currentShape != this.shapes[ctr]) continue;
                currentIndex = ctr;
            }
        }
        return currentIndex;
    }

    private Shape getLineGraph(double[] someValues) {
        GeneralPath path = null;
        int width = (int)(this.getSize().getWidth() - 85.0);
        int height = (int)(this.getSize().getHeight() - 45.0);
        if (someValues != null && someValues.length > 0) {
            path = new GeneralPath();
            path.moveTo(60.0f, (int)((double)(height + 15) - (double)height * ((someValues[0] - this.lowest) / (this.highest - this.lowest))));
            for (int ctr = 1; ctr < someValues.length; ++ctr) {
                path.lineTo((int)(60.0 + (double)width * ((double)ctr / ((double)this.longest - 1.0))), (int)((double)(height + 15) - (double)height * ((someValues[ctr] - this.lowest) / (this.highest - this.lowest))));
            }
        }
        return path;
    }

    private void updateHighestAndLongest() {
        if (!this.yAxisSet && this.currentShape != null) {
            int ctr;
            if (this.isDataMode) {
                this.lowest = this.highest = this.values[0];
                for (ctr = 1; ctr < this.values.length; ++ctr) {
                    if (this.values[ctr] > this.highest) {
                        this.highest = this.values[ctr];
                    }
                    if (!(this.values[ctr] < this.lowest)) continue;
                    this.lowest = this.values[ctr];
                }
            } else if (this.isDerivativesMode) {
                this.lowest = this.highest = this.derivatives[0];
                for (ctr = 1; ctr < this.derivatives.length; ++ctr) {
                    if (this.derivatives[ctr] > this.highest) {
                        this.highest = this.derivatives[ctr];
                    }
                    if (!(this.derivatives[ctr] < this.lowest)) continue;
                    this.lowest = this.derivatives[ctr];
                }
            } else if (this.isCumulativesMode) {
                this.lowest = this.highest = this.cumulatives[0];
                for (ctr = 1; ctr < this.cumulatives.length; ++ctr) {
                    if (this.cumulatives[ctr] > this.highest) {
                        this.highest = this.cumulatives[ctr];
                    }
                    if (!(this.cumulatives[ctr] < this.lowest)) continue;
                    this.lowest = this.cumulatives[ctr];
                }
            }
        }
        this.longest = 0;
        if (this.isDataMode && this.values != null && this.values.length > 0) {
            this.longest = this.values.length;
        } else if (this.isDerivativesMode && this.derivatives != null && this.derivatives.length > 0) {
            this.longest = this.derivatives.length;
        } else if (this.isCumulativesMode && this.cumulatives != null && this.cumulatives.length > 0) {
            this.longest = this.cumulatives.length;
        }
        if (this.storedValues.size() > 0) {
            Enumeration<double[]> en = this.storedValues.elements();
            while (en.hasMoreElements()) {
                double[] someValues = en.nextElement();
                if (someValues == this.values) continue;
                if (!this.yAxisSet && (this.isDerivativesMode || this.isCumulativesMode)) {
                    for (double someValue : someValues) {
                        if (someValue > this.highest) {
                            this.highest = someValue;
                        }
                        if (!(someValue < this.lowest)) continue;
                        this.lowest = someValue;
                    }
                }
                if (this.longest >= someValues.length) continue;
                this.longest = someValues.length;
            }
        }
    }

    private void updateHighlighting() {
        this.updateHighlighting(false);
    }

    private void updateHighlighting(boolean clearOnly) {
        if (this.shapes != null) {
            for (Line shape : this.shapes) {
                if (clearOnly) {
                    shape.setHighlighted(false);
                    continue;
                }
                shape.setHighlighted(shape == this.currentShape);
            }
        }
    }

    @Override
    public String getCaptureType() {
        return "cross-section";
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput) {
    }
}

