/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.roi;

import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.core.ViewerAssociated;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterRejectionData;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.roi.ClusterROIAnalysisPanel;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.roi.ClusterROIManager;
import edu.uthscsa.ric.utilities.BitUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ClusterROIAnalysisTool
extends JFrame
implements ActionListener,
MangoColorSelectedListener,
ViewerAssociated,
ClusterROIManager {
    private ClusterROIAnalysisPanel filterPanel;
    private JButton convertButton;
    private JButton filterButton;
    private JButton searchButton;
    private JButton statsButton;
    private JLabel resultLabel;
    private JLabel infoLabel;
    private JPanel buttonPanel;
    private JPanel firstPanel;
    private JPanel thirdPanel;
    private MangoColorButton roiButton;
    private boolean hasConverted;
    private boolean hasRunSearch;
    private final SliceViewer viewer;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_DONE = "Done";
    public static final String ACTION_FIND = "Find components";
    public static final String ACTION_RESET = "Reset";
    public static final String ACTION_SPLIT = "Split components into multiple colors";
    public static final String ACTION_STATS = "Create stats of components";
    public static final String ACTION_FILTER = "Delete filtered components";
    public static final String BORDER_TITLE_FIRST = "1. Select ROI color";
    public static final String BORDER_TITLE_SECOND = "2. Select number of components";
    public static final String BORDER_TITLE_THIRD = "3. Component actions";
    public static final String LABEL_INFO = "Changes will be reflected dynamically in the viewer";
    public static final String NAME = "Find ROI Components";
    public static final String RESULT_NO_ROI = "Add an ROI and click Reset to begin...";

    public ClusterROIAnalysisTool(SliceViewer viewer) {
        this.viewer = viewer;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_FIND)) {
            this.hasRunSearch = true;
            this.filterPanel.setROIColor(this.roiButton.getColor());
            this.filterPanel.findClusters(this);
        } else if (command.equals(ACTION_SPLIT)) {
            this.hasConverted = true;
            this.filterPanel.makeROIs();
        } else if (command.equals(ACTION_STATS)) {
            this.filterPanel.analyzeClusters(true);
        } else if (command.equals(ACTION_RESET)) {
            this.reset();
        } else if (command.equals(ACTION_DONE)) {
            this.reset();
            this.setVisible(false);
        } else if (command.equals(ACTION_FILTER)) {
            this.filterPanel.filterROI();
        }
    }

    public void setROIColor(int roiColor) {
        this.roiButton.setColor(roiColor);
        this.filterPanel.setROIColor(this.roiButton.getColor());
        this.filterPanel.updateClusterUI(this, this.viewer.getROIManager().getClusterData(this.roiButton.getColor()));
        this.hasRunSearch = true;
        this.filterPanel.updateEnabledState();
        this.updateEnabledState();
    }

    public void colorSelected(int color) {
        this.reset();
    }

    @Override
    public void finishedFilteringClusters() {
        this.reset();
    }

    @Override
    public void finishedFindingClusters(int numClusters) {
        this.resultLabel.setText(numClusters + " " + (numClusters == 1 ? "component found" : "components found"));
        this.updateEnabledState();
    }

    @Override
    public void finishedSplittingClusters() {
        this.updateEnabledState();
    }

    @Override
    public String getDescription() {
        return NAME;
    }

    @Override
    public SliceViewer getViewer() {
        return this.viewer;
    }

    @Override
    public JFrame getWindow() {
        return this;
    }

    @Override
    public void numberOfVisibleClustersHasChanged(int numVisibleClusters, int numTotalClusters) {
        int numAvailableColors = Long.bitCount(this.viewer.getROIManager().getUsedMask() ^ 0xFFFFFFFFFFFFFFFFL);
        if (numAvailableColors < numVisibleClusters) {
            this.infoLabel.setText("Warning: components (" + numVisibleClusters + ") exceed available colors (" + numAvailableColors + ")");
            this.infoLabel.setForeground(Color.RED);
            this.convertButton.setEnabled(false);
        } else {
            ClusterRejectionData crd = this.viewer.getROIManager().getClusterData(this.filterPanel.getROIColor());
            boolean enabled = this.hasRunSearch && crd != null;
            this.infoLabel.setText(LABEL_INFO);
            this.infoLabel.setForeground(Color.GRAY);
            this.convertButton.setEnabled(enabled && !this.hasConverted && crd.clusters.getNumNonZeroClusters() > 1 && numVisibleClusters > 1);
            this.filterButton.setEnabled(enabled && !this.hasConverted && this.filterPanel.isFiltering());
        }
    }

    public void roiTimepointChanged() {
        this.reset();
    }

    private void buildFilterPanel() {
        this.filterPanel = new ClusterROIAnalysisPanel(this.viewer, this);
        JPanel infoLabelPanel = new JPanel();
        infoLabelPanel.setLayout(new BoxLayout(infoLabelPanel, 0));
        infoLabelPanel.add(Box.createHorizontalGlue());
        infoLabelPanel.add(this.infoLabel);
        infoLabelPanel.add(Box.createHorizontalGlue());
        JPanel secondPanel = new JPanel();
        secondPanel.setLayout(new BoxLayout(secondPanel, 1));
        secondPanel.add(Box.createVerticalGlue());
        secondPanel.add(this.filterPanel);
        secondPanel.add(Box.createVerticalGlue());
        secondPanel.add(infoLabelPanel);
        secondPanel.add(Box.createVerticalGlue());
        secondPanel.setPreferredSize(new Dimension(390, 100));
        secondPanel.setMinimumSize(new Dimension(390, 100));
        secondPanel.setMaximumSize(new Dimension(390, 100));
        secondPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), BORDER_TITLE_SECOND));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.firstPanel);
        mainPanel.add(secondPanel);
        mainPanel.add(this.thirdPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(this.buttonPanel);
        JPanel mainPanelOut = new JPanel(new BorderLayout());
        mainPanelOut.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanelOut.add((Component)mainPanel, "Center");
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        contentPane.add((Component)mainPanelOut, "Center");
        this.validate();
        this.pack();
        this.viewer.updateViewer();
        this.viewer.updateROISlices();
    }

    private void buildFirstPanel() {
        boolean hasROIs = this.viewer.getROIManager().hasROI();
        this.firstPanel = new JPanel();
        this.firstPanel.setLayout(new BoxLayout(this.firstPanel, 0));
        this.firstPanel.add(Box.createHorizontalGlue());
        if (hasROIs) {
            this.firstPanel.add(this.roiButton);
            this.firstPanel.add(Box.createHorizontalGlue());
            this.firstPanel.add(this.searchButton);
            this.firstPanel.add(Box.createHorizontalGlue());
            this.resultLabel.setText("0 components found");
        } else {
            this.resultLabel.setText(RESULT_NO_ROI);
        }
        this.firstPanel.add(this.resultLabel);
        this.firstPanel.add(Box.createHorizontalGlue());
        this.firstPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), BORDER_TITLE_FIRST));
        this.firstPanel.setPreferredSize(new Dimension(390, 85));
        this.firstPanel.setMinimumSize(new Dimension(390, 85));
        this.firstPanel.setMaximumSize(new Dimension(390, 85));
    }

    private void createUI() {
        this.roiButton = (MangoColorButton)this.viewer.createColorPickerButton(this, true);
        this.roiButton.setColor(BitUtilities.findNextSetBitIndex((long)this.viewer.getROIManager().getUsedMask(), (int)0));
        this.searchButton = new JButton(ACTION_FIND);
        this.searchButton.addActionListener(this);
        this.resultLabel = new JLabel("0 components found");
        this.infoLabel = new JLabel(LABEL_INFO, 0);
        this.infoLabel.setForeground(Color.GRAY);
        this.filterButton = new JButton(ACTION_FILTER);
        this.filterButton.addActionListener(this);
        JPanel filterButtonPanel = new JPanel();
        filterButtonPanel.setLayout(new BoxLayout(filterButtonPanel, 0));
        filterButtonPanel.add(Box.createHorizontalGlue());
        filterButtonPanel.add(this.filterButton);
        filterButtonPanel.add(Box.createHorizontalGlue());
        this.convertButton = new JButton(ACTION_SPLIT);
        this.convertButton.addActionListener(this);
        JPanel convertButtonPanel = new JPanel();
        convertButtonPanel.setLayout(new BoxLayout(convertButtonPanel, 0));
        convertButtonPanel.add(Box.createHorizontalGlue());
        convertButtonPanel.add(this.convertButton);
        convertButtonPanel.add(Box.createHorizontalGlue());
        this.statsButton = new JButton(ACTION_STATS);
        this.statsButton.addActionListener(this);
        JPanel statsButtonPanel = new JPanel();
        statsButtonPanel.setLayout(new BoxLayout(statsButtonPanel, 0));
        statsButtonPanel.add(Box.createHorizontalGlue());
        statsButtonPanel.add(this.statsButton);
        statsButtonPanel.add(Box.createHorizontalGlue());
        this.thirdPanel = new JPanel();
        this.thirdPanel.setLayout(new BoxLayout(this.thirdPanel, 1));
        this.thirdPanel.add(Box.createVerticalGlue());
        this.thirdPanel.add(statsButtonPanel);
        this.thirdPanel.add(Box.createVerticalGlue());
        this.thirdPanel.add(convertButtonPanel);
        this.thirdPanel.add(Box.createVerticalGlue());
        this.thirdPanel.add(filterButtonPanel);
        this.thirdPanel.add(Box.createVerticalGlue());
        this.thirdPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), BORDER_TITLE_THIRD));
        JButton resetButton = new JButton(ACTION_RESET);
        resetButton.addActionListener(this);
        JButton doneButton = new JButton(ACTION_DONE);
        doneButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(resetButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(doneButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.reset();
        this.setTitle("Find ROI Components: " + this.viewer.getImageTitle());
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setLocation(DisplayUtils.getNextWindowLocation(this.viewer.getViewerContainer(), this.getSize(), null, this.viewer.getMango().isApplet()));
        this.setVisible(true);
    }

    public final void reset() {
        this.hasRunSearch = false;
        this.hasConverted = false;
        if (this.filterPanel != null) {
            this.filterPanel.removeClusterFilter();
            this.filterPanel = null;
        }
        this.buildFirstPanel();
        this.buildFilterPanel();
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        ClusterRejectionData crd = this.viewer.getROIManager().getClusterData(this.filterPanel.getROIColor());
        boolean enabled = this.hasRunSearch && crd != null;
        this.searchButton.setEnabled(!this.hasRunSearch);
        this.filterPanel.updateEnabledState(this.hasConverted);
        this.convertButton.setEnabled(enabled && !this.hasConverted && crd.clusters.getNumNonZeroClusters() > 1 && this.filterPanel.getNumVisibleComponents() > 1);
        this.filterButton.setEnabled(enabled && !this.hasConverted && this.filterPanel.isFiltering());
        this.resultLabel.setEnabled(enabled && !this.hasConverted);
        this.statsButton.setEnabled(enabled && !this.hasConverted);
    }
}

