/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.overlay;

import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterRejectionData;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterStat;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.operations.ClusterOperations;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.overlay.ClusterManager;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ClusterAnalysisPanel
extends JPanel
implements ActionListener,
PopupMenuListener {
    private JButton optionsButton;
    private JMenuItem hideItem;
    private JPopupMenu popup;
    private JSlider countSlider;
    private MangoTextField countText;
    private MangoTextField sizeText;
    private boolean findingClusters;
    private int countSliderLastValue;
    private long popupTimeCanceled;
    private final ImageIcon icon;
    private final MangoNumberFormatter formatter = new MangoNumberFormatter();
    private final SliceViewer viewer;
    private final ScreenVolume screenVol;
    private static final long serialVersionUID = 1L;
    public static final Color ACTIVE_BACKGROUND = new Color(225, 225, 225);
    public static final Color HIDDEN_BACKGROUND = new Color(175, 175, 175);
    public static final String ACTION_FIND = "Find next cluster";
    public static final String ACTION_REMOVE = "Remove this filter";
    public static final String ACTION_ROI = "Create ROIs of clusters";
    public static final String ACTION_STATS = "Create stats of clusters";
    public static final String NO_CLUSTERS_LABEL = "No clusters found. Click to try again...";
    public static final String START_LABEL = "Click button to search for clusters...";
    public static final int DEFAULT_CLUSTER_COUNT = 8;
    public static final int HEIGHT = 60;
    public static final int WIDTH = 380;

    protected ClusterAnalysisPanel(SliceViewer viewer, ScreenVolume screenVol, ImageIcon icon) {
        this.viewer = viewer;
        this.screenVol = screenVol;
        this.icon = icon;
        this.updatePanel();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("Find Clusters")) {
            this.findClusters(null);
        } else if (command.equals("Size")) {
            double mmVol = this.viewer.getVolume().getXSize() * this.viewer.getVolume().getYSize() * this.viewer.getVolume().getZSize();
            try {
                double filterValue = Double.parseDouble(this.sizeText.getText());
                this.updateClustersBySize((int)Math.round(filterValue / mmVol), mmVol);
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
                this.sizeText.setText("0");
                this.countSlider.setValue(0);
            }
        } else if (command.equals("Count")) {
            try {
                int clusterCount = Integer.parseInt(this.countText.getText());
                this.updateClustersByCount(clusterCount);
            }
            catch (Exception ex) {
                AppLogger.warn((Throwable)ex);
                this.sizeText.setText("0");
                this.countSlider.setValue(0);
            }
        } else if (command.equals("show popup")) {
            this.showPopup();
        } else if (command.equals(ACTION_STATS)) {
            this.analyzeClusters(true);
        } else if (command.equals(ACTION_FIND)) {
            this.findNextCluster();
        } else if (command.equals(ACTION_ROI)) {
            this.makeROIs();
        } else if (command.equals("Disable")) {
            this.disableClusterFilter();
        } else if (command.equals("Enable")) {
            this.enableClusterFilter();
        } else if (command.equals(ACTION_REMOVE)) {
            this.removeClusterFilter();
        }
    }

    public ScreenVolume getScreenVolume() {
        return this.screenVol;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popup) {
            this.popupTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    protected void analyzeClusters(boolean analyzeAll) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int numClustersToDisplay = 0;
                try {
                    numClustersToDisplay = Integer.parseInt(ClusterAnalysisPanel.this.countText.getText());
                }
                catch (Exception ex) {
                    AppLogger.info((Throwable)ex);
                }
                Vector<ClusterStat> clusterVec = ClusterOperations.analyzeClusters(ClusterAnalysisPanel.this.viewer, ClusterAnalysisPanel.this.screenVol.getVolume(), ClusterAnalysisPanel.this.screenVol.getClusterData());
                ClusterAnalysisPanel.printClusters(ClusterAnalysisPanel.this.viewer, ClusterAnalysisPanel.this.screenVol, numClustersToDisplay, clusterVec);
            }
        }, "ClusterAnalysisPanel.analyzeClusters() Thread");
        workThread.start();
    }

    public static void printClusters(final SliceViewer viewer, final ScreenVolume overlay, int numClustersToDisplay, final Vector<ClusterStat> clusterVec) {
        final int numClustersToDisplayF = numClustersToDisplay;
        if (clusterVec != null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Iterator it = clusterVec.iterator();
                        int count = 0;
                        while (it.hasNext()) {
                            ClusterStat cluster = (ClusterStat)it.next();
                            if (count >= numClustersToDisplayF) continue;
                            AnalysisImpl analysis = cluster.makeAnalysis(overlay);
                            analysis.setUnitSize(viewer.getVolume().getVoxelVolume());
                            analysis.setDescription("Cluster " + (count + 1) + " of " + numClustersToDisplayF);
                            viewer.getMango().getResultsManager().addStatistic(viewer, overlay.getVolume(), analysis);
                            ++count;
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    protected void disableClusterFilter() {
        ClusterRejectionData crd = this.screenVol.getClusterData();
        if (crd != null) {
            crd.hiding = true;
            this.hideItem.setText("Enable");
            this.hideItem.setActionCommand("Enable");
            SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)this, (Color)HIDDEN_BACKGROUND, (Class[])new Class[]{JTextField.class});
            this.viewer.forceImageUpdate();
            this.viewer.updateScreenSlices();
        }
    }

    protected void enableClusterFilter() {
        ClusterRejectionData crd = this.screenVol.getClusterData();
        if (crd != null) {
            crd.hiding = false;
            this.hideItem.setText("Disable");
            this.hideItem.setActionCommand("Disable");
            SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)this, (Color)ACTIVE_BACKGROUND, (Class[])new Class[]{JTextField.class});
            this.viewer.forceImageUpdate();
            this.viewer.updateScreenSlices();
        }
    }

    protected void findClusters(final ClusterManager cm) {
        if (this.findingClusters) {
            return;
        }
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ClusterAnalysisPanel.this.findingClusters = true;
                ClusterOperations.findCluster(ClusterAnalysisPanel.this.viewer, ClusterAnalysisPanel.this.screenVol, ClusterAnalysisPanel.this.screenVol.getDynamicScreenMin());
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ClusterAnalysisPanel.this.updatePanel();
                        ClusterAnalysisPanel.this.updateClustersByCount();
                        if (cm != null) {
                            cm.finishedFindingClusters(((ClusterAnalysisPanel)ClusterAnalysisPanel.this).screenVol.getClusterData().clusters.getNumNonZeroClusters());
                        }
                    }
                });
                ClusterAnalysisPanel.this.findingClusters = false;
            }
        }, "ClusterAnalysisPanel.findClusters() Thread");
        workThread.start();
    }

    protected boolean hasClusterData() {
        return this.screenVol.getClusterData() != null;
    }

    protected void removeClusterFilter() {
        ClusterRejectionData crd = this.screenVol.getClusterData();
        if (crd != null) {
            crd.cleanup();
            this.screenVol.setClusterData(null);
            this.updatePanel();
            this.viewer.forceImageUpdate();
            this.viewer.updateScreenSlices();
        }
    }

    protected void updateClustersByCount() {
        ClusterRejectionData crd = this.screenVol.getClusterData();
        this.updateClustersByCount(Math.min(8, crd.clusters.getNumNonZeroClusters()));
    }

    private void findNextCluster() {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                double filterValue = Double.parseDouble(ClusterAnalysisPanel.this.sizeText.getText());
                double mmVol = ClusterAnalysisPanel.this.viewer.getVolume().getXSize() * ClusterAnalysisPanel.this.viewer.getVolume().getYSize() * ClusterAnalysisPanel.this.viewer.getVolume().getZSize();
                final Coordinate coord = ClusterOperations.findNextCluster(ClusterAnalysisPanel.this.viewer, ClusterAnalysisPanel.this.screenVol, ClusterAnalysisPanel.this.screenVol.getClusterData(), ClusterAnalysisPanel.this.viewer.getCurrentIndex(null), (int)Math.round(filterValue / mmVol));
                if (coord != null) {
                    SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ClusterAnalysisPanel.this.viewer.setCurrentCoordinate(coord, true, 0);
                        }
                    });
                }
            }
        }, "ClusterAnalysisPanel.findNextCluster() Thread");
        workThread.start();
    }

    private void makePopupMenu() {
        this.popup = new JPopupMenu();
        this.popup.addPopupMenuListener(this);
        JMenuItem findItem = new JMenuItem(ACTION_FIND);
        findItem.addActionListener(this);
        this.popup.add(findItem);
        JMenuItem analyzeAllItem = new JMenuItem(ACTION_STATS);
        analyzeAllItem.addActionListener(this);
        this.popup.add(analyzeAllItem);
        JMenuItem roiItem = new JMenuItem(ACTION_ROI);
        roiItem.addActionListener(this);
        this.popup.add(roiItem);
        this.popup.add(new JToolBar.Separator(new Dimension(0, 8)));
        JMenuItem removeItem = new JMenuItem(ACTION_REMOVE);
        removeItem.addActionListener(this);
        this.popup.add(removeItem);
    }

    private void makeROIs() {
        double filterValue = 0.0;
        try {
            filterValue = Double.parseDouble(this.sizeText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        double mmVol = this.viewer.getVolume().getXSize() * this.viewer.getVolume().getYSize() * this.viewer.getVolume().getZSize();
        final int size = (int)Math.round(filterValue / mmVol);
        this.viewer.recordAction("runGenerateClusterROI", new String[]{null, String.valueOf(size)});
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ClusterOperations.makeROIOfCluster(ClusterAnalysisPanel.this.viewer.getROIManager(), ClusterAnalysisPanel.this.screenVol.getClusterData(), size, 0L, null);
            }
        }, "ClusterAnalysisPanel.makeROIs() Thread");
        workThread.start();
    }

    private void showPopup() {
        long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
        if (timeSinceCancel > 250L) {
            this.popup.show(this.optionsButton, this.optionsButton.getPreferredSize().width, 0);
        }
    }

    private void updateClustersByCount(int numClusters) {
        double mmVol = this.viewer.getVolume().getXSize() * this.viewer.getVolume().getYSize() * this.viewer.getVolume().getZSize();
        this.countText.setText(String.valueOf(numClusters));
        ClusterRejectionData crd = this.screenVol.getClusterData();
        crd.contains = new boolean[crd.clusters.getNumClusters() + 1];
        double clusterSize = ROIManager.rejectSmallClusters(crd.contains, crd.clusters, numClusters);
        this.countSlider.setValue(numClusters);
        this.sizeText.setText(this.formatter.format(clusterSize * mmVol));
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ClusterAnalysisPanel.this.viewer.forceImageUpdate();
                ClusterAnalysisPanel.this.viewer.updateScreenSlices();
            }
        });
    }

    private void updateClustersBySize(int numVoxels, double voxelVolume) {
        int numClusters;
        this.sizeText.setText(this.formatter.format((double)numVoxels * voxelVolume));
        ClusterRejectionData crd = this.screenVol.getClusterData();
        crd.contains = new boolean[crd.clusters.getNumClusters() + 1];
        crd.numClusters = numClusters = ROIManager.rejectSmallClusters(crd.contains, crd.clusters, (double)numVoxels);
        this.countText.setText(String.valueOf(numClusters));
        this.countSlider.setValue(numClusters);
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ClusterAnalysisPanel.this.viewer.forceImageUpdate();
                ClusterAnalysisPanel.this.viewer.updateScreenSlices();
            }
        });
    }

    private void updatePanel() {
        this.removeAll();
        ClusterRejectionData crd = this.screenVol.getClusterData();
        boolean hasClusterData = crd != null;
        boolean hasClusters = hasClusterData && crd.clusters.getNumNonZeroClusters() > 0;
        this.setLayout(new BoxLayout(this, 0));
        JButton goButton = new JButton(this.icon);
        goButton.setActionCommand("Find Clusters");
        goButton.addActionListener(this);
        goButton.setPreferredSize(new Dimension(goButton.getPreferredSize().height, goButton.getPreferredSize().height));
        goButton.setMaximumSize(goButton.getPreferredSize());
        goButton.setMinimumSize(goButton.getPreferredSize());
        this.hideItem = new JMenuItem();
        JLabel startLabel = new JLabel();
        startLabel.setForeground(Color.GRAY);
        this.add(Box.createHorizontalStrut(6));
        this.add(goButton);
        this.add(Box.createHorizontalGlue());
        if (!hasClusterData) {
            startLabel.setText(START_LABEL);
            this.add(startLabel);
        } else if (!hasClusters) {
            startLabel.setText(NO_CLUSTERS_LABEL);
            this.add(startLabel);
        }
        JLabel clusterLabel = new JLabel("<html>Cluster Filter<sup> </sup></html>", 0);
        JPanel clusterLabelPanel = new JPanel();
        clusterLabelPanel.setLayout(new BoxLayout(clusterLabelPanel, 0));
        clusterLabelPanel.add(Box.createHorizontalGlue());
        clusterLabelPanel.add(clusterLabel);
        clusterLabelPanel.add(Box.createHorizontalGlue());
        this.countSlider = new JSlider(1, 100, 1);
        this.countSlider.setFocusable(false);
        if (Platform.WINDOWS) {
            this.countSlider.setPaintTicks(true);
        }
        if (this.screenVol.getClusterData() != null) {
            this.countSlider.setMaximum(crd.clusters.getNumNonZeroClusters());
            this.countSlider.setValue(crd.numClusters);
        }
        this.countSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int countSliderNewValue = ClusterAnalysisPanel.this.countSlider.getValue();
                if (countSliderNewValue != ClusterAnalysisPanel.this.countSliderLastValue) {
                    ClusterAnalysisPanel.this.countText.setText(String.valueOf(countSliderNewValue));
                    ClusterAnalysisPanel.this.updateClustersByCount(countSliderNewValue);
                    ClusterAnalysisPanel.this.countSliderLastValue = countSliderNewValue;
                }
            }
        });
        JPanel sizeSliderPanel = new JPanel();
        sizeSliderPanel.setLayout(new BoxLayout(sizeSliderPanel, 0));
        sizeSliderPanel.add(Box.createHorizontalGlue());
        sizeSliderPanel.add(this.countSlider);
        sizeSliderPanel.add(Box.createHorizontalGlue());
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BoxLayout(filterPanel, 1));
        if (Platform.WINDOWS) {
            filterPanel.add(Box.createVerticalGlue());
        }
        filterPanel.add(clusterLabelPanel);
        filterPanel.add(sizeSliderPanel);
        JLabel sizeLabel = new JLabel("<html>Size (mm<sup>3</sup>)</html>", 0);
        JPanel sizeLabelPanel = new JPanel();
        sizeLabelPanel.setLayout(new BoxLayout(sizeLabelPanel, 0));
        sizeLabelPanel.add(Box.createHorizontalGlue());
        sizeLabelPanel.add(sizeLabel);
        sizeLabelPanel.add(Box.createHorizontalGlue());
        this.sizeText = new MangoTextField("", 6);
        this.sizeText.setMinimumSize(this.sizeText.getPreferredSize());
        this.sizeText.setMaximumSize(this.sizeText.getPreferredSize());
        this.sizeText.addActionListener(this);
        this.sizeText.setActionCommand("Size");
        JPanel sizeTextPanel = new JPanel();
        sizeTextPanel.setLayout(new BoxLayout(sizeTextPanel, 0));
        sizeTextPanel.add(Box.createHorizontalGlue());
        sizeTextPanel.add(this.sizeText);
        sizeTextPanel.add(Box.createHorizontalGlue());
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new BoxLayout(sizePanel, 1));
        sizePanel.add(sizeLabelPanel);
        sizePanel.add(Box.createVerticalStrut(2));
        sizePanel.add(sizeTextPanel);
        JLabel countLabel = new JLabel("<html>Rank<sup> </sup></html>", 0);
        JPanel countLabelPanel = new JPanel();
        countLabelPanel.setLayout(new BoxLayout(countLabelPanel, 0));
        countLabelPanel.add(Box.createHorizontalGlue());
        countLabelPanel.add(countLabel);
        countLabelPanel.add(Box.createHorizontalGlue());
        this.countText = new MangoTextField(crd != null ? String.valueOf(crd.numClusters) : "", 4);
        this.countText.setMinimumSize(this.countText.getPreferredSize());
        this.countText.setMaximumSize(this.countText.getPreferredSize());
        this.countText.addActionListener(this);
        this.countText.setActionCommand("Count");
        JPanel countTextPanel = new JPanel();
        countTextPanel.setLayout(new BoxLayout(countTextPanel, 0));
        countTextPanel.add(Box.createHorizontalGlue());
        countTextPanel.add(this.countText);
        countTextPanel.add(Box.createHorizontalGlue());
        JPanel countPanel = new JPanel();
        countPanel.setLayout(new BoxLayout(countPanel, 1));
        countPanel.add(countLabelPanel);
        countPanel.add(Box.createVerticalStrut(2));
        countPanel.add(countTextPanel);
        JPanel filterControlsPanel = new JPanel();
        filterControlsPanel.setLayout(new BoxLayout(filterControlsPanel, 0));
        filterControlsPanel.add(Box.createHorizontalGlue());
        filterControlsPanel.add(Box.createHorizontalStrut(2));
        filterControlsPanel.add(filterPanel);
        filterControlsPanel.add(Box.createHorizontalStrut(2));
        filterControlsPanel.add(countPanel);
        filterControlsPanel.add(Box.createHorizontalStrut(2));
        filterControlsPanel.add(sizePanel);
        filterControlsPanel.add(Box.createHorizontalStrut(2));
        filterControlsPanel.add(Box.createHorizontalGlue());
        if (hasClusterData && hasClusters) {
            this.add(filterControlsPanel);
        }
        this.optionsButton = new JButton(MangoStyle.ICON_OPTIONS);
        this.optionsButton.setMinimumSize(this.optionsButton.getPreferredSize());
        this.optionsButton.setMaximumSize(this.optionsButton.getPreferredSize());
        this.optionsButton.setActionCommand("show popup");
        this.optionsButton.addActionListener(this);
        this.makePopupMenu();
        this.add(Box.createHorizontalGlue());
        if (hasClusterData && hasClusters) {
            this.add(this.optionsButton);
            this.add(Box.createHorizontalStrut(4));
        }
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setPreferredSize(new Dimension(380, 60));
        this.setMinimumSize(new Dimension(380, 60));
        this.setMaximumSize(new Dimension(380, 60));
        SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)this, (Color)ACTIVE_BACKGROUND, (Class[])new Class[]{JTextField.class});
        this.validate();
        this.repaint();
    }
}

