/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.operations;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterRejectionData;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterStat;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.roi.EquivalentSet;
import edu.uthscsa.ric.roi.EquivalentSetManager;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.utilities.BitUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public final class ClusterOperations {
    private ClusterOperations() {
    }

    public static Vector<ClusterStat> analyzeClusters(VolumeManager viewer, Volume overlay, ClusterRejectionData data) {
        TreeMap<Integer, ClusterStat> clusterMap = new TreeMap<Integer, ClusterStat>();
        int[] clusterDataMap = new int[data.clusters.getNumLabels()];
        ClusterOperations.mapAllClusters(clusterDataMap, data.clusters);
        int xDim = viewer.getBaseVolume().getXDim() + 1;
        int yDim = viewer.getBaseVolume().getYDim() + 1;
        int zDim = viewer.getBaseVolume().getZDim() + 1;
        for (EquivalentSet set : data.clusters.getAllSetsOrdered()) {
            int clusterId = set.hashCode();
            int count = data.clusters.getCountsInSet(set);
            if (count <= 0) continue;
            ClusterStat cluster = new ClusterStat(count);
            clusterMap.put(clusterId, cluster);
        }
        ProgressMeter progress = viewer.makeProgressMeter();
        progress.setDescription("Analyzing Clusters");
        progress.start(0, 0, zDim);
        VolumeData volData = new VolumeData(viewer, overlay);
        for (int ctrZ = 0; ctrZ < zDim; ++ctrZ) {
            progress.setValue(ctrZ);
            for (int ctrY = 0; ctrY < yDim; ++ctrY) {
                for (int ctrX = 0; ctrX < xDim; ++ctrX) {
                    int clusterId;
                    ClusterStat cluster;
                    int index = ctrZ * xDim * yDim + ctrY * xDim + ctrX;
                    int label = data.buffer.get(index);
                    if (label <= 0 || (cluster = (ClusterStat)clusterMap.get(clusterId = clusterDataMap[label])) == null) continue;
                    double value = volData.getValue(ctrX, ctrY, ctrZ);
                    if (value > cluster.max) {
                        cluster.max = value;
                        cluster.maxCoord.setValues((double)ctrX, (double)ctrY, (double)ctrZ);
                    }
                    if (value < cluster.min) {
                        cluster.min = value;
                        cluster.minCoord.setValues((double)ctrX, (double)ctrY, (double)ctrZ);
                    }
                    double currentABS = Math.abs(value);
                    cluster.weightedSumX += currentABS * (double)ctrX;
                    cluster.weightedSumY += currentABS * (double)ctrY;
                    cluster.weightedSumZ += currentABS * (double)ctrZ;
                    cluster.sum += value;
                    cluster.comSum += currentABS;
                    cluster.sumSquared += MathUtilities.pow((double)value, (double)2.0);
                    ++cluster.size;
                }
            }
        }
        progress.setValue(progress.getMax());
        Collection clusters = clusterMap.values();
        Vector<ClusterStat> clusterVec = new Vector<ClusterStat>(clusters);
        Collections.sort(clusterVec, new ClusterComparator());
        for (ClusterStat cluster : clusterVec) {
            Coordinate centroid = cluster.getCentroid();
            cluster.centroid = volData.getValue(centroid.xInt, centroid.yInt, centroid.zInt);
        }
        return clusterVec;
    }

    public static Coordinate findNextCluster(SliceViewer viewer, ScreenVolume overlay, ClusterRejectionData data, Coordinate analyzeCoord, int minSize) {
        int index;
        int label;
        int[] clusterDataMap = new int[data.clusters.getNumLabels()];
        ClusterOperations.mapAllClusters(clusterDataMap, data.clusters);
        int xDim = viewer.getVolume().getXDim() + 1;
        int yDim = viewer.getVolume().getYDim() + 1;
        int zDim = viewer.getVolume().getZDim() + 1;
        int clusterToSearch = -1;
        if (analyzeCoord != null && (label = data.buffer.get(index = analyzeCoord.zInt * xDim * yDim + analyzeCoord.yInt * xDim + analyzeCoord.xInt)) > 0) {
            clusterToSearch = clusterDataMap[label];
        }
        Iterator<EquivalentSet> it = data.clusters.getAllSetsOrdered().iterator();
        ClusterStat cluster = null;
        boolean findNextCluster = false;
        while (it.hasNext() && cluster == null) {
            EquivalentSet set = it.next();
            int clusterId = set.hashCode();
            int count = data.clusters.getCountsInSet(set);
            if (count >= minSize && (clusterToSearch == -1 || findNextCluster)) {
                cluster = new ClusterStat(count);
                clusterToSearch = clusterId;
            }
            findNextCluster = clusterToSearch == clusterId;
        }
        if (cluster == null) {
            cluster = new ClusterStat(data.clusters.getCountsInSet(data.clusters.getAllSetsOrdered().get(0)));
            clusterToSearch = data.clusters.getAllSetsOrdered().get(0).hashCode();
        }
        VolumeData volData = null;
        if (overlay != null) {
            volData = new VolumeData(viewer, overlay.getVolume());
        }
        if (cluster != null) {
            ProgressMeter progress = viewer.makeProgressMeter();
            progress.setDescription("Finding Cluster");
            progress.start(0, 0, zDim);
            for (int ctrZ = 0; ctrZ < zDim; ++ctrZ) {
                progress.setValue(ctrZ);
                for (int ctrY = 0; ctrY < yDim; ++ctrY) {
                    for (int ctrX = 0; ctrX < xDim; ++ctrX) {
                        int clusterId;
                        int index2 = ctrZ * xDim * yDim + ctrY * xDim + ctrX;
                        int label2 = data.buffer.get(index2);
                        if (label2 <= 0 || (clusterId = clusterDataMap[label2]) != clusterToSearch) continue;
                        double value = overlay != null ? volData.getValue(ctrX, ctrY, ctrZ) : 1.0;
                        if (value > cluster.max) {
                            cluster.max = value;
                            cluster.maxCoord.setValues((double)ctrX, (double)ctrY, (double)ctrZ);
                        }
                        if (value < cluster.min) {
                            cluster.min = value;
                            cluster.minCoord.setValues((double)ctrX, (double)ctrY, (double)ctrZ);
                        }
                        double currentABS = Math.abs(value);
                        cluster.weightedSumX += currentABS * (double)ctrX;
                        cluster.weightedSumY += currentABS * (double)ctrY;
                        cluster.weightedSumZ += currentABS * (double)ctrZ;
                        cluster.sum += value;
                        cluster.comSum += currentABS;
                        cluster.sumSquared += MathUtilities.pow((double)value, (double)2.0);
                        ++cluster.size;
                    }
                }
                progress.setValue(progress.getMax());
            }
        }
        return cluster.maxCoord;
    }

    public static void makeROIOfCluster(ROIManager roiManager, ClusterRejectionData data, int minSize, long clearMask, String label) {
        TreeMap<Integer, ClusterStat> clusterMap = new TreeMap<Integer, ClusterStat>();
        int[] clusterDataMap = new int[data.clusters.getNumLabels()];
        ClusterOperations.mapAllClusters(clusterDataMap, data.clusters);
        long unusedMask = roiManager.getUsedMask() ^ 0xFFFFFFFFFFFFFFFFL;
        long colorMask = 0L;
        int nextFreeIndex = BitUtilities.findNextSetBitIndex((long)unusedMask, (int)0);
        int highestIndex = -1;
        int maxColors = roiManager.getMaximumColors();
        int index = 0;
        for (EquivalentSet set : data.clusters.getAllSetsOrdered()) {
            int clusterId = set.hashCode();
            int count = data.clusters.getCountsInSet(set);
            if (count >= minSize && count > 0) {
                ClusterStat cluster = new ClusterStat(count);
                cluster.roiColor = nextFreeIndex;
                colorMask |= 1L << nextFreeIndex;
                if (nextFreeIndex > highestIndex) {
                    highestIndex = nextFreeIndex;
                }
                cluster.label = label + " " + (index + 1);
                clusterMap.put(clusterId, cluster);
                ++index;
            }
            nextFreeIndex = BitUtilities.findNextSetBitIndex((long)unusedMask, (int)(nextFreeIndex + 1));
        }
        int maxColorsNew = maxColors;
        if (highestIndex >= maxColors) {
            maxColorsNew = highestIndex >= 32 ? 64 : (highestIndex >= 16 ? 32 : 16);
        }
        roiManager.doClusterROI(data, clusterDataMap, clusterMap, colorMask, clearMask, maxColorsNew);
        for (ClusterStat cluster : clusterMap.values()) {
            if (label == null) continue;
            roiManager.setLabel(cluster.roiColor, cluster.label, false);
        }
    }

    private static ClusterRejectionData createClusterRejectionData(SliceViewer viewer) {
        ClusterRejectionData crd = new ClusterRejectionData();
        crd.buffer = ROIManager.createROIFileBuffer3D(viewer.getROIManager().getXDim(), viewer.getROIManager().getYDim(), viewer.getROIManager().getZDim()).asIntBuffer();
        return crd;
    }

    public static void findCluster(SliceViewer viewer, ScreenVolume overlay, double screenMin) {
        viewer.recordAction("runClusterAnalysis", new String[]{null, String.valueOf(screenMin)}, true);
        if (overlay.getClusterData() == null) {
            overlay.setClusterData(ClusterOperations.createClusterRejectionData(viewer));
        } else {
            overlay.getClusterData().buffer.rewind();
        }
        ClusterRejectionData crd = overlay.getClusterData();
        crd.clusters = new EquivalentSetManager(true);
        boolean isNegative = overlay.isNegative();
        viewer.getROIManager().findComponentMapVolume(screenMin, isNegative, overlay.getVolume(), crd.buffer, crd.clusters);
    }

    public static ClusterRejectionData findClusterROI(SliceViewer viewer, int roiColor) {
        viewer.recordAction("runComponentAnalysisROI", new String[]{String.valueOf(roiColor)}, true);
        ROIManager roiManager = viewer.getROIManager();
        if (roiManager.getClusterData(roiColor) == null) {
            roiManager.setClusterData(ClusterOperations.createClusterRejectionData(viewer), roiColor);
        } else {
            roiManager.getClusterData((int)roiColor).buffer.rewind();
        }
        ClusterRejectionData crd = roiManager.getClusterData(roiColor);
        crd.clusters = new EquivalentSetManager(true);
        viewer.getROIManager().findComponentMapROI(roiColor, crd.buffer, crd.clusters);
        return crd;
    }

    private static void mapAllClusters(int[] map, EquivalentSetManager equivSetManager) {
        for (EquivalentSet set : equivSetManager.getAllSets()) {
            int count = equivSetManager.getCountsInSet(set);
            if (count <= 0) continue;
            Vector<Integer> labels = set.getLabels();
            int numItems = labels.size();
            for (int ctr = 0; ctr < numItems; ++ctr) {
                map[labels.get((int)ctr).intValue()] = set.hashCode();
            }
        }
    }

    static class ClusterComparator
    implements Comparator<ClusterStat>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ClusterComparator() {
        }

        @Override
        public int compare(ClusterStat o1, ClusterStat o2) {
            if (o2.count == o1.count) {
                if (o2.sum == o1.sum) {
                    if (o2.maxCoord.xInt == o1.maxCoord.xInt) {
                        if (o2.maxCoord.yInt == o1.maxCoord.yInt) {
                            return o2.maxCoord.zInt - o1.maxCoord.zInt;
                        }
                        return o2.maxCoord.yInt - o1.maxCoord.yInt;
                    }
                    return o2.maxCoord.xInt - o1.maxCoord.xInt;
                }
                return (int)Math.signum(o2.sum - o1.sum);
            }
            return o2.count - o1.count;
        }
    }
}

