/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.dialogs.cluster;

import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.Color;

public class ClusterStat {
    public Coordinate maxCoord;
    public Coordinate minCoord;
    public String label;
    public double centroid;
    public double comSum;
    public double max;
    public double min;
    public double sum;
    public double sumSquared;
    public double weightedSumX;
    public double weightedSumY;
    public double weightedSumZ;
    public int count;
    public int roiColor;
    public int size;

    public ClusterStat(int count) {
        this.count = count;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.minCoord = new Coordinate();
        this.maxCoord = new Coordinate();
    }

    public Coordinate getCentroid() {
        return new Coordinate(this.weightedSumX / this.comSum, this.weightedSumY / this.comSum, this.weightedSumZ / this.comSum);
    }

    public double getMean() {
        return this.sum / (double)this.size;
    }

    public double getStdev() {
        return Math.sqrt(((double)this.size * this.sumSquared - MathUtilities.pow((double)this.sum, (double)2.0)) / (double)((float)this.size * ((float)this.size - 1.0f)));
    }

    public AnalysisImpl makeAnalysis(ScreenVolume screenVol) {
        AnalysisImpl analysis = this.makeAnalysis(screenVol.getVolume());
        analysis.setColor(new Color(screenVol.getLookupTableManager().lookupRed(0), screenVol.getLookupTableManager().lookupGreen(0), screenVol.getLookupTableManager().lookupBlue(0)));
        analysis.setName(screenVol.getName());
        return analysis;
    }

    public AnalysisImpl makeAnalysis(Volume volume) {
        AnalysisImpl analysis = new AnalysisImpl(this.getMean(), this.min, this.max, this.sum, this.getStdev(), this.count);
        analysis.setMinCoordinate(new Coordinate4D(this.minCoord.xDbl, this.minCoord.yDbl, this.minCoord.zDbl, volume.getCurrentTimepoint()));
        analysis.setMaxCoordinate(new Coordinate4D(this.maxCoord.xDbl, this.maxCoord.yDbl, this.maxCoord.zDbl, volume.getCurrentTimepoint()));
        Coordinate centroidCoord = this.getCentroid();
        analysis.setCentroidCoordinate(new Coordinate4D(centroidCoord.xDbl, centroidCoord.yDbl, centroidCoord.zDbl, volume.getCurrentTimepoint()));
        analysis.setCentroid(this.centroid);
        analysis.setType(5);
        analysis.setDescription("Cluster");
        return analysis;
    }
}

